/*
 * Decompiled with CFR 0.152.
 */
package telsos.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class Bits {
    private static final double LN2 = Math.log(2.0);
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;

    private Bits() {
    }

    public static boolean getBoolean(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public static byte getByte(byte[] byArray, int n) {
        return byArray[n];
    }

    public static char getChar(byte[] byArray, int n) {
        return (char)((byArray[n + 1] & 0xFF) + (byArray[n + 0] << 8));
    }

    public static short getShort(byte[] byArray, int n) {
        return (short)((byArray[n + 1] & 0xFF) + (byArray[n + 0] << 8));
    }

    public static int getInt(byte[] byArray, int n) {
        return (byArray[n + 3] & 0xFF) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + (byArray[n + 0] << 24);
    }

    public static float getFloat(byte[] byArray, int n) {
        int n2 = (byArray[n + 3] & 0xFF) + ((byArray[n + 2] & 0xFF) << 8) + ((byArray[n + 1] & 0xFF) << 16) + (byArray[n + 0] << 24);
        return Float.intBitsToFloat(n2);
    }

    public static long getLong(byte[] byArray, int n) {
        return ((long)byArray[n + 7] & 0xFFL) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + ((long)byArray[n + 0] << 56);
    }

    public static long getUInt48(byte[] byArray, int n) {
        return ((long)byArray[n + 5] & 0xFFL) + (((long)byArray[n + 4] & 0xFFL) << 8) + (((long)byArray[n + 3] & 0xFFL) << 16) + (((long)byArray[n + 2] & 0xFFL) << 24) + (((long)byArray[n + 1] & 0xFFL) << 32) + (((long)byArray[n + 0] & 0xFFL) << 40);
    }

    public static double getDouble(byte[] byArray, int n) {
        long l = ((long)byArray[n + 7] & 0xFFL) + (((long)byArray[n + 6] & 0xFFL) << 8) + (((long)byArray[n + 5] & 0xFFL) << 16) + (((long)byArray[n + 4] & 0xFFL) << 24) + (((long)byArray[n + 3] & 0xFFL) << 32) + (((long)byArray[n + 2] & 0xFFL) << 40) + (((long)byArray[n + 1] & 0xFFL) << 48) + ((long)byArray[n + 0] << 56);
        return Double.longBitsToDouble(l);
    }

    public static BitSet bytesToBitSet(byte[] byArray) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < byArray.length * 8; ++i) {
            if ((byArray[byArray.length - i / 8 - 1] & 0xFF & 1 << i % 8) == 0) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public static void putBoolean(byte[] byArray, int n, boolean bl) {
        byArray[n] = (byte)(bl ? 1 : 0);
    }

    public static byte[] booleanToBytes(boolean bl) {
        byte[] byArray = new byte[1];
        Bits.putBoolean(byArray, 0, bl);
        return byArray;
    }

    public static void putByte(byte[] byArray, int n, byte by) {
        byArray[n] = by;
    }

    public static byte[] byteToBytes(byte by) {
        byte[] byArray = new byte[1];
        Bits.putByte(byArray, 0, by);
        return byArray;
    }

    public static void putChar(byte[] byArray, int n, char c) {
        byArray[n + 1] = (byte)(c >>> 0);
        byArray[n + 0] = (byte)(c >>> 8);
    }

    public static byte[] charToBytes(char c) {
        byte[] byArray = new byte[2];
        Bits.putChar(byArray, 0, c);
        return byArray;
    }

    public static void putShort(byte[] byArray, int n, short s) {
        byArray[n + 1] = (byte)(s >>> 0);
        byArray[n + 0] = (byte)(s >>> 8);
    }

    public static byte[] shortToBytes(short s) {
        byte[] byArray = new byte[2];
        Bits.putShort(byArray, 0, s);
        return byArray;
    }

    public static void putInt(byte[] byArray, int n, int n2) {
        byArray[n + 3] = (byte)(n2 >>> 0);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }

    public static byte[] intToBytes(int n) {
        byte[] byArray = new byte[4];
        Bits.putInt(byArray, 0, n);
        return byArray;
    }

    public static void putFloat(byte[] byArray, int n, float f) {
        int n2 = Float.floatToIntBits(f);
        byArray[n + 3] = (byte)(n2 >>> 0);
        byArray[n + 2] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)(n2 >>> 16);
        byArray[n + 0] = (byte)(n2 >>> 24);
    }

    public static byte[] floatToBytes(float f) {
        byte[] byArray = new byte[4];
        Bits.putFloat(byArray, 0, f);
        return byArray;
    }

    public static void putLong(byte[] byArray, int n, long l) {
        byArray[n + 7] = (byte)(l >>> 0);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }

    public static byte[] longToBytes(long l) {
        byte[] byArray = new byte[8];
        Bits.putLong(byArray, 0, l);
        return byArray;
    }

    public static void putUnsigned48(byte[] byArray, int n, long l) {
        byArray[n + 5] = (byte)(l >>> 0);
        byArray[n + 4] = (byte)(l >>> 8);
        byArray[n + 3] = (byte)(l >>> 16);
        byArray[n + 2] = (byte)(l >>> 24);
        byArray[n + 1] = (byte)(l >>> 32);
        byArray[n + 0] = (byte)(l >>> 40);
    }

    public static byte[] unsigned48ToBytes(long l) {
        byte[] byArray = new byte[6];
        Bits.putUnsigned48(byArray, 0, l);
        return byArray;
    }

    public static void putDouble(byte[] byArray, int n, double d) {
        long l = Double.doubleToLongBits(d);
        byArray[n + 7] = (byte)(l >>> 0);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 0] = (byte)(l >>> 56);
    }

    public static byte[] doubleToBytes(double d) {
        byte[] byArray = new byte[8];
        Bits.putDouble(byArray, 0, d);
        return byArray;
    }

    public static byte[] bitSetToBytes(BitSet bitSet) {
        byte[] byArray = new byte[bitSet.length() / 8 + 1];
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            int n = byArray.length - i / 8 - 1;
            byArray[n] = (byte)(byArray[n] | 1 << i % 8);
        }
        return byArray;
    }

    public static int bitLength(long l) {
        l = l < 0L ? -l : l + 1L;
        double d = Math.log(l) / LN2;
        return (int)Math.ceil(d);
    }

    public static List<Long> longBits(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative argument " + l);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(Bits.bitLength(l));
        if (l == 0L) {
            arrayList.add(ZERO);
            return arrayList;
        }
        while (l != 0L) {
            if (l % 2L == 0L) {
                arrayList.add(ZERO);
            } else {
                arrayList.add(ONE);
            }
            l >>= 1;
        }
        return arrayList;
    }

    public static byte[] stringToBytesUTF(String string, int n) {
        int n2 = string.length() - n;
        byte[] byArray = new byte[n2 << 1];
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i + n);
            int n3 = i << 1;
            byArray[n3] = (byte)((c & 0xFF00) >> 8);
            byArray[n3 + 1] = (byte)(c & 0xFF);
        }
        return byArray;
    }

    public static String bytesToStringUTF(byte[] byArray) {
        char[] cArray = new char[byArray.length >> 1];
        for (int i = 0; i < cArray.length; ++i) {
            char c;
            int n = i << 1;
            cArray[i] = c = (char)(((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF));
        }
        return String.valueOf(cArray);
    }

    public static long[] bytesToLongsArray(byte[] byArray) {
        if (byArray.length % 8 != 0) {
            throw new IllegalArgumentException("The length of byte array must be a multiple of 8.");
        }
        long[] lArray = new long[byArray.length / 8];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = Bits.getLong(byArray, i * 8);
        }
        return lArray;
    }

    public static List<Long> bytesToLongsList(byte[] byArray) {
        if (byArray.length % 8 != 0) {
            throw new IllegalArgumentException("The length of byte array must be a multiple of 8.");
        }
        int n = byArray.length / 8;
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(Bits.getLong(byArray, i * 8));
        }
        return arrayList;
    }

    public static byte[] longsArrayToBytes(long[] lArray) {
        byte[] byArray = new byte[lArray.length * 8];
        for (int i = 0; i < lArray.length; ++i) {
            Bits.putLong(byArray, i * 8, lArray[i]);
        }
        return byArray;
    }

    public static byte[] bigDecimalToBytes(BigDecimal bigDecimal) {
        byte[] byArray = bigDecimal.unscaledValue().toByteArray();
        byte[] byArray2 = new byte[4 + byArray.length];
        Bits.putInt(byArray2, 0, bigDecimal.scale());
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        return byArray2;
    }

    public static BigDecimal bytesToBigDecimal(byte[] byArray) {
        int n = Bits.getInt(byArray, 0);
        int n2 = byArray.length - 4;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 4, byArray2, 0, n2);
        return new BigDecimal(new BigInteger(byArray2), n);
    }

    public static long[] makeLongs(int n) {
        return new long[n];
    }

    public static Object[] makeObjects(int n) {
        return new Object[n];
    }
}

