(ns telsos.lib.clojure)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn ns? [x]
  (instance? clojure.lang.Namespace x))

(defn RT-var
  (^clojure.lang.Var
    [ns- name-]
    (clojure.lang.RT/var ns- name-))

  (^clojure.lang.Var
    [ns- name- file]
    (let [v1 (RT-var ns- name-)]
      (if-not (instance? clojure.lang.Var$Unbound @v1)
        v1

        (do (load-file file) (RT-var ns- name-))))))

(defn named?
  [x]
  (or (string? x) (instance? clojure.lang.Named x)))

(defn maybe-name [x] (when (named? x) (name x)))

(defn false->nil [x] (if-not x nil x))
