(ns telsos.lib.strings
  (:refer-clojure :exclude [parse-long])
  (:import
   (org.apache.commons.validator.routines EmailValidator)
   (telsos.lib Numbers)))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn non-blank?
  [s]
  (and (string? s) (not (.isBlank ^String s))))

(defn email?
  ([s]
   (and (string? s)
        (.isValid (EmailValidator/getInstance) s)))

  ([allow-local? allow-tld? s]
   (and (string? s)
        (.isValid (EmailValidator/getInstance allow-local? allow-tld?) s))))

(def Email
  [:fn {:error/message "should be a valid email"} email?])

(defn named?
  [x]
  (or (string? x) (keyword? x) (symbol? x)))

(def Named
  [:fn {:error/message "should be named"} named?])

(defn indent-string
  ([length]
   (indent-string length " "))

  ([length with]
   (str (.repeat (str with) (long length)))))

(defn indent-to-length
  ([s ^long length]
   (indent-to-length s length " "))

  ([s ^long length with]
   (let [s    (str s)
         diff (- length (.length s))]
     (if (pos? diff)
       (str (indent-string diff with) s)
       s))))

(defn ->opt-long
  ^Long [s]
  (Numbers/parseLong s))
