(ns telsos.lib.binding)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(deftype ^:private Scoped [^java.lang.ScopedValue scoped-value default-value]
  Object
  (toString [this] (str (deref this)))

  clojure.lang.IDeref
  (deref [_] (.orElse scoped-value default-value)))

(defn create-scoped
  ([]
   (create-scoped #_default-value nil))

  ([default-value]
   (Scoped. (java.lang.ScopedValue/newInstance) default-value)))

(defn scoped*
  [^Scoped scoped value body]
  (.call (java.lang.ScopedValue/where (.scoped-value scoped) value) body))

(defmacro scoped {:style/indent 1}
  [[scoped- value] & body]
  `(scoped* ~scoped- ~value (fn [& ~'_] ~@body)))
