/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graph.Vertex;
import com.brunomnsilva.smartgraph.graphview.ShapeFactory;
import com.brunomnsilva.smartgraph.graphview.ShapeWithRadius;
import com.brunomnsilva.smartgraph.graphview.SmartGraphVertex;
import com.brunomnsilva.smartgraph.graphview.SmartLabel;
import com.brunomnsilva.smartgraph.graphview.SmartLabelledNode;
import com.brunomnsilva.smartgraph.graphview.SmartStylableNode;
import com.brunomnsilva.smartgraph.graphview.SmartStyleProxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Group;

public class SmartGraphVertexNode<T>
extends Group
implements SmartGraphVertex<T>,
SmartLabelledNode {
    private final Vertex<T> underlyingVertex;
    private boolean isDragging;
    private boolean allowMove;
    private final Set<SmartGraphVertexNode<T>> adjacentVertices;
    private final PointVector forceVector = new PointVector(0.0, 0.0);
    private final PointVector updatedPosition = new PointVector(0.0, 0.0);
    private final DoubleProperty centerX;
    private final DoubleProperty centerY;
    private final DoubleProperty radius;
    private final SmartStyleProxy styleProxy;
    private SmartLabel attachedLabel;
    private ShapeWithRadius<?> shapeProxy;
    private String shapeProxyName;

    public SmartGraphVertexNode(Vertex<T> v, double x, double y, double radius, String shapeType, boolean allowMove) {
        this.underlyingVertex = v;
        this.adjacentVertices = new HashSet<SmartGraphVertexNode<T>>();
        this.attachedLabel = null;
        this.isDragging = false;
        this.centerX = new SimpleDoubleProperty();
        this.centerY = new SimpleDoubleProperty();
        this.radius = new SimpleDoubleProperty();
        this.shapeProxy = ShapeFactory.create(shapeType, x, y, radius);
        this.shapeProxyName = shapeType;
        this.bindShapeProperties(this.shapeProxy);
        this.getChildren().add((Object)this.shapeProxy.getShape());
        this.styleProxy = new SmartStyleProxy(this.shapeProxy.getShape());
        this.styleProxy.addStyleClass("vertex");
        this.allowMove = allowMove;
        if (allowMove) {
            this.enableDrag();
        }
    }

    public double getCenterX() {
        return this.centerX.doubleValue();
    }

    public void setCenterX(double x) {
        this.centerX.set(x);
    }

    public double getCenterY() {
        return this.centerY.doubleValue();
    }

    public void setCenterY(double y) {
        this.centerY.set(y);
    }

    public DoubleProperty centerXProperty() {
        return this.centerX;
    }

    public DoubleProperty centerYProperty() {
        return this.centerY;
    }

    public ReadOnlyDoubleProperty radiusProperty() {
        return this.radius;
    }

    @Override
    public double getRadius() {
        return this.radius.doubleValue();
    }

    public void setRadius(double radius) {
        if (Double.compare(this.getRadius(), radius) != 0) {
            this.radius.set(radius);
        }
    }

    public void setShapeType(String shapeType) {
        if (this.shapeProxyName.compareToIgnoreCase(shapeType) == 0) {
            return;
        }
        ShapeWithRadius<?> newShapeProxy = ShapeFactory.create(shapeType, this.getCenterX(), this.getCenterY(), this.getRadius());
        SmartStyleProxy.copyStyling(this.shapeProxy.getShape(), newShapeProxy.getShape());
        this.styleProxy.setClient(newShapeProxy.getShape());
        this.shapeProxy = newShapeProxy;
        this.shapeProxyName = shapeType;
        this.bindShapeProperties(newShapeProxy);
        this.getChildren().clear();
        this.getChildren().add((Object)newShapeProxy.getShape());
    }

    public void addAdjacentVertex(SmartGraphVertexNode<T> v) {
        this.adjacentVertices.add(v);
    }

    public boolean removeAdjacentVertex(SmartGraphVertexNode<T> v) {
        return this.adjacentVertices.remove(v);
    }

    public boolean removeAdjacentVertices(Collection<SmartGraphVertexNode<T>> col) {
        return this.adjacentVertices.removeAll(col);
    }

    public boolean isAdjacentTo(SmartGraphVertexNode<T> v) {
        return this.adjacentVertices.contains(v);
    }

    public int neighborhoodSize() {
        return this.adjacentVertices.size();
    }

    public Point2D getPosition() {
        return new Point2D(this.getCenterX(), this.getCenterY());
    }

    public void setPosition(Point2D p) {
        this.setPosition(p.getX(), p.getY());
    }

    @Override
    public void setPosition(double x, double y) {
        if (this.isDragging) {
            return;
        }
        this.setCenterX(x);
        this.setCenterY(y);
    }

    @Override
    public double getPositionCenterX() {
        return this.getCenterX();
    }

    @Override
    public double getPositionCenterY() {
        return this.getCenterY();
    }

    public void resetForces() {
        this.forceVector.y = 0.0;
        this.forceVector.x = 0.0;
        this.updatedPosition.x = this.getCenterX();
        this.updatedPosition.y = this.getCenterY();
    }

    public void addForceVector(double x, double y) {
        this.forceVector.x += x;
        this.forceVector.y += y;
    }

    public Point2D getForceVector() {
        return new Point2D(this.forceVector.x, this.forceVector.y);
    }

    public Point2D getUpdatedPosition() {
        return new Point2D(this.updatedPosition.x, this.updatedPosition.y);
    }

    public void updateDelta() {
        this.updatedPosition.x += this.forceVector.x;
        this.updatedPosition.y += this.forceVector.y;
    }

    public void moveFromForces() {
        double height = this.getParent().getLayoutBounds().getHeight();
        double width = this.getParent().getLayoutBounds().getWidth();
        this.updatedPosition.x = this.boundVertexNodeXPositioning(this.updatedPosition.x, 0.0, width);
        this.updatedPosition.y = this.boundVertexNodeYPositioning(this.updatedPosition.y, 0.0, height);
        this.setPosition(this.updatedPosition.x, this.updatedPosition.y);
    }

    @Override
    public void attachLabel(SmartLabel label) {
        this.attachedLabel = label;
        label.xProperty().bind((ObservableValue)this.centerXProperty().subtract((ObservableNumberValue)Bindings.divide((ObservableNumberValue)label.layoutWidthProperty(), (double)2.0)));
        label.yProperty().bind((ObservableValue)this.centerYProperty().add((ObservableNumberValue)Bindings.add((ObservableNumberValue)this.shapeProxy.radiusProperty(), (ObservableNumberValue)label.layoutHeightProperty())));
    }

    @Override
    public SmartLabel getAttachedLabel() {
        return this.attachedLabel;
    }

    @Override
    public Vertex<T> getUnderlyingVertex() {
        return this.underlyingVertex;
    }

    @Override
    public void setStyleInline(String css) {
        this.styleProxy.setStyleInline(css);
    }

    @Override
    public void setStyleClass(String cssClass) {
        this.styleProxy.setStyleClass(cssClass);
    }

    @Override
    public void addStyleClass(String cssClass) {
        this.styleProxy.addStyleClass(cssClass);
    }

    @Override
    public boolean removeStyleClass(String cssClass) {
        return this.styleProxy.removeStyleClass(cssClass);
    }

    @Override
    public SmartStylableNode getStylableLabel() {
        return this.attachedLabel;
    }

    private void enableDrag() {
        PointVector dragDelta = new PointVector(0.0, 0.0);
        this.setOnMousePressed(mouseEvent -> {
            if (mouseEvent.isPrimaryButtonDown()) {
                pointVector.x = this.getCenterX() - mouseEvent.getX();
                pointVector.y = this.getCenterY() - mouseEvent.getY();
                this.isDragging = true;
                mouseEvent.consume();
            }
        });
        this.setOnMouseReleased(mouseEvent -> {
            if (this.allowMove) {
                this.setCursor(Cursor.HAND);
            }
            this.isDragging = false;
            mouseEvent.consume();
        });
        this.setOnMouseDragged(mouseEvent -> {
            if (mouseEvent.isPrimaryButtonDown()) {
                if (this.allowMove && this.getCursor() != Cursor.MOVE) {
                    this.setCursor(Cursor.MOVE);
                }
                double newX = mouseEvent.getX() + pointVector.x;
                double x = this.boundVertexNodeXPositioning(newX, 0.0, this.getParent().getLayoutBounds().getWidth());
                this.setCenterX(x);
                double newY = mouseEvent.getY() + pointVector.y;
                double y = this.boundVertexNodeYPositioning(newY, 0.0, this.getParent().getLayoutBounds().getHeight());
                this.setCenterY(y);
                mouseEvent.consume();
            }
        });
        this.setOnMouseEntered(mouseEvent -> {
            if (this.allowMove && !mouseEvent.isPrimaryButtonDown()) {
                this.setCursor(Cursor.HAND);
            }
        });
        this.setOnMouseExited(mouseEvent -> {
            if (this.allowMove && !mouseEvent.isPrimaryButtonDown()) {
                this.setCursor(Cursor.DEFAULT);
            }
        });
    }

    private double boundVertexNodeXPositioning(double xCoord, double minCoordValue, double maxCoordValue) {
        double lengthToSide = Math.max(this.getRadius(), this.attachedLabel != null ? this.attachedLabel.layoutWidthProperty().get() / 2.0 : 0.0);
        if (xCoord < minCoordValue + lengthToSide) {
            return minCoordValue + lengthToSide;
        }
        if (xCoord > maxCoordValue - lengthToSide) {
            return maxCoordValue - lengthToSide;
        }
        return xCoord;
    }

    private double boundVertexNodeYPositioning(double yCoord, double minCoordValue, double maxCoordValue) {
        double lengthToTop = this.getRadius();
        double lengthToBottom = this.getRadius() + (this.attachedLabel != null ? this.attachedLabel.layoutHeightProperty().get() : 0.0);
        if (yCoord < minCoordValue + lengthToTop) {
            return minCoordValue + lengthToTop;
        }
        if (yCoord > maxCoordValue - lengthToBottom) {
            return maxCoordValue - lengthToBottom;
        }
        return yCoord;
    }

    private void bindShapeProperties(ShapeWithRadius<?> shape) {
        if (this.shapeProxy != null && this.centerX.isBound()) {
            this.centerX.unbindBidirectional((Property)this.shapeProxy.centerXProperty());
        }
        if (this.shapeProxy != null && this.centerY.isBound()) {
            this.centerY.unbindBidirectional((Property)this.shapeProxy.centerYProperty());
        }
        if (this.shapeProxy != null && this.radius.isBound()) {
            this.radius.unbindBidirectional((Property)this.shapeProxy.radiusProperty());
        }
        this.centerX.bindBidirectional((Property)shape.centerXProperty());
        this.centerY.bindBidirectional((Property)shape.centerYProperty());
        this.radius.bindBidirectional((Property)shape.radiusProperty());
    }

    private static class PointVector {
        double x;
        double y;

        public PointVector(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

