/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graph.Digraph;
import com.brunomnsilva.smartgraph.graph.Edge;
import com.brunomnsilva.smartgraph.graph.Graph;
import com.brunomnsilva.smartgraph.graph.Vertex;
import com.brunomnsilva.smartgraph.graphview.Args;
import com.brunomnsilva.smartgraph.graphview.ForceDirectedLayoutStrategy;
import com.brunomnsilva.smartgraph.graphview.ForceDirectedSpringGravityLayoutStrategy;
import com.brunomnsilva.smartgraph.graphview.SmartArrow;
import com.brunomnsilva.smartgraph.graphview.SmartCircularSortedPlacementStrategy;
import com.brunomnsilva.smartgraph.graphview.SmartGraphEdge;
import com.brunomnsilva.smartgraph.graphview.SmartGraphEdgeBase;
import com.brunomnsilva.smartgraph.graphview.SmartGraphEdgeCurve;
import com.brunomnsilva.smartgraph.graphview.SmartGraphEdgeLine;
import com.brunomnsilva.smartgraph.graphview.SmartGraphProperties;
import com.brunomnsilva.smartgraph.graphview.SmartGraphVertex;
import com.brunomnsilva.smartgraph.graphview.SmartGraphVertexNode;
import com.brunomnsilva.smartgraph.graphview.SmartLabel;
import com.brunomnsilva.smartgraph.graphview.SmartLabelProvider;
import com.brunomnsilva.smartgraph.graphview.SmartLabelSource;
import com.brunomnsilva.smartgraph.graphview.SmartPlacementStrategy;
import com.brunomnsilva.smartgraph.graphview.SmartRadiusProvider;
import com.brunomnsilva.smartgraph.graphview.SmartRadiusSource;
import com.brunomnsilva.smartgraph.graphview.SmartShapeTypeProvider;
import com.brunomnsilva.smartgraph.graphview.SmartShapeTypeSource;
import com.brunomnsilva.smartgraph.graphview.SmartStylableNode;
import com.brunomnsilva.smartgraph.graphview.UtilitiesJavaFX;
import com.brunomnsilva.smartgraph.graphview.UtilitiesPoint2D;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;

public class SmartGraphPanel<V, E>
extends Pane {
    private final SmartGraphProperties graphProperties;
    private static final String DEFAULT_CSS_FILE = "smartgraph.css";
    private final Graph<V, E> theGraph;
    private final SmartPlacementStrategy placementStrategy;
    private final Map<Vertex<V>, SmartGraphVertexNode<V>> vertexNodes;
    private final Map<Edge<E, V>, SmartGraphEdgeBase<E, V>> edgeNodes;
    private final Map<Edge<E, V>, Tuple<Vertex<V>>> connections;
    private final Map<Tuple<SmartGraphVertexNode<V>>, Integer> placedEdges = new HashMap<Tuple<SmartGraphVertexNode<V>>, Integer>();
    private boolean initialized = false;
    private final boolean edgesWithArrows;
    private Consumer<SmartGraphVertex<V>> vertexClickConsumer;
    private Consumer<SmartGraphEdge<E, V>> edgeClickConsumer;
    private SmartLabelProvider<V> vertexLabelProvider;
    private SmartLabelProvider<E> edgeLabelProvider;
    private SmartRadiusProvider<V> vertexRadiusProvider;
    private SmartShapeTypeProvider<V> vertexShapeTypeProvider;
    public final BooleanProperty automaticLayoutProperty;
    private final AnimationTimer timer;
    private ForceDirectedLayoutStrategy<V> automaticLayoutStrategy;
    private static final int AUTOMATIC_LAYOUT_ITERATIONS = 20;

    public SmartGraphPanel(@NamedArg(value="graph") Graph<V, E> theGraph, @NamedArg(value="properties") SmartGraphProperties properties, @NamedArg(value="placementStrategy") SmartPlacementStrategy placementStrategy, @NamedArg(value="cssFileURI") URI cssFile, @NamedArg(value="automaticLayoutStrategy") ForceDirectedLayoutStrategy<V> layoutStrategy) {
        Args.requireNotNull(theGraph, "theGraph");
        Args.requireNotNull(properties, "properties");
        Args.requireNotNull(placementStrategy, "placementStrategy");
        Args.requireNotNull(cssFile, "cssFile");
        Args.requireNotNull(layoutStrategy, "layoutStrategy");
        this.theGraph = theGraph;
        this.graphProperties = properties;
        this.placementStrategy = placementStrategy;
        this.edgesWithArrows = this.graphProperties.getUseEdgeArrow();
        this.automaticLayoutStrategy = layoutStrategy;
        this.vertexNodes = new HashMap<Vertex<V>, SmartGraphVertexNode<V>>();
        this.edgeNodes = new HashMap<Edge<E, V>, SmartGraphEdgeBase<E, V>>();
        this.connections = new HashMap<Edge<E, V>, Tuple<Vertex<V>>>();
        this.vertexClickConsumer = null;
        this.edgeClickConsumer = null;
        this.loadAndApplyStylesheet(cssFile);
        this.initNodes();
        this.enableDoubleClickListener();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                SmartGraphPanel.this.runAutomaticLayout();
            }
        };
        this.automaticLayoutProperty = new SimpleBooleanProperty(false);
        this.automaticLayoutProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.timer.start();
            } else {
                this.timer.stop();
            }
        });
    }

    public SmartGraphPanel(Graph<V, E> theGraph) {
        this(theGraph, new SmartGraphProperties(), new SmartCircularSortedPlacementStrategy(), new File(DEFAULT_CSS_FILE).toURI(), new ForceDirectedSpringGravityLayoutStrategy());
    }

    public SmartGraphPanel(Graph<V, E> theGraph, ForceDirectedLayoutStrategy<V> layoutStrategy) {
        this(theGraph, new SmartGraphProperties(), new SmartCircularSortedPlacementStrategy(), new File(DEFAULT_CSS_FILE).toURI(), layoutStrategy);
    }

    public SmartGraphPanel(Graph<V, E> theGraph, SmartGraphProperties properties) {
        this(theGraph, properties, new SmartCircularSortedPlacementStrategy(), new File(DEFAULT_CSS_FILE).toURI(), new ForceDirectedSpringGravityLayoutStrategy());
    }

    public SmartGraphPanel(Graph<V, E> theGraph, SmartPlacementStrategy placementStrategy, ForceDirectedLayoutStrategy<V> layoutStrategy) {
        this(theGraph, new SmartGraphProperties(), placementStrategy, new File(DEFAULT_CSS_FILE).toURI(), layoutStrategy);
    }

    public SmartGraphPanel(Graph<V, E> theGraph, SmartPlacementStrategy placementStrategy) {
        this(theGraph, new SmartGraphProperties(), placementStrategy, new File(DEFAULT_CSS_FILE).toURI(), new ForceDirectedSpringGravityLayoutStrategy());
    }

    public SmartGraphPanel(Graph<V, E> theGraph, SmartGraphProperties properties, SmartPlacementStrategy placementStrategy) {
        this(theGraph, properties, placementStrategy, new File(DEFAULT_CSS_FILE).toURI(), new ForceDirectedSpringGravityLayoutStrategy());
    }

    public SmartGraphPanel(Graph<V, E> theGraph, SmartGraphProperties properties, SmartPlacementStrategy placementStrategy, URI cssFile) {
        this(theGraph, properties, placementStrategy, cssFile, new ForceDirectedSpringGravityLayoutStrategy());
    }

    private synchronized void runAutomaticLayout() {
        int i = 0;
        while (i < 20) {
            this.resetForces();
            this.computeForces();
            this.updateForces();
            ++i;
        }
        this.applyForces();
    }

    public void init() throws IllegalStateException {
        if (this.getScene() == null) {
            throw new IllegalStateException("You must call this method after the instance was added to a scene.");
        }
        if (this.getWidth() == 0.0 || this.getHeight() == 0.0) {
            throw new IllegalStateException("The layout for this panel has zero width and/or height");
        }
        if (this.initialized) {
            throw new IllegalStateException("Already initialized. Use update() method instead.");
        }
        if (this.placementStrategy != null) {
            this.placementStrategy.place(this.widthProperty().doubleValue(), this.heightProperty().doubleValue(), this);
        } else {
            new SmartCircularSortedPlacementStrategy().place(this.widthProperty().doubleValue(), this.heightProperty().doubleValue(), this);
            this.timer.start();
        }
        this.initialized = true;
    }

    public BooleanProperty automaticLayoutProperty() {
        return this.automaticLayoutProperty;
    }

    public void setAutomaticLayout(boolean value) {
        this.automaticLayoutProperty.set(value);
    }

    public void setAutomaticLayoutStrategy(ForceDirectedLayoutStrategy<V> strategy) {
        Args.requireNotNull(strategy, "strategy");
        this.automaticLayoutStrategy = strategy;
    }

    public Graph<V, E> getModel() {
        return this.theGraph;
    }

    public final Collection<SmartGraphVertex<V>> getSmartVertices() {
        return new ArrayList<SmartGraphVertex<V>>(this.vertexNodes.values());
    }

    public final Collection<SmartGraphEdge<E, V>> getSmartEdges() {
        return new ArrayList<SmartGraphEdge<E, V>>(this.edgeNodes.values());
    }

    public void update() {
        if (this.getScene() == null) {
            throw new IllegalStateException("You must call this method after the instance was added to a scene.");
        }
        if (!this.initialized) {
            throw new IllegalStateException("You must call init() method before any updates.");
        }
        Platform.runLater(() -> this.updateViewModel());
    }

    public void updateAndWait() {
        if (this.getScene() == null) {
            throw new IllegalStateException("You must call this method after the instance was added to a scene.");
        }
        if (!this.initialized) {
            throw new IllegalStateException("You must call init() method before any updates.");
        }
        FutureTask<Boolean> update = new FutureTask<Boolean>(() -> {
            this.updateViewModel();
            return true;
        });
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(update);
            try {
                update.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                Logger.getLogger(SmartGraphPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.updateViewModel();
        }
    }

    private synchronized void updateViewModel() {
        this.removeNodes();
        this.insertNodes();
        this.updateNodes();
    }

    public void setVertexDoubleClickAction(Consumer<SmartGraphVertex<V>> action) {
        this.vertexClickConsumer = action;
    }

    public void setEdgeDoubleClickAction(Consumer<SmartGraphEdge<E, V>> action) {
        this.edgeClickConsumer = action;
    }

    public void setVertexLabelProvider(SmartLabelProvider<V> labelProvider) {
        this.vertexLabelProvider = labelProvider;
    }

    public void setEdgeLabelProvider(SmartLabelProvider<E> labelProvider) {
        this.edgeLabelProvider = labelProvider;
    }

    public void setVertexRadiusProvider(SmartRadiusProvider<V> vertexRadiusProvider) {
        this.vertexRadiusProvider = vertexRadiusProvider;
    }

    public void setVertexShapeTypeProvider(SmartShapeTypeProvider<V> vertexShapeTypeProvider) {
        this.vertexShapeTypeProvider = vertexShapeTypeProvider;
    }

    private void initNodes() {
        for (Vertex<V> vertex : this.listOfVertices()) {
            SmartGraphVertexNode<V> vertexAnchor = this.createVertex(vertex, 0.0, 0.0);
            this.vertexNodes.put(vertex, vertexAnchor);
        }
        List<Edge<E, V>> edgesToPlace = this.listOfEdges();
        for (Vertex<V> vertex : this.vertexNodes.keySet()) {
            Collection<Edge<E, V>> incidentEdges = this.theGraph.incidentEdges(vertex);
            for (Edge edge : incidentEdges) {
                if (!edgesToPlace.contains(edge)) continue;
                Vertex<V> oppositeVertex = this.theGraph.opposite(vertex, edge);
                SmartGraphVertexNode<V> graphVertexIn = this.vertexNodes.get(vertex);
                SmartGraphVertexNode<V> graphVertexOppositeOut = this.vertexNodes.get(oppositeVertex);
                graphVertexIn.addAdjacentVertex(graphVertexOppositeOut);
                graphVertexOppositeOut.addAdjacentVertex(graphVertexIn);
                SmartGraphEdgeBase<E, V> graphEdge = this.createEdge(edge, graphVertexIn, graphVertexOppositeOut);
                this.connections.put(edge, new Tuple<Vertex<V>>(vertex, oppositeVertex));
                this.addEdge(graphEdge, edge);
                if (this.edgesWithArrows && this.theGraph instanceof Digraph) {
                    SmartArrow arrow = new SmartArrow(this.graphProperties.getEdgeArrowSize());
                    graphEdge.attachArrow(arrow);
                    this.getChildren().add((Object)arrow);
                }
                edgesToPlace.remove(edge);
            }
        }
        for (Vertex<V> vertex : this.vertexNodes.keySet()) {
            SmartGraphVertexNode<V> v = this.vertexNodes.get(vertex);
            this.addVertex(v);
        }
    }

    private SmartGraphVertexNode<V> createVertex(Vertex<V> v, double x, double y) {
        String shapeType = this.getVertexShapeTypeFor(v.element());
        double shapeRadius = this.getVertexShapeRadiusFor(v.element());
        return new SmartGraphVertexNode<V>(v, x, y, shapeRadius, shapeType, this.graphProperties.getVertexAllowUserMove());
    }

    private SmartGraphEdgeBase<E, V> createEdge(Edge<E, V> edge, SmartGraphVertexNode<V> graphVertexInbound, SmartGraphVertexNode<V> graphVertexOutbound) {
        int edgeIndex = 0;
        Integer counter = this.placedEdges.get(new Tuple<SmartGraphVertexNode<V>>(graphVertexInbound, graphVertexOutbound));
        if (counter != null) {
            edgeIndex = counter;
        }
        SmartGraphEdgeBase<E, V> graphEdge = this.getTotalEdgesBetween(graphVertexInbound.getUnderlyingVertex(), graphVertexOutbound.getUnderlyingVertex()) > 1 || graphVertexInbound == graphVertexOutbound ? new SmartGraphEdgeCurve<E, V>(edge, graphVertexInbound, graphVertexOutbound, edgeIndex) : new SmartGraphEdgeLine<E, V>(edge, graphVertexInbound, graphVertexOutbound);
        this.placedEdges.put(new Tuple<SmartGraphVertexNode<V>>(graphVertexInbound, graphVertexOutbound), ++edgeIndex);
        return graphEdge;
    }

    private void addVertex(SmartGraphVertexNode<V> v) {
        this.getChildren().add(v);
        String labelText = this.getVertexLabelFor(v.getUnderlyingVertex().element());
        if (this.graphProperties.getUseVertexTooltip()) {
            Tooltip t = new Tooltip(labelText);
            Tooltip.install(v, (Tooltip)t);
        }
        if (this.graphProperties.getUseVertexLabel()) {
            SmartLabel label = new SmartLabel(labelText);
            label.addStyleClass("vertex-label");
            this.getChildren().add((Object)label);
            v.attachLabel(label);
        }
    }

    private void addEdge(SmartGraphEdgeBase<E, V> e, Edge<E, V> edge) {
        this.getChildren().add(0, (Object)((Node)e));
        this.edgeNodes.put(edge, e);
        String labelText = this.getEdgeLabelFor(edge.element());
        if (this.graphProperties.getUseEdgeTooltip()) {
            Tooltip t = new Tooltip(labelText);
            Tooltip.install((Node)((Node)e), (Tooltip)t);
        }
        if (this.graphProperties.getUseEdgeLabel()) {
            SmartLabel label = new SmartLabel(labelText);
            label.addStyleClass("edge-label");
            this.getChildren().add((Object)label);
            e.attachLabel(label);
        }
    }

    private void insertNodes() {
        Collection<Edge<E, V>> unplottedEdges;
        Collection<Vertex<V>> unplottedVertices = this.unplottedVertices();
        LinkedList<SmartGraphVertexNode<V>> newVertices = null;
        Bounds bounds = this.getPlotBounds();
        double mx = bounds.getMinX() + bounds.getWidth() / 2.0;
        double my = bounds.getMinY() + bounds.getHeight() / 2.0;
        if (!unplottedVertices.isEmpty()) {
            newVertices = new LinkedList<SmartGraphVertexNode<V>>();
            for (Vertex<V> vertex : unplottedVertices) {
                double y;
                double x;
                Collection<Edge<E, V>> incidentEdges = this.theGraph.incidentEdges(vertex);
                if (incidentEdges.isEmpty()) {
                    x = mx;
                    y = my;
                } else {
                    Edge<E, V> firstEdge = incidentEdges.iterator().next();
                    Vertex<V> opposite = this.theGraph.opposite(vertex, firstEdge);
                    SmartGraphVertexNode<V> existing = this.vertexNodes.get(opposite);
                    if (existing == null) {
                        x = mx;
                        y = my;
                    } else {
                        Point2D p = UtilitiesPoint2D.rotate(existing.getPosition().add(50.0, 50.0), existing.getPosition(), Math.random() * 360.0);
                        x = SmartGraphPanel.clamp(p.getX(), 0.0, this.getWidth());
                        y = SmartGraphPanel.clamp(p.getY(), 0.0, this.getHeight());
                    }
                }
                SmartGraphVertexNode<V> newVertex = this.createVertex(vertex, x, y);
                newVertices.add(newVertex);
                this.vertexNodes.put(vertex, newVertex);
            }
        }
        if (!(unplottedEdges = this.unplottedEdges()).isEmpty()) {
            for (Edge<E, V> edge : unplottedEdges) {
                Vertex<V>[] vertices = edge.vertices();
                Vertex<V> u = vertices[0];
                Vertex<V> v = vertices[1];
                SmartGraphVertexNode<V> graphVertexOut = this.vertexNodes.get(u);
                SmartGraphVertexNode<V> graphVertexIn = this.vertexNodes.get(v);
                if (graphVertexIn == null || graphVertexOut == null) continue;
                graphVertexOut.addAdjacentVertex(graphVertexIn);
                graphVertexIn.addAdjacentVertex(graphVertexOut);
                SmartGraphEdgeBase<E, V> graphEdge = this.createEdge(edge, graphVertexIn, graphVertexOut);
                if (this.edgesWithArrows && this.theGraph instanceof Digraph) {
                    SmartArrow arrow = new SmartArrow(this.graphProperties.getEdgeArrowSize());
                    graphEdge.attachArrow(arrow);
                    this.getChildren().add((Object)arrow);
                }
                this.connections.put(edge, new Tuple<Vertex<V>>(u, v));
                this.addEdge(graphEdge, edge);
            }
        }
        if (newVertices != null) {
            for (SmartGraphVertexNode smartGraphVertexNode : newVertices) {
                this.addVertex(smartGraphVertexNode);
            }
        }
    }

    private void removeNodes() {
        Collection<Edge<E, V>> removedEdges = this.removedEdges();
        for (Edge<E, V> e : removedEdges) {
            SmartGraphEdgeBase<E, V> edgeToRemove = this.edgeNodes.get(e);
            this.edgeNodes.remove(e);
            this.removeEdge(edgeToRemove);
            Tuple<Vertex<V>> vertexTuple = this.connections.get(e);
            if (this.getTotalEdgesBetween((Vertex)((Tuple)vertexTuple).first, (Vertex)((Tuple)vertexTuple).second) == 0) {
                SmartGraphVertexNode<V> v0 = this.vertexNodes.get(((Tuple)vertexTuple).first);
                SmartGraphVertexNode<V> v1 = this.vertexNodes.get(((Tuple)vertexTuple).second);
                v0.removeAdjacentVertex(v1);
                v1.removeAdjacentVertex(v0);
            }
            this.connections.remove(e);
        }
        Collection<Vertex<V>> removedVertices = this.removedVertices();
        for (Vertex<V> removedVertex : removedVertices) {
            SmartGraphVertexNode<V> removed = this.vertexNodes.remove(removedVertex);
            this.removeVertex(removed);
        }
    }

    private void removeEdge(SmartGraphEdgeBase<E, V> e) {
        SmartLabel attachedLabel;
        this.getChildren().remove((Object)((Node)e));
        SmartArrow attachedArrow = e.getAttachedArrow();
        if (attachedArrow != null) {
            this.getChildren().remove((Object)attachedArrow);
        }
        if ((attachedLabel = e.getAttachedLabel()) != null) {
            this.getChildren().remove((Object)attachedLabel);
        }
    }

    private void removeVertex(SmartGraphVertexNode<V> v) {
        this.getChildren().remove(v);
        SmartLabel attachedLabel = v.getAttachedLabel();
        if (attachedLabel != null) {
            this.getChildren().remove((Object)attachedLabel);
        }
    }

    private void updateNodes() {
        this.theGraph.vertices().forEach(v -> {
            SmartGraphVertexNode<V> vertexNode = this.vertexNodes.get(v);
            if (vertexNode != null) {
                SmartLabel label = vertexNode.getAttachedLabel();
                if (label != null) {
                    String text = this.getVertexLabelFor(v.element());
                    label.setText_(text);
                }
                double radius = this.getVertexShapeRadiusFor(v.element());
                vertexNode.setRadius(radius);
                String shapeType = this.getVertexShapeTypeFor(v.element());
                vertexNode.setShapeType(shapeType);
            }
        });
        this.theGraph.edges().forEach(e -> {
            SmartLabel label;
            SmartGraphEdgeBase<E, V> edgeNode = this.edgeNodes.get(e);
            if (edgeNode != null && (label = edgeNode.getAttachedLabel()) != null) {
                String text = this.getEdgeLabelFor(e.element());
                label.setText_(text);
            }
        });
    }

    protected final String getVertexLabelFor(V vertexElement) {
        if (vertexElement == null) {
            return "<NULL>";
        }
        if (this.vertexLabelProvider != null) {
            return this.vertexLabelProvider.valueFor(vertexElement);
        }
        try {
            Class<?> clazz = vertexElement.getClass();
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(SmartLabelSource.class)) {
                    method.setAccessible(true);
                    Object value = method.invoke(vertexElement, new Object[0]);
                    return value.toString();
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(SmartGraphPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return vertexElement.toString();
    }

    protected final String getEdgeLabelFor(E edgeElement) {
        if (edgeElement == null) {
            return "<NULL>";
        }
        if (this.edgeLabelProvider != null) {
            return this.edgeLabelProvider.valueFor(edgeElement);
        }
        try {
            Class<?> clazz = edgeElement.getClass();
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(SmartLabelSource.class)) {
                    method.setAccessible(true);
                    Object value = method.invoke(edgeElement, new Object[0]);
                    return value.toString();
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(SmartGraphPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return edgeElement.toString();
    }

    protected final String getVertexShapeTypeFor(V vertexElement) {
        if (vertexElement == null) {
            return this.graphProperties.getVertexShape();
        }
        if (this.vertexShapeTypeProvider != null) {
            return this.vertexShapeTypeProvider.valueFor(vertexElement);
        }
        try {
            Class<?> clazz = vertexElement.getClass();
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(SmartShapeTypeSource.class)) {
                    method.setAccessible(true);
                    Object value = method.invoke(vertexElement, new Object[0]);
                    return value.toString();
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(SmartGraphPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.graphProperties.getVertexShape();
    }

    protected final double getVertexShapeRadiusFor(V vertexElement) {
        if (vertexElement == null) {
            return this.graphProperties.getVertexRadius();
        }
        if (this.vertexRadiusProvider != null) {
            return this.vertexRadiusProvider.valueFor(vertexElement);
        }
        try {
            Class<?> clazz = vertexElement.getClass();
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(SmartRadiusSource.class)) {
                    method.setAccessible(true);
                    Object value = method.invoke(vertexElement, new Object[0]);
                    return Double.parseDouble(value.toString());
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(SmartGraphPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.graphProperties.getVertexRadius();
    }

    private Bounds getPlotBounds() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        if (this.vertexNodes.size() == 0) {
            return new BoundingBox(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        for (SmartGraphVertexNode<V> v : this.vertexNodes.values()) {
            minX = Math.min(minX, v.getCenterX());
            minY = Math.min(minY, v.getCenterY());
            maxX = Math.max(maxX, v.getCenterX());
            maxY = Math.max(maxY, v.getCenterY());
        }
        return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
    }

    private void computeForces() {
        this.automaticLayoutStrategy.computeForces(this.vertexNodes.values(), this.getWidth(), this.getHeight());
    }

    private boolean areAdjacent(SmartGraphVertexNode<V> v, SmartGraphVertexNode<V> u) {
        return v.isAdjacentTo(u);
    }

    private void updateForces() {
        this.vertexNodes.values().forEach(v -> v.updateDelta());
    }

    private void applyForces() {
        this.vertexNodes.values().forEach(v -> v.moveFromForces());
    }

    private void resetForces() {
        this.vertexNodes.values().forEach(v -> v.resetForces());
    }

    private int getTotalEdgesBetween(Vertex<V> v, Vertex<V> u) {
        int count = 0;
        for (Edge<E, V> edge : this.theGraph.edges()) {
            if ((edge.vertices()[0] != v || edge.vertices()[1] != u) && (edge.vertices()[0] != u || edge.vertices()[1] != v)) continue;
            ++count;
        }
        return count;
    }

    private List<Edge<E, V>> listOfEdges() {
        return new LinkedList<Edge<E, V>>(this.theGraph.edges());
    }

    private List<Vertex<V>> listOfVertices() {
        return new LinkedList<Vertex<V>>(this.theGraph.vertices());
    }

    private Collection<Vertex<V>> unplottedVertices() {
        LinkedList<Vertex<V>> unplotted = new LinkedList<Vertex<V>>();
        for (Vertex<V> v : this.theGraph.vertices()) {
            if (this.vertexNodes.containsKey(v)) continue;
            unplotted.add(v);
        }
        return unplotted;
    }

    private Collection<Vertex<V>> removedVertices() {
        LinkedList<Vertex<V>> removed = new LinkedList<Vertex<V>>();
        Collection<Vertex<V>> graphVertices = this.theGraph.vertices();
        Collection<SmartGraphVertexNode<V>> plotted = this.vertexNodes.values();
        for (SmartGraphVertexNode<V> v : plotted) {
            if (graphVertices.contains(v.getUnderlyingVertex())) continue;
            removed.add(v.getUnderlyingVertex());
        }
        return removed;
    }

    private Collection<Edge<E, V>> removedEdges() {
        LinkedList removed = new LinkedList();
        Collection<Edge<E, V>> graphEdges = this.theGraph.edges();
        Collection<SmartGraphEdgeBase<E, V>> plotted = this.edgeNodes.values();
        for (SmartGraphEdgeBase<E, V> e : plotted) {
            if (graphEdges.contains(e.getUnderlyingEdge())) continue;
            removed.add(e.getUnderlyingEdge());
        }
        return removed;
    }

    private Collection<Edge<E, V>> unplottedEdges() {
        LinkedList<Edge<Edge<E, V>, V>> unplotted = new LinkedList<Edge<Edge<E, V>, V>>();
        for (Edge<E, V> e : this.theGraph.edges()) {
            if (this.edgeNodes.containsKey(e)) continue;
            unplotted.add(e);
        }
        return unplotted;
    }

    public void setVertexPosition(Vertex<V> v, double x, double y) {
        SmartGraphVertexNode<V> node = this.vertexNodes.get(v);
        if (node != null) {
            node.setPosition(x, y);
        }
    }

    public double getVertexPositionX(Vertex<V> v) {
        SmartGraphVertexNode<V> node = this.vertexNodes.get(v);
        if (node != null) {
            return node.getPositionCenterX();
        }
        return Double.NaN;
    }

    public double getVertexPositionY(Vertex<V> v) {
        SmartGraphVertexNode<V> node = this.vertexNodes.get(v);
        if (node != null) {
            return node.getPositionCenterY();
        }
        return Double.NaN;
    }

    public SmartStylableNode getStylableVertex(Vertex<V> v) {
        return this.vertexNodes.get(v);
    }

    public SmartStylableNode getStylableVertex(V vertexElement) {
        for (Vertex<V> v : this.vertexNodes.keySet()) {
            if (!v.element().equals(vertexElement)) continue;
            return this.vertexNodes.get(v);
        }
        return null;
    }

    public SmartStylableNode getStylableEdge(Edge<E, V> edge) {
        return this.edgeNodes.get(edge);
    }

    public SmartStylableNode getStylableEdge(E edgeElement) {
        for (Edge<E, V> e : this.edgeNodes.keySet()) {
            if (!e.element().equals(edgeElement)) continue;
            return this.edgeNodes.get(e);
        }
        return null;
    }

    public SmartStylableNode getStylableLabel(Vertex<V> v) {
        SmartGraphVertexNode<V> vertex = this.vertexNodes.get(v);
        return vertex != null ? vertex.getStylableLabel() : null;
    }

    public SmartStylableNode getStylableLabel(Edge<E, V> e) {
        SmartGraphEdgeBase<E, V> edge = this.edgeNodes.get(e);
        return edge != null ? edge.getStylableLabel() : null;
    }

    private void loadAndApplyStylesheet(URI cssFile) {
        try {
            String css = cssFile.toURL().toExternalForm();
            this.getStylesheets().add((Object)css);
            this.getStyleClass().add((Object)"graph");
        }
        catch (MalformedURLException ex) {
            String msg = String.format("Error loading stylesheet from URI = %s", cssFile);
            Logger.getLogger(SmartGraphPanel.class.getName()).log(Level.SEVERE, msg, ex);
        }
    }

    private void enableDoubleClickListener() {
        this.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                Node node = UtilitiesJavaFX.pick((Node)this, mouseEvent.getSceneX(), mouseEvent.getSceneY());
                if (node == null) {
                    return;
                }
                if (node instanceof SmartGraphVertex) {
                    SmartGraphVertex v = (SmartGraphVertex)node;
                    if (this.vertexClickConsumer != null) {
                        this.vertexClickConsumer.accept(v);
                    }
                } else if (node instanceof SmartGraphEdge) {
                    SmartGraphEdge e = (SmartGraphEdge)node;
                    if (this.edgeClickConsumer != null) {
                        this.edgeClickConsumer.accept(e);
                    }
                }
            }
        });
    }

    private static double clamp(double value, double min, double max) {
        if (Double.compare(value, min) < 0) {
            return min;
        }
        if (Double.compare(value, max) > 0) {
            return max;
        }
        return value;
    }

    private static class Tuple<T> {
        private final T first;
        private final T second;

        public Tuple(T first, T second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + Objects.hashCode(this.first);
            hash = 29 * hash + Objects.hashCode(this.second);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tuple other = (Tuple)obj;
            if (!Objects.equals(this.first, other.first)) {
                return false;
            }
            return Objects.equals(this.second, other.second);
        }
    }
}

