/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graph.Edge;
import com.brunomnsilva.smartgraph.graphview.SmartArrow;
import com.brunomnsilva.smartgraph.graphview.SmartGraphEdgeBase;
import com.brunomnsilva.smartgraph.graphview.SmartGraphVertexNode;
import com.brunomnsilva.smartgraph.graphview.SmartLabel;
import com.brunomnsilva.smartgraph.graphview.SmartStylableNode;
import com.brunomnsilva.smartgraph.graphview.SmartStyleProxy;
import com.brunomnsilva.smartgraph.graphview.UtilitiesBindings;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Translate;

public class SmartGraphEdgeLine<E, V>
extends Line
implements SmartGraphEdgeBase<E, V> {
    private final Edge<E, V> underlyingEdge;
    private final SmartGraphVertexNode<V> inbound;
    private final SmartGraphVertexNode<V> outbound;
    private SmartLabel attachedLabel = null;
    private SmartArrow attachedArrow = null;
    private final SmartStyleProxy styleProxy;

    public SmartGraphEdgeLine(Edge<E, V> edge, SmartGraphVertexNode<V> inbound, SmartGraphVertexNode<V> outbound) {
        if (inbound == null || outbound == null) {
            throw new IllegalArgumentException("Cannot connect null vertices.");
        }
        this.inbound = inbound;
        this.outbound = outbound;
        this.underlyingEdge = edge;
        this.styleProxy = new SmartStyleProxy((Shape)this);
        this.styleProxy.addStyleClass("edge");
        this.startXProperty().bind((ObservableValue)outbound.centerXProperty());
        this.startYProperty().bind((ObservableValue)outbound.centerYProperty());
        this.endXProperty().bind((ObservableValue)inbound.centerXProperty());
        this.endYProperty().bind((ObservableValue)inbound.centerYProperty());
        this.propagateHoverEffectToArrow();
    }

    @Override
    public void setStyleInline(String css) {
        this.styleProxy.setStyleInline(css);
        if (this.attachedArrow != null) {
            this.attachedArrow.setStyleInline(css);
        }
    }

    @Override
    public void setStyleClass(String cssClass) {
        this.styleProxy.setStyleClass(cssClass);
        if (this.attachedArrow != null) {
            this.attachedArrow.setStyleClass(cssClass);
        }
    }

    @Override
    public void addStyleClass(String cssClass) {
        this.styleProxy.addStyleClass(cssClass);
        if (this.attachedArrow != null) {
            this.attachedArrow.addStyleClass(cssClass);
        }
    }

    @Override
    public boolean removeStyleClass(String cssClass) {
        boolean result = this.styleProxy.removeStyleClass(cssClass);
        if (this.attachedArrow != null) {
            this.attachedArrow.removeStyleClass(cssClass);
        }
        return result;
    }

    @Override
    public void attachLabel(SmartLabel label) {
        this.attachedLabel = label;
        label.xProperty().bind((ObservableValue)this.startXProperty().add((ObservableNumberValue)this.endXProperty()).divide(2).subtract((ObservableNumberValue)Bindings.divide((ObservableNumberValue)label.layoutWidthProperty(), (int)2)));
        label.yProperty().bind((ObservableValue)this.startYProperty().add((ObservableNumberValue)this.endYProperty()).divide(2).add((ObservableNumberValue)Bindings.divide((ObservableNumberValue)label.layoutHeightProperty(), (double)1.5)));
    }

    @Override
    public SmartLabel getAttachedLabel() {
        return this.attachedLabel;
    }

    @Override
    public Edge<E, V> getUnderlyingEdge() {
        return this.underlyingEdge;
    }

    @Override
    public void attachArrow(SmartArrow arrow) {
        this.attachedArrow = arrow;
        arrow.translateXProperty().bind((ObservableValue)this.endXProperty());
        arrow.translateYProperty().bind((ObservableValue)this.endYProperty());
        Rotate rotation = new Rotate();
        rotation.pivotXProperty().bind((ObservableValue)this.translateXProperty());
        rotation.pivotYProperty().bind((ObservableValue)this.translateYProperty());
        rotation.angleProperty().bind((ObservableValue)UtilitiesBindings.toDegrees((ObservableDoubleValue)UtilitiesBindings.atan2((ObservableDoubleValue)this.endYProperty().subtract((ObservableNumberValue)this.startYProperty()), (ObservableDoubleValue)this.endXProperty().subtract((ObservableNumberValue)this.startXProperty()))));
        arrow.getTransforms().add((Object)rotation);
        Translate t = new Translate(0.0, 0.0);
        t.xProperty().bind((ObservableValue)this.inbound.radiusProperty().negate());
        arrow.getTransforms().add((Object)t);
    }

    @Override
    public SmartArrow getAttachedArrow() {
        return this.attachedArrow;
    }

    @Override
    public SmartStylableNode getStylableArrow() {
        return this.attachedArrow;
    }

    @Override
    public SmartStylableNode getStylableLabel() {
        return this.attachedLabel;
    }

    private void propagateHoverEffectToArrow() {
        this.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (this.attachedArrow != null && newValue.booleanValue()) {
                this.attachedArrow.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_ENTERED, 0.0, 0.0, 0.0, 0.0, MouseButton.NONE, 0, true, true, true, true, true, true, true, true, true, true, null));
            } else if (this.attachedArrow != null) {
                this.attachedArrow.fireEvent((Event)new MouseEvent(MouseEvent.MOUSE_EXITED, 0.0, 0.0, 0.0, 0.0, MouseButton.NONE, 0, true, true, true, true, true, true, true, true, true, true, null));
            }
        });
    }
}

