/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graphview.Args;
import com.brunomnsilva.smartgraph.graphview.ShapeWithRadius;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;

public class ShapeRegularPolygon
implements ShapeWithRadius<Polygon> {
    protected final int numberSides;
    protected final DoubleProperty centerX;
    protected final DoubleProperty centerY;
    protected final DoubleProperty radius;
    protected final Polygon surrogate;

    public ShapeRegularPolygon(double x, double y, double radius, int numberSides) {
        Args.requireNonNegative(x, "x");
        Args.requireNonNegative(y, "y");
        Args.requireNonNegative(radius, "radius");
        Args.requireGreaterThan(numberSides, "numberSides", 2.0);
        this.surrogate = new Polygon();
        this.numberSides = numberSides;
        this.centerX = new SimpleDoubleProperty(x);
        this.centerY = new SimpleDoubleProperty(y);
        this.centerX.addListener((observable, oldValue, newValue) -> this.updatePolygon());
        this.centerY.addListener((observable, oldValue, newValue) -> this.updatePolygon());
        this.radius = new SimpleDoubleProperty(radius);
        this.radius.addListener((observable, oldValue, newValue) -> this.updatePolygon());
        this.updatePolygon();
    }

    protected void updatePolygon() {
        this.surrogate.getPoints().clear();
        double cx = this.centerX.doubleValue();
        double cy = this.centerY.doubleValue();
        double startAngle = Math.PI / (double)(this.numberSides % 2 == 0 ? this.numberSides : 2);
        double radius = this.getRadius();
        int i = 0;
        while (i < this.numberSides) {
            double angle = startAngle + Math.PI * 2 * (double)i / (double)this.numberSides;
            double px = cx - radius * Math.cos(angle);
            double py = cy - radius * Math.sin(angle);
            this.surrogate.getPoints().addAll((Object[])new Double[]{px, py});
            ++i;
        }
    }

    public int getNumberSides() {
        return this.numberSides;
    }

    @Override
    public Shape getShape() {
        return this.surrogate;
    }

    @Override
    public DoubleProperty centerXProperty() {
        return this.centerX;
    }

    @Override
    public DoubleProperty centerYProperty() {
        return this.centerY;
    }

    @Override
    public DoubleProperty radiusProperty() {
        return this.radius;
    }

    @Override
    public double getRadius() {
        return this.radius.doubleValue();
    }

    @Override
    public void setRadius(double radius) {
        Args.requireNonNegative(radius, "radius");
        this.radius.set(radius);
    }
}

