/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graphview.Args;
import com.brunomnsilva.smartgraph.graphview.ForceDirectedLayoutStrategy;
import com.brunomnsilva.smartgraph.graphview.SmartGraphVertexNode;
import javafx.geometry.Point2D;

public class ForceDirectedSpringSystemLayoutStrategy<V>
extends ForceDirectedLayoutStrategy<V> {
    private final double repulsiveForce;
    private final double attractionForce;
    private final double attractionScale;
    private final double acceleration;
    private static final double A_THOUSAND = 1000.0;

    public ForceDirectedSpringSystemLayoutStrategy() {
        this.repulsiveForce = 25.0;
        this.attractionForce = 3.0;
        this.attractionScale = 10.0;
        this.acceleration = 0.8;
    }

    public ForceDirectedSpringSystemLayoutStrategy(double repulsiveForce, double attractionForce, double attractionScale, double acceleration) {
        Args.requireGreaterThan(repulsiveForce, "repulsiveForce", 0.0);
        Args.requireGreaterThan(attractionForce, "attractionForce", 0.0);
        Args.requireGreaterThan(attractionScale, "attractionScale", 0.0);
        Args.requireGreaterThan(acceleration, "acceleration", 0.0);
        Args.requireInRange(acceleration, "acceleration", 0.0, 1.0);
        this.repulsiveForce = repulsiveForce;
        this.attractionForce = attractionForce;
        this.attractionScale = attractionScale;
        this.acceleration = acceleration;
    }

    @Override
    protected Point2D computeForceBetween(SmartGraphVertexNode<V> v, SmartGraphVertexNode<V> w, double panelWidth, double panelHeight) {
        Point2D attraction;
        Point2D vPosition = v.getUpdatedPosition();
        Point2D wPosition = w.getUpdatedPosition();
        double distance = vPosition.distance(wPosition) - (v.getRadius() + w.getRadius());
        Point2D forceDirection = wPosition.subtract(vPosition).normalize();
        if (distance < 1.0) {
            distance = 1.0;
        }
        if (v.isAdjacentTo(w)) {
            double attraction_factor = this.attractionForce * Math.log(distance / this.attractionScale);
            attraction = forceDirection.multiply(attraction_factor);
        } else {
            attraction = new Point2D(0.0, 0.0);
        }
        double repulsive_factor = this.repulsiveForce * 1000.0 / (distance * distance);
        Point2D repulsion = forceDirection.multiply(-repulsive_factor);
        Point2D totalForce = new Point2D(attraction.getX() + repulsion.getX(), attraction.getY() + repulsion.getY());
        return totalForce.multiply(this.acceleration);
    }
}

