/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graph;

import com.brunomnsilva.smartgraph.graph.Edge;
import com.brunomnsilva.smartgraph.graph.InvalidEdgeException;
import com.brunomnsilva.smartgraph.graph.InvalidVertexException;
import com.brunomnsilva.smartgraph.graph.Vertex;
import java.util.Collection;

public interface Graph<V, E> {
    public int numVertices();

    public int numEdges();

    public Collection<Vertex<V>> vertices();

    public Collection<Edge<E, V>> edges();

    public Collection<Edge<E, V>> incidentEdges(Vertex<V> var1) throws InvalidVertexException;

    public Vertex<V> opposite(Vertex<V> var1, Edge<E, V> var2) throws InvalidVertexException, InvalidEdgeException;

    public boolean areAdjacent(Vertex<V> var1, Vertex<V> var2) throws InvalidVertexException;

    public Vertex<V> insertVertex(V var1) throws InvalidVertexException;

    public Edge<E, V> insertEdge(Vertex<V> var1, Vertex<V> var2, E var3) throws InvalidVertexException, InvalidEdgeException;

    public Edge<E, V> insertEdge(V var1, V var2, E var3) throws InvalidVertexException, InvalidEdgeException;

    public V removeVertex(Vertex<V> var1) throws InvalidVertexException;

    public E removeEdge(Edge<E, V> var1) throws InvalidEdgeException;

    public V replace(Vertex<V> var1, V var2) throws InvalidVertexException;

    public E replace(Edge<E, V> var1, E var2) throws InvalidEdgeException;
}

