/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graph;

import com.brunomnsilva.smartgraph.graph.Digraph;
import com.brunomnsilva.smartgraph.graph.Edge;
import com.brunomnsilva.smartgraph.graph.InvalidEdgeException;
import com.brunomnsilva.smartgraph.graph.InvalidVertexException;
import com.brunomnsilva.smartgraph.graph.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DigraphEdgeList<V, E>
implements Digraph<V, E> {
    private final Map<V, Vertex<V>> vertices = new HashMap<V, Vertex<V>>();
    private final Map<E, Edge<E, V>> edges = new HashMap<E, Edge<E, V>>();

    @Override
    public synchronized Collection<Edge<E, V>> incidentEdges(Vertex<V> inbound) throws InvalidVertexException {
        this.checkVertex(inbound);
        ArrayList<Edge<Edge<E, V>, V>> incidentEdges = new ArrayList<Edge<Edge<E, V>, V>>();
        for (Edge<E, V> edge : this.edges.values()) {
            if (((MyEdge)edge).getInbound() != inbound) continue;
            incidentEdges.add(edge);
        }
        return incidentEdges;
    }

    @Override
    public synchronized Collection<Edge<E, V>> outboundEdges(Vertex<V> outbound) throws InvalidVertexException {
        this.checkVertex(outbound);
        ArrayList<Edge<Edge<E, V>, V>> outboundEdges = new ArrayList<Edge<Edge<E, V>, V>>();
        for (Edge<E, V> edge : this.edges.values()) {
            if (((MyEdge)edge).getOutbound() != outbound) continue;
            outboundEdges.add(edge);
        }
        return outboundEdges;
    }

    @Override
    public boolean areAdjacent(Vertex<V> outbound, Vertex<V> inbound) throws InvalidVertexException {
        this.checkVertex(outbound);
        this.checkVertex(inbound);
        for (Edge<E, V> edge : this.edges.values()) {
            if (((MyEdge)edge).getOutbound() != outbound || ((MyEdge)edge).getInbound() != inbound) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Edge<E, V> insertEdge(Vertex<V> outbound, Vertex<V> inbound, E edgeElement) throws InvalidVertexException, InvalidEdgeException {
        if (this.existsEdgeWith(edgeElement)) {
            throw new InvalidEdgeException("There's already an edge with this element.");
        }
        MyVertex outVertex = this.checkVertex(outbound);
        MyVertex inVertex = this.checkVertex(inbound);
        MyEdge newEdge = new MyEdge(edgeElement, outVertex, inVertex);
        this.edges.put(edgeElement, newEdge);
        return newEdge;
    }

    @Override
    public synchronized Edge<E, V> insertEdge(V outboundElement, V inboundElement, E edgeElement) throws InvalidVertexException, InvalidEdgeException {
        if (this.existsEdgeWith(edgeElement)) {
            throw new InvalidEdgeException("There's already an edge with this element.");
        }
        if (!this.existsVertexWith(outboundElement)) {
            throw new InvalidVertexException("No vertex contains " + outboundElement);
        }
        if (!this.existsVertexWith(inboundElement)) {
            throw new InvalidVertexException("No vertex contains " + inboundElement);
        }
        MyVertex outVertex = this.vertexOf(outboundElement);
        MyVertex inVertex = this.vertexOf(inboundElement);
        MyEdge newEdge = new MyEdge(edgeElement, outVertex, inVertex);
        this.edges.put(edgeElement, newEdge);
        return newEdge;
    }

    @Override
    public int numVertices() {
        return this.vertices.size();
    }

    @Override
    public int numEdges() {
        return this.edges.size();
    }

    @Override
    public synchronized Collection<Vertex<V>> vertices() {
        return new ArrayList<Vertex<V>>(this.vertices.values());
    }

    @Override
    public synchronized Collection<Edge<E, V>> edges() {
        return new ArrayList<Edge<E, V>>(this.edges.values());
    }

    @Override
    public synchronized Vertex<V> opposite(Vertex<V> v, Edge<E, V> e) throws InvalidVertexException, InvalidEdgeException {
        this.checkVertex(v);
        MyEdge edge = this.checkEdge(e);
        if (!edge.contains(v)) {
            return null;
        }
        if (edge.vertices()[0] == v) {
            return edge.vertices()[1];
        }
        return edge.vertices()[0];
    }

    @Override
    public synchronized Vertex<V> insertVertex(V vElement) throws InvalidVertexException {
        if (this.existsVertexWith(vElement)) {
            throw new InvalidVertexException("There's already a vertex with this element.");
        }
        MyVertex newVertex = new MyVertex(vElement);
        this.vertices.put((MyVertex)vElement, newVertex);
        return newVertex;
    }

    @Override
    public synchronized V removeVertex(Vertex<V> v) throws InvalidVertexException {
        this.checkVertex(v);
        V element = v.element();
        Collection<Edge<Edge<E, V>, V>> inOutEdges = this.incidentEdges(v);
        inOutEdges.addAll(this.outboundEdges(v));
        for (Edge<E, V> edge : inOutEdges) {
            this.edges.remove(edge.element());
        }
        this.vertices.remove(v.element());
        return element;
    }

    @Override
    public synchronized E removeEdge(Edge<E, V> e) throws InvalidEdgeException {
        this.checkEdge(e);
        E element = e.element();
        this.edges.remove(e.element());
        return element;
    }

    @Override
    public V replace(Vertex<V> v, V newElement) throws InvalidVertexException {
        if (this.existsVertexWith(newElement)) {
            throw new InvalidVertexException("There's already a vertex with this element.");
        }
        MyVertex vertex = this.checkVertex(v);
        Object oldElement = vertex.element;
        vertex.element = newElement;
        return oldElement;
    }

    @Override
    public E replace(Edge<E, V> e, E newElement) throws InvalidEdgeException {
        if (this.existsEdgeWith(newElement)) {
            throw new InvalidEdgeException("There's already an edge with this element.");
        }
        MyEdge edge = this.checkEdge(e);
        Object oldElement = edge.element;
        edge.element = newElement;
        return oldElement;
    }

    private MyVertex vertexOf(V vElement) {
        for (Vertex<V> v : this.vertices.values()) {
            if (!v.element().equals(vElement)) continue;
            return (MyVertex)v;
        }
        return null;
    }

    private boolean existsVertexWith(V vElement) {
        return this.vertices.containsKey(vElement);
    }

    private boolean existsEdgeWith(E edgeElement) {
        return this.edges.containsKey(edgeElement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("Graph with %d vertices and %d edges:\n", this.numVertices(), this.numEdges()));
        sb.append("--- Vertices: \n");
        for (Vertex<V> vertex : this.vertices.values()) {
            sb.append("\t").append(vertex.toString()).append("\n");
        }
        sb.append("\n--- Edges: \n");
        for (Edge edge : this.edges.values()) {
            sb.append("\t").append(edge.toString()).append("\n");
        }
        return sb.toString();
    }

    private MyVertex checkVertex(Vertex<V> v) throws InvalidVertexException {
        MyVertex vertex;
        if (v == null) {
            throw new InvalidVertexException("Null vertex.");
        }
        try {
            vertex = (MyVertex)v;
        }
        catch (ClassCastException e) {
            throw new InvalidVertexException("Not a vertex.");
        }
        if (!this.vertices.containsKey(vertex.element)) {
            throw new InvalidVertexException("Vertex does not belong to this graph.");
        }
        return vertex;
    }

    private MyEdge checkEdge(Edge<E, V> e) throws InvalidEdgeException {
        MyEdge edge;
        if (e == null) {
            throw new InvalidEdgeException("Null edge.");
        }
        try {
            edge = (MyEdge)e;
        }
        catch (ClassCastException ex) {
            throw new InvalidVertexException("Not an adge.");
        }
        if (!this.edges.containsKey(edge.element)) {
            throw new InvalidEdgeException("Edge does not belong to this graph.");
        }
        return edge;
    }

    private class MyEdge
    implements Edge<E, V> {
        E element;
        Vertex<V> vertexOutbound;
        Vertex<V> vertexInbound;

        public MyEdge(E element, Vertex<V> vertexOutbound, Vertex<V> vertexInbound) {
            this.element = element;
            this.vertexOutbound = vertexOutbound;
            this.vertexInbound = vertexInbound;
        }

        @Override
        public E element() {
            return this.element;
        }

        public boolean contains(Vertex<V> v) {
            return this.vertexOutbound == v || this.vertexInbound == v;
        }

        @Override
        public Vertex<V>[] vertices() {
            Vertex[] vertices = new Vertex[]{this.vertexOutbound, this.vertexInbound};
            return vertices;
        }

        public String toString() {
            return "Edge{{" + this.element + "}, vertexOutbound=" + this.vertexOutbound.toString() + ", vertexInbound=" + this.vertexInbound.toString() + '}';
        }

        public Vertex<V> getOutbound() {
            return this.vertexOutbound;
        }

        public Vertex<V> getInbound() {
            return this.vertexInbound;
        }
    }

    private class MyVertex
    implements Vertex<V> {
        V element;

        public MyVertex(V element) {
            this.element = element;
        }

        @Override
        public V element() {
            return this.element;
        }

        public String toString() {
            return "Vertex{" + this.element + '}';
        }
    }
}

