/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm.tutorials;

import clojure.lang.AFn;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.LockingTransaction;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Var;
import clojure.storm.Tracer;
import clojure.storm.tutorials.basics$fn__9166;
import clojure.storm.tutorials.basics$instrumentation_and_trace_on_QMARK_;
import clojure.storm.tutorials.basics$loading__6841__auto____9164;
import clojure.storm.tutorials.basics$print_current_step;
import clojure.storm.tutorials.basics$start;
import clojure.storm.tutorials.basics$step_next;
import clojure.storm.tutorials.basics$step_prev;
import clojure.storm.tutorials.basics$step_reset;
import java.util.Arrays;

public class basics__init {
    public static final Var const__0;
    public static final AFn const__1;
    public static final AFn const__2;
    public static final Var const__3;
    public static final AFn const__10;
    public static final Var const__11;
    public static final AFn const__13;
    public static final Var const__14;
    public static final Object const__15;
    public static final Var const__16;
    public static final AFn const__20;
    public static final Var const__21;
    public static final AFn const__24;
    public static final Var const__25;
    public static final AFn const__28;
    public static final Var const__29;
    public static final AFn const__32;
    public static final AFn const__34;
    public static final AFn const__35;
    public static final Var const__36;
    public static final AFn const__39;
    public static final Var const__40;
    public static final AFn const__43;

    public static void load() {
        Object v2;
        Object object = ((IFn)const__0.getRawRoot()).invoke(const__1);
        Object object2 = ((IFn)new basics$loading__6841__auto____9164()).invoke();
        if (((Symbol)const__1).equals(const__2)) {
            v2 = null;
        } else {
            LockingTransaction.runInTransaction(new basics$fn__9166());
            v2 = null;
        }
        Var var = const__3;
        Var var2 = var;
        var.setMeta((IPersistentMap)((Object)const__10));
        Var var3 = const__11;
        var3.setMeta((IPersistentMap)((Object)const__13));
        Var var4 = var3;
        var3.bindRoot(((IFn)const__14.getRawRoot()).invoke(const__15));
        Var var5 = const__16;
        var5.setMeta((IPersistentMap)((Object)const__20));
        Var var6 = var5;
        var5.bindRoot(new basics$print_current_step());
        Var var7 = const__21;
        var7.setMeta((IPersistentMap)((Object)const__24));
        Var var8 = var7;
        var7.bindRoot(new basics$step_next());
        Var var9 = const__25;
        var9.setMeta((IPersistentMap)((Object)const__28));
        Var var10 = var9;
        var9.bindRoot(new basics$step_prev());
        Var var11 = const__29;
        var11.setMeta((IPersistentMap)((Object)const__32));
        Var var12 = var11;
        var11.bindRoot(new basics$step_reset());
        Var var13 = const__3;
        var13.setMeta((IPersistentMap)((Object)const__34));
        Var var14 = var13;
        var13.bindRoot(const__35);
        Var var15 = const__36;
        var15.setMeta((IPersistentMap)((Object)const__39));
        Var var16 = var15;
        var15.bindRoot(new basics$instrumentation_and_trace_on_QMARK_());
        Var var17 = const__40;
        var17.setMeta((IPersistentMap)((Object)const__43));
        Var var18 = var17;
        var17.bindRoot(new basics$start());
        Tracer.registerFormLocation(1524797323, 1, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(-1105318579, 3, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(-1192933853, 5, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(-740672348, 7, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(731392793, 8, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(209579132, 9, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(-1932379274, 10, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(863966379, 12, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(-877337450, 348, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
        Tracer.registerFormLocation(-1947075255, 352, "clojure.storm.tutorials.basics", "clojure/storm/tutorials/basics.clj");
    }

    public static void __init0() {
        const__0 = RT.var("clojure.core", "in-ns");
        const__1 = Symbol.intern(null, "clojure.storm.tutorials.basics");
        const__2 = Symbol.intern(null, "clojure.core");
        const__3 = RT.var("clojure.storm.tutorials.basics", "steps");
        const__10 = (AFn)((Object)RT.map(RT.keyword(null, "declared"), Boolean.TRUE, RT.keyword(null, "line"), 3, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
        const__11 = RT.var("clojure.storm.tutorials.basics", "step");
        const__13 = (AFn)((Object)RT.map(RT.keyword(null, "line"), 5, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
        const__14 = RT.var("clojure.core", "atom");
        const__15 = 0L;
        const__16 = RT.var("clojure.storm.tutorials.basics", "print-current-step");
        const__20 = (AFn)((Object)RT.map(RT.keyword(null, "arglists"), PersistentList.create(Arrays.asList(Tuple.create())), RT.keyword(null, "line"), 7, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
        const__21 = RT.var("clojure.storm.tutorials.basics", "step-next");
        const__24 = (AFn)((Object)RT.map(RT.keyword(null, "arglists"), PersistentList.create(Arrays.asList(Tuple.create())), RT.keyword(null, "line"), 8, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
        const__25 = RT.var("clojure.storm.tutorials.basics", "step-prev");
        const__28 = (AFn)((Object)RT.map(RT.keyword(null, "arglists"), PersistentList.create(Arrays.asList(Tuple.create())), RT.keyword(null, "line"), 9, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
        const__29 = RT.var("clojure.storm.tutorials.basics", "step-reset");
        const__32 = (AFn)((Object)RT.map(RT.keyword(null, "arglists"), PersistentList.create(Arrays.asList(Tuple.create())), RT.keyword(null, "line"), 10, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
        const__34 = (AFn)((Object)RT.map(RT.keyword(null, "line"), 12, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
        const__35 = (AFn)((Object)RT.vector("\nWelcome to ClojureStorm basics tutorial.\n\nYou can always restart this tutorial by evaluating the keyword :tut/basics and move back\nand forth by evaluating :tut/next and :tut/prev.\n\nAs you can see, all ClojureStorm repl commands are invoked by evaluating keywords at the repl,\ncalled commands from now on.\n\nTry the :help command just to have a sense of what options are available, but don't focus too much\non them since we are going to cover them later.\n\nThen type :tut/next to continue.\n", "\nLet's jump right into debugging some code, but first let's load the debugger UI.\n\nYou can always start the FlowStorm UI by executing :dbg, and discard it by just closing\nthe window. It will take a couple of seconds the first time, but should open almost instantly\nfrom there on.\n\nSo go ahead and start the UI and I see you on the next slide!\n", "\nGreat! Now we need some code to debug, so go ahead and evaluate the next expressions:\n(you can copy and paste them one by one on the repl)\n\n----------------------------------\n(defn factorial [n]\n  (if (zero? n)\n     1\n     (* n (factorial (dec n)))))\n\n(factorial 5)\n----------------------------------\n\nIn your repl, you should see the result, like a normal Clojure repl, with the only difference\nthat everything that just happened got recorded. The UI will not show much yet, but follow along,\non the next slide we will be using it to explore what we just recorded.\n\nNote: The recording will always happen independently of the UI running or not.\n      This means you can work normally at your repl and open the debugger to see what just happened.\n\nNote2: What gets recorded depends on the value of clojure.storm.instrumentOnlyPrefixes and\n       clojure.storm.instrumentSkipPrefixes. This tutorial will only work over the `user` namespace\n       but the basic way of using it in your project will be to set :\n\n            -Dclojure.storm.instrumentOnlyPrefixes=your-project-top-ns,lib1-top-ns,lib2-top-ns\n\n       and all namespaces you are interested in debugging.\n\nNext we will start using the debugger.\n", "\nGreat, now let's focus on the FlowStorm UI.\n\nWe will focus on the Flows tab for now. On the left you\nshould see a list of threads for which we have recordings.\n\nIf you are running this from a bare bones clj command you should see\njust the `main` thread there, but if you are running it connected to nrepl (when using Cider, etc)\nyou probably see more threads like `nREPL-session-d7edf6bc-a548-4ce9-a283-71a331a30dc4`.\n\nYou can double click on any thread to explore the recordings, or if you just want to jump to the last\nthing recorded in your repl thread, type the :last command.\n\nGo ahead, try it and then move next.\n", "\nYou should be seeing a \"thread exploring tab\".\n\nIf you typed :last in the previous step, you should be seeing the `code stepping tool`, while if you\ndouble clicked on a thread you should be seeing the `call tree tool`. They are different tools to explore\nthe recordings. You can swap between tools in the bottom left corner of the \"thread exploring tab\".\n\nGo and click the first one, which is the `call tree tool`, then move next.\n", "\nThe `call tree tool` will show you a expandable overview of your recordings.\n\nExpand the one that says `(factorial 5)` and keep expanding it. It will show you\na tree of functions calls with its arguments. You can click on any nodes and the\nbottom two panels will show you a pretty print of the arguments vector on the left\nand of the return value on the right.\n\nNote: You are going to see other repl evaluations also related to Clojure loading the UI namespaces.\n\nNote2: Once opened the tree will not auto-refresh. Use the refresh button at the root of the tree\n       to update it.\n\nNow let's say you are interested in stepping through the code of your factorial function.\nWe can travel just before (factorial 2) was called. For it, you will have to expand the nodes until you\nsee the one you are interested in, then right click on it, and select `Step code` from the menu.\n\nIt should take you to the `code stepping tool` with the debugger positioned right at that\npoint in time.\n", "\nThere are a bunch of things going on at the `code stepping tool`.\n\nSome things to notice is that your factorial function code is showing there with\nsome parts highlighted in pink, and also there is a bar at the top with some controls and\nsome numbers.\n\nThe numbers show the position of the debugger in time for this specific thread. The number at the left\nis the current position, and the one on the right shows how many \"expressions executions\" were recorded\nso far for this thread.\n\nThere are 3 ways of moving around time from this screen.\n\nThe first one is by clicking the controls (check out the tool tips to know how they move).\n\nThe second one is by clicking on the highlights of the form. This are what FlowStorm captured as interesting\ndebugging points for this frame. You can click on them (symbols and expressions). It will get highlighted in green and the\ndebugger will move to that point in time. Sometimes is more practical to just click on the value you want to see\ninstead of clicking the next button many times.\n\nThe third one is by just typing a number on the current step input and then hitting enter.\nThis come in handy when you are trying to understand a complicated execution flow, since you can\ntake notes of interesting positions and then come back by just typing the position.\n\nAlso notice that as you move in time two panels on the right change.\nThe top one shows a pretty print of the current expression value while the bottom one\nshows all locals in scope. This example values are super simple, given they are just integers,\nbut for more complex values sometimes the pretty print is going to be too noisy and we would be better suited\nby a value explorer, which we are going to cover in a couple of slides.\n\nBefore leaving the `code stepping tool` let's learn one more future, loops debugging!\n\n\n", "\nFlowStorm contains a feature that can be pretty handy when debugging loops.\n\nFirst let's define and call a iterative version of our factorial function :\n\n-----------------------------------------\n(defn iter-factorial [n]\n   (loop [i n\n          result 1]\n     (if (zero? i)\n       result\n       (recur (dec i) (* result i)))))\n\n(iter-factorial 5)\n-----------------------------------------\n\nCopy and paste the previous forms, then lets jump right at the end of the iter-factorial call.\nFor this you can type :last, and then start stepping backwards using the single step back arrow\nuntil you get inside the body of the loop.\n\nNow try clicking any of the highlighted forms.\n\nThis time, the debugger is not moving immediately since it is asking first to choose what expression\nyou are interested in. Clicking on any of the menu values will make the debugger move to that position in time.\n\nThere is one special option at the beginning of all loop menus which reads `Goto Last Iteration`.\nThis is going to be useful when debugging loops with many iterations since the menu is only going to list the first 100.\nMost of the time we are also interested in the end of the loop, so we can use this options to quickly jump there.\n\nNote: When working with big loops `flowstorm.fnExpressionsLimit` jvm property can be used to limit\n      how many expressions get recorded per function frame.\n\nBefore finishing the execution exploring tools, let's check one more tool, the `functions list tool`,\nso go ahead and click on the last tab in the bottom left corner.\n", "\nThe `functions list tool` shows you all the functions next to how many times they have been called.\nThis is another way of looking at your recordings, which is sometimes useful.\n\nYou should see at least a table with :\n\n                       `user/factorial`                    6\n                       `user/iter-factorial`               1\n\nIf you double click on the `user/factorial` one, it will show you a list of all the calls with their arguments.\nYou can also use the checkboxes at the top to show/hide some of the arguments, which doesn't\nmake sense on this case but can come handy on more noisy situations.\n\nYou can double click on any of the calls at the left to step over code at that specific point in time.\n\nGive it a shot, double click on the call with arguments [4] to jump exactly to where (factorial 4) was called.\n\nAnd that is it for the code exploring tools! Next we will learn about FlowStorm data exploring tools, so when you\nare ready move next.\n", "\nGreat! Now we are going to learn about FlowStorm value exploring capabilities, but\nfirst let's clean all recordings and try a different example.\n\nFor clearing our recordings you can go to the debugger window and hit `Ctlr-L` or \nby clicking on the top left button (the one with the trash can icon). This comes handy\nin two situations. First, to get rid of old recorded data to make everything cleaner, and second,\nto free the recorded data so the garbage collector can get rid of it.\n\nNote: there is a bar at the bottom right corner that will show your max heap and how much of it is used,\n      so you can keep an eye on it and don't have to worry about recording too much.\n\nSo go ahead, clear the state and then evaluate the next form :\n\n--------------------\n\n(count (all-ns))\n\n--------------------\n\nand then type :last\n\nNow click on the highlighted parenthesis of `(all-ns)` to see the returned value.\n\nAs you can see on the top right panel, it is a sequence of namespaces objects.\n\nGo on and click on the `ins` button at the top of the panel to open the value inspector.\n\nThis will open the Value Inspector in another window with a bunch of stuff.\nYou can keep clicking on the highlighted values to keep digging.\n\nYou can also go backwards by using the top bar breadcrumbs.\n\nIf while digging on values you feel like exploring that value at the repl, you can click on the\n`def` button, it will ask you for a name, let's say you named it `mydata`, now you can go to your\nrepl and find it bound to the `user/mydata` var. You can define a value for the repl in any value panel\nyou see in FlowStorm, not just the value inspector.\n\nThere is also the `tap` value, to tap what you are seeing like with tap> which is pretty convenient if\nyou want to send it to a different value explorer like portal, rebl, reveal, etc.\n", "\nFor the last feature, let's see jumping to exceptions.\n\nFirst get rid of the state (Ctrl-L) and then let's eval this forms :\n\n--------------------------------------\n(defn foo [n]\n  (->> (range n)\n       (filter odd?)\n       (partition-all 2)\n       (map second)\n       (drop 10)\n       (reduce +)))\n\n(foo 70)\n--------------------------------------\n\nAn exception should show! Something on the lines of :\n\n       Cannot invoke \"Object.getClass()\" because \"x\" is null\n\nwhich is pretty confusing.\n\nYou can quickly jump right before the last exception\nby executing :ex\n\nIt should open the thread and point the debugger right before the exception happened.\nYou can then step backwards and try to figure out where the bug is coming from.\n\nLet's se if you can figure it out!\n", "\nBefore closing let's go over some of the important configuration options and commands\ndisplayed by :help.\n\n- :rec and :stop\n\nIf you want to pause tracing because you currently don't need it and you don't want\nrecordings to consume your heap space, you can enable/disable it with :rec and :stop\n\n- :inst and :noinst\n\nYou can also enable/disable compiler instrumentation. Important: when you disable it, it will\nnot remove instrumentation from already loaded functions, you will have to re evaluate them.\n\nDisabling instrumentation is useful when you want to measure performance or in any other situation\nwhere you don't want instrumentation.\nIf you start ClojureStorm with disabled instrumentation it should be exactly the vanilla\nClojure compiler.\n\n- JVM opts -Dclojure.storm.instrumentOnlyPrefixes and -Dclojure.storm.instrumentSkipPrefixes\n\nIf you start the jvm with -Dclojure.storm.instrumentOnlyPrefixes=my-project,lib1,lib2.core\nit means that all functions under my-project.*, lib.*  and lib2.core.* will get instrumented,\neverything else will be skipped and be compiled exactly like with the vanilla Clojure compiler.\n\nOn the other side you have -Dclojure.storm.instrumentSkipPrefixes to specify what to skip instead\nof what to instrument, in case you want to instrument everything but certain libs.\n\nEverything under clojure.* will be un-instrumented by default, but if you set the right prefixes you can then\nre-eval the clojure.* functions you are interested in and instrument them.\n", "\nBefore closing this are some tips I've found for using FlowStorm efficiently :\n\n- Get rid of all the state (Ctrl-L) before executing the actions you are interested in recording\n- Use the jvm options described in :help to configure it so you don't record unnecessary stuff.\n\nAnd that is all for the basics. If you find any issues or suggestions feel free\nto open a issue in https://github.com/jpmonettas/flow-storm-debugger\n\nNow let's go add it to your current project and give it a try.\nAll you have to do is to edit your deps.edn file and add a :dev alias with a config like:\n\n----------------------------------\n{:classpath-overrides {org.clojure/clojure nil}\n :extra-deps {com.github.jpmonettas/clojure {:mvn/version \"LATEST-AVAILABLE-VERSION\"}\n              com.github.jpmonettas/flow-storm-dbg {:mvn/version \"LATEST-AVAILABLE-VERSION\"}}\n :jvm-opts [\"-Dclojure.storm.traceEnable=true\"\n            \"-Dclojure.storm.instrumentEnable=true\"\n            \"-Dclojure.storm.instrumentOnlyPrefixes=YOUR-PROJECT-TOP-NS\"]}\n \nCheers and Good luck!!\n"));
        const__36 = RT.var("clojure.storm.tutorials.basics", "instrumentation-and-trace-on?");
        const__39 = (AFn)((Object)RT.map(RT.keyword(null, "arglists"), PersistentList.create(Arrays.asList(Tuple.create())), RT.keyword(null, "line"), 348, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
        const__40 = RT.var("clojure.storm.tutorials.basics", "start");
        const__43 = (AFn)((Object)RT.map(RT.keyword(null, "arglists"), PersistentList.create(Arrays.asList(Tuple.create())), RT.keyword(null, "line"), 352, RT.keyword(null, "column"), 1, RT.keyword(null, "file"), "clojure/storm/tutorials/basics.clj"));
    }

    static {
        basics__init.__init0();
        Compiler.pushNSandLoader(RT.classForName("clojure.storm.tutorials.basics__init").getClassLoader());
        try {
            basics__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

