/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.storm.BindTrace;
import clojure.storm.CallTreeNode;
import clojure.storm.ExprTrace;
import clojure.storm.FnCallTrace;
import clojure.storm.FnReturnTrace;
import clojure.storm.ITrace;
import java.util.ArrayDeque;
import java.util.Vector;

public class FrameIndex {
    private CallTreeNode rootNode;
    private ArrayDeque<CallTreeNode> buildStack;
    private Vector<ITrace> timeline = new Vector();

    public FrameIndex() {
        this.rootNode = new CallTreeNode();
        this.buildStack = new ArrayDeque();
        this.timeline = new Vector();
        this.buildStack.push(this.rootNode);
    }

    public synchronized void call(FnCallTrace fct) {
        CallTreeNode parentNode = this.buildStack.peek();
        long timelineIdx = this.timeline.size();
        long parentTimelineIdx = 0L;
        if (parentNode.getFrame() != null) {
            parentTimelineIdx = parentNode.getFrame().getTimelineIdx();
        }
        CallTreeNode newNode = new CallTreeNode(fct, timelineIdx, parentTimelineIdx);
        parentNode.addChild(newNode);
        fct.setFrameNode(newNode);
        this.buildStack.push(newNode);
        this.timeline.add(fct);
    }

    public synchronized void exec(ExprTrace et) {
        CallTreeNode currNode = this.buildStack.peek();
        et.setFrameNode(currNode);
        et.setTimelineIdx(this.getTimelineCount());
        boolean added = currNode.addExprExec(et);
        if (added) {
            this.timeline.add(et);
        }
    }

    public synchronized void bind(BindTrace bt) {
        CallTreeNode currNode = this.buildStack.peek();
        currNode.addBind(bt);
    }

    public synchronized void ret(FnReturnTrace frt) {
        frt.setTimelineIdx(this.getTimelineCount());
        this.timeline.add(frt);
        CallTreeNode currNode = this.buildStack.peek();
        frt.setFrameNode(currNode);
        currNode.setReturn(frt);
        this.buildStack.pop();
    }

    public synchronized void resetBuildStack() {
        this.buildStack.clear();
        this.buildStack.push(this.rootNode);
    }

    public Integer getTimelineCount() {
        return this.timeline.size();
    }

    public ITrace getTimelineEntry(int idx) {
        return this.timeline.get(idx);
    }

    public Vector<ITrace> getTimeline() {
        return this.timeline;
    }

    public CallTreeNode getRootNode() {
        return this.rootNode;
    }
}

