/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.storm.BindTrace;
import clojure.storm.ExprTrace;
import clojure.storm.FnCallTrace;
import clojure.storm.FnReturnTrace;
import java.util.ArrayList;
import java.util.List;

public class CallStackFrame {
    private FnCallTrace fnCallTrace;
    private long timelineIdx;
    private FnReturnTrace fnReturnTrace;
    private ArrayList<BindTrace> bindings;
    private ArrayList<ExprTrace> exprExecutions;
    private long parentTimelineIdx;
    private static long fnExpressionsLimit = 10000L;

    public CallStackFrame(FnCallTrace fnCallTrace, long timelineIdx, long parentTimelineIdx) {
        this.fnCallTrace = fnCallTrace;
        this.timelineIdx = timelineIdx;
        this.parentTimelineIdx = parentTimelineIdx;
        this.exprExecutions = new ArrayList();
        this.bindings = new ArrayList();
    }

    public static long getFnExpressionsLimit() {
        return fnExpressionsLimit;
    }

    public long getTimelineIdx() {
        return this.timelineIdx;
    }

    public long getParentTimelineIdx() {
        return this.parentTimelineIdx;
    }

    public void addBind(BindTrace bt) {
        if ((long)this.exprExecutions.size() <= fnExpressionsLimit) {
            this.bindings.add(bt);
        }
    }

    public boolean addExprExec(ExprTrace et) {
        if ((long)this.exprExecutions.size() <= fnExpressionsLimit) {
            this.exprExecutions.add(et);
            return true;
        }
        return false;
    }

    public void setReturn(FnReturnTrace frt) {
        this.fnReturnTrace = frt;
    }

    public FnCallTrace getFnCallTrace() {
        return this.fnCallTrace;
    }

    public FnReturnTrace getFnReturnTrace() {
        return this.fnReturnTrace;
    }

    public List<ExprTrace> getExprExecutions() {
        return this.exprExecutions;
    }

    public List<BindTrace> getBindings() {
        return this.bindings;
    }

    public ExprTrace getExprExecution(int idx) {
        return this.exprExecutions.get(idx);
    }

    public String toString() {
        if (this.fnCallTrace != null) {
            return "[CallStackFrame] " + this.fnCallTrace.toString();
        }
        return "[CallStackFrame] ";
    }

    static {
        String fnExpressionsLimitProp = System.getProperty("clojure.storm.fnExpressionsLimit");
        if (fnExpressionsLimitProp != null) {
            fnExpressionsLimit = Long.parseLong(fnExpressionsLimitProp);
        }
    }
}

