/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.IPersistentVector;
import clojure.storm.Coord;
import clojure.storm.FormLocation;
import clojure.storm.FormObject;
import clojure.storm.TraceIndex;

public class Tracer {
    private static String currentThreadKey() {
        return Thread.currentThread().getName() + "-" + Thread.currentThread().getId();
    }

    public static void traceFnCall(IPersistentVector fnArgs, String fnNs, String fnName, int formId) {
        TraceIndex.addFnCall(fnNs, fnName, fnArgs, formId);
    }

    public static void traceExpr(Object val2, Coord coord, int formId) {
        TraceIndex.addExprExec(val2, coord, formId);
    }

    public static void traceFnReturn(Object retVal, Coord coord, int formId) {
        TraceIndex.addFnReturn(retVal, coord, formId);
    }

    public static void traceBind(Object val2, Coord coord, String symName) {
        TraceIndex.addBind(coord, symName, val2);
    }

    public static void registerFormLocation(int formId, int line, String ns2, String sourceFile) {
        TraceIndex.registerForm(formId, new FormLocation(formId, sourceFile, ns2, line));
    }

    public static void registerFormObject(int formId, String nsName, Object form) {
        TraceIndex.registerForm(formId, new FormObject(formId, nsName, form));
    }
}

