/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.Compiler;
import clojure.lang.EnumerationSeq;
import clojure.lang.IBlockingDeref;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPending;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.ITransientCollection;
import clojure.lang.Keyword;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.storm.BindTrace;
import clojure.storm.Coord;
import clojure.storm.Emitter;
import clojure.storm.ExprTrace;
import clojure.storm.FnCallStatsIndex;
import clojure.storm.FnCallTrace;
import clojure.storm.FnReturnTrace;
import clojure.storm.FormObject;
import clojure.storm.FrameIndex;
import clojure.storm.IForm;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TraceIndex {
    static final Keyword FRAME_INDEX_KEY;
    static final Keyword FN_CALL_STATS_INDEX_KEY;
    static final Keyword THREAD_IDX_KEY;
    static final Keyword THREAD_ID_KEY;
    static final Keyword THREAD_NAME_KEY;
    static final Keyword FORM_ID_KEY;
    static final Keyword FORM_NS_KEY;
    static final Keyword FORM_FORM_KEY;
    static final Keyword FORM_DEF_KIND_KEY;
    static final Keyword MULTIMETHOD_DISPATCH_VAL_KEY;
    static final Keyword REF_SNAPSHOT_KEY;
    static final Keyword REF_TYPE_KEY;
    static final Keyword REF_TIMEOUT_KEY;
    private static IPersistentMap lastCapturedExceptionLoc;
    private static ConcurrentHashMap<Long, IPersistentMap> threadIndexes;
    private static ConcurrentHashMap<Long, String> threadNames;
    private static ConcurrentHashMap<Integer, IForm> formsTable;
    private static IFn onThreadCreatedFn;
    private static AtomicBoolean traceEnable;

    public static IPersistentMap getLastExceptionLoc() {
        return lastCapturedExceptionLoc;
    }

    public static IPersistentMap getLastExpressionLoc() {
        Thread thread2 = Thread.currentThread();
        IPersistentMap indexes = threadIndexes.get(thread2.getId());
        Integer idx = 0;
        if (indexes != null) {
            FrameIndex frameIndex = (FrameIndex)indexes.valAt(FRAME_INDEX_KEY);
            frameIndex.resetBuildStack();
            idx = frameIndex.getTimelineCount() - 1;
        }
        return RT.map(THREAD_ID_KEY, thread2.getId(), THREAD_NAME_KEY, thread2.getName(), THREAD_IDX_KEY, idx);
    }

    public static void handleThreadException(Thread thread2, Throwable ex) {
        Long threadId = thread2.getId();
        IPersistentMap indexes = threadIndexes.get(threadId);
        if (indexes != null) {
            FrameIndex frameIndex = (FrameIndex)indexes.valAt(FRAME_INDEX_KEY);
            frameIndex.resetBuildStack();
            Integer idx = frameIndex.getTimelineCount() - 1;
            lastCapturedExceptionLoc = RT.map(THREAD_ID_KEY, threadId, THREAD_NAME_KEY, thread2.getName(), THREAD_IDX_KEY, idx);
        }
    }

    public static void setOnThreadCreated(IFn f) {
        onThreadCreatedFn = f;
    }

    private static IPersistentMap makeFormMap(IForm form) {
        Object frmO = form.getForm();
        Keyword frmKind = FormObject.formKind(frmO);
        IPersistentMap ret = RT.map(FORM_ID_KEY, form.getId(), FORM_NS_KEY, form.getNs(), FORM_FORM_KEY, frmO, FORM_DEF_KIND_KEY, frmKind);
        if (frmKind == FormObject.DEFMETHOD_KEY) {
            ret = ret.assoc(MULTIMETHOD_DISPATCH_VAL_KEY, FormObject.multiMethodDispatchVal((ISeq)frmO));
        }
        return ret;
    }

    public static void printForms() {
        Enumeration<Integer> e2 = formsTable.keys();
        while (e2.hasMoreElements()) {
            Integer fId = e2.nextElement();
            IForm form = formsTable.get(fId);
            System.out.println("Form " + form.getClass() + " " + form.getForm().toString());
        }
    }

    public static void printStats() {
        System.out.println("Threads :" + threadNames.values());
        Enumeration<Long> e2 = threadIndexes.keys();
        while (e2.hasMoreElements()) {
            Long tId = e2.nextElement();
            IPersistentMap m = threadIndexes.get(tId);
            FrameIndex fi = (FrameIndex)m.valAt(FRAME_INDEX_KEY);
            System.out.println("Thread " + tId + " timeline count " + fi.getTimelineCount());
        }
    }

    public static IPersistentMap getForm(int formId) {
        return TraceIndex.makeFormMap(formsTable.get(formId));
    }

    public static IPersistentVector getAllForms() {
        ArrayList<IPersistentMap> forms = new ArrayList<IPersistentMap>();
        for (IForm form : formsTable.values()) {
            forms.add(TraceIndex.makeFormMap(form));
        }
        return PersistentVector.create(forms);
    }

    public static void registerForm(int formId, IForm form) {
        formsTable.put(formId, form);
    }

    public static Long getThreadId(String threadName) {
        for (Map.Entry<Long, String> entry : threadNames.entrySet()) {
            if (!entry.getValue().equals(threadName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getThreadName(Long threadId) {
        return threadNames.get(threadId);
    }

    public static ISeq getThreadIds() {
        return EnumerationSeq.create(threadIndexes.keys());
    }

    public static ConcurrentHashMap<Long, String> getThreadNames() {
        return threadNames;
    }

    public static IPersistentMap getThreadIndexes(Long threadId) {
        return threadIndexes.get(threadId);
    }

    private static Object maybeSnapshotVal(Object val2) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof IDeref && !val2.getClass().toString().equals("class mount.core.DerefableState")) {
            try {
                Object dval = null;
                if (val2 instanceof IBlockingDeref && val2 instanceof IPending) {
                    dval = ((IPending)val2).isRealized() ? ((IDeref)val2).deref() : REF_TIMEOUT_KEY;
                } else {
                    ((IDeref)val2).deref();
                }
                return RT.map(REF_SNAPSHOT_KEY, dval, REF_TYPE_KEY, val2.getClass().toString());
            }
            catch (Exception e2) {
                System.out.println("ERROR dereferencing val of class : |" + val2.getClass() + "|");
                return val2;
            }
        }
        return val2;
    }

    private static IPersistentVector snapshotVector(IPersistentVector v) {
        ITransientCollection ret = PersistentVector.EMPTY.asTransient();
        for (int i = 0; i < v.count(); ++i) {
            ret = ret.conj(TraceIndex.maybeSnapshotVal(v.nth(i)));
        }
        return (IPersistentVector)ret.persistent();
    }

    public static void addFnCall(String fnNs, String fnName, IPersistentVector fnArgs, int formId) {
        if (traceEnable.get()) {
            IPersistentMap indexes;
            Long threadId = Thread.currentThread().getId();
            String threadName = Thread.currentThread().getName();
            FnCallTrace fct = new FnCallTrace(fnNs, fnName, TraceIndex.snapshotVector(fnArgs), formId);
            if (!threadIndexes.containsKey(threadId)) {
                indexes = RT.map(FRAME_INDEX_KEY, new FrameIndex(), FN_CALL_STATS_INDEX_KEY, new FnCallStatsIndex());
                threadIndexes.put(threadId, indexes);
                if (onThreadCreatedFn != null) {
                    onThreadCreatedFn.invoke(RT.map(THREAD_ID_KEY, threadId, FORM_ID_KEY, formId, THREAD_NAME_KEY, threadName));
                }
            }
            if (!threadNames.contains(threadId)) {
                threadNames.put(threadId, threadName);
            }
            indexes = threadIndexes.get(threadId);
            FrameIndex frameIndex = (FrameIndex)indexes.valAt(FRAME_INDEX_KEY);
            FnCallStatsIndex statsIndex = (FnCallStatsIndex)indexes.valAt(FN_CALL_STATS_INDEX_KEY);
            frameIndex.call(fct);
            statsIndex.call(threadId, fct);
        }
    }

    public static void addExprExec(Object val2, Coord coord, int formId) {
        Long threadId;
        IPersistentMap indexes;
        if (traceEnable.get() && (indexes = threadIndexes.get(threadId = Long.valueOf(Thread.currentThread().getId()))) != null) {
            FrameIndex frameIndex = (FrameIndex)indexes.valAt(FRAME_INDEX_KEY);
            ExprTrace et = new ExprTrace(formId, coord, TraceIndex.maybeSnapshotVal(val2));
            frameIndex.exec(et);
        }
    }

    public static void addFnReturn(Object retVal, Coord coord, int formId) {
        Long threadId;
        IPersistentMap indexes;
        if (traceEnable.get() && (indexes = threadIndexes.get(threadId = Long.valueOf(Thread.currentThread().getId()))) != null) {
            FrameIndex frameIndex = (FrameIndex)indexes.valAt(FRAME_INDEX_KEY);
            FnReturnTrace frt = new FnReturnTrace(TraceIndex.maybeSnapshotVal(retVal), formId, coord);
            frameIndex.ret(frt);
        }
    }

    public static void addBind(Coord coord, String symName, Object val2) {
        Long threadId;
        IPersistentMap indexes;
        if (traceEnable.get() && (indexes = threadIndexes.get(threadId = Long.valueOf(Thread.currentThread().getId()))) != null) {
            FrameIndex frameIndex = (FrameIndex)indexes.valAt(FRAME_INDEX_KEY);
            BindTrace bt = new BindTrace(coord, symName, TraceIndex.maybeSnapshotVal(val2));
            frameIndex.bind(bt);
        }
    }

    public static void discardThread(Long threadId) {
        threadIndexes.remove(threadId);
        threadNames.remove(threadId);
        if (lastCapturedExceptionLoc != null && lastCapturedExceptionLoc.valAt(THREAD_ID_KEY).equals(threadId)) {
            lastCapturedExceptionLoc = null;
        }
    }

    public static boolean getTraceEnable() {
        return traceEnable.get();
    }

    public static void disableThreadsTracing() {
        traceEnable.set(false);
        System.out.println("Storm tracing disable.");
    }

    public static void enableThreadsTracing() {
        if (traceEnable.get()) {
            System.out.println("Storm tracing is already enable.");
        } else {
            for (ISeq threadIds = TraceIndex.getThreadIds(); threadIds != null; threadIds = threadIds.next()) {
                Long threadId = (Long)threadIds.first();
                IPersistentMap indexes = threadIndexes.get(threadId);
                FrameIndex frameIndex = (FrameIndex)indexes.valAt(FRAME_INDEX_KEY);
                frameIndex.resetBuildStack();
            }
            traceEnable.set(true);
            System.out.println("Storm tracing enable.");
        }
    }

    static {
        String onlyPrefixesProp;
        String skipPrefixesProp;
        String instrumentationEnableProp;
        FRAME_INDEX_KEY = Keyword.intern(null, "frame-index");
        FN_CALL_STATS_INDEX_KEY = Keyword.intern(null, "fn-call-stats-index");
        THREAD_IDX_KEY = Keyword.intern("thread", "idx");
        THREAD_ID_KEY = Keyword.intern("thread", "id");
        THREAD_NAME_KEY = Keyword.intern("thread", "name");
        FORM_ID_KEY = Keyword.intern("form", "id");
        FORM_NS_KEY = Keyword.intern("form", "ns");
        FORM_FORM_KEY = Keyword.intern("form", "form");
        FORM_DEF_KIND_KEY = Keyword.intern("form", "def-kind");
        MULTIMETHOD_DISPATCH_VAL_KEY = Keyword.intern("multimethod", "dispatch-val");
        REF_SNAPSHOT_KEY = Keyword.intern("ref", "snapshot");
        REF_TYPE_KEY = Keyword.intern("ref", "type");
        REF_TIMEOUT_KEY = Keyword.intern("ref", "timeout");
        lastCapturedExceptionLoc = null;
        threadIndexes = new ConcurrentHashMap();
        threadNames = new ConcurrentHashMap();
        formsTable = new ConcurrentHashMap();
        onThreadCreatedFn = null;
        traceEnable = new AtomicBoolean(false);
        String traceEnableProp = System.getProperty("clojure.storm.traceEnable");
        if (traceEnableProp != null && traceEnableProp.equals("true")) {
            TraceIndex.enableThreadsTracing();
        }
        if ((instrumentationEnableProp = System.getProperty("clojure.storm.instrumentEnable")) != null) {
            if (instrumentationEnableProp.equals("true")) {
                Emitter.setInstrumentationEnable(true);
            } else {
                Emitter.setInstrumentationEnable(false);
            }
        }
        if ((skipPrefixesProp = System.getProperty("clojure.storm.instrumentSkipPrefixes")) != null) {
            String[] prefixes;
            for (String p : prefixes = skipPrefixesProp.split(",")) {
                Emitter.addInstrumentationSkipPrefix(Compiler.munge(p));
            }
        }
        if ((onlyPrefixesProp = System.getProperty("clojure.storm.instrumentOnlyPrefixes")) != null) {
            String[] prefixes;
            for (String p : prefixes = onlyPrefixesProp.split(",")) {
                Emitter.addInstrumentationOnlyPrefix(Compiler.munge(p));
            }
        }
        Thread.setDefaultUncaughtExceptionHandler((t, e2) -> TraceIndex.handleThreadException(t, e2));
    }
}

