/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.storm.BindTrace;
import clojure.storm.CallStackFrame;
import clojure.storm.ExprTrace;
import clojure.storm.FnCallTrace;
import clojure.storm.FnReturnTrace;
import java.util.List;
import java.util.Vector;

public class CallTreeNode {
    private CallStackFrame frame;
    private Vector<CallTreeNode> childs;

    public CallTreeNode() {
        this.frame = null;
        this.childs = new Vector();
    }

    public CallTreeNode(FnCallTrace fnCallTrace, long timelineIdx, long parentTimelineIdx) {
        this.frame = new CallStackFrame(fnCallTrace, timelineIdx, parentTimelineIdx);
        this.childs = new Vector();
    }

    public void addChild(CallTreeNode child) {
        this.childs.add(child);
    }

    public boolean addExprExec(ExprTrace et) {
        if (!this.isFirstNode()) {
            return this.frame.addExprExec(et);
        }
        return false;
    }

    public void addBind(BindTrace bt) {
        if (!this.isFirstNode()) {
            this.frame.addBind(bt);
        }
    }

    public void setReturn(FnReturnTrace frt) {
        if (!this.isFirstNode()) {
            this.frame.setReturn(frt);
        }
    }

    public boolean isFirstNode() {
        return this.frame == null;
    }

    public List<CallTreeNode> getChilds() {
        return this.childs;
    }

    public CallStackFrame getFrame() {
        return this.frame;
    }

    public String toString() {
        if (this.isFirstNode()) {
            return "[CallTreeNode] FIRST";
        }
        return "[CallTreeNode] " + this.frame.toString();
    }
}

