/*
 * Decompiled with CFR 0.152.
 */
package clojure.storm;

import clojure.lang.AFn;
import clojure.lang.Associative;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.IRecord;
import clojure.lang.ISeq;
import clojure.lang.LispReader;
import clojure.lang.MapEntry;
import clojure.lang.Namespace;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Util;
import clojure.storm.Emitter;
import java.util.ArrayList;
import java.util.Iterator;

public class Utils {
    public static Object mergeMeta(Object x, IPersistentMap m) {
        if (x instanceof IObj) {
            IObj o = (IObj)x;
            if (m != null || RT.meta(o) != null) {
                MapEntry me;
                IPersistentMap retMeta = PersistentHashMap.EMPTY;
                IPersistentMap oMeta = RT.meta(o);
                if (oMeta != null) {
                    for (Object meo : oMeta) {
                        me = (MapEntry)meo;
                        retMeta = retMeta.assoc(me.getKey(), me.getValue());
                    }
                }
                if (m != null) {
                    for (Object meo : m) {
                        me = (MapEntry)meo;
                        retMeta = retMeta.assoc(me.getKey(), me.getValue());
                    }
                }
                return o.withMeta(retMeta);
            }
            return x;
        }
        return x;
    }

    public static Symbol maybeGetTraceSymbol(Symbol sym, ISeq form) {
        if (sym.getNamespace() != null && sym.getNamespace().equals("clojure.core") && sym.getName().equals("addMethod")) {
            Symbol nameSym = (Symbol)RT.second(form);
            String currentNsName = ((Namespace)RT.CURRENT_NS.deref()).getName().getName();
            return Symbol.create(nameSym.getNamespace() != null ? nameSym.getNamespace() : currentNsName, nameSym.getName());
        }
        return null;
    }

    public static IPersistentVector coordOf(Object form) {
        IPersistentVector coord = (IPersistentVector)RT.get(RT.meta(form), LispReader.COORD_KEY);
        if (coord == null && form != null && form instanceof ISeq && ((ISeq)form).count() > 0) {
            coord = (IPersistentVector)RT.get(RT.meta(((ISeq)form).first()), LispReader.COORD_KEY);
        }
        return coord;
    }

    public static Object addCoordMeta(Object o, IPersistentVector coord) {
        Associative meta = RT.meta(o);
        if (coord != null && o instanceof IObj) {
            meta = RT.assoc(meta, LispReader.COORD_KEY, coord);
            return ((IObj)o).withMeta((IPersistentMap)meta);
        }
        return o;
    }

    private static String objCoord(String kind, Object form) {
        return kind + Util.hasheq(form);
    }

    private static IPersistentCollection mapIndexed(IFn f, IPersistentCollection coll) {
        ArrayList<Object> objs = new ArrayList<Object>();
        int i = 0;
        Iterator iter = RT.iter(coll);
        while (iter.hasNext()) {
            Object o = iter.next();
            Object mappedO = f.invoke(i, o);
            objs.add(mappedO);
            ++i;
        }
        if (coll instanceof PersistentVector) {
            return PersistentVector.create(objs);
        }
        if (coll instanceof PersistentHashSet) {
            return PersistentHashSet.create(objs);
        }
        return PersistentList.create(objs);
    }

    private static Object walkCodeForm(final IPersistentVector coord, final IFn f, Object form) {
        AFn walkCollection = new AFn(){

            @Override
            public Object invoke(Object forms) {
                return Utils.mapIndexed(new AFn(){

                    @Override
                    public Object invoke(Object idx, Object frm) {
                        return Utils.walkCodeForm((IPersistentVector)RT.conj(coord, idx), f, frm);
                    }
                }, (IPersistentCollection)forms);
            }
        };
        AFn walkSet = new AFn(){

            @Override
            public Object invoke(Object forms) {
                return (IPersistentSet)Utils.mapIndexed(new AFn(){

                    @Override
                    public Object invoke(Object idx, Object frm) {
                        return Utils.walkCodeForm((IPersistentVector)RT.conj(coord, Utils.objCoord("K", frm)), f, frm);
                    }
                }, (IPersistentSet)forms);
            }
        };
        AFn walkMap = new AFn(){

            @Override
            public Object invoke(Object m) {
                ArrayList<Object> kvs = new ArrayList<Object>();
                Iterator iter = RT.iter(m);
                while (iter.hasNext()) {
                    MapEntry e2 = (MapEntry)iter.next();
                    Object kfrm = e2.getKey();
                    Object vfrm = e2.getValue();
                    kvs.add(Utils.walkCodeForm((IPersistentVector)RT.conj(coord, Utils.objCoord("K", kfrm)), f, kfrm));
                    kvs.add(Utils.walkCodeForm((IPersistentVector)RT.conj(coord, Utils.objCoord("V", kfrm)), f, vfrm));
                }
                Object[] r = kvs.toArray();
                return RT.map(r);
            }
        };
        Object result = null;
        result = form instanceof IPersistentMap && !(form instanceof IRecord) ? walkMap.invoke(form) : (form instanceof IPersistentSet ? walkSet.invoke(form) : (form instanceof IPersistentCollection ? walkCollection.invoke(form) : form));
        return f.invoke(coord, Utils.mergeMeta(result, RT.meta(form)));
    }

    public static Object tagFormRecursively(Object form) {
        return Utils.walkCodeForm(PersistentVector.EMPTY, new AFn(){

            @Override
            public Object invoke(Object coord, Object frm) {
                if (frm instanceof ISeq || frm instanceof Symbol) {
                    return Utils.addCoordMeta(frm, (IPersistentVector)coord);
                }
                return frm;
            }
        }, form);
    }

    public static Object tagStormCoord(Object form) {
        if (((Boolean)Emitter.INSTRUMENTATION_ENABLE.deref()).booleanValue()) {
            try {
                Object tagged = Utils.tagFormRecursively(form);
                return tagged;
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                return form;
            }
        }
        return form;
    }

    public static Object stripStormMeta(Object form) {
        return Utils.walkCodeForm(PersistentVector.EMPTY, new AFn(){

            @Override
            public Object invoke(Object coord, Object frm) {
                if (frm instanceof ISeq || frm instanceof Symbol) {
                    IObj mfrm = (IObj)frm;
                    IPersistentMap frmMeta = RT.meta(mfrm);
                    return mfrm.withMeta((IPersistentMap)RT.dissoc(frmMeta, LispReader.COORD_KEY));
                }
                return frm;
            }
        }, form);
    }

    public static int toInt(Object n) {
        if (n == null) {
            return 0;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        if (n instanceof Long) {
            return ((Long)n).intValue();
        }
        return 0;
    }
}

