goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.active_modules_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.active_modules_ref = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
shadow.cljs.devtools.client.browser.module_loaded = (function shadow$cljs$devtools$client$browser$module_loaded(name){
return shadow.cljs.devtools.client.browser.active_modules_ref.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.active_modules_ref.cljs$core$IDeref$_deref$arity$1(null),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(name)));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_(null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___52127 = arguments.length;
var i__4731__auto___52128 = (0);
while(true){
if((i__4731__auto___52128 < len__4730__auto___52127)){
args__4736__auto__.push((arguments[i__4731__auto___52128]));

var G__52129 = (i__4731__auto___52128 + (1));
i__4731__auto___52128 = G__52129;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
if(cljs.core.seq(shadow.cljs.devtools.client.env.log_style)){
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%cshadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),shadow.cljs.devtools.client.env.log_style], null),args)));
} else {
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null),args)));
}
});

shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq51889){
var G__51890 = cljs.core.first(seq51889);
var seq51889__$1 = cljs.core.next(seq51889);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51890,seq51889__$1);
});

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5816__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5816__auto__)){
var s = temp__5816__auto__;
return s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
}
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.scripts_to_load !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.scripts_to_load = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
shadow.cljs.devtools.client.browser.loaded_QMARK_ = goog.isProvided_;
shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$goog_is_loaded_QMARK_(name){
return $CLJS.SHADOW_ENV.isLoaded(name);
});
shadow.cljs.devtools.client.browser.goog_base_rc = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("shadow.build.classpath","resource","shadow.build.classpath/resource",-879517823),"goog/base.js"], null);
shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_ = (function shadow$cljs$devtools$client$browser$src_is_loaded_QMARK_(p__51894){
var map__51895 = p__51894;
var map__51895__$1 = (((((!((map__51895 == null))))?(((((map__51895.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51895.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51895):map__51895);
var src = map__51895__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51895__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51895__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var or__4131__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.goog_base_rc,resource_id);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return shadow.cljs.devtools.client.browser.goog_is_loaded_QMARK_(output_name);
}
});
shadow.cljs.devtools.client.browser.module_is_active_QMARK_ = (function shadow$cljs$devtools$client$browser$module_is_active_QMARK_(module){
return cljs.core.contains_QMARK_(cljs.core.deref(shadow.cljs.devtools.client.browser.active_modules_ref),module);
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__51897 = cljs.core.seq(sources);
var chunk__51898 = null;
var count__51899 = (0);
var i__51900 = (0);
while(true){
if((i__51900 < count__51899)){
var map__51911 = chunk__51898.cljs$core$IIndexed$_nth$arity$2(null,i__51900);
var map__51911__$1 = (((((!((map__51911 == null))))?(((((map__51911.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51911.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51911):map__51911);
var src = map__51911__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51911__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51911__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51911__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51911__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e51913){var e_52130 = e51913;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_52130);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_52130.message)].join('')));
}

var G__52131 = seq__51897;
var G__52132 = chunk__51898;
var G__52133 = count__51899;
var G__52134 = (i__51900 + (1));
seq__51897 = G__52131;
chunk__51898 = G__52132;
count__51899 = G__52133;
i__51900 = G__52134;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__51897);
if(temp__5818__auto__){
var seq__51897__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51897__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__51897__$1);
var G__52135 = cljs.core.chunk_rest(seq__51897__$1);
var G__52136 = c__4550__auto__;
var G__52137 = cljs.core.count(c__4550__auto__);
var G__52138 = (0);
seq__51897 = G__52135;
chunk__51898 = G__52136;
count__51899 = G__52137;
i__51900 = G__52138;
continue;
} else {
var map__51914 = cljs.core.first(seq__51897__$1);
var map__51914__$1 = (((((!((map__51914 == null))))?(((((map__51914.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51914.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51914):map__51914);
var src = map__51914__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51914__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51914__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51914__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51914__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e51916){var e_52139 = e51916;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_52139);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_52139.message)].join('')));
}

var G__52140 = cljs.core.next(seq__51897__$1);
var G__52141 = null;
var G__52142 = (0);
var G__52143 = (0);
seq__51897 = G__52140;
chunk__51898 = G__52141;
count__51899 = G__52142;
i__51900 = G__52143;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["can't find fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__51918 = cljs.core.seq(js_requires);
var chunk__51919 = null;
var count__51920 = (0);
var i__51921 = (0);
while(true){
if((i__51921 < count__51920)){
var js_ns = chunk__51919.cljs$core$IIndexed$_nth$arity$2(null,i__51921);
var require_str_52146 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_52146);


var G__52147 = seq__51918;
var G__52148 = chunk__51919;
var G__52149 = count__51920;
var G__52150 = (i__51921 + (1));
seq__51918 = G__52147;
chunk__51919 = G__52148;
count__51920 = G__52149;
i__51921 = G__52150;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__51918);
if(temp__5818__auto__){
var seq__51918__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51918__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__51918__$1);
var G__52151 = cljs.core.chunk_rest(seq__51918__$1);
var G__52152 = c__4550__auto__;
var G__52153 = cljs.core.count(c__4550__auto__);
var G__52154 = (0);
seq__51918 = G__52151;
chunk__51919 = G__52152;
count__51920 = G__52153;
i__51921 = G__52154;
continue;
} else {
var js_ns = cljs.core.first(seq__51918__$1);
var require_str_52159 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_52159);


var G__52160 = cljs.core.next(seq__51918__$1);
var G__52161 = null;
var G__52162 = (0);
var G__52163 = (0);
seq__51918 = G__52160;
chunk__51919 = G__52161;
count__51920 = G__52162;
i__51921 = G__52163;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_(sources)){
var G__51925 = cljs.core.PersistentVector.EMPTY;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__51925) : callback.call(null,G__51925));
} else {
var G__51926 = shadow.cljs.devtools.client.env.files_url();
var G__51927 = ((function (G__51926){
return (function (res){
var req = this;
var content = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(content) : callback.call(null,content));
});})(G__51926))
;
var G__51928 = "POST";
var G__51929 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)], 0));
var G__51930 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__51926,G__51927,G__51928,G__51929,G__51930);
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__51935){
var map__51937 = p__51935;
var map__51937__$1 = (((((!((map__51937 == null))))?(((((map__51937.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51937.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51937):map__51937);
var msg = map__51937__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51937__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51937__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var map__51944 = info;
var map__51944__$1 = (((((!((map__51944 == null))))?(((((map__51944.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51944.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51944):map__51944);
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51944__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var compiled = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51944__$1,new cljs.core.Keyword(null,"compiled","compiled",850043082));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4523__auto__ = ((function (map__51944,map__51944__$1,sources,compiled,map__51937,map__51937__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__51947(s__51948){
return (new cljs.core.LazySeq(null,((function (map__51944,map__51944__$1,sources,compiled,map__51937,map__51937__$1,msg,info,reload_info){
return (function (){
var s__51948__$1 = s__51948;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__51948__$1);
if(temp__5818__auto__){
var xs__6376__auto__ = temp__5818__auto__;
var map__51957 = cljs.core.first(xs__6376__auto__);
var map__51957__$1 = (((((!((map__51957 == null))))?(((((map__51957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51957.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51957):map__51957);
var src = map__51957__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51957__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51957__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4519__auto__ = ((function (s__51948__$1,map__51957,map__51957__$1,src,resource_name,warnings,xs__6376__auto__,temp__5818__auto__,map__51944,map__51944__$1,sources,compiled,map__51937,map__51937__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__51947_$_iter__51949(s__51950){
return (new cljs.core.LazySeq(null,((function (s__51948__$1,map__51957,map__51957__$1,src,resource_name,warnings,xs__6376__auto__,temp__5818__auto__,map__51944,map__51944__$1,sources,compiled,map__51937,map__51937__$1,msg,info,reload_info){
return (function (){
var s__51950__$1 = s__51950;
while(true){
var temp__5818__auto____$1 = cljs.core.seq(s__51950__$1);
if(temp__5818__auto____$1){
var s__51950__$2 = temp__5818__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__51950__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__51950__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__51952 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__51951 = (0);
while(true){
if((i__51951 < size__4522__auto__)){
var warning = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__51951);
cljs.core.chunk_append(b__51952,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__52168 = (i__51951 + (1));
i__51951 = G__52168;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51952),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__51947_$_iter__51949(cljs.core.chunk_rest(s__51950__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51952),null);
}
} else {
var warning = cljs.core.first(s__51950__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__51947_$_iter__51949(cljs.core.rest(s__51950__$2)));
}
} else {
return null;
}
break;
}
});})(s__51948__$1,map__51957,map__51957__$1,src,resource_name,warnings,xs__6376__auto__,temp__5818__auto__,map__51944,map__51944__$1,sources,compiled,map__51937,map__51937__$1,msg,info,reload_info))
,null,null));
});})(s__51948__$1,map__51957,map__51957__$1,src,resource_name,warnings,xs__6376__auto__,temp__5818__auto__,map__51944,map__51944__$1,sources,compiled,map__51937,map__51937__$1,msg,info,reload_info))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(warnings));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__51947(cljs.core.rest(s__51948__$1)));
} else {
var G__52170 = cljs.core.rest(s__51948__$1);
s__51948__$1 = G__52170;
continue;
}
} else {
var G__52171 = cljs.core.rest(s__51948__$1);
s__51948__$1 = G__52171;
continue;
}
} else {
return null;
}
break;
}
});})(map__51944,map__51944__$1,sources,compiled,map__51937,map__51937__$1,msg,info,reload_info))
,null,null));
});})(map__51944,map__51944__$1,sources,compiled,map__51937,map__51937__$1,msg,info,reload_info))
;
return iter__4523__auto__(sources);
})()));
var seq__51976_52172 = cljs.core.seq(warnings);
var chunk__51977_52173 = null;
var count__51978_52174 = (0);
var i__51979_52175 = (0);
while(true){
if((i__51979_52175 < count__51978_52174)){
var map__51992_52176 = chunk__51977_52173.cljs$core$IIndexed$_nth$arity$2(null,i__51979_52175);
var map__51992_52177__$1 = (((((!((map__51992_52176 == null))))?(((((map__51992_52176.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51992_52176.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51992_52176):map__51992_52176);
var w_52178 = map__51992_52177__$1;
var msg_52179__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51992_52177__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_52180 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51992_52177__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_52181 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51992_52177__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_52182 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51992_52177__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_52182)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_52180),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_52181),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_52179__$1)].join(''));


var G__52186 = seq__51976_52172;
var G__52187 = chunk__51977_52173;
var G__52188 = count__51978_52174;
var G__52189 = (i__51979_52175 + (1));
seq__51976_52172 = G__52186;
chunk__51977_52173 = G__52187;
count__51978_52174 = G__52188;
i__51979_52175 = G__52189;
continue;
} else {
var temp__5818__auto___52190 = cljs.core.seq(seq__51976_52172);
if(temp__5818__auto___52190){
var seq__51976_52191__$1 = temp__5818__auto___52190;
if(cljs.core.chunked_seq_QMARK_(seq__51976_52191__$1)){
var c__4550__auto___52192 = cljs.core.chunk_first(seq__51976_52191__$1);
var G__52193 = cljs.core.chunk_rest(seq__51976_52191__$1);
var G__52194 = c__4550__auto___52192;
var G__52195 = cljs.core.count(c__4550__auto___52192);
var G__52196 = (0);
seq__51976_52172 = G__52193;
chunk__51977_52173 = G__52194;
count__51978_52174 = G__52195;
i__51979_52175 = G__52196;
continue;
} else {
var map__51994_52197 = cljs.core.first(seq__51976_52191__$1);
var map__51994_52198__$1 = (((((!((map__51994_52197 == null))))?(((((map__51994_52197.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51994_52197.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51994_52197):map__51994_52197);
var w_52199 = map__51994_52198__$1;
var msg_52200__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51994_52198__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_52201 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51994_52198__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_52202 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51994_52198__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_52203 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51994_52198__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_52203)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_52201),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_52202),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_52200__$1)].join(''));


var G__52204 = cljs.core.next(seq__51976_52191__$1);
var G__52205 = null;
var G__52206 = (0);
var G__52207 = (0);
seq__51976_52172 = G__52204;
chunk__51977_52173 = G__52205;
count__51978_52174 = G__52206;
i__51979_52175 = G__52207;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__51944,map__51944__$1,sources,compiled,warnings,map__51937,map__51937__$1,msg,info,reload_info){
return (function (p__51996){
var map__51997 = p__51996;
var map__51997__$1 = (((((!((map__51997 == null))))?(((((map__51997.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51997.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51997):map__51997);
var src = map__51997__$1;
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51997__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51997__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
return ((cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"always-load","always-load",66405637).cljs$core$IFn$_invoke$arity$1(reload_info),ns)) || (cljs.core.not(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src))) || (((cljs.core.contains_QMARK_(compiled,resource_id)) && (cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))))));
});})(map__51944,map__51944__$1,sources,compiled,warnings,map__51937,map__51937__$1,msg,info,reload_info))
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__51944,map__51944__$1,sources,compiled,warnings,map__51937,map__51937__$1,msg,info,reload_info){
return (function (p__52002){
var map__52003 = p__52002;
var map__52003__$1 = (((((!((map__52003 == null))))?(((((map__52003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52003):map__52003);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52003__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"never-load","never-load",1300896819).cljs$core$IFn$_invoke$arity$1(reload_info),ns);
});})(map__51944,map__51944__$1,sources,compiled,warnings,map__51937,map__51937__$1,msg,info,reload_info))
,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (map__51944,map__51944__$1,sources,compiled,warnings,map__51937,map__51937__$1,msg,info,reload_info){
return (function (p__52005){
var map__52007 = p__52005;
var map__52007__$1 = (((((!((map__52007 == null))))?(((((map__52007.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52007.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52007):map__52007);
var rc = map__52007__$1;
var module = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52007__$1,new cljs.core.Keyword(null,"module","module",1424618191));
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("js",shadow.cljs.devtools.client.env.module_format)) || (shadow.cljs.devtools.client.browser.module_is_active_QMARK_(module)));
});})(map__51944,map__51944__$1,sources,compiled,warnings,map__51937,map__51937__$1,msg,info,reload_info))
,sources))));
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(cljs.core.seq(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("reloading code but no :after-load hooks are configured!",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks"], 0));
}

return shadow.cljs.devtools.client.browser.load_sources(sources_to_get,((function (sources_to_get,map__51944,map__51944__$1,sources,compiled,warnings,map__51937,map__51937__$1,msg,info,reload_info){
return (function (p1__51933_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__51933_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
});})(sources_to_get,map__51944,map__51944__$1,sources,compiled,warnings,map__51937,map__51937__$1,msg,info,reload_info))
);
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(new$,(1));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old,rel_new)) || (clojure.string.starts_with_QMARK_(old,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(rel_new),"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
var and__4120__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not(node_uri.hasDomain())));
if(and__4120__auto__){
var and__4120__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs,new$);
if(and__4120__auto____$1){
return new$;
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__52015){
var map__52016 = p__52015;
var map__52016__$1 = (((((!((map__52016 == null))))?(((((map__52016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52016.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52016):map__52016);
var msg = map__52016__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52016__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__52018 = cljs.core.seq(updates);
var chunk__52020 = null;
var count__52021 = (0);
var i__52022 = (0);
while(true){
if((i__52022 < count__52021)){
var path = chunk__52020.cljs$core$IIndexed$_nth$arity$2(null,i__52022);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__52052_52213 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__52055_52214 = null;
var count__52056_52215 = (0);
var i__52057_52216 = (0);
while(true){
if((i__52057_52216 < count__52056_52215)){
var node_52217 = chunk__52055_52214.cljs$core$IIndexed$_nth$arity$2(null,i__52057_52216);
var path_match_52218 = shadow.cljs.devtools.client.browser.match_paths(node_52217.getAttribute("href"),path);
if(cljs.core.truth_(path_match_52218)){
var new_link_52220 = (function (){var G__52065 = node_52217.cloneNode(true);
G__52065.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_52218),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__52065;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_52218], 0));

goog.dom.insertSiblingAfter(new_link_52220,node_52217);

goog.dom.removeNode(node_52217);


var G__52223 = seq__52052_52213;
var G__52224 = chunk__52055_52214;
var G__52225 = count__52056_52215;
var G__52226 = (i__52057_52216 + (1));
seq__52052_52213 = G__52223;
chunk__52055_52214 = G__52224;
count__52056_52215 = G__52225;
i__52057_52216 = G__52226;
continue;
} else {
var G__52227 = seq__52052_52213;
var G__52228 = chunk__52055_52214;
var G__52229 = count__52056_52215;
var G__52230 = (i__52057_52216 + (1));
seq__52052_52213 = G__52227;
chunk__52055_52214 = G__52228;
count__52056_52215 = G__52229;
i__52057_52216 = G__52230;
continue;
}
} else {
var temp__5818__auto___52234 = cljs.core.seq(seq__52052_52213);
if(temp__5818__auto___52234){
var seq__52052_52235__$1 = temp__5818__auto___52234;
if(cljs.core.chunked_seq_QMARK_(seq__52052_52235__$1)){
var c__4550__auto___52236 = cljs.core.chunk_first(seq__52052_52235__$1);
var G__52237 = cljs.core.chunk_rest(seq__52052_52235__$1);
var G__52238 = c__4550__auto___52236;
var G__52239 = cljs.core.count(c__4550__auto___52236);
var G__52240 = (0);
seq__52052_52213 = G__52237;
chunk__52055_52214 = G__52238;
count__52056_52215 = G__52239;
i__52057_52216 = G__52240;
continue;
} else {
var node_52241 = cljs.core.first(seq__52052_52235__$1);
var path_match_52242 = shadow.cljs.devtools.client.browser.match_paths(node_52241.getAttribute("href"),path);
if(cljs.core.truth_(path_match_52242)){
var new_link_52243 = (function (){var G__52069 = node_52241.cloneNode(true);
G__52069.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_52242),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__52069;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_52242], 0));

goog.dom.insertSiblingAfter(new_link_52243,node_52241);

goog.dom.removeNode(node_52241);


var G__52244 = cljs.core.next(seq__52052_52235__$1);
var G__52245 = null;
var G__52246 = (0);
var G__52247 = (0);
seq__52052_52213 = G__52244;
chunk__52055_52214 = G__52245;
count__52056_52215 = G__52246;
i__52057_52216 = G__52247;
continue;
} else {
var G__52248 = cljs.core.next(seq__52052_52235__$1);
var G__52249 = null;
var G__52250 = (0);
var G__52251 = (0);
seq__52052_52213 = G__52248;
chunk__52055_52214 = G__52249;
count__52056_52215 = G__52250;
i__52057_52216 = G__52251;
continue;
}
}
} else {
}
}
break;
}


var G__52252 = seq__52018;
var G__52253 = chunk__52020;
var G__52254 = count__52021;
var G__52255 = (i__52022 + (1));
seq__52018 = G__52252;
chunk__52020 = G__52253;
count__52021 = G__52254;
i__52022 = G__52255;
continue;
} else {
var G__52256 = seq__52018;
var G__52257 = chunk__52020;
var G__52258 = count__52021;
var G__52259 = (i__52022 + (1));
seq__52018 = G__52256;
chunk__52020 = G__52257;
count__52021 = G__52258;
i__52022 = G__52259;
continue;
}
} else {
var temp__5818__auto__ = cljs.core.seq(seq__52018);
if(temp__5818__auto__){
var seq__52018__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__52018__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__52018__$1);
var G__52260 = cljs.core.chunk_rest(seq__52018__$1);
var G__52261 = c__4550__auto__;
var G__52262 = cljs.core.count(c__4550__auto__);
var G__52263 = (0);
seq__52018 = G__52260;
chunk__52020 = G__52261;
count__52021 = G__52262;
i__52022 = G__52263;
continue;
} else {
var path = cljs.core.first(seq__52018__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__52070_52264 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__52073_52265 = null;
var count__52074_52266 = (0);
var i__52075_52267 = (0);
while(true){
if((i__52075_52267 < count__52074_52266)){
var node_52268 = chunk__52073_52265.cljs$core$IIndexed$_nth$arity$2(null,i__52075_52267);
var path_match_52269 = shadow.cljs.devtools.client.browser.match_paths(node_52268.getAttribute("href"),path);
if(cljs.core.truth_(path_match_52269)){
var new_link_52270 = (function (){var G__52080 = node_52268.cloneNode(true);
G__52080.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_52269),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__52080;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_52269], 0));

goog.dom.insertSiblingAfter(new_link_52270,node_52268);

goog.dom.removeNode(node_52268);


var G__52271 = seq__52070_52264;
var G__52272 = chunk__52073_52265;
var G__52273 = count__52074_52266;
var G__52274 = (i__52075_52267 + (1));
seq__52070_52264 = G__52271;
chunk__52073_52265 = G__52272;
count__52074_52266 = G__52273;
i__52075_52267 = G__52274;
continue;
} else {
var G__52275 = seq__52070_52264;
var G__52276 = chunk__52073_52265;
var G__52277 = count__52074_52266;
var G__52278 = (i__52075_52267 + (1));
seq__52070_52264 = G__52275;
chunk__52073_52265 = G__52276;
count__52074_52266 = G__52277;
i__52075_52267 = G__52278;
continue;
}
} else {
var temp__5818__auto___52279__$1 = cljs.core.seq(seq__52070_52264);
if(temp__5818__auto___52279__$1){
var seq__52070_52280__$1 = temp__5818__auto___52279__$1;
if(cljs.core.chunked_seq_QMARK_(seq__52070_52280__$1)){
var c__4550__auto___52281 = cljs.core.chunk_first(seq__52070_52280__$1);
var G__52282 = cljs.core.chunk_rest(seq__52070_52280__$1);
var G__52283 = c__4550__auto___52281;
var G__52284 = cljs.core.count(c__4550__auto___52281);
var G__52285 = (0);
seq__52070_52264 = G__52282;
chunk__52073_52265 = G__52283;
count__52074_52266 = G__52284;
i__52075_52267 = G__52285;
continue;
} else {
var node_52286 = cljs.core.first(seq__52070_52280__$1);
var path_match_52287 = shadow.cljs.devtools.client.browser.match_paths(node_52286.getAttribute("href"),path);
if(cljs.core.truth_(path_match_52287)){
var new_link_52288 = (function (){var G__52081 = node_52286.cloneNode(true);
G__52081.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_52287),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__52081;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_52287], 0));

goog.dom.insertSiblingAfter(new_link_52288,node_52286);

goog.dom.removeNode(node_52286);


var G__52289 = cljs.core.next(seq__52070_52280__$1);
var G__52290 = null;
var G__52291 = (0);
var G__52292 = (0);
seq__52070_52264 = G__52289;
chunk__52073_52265 = G__52290;
count__52074_52266 = G__52291;
i__52075_52267 = G__52292;
continue;
} else {
var G__52293 = cljs.core.next(seq__52070_52280__$1);
var G__52294 = null;
var G__52295 = (0);
var G__52296 = (0);
seq__52070_52264 = G__52293;
chunk__52073_52265 = G__52294;
count__52074_52266 = G__52295;
i__52075_52267 = G__52296;
continue;
}
}
} else {
}
}
break;
}


var G__52297 = cljs.core.next(seq__52018__$1);
var G__52298 = null;
var G__52299 = (0);
var G__52300 = (0);
seq__52018 = G__52297;
chunk__52020 = G__52298;
count__52021 = G__52299;
i__52022 = G__52300;
continue;
} else {
var G__52301 = cljs.core.next(seq__52018__$1);
var G__52302 = null;
var G__52303 = (0);
var G__52304 = (0);
seq__52018 = G__52301;
chunk__52020 = G__52302;
count__52021 = G__52303;
i__52022 = G__52304;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace(s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(shadow.cljs.devtools.client.env.repl_error(e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root()], 0));
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("undefined",typeof(module))){
return eval(js);
} else {
return (0,eval)(js);;
}
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__52089){
var map__52090 = p__52089;
var map__52090__$1 = (((((!((map__52090 == null))))?(((((map__52090.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52090.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52090):map__52090);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52090__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52090__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call(((function (map__52090,map__52090__$1,id,js){
return (function (){
return shadow.cljs.devtools.client.browser.global_eval(js);
});})(map__52090,map__52090__$1,id,js))
,shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__52092,done){
var map__52093 = p__52092;
var map__52093__$1 = (((((!((map__52093 == null))))?(((((map__52093.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52093.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52093):map__52093);
var msg = map__52093__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52093__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52093__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52093__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52093__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (map__52093,map__52093__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (p__52095){
var map__52096 = p__52095;
var map__52096__$1 = (((((!((map__52096 == null))))?(((((map__52096.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52096.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52096):map__52096);
var src = map__52096__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52096__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4120__auto__ = shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__4120__auto__;
}
});})(map__52093,map__52093__$1,msg,id,sources,reload_namespaces,js_requires))
,sources));
return shadow.cljs.devtools.client.browser.load_sources(sources_to_load,((function (sources_to_load,map__52093,map__52093__$1,msg,id,sources,reload_namespaces,js_requires){
return (function (sources__$1){
try{shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
}catch (e52100){var e = e52100;
return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-error","repl/require-error",1689310021),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"error","error",-978969032),e.message], null));
}finally {(done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}});})(sources_to_load,map__52093,map__52093__$1,msg,id,sources,reload_namespaces,js_requires))
);
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__52101,done){
var map__52103 = p__52101;
var map__52103__$1 = (((((!((map__52103 == null))))?(((((map__52103.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52103.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52103):map__52103);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52103__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52103__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.browser.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),((function (map__52103,map__52103__$1,repl_state,id){
return (function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

shadow.cljs.devtools.client.browser.devtools_msg("REPL session start successful");

return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
});})(map__52103,map__52103__$1,repl_state,id))
);
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__52111){
var map__52112 = p__52111;
var map__52112__$1 = (((((!((map__52112 == null))))?(((((map__52112.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52112.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52112):map__52112);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52112__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52112__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_(null);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__52114,done){
var map__52115 = p__52114;
var map__52115__$1 = (((((!((map__52115 == null))))?(((((map__52115.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__52115.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52115):map__52115);
var msg = map__52115__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52115__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

var G__52118_52312 = type;
var G__52118_52313__$1 = (((G__52118_52312 instanceof cljs.core.Keyword))?G__52118_52312.fqn:null);
switch (G__52118_52313__$1) {
case "asset-watch":
shadow.cljs.devtools.client.browser.handle_asset_watch(msg);

break;
case "repl/invoke":
shadow.cljs.devtools.client.browser.repl_invoke(msg);

break;
case "repl/require":
shadow.cljs.devtools.client.browser.repl_require(msg,done);

break;
case "repl/set-ns":
shadow.cljs.devtools.client.browser.repl_set_ns(msg);

break;
case "repl/init":
shadow.cljs.devtools.client.browser.repl_init(msg,done);

break;
case "repl/session-start":
shadow.cljs.devtools.client.browser.repl_init(msg,done);

break;
case "repl/ping":
shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","pong","repl/pong",-166610159),new cljs.core.Keyword(null,"time-server","time-server",786726561),new cljs.core.Keyword(null,"time-server","time-server",786726561).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"time-runtime","time-runtime",-40294923),Date.now()], null));

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

shadow.cljs.devtools.client.browser.handle_build_complete(msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end();

shadow.cljs.devtools.client.hud.hud_error(msg);

break;
case "build-init":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide();

shadow.cljs.devtools.client.hud.load_start();

break;
case "pong":

break;
case "client/stale":
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",shadow.cljs.devtools.client.env.build_id,"\" not running"].join(''));

break;
case "custom-msg":
shadow.cljs.devtools.client.env.publish_BANG_(new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:

}

if(cljs.core.contains_QMARK_(shadow.cljs.devtools.client.env.async_ops,type)){
return null;
} else {
return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
var G__52119 = ["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",shadow.cljs.devtools.client.env.server_host,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/browser"].join('');
var G__52120 = ((function (G__52119){
return (function (res){
var req = this;
var actions = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
if(cljs.core.truth_(callback)){
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(actions) : callback.call(null,actions));
} else {
return null;
}
});})(G__52119))
;
var G__52121 = "POST";
var G__52122 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)], 0));
var G__52123 = ({"content-type": "application/edn; charset=utf-8"});
return goog.net.XhrIo.send(G__52119,G__52120,G__52121,G__52122,G__52123);
});
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url(new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,socket);

socket.onmessage = ((function (print_fn,ws_url,socket){
return (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg(e.data,shadow.cljs.devtools.client.browser.handle_message);
});})(print_fn,ws_url,socket))
;

socket.onopen = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,null);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("goog",shadow.cljs.devtools.client.env.module_format)){
goog.provide = goog.constructNamespace_;
} else {
}

shadow.cljs.devtools.client.env.set_print_fns_BANG_(shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg("WebSocket connected!");
});})(print_fn,ws_url,socket))
;

socket.onclose = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.browser.devtools_msg("WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error((function (){var or__4131__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);

return shadow.cljs.devtools.client.env.reset_print_fns_BANG_();
});})(print_fn,ws_url,socket))
;

return socket.onerror = ((function (print_fn,ws_url,socket){
return (function (e){
shadow.cljs.devtools.client.hud.connection_error("Connection failed!");

return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("websocket error",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
});})(print_fn,ws_url,socket))
;
}catch (e52125){var e = e52125;
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("WebSocket setup failed",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5818__auto___52315 = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5818__auto___52315)){
var s_52316 = temp__5818__auto___52315;
shadow.cljs.devtools.client.browser.devtools_msg("connection reset!");

s_52316.onclose = ((function (s_52316,temp__5818__auto___52315){
return (function (e){
return null;
});})(s_52316,temp__5818__auto___52315))
;

s_52316.close();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

window.addEventListener("beforeunload",(function (){
var temp__5818__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5818__auto__)){
var s = temp__5818__auto__;
return s.close();
} else {
return null;
}
}));

if(cljs.core.truth_((function (){var and__4120__auto__ = document;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("loading",document.readyState);
} else {
return and__4120__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
