goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_((re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1 ? re_frame.registrar.kinds.cljs$core$IFn$_invoke$arity$1(re_frame.fx.kind) : re_frame.registrar.kinds.call(null,re_frame.fx.kind)))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler(re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_()){
var _STAR_current_trace_STAR__orig_val__53573 = re_frame.trace._STAR_current_trace_STAR_;
var _STAR_current_trace_STAR__temp_val__53574 = re_frame.trace.start_trace(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));
re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__temp_val__53574;

try{try{var seq__53577 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__53578 = null;
var count__53579 = (0);
var i__53580 = (0);
while(true){
if((i__53580 < count__53579)){
var vec__53589 = chunk__53578.cljs$core$IIndexed$_nth$arity$2(null,i__53580);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53589,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53589,(1),null);
var temp__5816__auto___53683 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5816__auto___53683)){
var effect_fn_53684 = temp__5816__auto___53683;
(effect_fn_53684.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53684.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53684.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53685 = seq__53577;
var G__53686 = chunk__53578;
var G__53687 = count__53579;
var G__53688 = (i__53580 + (1));
seq__53577 = G__53685;
chunk__53578 = G__53686;
count__53579 = G__53687;
i__53580 = G__53688;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__53577);
if(temp__5818__auto__){
var seq__53577__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53577__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__53577__$1);
var G__53689 = cljs.core.chunk_rest(seq__53577__$1);
var G__53690 = c__4550__auto__;
var G__53691 = cljs.core.count(c__4550__auto__);
var G__53692 = (0);
seq__53577 = G__53689;
chunk__53578 = G__53690;
count__53579 = G__53691;
i__53580 = G__53692;
continue;
} else {
var vec__53593 = cljs.core.first(seq__53577__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53593,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53593,(1),null);
var temp__5816__auto___53693 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5816__auto___53693)){
var effect_fn_53694 = temp__5816__auto___53693;
(effect_fn_53694.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53694.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53694.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53695 = cljs.core.next(seq__53577__$1);
var G__53696 = null;
var G__53697 = (0);
var G__53698 = (0);
seq__53577 = G__53695;
chunk__53578 = G__53696;
count__53579 = G__53697;
i__53580 = G__53698;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_()){
var end__53102__auto___53699 = re_frame.interop.now();
var duration__53103__auto___53700 = (end__53102__auto___53699 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__53103__auto___53700,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now()], 0)));

re_frame.trace.run_tracing_callbacks_BANG_(end__53102__auto___53699);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR__orig_val__53573;
}} else {
var seq__53596 = cljs.core.seq(new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__53597 = null;
var count__53598 = (0);
var i__53599 = (0);
while(true){
if((i__53599 < count__53598)){
var vec__53606 = chunk__53597.cljs$core$IIndexed$_nth$arity$2(null,i__53599);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53606,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53606,(1),null);
var temp__5816__auto___53702 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5816__auto___53702)){
var effect_fn_53703 = temp__5816__auto___53702;
(effect_fn_53703.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53703.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53703.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53704 = seq__53596;
var G__53705 = chunk__53597;
var G__53706 = count__53598;
var G__53707 = (i__53599 + (1));
seq__53596 = G__53704;
chunk__53597 = G__53705;
count__53598 = G__53706;
i__53599 = G__53707;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__53596);
if(temp__5818__auto__){
var seq__53596__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53596__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__53596__$1);
var G__53708 = cljs.core.chunk_rest(seq__53596__$1);
var G__53709 = c__4550__auto__;
var G__53710 = cljs.core.count(c__4550__auto__);
var G__53711 = (0);
seq__53596 = G__53708;
chunk__53597 = G__53709;
count__53598 = G__53710;
i__53599 = G__53711;
continue;
} else {
var vec__53614 = cljs.core.first(seq__53596__$1);
var effect_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53614,(0),null);
var effect_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53614,(1),null);
var temp__5816__auto___53712 = re_frame.registrar.get_handler.cljs$core$IFn$_invoke$arity$3(re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5816__auto___53712)){
var effect_fn_53713 = temp__5816__auto___53712;
(effect_fn_53713.cljs$core$IFn$_invoke$arity$1 ? effect_fn_53713.cljs$core$IFn$_invoke$arity$1(effect_value) : effect_fn_53713.call(null,effect_value));
} else {
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: no handler registered for effect:",effect_key,". Ignoring."], 0));
}


var G__53714 = cljs.core.next(seq__53596__$1);
var G__53715 = null;
var G__53716 = (0);
var G__53717 = (0);
seq__53596 = G__53714;
chunk__53597 = G__53715;
count__53598 = G__53716;
i__53599 = G__53717;
continue;
}
} else {
return null;
}
}
break;
}
}
})], 0));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__53624 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__53625 = null;
var count__53626 = (0);
var i__53627 = (0);
while(true){
if((i__53627 < count__53626)){
var map__53639 = chunk__53625.cljs$core$IIndexed$_nth$arity$2(null,i__53627);
var map__53639__$1 = (((((!((map__53639 == null))))?(((((map__53639.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53639.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53639):map__53639);
var effect = map__53639__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53639__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53639__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__53624,chunk__53625,count__53626,i__53627,map__53639,map__53639__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__53624,chunk__53625,count__53626,i__53627,map__53639,map__53639__$1,effect,ms,dispatch))
,ms);
}


var G__53718 = seq__53624;
var G__53719 = chunk__53625;
var G__53720 = count__53626;
var G__53721 = (i__53627 + (1));
seq__53624 = G__53718;
chunk__53625 = G__53719;
count__53626 = G__53720;
i__53627 = G__53721;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__53624);
if(temp__5818__auto__){
var seq__53624__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53624__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__53624__$1);
var G__53722 = cljs.core.chunk_rest(seq__53624__$1);
var G__53723 = c__4550__auto__;
var G__53724 = cljs.core.count(c__4550__auto__);
var G__53725 = (0);
seq__53624 = G__53722;
chunk__53625 = G__53723;
count__53626 = G__53724;
i__53627 = G__53725;
continue;
} else {
var map__53645 = cljs.core.first(seq__53624__$1);
var map__53645__$1 = (((((!((map__53645 == null))))?(((((map__53645.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53645.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53645):map__53645);
var effect = map__53645__$1;
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53645__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53645__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_(dispatch)) || ((!(typeof ms === 'number'))))){
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-later value:",effect], 0));
} else {
re_frame.interop.set_timeout_BANG_(((function (seq__53624,chunk__53625,count__53626,i__53627,map__53645,map__53645__$1,effect,ms,dispatch,seq__53624__$1,temp__5818__auto__){
return (function (){
return re_frame.router.dispatch(dispatch);
});})(seq__53624,chunk__53625,count__53626,i__53627,map__53645,map__53645__$1,effect,ms,dispatch,seq__53624__$1,temp__5818__auto__))
,ms);
}


var G__53728 = cljs.core.next(seq__53624__$1);
var G__53729 = null;
var G__53730 = (0);
var G__53731 = (0);
seq__53624 = G__53728;
chunk__53625 = G__53729;
count__53626 = G__53730;
i__53627 = G__53731;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if((!(cljs.core.vector_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value], 0));
} else {
return re_frame.router.dispatch(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if((!(cljs.core.sequential_QMARK_(value)))){
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["re-frame: ignoring bad :dispatch-n value. Expected a collection, but got:",value], 0));
} else {
var seq__53651 = cljs.core.seq(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,value));
var chunk__53652 = null;
var count__53653 = (0);
var i__53654 = (0);
while(true){
if((i__53654 < count__53653)){
var event = chunk__53652.cljs$core$IIndexed$_nth$arity$2(null,i__53654);
re_frame.router.dispatch(event);


var G__53734 = seq__53651;
var G__53735 = chunk__53652;
var G__53736 = count__53653;
var G__53737 = (i__53654 + (1));
seq__53651 = G__53734;
chunk__53652 = G__53735;
count__53653 = G__53736;
i__53654 = G__53737;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__53651);
if(temp__5818__auto__){
var seq__53651__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53651__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__53651__$1);
var G__53740 = cljs.core.chunk_rest(seq__53651__$1);
var G__53741 = c__4550__auto__;
var G__53742 = cljs.core.count(c__4550__auto__);
var G__53743 = (0);
seq__53651 = G__53740;
chunk__53652 = G__53741;
count__53653 = G__53742;
i__53654 = G__53743;
continue;
} else {
var event = cljs.core.first(seq__53651__$1);
re_frame.router.dispatch(event);


var G__53744 = cljs.core.next(seq__53651__$1);
var G__53745 = null;
var G__53746 = (0);
var G__53747 = (0);
seq__53651 = G__53744;
chunk__53652 = G__53745;
count__53653 = G__53746;
i__53654 = G__53747;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_(value)){
var seq__53677 = cljs.core.seq(value);
var chunk__53678 = null;
var count__53679 = (0);
var i__53680 = (0);
while(true){
if((i__53680 < count__53679)){
var event = chunk__53678.cljs$core$IIndexed$_nth$arity$2(null,i__53680);
clear_event(event);


var G__53748 = seq__53677;
var G__53749 = chunk__53678;
var G__53750 = count__53679;
var G__53751 = (i__53680 + (1));
seq__53677 = G__53748;
chunk__53678 = G__53749;
count__53679 = G__53750;
i__53680 = G__53751;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__53677);
if(temp__5818__auto__){
var seq__53677__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__53677__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__53677__$1);
var G__53752 = cljs.core.chunk_rest(seq__53677__$1);
var G__53753 = c__4550__auto__;
var G__53754 = cljs.core.count(c__4550__auto__);
var G__53755 = (0);
seq__53677 = G__53752;
chunk__53678 = G__53753;
count__53679 = G__53754;
i__53680 = G__53755;
continue;
} else {
var event = cljs.core.first(seq__53677__$1);
clear_event(event);


var G__53756 = cljs.core.next(seq__53677__$1);
var G__53757 = null;
var G__53758 = (0);
var G__53759 = (0);
seq__53677 = G__53756;
chunk__53678 = G__53757;
count__53679 = G__53758;
i__53680 = G__53759;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event(value);
}
}));
re_frame.fx.reg_fx(new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if((!((cljs.core.deref(re_frame.db.app_db) === value)))){
return cljs.core.reset_BANG_(re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=re_frame.fx.js.map
