goog.provide('re_com.typeahead');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('re_com.misc');
goog.require('re_com.util');
goog.require('re_com.popover');
goog.require('re_com.box');
goog.require('re_com.validate');
goog.require('reagent.core');
goog.require('goog.events.KeyCodes');

/**
 * Return an initial value for the typeahead state, given `args`.
 */
re_com.typeahead.make_typeahead_state = (function re_com$typeahead$make_typeahead_state(p__88596){
var map__88597 = p__88596;
var map__88597__$1 = (((((!((map__88597 == null))))?(((((map__88597.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88597.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88597):map__88597);
var args = map__88597__$1;
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88597__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var rigid_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88597__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88597__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var immediate_model_update_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88597__$1,new cljs.core.Keyword(null,"immediate-model-update?","immediate-model-update?",-2000005618));
var data_source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88597__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var suggestion_to_string = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88597__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var debounce_delay = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88597__$1,new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982));
var model = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88597__$1,new cljs.core.Keyword(null,"model","model",331153215));
var external_model_value = re_com.util.deref_or_value(model);
var G__88604 = (function (){var c_input = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"immediate-model-update?","immediate-model-update?",-2000005618),new cljs.core.Keyword(null,"c-search","c-search",1832536180),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"c-input","c-input",-1821004232),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"external-model","external-model",506095421),new cljs.core.Keyword(null,"model","model",331153215)],[false,(function (){var or__4131__auto__ = suggestion_to_string;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.str;
}
})(),false,"",rigid_QMARK_,data_source,immediate_model_update_QMARK_,(re_com.typeahead.debounce.cljs$core$IFn$_invoke$arity$2 ? re_com.typeahead.debounce.cljs$core$IFn$_invoke$arity$2(c_input,debounce_delay) : re_com.typeahead.debounce.call(null,c_input,debounce_delay)),change_on_blur_QMARK_,cljs.core.PersistentVector.EMPTY,c_input,on_change,re_com.util.deref_or_value(model),re_com.util.deref_or_value(model)]);
})();
if(cljs.core.truth_(external_model_value)){
return (re_com.typeahead.display_suggestion.cljs$core$IFn$_invoke$arity$2 ? re_com.typeahead.display_suggestion.cljs$core$IFn$_invoke$arity$2(G__88604,external_model_value) : re_com.typeahead.display_suggestion.call(null,G__88604,external_model_value));
} else {
return G__88604;
}
});
/**
 * Should `event` update the `typeahead` `model`?
 */
re_com.typeahead.event_updates_model_QMARK_ = (function re_com$typeahead$event_updates_model_QMARK_(p__88611,event){
var map__88612 = p__88611;
var map__88612__$1 = (((((!((map__88612 == null))))?(((((map__88612.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88612.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88612):map__88612);
var state = map__88612__$1;
var change_on_blur_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88612__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var rigid_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88612__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var immediate_model_update_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88612__$1,new cljs.core.Keyword(null,"immediate-model-update?","immediate-model-update?",-2000005618));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value(change_on_blur_QMARK_);
var immediate_model_update_QMARK___$1 = re_com.util.deref_or_value(immediate_model_update_QMARK_);
var rigid_QMARK___$1 = re_com.util.deref_or_value(rigid_QMARK_);
var G__88618 = event;
var G__88618__$1 = (((G__88618 instanceof cljs.core.Keyword))?G__88618.fqn:null);
switch (G__88618__$1) {
case "input-text-blurred":
var and__4120__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not(rigid_QMARK___$1);
} else {
return and__4120__auto__;
}

break;
case "suggestion-activated":
return cljs.core.not(change_on_blur_QMARK___$1);

break;
case "input-text-changed":
var and__4120__auto__ = cljs.core.not(rigid_QMARK___$1);
if(and__4120__auto__){
var or__4131__auto__ = cljs.core.not(change_on_blur_QMARK___$1);
if(or__4131__auto__){
return or__4131__auto__;
} else {
return immediate_model_update_QMARK___$1;
}
} else {
return and__4120__auto__;
}

break;
default:
return false;

}
});
/**
 * Should `event` cause the `input-text` value to be used to show the active suggestion?
 */
re_com.typeahead.event_displays_suggestion_QMARK_ = (function re_com$typeahead$event_displays_suggestion_QMARK_(p__88622,event){
var map__88623 = p__88622;
var map__88623__$1 = (((((!((map__88623 == null))))?(((((map__88623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88623.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88623):map__88623);
var state = map__88623__$1;
var change_on_blur_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88623__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value(change_on_blur_QMARK_);
var G__88625 = event;
var G__88625__$1 = (((G__88625 instanceof cljs.core.Keyword))?G__88625.fqn:null);
switch (G__88625__$1) {
case "suggestion-activated":
return cljs.core.not(change_on_blur_QMARK___$1);

break;
default:
return false;

}
});
/**
 * Change the `typeahead` `model` value to `new-value`
 */
re_com.typeahead.update_model = (function re_com$typeahead$update_model(p__88629,new_value){
var map__88630 = p__88629;
var map__88630__$1 = (((((!((map__88630 == null))))?(((((map__88630.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88630.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88630):map__88630);
var state = map__88630__$1;
var on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88630__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
if(cljs.core.truth_(on_change)){
(on_change.cljs$core$IFn$_invoke$arity$1 ? on_change.cljs$core$IFn$_invoke$arity$1(new_value) : on_change.call(null,new_value));
} else {
}

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword(null,"model","model",331153215),new_value);
});
/**
 * Change the `input-text` `model` to the string representation of `suggestion`
 */
re_com.typeahead.display_suggestion = (function re_com$typeahead$display_suggestion(p__88634,suggestion){
var map__88635 = p__88634;
var map__88635__$1 = (((((!((map__88635 == null))))?(((((map__88635.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88635.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88635):map__88635);
var state = map__88635__$1;
var suggestion_to_string = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88635__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var suggestion_string = (suggestion_to_string.cljs$core$IFn$_invoke$arity$1 ? suggestion_to_string.cljs$core$IFn$_invoke$arity$1(suggestion) : suggestion_to_string.call(null,suggestion));
var G__88637 = state;
if(cljs.core.truth_(suggestion_string)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__88637,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),suggestion_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),true], 0));
} else {
return G__88637;
}
});
re_com.typeahead.clear_suggestions = (function re_com$typeahead$clear_suggestions(state){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728)], 0));
});
/**
 * Make the suggestion at `index` the active suggestion
 */
re_com.typeahead.activate_suggestion_by_index = (function re_com$typeahead$activate_suggestion_by_index(p__88641,index){
var map__88642 = p__88641;
var map__88642__$1 = (((((!((map__88642 == null))))?(((((map__88642.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88642.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88642):map__88642);
var state = map__88642__$1;
var suggestions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88642__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(suggestions,index);
var G__88644 = state;
var G__88644__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__88644,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),index)
;
var G__88644__$2 = (cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_(state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))?re_com.typeahead.update_model(G__88644__$1,suggestion):G__88644__$1);
if(cljs.core.truth_(re_com.typeahead.event_displays_suggestion_QMARK_(state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))){
return re_com.typeahead.display_suggestion(G__88644__$2,suggestion);
} else {
return G__88644__$2;
}
});
/**
 * Choose the suggestion at `index`
 */
re_com.typeahead.choose_suggestion_by_index = (function re_com$typeahead$choose_suggestion_by_index(p__88646,index){
var map__88647 = p__88646;
var map__88647__$1 = (((((!((map__88647 == null))))?(((((map__88647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88647.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88647):map__88647);
var state = map__88647__$1;
var suggestions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88647__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(suggestions,index);
return re_com.typeahead.clear_suggestions(re_com.typeahead.display_suggestion(re_com.typeahead.update_model(re_com.typeahead.activate_suggestion_by_index(state,index),suggestion),suggestion));
});
re_com.typeahead.choose_suggestion_active = (function re_com$typeahead$choose_suggestion_active(p__88652){
var map__88654 = p__88652;
var map__88654__$1 = (((((!((map__88654 == null))))?(((((map__88654.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88654.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88654):map__88654);
var state = map__88654__$1;
var suggestion_active_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88654__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__88656 = state;
if(cljs.core.truth_(suggestion_active_index)){
return re_com.typeahead.choose_suggestion_by_index(G__88656,suggestion_active_index);
} else {
return G__88656;
}
});
re_com.typeahead.wrap = (function re_com$typeahead$wrap(index,count){
return cljs.core.mod((count + index),count);
});
re_com.typeahead.activate_suggestion_next = (function re_com$typeahead$activate_suggestion_next(p__88657){
var map__88658 = p__88657;
var map__88658__$1 = (((((!((map__88658 == null))))?(((((map__88658.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88658.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88658):map__88658);
var state = map__88658__$1;
var suggestions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88658__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88658__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__88660 = state;
if(cljs.core.seq(suggestions)){
return re_com.typeahead.activate_suggestion_by_index(G__88660,re_com.typeahead.wrap(((function (){var or__4131__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (-1);
}
})() + (1)),cljs.core.count(suggestions)));
} else {
return G__88660;
}
});
re_com.typeahead.activate_suggestion_prev = (function re_com$typeahead$activate_suggestion_prev(p__88661){
var map__88662 = p__88661;
var map__88662__$1 = (((((!((map__88662 == null))))?(((((map__88662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88662.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88662):map__88662);
var state = map__88662__$1;
var suggestions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88662__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88662__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__88664 = state;
if(cljs.core.seq(suggestions)){
return re_com.typeahead.activate_suggestion_by_index(G__88664,re_com.typeahead.wrap(((function (){var or__4131__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() - (1)),cljs.core.count(suggestions)));
} else {
return G__88664;
}
});
re_com.typeahead.reset_typeahead = (function re_com$typeahead$reset_typeahead(state){
var G__88665 = state;
var G__88665__$1 = re_com.typeahead.clear_suggestions(G__88665)
;
var G__88665__$2 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__88665__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"input-text","input-text",-1336297114),"",new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false], 0))
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_(state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model(G__88665__$2,null);
} else {
return G__88665__$2;
}
});
/**
 * Update state when new suggestions are available
 */
re_com.typeahead.got_suggestions = (function re_com$typeahead$got_suggestions(state,suggestions){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),suggestions,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),null], 0));
});
/**
 * Update state when the `input-text` is about to lose focus.
 */
re_com.typeahead.input_text_will_blur = (function re_com$typeahead$input_text_will_blur(p__88670){
var map__88671 = p__88670;
var map__88671__$1 = (((((!((map__88671 == null))))?(((((map__88671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88671.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88671):map__88671);
var state = map__88671__$1;
var input_text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88671__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var displaying_suggestion_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88671__$1,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862));
var model = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88671__$1,new cljs.core.Keyword(null,"model","model",331153215));
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.not(displaying_suggestion_QMARK_);
if(and__4120__auto__){
return re_com.typeahead.event_updates_model_QMARK_(state,new cljs.core.Keyword(null,"input-text-blurred","input-text-blurred",-501892307));
} else {
return and__4120__auto__;
}
})())){
return re_com.typeahead.update_model(state,input_text);
} else {
return re_com.typeahead.clear_suggestions(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),input_text));

}
});
/**
 * Update `state` given a new `data-source`. Resets the typeahead since any existing suggestions
 *   came from the old `data-source`.
 */
re_com.typeahead.change_data_source = (function re_com$typeahead$change_data_source(state,data_source){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(re_com.typeahead.reset_typeahead(state),new cljs.core.Keyword(null,"data-source","data-source",-658934676),data_source);
});
/**
 * Call the `data-source` fn with `text`, and then call `got-suggestions` with the result
 *   (asynchronously, if `data-source` does not return a truthy value).
 */
re_com.typeahead.search_data_source_BANG_ = (function re_com$typeahead$search_data_source_BANG_(data_source,state_atom,text){
var temp__5816__auto__ = (function (){var G__88679 = text;
var G__88680 = ((function (G__88679){
return (function (p1__88678_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state_atom,re_com.typeahead.got_suggestions,p1__88678_SHARP_);
});})(G__88679))
;
return (data_source.cljs$core$IFn$_invoke$arity$2 ? data_source.cljs$core$IFn$_invoke$arity$2(G__88679,G__88680) : data_source.call(null,G__88679,G__88680));
})();
if(cljs.core.truth_(temp__5816__auto__)){
var return_value = temp__5816__auto__;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state_atom,re_com.typeahead.got_suggestions,return_value);
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),true);
}
});
/**
 * For every value arriving on the `c-search` channel, call `search-data-source!`.
 */
re_com.typeahead.search_data_source_loop_BANG_ = (function re_com$typeahead$search_data_source_loop_BANG_(state_atom,c_search){
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__){
return (function (state_88701){
var state_val_88702 = (state_88701[(1)]);
if((state_val_88702 === (1))){
var state_88701__$1 = state_88701;
var statearr_88707_88933 = state_88701__$1;
(statearr_88707_88933[(2)] = null);

(statearr_88707_88933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88702 === (2))){
var state_88701__$1 = state_88701;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88701__$1,(4),c_search);
} else {
if((state_val_88702 === (3))){
var inst_88697 = (state_88701[(2)]);
var state_88701__$1 = state_88701;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88701__$1,inst_88697);
} else {
if((state_val_88702 === (4))){
var inst_88683 = (state_88701[(7)]);
var inst_88683__$1 = (state_88701[(2)]);
var inst_88684 = cljs.core.deref(state_atom);
var inst_88685 = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(inst_88684);
var inst_88686 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",inst_88683__$1);
var state_88701__$1 = (function (){var statearr_88710 = state_88701;
(statearr_88710[(7)] = inst_88683__$1);

(statearr_88710[(8)] = inst_88685);

return statearr_88710;
})();
if(inst_88686){
var statearr_88711_88936 = state_88701__$1;
(statearr_88711_88936[(1)] = (5));

} else {
var statearr_88713_88937 = state_88701__$1;
(statearr_88713_88937[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88702 === (5))){
var inst_88685 = (state_88701[(8)]);
var inst_88688 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,re_com.typeahead.reset_typeahead);
var inst_88689 = re_com.typeahead.search_data_source_BANG_(inst_88685,state_atom,"");
var state_88701__$1 = (function (){var statearr_88715 = state_88701;
(statearr_88715[(9)] = inst_88688);

return statearr_88715;
})();
var statearr_88716_88940 = state_88701__$1;
(statearr_88716_88940[(2)] = inst_88689);

(statearr_88716_88940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88702 === (6))){
var inst_88683 = (state_88701[(7)]);
var inst_88685 = (state_88701[(8)]);
var inst_88691 = re_com.typeahead.search_data_source_BANG_(inst_88685,state_atom,inst_88683);
var state_88701__$1 = state_88701;
var statearr_88717_88943 = state_88701__$1;
(statearr_88717_88943[(2)] = inst_88691);

(statearr_88717_88943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88702 === (7))){
var inst_88693 = (state_88701[(2)]);
var state_88701__$1 = (function (){var statearr_88718 = state_88701;
(statearr_88718[(10)] = inst_88693);

return statearr_88718;
})();
var statearr_88720_88948 = state_88701__$1;
(statearr_88720_88948[(2)] = null);

(statearr_88720_88948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__46663__auto__))
;
return ((function (switch__46368__auto__,c__46663__auto__){
return (function() {
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto__ = null;
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto____0 = (function (){
var statearr_88721 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_88721[(0)] = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto__);

(statearr_88721[(1)] = (1));

return statearr_88721;
});
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto____1 = (function (state_88701){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_88701);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e88723){if((e88723 instanceof Object)){
var ex__46372__auto__ = e88723;
var statearr_88725_88949 = state_88701;
(statearr_88725_88949[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_88701);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e88723;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88950 = state_88701;
state_88701 = G__88950;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto__ = function(state_88701){
switch(arguments.length){
case 0:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto____0.call(this);
case 1:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto____1.call(this,state_88701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto____0;
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto____1;
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__))
})();
var state__46665__auto__ = (function (){var statearr_88728 = f__46664__auto__();
(statearr_88728[(6)] = c__46663__auto__);

return statearr_88728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__))
);

return c__46663__auto__;
});
/**
 * Update state in response to `input-text` `on-change`, and put text on the `c-input` channel
 */
re_com.typeahead.input_text_on_change_BANG_ = (function re_com$typeahead$input_text_on_change_BANG_(state_atom,new_text){
var map__88732 = cljs.core.deref(state_atom);
var map__88732__$1 = (((((!((map__88732 == null))))?(((((map__88732.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88732.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88732):map__88732);
var state = map__88732__$1;
var input_text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88732__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var c_input = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88732__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_text,input_text)){
return state;
} else {
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(c_input,new_text);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,((function (map__88732,map__88732__$1,state,input_text,c_input){
return (function (p1__88730_SHARP_){
var G__88734 = p1__88730_SHARP_;
var G__88734__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__88734,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new_text,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false], 0))
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_(state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model(G__88734__$1,new_text);
} else {
return G__88734__$1;
}
});})(map__88732,map__88732__$1,state,input_text,c_input))
);
}
});
re_com.typeahead.input_text_on_key_down_BANG_ = (function re_com$typeahead$input_text_on_key_down_BANG_(state_atom,event){
var pred__88735 = cljs.core._EQ_;
var expr__88736 = event.which;
if(cljs.core.truth_((pred__88735.cljs$core$IFn$_invoke$arity$2 ? pred__88735.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.UP,expr__88736) : pred__88735.call(null,goog.events.KeyCodes.UP,expr__88736)))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,re_com.typeahead.activate_suggestion_prev);
} else {
if(cljs.core.truth_((pred__88735.cljs$core$IFn$_invoke$arity$2 ? pred__88735.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.DOWN,expr__88736) : pred__88735.call(null,goog.events.KeyCodes.DOWN,expr__88736)))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,re_com.typeahead.activate_suggestion_next);
} else {
if(cljs.core.truth_((pred__88735.cljs$core$IFn$_invoke$arity$2 ? pred__88735.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.ENTER,expr__88736) : pred__88735.call(null,goog.events.KeyCodes.ENTER,expr__88736)))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,re_com.typeahead.choose_suggestion_active);
} else {
if(cljs.core.truth_((pred__88735.cljs$core$IFn$_invoke$arity$2 ? pred__88735.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.ESC,expr__88736) : pred__88735.call(null,goog.events.KeyCodes.ESC,expr__88736)))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state_atom,re_com.typeahead.got_suggestions,cljs.core.PersistentVector.EMPTY);
} else {
if(cljs.core.truth_((pred__88735.cljs$core$IFn$_invoke$arity$2 ? pred__88735.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.TAB,expr__88736) : pred__88735.call(null,goog.events.KeyCodes.TAB,expr__88736)))){
if(cljs.core.truth_(cljs.core.not_empty(new cljs.core.Keyword(null,"suggestions","suggestions",-859472618).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state_atom))))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,re_com.typeahead.activate_suggestion_next);

return event.preventDefault();
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,re_com.typeahead.input_text_will_blur);
}
} else {
return true;
}
}
}
}
}
});
re_com.typeahead.typeahead_args_desc = new cljs.core.PersistentVector(null, 19, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null)," supplies suggestion objects. This can either accept a single string argument (the search term), or a string and a callback. For the first case, the fn should return a collection of suggestion objects (which can be anything). For the second case, the fn should return ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil"], null),", and eventually result in a call to the callback with a collection of suggestion objects."], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"string -> nil",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":change-on-blur?"], null)," controls when it is called. It is passed a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, invoke ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-change"], null)," when the user chooses a suggestion, otherwise invoke it on every change (navigating through suggestions with the mouse or keyboard, or if ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"rigid?"], null)," is also ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null),", invoke it on every character typed.)"], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"immediate-model-update?","immediate-model-update?",-2000005618),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"update model with currently entered text on every keystroke (similar to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":change-on-blur?"], null)," but no changes to model if mouse is over suggestions)"], null)], null),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"object | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"the initial value of the typeahead (should match the suggestion objects returned by ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),")."]),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),(250),new cljs.core.Keyword(null,"type","type",1174270348),"integer",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.integer_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"after receiving input, the typeahead will wait this many milliseconds without receiving new input before calling ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),"."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"render fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"override the rendering of the suggestion items by passing a fn that returns hiccup forms. The fn will receive two arguments: the search term, and the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"suggestion -> string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"when a suggestion is chosen, the input-text value will be set to the result of calling this fn with the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"If ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null)," the user will be allowed to choose arbitrary text input rather than a suggestion from ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),". In this case, a string will be supplied in lieu of a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"keyword",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.input_status_type_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"validation status. ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil/omitted"], null)," for normal status or one of: ",re_com.validate.input_status_types_list], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, display an icon to match ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":status"], null)," (no icon for nil)"], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"displayed in status icon's tooltip"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"background text shown when empty"], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),"250px",new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS width setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS height setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, the user can't interact (input anything)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS class names, space separated (applies to the textbox)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"CSS style map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.css_style_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS styles to add or override (applies to the textbox)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"HTML attr map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.html_attr_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"HTML attributes, like ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-mouse-move"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),"No ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":class"], null)," or ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":style"], null),"allowed (applies to ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.bold","span.bold",636457745),"the outer container"], null),", rather than the textbox)"], null)], null)], null);
/**
 * typeahead reagent component
 */
re_com.typeahead.typeahead = (function re_com$typeahead$typeahead(var_args){
var args__4736__auto__ = [];
var len__4730__auto___88983 = arguments.length;
var i__4731__auto___88985 = (0);
while(true){
if((i__4731__auto___88985 < len__4730__auto___88983)){
args__4736__auto__.push((arguments[i__4731__auto___88985]));

var G__88987 = (i__4731__auto___88985 + (1));
i__4731__auto___88985 = G__88987;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic = (function (p__88749){
var map__88751 = p__88749;
var map__88751__$1 = (((((!((map__88751 == null))))?(((((map__88751.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88751.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88751):map__88751);
var args = map__88751__$1;
if((((!(goog.DEBUG)))?true:re_com.validate.validate_args.cljs$core$IFn$_invoke$arity$variadic(re_com.validate.extract_arg_data(re_com.typeahead.typeahead_args_desc),args,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["typeahead"], 0)))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__88753 = re_com.typeahead.make_typeahead_state(args);
var map__88753__$1 = (((((!((map__88753 == null))))?(((((map__88753.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88753.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88753):map__88753);
var state = map__88753__$1;
var c_search = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88753__$1,new cljs.core.Keyword(null,"c-search","c-search",1832536180));
var c_input = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88753__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
var state_atom = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(state);
var input_text_model = reagent.core.cursor(state_atom,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input-text","input-text",-1336297114)], null));
re_com.typeahead.search_data_source_loop_BANG_(state_atom,c_search);

return ((function (map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function() { 
var G__88988__delegate = function (p__88758){
var map__88759 = p__88758;
var map__88759__$1 = (((((!((map__88759 == null))))?(((((map__88759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88759.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88759):map__88759);
var args__$1 = map__88759__$1;
var disabled_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var status_icon_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var status_tooltip = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007));
var model = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"model","model",331153215));
var _debounce_delay = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"_debounce-delay","_debounce-delay",-1476744225));
var attr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"attr","attr",-604132353));
var _on_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"_on-change","_on-change",156649312));
var placeholder = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var render_suggestion = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503));
var _suggestion_to_string = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"_suggestion-to-string","_suggestion-to-string",795407399));
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var data_source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var _rigid_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"_rigid?","_rigid?",1424449294));
var style = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var _change_on_blur_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"_change-on-blur?","_change-on-blur?",1219941073));
var _immediate_model_update_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"_immediate-model-update?","_immediate-model-update?",1035374450));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88759__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
if((((!(goog.DEBUG)))?true:re_com.validate.validate_args.cljs$core$IFn$_invoke$arity$variadic(re_com.validate.extract_arg_data(re_com.typeahead.typeahead_args_desc),args__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["typeahead"], 0)))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__88764 = cljs.core.deref(state_atom);
var map__88764__$1 = (((((!((map__88764 == null))))?(((((map__88764.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__88764.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__88764):map__88764);
var state__$1 = map__88764__$1;
var suggestions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88764__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var waiting_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88764__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215));
var suggestion_active_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88764__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var last_data_source = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(state__$1);
var width__$1 = (function (){var or__4131__auto__ = width;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "250px";
}
})();
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(last_data_source,data_source)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state_atom,re_com.typeahead.change_data_source,data_source);
} else {
}

return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead",new cljs.core.Keyword(null,"attr","attr",-604132353),attr,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.input_text,new cljs.core.Keyword(null,"model","model",331153215),input_text_model,new cljs.core.Keyword(null,"class","class",-2030961996),class$,new cljs.core.Keyword(null,"style","style",-496642736),style,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK_,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),status_icon_QMARK_,new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),status_tooltip,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_com.typeahead.input_text_on_change_BANG_,state_atom),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),false,new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-key-down","on-key-down",-1374733765),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(re_com.typeahead.input_text_on_key_down_BANG_,state_atom),new cljs.core.Keyword(null,"on-focus","on-focus",-13737624),((function (map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function (){
return cljs.core.List.EMPTY;
});})(map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,re_com.typeahead.input_text_will_blur);
});})(map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
], null)], null),(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.not_empty(suggestions);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return waiting_QMARK_;
}
})())?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-suggestions-container",new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"align","align",1964212802),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.throbber,new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"small","small",2133478704),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-throbber"], null)], null):null),(function (){var iter__4523__auto__ = ((function (map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function re_com$typeahead$iter__88766(s__88767){
return (new cljs.core.LazySeq(null,((function (map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function (){
var s__88767__$1 = s__88767;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__88767__$1);
if(temp__5818__auto__){
var s__88767__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__88767__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__88767__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__88769 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__88768 = (0);
while(true){
if((i__88768 < size__4522__auto__)){
var vec__88772 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__88768);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__88772,(0),null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__88772,(1),null);
var selected_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(suggestion_active_index,i);
cljs.core.chunk_append(b__88769,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?(render_suggestion.cljs$core$IFn$_invoke$arity$1 ? render_suggestion.cljs$core$IFn$_invoke$arity$1(s) : render_suggestion.call(null,s)):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",((selected_QMARK_)?" active":null)].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (i__88768,selected_QMARK_,vec__88772,i,s,c__4521__auto__,size__4522__auto__,b__88769,s__88767__$2,temp__5818__auto__,map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(i__88768,selected_QMARK_,vec__88772,i,s,c__4521__auto__,size__4522__auto__,b__88769,s__88767__$2,temp__5818__auto__,map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (i__88768,selected_QMARK_,vec__88772,i,s,c__4521__auto__,size__4522__auto__,b__88769,s__88767__$2,temp__5818__auto__,map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function (p1__88742_SHARP_){
p1__88742_SHARP_.preventDefault();

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(i__88768,selected_QMARK_,vec__88772,i,s,c__4521__auto__,size__4522__auto__,b__88769,s__88767__$2,temp__5818__auto__,map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)));

var G__89013 = (i__88768 + (1));
i__88768 = G__89013;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__88769),re_com$typeahead$iter__88766(cljs.core.chunk_rest(s__88767__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__88769),null);
}
} else {
var vec__88781 = cljs.core.first(s__88767__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__88781,(0),null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__88781,(1),null);
var selected_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(suggestion_active_index,i);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?(render_suggestion.cljs$core$IFn$_invoke$arity$1 ? render_suggestion.cljs$core$IFn$_invoke$arity$1(s) : render_suggestion.call(null,s)):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",((selected_QMARK_)?" active":null)].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (selected_QMARK_,vec__88781,i,s,s__88767__$2,temp__5818__auto__,map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(selected_QMARK_,vec__88781,i,s,s__88767__$2,temp__5818__auto__,map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (selected_QMARK_,vec__88781,i,s,s__88767__$2,temp__5818__auto__,map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args){
return (function (p1__88742_SHARP_){
p1__88742_SHARP_.preventDefault();

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(selected_QMARK_,vec__88781,i,s,s__88767__$2,temp__5818__auto__,map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)),re_com$typeahead$iter__88766(cljs.core.rest(s__88767__$2)));
}
} else {
return null;
}
break;
}
});})(map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
,null,null));
});})(map__88764,map__88764__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,last_data_source,width__$1,map__88759,map__88759__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,attr,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,_immediate_model_update_QMARK_,status,class$,map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
;
return iter__4523__auto__(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$0(),suggestions));
})()], null)], null)], null):null)], null)], null);
};
var G__88988 = function (var_args){
var p__88758 = null;
if (arguments.length > 0) {
var G__89015__i = 0, G__89015__a = new Array(arguments.length -  0);
while (G__89015__i < G__89015__a.length) {G__89015__a[G__89015__i] = arguments[G__89015__i + 0]; ++G__89015__i;}
  p__88758 = new cljs.core.IndexedSeq(G__89015__a,0,null);
} 
return G__88988__delegate.call(this,p__88758);};
G__88988.cljs$lang$maxFixedArity = 0;
G__88988.cljs$lang$applyTo = (function (arglist__89016){
var p__88758 = cljs.core.seq(arglist__89016);
return G__88988__delegate(p__88758);
});
G__88988.cljs$core$IFn$_invoke$arity$variadic = G__88988__delegate;
return G__88988;
})()
;
;})(map__88753,map__88753__$1,state,c_search,c_input,state_atom,input_text_model,map__88751,map__88751__$1,args))
});

re_com.typeahead.typeahead.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
re_com.typeahead.typeahead.cljs$lang$applyTo = (function (seq88746){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq88746));
});

/**
 * Return a channel which will receive a value from the `in` channel only
 *   if no further value is received on the `in` channel in the next `ms` milliseconds.
 */
re_com.typeahead.debounce = (function re_com$typeahead$debounce(in$,ms){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__46663__auto___89017 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___89017,out){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___89017,out){
return (function (state_88842){
var state_val_88843 = (state_88842[(1)]);
if((state_val_88843 === (7))){
var inst_88795 = (state_88842[(2)]);
var state_88842__$1 = state_88842;
var statearr_88846_89018 = state_88842__$1;
(statearr_88846_89018[(2)] = inst_88795);

(statearr_88846_89018[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (1))){
var inst_88790 = null;
var state_88842__$1 = (function (){var statearr_88849 = state_88842;
(statearr_88849[(7)] = inst_88790);

return statearr_88849;
})();
var statearr_88850_89019 = state_88842__$1;
(statearr_88850_89019[(2)] = null);

(statearr_88850_89019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (4))){
var state_88842__$1 = state_88842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_88842__$1,(7),in$);
} else {
if((state_val_88843 === (15))){
var inst_88826 = (state_88842[(2)]);
var state_88842__$1 = (function (){var statearr_88851 = state_88842;
(statearr_88851[(8)] = inst_88826);

return statearr_88851;
})();
var statearr_88852_89021 = state_88842__$1;
(statearr_88852_89021[(2)] = null);

(statearr_88852_89021[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (13))){
var inst_88813 = (state_88842[(9)]);
var inst_88828 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_88813,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_88842__$1 = state_88842;
if(inst_88828){
var statearr_88853_89022 = state_88842__$1;
(statearr_88853_89022[(1)] = (16));

} else {
var statearr_88858_89023 = state_88842__$1;
(statearr_88858_89023[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (6))){
var inst_88799 = (state_88842[(10)]);
var inst_88798 = (state_88842[(2)]);
var inst_88799__$1 = cljs.core.async.timeout(ms);
var inst_88807 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_88808 = [in$,inst_88799__$1];
var inst_88809 = (new cljs.core.PersistentVector(null,2,(5),inst_88807,inst_88808,null));
var state_88842__$1 = (function (){var statearr_88859 = state_88842;
(statearr_88859[(11)] = inst_88798);

(statearr_88859[(10)] = inst_88799__$1);

return statearr_88859;
})();
return cljs.core.async.ioc_alts_BANG_(state_88842__$1,(8),inst_88809);
} else {
if((state_val_88843 === (17))){
var state_88842__$1 = state_88842;
var statearr_88860_89024 = state_88842__$1;
(statearr_88860_89024[(2)] = null);

(statearr_88860_89024[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (3))){
var inst_88839 = (state_88842[(2)]);
var state_88842__$1 = state_88842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_88842__$1,inst_88839);
} else {
if((state_val_88843 === (12))){
var inst_88798 = (state_88842[(11)]);
var state_88842__$1 = state_88842;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_88842__$1,(15),out,inst_88798);
} else {
if((state_val_88843 === (2))){
var inst_88790 = (state_88842[(7)]);
var inst_88792 = (inst_88790 == null);
var state_88842__$1 = state_88842;
if(cljs.core.truth_(inst_88792)){
var statearr_88861_89028 = state_88842__$1;
(statearr_88861_89028[(1)] = (4));

} else {
var statearr_88862_89029 = state_88842__$1;
(statearr_88862_89029[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (11))){
var inst_88836 = (state_88842[(2)]);
var inst_88790 = inst_88836;
var state_88842__$1 = (function (){var statearr_88864 = state_88842;
(statearr_88864[(7)] = inst_88790);

return statearr_88864;
})();
var statearr_88866_89030 = state_88842__$1;
(statearr_88866_89030[(2)] = null);

(statearr_88866_89030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (9))){
var inst_88811 = (state_88842[(12)]);
var inst_88819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_88811,(0),null);
var inst_88820 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_88811,(1),null);
var state_88842__$1 = (function (){var statearr_88867 = state_88842;
(statearr_88867[(13)] = inst_88820);

return statearr_88867;
})();
var statearr_88868_89031 = state_88842__$1;
(statearr_88868_89031[(2)] = inst_88819);

(statearr_88868_89031[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (5))){
var inst_88790 = (state_88842[(7)]);
var state_88842__$1 = state_88842;
var statearr_88869_89032 = state_88842__$1;
(statearr_88869_89032[(2)] = inst_88790);

(statearr_88869_89032[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (14))){
var inst_88834 = (state_88842[(2)]);
var state_88842__$1 = state_88842;
var statearr_88870_89033 = state_88842__$1;
(statearr_88870_89033[(2)] = inst_88834);

(statearr_88870_89033[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (16))){
var inst_88812 = (state_88842[(14)]);
var state_88842__$1 = state_88842;
var statearr_88871_89034 = state_88842__$1;
(statearr_88871_89034[(2)] = inst_88812);

(statearr_88871_89034[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (10))){
var inst_88799 = (state_88842[(10)]);
var inst_88813 = (state_88842[(9)]);
var inst_88823 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_88813,inst_88799);
var state_88842__$1 = state_88842;
if(inst_88823){
var statearr_88872_89035 = state_88842__$1;
(statearr_88872_89035[(1)] = (12));

} else {
var statearr_88873_89036 = state_88842__$1;
(statearr_88873_89036[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (18))){
var inst_88832 = (state_88842[(2)]);
var state_88842__$1 = state_88842;
var statearr_88874_89039 = state_88842__$1;
(statearr_88874_89039[(2)] = inst_88832);

(statearr_88874_89039[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_88843 === (8))){
var inst_88813 = (state_88842[(9)]);
var inst_88811 = (state_88842[(12)]);
var inst_88811__$1 = (state_88842[(2)]);
var inst_88812 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_88811__$1,(0),null);
var inst_88813__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_88811__$1,(1),null);
var inst_88814 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_88813__$1,in$);
var state_88842__$1 = (function (){var statearr_88877 = state_88842;
(statearr_88877[(9)] = inst_88813__$1);

(statearr_88877[(14)] = inst_88812);

(statearr_88877[(12)] = inst_88811__$1);

return statearr_88877;
})();
if(inst_88814){
var statearr_88878_89041 = state_88842__$1;
(statearr_88878_89041[(1)] = (9));

} else {
var statearr_88879_89042 = state_88842__$1;
(statearr_88879_89042[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___89017,out))
;
return ((function (switch__46368__auto__,c__46663__auto___89017,out){
return (function() {
var re_com$typeahead$debounce_$_state_machine__46369__auto__ = null;
var re_com$typeahead$debounce_$_state_machine__46369__auto____0 = (function (){
var statearr_88882 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_88882[(0)] = re_com$typeahead$debounce_$_state_machine__46369__auto__);

(statearr_88882[(1)] = (1));

return statearr_88882;
});
var re_com$typeahead$debounce_$_state_machine__46369__auto____1 = (function (state_88842){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_88842);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e88884){if((e88884 instanceof Object)){
var ex__46372__auto__ = e88884;
var statearr_88885_89043 = state_88842;
(statearr_88885_89043[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_88842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e88884;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89044 = state_88842;
state_88842 = G__89044;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
re_com$typeahead$debounce_$_state_machine__46369__auto__ = function(state_88842){
switch(arguments.length){
case 0:
return re_com$typeahead$debounce_$_state_machine__46369__auto____0.call(this);
case 1:
return re_com$typeahead$debounce_$_state_machine__46369__auto____1.call(this,state_88842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
re_com$typeahead$debounce_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$debounce_$_state_machine__46369__auto____0;
re_com$typeahead$debounce_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$debounce_$_state_machine__46369__auto____1;
return re_com$typeahead$debounce_$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___89017,out))
})();
var state__46665__auto__ = (function (){var statearr_88886 = f__46664__auto__();
(statearr_88886[(6)] = c__46663__auto___89017);

return statearr_88886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___89017,out))
);


return out;
});

//# sourceMappingURL=re_com.typeahead.js.map
