goog.provide('pretty_spec.printer');
goog.require('cljs.core');
goog.require('fipp.visit');
goog.require('fipp.edn');
goog.require('fipp.ednize');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fipp.visit.IVisitor}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
pretty_spec.printer.EdnPrinter = (function (symbols,ns_aliases,__meta,__extmap,__hash){
this.symbols = symbols;
this.ns_aliases = ns_aliases;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
pretty_spec.printer.EdnPrinter.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k85440,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__85464 = k85440;
var G__85464__$1 = (((G__85464 instanceof cljs.core.Keyword))?G__85464.fqn:null);
switch (G__85464__$1) {
case "symbols":
return self__.symbols;

break;
case "ns-aliases":
return self__.ns_aliases;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k85440,else__4388__auto__);

}
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__85471){
var vec__85472 = p__85471;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85472,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85472,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#pretty-spec.printer.EdnPrinter{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"symbols","symbols",1211743),self__.symbols],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821),self__.ns_aliases],null))], null),self__.__extmap));
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__85439){
var self__ = this;
var G__85439__$1 = this;
return (new cljs.core.RecordIter((0),G__85439__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"symbols","symbols",1211743),new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new pretty_spec.printer.EdnPrinter(self__.symbols,self__.ns_aliases,self__.__meta,self__.__extmap,self__.__hash));
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__85497 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (466488785 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__85497(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this85441,other85442){
var self__ = this;
var this85441__$1 = this;
return (((!((other85442 == null)))) && ((this85441__$1.constructor === other85442.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this85441__$1.symbols,other85442.symbols)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this85441__$1.ns_aliases,other85442.ns_aliases)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this85441__$1.__extmap,other85442.__extmap)));
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$ = cljs.core.PROTOCOL_SENTINEL;

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_record$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return fipp.visit.visit(this$__$1,fipp.ednize.record__GT_tagged(x));
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_meta$arity$3 = (function (this$,m,x){
var self__ = this;
var this$__$1 = this;
return fipp.visit.visit_STAR_(this$__$1,x);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_number$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0))], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_pattern$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0))], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_unknown$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return fipp.visit.visit(this$__$1,fipp.ednize.edn(x));
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_symbol$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
var x_SINGLEQUOTE_ = ((((cljs.core.qualified_symbol_QMARK_(x)) && (cljs.core.contains_QMARK_(self__.ns_aliases,cljs.core.namespace(x)))))?cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((function (){var G__85534 = cljs.core.namespace(x);
return (self__.ns_aliases.cljs$core$IFn$_invoke$arity$1 ? self__.ns_aliases.cljs$core$IFn$_invoke$arity$1(G__85534) : self__.ns_aliases.call(null,G__85534));
})(),cljs.core.name(x)):x);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x_SINGLEQUOTE_)], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_seq$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
var temp__5816__auto__ = (function (){var G__85537 = cljs.core.first(x);
return (self__.symbols.cljs$core$IFn$_invoke$arity$1 ? self__.symbols.cljs$core$IFn$_invoke$arity$1(G__85537) : self__.symbols.call(null,G__85537));
})();
if(cljs.core.truth_(temp__5816__auto__)){
var pretty = temp__5816__auto__;
return (pretty.cljs$core$IFn$_invoke$arity$2 ? pretty.cljs$core$IFn$_invoke$arity$2(this$__$1,x) : pretty.call(null,this$__$1,x));
} else {
return fipp.edn.pretty_coll(this$__$1,"(",x,new cljs.core.Keyword(null,"line","line",212345235),")",fipp.visit.visit);
}
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_boolean$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_tagged$arity$2 = (function (this$,p__85546){
var self__ = this;
var map__85547 = p__85546;
var map__85547__$1 = (((((!((map__85547 == null))))?(((((map__85547.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85547.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85547):map__85547);
var tag = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85547__$1,new cljs.core.Keyword(null,"tag","tag",-1290361223));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85547__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"group","group",582596132),"#",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([tag], 0)),fipp.visit.visit(this$__$1,form)], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_keyword$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
var x_SINGLEQUOTE_ = ((((cljs.core.qualified_keyword_QMARK_(x)) && (cljs.core.contains_QMARK_(self__.ns_aliases,cljs.core.namespace(x)))))?cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((function (){var G__85563 = cljs.core.namespace(x);
return (self__.ns_aliases.cljs$core$IFn$_invoke$arity$1 ? self__.ns_aliases.cljs$core$IFn$_invoke$arity$1(G__85563) : self__.ns_aliases.call(null,G__85563));
})(),cljs.core.name(x)):x);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x_SINGLEQUOTE_)], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_map$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return fipp.edn.pretty_coll(this$__$1,"{",x,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),",",new cljs.core.Keyword(null,"line","line",212345235)], null),"}",((function (this$__$1){
return (function (printer,p__85573){
var vec__85575 = p__85573;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85575,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85575,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),fipp.visit.visit(printer,k)," ",fipp.visit.visit(printer,v)], null);
});})(this$__$1))
);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_nil$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),"nil"], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_character$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0))], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_string$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0))], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_var$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)], null);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_set$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return fipp.edn.pretty_coll(this$__$1,"#{",x,new cljs.core.Keyword(null,"line","line",212345235),"}",fipp.visit.visit);
});

pretty_spec.printer.EdnPrinter.prototype.fipp$visit$IVisitor$visit_vector$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
return fipp.edn.pretty_coll(this$__$1,"[",x,new cljs.core.Keyword(null,"line","line",212345235),"]",fipp.visit.visit);
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821),null,new cljs.core.Keyword(null,"symbols","symbols",1211743),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new pretty_spec.printer.EdnPrinter(self__.symbols,self__.ns_aliases,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__85439){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__85609 = cljs.core.keyword_identical_QMARK_;
var expr__85610 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__85613 = new cljs.core.Keyword(null,"symbols","symbols",1211743);
var G__85614 = expr__85610;
return (pred__85609.cljs$core$IFn$_invoke$arity$2 ? pred__85609.cljs$core$IFn$_invoke$arity$2(G__85613,G__85614) : pred__85609.call(null,G__85613,G__85614));
})())){
return (new pretty_spec.printer.EdnPrinter(G__85439,self__.ns_aliases,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__85616 = new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821);
var G__85617 = expr__85610;
return (pred__85609.cljs$core$IFn$_invoke$arity$2 ? pred__85609.cljs$core$IFn$_invoke$arity$2(G__85616,G__85617) : pred__85609.call(null,G__85616,G__85617));
})())){
return (new pretty_spec.printer.EdnPrinter(self__.symbols,G__85439,self__.__meta,self__.__extmap,null));
} else {
return (new pretty_spec.printer.EdnPrinter(self__.symbols,self__.ns_aliases,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__85439),null));
}
}
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"symbols","symbols",1211743),self__.symbols,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821),self__.ns_aliases,null))], null),self__.__extmap));
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__85439){
var self__ = this;
var this__4384__auto____$1 = this;
return (new pretty_spec.printer.EdnPrinter(self__.symbols,self__.ns_aliases,G__85439,self__.__extmap,self__.__hash));
});

pretty_spec.printer.EdnPrinter.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

pretty_spec.printer.EdnPrinter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"symbols","symbols",1641743270,null),new cljs.core.Symbol(null,"ns-aliases","ns-aliases",-1364180948,null)], null);
});

pretty_spec.printer.EdnPrinter.cljs$lang$type = true;

pretty_spec.printer.EdnPrinter.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"pretty-spec.printer/EdnPrinter",null,(1),null));
});

pretty_spec.printer.EdnPrinter.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"pretty-spec.printer/EdnPrinter");
});

/**
 * Positional factory function for pretty-spec.printer/EdnPrinter.
 */
pretty_spec.printer.__GT_EdnPrinter = (function pretty_spec$printer$__GT_EdnPrinter(symbols,ns_aliases){
return (new pretty_spec.printer.EdnPrinter(symbols,ns_aliases,null,null,null));
});

/**
 * Factory function for pretty-spec.printer/EdnPrinter, taking a map of keywords to field values.
 */
pretty_spec.printer.map__GT_EdnPrinter = (function pretty_spec$printer$map__GT_EdnPrinter(G__85446){
var extmap__4424__auto__ = (function (){var G__85646 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__85446,new cljs.core.Keyword(null,"symbols","symbols",1211743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821)], 0));
if(cljs.core.record_QMARK_(G__85446)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__85646);
} else {
return G__85646;
}
})();
return (new pretty_spec.printer.EdnPrinter(new cljs.core.Keyword(null,"symbols","symbols",1211743).cljs$core$IFn$_invoke$arity$1(G__85446),new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821).cljs$core$IFn$_invoke$arity$1(G__85446),null,cljs.core.not_empty(extmap__4424__auto__),null));
});


//# sourceMappingURL=pretty_spec.printer.js.map
