goog.provide('flow_storm.tracer');
goog.require('cljs.core');
goog.require('taoensso.sente');
goog.require('cljs.core.async');
goog.require('editscript.core');
goog.require('editscript.edit');
if((typeof flow_storm !== 'undefined') && (typeof flow_storm.tracer !== 'undefined') && (typeof flow_storm.tracer.send_fn_a !== 'undefined')){
} else {
flow_storm.tracer.send_fn_a = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
if((typeof flow_storm !== 'undefined') && (typeof flow_storm.tracer !== 'undefined') && (typeof flow_storm.tracer.pre_conn_events_holder !== 'undefined')){
} else {
flow_storm.tracer.pre_conn_events_holder = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
flow_storm.tracer._STAR_flow_id_STAR_ = null;
flow_storm.tracer.get_timestamp = (function flow_storm$tracer$get_timestamp(){
return (new Date()).getTime();
});
flow_storm.tracer.serialize_val = (function flow_storm$tracer$serialize_val(v){
var _STAR_print_length_STAR__orig_val__68617 = cljs.core._STAR_print_length_STAR_;
var _STAR_print_length_STAR__temp_val__68618 = (function (){var or__4131__auto__ = cljs.core._STAR_print_length_STAR_;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (50);
}
})();
cljs.core._STAR_print_length_STAR_ = _STAR_print_length_STAR__temp_val__68618;

try{return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([v], 0));
}finally {cljs.core._STAR_print_length_STAR_ = _STAR_print_length_STAR__orig_val__68617;
}});
/**
 * Collect the event in a internal atom (`pre-conn-events-holder`).
 *   Ment to be used by the websocket ws-send to hold events
 *   while a connection to the debugger is not ready.
 */
flow_storm.tracer.hold_event = (function flow_storm$tracer$hold_event(event){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["[Holding]",event], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(flow_storm.tracer.pre_conn_events_holder,cljs.core.conj,event);
});
/**
 * Send the event thru the connected websocket. If the websocket
 *   connection is not ready, hold it in `pre-conn-events-holder`
 */
flow_storm.tracer.ws_send = (function flow_storm$tracer$ws_send(event){
var fexpr__68619 = (function (){var or__4131__auto__ = cljs.core.deref(flow_storm.tracer.send_fn_a);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return flow_storm.tracer.hold_event;
}
})();
return (fexpr__68619.cljs$core$IFn$_invoke$arity$1 ? fexpr__68619.cljs$core$IFn$_invoke$arity$1(event) : fexpr__68619.call(null,event));
});
/**
 * Instrumentation function. Sends the `:flow-storm/init-trace` trace
 */
flow_storm.tracer.init_trace = (function flow_storm$tracer$init_trace(p__68620,form){
var map__68621 = p__68620;
var map__68621__$1 = (((((!((map__68621 == null))))?(((((map__68621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68621):map__68621);
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68621__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var form_flow_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68621__$1,new cljs.core.Keyword(null,"form-flow-id","form-flow-id",-2099634612));
var flow_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68621__$1,new cljs.core.Keyword(null,"flow-id","flow-id",877639368));
var args_vec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68621__$1,new cljs.core.Keyword(null,"args-vec","args-vec",-1577275442));
var fn_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68621__$1,new cljs.core.Keyword(null,"fn-name","fn-name",-766594004));
var trace_data = (function (){var G__68623 = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flow-id","flow-id",877639368),flow_storm.tracer._STAR_flow_id_STAR_,new cljs.core.Keyword(null,"form-id","form-id",-158754567),form_id,new cljs.core.Keyword(null,"form-flow-id","form-flow-id",-2099634612),form_flow_id,new cljs.core.Keyword(null,"form","form",-1624062471),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0)),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),flow_storm.tracer.get_timestamp()], null);
var G__68623__$1 = (cljs.core.truth_(args_vec)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__68623,new cljs.core.Keyword(null,"args-vec","args-vec",-1577275442),flow_storm.tracer.serialize_val(args_vec)):G__68623);
var G__68623__$2 = (cljs.core.truth_(fn_name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__68623__$1,new cljs.core.Keyword(null,"fn-name","fn-name",-766594004),fn_name):G__68623__$1);
if(cljs.core.truth_(flow_id)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__68623__$2,new cljs.core.Keyword(null,"fixed-flow-id-starter?","fixed-flow-id-starter?",1558610388),true);
} else {
return G__68623__$2;
}
})();
return flow_storm.tracer.ws_send(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("flow-storm","init-trace","flow-storm/init-trace",-1182059410),trace_data], null));
});
/**
 * Instrumentation function. Sends the `:flow-storm/add-trace` trace and returns the result.
 */
flow_storm.tracer.trace_and_return = (function flow_storm$tracer$trace_and_return(result,err,p__68624,orig_form){
var map__68625 = p__68624;
var map__68625__$1 = (((((!((map__68625 == null))))?(((((map__68625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68625.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68625):map__68625);
var coor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68625__$1,new cljs.core.Keyword(null,"coor","coor",-270968493));
var outer_form_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68625__$1,new cljs.core.Keyword(null,"outer-form?","outer-form?",474054841));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68625__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var form_flow_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68625__$1,new cljs.core.Keyword(null,"form-flow-id","form-flow-id",-2099634612));
var trace_data = (function (){var G__68627 = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flow-id","flow-id",877639368),flow_storm.tracer._STAR_flow_id_STAR_,new cljs.core.Keyword(null,"form-id","form-id",-158754567),form_id,new cljs.core.Keyword(null,"form-flow-id","form-flow-id",-2099634612),form_flow_id,new cljs.core.Keyword(null,"coor","coor",-270968493),coor,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),flow_storm.tracer.get_timestamp()], null);
var G__68627__$1 = ((cljs.core.not(err))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__68627,new cljs.core.Keyword(null,"result","result",1415092211),flow_storm.tracer.serialize_val(result)):G__68627);
var G__68627__$2 = (cljs.core.truth_(err)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__68627__$1,new cljs.core.Keyword(null,"err","err",-2089457205),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("error","message","error/message",-502809098),new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err)], null)):G__68627__$1);
if(cljs.core.truth_(outer_form_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__68627__$2,new cljs.core.Keyword(null,"outer-form?","outer-form?",474054841),true);
} else {
return G__68627__$2;
}
})();
flow_storm.tracer.ws_send(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("flow-storm","add-trace","flow-storm/add-trace",683117365),trace_data], null));

return result;
});
/**
 * Instrumentation function. Sends the `:flow-storm/add-bind-trace` trace
 */
flow_storm.tracer.bound_trace = (function flow_storm$tracer$bound_trace(symb,val,p__68628){
var map__68629 = p__68628;
var map__68629__$1 = (((((!((map__68629 == null))))?(((((map__68629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68629.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68629):map__68629);
var coor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68629__$1,new cljs.core.Keyword(null,"coor","coor",-270968493));
var form_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68629__$1,new cljs.core.Keyword(null,"form-id","form-id",-158754567));
var form_flow_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68629__$1,new cljs.core.Keyword(null,"form-flow-id","form-flow-id",-2099634612));
var trace_data = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"flow-id","flow-id",877639368),flow_storm.tracer._STAR_flow_id_STAR_,new cljs.core.Keyword(null,"form-id","form-id",-158754567),form_id,new cljs.core.Keyword(null,"form-flow-id","form-flow-id",-2099634612),form_flow_id,new cljs.core.Keyword(null,"coor","coor",-270968493),coor,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),flow_storm.tracer.get_timestamp(),new cljs.core.Keyword(null,"symbol","symbol",-1038572696),cljs.core.name(symb),new cljs.core.Keyword(null,"value","value",305978217),flow_storm.tracer.serialize_val(val)], null);
return flow_storm.tracer.ws_send(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("flow-storm","add-bind-trace","flow-storm/add-bind-trace",-1542659014),trace_data], null));
});
/**
 * Sends the `:flow-storm/ref-init-trace` trace
 */
flow_storm.tracer.ref_init_trace = (function flow_storm$tracer$ref_init_trace(ref_id,ref_name,init_val){
var trace_data = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"ref-id","ref-id",-1783010884),ref_id,new cljs.core.Keyword(null,"ref-name","ref-name",269436002),ref_name,new cljs.core.Keyword(null,"init-val","init-val",-70272968),flow_storm.tracer.serialize_val(init_val),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),flow_storm.tracer.get_timestamp()], null);
return flow_storm.tracer.ws_send(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("flow-storm","ref-init-trace","flow-storm/ref-init-trace",431039399),trace_data], null));
});
/**
 * Sends the `:flow-storm/ref-trace` trace
 */
flow_storm.tracer.ref_trace = (function flow_storm$tracer$ref_trace(ref_id,patch){
var trace_data = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ref-id","ref-id",-1783010884),ref_id,new cljs.core.Keyword(null,"patch","patch",380775109),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([patch], 0)),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),flow_storm.tracer.get_timestamp()], null);
return flow_storm.tracer.ws_send(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("flow-storm","ref-trace","flow-storm/ref-trace",572659942),trace_data], null));
});
flow_storm.tracer.trace_ref = (function flow_storm$tracer$trace_ref(ref,p__68631){
var map__68632 = p__68631;
var map__68632__$1 = (((((!((map__68632 == null))))?(((((map__68632.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68632.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68632):map__68632);
var ref_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68632__$1,new cljs.core.Keyword(null,"ref-name","ref-name",269436002));
var ignore_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68632__$1,new cljs.core.Keyword(null,"ignore-keys","ignore-keys",-868783304));
var ref_id = cljs.core.hash(ref);
var rm_ignored_keys = ((function (ref_id,map__68632,map__68632__$1,ref_name,ignore_keys){
return (function (v){
if(((cljs.core.seq(ignore_keys)) && (cljs.core.map_QMARK_(v)))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc,v),ignore_keys);
} else {
return v;
}
});})(ref_id,map__68632,map__68632__$1,ref_name,ignore_keys))
;
var ref_init_val = rm_ignored_keys(cljs.core.deref(ref));
flow_storm.tracer.ref_init_trace(ref_id,ref_name,ref_init_val);

return cljs.core.add_watch(ref,new cljs.core.Keyword(null,"flow-storm","flow-storm",-1356628559),((function (ref_id,rm_ignored_keys,ref_init_val,map__68632,map__68632__$1,ref_name,ignore_keys){
return (function (_,___$1,old_value,new_value){
var patch = editscript.edit.get_edits(editscript.core.diff.cljs$core$IFn$_invoke$arity$2(rm_ignored_keys(old_value),rm_ignored_keys(new_value)));
if(cljs.core.seq(patch)){
return flow_storm.tracer.ref_trace(ref_id,patch);
} else {
return null;
}
});})(ref_id,rm_ignored_keys,ref_init_val,map__68632,map__68632__$1,ref_name,ignore_keys))
);
});
flow_storm.tracer.untrace_ref = (function flow_storm$tracer$untrace_ref(ref){
return cljs.core.remove_watch(ref,new cljs.core.Keyword(null,"flow-storm","flow-storm",-1356628559));
});
flow_storm.tracer.trace_tap = (function flow_storm$tracer$trace_tap(tap_id,tap_name,v){
var trace_data = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"tap-id","tap-id",781538523),tap_id,new cljs.core.Keyword(null,"tap-name","tap-name",1080506706),tap_name,new cljs.core.Keyword(null,"value","value",305978217),flow_storm.tracer.serialize_val(v),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),flow_storm.tracer.get_timestamp()], null);
return flow_storm.tracer.ws_send(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("flow-storm","tap-trace","flow-storm/tap-trace",-910804655),trace_data], null));
});
flow_storm.tracer.init_tap = (function flow_storm$tracer$init_tap(var_args){
var G__68635 = arguments.length;
switch (G__68635) {
case 0:
return flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$0 = (function (){
var rnd_id = cljs.core.rand_int((100000));
return flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$2(rnd_id,cljs.core.str.cljs$core$IFn$_invoke$arity$1(rnd_id));
});

flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$1 = (function (tap_name){
return flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$2(cljs.core.rand_int((100000)),tap_name);
});

flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$2 = (function (tap_id,tap_name){
var temp__5754__auto__ = (((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.add_tap !== 'undefined'))?(new cljs.core.Var((function (){
return cljs.core.add_tap;
}),cljs.core.with_meta(new cljs.core.Symbol("cljs.core","add-tap","cljs.core/add-tap",-238297040,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"add-tap","add-tap",-670481493,null),"cljs/core.cljs",(14),(1),(11531),(11531),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Adds f, a fn of one argument, to the tap set. This function will be called with\n  anything sent via tap>. Remember f in order to remove-tap",(cljs.core.truth_(cljs.core.add_tap)?cljs.core.add_tap.cljs$lang$test:null)]))):null);
if(cljs.core.truth_(temp__5754__auto__)){
var add_tap_fn = temp__5754__auto__;
var G__68636 = ((function (add_tap_fn,temp__5754__auto__){
return (function (v){
return flow_storm.tracer.trace_tap(tap_id,tap_name,v);
});})(add_tap_fn,temp__5754__auto__))
;
return (add_tap_fn.cljs$core$IFn$_invoke$arity$1 ? add_tap_fn.cljs$core$IFn$_invoke$arity$1(G__68636) : add_tap_fn.call(null,G__68636));
} else {
return null;
}
});

flow_storm.tracer.init_tap.cljs$lang$maxFixedArity = 2;

/**
 * Connects to the flow-storm debugger.
 *   When connection is ready, replies any events hold in `pre-conn-events-holder`
 */
flow_storm.tracer.connect = (function flow_storm$tracer$connect(var_args){
var G__68638 = arguments.length;
switch (G__68638) {
case 0:
return flow_storm.tracer.connect.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return flow_storm.tracer.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

flow_storm.tracer.connect.cljs$core$IFn$_invoke$arity$0 = (function (){
return flow_storm.tracer.connect.cljs$core$IFn$_invoke$arity$1(null);
});

flow_storm.tracer.connect.cljs$core$IFn$_invoke$arity$1 = (function (p__68639){
var map__68640 = p__68639;
var map__68640__$1 = (((((!((map__68640 == null))))?(((((map__68640.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68640.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68640):map__68640);
var host = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68640__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var port = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68640__$1,new cljs.core.Keyword(null,"port","port",1534937262));
var protocol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68640__$1,new cljs.core.Keyword(null,"protocol","protocol",652470118));
var tap_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68640__$1,new cljs.core.Keyword(null,"tap-name","tap-name",1080506706));
var map__68642 = taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic("/chsk","dummy-csrf-token",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"protocol","protocol",652470118),(function (){var or__4131__auto__ = protocol;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"http","http",382524695);
}
})(),new cljs.core.Keyword(null,"host","host",-1558485167),(function (){var or__4131__auto__ = host;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "localhost";
}
})(),new cljs.core.Keyword(null,"port","port",1534937262),(function (){var or__4131__auto__ = port;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (7722);
}
})()], null)], 0));
var map__68642__$1 = (((((!((map__68642 == null))))?(((((map__68642.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68642.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68642):map__68642);
var chsk = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68642__$1,new cljs.core.Keyword(null,"chsk","chsk",-863703081));
var ch_recv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68642__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68642__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68642__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
flow_storm.tracer.init_tap.cljs$core$IFn$_invoke$arity$1(tap_name);

return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(ch_recv,((function (map__68642,map__68642__$1,chsk,ch_recv,send_fn,state,map__68640,map__68640__$1,host,port,protocol,tap_name){
return (function (p__68644){
var map__68645 = p__68644;
var map__68645__$1 = (((((!((map__68645 == null))))?(((((map__68645.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68645.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__68645):map__68645);
var event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68645__$1,new cljs.core.Keyword(null,"event","event",301435442));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(event),new cljs.core.Keyword("chsk","state","chsk/state",-1991397620))){
var holded_events = cljs.core.deref(flow_storm.tracer.pre_conn_events_holder);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Ws connection ready, re playing ",cljs.core.count(holded_events),"events"], 0));

cljs.core.reset_BANG_(flow_storm.tracer.send_fn_a,send_fn);

var seq__68647_68678 = cljs.core.seq(holded_events);
var chunk__68648_68679 = null;
var count__68649_68680 = (0);
var i__68650_68681 = (0);
while(true){
if((i__68650_68681 < count__68649_68680)){
var ev_68682 = chunk__68648_68679.cljs$core$IIndexed$_nth$arity$2(null,i__68650_68681);
(send_fn.cljs$core$IFn$_invoke$arity$1 ? send_fn.cljs$core$IFn$_invoke$arity$1(ev_68682) : send_fn.call(null,ev_68682));


var G__68683 = seq__68647_68678;
var G__68684 = chunk__68648_68679;
var G__68685 = count__68649_68680;
var G__68686 = (i__68650_68681 + (1));
seq__68647_68678 = G__68683;
chunk__68648_68679 = G__68684;
count__68649_68680 = G__68685;
i__68650_68681 = G__68686;
continue;
} else {
var temp__5754__auto___68687 = cljs.core.seq(seq__68647_68678);
if(temp__5754__auto___68687){
var seq__68647_68690__$1 = temp__5754__auto___68687;
if(cljs.core.chunked_seq_QMARK_(seq__68647_68690__$1)){
var c__4550__auto___68691 = cljs.core.chunk_first(seq__68647_68690__$1);
var G__68692 = cljs.core.chunk_rest(seq__68647_68690__$1);
var G__68693 = c__4550__auto___68691;
var G__68694 = cljs.core.count(c__4550__auto___68691);
var G__68695 = (0);
seq__68647_68678 = G__68692;
chunk__68648_68679 = G__68693;
count__68649_68680 = G__68694;
i__68650_68681 = G__68695;
continue;
} else {
var ev_68697 = cljs.core.first(seq__68647_68690__$1);
(send_fn.cljs$core$IFn$_invoke$arity$1 ? send_fn.cljs$core$IFn$_invoke$arity$1(ev_68697) : send_fn.call(null,ev_68697));


var G__68698 = cljs.core.next(seq__68647_68690__$1);
var G__68699 = null;
var G__68700 = (0);
var G__68701 = (0);
seq__68647_68678 = G__68698;
chunk__68648_68679 = G__68699;
count__68649_68680 = G__68700;
i__68650_68681 = G__68701;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(flow_storm.tracer.pre_conn_events_holder,cljs.core.PersistentVector.EMPTY);
} else {
return null;
}
});})(map__68642,map__68642__$1,chsk,ch_recv,send_fn,state,map__68640,map__68640__$1,host,port,protocol,tap_name))
);
});

flow_storm.tracer.connect.cljs$lang$maxFixedArity = 1;


//# sourceMappingURL=flow_storm.tracer.js.map
