goog.provide('editscript.core');
goog.require('cljs.core');
goog.require('editscript.edit');
goog.require('editscript.patch');
goog.require('editscript.diff.quick');
goog.require('editscript.diff.a_star');
/**
 * Create an editscript to represent the transformations needed to turn a
 *   Clojure data structure `a` into another Clojure data structure `b`.
 * 
 *   This function accepts any nested Clojure data structures. In Clojure, those
 *   implement `IPersistentVector`, `IPersistentMap`, `IPersistentList`,
 *   and `IPersistentSet` will be treated as collections. The same are true for
 *   the corresponding deftypes in Clojurescript, such as `PersistentVector`,
 *   `PersistentMap`, and so on. Anything else are treated as atomic values.
 * 
 *   The editscript is represented as a vector of basic operations: add `:+`,
 *   delete `:-`, and replace `:r`. Each operation also include a path to the
 *   location of the operation, which is similar to the path vector in `update-in`.
 *   However, editscript path works for all above four collection types, not just
 *   associative ones. For `:+` and `:r`, a new value is also required.
 * 
 *   Currently, the default diffing algorithm, `:A*` aims to minimize the size of the
 *   resulting editscript.
 * 
 *   A faster alternative is `:quick` algorithm, which does
 *   not producing optimal diffing results. An `:algo` option can be used to choose
 *   the algorithm, i.e. `{:algo :quick}`.
 */
editscript.core.diff = (function editscript$core$diff(var_args){
var G__91710 = arguments.length;
switch (G__91710) {
case 2:
return editscript.core.diff.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return editscript.core.diff.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

editscript.core.diff.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return editscript.core.diff.cljs$core$IFn$_invoke$arity$3(a,b,cljs.core.PersistentArrayMap.EMPTY);
});

editscript.core.diff.cljs$core$IFn$_invoke$arity$3 = (function (a,b,p__91711){
var map__91712 = p__91711;
var map__91712__$1 = (((((!((map__91712 == null))))?(((((map__91712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__91712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__91712):map__91712);
var algo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__91712__$1,new cljs.core.Keyword(null,"algo","algo",1472048382));
var algo__$1 = (function (){var or__4131__auto__ = algo;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"A*","A*",413304642);
}
})();
var fexpr__91715 = (function (){var G__91716 = algo__$1;
var G__91716__$1 = (((G__91716 instanceof cljs.core.Keyword))?G__91716.fqn:null);
switch (G__91716__$1) {
case "A*":
return editscript.diff.a_star.diff;

break;
case "quick":
return editscript.diff.quick.diff;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__91716__$1)].join('')));

}
})();
return (fexpr__91715.cljs$core$IFn$_invoke$arity$2 ? fexpr__91715.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__91715.call(null,a,b));
});

editscript.core.diff.cljs$lang$maxFixedArity = 3;

/**
 * Apply the editscript `script` on `a` to produce `b`, assuming the
 *   script is the results of running  `(diff a b)`, such that
 *   `(= b (patch a (diff a b)))` is true
 */
editscript.core.patch = (function editscript$core$patch(a,script){
if((script instanceof editscript.edit.EditScript)){
} else {
throw (new Error("Assert failed: (instance? editscript.edit.EditScript script)"));
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__91717_SHARP_,p2__91718_SHARP_){
return editscript.patch.patch_STAR_(p1__91717_SHARP_,p2__91718_SHARP_);
}),a,editscript.edit.get_edits(script));
});

//# sourceMappingURL=editscript.core.js.map
