goog.provide('datascript.query');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('clojure.walk');
goog.require('datascript.db');
goog.require('me.tonsky.persistent_sorted_set.arrays');
goog.require('datascript.lru');
goog.require('datascript.impl.entity');
goog.require('datascript.parser');
goog.require('datascript.pull_api');
goog.require('datascript.pull_parser');
datascript.query.lru_cache_size = (100);



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
datascript.query.Context = (function (rels,sources,rules,__meta,__extmap,__hash){
this.rels = rels;
this.sources = sources;
this.rules = rules;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
datascript.query.Context.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

datascript.query.Context.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k73422,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__73429 = k73422;
var G__73429__$1 = (((G__73429 instanceof cljs.core.Keyword))?G__73429.fqn:null);
switch (G__73429__$1) {
case "rels":
return self__.rels;

break;
case "sources":
return self__.sources;

break;
case "rules":
return self__.rules;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k73422,else__4388__auto__);

}
});

datascript.query.Context.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__73432){
var vec__73433 = p__73432;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73433,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73433,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

datascript.query.Context.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#datascript.query.Context{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rels","rels",1770187185),self__.rels],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sources","sources",-321166424),self__.sources],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rules","rules",1198912366),self__.rules],null))], null),self__.__extmap));
});

datascript.query.Context.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__73421){
var self__ = this;
var G__73421__$1 = this;
return (new cljs.core.RecordIter((0),G__73421__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rels","rels",1770187185),new cljs.core.Keyword(null,"sources","sources",-321166424),new cljs.core.Keyword(null,"rules","rules",1198912366)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

datascript.query.Context.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

datascript.query.Context.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new datascript.query.Context(self__.rels,self__.sources,self__.rules,self__.__meta,self__.__extmap,self__.__hash));
});

datascript.query.Context.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
});

datascript.query.Context.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__73440 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1014232958 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__73440(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

datascript.query.Context.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this73423,other73424){
var self__ = this;
var this73423__$1 = this;
return (((!((other73424 == null)))) && ((this73423__$1.constructor === other73424.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73423__$1.rels,other73424.rels)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73423__$1.sources,other73424.sources)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73423__$1.rules,other73424.rules)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73423__$1.__extmap,other73424.__extmap)));
});

datascript.query.Context.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"sources","sources",-321166424),null,new cljs.core.Keyword(null,"rules","rules",1198912366),null,new cljs.core.Keyword(null,"rels","rels",1770187185),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new datascript.query.Context(self__.rels,self__.sources,self__.rules,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

datascript.query.Context.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__73421){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__73443 = cljs.core.keyword_identical_QMARK_;
var expr__73444 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__73446 = new cljs.core.Keyword(null,"rels","rels",1770187185);
var G__73447 = expr__73444;
return (pred__73443.cljs$core$IFn$_invoke$arity$2 ? pred__73443.cljs$core$IFn$_invoke$arity$2(G__73446,G__73447) : pred__73443.call(null,G__73446,G__73447));
})())){
return (new datascript.query.Context(G__73421,self__.sources,self__.rules,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73452 = new cljs.core.Keyword(null,"sources","sources",-321166424);
var G__73453 = expr__73444;
return (pred__73443.cljs$core$IFn$_invoke$arity$2 ? pred__73443.cljs$core$IFn$_invoke$arity$2(G__73452,G__73453) : pred__73443.call(null,G__73452,G__73453));
})())){
return (new datascript.query.Context(self__.rels,G__73421,self__.rules,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73454 = new cljs.core.Keyword(null,"rules","rules",1198912366);
var G__73455 = expr__73444;
return (pred__73443.cljs$core$IFn$_invoke$arity$2 ? pred__73443.cljs$core$IFn$_invoke$arity$2(G__73454,G__73455) : pred__73443.call(null,G__73454,G__73455));
})())){
return (new datascript.query.Context(self__.rels,self__.sources,G__73421,self__.__meta,self__.__extmap,null));
} else {
return (new datascript.query.Context(self__.rels,self__.sources,self__.rules,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__73421),null));
}
}
}
});

datascript.query.Context.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rels","rels",1770187185),self__.rels,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sources","sources",-321166424),self__.sources,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rules","rules",1198912366),self__.rules,null))], null),self__.__extmap));
});

datascript.query.Context.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__73421){
var self__ = this;
var this__4384__auto____$1 = this;
return (new datascript.query.Context(self__.rels,self__.sources,self__.rules,G__73421,self__.__extmap,self__.__hash));
});

datascript.query.Context.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

datascript.query.Context.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"rels","rels",-884248584,null),new cljs.core.Symbol(null,"sources","sources",1319365103,null),new cljs.core.Symbol(null,"rules","rules",-1455523403,null)], null);
});

datascript.query.Context.cljs$lang$type = true;

datascript.query.Context.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"datascript.query/Context",null,(1),null));
});

datascript.query.Context.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"datascript.query/Context");
});

/**
 * Positional factory function for datascript.query/Context.
 */
datascript.query.__GT_Context = (function datascript$query$__GT_Context(rels,sources,rules){
return (new datascript.query.Context(rels,sources,rules,null,null,null));
});

/**
 * Factory function for datascript.query/Context, taking a map of keywords to field values.
 */
datascript.query.map__GT_Context = (function datascript$query$map__GT_Context(G__73425){
var extmap__4424__auto__ = (function (){var G__73470 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__73425,new cljs.core.Keyword(null,"rels","rels",1770187185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"sources","sources",-321166424),new cljs.core.Keyword(null,"rules","rules",1198912366)], 0));
if(cljs.core.record_QMARK_(G__73425)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__73470);
} else {
return G__73470;
}
})();
return (new datascript.query.Context(new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(G__73425),new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(G__73425),new cljs.core.Keyword(null,"rules","rules",1198912366).cljs$core$IFn$_invoke$arity$1(G__73425),null,cljs.core.not_empty(extmap__4424__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
datascript.query.Relation = (function (attrs,tuples,__meta,__extmap,__hash){
this.attrs = attrs;
this.tuples = tuples;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
datascript.query.Relation.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

datascript.query.Relation.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k73473,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__73478 = k73473;
var G__73478__$1 = (((G__73478 instanceof cljs.core.Keyword))?G__73478.fqn:null);
switch (G__73478__$1) {
case "attrs":
return self__.attrs;

break;
case "tuples":
return self__.tuples;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k73473,else__4388__auto__);

}
});

datascript.query.Relation.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__73479){
var vec__73480 = p__73479;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73480,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73480,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

datascript.query.Relation.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#datascript.query.Relation{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"attrs","attrs",-2090668713),self__.attrs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tuples","tuples",-676032639),self__.tuples],null))], null),self__.__extmap));
});

datascript.query.Relation.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__73472){
var self__ = this;
var G__73472__$1 = this;
return (new cljs.core.RecordIter((0),G__73472__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.Keyword(null,"tuples","tuples",-676032639)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

datascript.query.Relation.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

datascript.query.Relation.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new datascript.query.Relation(self__.attrs,self__.tuples,self__.__meta,self__.__extmap,self__.__hash));
});

datascript.query.Relation.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

datascript.query.Relation.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__73490 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1107093117 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__73490(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

datascript.query.Relation.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this73474,other73475){
var self__ = this;
var this73474__$1 = this;
return (((!((other73475 == null)))) && ((this73474__$1.constructor === other73475.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73474__$1.attrs,other73475.attrs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73474__$1.tuples,other73475.tuples)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this73474__$1.__extmap,other73475.__extmap)));
});

datascript.query.Relation.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),null,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new datascript.query.Relation(self__.attrs,self__.tuples,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

datascript.query.Relation.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__73472){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__73491 = cljs.core.keyword_identical_QMARK_;
var expr__73492 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__73494 = new cljs.core.Keyword(null,"attrs","attrs",-2090668713);
var G__73495 = expr__73492;
return (pred__73491.cljs$core$IFn$_invoke$arity$2 ? pred__73491.cljs$core$IFn$_invoke$arity$2(G__73494,G__73495) : pred__73491.call(null,G__73494,G__73495));
})())){
return (new datascript.query.Relation(G__73472,self__.tuples,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__73496 = new cljs.core.Keyword(null,"tuples","tuples",-676032639);
var G__73497 = expr__73492;
return (pred__73491.cljs$core$IFn$_invoke$arity$2 ? pred__73491.cljs$core$IFn$_invoke$arity$2(G__73496,G__73497) : pred__73491.call(null,G__73496,G__73497));
})())){
return (new datascript.query.Relation(self__.attrs,G__73472,self__.__meta,self__.__extmap,null));
} else {
return (new datascript.query.Relation(self__.attrs,self__.tuples,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__73472),null));
}
}
});

datascript.query.Relation.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"attrs","attrs",-2090668713),self__.attrs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tuples","tuples",-676032639),self__.tuples,null))], null),self__.__extmap));
});

datascript.query.Relation.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__73472){
var self__ = this;
var this__4384__auto____$1 = this;
return (new datascript.query.Relation(self__.attrs,self__.tuples,G__73472,self__.__extmap,self__.__hash));
});

datascript.query.Relation.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

datascript.query.Relation.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"tuples","tuples",964498888,null)], null);
});

datascript.query.Relation.cljs$lang$type = true;

datascript.query.Relation.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"datascript.query/Relation",null,(1),null));
});

datascript.query.Relation.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"datascript.query/Relation");
});

/**
 * Positional factory function for datascript.query/Relation.
 */
datascript.query.__GT_Relation = (function datascript$query$__GT_Relation(attrs,tuples){
return (new datascript.query.Relation(attrs,tuples,null,null,null));
});

/**
 * Factory function for datascript.query/Relation, taking a map of keywords to field values.
 */
datascript.query.map__GT_Relation = (function datascript$query$map__GT_Relation(G__73476){
var extmap__4424__auto__ = (function (){var G__73505 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__73476,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"tuples","tuples",-676032639)], 0));
if(cljs.core.record_QMARK_(G__73476)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__73505);
} else {
return G__73505;
}
})();
return (new datascript.query.Relation(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(G__73476),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(G__73476),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

datascript.query.single = (function datascript$query$single(coll){
if((cljs.core.next(coll) == null)){
} else {
throw (new Error(["Assert failed: ","Expected single element","\n","(nil? (next coll))"].join('')));
}

return cljs.core.first(coll);
});
datascript.query.intersect_keys = (function datascript$query$intersect_keys(attrs1,attrs2){
return clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(attrs1)),cljs.core.set(cljs.core.keys(attrs2)));
});
datascript.query.concatv = (function datascript$query$concatv(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74283 = arguments.length;
var i__4731__auto___74284 = (0);
while(true){
if((i__4731__auto___74284 < len__4730__auto___74283)){
args__4736__auto__.push((arguments[i__4731__auto___74284]));

var G__74290 = (i__4731__auto___74284 + (1));
i__4731__auto___74284 = G__74290;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return datascript.query.concatv.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

datascript.query.concatv.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.cat,xs);
});

datascript.query.concatv.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
datascript.query.concatv.cljs$lang$applyTo = (function (seq73508){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq73508));
});

datascript.query.zip = (function datascript$query$zip(var_args){
var G__73513 = arguments.length;
switch (G__73513) {
case 2:
return datascript.query.zip.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___74294 = arguments.length;
var i__4731__auto___74295 = (0);
while(true){
if((i__4731__auto___74295 < len__4730__auto___74294)){
args_arr__4751__auto__.push((arguments[i__4731__auto___74295]));

var G__74296 = (i__4731__auto___74295 + (1));
i__4731__auto___74295 = G__74296;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return datascript.query.zip.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

datascript.query.zip.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,a,b);
});

datascript.query.zip.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,rest){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.mapv,cljs.core.vector,a,b,rest);
});

/** @this {Function} */
datascript.query.zip.cljs$lang$applyTo = (function (seq73510){
var G__73511 = cljs.core.first(seq73510);
var seq73510__$1 = cljs.core.next(seq73510);
var G__73512 = cljs.core.first(seq73510__$1);
var seq73510__$2 = cljs.core.next(seq73510__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73511,G__73512,seq73510__$2);
});

datascript.query.zip.cljs$lang$maxFixedArity = (2);

datascript.query.same_keys_QMARK_ = (function datascript$query$same_keys_QMARK_(a,b){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(a),cljs.core.count(b))) && (cljs.core.every_QMARK_((function (p1__73514_SHARP_){
return cljs.core.contains_QMARK_(b,p1__73514_SHARP_);
}),cljs.core.keys(a))) && (cljs.core.every_QMARK_((function (p1__73515_SHARP_){
return cljs.core.contains_QMARK_(b,p1__73515_SHARP_);
}),cljs.core.keys(a))));
});
datascript.query.looks_like_QMARK_ = (function datascript$query$looks_like_QMARK_(pattern,form){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"_","_",-1201019570,null),pattern)){
return true;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"*","*",345799209,null)], null),pattern)){
return cljs.core.sequential_QMARK_(form);
} else {
if((pattern instanceof cljs.core.Symbol)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,pattern);
} else {
if(cljs.core.sequential_QMARK_(pattern)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(pattern),new cljs.core.Symbol(null,"*","*",345799209,null))){
return ((cljs.core.sequential_QMARK_(form)) && (cljs.core.every_QMARK_((function (p__73520){
var vec__73521 = p__73520;
var pattern_el = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73521,(0),null);
var form_el = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73521,(1),null);
return (datascript.query.looks_like_QMARK_.cljs$core$IFn$_invoke$arity$2 ? datascript.query.looks_like_QMARK_.cljs$core$IFn$_invoke$arity$2(pattern_el,form_el) : datascript.query.looks_like_QMARK_.call(null,pattern_el,form_el));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.butlast(pattern),form))));
} else {
return ((cljs.core.sequential_QMARK_(form)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(form),cljs.core.count(pattern))) && (cljs.core.every_QMARK_((function (p__73528){
var vec__73529 = p__73528;
var pattern_el = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73529,(0),null);
var form_el = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73529,(1),null);
return (datascript.query.looks_like_QMARK_.cljs$core$IFn$_invoke$arity$2 ? datascript.query.looks_like_QMARK_.cljs$core$IFn$_invoke$arity$2(pattern_el,form_el) : datascript.query.looks_like_QMARK_.call(null,pattern_el,form_el));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,pattern,form))));
}
} else {
return (pattern.cljs$core$IFn$_invoke$arity$1 ? pattern.cljs$core$IFn$_invoke$arity$1(form) : pattern.call(null,form));

}
}
}
}
});
datascript.query.source_QMARK_ = (function datascript$query$source_QMARK_(sym){
return (((sym instanceof cljs.core.Symbol)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$",cljs.core.first(cljs.core.name(sym)))));
});
datascript.query.free_var_QMARK_ = (function datascript$query$free_var_QMARK_(sym){
return (((sym instanceof cljs.core.Symbol)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("?",cljs.core.first(cljs.core.name(sym)))));
});
datascript.query.attr_QMARK_ = (function datascript$query$attr_QMARK_(form){
return (((form instanceof cljs.core.Keyword)) || (typeof form === 'string'));
});
datascript.query.lookup_ref_QMARK_ = (function datascript$query$lookup_ref_QMARK_(form){
return datascript.query.looks_like_QMARK_(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [datascript.query.attr_QMARK_,new cljs.core.Symbol(null,"_","_",-1201019570,null)], null),form);
});
datascript.query.join_tuples = (function datascript$query$join_tuples(t1,idxs1,t2,idxs2){
var l1 = idxs1.length;
var l2 = idxs2.length;
var res = me.tonsky.persistent_sorted_set.arrays.make_array((l1 + l2));
var n__4607__auto___74319 = l1;
var i_74320 = (0);
while(true){
if((i_74320 < n__4607__auto___74319)){
(res[i_74320] = (t1[(idxs1[i_74320])]));

var G__74322 = (i_74320 + (1));
i_74320 = G__74322;
continue;
} else {
}
break;
}

var n__4607__auto___74323 = l2;
var i_74324 = (0);
while(true){
if((i_74324 < n__4607__auto___74323)){
(res[(l1 + i_74324)] = (t2[(idxs2[i_74324])]));

var G__74325 = (i_74324 + (1));
i_74324 = G__74325;
continue;
} else {
}
break;
}

return res;
});
datascript.query.sum_rel = (function datascript$query$sum_rel(a,b){
var map__73537 = a;
var map__73537__$1 = (((((!((map__73537 == null))))?(((((map__73537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73537.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__73537):map__73537);
var attrs_a = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73537__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var tuples_a = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73537__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var map__73538 = b;
var map__73538__$1 = (((((!((map__73538 == null))))?(((((map__73538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73538.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__73538):map__73538);
var attrs_b = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73538__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var tuples_b = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73538__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(attrs_a,attrs_b)){
return (new datascript.query.Relation(attrs_a,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(tuples_a),tuples_b),null,null,null));
} else {
if((!(datascript.query.same_keys_QMARK_(attrs_a,attrs_b)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can\u2019t sum relations with different attrs: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([attrs_a], 0))," and ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([attrs_b], 0))].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","where","query/where",-1935159429)], null));
} else {
if(cljs.core.every_QMARK_(cljs.core.number_QMARK_,cljs.core.vals(attrs_a))){
var idxb__GT_idxa = cljs.core.vec((function (){var iter__4523__auto__ = ((function (map__73537,map__73537__$1,attrs_a,tuples_a,map__73538,map__73538__$1,attrs_b,tuples_b){
return (function datascript$query$sum_rel_$_iter__73541(s__73542){
return (new cljs.core.LazySeq(null,((function (map__73537,map__73537__$1,attrs_a,tuples_a,map__73538,map__73538__$1,attrs_b,tuples_b){
return (function (){
var s__73542__$1 = s__73542;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__73542__$1);
if(temp__5818__auto__){
var s__73542__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__73542__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__73542__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__73544 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__73543 = (0);
while(true){
if((i__73543 < size__4522__auto__)){
var vec__73545 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__73543);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73545,(0),null);
var idx_b = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73545,(1),null);
cljs.core.chunk_append(b__73544,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx_b,(attrs_a.cljs$core$IFn$_invoke$arity$1 ? attrs_a.cljs$core$IFn$_invoke$arity$1(sym) : attrs_a.call(null,sym))], null));

var G__74336 = (i__73543 + (1));
i__73543 = G__74336;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__73544),datascript$query$sum_rel_$_iter__73541(cljs.core.chunk_rest(s__73542__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__73544),null);
}
} else {
var vec__73548 = cljs.core.first(s__73542__$2);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73548,(0),null);
var idx_b = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73548,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx_b,(attrs_a.cljs$core$IFn$_invoke$arity$1 ? attrs_a.cljs$core$IFn$_invoke$arity$1(sym) : attrs_a.call(null,sym))], null),datascript$query$sum_rel_$_iter__73541(cljs.core.rest(s__73542__$2)));
}
} else {
return null;
}
break;
}
});})(map__73537,map__73537__$1,attrs_a,tuples_a,map__73538,map__73538__$1,attrs_b,tuples_b))
,null,null));
});})(map__73537,map__73537__$1,attrs_a,tuples_a,map__73538,map__73538__$1,attrs_b,tuples_b))
;
return iter__4523__auto__(attrs_b);
})());
var tlen = (cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.vals(attrs_a)) + (1));
var tuples_SINGLEQUOTE_ = cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (idxb__GT_idxa,tlen,map__73537,map__73537__$1,attrs_a,tuples_a,map__73538,map__73538__$1,attrs_b,tuples_b){
return (function (acc,tuple_b){
var tuple_SINGLEQUOTE_ = me.tonsky.persistent_sorted_set.arrays.make_array(tlen);
var seq__73553_74344 = cljs.core.seq(idxb__GT_idxa);
var chunk__73554_74345 = null;
var count__73555_74346 = (0);
var i__73556_74347 = (0);
while(true){
if((i__73556_74347 < count__73555_74346)){
var vec__73564_74348 = chunk__73554_74345.cljs$core$IIndexed$_nth$arity$2(null,i__73556_74347);
var idx_b_74349 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73564_74348,(0),null);
var idx_a_74350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73564_74348,(1),null);
(tuple_SINGLEQUOTE_[idx_a_74350] = (tuple_b[idx_b_74349]));


var G__74352 = seq__73553_74344;
var G__74353 = chunk__73554_74345;
var G__74354 = count__73555_74346;
var G__74355 = (i__73556_74347 + (1));
seq__73553_74344 = G__74352;
chunk__73554_74345 = G__74353;
count__73555_74346 = G__74354;
i__73556_74347 = G__74355;
continue;
} else {
var temp__5818__auto___74356 = cljs.core.seq(seq__73553_74344);
if(temp__5818__auto___74356){
var seq__73553_74358__$1 = temp__5818__auto___74356;
if(cljs.core.chunked_seq_QMARK_(seq__73553_74358__$1)){
var c__4550__auto___74359 = cljs.core.chunk_first(seq__73553_74358__$1);
var G__74360 = cljs.core.chunk_rest(seq__73553_74358__$1);
var G__74361 = c__4550__auto___74359;
var G__74362 = cljs.core.count(c__4550__auto___74359);
var G__74363 = (0);
seq__73553_74344 = G__74360;
chunk__73554_74345 = G__74361;
count__73555_74346 = G__74362;
i__73556_74347 = G__74363;
continue;
} else {
var vec__73567_74364 = cljs.core.first(seq__73553_74358__$1);
var idx_b_74365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73567_74364,(0),null);
var idx_a_74366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73567_74364,(1),null);
(tuple_SINGLEQUOTE_[idx_a_74366] = (tuple_b[idx_b_74365]));


var G__74367 = cljs.core.next(seq__73553_74358__$1);
var G__74368 = null;
var G__74369 = (0);
var G__74370 = (0);
seq__73553_74344 = G__74367;
chunk__73554_74345 = G__74368;
count__73555_74346 = G__74369;
i__73556_74347 = G__74370;
continue;
}
} else {
}
}
break;
}

return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(acc,tuple_SINGLEQUOTE_);
});})(idxb__GT_idxa,tlen,map__73537,map__73537__$1,attrs_a,tuples_a,map__73538,map__73538__$1,attrs_b,tuples_b))
,cljs.core.transient$(cljs.core.vec(tuples_a)),tuples_b));
return (new datascript.query.Relation(attrs_a,tuples_SINGLEQUOTE_,null,null,null));
} else {
var all_attrs = cljs.core.zipmap(cljs.core.keys(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([attrs_a,attrs_b], 0))),cljs.core.range.cljs$core$IFn$_invoke$arity$0());
var G__73572 = (function (){var G__73574 = (new datascript.query.Relation(all_attrs,cljs.core.PersistentVector.EMPTY,null,null,null));
var G__73575 = a;
return (datascript.query.sum_rel.cljs$core$IFn$_invoke$arity$2 ? datascript.query.sum_rel.cljs$core$IFn$_invoke$arity$2(G__73574,G__73575) : datascript.query.sum_rel.call(null,G__73574,G__73575));
})();
var G__73573 = b;
return (datascript.query.sum_rel.cljs$core$IFn$_invoke$arity$2 ? datascript.query.sum_rel.cljs$core$IFn$_invoke$arity$2(G__73572,G__73573) : datascript.query.sum_rel.call(null,G__73572,G__73573));

}
}
}
});
datascript.query.prod_rel = (function datascript$query$prod_rel(var_args){
var G__73577 = arguments.length;
switch (G__73577) {
case 0:
return datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$0();

break;
case 2:
return datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new datascript.query.Relation(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [me.tonsky.persistent_sorted_set.arrays.make_array((0))], null),null,null,null));
});

datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$2 = (function (rel1,rel2){
var attrs1 = cljs.core.keys(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel1));
var attrs2 = cljs.core.keys(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel2));
var idxs1 = cljs.core.to_array(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel1),attrs1));
var idxs2 = cljs.core.to_array(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel2),attrs2));
return (new datascript.query.Relation(cljs.core.zipmap(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(attrs1,attrs2),cljs.core.range.cljs$core$IFn$_invoke$arity$0()),cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attrs1,attrs2,idxs1,idxs2){
return (function (acc,t1){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (attrs1,attrs2,idxs1,idxs2){
return (function (acc__$1,t2){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(acc__$1,datascript.query.join_tuples(t1,idxs1,t2,idxs2));
});})(attrs1,attrs2,idxs1,idxs2))
,acc,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(rel2));
});})(attrs1,attrs2,idxs1,idxs2))
,cljs.core.transient$(cljs.core.PersistentVector.EMPTY),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(rel1))),null,null,null));
});

datascript.query.prod_rel.cljs$lang$maxFixedArity = 2;

datascript.query._differ_QMARK_ = (function datascript$query$_differ_QMARK_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74384 = arguments.length;
var i__4731__auto___74385 = (0);
while(true){
if((i__4731__auto___74385 < len__4730__auto___74384)){
args__4736__auto__.push((arguments[i__4731__auto___74385]));

var G__74387 = (i__4731__auto___74385 + (1));
i__4731__auto___74385 = G__74387;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return datascript.query._differ_QMARK_.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

datascript.query._differ_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var l = cljs.core.count(xs);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.take.cljs$core$IFn$_invoke$arity$2((l / (2)),xs),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((l / (2)),xs));
});

datascript.query._differ_QMARK_.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
datascript.query._differ_QMARK_.cljs$lang$applyTo = (function (seq73578){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq73578));
});

datascript.query._get_else = (function datascript$query$_get_else(db,e,a,else_val){
if((else_val == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("get-else: nil default value is not supported",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","where","query/where",-1935159429)], null));
} else {
}

var temp__5820__auto__ = cljs.core.first(datascript.db._search(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,a], null)));
if((temp__5820__auto__ == null)){
return else_val;
} else {
var datom = temp__5820__auto__;
return new cljs.core.Keyword(null,"v","v",21465059).cljs$core$IFn$_invoke$arity$1(datom);
}
});
datascript.query._get_some = (function datascript$query$_get_some(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74390 = arguments.length;
var i__4731__auto___74391 = (0);
while(true){
if((i__4731__auto___74391 < len__4730__auto___74390)){
args__4736__auto__.push((arguments[i__4731__auto___74391]));

var G__74392 = (i__4731__auto___74391 + (1));
i__4731__auto___74391 = G__74392;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return datascript.query._get_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

datascript.query._get_some.cljs$core$IFn$_invoke$arity$variadic = (function (db,e,as){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (_,a){
var temp__5822__auto__ = cljs.core.first(datascript.db._search(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,a], null)));
if((temp__5822__auto__ == null)){
return null;
} else {
var datom = temp__5822__auto__;
return cljs.core.reduced(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586).cljs$core$IFn$_invoke$arity$1(datom),new cljs.core.Keyword(null,"v","v",21465059).cljs$core$IFn$_invoke$arity$1(datom)], null));
}
}),null,as);
});

datascript.query._get_some.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
datascript.query._get_some.cljs$lang$applyTo = (function (seq73581){
var G__73582 = cljs.core.first(seq73581);
var seq73581__$1 = cljs.core.next(seq73581);
var G__73583 = cljs.core.first(seq73581__$1);
var seq73581__$2 = cljs.core.next(seq73581__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73582,G__73583,seq73581__$2);
});

datascript.query._missing_QMARK_ = (function datascript$query$_missing_QMARK_(db,e,a){
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2(datascript.impl.entity.entity(db,e),a) == null);
});
datascript.query.and_fn = (function datascript$query$and_fn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74401 = arguments.length;
var i__4731__auto___74402 = (0);
while(true){
if((i__4731__auto___74402 < len__4730__auto___74401)){
args__4736__auto__.push((arguments[i__4731__auto___74402]));

var G__74405 = (i__4731__auto___74402 + (1));
i__4731__auto___74402 = G__74405;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return datascript.query.and_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

datascript.query.and_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (a,b){
if(cljs.core.truth_(b)){
return b;
} else {
return cljs.core.reduced(b);
}
}),true,args);
});

datascript.query.and_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
datascript.query.and_fn.cljs$lang$applyTo = (function (seq73587){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq73587));
});

datascript.query.or_fn = (function datascript$query$or_fn(var_args){
var args__4736__auto__ = [];
var len__4730__auto___74408 = arguments.length;
var i__4731__auto___74409 = (0);
while(true){
if((i__4731__auto___74409 < len__4730__auto___74408)){
args__4736__auto__.push((arguments[i__4731__auto___74409]));

var G__74411 = (i__4731__auto___74409 + (1));
i__4731__auto___74409 = G__74411;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return datascript.query.or_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

datascript.query.or_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (a,b){
if(cljs.core.truth_(b)){
return cljs.core.reduced(b);
} else {
return b;
}
}),null,args);
});

datascript.query.or_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
datascript.query.or_fn.cljs$lang$applyTo = (function (seq73590){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq73590));
});

datascript.query.built_ins = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"true?","true?",-1600332395,null),new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.Symbol(null,"odd?","odd?",-1458588199,null),new cljs.core.Symbol(null,"get-else","get-else",1312024065,null),new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"print-str","print-str",-699700354,null),new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"get-some","get-some",409442058,null),new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.Symbol(null,"false?","false?",-1522377573,null),new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.Symbol(null,"identity","identity",-1007039734,null),new cljs.core.Symbol(null,"-differ?","-differ?",1465687357,null),new cljs.core.Symbol(null,"re-seq","re-seq",-2105554076,null),new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol("clojure.string","starts-with?","clojure.string/starts-with?",656256322,null),new cljs.core.Symbol(null,"=","=",-1501502141,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"missing?","missing?",-1710383910,null),new cljs.core.Symbol(null,"ground","ground",-1460862835,null),new cljs.core.Symbol(null,"rand-int","rand-int",-495012157,null),new cljs.core.Symbol(null,"complement","complement",-913606051,null),new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.Symbol(null,"hash-map","hash-map",-439030950,null),new cljs.core.Symbol(null,"compare","compare",1109853757,null),new cljs.core.Symbol(null,"range","range",-1014743483,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.Symbol(null,"pr-str","pr-str",-2066912145,null),new cljs.core.Symbol(null,"println-str","println-str",-2049216703,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"zero?","zero?",325758897,null),new cljs.core.Symbol(null,"!=","!=",-201205829,null),new cljs.core.Symbol(null,"prn-str","prn-str",-145225943,null),new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.Symbol(null,"re-pattern","re-pattern",1047705161,null),new cljs.core.Symbol(null,"vector","vector",-751469611,null),new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.Symbol(null,"some?","some?",234752293,null),new cljs.core.Symbol(null,"pos?","pos?",-244377722,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"re-matches","re-matches",-1865705768,null),new cljs.core.Symbol(null,"list","list",-1889078086,null),new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.Symbol("clojure.string","ends-with?","clojure.string/ends-with?",-745964149,null),new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.Symbol("clojure.string","includes?","clojure.string/includes?",-1842146260,null),new cljs.core.Symbol(null,"array-map","array-map",1555038968,null),new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.Symbol(null,"even?","even?",-1827825394,null),new cljs.core.Symbol(null,"type","type",-1480165421,null),new cljs.core.Symbol(null,"neg?","neg?",-1902175577,null),new cljs.core.Symbol("clojure.string","blank?","clojure.string/blank?",1772874244,null),new cljs.core.Symbol(null,"not-empty","not-empty",2029453590,null),new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"identical?","identical?",-745864205,null),new cljs.core.Symbol(null,"set","set",1945134081,null),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null)],[cljs.core.true_QMARK_,datascript.query.and_fn,cljs.core.odd_QMARK_,datascript.query._get_else,cljs.core._GT__EQ_,cljs.core.print_str,cljs.core._GT_,cljs.core.count,datascript.query._get_some,cljs.core.nil_QMARK_,cljs.core.inc,cljs.core._SLASH_,cljs.core.quot,cljs.core.false_QMARK_,cljs.core.not,cljs.core.identity,datascript.query._differ_QMARK_,cljs.core.re_seq,cljs.core._LT__EQ_,clojure.string.starts_with_QMARK_,cljs.core._EQ_,cljs.core.min,cljs.core._PLUS_,cljs.core.name,datascript.query._missing_QMARK_,cljs.core.identity,cljs.core.rand_int,cljs.core.complement,cljs.core._EQ__EQ_,cljs.core.hash_map,cljs.core.compare,cljs.core.range,cljs.core.max,cljs.core.empty,cljs.core._STAR_,cljs.core.pr_str,cljs.core.println_str,cljs.core.meta,cljs.core.zero_QMARK_,cljs.core.not_EQ_,cljs.core.prn_str,cljs.core.dec,cljs.core.re_pattern,cljs.core.vector,cljs.core.not_EQ_,cljs.core.str,cljs.core._LT_,cljs.core.namespace,cljs.core._,cljs.core.some_QMARK_,cljs.core.pos_QMARK_,cljs.core.rand,cljs.core.re_matches,cljs.core.list,cljs.core.contains_QMARK_,clojure.string.ends_with_QMARK_,cljs.core.subs,cljs.core.mod,clojure.string.includes_QMARK_,cljs.core.array_map,cljs.core.rem,cljs.core.even_QMARK_,cljs.core.type,cljs.core.neg_QMARK_,clojure.string.blank_QMARK_,cljs.core.not_empty,datascript.query.or_fn,cljs.core.identical_QMARK_,cljs.core.set,cljs.core.re_find]);
datascript.query.built_in_aggregates = (function (){var sum = (function datascript$query$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function datascript$query$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function datascript$query$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__73628 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__73628 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__73628;
}
});
var variance = (function datascript$query$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4523__auto__ = ((function (mean){
return (function datascript$query$variance_$_iter__73629(s__73630){
return (new cljs.core.LazySeq(null,((function (mean){
return (function (){
var s__73630__$1 = s__73630;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__73630__$1);
if(temp__5818__auto__){
var s__73630__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__73630__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__73630__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__73632 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__73631 = (0);
while(true){
if((i__73631 < size__4522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__73631);
var delta = (x - mean);
cljs.core.chunk_append(b__73632,(delta * delta));

var G__74443 = (i__73631 + (1));
i__73631 = G__74443;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__73632),datascript$query$variance_$_iter__73629(cljs.core.chunk_rest(s__73630__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__73632),null);
}
} else {
var x = cljs.core.first(s__73630__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),datascript$query$variance_$_iter__73629(cljs.core.rest(s__73630__$2)));
}
} else {
return null;
}
break;
}
});})(mean))
,null,null));
});})(mean))
;
return iter__4523__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function datascript$query$stddev(coll){
return Math.sqrt(variance(coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,sum,(function() {
var G__74446 = null;
var G__74446__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__74446__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__74446 = function(n,coll){
switch(arguments.length){
case 1:
return G__74446__1.call(this,n);
case 2:
return G__74446__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__74446.cljs$core$IFn$_invoke$arity$1 = G__74446__1;
G__74446.cljs$core$IFn$_invoke$arity$2 = G__74446__2;
return G__74446;
})()
,(function() {
var G__74456 = null;
var G__74456__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__74456__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__74456 = function(n,coll){
switch(arguments.length){
case 1:
return G__74456__1.call(this,n);
case 2:
return G__74456__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__74456.cljs$core$IFn$_invoke$arity$1 = G__74456__1;
G__74456.cljs$core$IFn$_invoke$arity$2 = G__74456__2;
return G__74456;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),cljs.core.set,avg,stddev,(function() {
var G__74464 = null;
var G__74464__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__74464__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__74464 = function(n,coll){
switch(arguments.length){
case 1:
return G__74464__1.call(this,n);
case 2:
return G__74464__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__74464.cljs$core$IFn$_invoke$arity$1 = G__74464__1;
G__74464.cljs$core$IFn$_invoke$arity$2 = G__74464__2;
return G__74464;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
datascript.query.parse_rules = (function datascript$query$parse_rules(rules){
var rules__$1 = ((typeof rules === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(rules):rules);
return cljs.core.group_by(cljs.core.ffirst,rules__$1);
});
datascript.query.empty_rel = (function datascript$query$empty_rel(binding){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"symbol","symbol",-1038572696),datascript.parser.collect_vars_distinct(binding));
return (new datascript.query.Relation(cljs.core.zipmap(vars,cljs.core.range.cljs$core$IFn$_invoke$arity$0()),cljs.core.PersistentVector.EMPTY,null,null,null));
});

/**
 * @interface
 */
datascript.query.IBinding = function(){};

datascript.query.in__GT_rel = (function datascript$query$in__GT_rel(binding,value){
if((((!((binding == null)))) && ((!((binding.datascript$query$IBinding$in__GT_rel$arity$2 == null)))))){
return binding.datascript$query$IBinding$in__GT_rel$arity$2(binding,value);
} else {
var x__4433__auto__ = (((binding == null))?null:binding);
var m__4434__auto__ = (datascript.query.in__GT_rel[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(binding,value) : m__4434__auto__.call(null,binding,value));
} else {
var m__4431__auto__ = (datascript.query.in__GT_rel["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(binding,value) : m__4431__auto__.call(null,binding,value));
} else {
throw cljs.core.missing_protocol("IBinding.in->rel",binding);
}
}
}
});

datascript.parser.BindIgnore.prototype.datascript$query$IBinding$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.BindIgnore.prototype.datascript$query$IBinding$in__GT_rel$arity$2 = (function (_,___$1){
var ___$2 = this;
return datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$0();
});

datascript.parser.BindScalar.prototype.datascript$query$IBinding$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.BindScalar.prototype.datascript$query$IBinding$in__GT_rel$arity$2 = (function (binding,value){
var binding__$1 = this;
return (new datascript.query.Relation(cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(binding__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"symbol","symbol",-1038572696)], null)),(0)]),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [value], null))], null),null,null,null));
});

datascript.parser.BindColl.prototype.datascript$query$IBinding$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.BindColl.prototype.datascript$query$IBinding$in__GT_rel$arity$2 = (function (binding,coll){
var binding__$1 = this;
if((!(datascript.db.seqable_QMARK_(coll)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot bind value ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0))," to collection ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([datascript.parser.source(binding__$1)], 0))].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","binding","query/binding",698240489),new cljs.core.Keyword(null,"value","value",305978217),coll,new cljs.core.Keyword(null,"binding","binding",539932593),datascript.parser.source(binding__$1)], null));
} else {
if(cljs.core.empty_QMARK_(coll)){
return datascript.query.empty_rel(binding__$1);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.sum_rel,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (binding__$1){
return (function (p1__73647_SHARP_){
return datascript.query.in__GT_rel(new cljs.core.Keyword(null,"binding","binding",539932593).cljs$core$IFn$_invoke$arity$1(binding__$1),p1__73647_SHARP_);
});})(binding__$1))
,coll));

}
}
});

datascript.parser.BindTuple.prototype.datascript$query$IBinding$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.BindTuple.prototype.datascript$query$IBinding$in__GT_rel$arity$2 = (function (binding,coll){
var binding__$1 = this;
if((!(datascript.db.seqable_QMARK_(coll)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot bind value ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0))," to tuple ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([datascript.parser.source(binding__$1)], 0))].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","binding","query/binding",698240489),new cljs.core.Keyword(null,"value","value",305978217),coll,new cljs.core.Keyword(null,"binding","binding",539932593),datascript.parser.source(binding__$1)], null));
} else {
if((cljs.core.count(coll) < cljs.core.count(new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(binding__$1)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Not enough elements in a collection ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0))," to bind tuple ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([datascript.parser.source(binding__$1)], 0))].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","binding","query/binding",698240489),new cljs.core.Keyword(null,"value","value",305978217),coll,new cljs.core.Keyword(null,"binding","binding",539932593),datascript.parser.source(binding__$1)], null));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.prod_rel,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (binding__$1){
return (function (p1__73648_SHARP_,p2__73649_SHARP_){
return datascript.query.in__GT_rel(p1__73648_SHARP_,p2__73649_SHARP_);
});})(binding__$1))
,new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(binding__$1),coll));

}
}
});
datascript.query.resolve_in = (function datascript$query$resolve_in(context,p__73671){
var vec__73672 = p__73671;
var binding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73672,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73672,(1),null);
if((((binding instanceof datascript.parser.BindScalar)) && ((new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(binding) instanceof datascript.parser.SrcVar)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$5(context,new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.assoc,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(binding,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"symbol","symbol",-1038572696)], null)),value);
} else {
if((((binding instanceof datascript.parser.BindScalar)) && ((new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(binding) instanceof datascript.parser.RulesVar)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(context,new cljs.core.Keyword(null,"rules","rules",1198912366),datascript.query.parse_rules(value));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(context,new cljs.core.Keyword(null,"rels","rels",1770187185),cljs.core.conj,datascript.query.in__GT_rel(binding,value));

}
}
});
datascript.query.resolve_ins = (function datascript$query$resolve_ins(context,bindings,values){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(datascript.query.resolve_in,context,cljs.core.zipmap(bindings,values));
});
/**
 * List of symbols in current pattern that might potentiall be resolved to refs
 */
datascript.query._STAR_lookup_attrs_STAR_ = null;
/**
 * Default pattern source. Lookup refs, patterns, rules will be resolved with it
 */
datascript.query._STAR_implicit_source_STAR_ = null;
datascript.query.getter_fn = (function datascript$query$getter_fn(attrs,attr){
var idx = (attrs.cljs$core$IFn$_invoke$arity$1 ? attrs.cljs$core$IFn$_invoke$arity$1(attr) : attrs.call(null,attr));
if(cljs.core.contains_QMARK_(datascript.query._STAR_lookup_attrs_STAR_,attr)){
return ((function (idx){
return (function (tuple){
var eid = (tuple[idx]);
if(typeof eid === 'number'){
return eid;
} else {
if(cljs.core.sequential_QMARK_(eid)){
return datascript.db.entid(datascript.query._STAR_implicit_source_STAR_,eid);
} else {
if(me.tonsky.persistent_sorted_set.arrays.array_QMARK_(eid)){
return datascript.db.entid(datascript.query._STAR_implicit_source_STAR_,eid);
} else {
return eid;

}
}
}
});
;})(idx))
} else {
return ((function (idx){
return (function (tuple){
return (tuple[idx]);
});
;})(idx))
}
});
datascript.query.tuple_key_fn = (function datascript$query$tuple_key_fn(getters){
if((cljs.core.count(getters) === (1))){
return cljs.core.first(getters);
} else {
var getters__$1 = cljs.core.to_array(getters);
return ((function (getters__$1){
return (function (tuple){
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(getters__$1.map(((function (getters__$1){
return (function (p1__73682_SHARP_){
return (p1__73682_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__73682_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__73682_SHARP_.call(null,tuple));
});})(getters__$1))
));
});
;})(getters__$1))
}
});
datascript.query.hash_attrs = (function datascript$query$hash_attrs(key_fn,tuples){
var tuples__$1 = tuples;
var hash_table = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
var temp__5820__auto__ = cljs.core.first(tuples__$1);
if((temp__5820__auto__ == null)){
return cljs.core.persistent_BANG_(hash_table);
} else {
var tuple = temp__5820__auto__;
var key = (key_fn.cljs$core$IFn$_invoke$arity$1 ? key_fn.cljs$core$IFn$_invoke$arity$1(tuple) : key_fn.call(null,tuple));
var G__74520 = cljs.core.next(tuples__$1);
var G__74521 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(hash_table,key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(hash_table,key,cljs.core.List.EMPTY),tuple));
tuples__$1 = G__74520;
hash_table = G__74521;
continue;
}
break;
}
});
datascript.query.hash_join = (function datascript$query$hash_join(rel1,rel2){
var tuples1 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(rel1);
var tuples2 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(rel2);
var attrs1 = new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel1);
var attrs2 = new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel2);
var common_attrs = cljs.core.vec(datascript.query.intersect_keys(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel1),new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel2)));
var common_gtrs1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (tuples1,tuples2,attrs1,attrs2,common_attrs){
return (function (p1__73702_SHARP_){
return datascript.query.getter_fn(attrs1,p1__73702_SHARP_);
});})(tuples1,tuples2,attrs1,attrs2,common_attrs))
,common_attrs);
var common_gtrs2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (tuples1,tuples2,attrs1,attrs2,common_attrs,common_gtrs1){
return (function (p1__73703_SHARP_){
return datascript.query.getter_fn(attrs2,p1__73703_SHARP_);
});})(tuples1,tuples2,attrs1,attrs2,common_attrs,common_gtrs1))
,common_attrs);
var keep_attrs1 = cljs.core.keys(attrs1);
var keep_attrs2 = cljs.core.vec(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(attrs2)),cljs.core.set(cljs.core.keys(attrs1))));
var keep_idxs1 = cljs.core.to_array(cljs.core.map.cljs$core$IFn$_invoke$arity$2(attrs1,keep_attrs1));
var keep_idxs2 = cljs.core.to_array(cljs.core.map.cljs$core$IFn$_invoke$arity$2(attrs2,keep_attrs2));
var key_fn1 = datascript.query.tuple_key_fn(common_gtrs1);
var hash = datascript.query.hash_attrs(key_fn1,tuples1);
var key_fn2 = datascript.query.tuple_key_fn(common_gtrs2);
var new_tuples = cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tuples1,tuples2,attrs1,attrs2,common_attrs,common_gtrs1,common_gtrs2,keep_attrs1,keep_attrs2,keep_idxs1,keep_idxs2,key_fn1,hash,key_fn2){
return (function (acc,tuple2){
var key = (key_fn2.cljs$core$IFn$_invoke$arity$1 ? key_fn2.cljs$core$IFn$_invoke$arity$1(tuple2) : key_fn2.call(null,tuple2));
var temp__5820__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(hash,key);
if((temp__5820__auto__ == null)){
return acc;
} else {
var tuples1__$1 = temp__5820__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tuples1__$1,temp__5820__auto__,key,tuples1,tuples2,attrs1,attrs2,common_attrs,common_gtrs1,common_gtrs2,keep_attrs1,keep_attrs2,keep_idxs1,keep_idxs2,key_fn1,hash,key_fn2){
return (function (acc__$1,tuple1){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(acc__$1,datascript.query.join_tuples(tuple1,keep_idxs1,tuple2,keep_idxs2));
});})(tuples1__$1,temp__5820__auto__,key,tuples1,tuples2,attrs1,attrs2,common_attrs,common_gtrs1,common_gtrs2,keep_attrs1,keep_attrs2,keep_idxs1,keep_idxs2,key_fn1,hash,key_fn2))
,acc,tuples1__$1);
}
});})(tuples1,tuples2,attrs1,attrs2,common_attrs,common_gtrs1,common_gtrs2,keep_attrs1,keep_attrs2,keep_idxs1,keep_idxs2,key_fn1,hash,key_fn2))
,cljs.core.transient$(cljs.core.PersistentVector.EMPTY),tuples2));
return (new datascript.query.Relation(cljs.core.zipmap(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(keep_attrs1,keep_attrs2),cljs.core.range.cljs$core$IFn$_invoke$arity$0()),new_tuples,null,null,null));
});
datascript.query.subtract_rel = (function datascript$query$subtract_rel(a,b){
var map__73713 = a;
var map__73713__$1 = (((((!((map__73713 == null))))?(((((map__73713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__73713):map__73713);
var attrs_a = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73713__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var tuples_a = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73713__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var map__73714 = b;
var map__73714__$1 = (((((!((map__73714 == null))))?(((((map__73714.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73714.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__73714):map__73714);
var attrs_b = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73714__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var tuples_b = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__73714__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var attrs = datascript.query.intersect_keys(attrs_a,attrs_b);
var getters_b = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__73713,map__73713__$1,attrs_a,tuples_a,map__73714,map__73714__$1,attrs_b,tuples_b,attrs){
return (function (p1__73710_SHARP_){
return datascript.query.getter_fn(attrs_b,p1__73710_SHARP_);
});})(map__73713,map__73713__$1,attrs_a,tuples_a,map__73714,map__73714__$1,attrs_b,tuples_b,attrs))
,attrs);
var key_fn_b = datascript.query.tuple_key_fn(getters_b);
var hash = datascript.query.hash_attrs(key_fn_b,tuples_b);
var getters_a = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__73713,map__73713__$1,attrs_a,tuples_a,map__73714,map__73714__$1,attrs_b,tuples_b,attrs,getters_b,key_fn_b,hash){
return (function (p1__73711_SHARP_){
return datascript.query.getter_fn(attrs_a,p1__73711_SHARP_);
});})(map__73713,map__73713__$1,attrs_a,tuples_a,map__73714,map__73714__$1,attrs_b,tuples_b,attrs,getters_b,key_fn_b,hash))
,attrs);
var key_fn_a = datascript.query.tuple_key_fn(getters_a);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(a,new cljs.core.Keyword(null,"tuples","tuples",-676032639),cljs.core.filterv(((function (map__73713,map__73713__$1,attrs_a,tuples_a,map__73714,map__73714__$1,attrs_b,tuples_b,attrs,getters_b,key_fn_b,hash,getters_a,key_fn_a){
return (function (p1__73712_SHARP_){
return ((function (){var G__73722 = (key_fn_a.cljs$core$IFn$_invoke$arity$1 ? key_fn_a.cljs$core$IFn$_invoke$arity$1(p1__73712_SHARP_) : key_fn_a.call(null,p1__73712_SHARP_));
return (hash.cljs$core$IFn$_invoke$arity$1 ? hash.cljs$core$IFn$_invoke$arity$1(G__73722) : hash.call(null,G__73722));
})() == null);
});})(map__73713,map__73713__$1,attrs_a,tuples_a,map__73714,map__73714__$1,attrs_b,tuples_b,attrs,getters_b,key_fn_b,hash,getters_a,key_fn_a))
,tuples_a));
});
datascript.query.lookup_pattern_db = (function datascript$query$lookup_pattern_db(db,pattern){
var search_pattern = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__73723_SHARP_){
if((p1__73723_SHARP_ instanceof cljs.core.Symbol)){
return null;
} else {
return p1__73723_SHARP_;
}
}),pattern);
var datoms = datascript.db._search(db,search_pattern);
var attr__GT_prop = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (search_pattern,datoms){
return (function (p__73726){
var vec__73730 = p__73726;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73730,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73730,(1),null);
return datascript.query.free_var_QMARK_(s);
});})(search_pattern,datoms))
,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,pattern,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["e","a","v","tx"], null))));
return (new datascript.query.Relation(attr__GT_prop,datoms,null,null,null));
});
datascript.query.matches_pattern_QMARK_ = (function datascript$query$matches_pattern_QMARK_(pattern,tuple){
var tuple__$1 = tuple;
var pattern__$1 = pattern;
while(true){
if(cljs.core.truth_((function (){var and__4120__auto__ = tuple__$1;
if(cljs.core.truth_(and__4120__auto__)){
return pattern__$1;
} else {
return and__4120__auto__;
}
})())){
var t = cljs.core.first(tuple__$1);
var p = cljs.core.first(pattern__$1);
if((((p instanceof cljs.core.Symbol)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p)))){
var G__74550 = cljs.core.next(tuple__$1);
var G__74551 = cljs.core.next(pattern__$1);
tuple__$1 = G__74550;
pattern__$1 = G__74551;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
datascript.query.lookup_pattern_coll = (function datascript$query$lookup_pattern_coll(coll,pattern){
var data = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__73734_SHARP_){
return datascript.query.matches_pattern_QMARK_(pattern,p1__73734_SHARP_);
}),coll);
var attr__GT_idx = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (data){
return (function (p__73741){
var vec__73742 = p__73741;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73742,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73742,(1),null);
return datascript.query.free_var_QMARK_(s);
});})(data))
,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,pattern,cljs.core.range.cljs$core$IFn$_invoke$arity$0())));
return (new datascript.query.Relation(attr__GT_idx,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.to_array,data),null,null,null));
});
datascript.query.normalize_pattern_clause = (function datascript$query$normalize_pattern_clause(clause){
if(datascript.query.source_QMARK_(cljs.core.first(clause))){
return clause;
} else {
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"$","$",-1580747756,null)], null),clause);
}
});
datascript.query.lookup_pattern = (function datascript$query$lookup_pattern(source,pattern){
if((((!((source == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === source.datascript$db$ISearch$))))?true:(((!source.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(datascript.db.ISearch,source):false)):cljs.core.native_satisfies_QMARK_(datascript.db.ISearch,source))){
return datascript.query.lookup_pattern_db(source,pattern);
} else {
return datascript.query.lookup_pattern_coll(source,pattern);

}
});
datascript.query.collapse_rels = (function datascript$query$collapse_rels(rels,new_rel){
var rels__$1 = rels;
var new_rel__$1 = new_rel;
var acc = cljs.core.PersistentVector.EMPTY;
while(true){
var temp__5820__auto__ = cljs.core.first(rels__$1);
if((temp__5820__auto__ == null)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new_rel__$1);
} else {
var rel = temp__5820__auto__;
if(cljs.core.truth_(cljs.core.not_empty(datascript.query.intersect_keys(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(new_rel__$1),new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel))))){
var G__74558 = cljs.core.next(rels__$1);
var G__74559 = datascript.query.hash_join(rel,new_rel__$1);
var G__74560 = acc;
rels__$1 = G__74558;
new_rel__$1 = G__74559;
acc = G__74560;
continue;
} else {
var G__74567 = cljs.core.next(rels__$1);
var G__74568 = new_rel__$1;
var G__74569 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,rel);
rels__$1 = G__74567;
new_rel__$1 = G__74568;
acc = G__74569;
continue;
}
}
break;
}
});
datascript.query.rel_with_attr = (function datascript$query$rel_with_attr(context,sym){
return cljs.core.some((function (p1__73751_SHARP_){
if(cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(p1__73751_SHARP_),sym)){
return p1__73751_SHARP_;
} else {
return null;
}
}),new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context));
});
datascript.query.context_resolve_val = (function datascript$query$context_resolve_val(context,sym){
var temp__5822__auto__ = datascript.query.rel_with_attr(context,sym);
if((temp__5822__auto__ == null)){
return null;
} else {
var rel = temp__5822__auto__;
var temp__5822__auto____$1 = cljs.core.first(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(rel));
if((temp__5822__auto____$1 == null)){
return null;
} else {
var tuple = temp__5822__auto____$1;
return (tuple[(function (){var fexpr__73758 = new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel);
return (fexpr__73758.cljs$core$IFn$_invoke$arity$1 ? fexpr__73758.cljs$core$IFn$_invoke$arity$1(sym) : fexpr__73758.call(null,sym));
})()]);
}
}
});
datascript.query.rel_contains_attrs_QMARK_ = (function datascript$query$rel_contains_attrs_QMARK_(rel,attrs){
return cljs.core.some((function (p1__73763_SHARP_){
return cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel),p1__73763_SHARP_);
}),attrs);
});
datascript.query.rel_prod_by_attrs = (function datascript$query$rel_prod_by_attrs(context,attrs){
var rels = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__73764_SHARP_){
return datascript.query.rel_contains_attrs_QMARK_(p1__73764_SHARP_,attrs);
}),new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context));
var production = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.prod_rel,rels);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update.cljs$core$IFn$_invoke$arity$3(context,new cljs.core.Keyword(null,"rels","rels",1770187185),((function (rels,production){
return (function (p1__73765_SHARP_){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(rels),p1__73765_SHARP_);
});})(rels,production))
),production], null);
});
datascript.query._call_fn = (function datascript$query$_call_fn(context,rel,f,args){
var sources = new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(context);
var attrs = new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel);
var len = cljs.core.count(args);
var static_args = me.tonsky.persistent_sorted_set.arrays.make_array(len);
var tuples_args = me.tonsky.persistent_sorted_set.arrays.make_array(len);
var n__4607__auto___74581 = len;
var i_74582 = (0);
while(true){
if((i_74582 < n__4607__auto___74581)){
var arg_74584 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(args,i_74582);
if((arg_74584 instanceof cljs.core.Symbol)){
var temp__5820__auto___74585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sources,arg_74584);
if((temp__5820__auto___74585 == null)){
(tuples_args[i_74582] = cljs.core.get.cljs$core$IFn$_invoke$arity$2(attrs,arg_74584));
} else {
var source_74587 = temp__5820__auto___74585;
(static_args[i_74582] = source_74587);
}
} else {
(static_args[i_74582] = arg_74584);
}

var G__74592 = (i_74582 + (1));
i_74582 = G__74592;
continue;
} else {
}
break;
}

if((f === cljs.core.vector)){
return ((function (sources,attrs,len,static_args,tuples_args){
return (function (tuple){
var args__$1 = me.tonsky.persistent_sorted_set.arrays.aclone(static_args);
var n__4607__auto___74596 = len;
var i_74597 = (0);
while(true){
if((i_74597 < n__4607__auto___74596)){
var temp__5822__auto___74599 = (tuples_args[i_74597]);
if((temp__5822__auto___74599 == null)){
} else {
var tuple_idx_74600 = temp__5822__auto___74599;
var v_74601 = (tuple[tuple_idx_74600]);
(args__$1[i_74597] = v_74601);
}

var G__74602 = (i_74597 + (1));
i_74597 = G__74602;
continue;
} else {
}
break;
}

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});
;})(sources,attrs,len,static_args,tuples_args))
} else {
return ((function (sources,attrs,len,static_args,tuples_args){
return (function (tuple){
var n__4607__auto___74603 = len;
var i_74604 = (0);
while(true){
if((i_74604 < n__4607__auto___74603)){
var temp__5822__auto___74605 = (tuples_args[i_74604]);
if((temp__5822__auto___74605 == null)){
} else {
var tuple_idx_74607 = temp__5822__auto___74605;
var v_74608 = (tuple[tuple_idx_74607]);
(static_args[i_74604] = v_74608);
}

var G__74610 = (i_74604 + (1));
i_74604 = G__74610;
continue;
} else {
}
break;
}

return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,static_args);
});
;})(sources,attrs,len,static_args,tuples_args))
}
});
datascript.query.resolve_sym = (function datascript$query$resolve_sym(sym){
return null;
});
datascript.query.filter_by_pred = (function datascript$query$filter_by_pred(context,clause){
var vec__73781 = clause;
var vec__73784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73781,(0),null);
var seq__73785 = cljs.core.seq(vec__73784);
var first__73786 = cljs.core.first(seq__73785);
var seq__73785__$1 = cljs.core.next(seq__73785);
var f = first__73786;
var args = seq__73785__$1;
var pred = (function (){var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datascript.query.built_ins,f);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = datascript.query.context_resolve_val(context,f);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = datascript.query.resolve_sym(f);
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
if((datascript.query.rel_with_attr(context,f) == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown predicate '",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([f], 0))," in ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([clause], 0))].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","where","query/where",-1935159429),new cljs.core.Keyword(null,"form","form",-1624062471),clause,new cljs.core.Keyword(null,"var","var",-769682797),f], null));
} else {
return null;
}
}
}
}
})();
var vec__73787 = datascript.query.rel_prod_by_attrs(context,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol_QMARK_,args));
var context__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73787,(0),null);
var production = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73787,(1),null);
var new_rel = (cljs.core.truth_(pred)?(function (){var tuple_pred = datascript.query._call_fn(context__$1,production,pred,args);
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(production,new cljs.core.Keyword(null,"tuples","tuples",-676032639),((function (tuple_pred,vec__73781,vec__73784,seq__73785,first__73786,seq__73785__$1,f,args,pred,vec__73787,context__$1,production){
return (function (p1__73780_SHARP_){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(tuple_pred,p1__73780_SHARP_);
});})(tuple_pred,vec__73781,vec__73784,seq__73785,first__73786,seq__73785__$1,f,args,pred,vec__73787,context__$1,production))
);
})():cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(production,new cljs.core.Keyword(null,"tuples","tuples",-676032639),cljs.core.PersistentVector.EMPTY));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(context__$1,new cljs.core.Keyword(null,"rels","rels",1770187185),cljs.core.conj,new_rel);
});
datascript.query.bind_by_fn = (function datascript$query$bind_by_fn(context,clause){
var vec__73794 = clause;
var vec__73797 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73794,(0),null);
var seq__73798 = cljs.core.seq(vec__73797);
var first__73799 = cljs.core.first(seq__73798);
var seq__73798__$1 = cljs.core.next(seq__73798);
var f = first__73799;
var args = seq__73798__$1;
var out = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73794,(1),null);
var binding = datascript.parser.parse_binding(out);
var fun = (function (){var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datascript.query.built_ins,f);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = datascript.query.context_resolve_val(context,f);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = datascript.query.resolve_sym(f);
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
if((datascript.query.rel_with_attr(context,f) == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown function '",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([f], 0))," in ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([clause], 0))].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","where","query/where",-1935159429),new cljs.core.Keyword(null,"form","form",-1624062471),clause,new cljs.core.Keyword(null,"var","var",-769682797),f], null));
} else {
return null;
}
}
}
}
})();
var vec__73800 = datascript.query.rel_prod_by_attrs(context,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol_QMARK_,args));
var context__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73800,(0),null);
var production = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73800,(1),null);
var new_rel = (cljs.core.truth_(fun)?(function (){var tuple_fn = datascript.query._call_fn(context__$1,production,fun,args);
var rels = (function (){var iter__4523__auto__ = ((function (tuple_fn,vec__73794,vec__73797,seq__73798,first__73799,seq__73798__$1,f,args,out,binding,fun,vec__73800,context__$1,production){
return (function datascript$query$bind_by_fn_$_iter__73808(s__73809){
return (new cljs.core.LazySeq(null,((function (tuple_fn,vec__73794,vec__73797,seq__73798,first__73799,seq__73798__$1,f,args,out,binding,fun,vec__73800,context__$1,production){
return (function (){
var s__73809__$1 = s__73809;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__73809__$1);
if(temp__5818__auto__){
var s__73809__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__73809__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__73809__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__73811 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__73810 = (0);
while(true){
if((i__73810 < size__4522__auto__)){
var tuple = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__73810);
var val = tuple_fn(tuple);
if((!((val == null)))){
cljs.core.chunk_append(b__73811,datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$2((new datascript.query.Relation(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(production),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple], null),null,null,null)),datascript.query.in__GT_rel(binding,val)));

var G__74632 = (i__73810 + (1));
i__73810 = G__74632;
continue;
} else {
var G__74633 = (i__73810 + (1));
i__73810 = G__74633;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__73811),datascript$query$bind_by_fn_$_iter__73808(cljs.core.chunk_rest(s__73809__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__73811),null);
}
} else {
var tuple = cljs.core.first(s__73809__$2);
var val = tuple_fn(tuple);
if((!((val == null)))){
return cljs.core.cons(datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$2((new datascript.query.Relation(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(production),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple], null),null,null,null)),datascript.query.in__GT_rel(binding,val)),datascript$query$bind_by_fn_$_iter__73808(cljs.core.rest(s__73809__$2)));
} else {
var G__74637 = cljs.core.rest(s__73809__$2);
s__73809__$1 = G__74637;
continue;
}
}
} else {
return null;
}
break;
}
});})(tuple_fn,vec__73794,vec__73797,seq__73798,first__73799,seq__73798__$1,f,args,out,binding,fun,vec__73800,context__$1,production))
,null,null));
});})(tuple_fn,vec__73794,vec__73797,seq__73798,first__73799,seq__73798__$1,f,args,out,binding,fun,vec__73800,context__$1,production))
;
return iter__4523__auto__(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(production));
})();
if(cljs.core.empty_QMARK_(rels)){
return datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$2(production,datascript.query.empty_rel(binding));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.sum_rel,rels);
}
})():datascript.query.prod_rel.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(production,new cljs.core.Keyword(null,"tuples","tuples",-676032639),cljs.core.PersistentVector.EMPTY),datascript.query.empty_rel(binding)));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(context__$1,new cljs.core.Keyword(null,"rels","rels",1770187185),datascript.query.collapse_rels,new_rel);
});
datascript.query.rule_QMARK_ = (function datascript$query$rule_QMARK_(context,clause){
return ((cljs.core.sequential_QMARK_(clause)) && (cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"rules","rules",1198912366).cljs$core$IFn$_invoke$arity$1(context),((datascript.query.source_QMARK_(cljs.core.first(clause)))?cljs.core.second(clause):cljs.core.first(clause)))));
});
datascript.query.rule_seqid = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
datascript.query.expand_rule = (function datascript$query$expand_rule(clause,context,used_args){
var vec__73823 = clause;
var seq__73824 = cljs.core.seq(vec__73823);
var first__73825 = cljs.core.first(seq__73824);
var seq__73824__$1 = cljs.core.next(seq__73824);
var rule = first__73825;
var call_args = seq__73824__$1;
var seqid = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(datascript.query.rule_seqid,cljs.core.inc);
var branches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"rules","rules",1198912366).cljs$core$IFn$_invoke$arity$1(context),rule);
var iter__4523__auto__ = ((function (vec__73823,seq__73824,first__73825,seq__73824__$1,rule,call_args,seqid,branches){
return (function datascript$query$expand_rule_$_iter__73826(s__73827){
return (new cljs.core.LazySeq(null,((function (vec__73823,seq__73824,first__73825,seq__73824__$1,rule,call_args,seqid,branches){
return (function (){
var s__73827__$1 = s__73827;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__73827__$1);
if(temp__5818__auto__){
var s__73827__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__73827__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__73827__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__73829 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__73828 = (0);
while(true){
if((i__73828 < size__4522__auto__)){
var branch = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__73828);
var vec__73830 = branch;
var seq__73831 = cljs.core.seq(vec__73830);
var first__73832 = cljs.core.first(seq__73831);
var seq__73831__$1 = cljs.core.next(seq__73831);
var vec__73833 = first__73832;
var seq__73834 = cljs.core.seq(vec__73833);
var first__73835 = cljs.core.first(seq__73834);
var seq__73834__$1 = cljs.core.next(seq__73834);
var _ = first__73835;
var rule_args = seq__73834__$1;
var clauses = seq__73831__$1;
var replacements = cljs.core.zipmap(rule_args,call_args);
cljs.core.chunk_append(b__73829,clojure.walk.postwalk(((function (i__73828,vec__73830,seq__73831,first__73832,seq__73831__$1,vec__73833,seq__73834,first__73835,seq__73834__$1,_,rule_args,clauses,replacements,branch,c__4521__auto__,size__4522__auto__,b__73829,s__73827__$2,temp__5818__auto__,vec__73823,seq__73824,first__73825,seq__73824__$1,rule,call_args,seqid,branches){
return (function (p1__73822_SHARP_){
if(datascript.query.free_var_QMARK_(p1__73822_SHARP_)){
var x__61858__auto__ = (replacements.cljs$core$IFn$_invoke$arity$1 ? replacements.cljs$core$IFn$_invoke$arity$1(p1__73822_SHARP_) : replacements.call(null,p1__73822_SHARP_));
if((x__61858__auto__ == null)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.name(p1__73822_SHARP_),"__auto__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(seqid)].join(''));
} else {
return x__61858__auto__;
}
} else {
return p1__73822_SHARP_;
}
});})(i__73828,vec__73830,seq__73831,first__73832,seq__73831__$1,vec__73833,seq__73834,first__73835,seq__73834__$1,_,rule_args,clauses,replacements,branch,c__4521__auto__,size__4522__auto__,b__73829,s__73827__$2,temp__5818__auto__,vec__73823,seq__73824,first__73825,seq__73824__$1,rule,call_args,seqid,branches))
,clauses));

var G__74670 = (i__73828 + (1));
i__73828 = G__74670;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__73829),datascript$query$expand_rule_$_iter__73826(cljs.core.chunk_rest(s__73827__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__73829),null);
}
} else {
var branch = cljs.core.first(s__73827__$2);
var vec__73838 = branch;
var seq__73839 = cljs.core.seq(vec__73838);
var first__73840 = cljs.core.first(seq__73839);
var seq__73839__$1 = cljs.core.next(seq__73839);
var vec__73841 = first__73840;
var seq__73842 = cljs.core.seq(vec__73841);
var first__73843 = cljs.core.first(seq__73842);
var seq__73842__$1 = cljs.core.next(seq__73842);
var _ = first__73843;
var rule_args = seq__73842__$1;
var clauses = seq__73839__$1;
var replacements = cljs.core.zipmap(rule_args,call_args);
return cljs.core.cons(clojure.walk.postwalk(((function (vec__73838,seq__73839,first__73840,seq__73839__$1,vec__73841,seq__73842,first__73843,seq__73842__$1,_,rule_args,clauses,replacements,branch,s__73827__$2,temp__5818__auto__,vec__73823,seq__73824,first__73825,seq__73824__$1,rule,call_args,seqid,branches){
return (function (p1__73822_SHARP_){
if(datascript.query.free_var_QMARK_(p1__73822_SHARP_)){
var x__61858__auto__ = (replacements.cljs$core$IFn$_invoke$arity$1 ? replacements.cljs$core$IFn$_invoke$arity$1(p1__73822_SHARP_) : replacements.call(null,p1__73822_SHARP_));
if((x__61858__auto__ == null)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.name(p1__73822_SHARP_),"__auto__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(seqid)].join(''));
} else {
return x__61858__auto__;
}
} else {
return p1__73822_SHARP_;
}
});})(vec__73838,seq__73839,first__73840,seq__73839__$1,vec__73841,seq__73842,first__73843,seq__73842__$1,_,rule_args,clauses,replacements,branch,s__73827__$2,temp__5818__auto__,vec__73823,seq__73824,first__73825,seq__73824__$1,rule,call_args,seqid,branches))
,clauses),datascript$query$expand_rule_$_iter__73826(cljs.core.rest(s__73827__$2)));
}
} else {
return null;
}
break;
}
});})(vec__73823,seq__73824,first__73825,seq__73824__$1,rule,call_args,seqid,branches))
,null,null));
});})(vec__73823,seq__73824,first__73825,seq__73824__$1,rule,call_args,seqid,branches))
;
return iter__4523__auto__(branches);
});
datascript.query.remove_pairs = (function datascript$query$remove_pairs(xs,ys){
var pairs = cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__73845){
var vec__73847 = p__73845;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73847,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73847,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y);
}),cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,xs,ys));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,pairs),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,pairs)], null);
});
datascript.query.rule_gen_guards = (function datascript$query$rule_gen_guards(rule_clause,used_args){
var vec__73850 = rule_clause;
var seq__73851 = cljs.core.seq(vec__73850);
var first__73852 = cljs.core.first(seq__73851);
var seq__73851__$1 = cljs.core.next(seq__73851);
var rule = first__73852;
var call_args = seq__73851__$1;
var prev_call_args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(used_args,rule);
var iter__4523__auto__ = ((function (vec__73850,seq__73851,first__73852,seq__73851__$1,rule,call_args,prev_call_args){
return (function datascript$query$rule_gen_guards_$_iter__73853(s__73854){
return (new cljs.core.LazySeq(null,((function (vec__73850,seq__73851,first__73852,seq__73851__$1,rule,call_args,prev_call_args){
return (function (){
var s__73854__$1 = s__73854;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__73854__$1);
if(temp__5818__auto__){
var s__73854__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__73854__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__73854__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__73856 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__73855 = (0);
while(true){
if((i__73855 < size__4522__auto__)){
var prev_args = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__73855);
var vec__73857 = datascript.query.remove_pairs(call_args,prev_args);
var call_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73857,(0),null);
var prev_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73857,(1),null);
cljs.core.chunk_append(b__73856,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"-differ?","-differ?",1465687357,null)], null),call_args__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([prev_args__$1], 0))], null));

var G__74692 = (i__73855 + (1));
i__73855 = G__74692;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__73856),datascript$query$rule_gen_guards_$_iter__73853(cljs.core.chunk_rest(s__73854__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__73856),null);
}
} else {
var prev_args = cljs.core.first(s__73854__$2);
var vec__73861 = datascript.query.remove_pairs(call_args,prev_args);
var call_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73861,(0),null);
var prev_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73861,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"-differ?","-differ?",1465687357,null)], null),call_args__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([prev_args__$1], 0))], null),datascript$query$rule_gen_guards_$_iter__73853(cljs.core.rest(s__73854__$2)));
}
} else {
return null;
}
break;
}
});})(vec__73850,seq__73851,first__73852,seq__73851__$1,rule,call_args,prev_call_args))
,null,null));
});})(vec__73850,seq__73851,first__73852,seq__73851__$1,rule,call_args,prev_call_args))
;
return iter__4523__auto__(prev_call_args);
});
datascript.query.walk_collect = (function datascript$query$walk_collect(form,pred){
var res = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
clojure.walk.postwalk(((function (res){
return (function (p1__73864_SHARP_){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(p1__73864_SHARP_) : pred.call(null,p1__73864_SHARP_)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(res,cljs.core.conj,p1__73864_SHARP_);
} else {
}

return p1__73864_SHARP_;
});})(res))
,form);

return cljs.core.deref(res);
});
datascript.query.collect_vars = (function datascript$query$collect_vars(clause){
return cljs.core.set(datascript.query.walk_collect(clause,datascript.query.free_var_QMARK_));
});
datascript.query.split_guards = (function datascript$query$split_guards(clauses,guards){
var bound_vars = datascript.query.collect_vars(clauses);
var pred = ((function (bound_vars){
return (function (p__73873){
var vec__73874 = p__73873;
var vec__73877 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73874,(0),null);
var seq__73878 = cljs.core.seq(vec__73877);
var first__73879 = cljs.core.first(seq__73878);
var seq__73878__$1 = cljs.core.next(seq__73878);
var _ = first__73879;
var vars = seq__73878__$1;
return cljs.core.every_QMARK_(bound_vars,vars);
});})(bound_vars))
;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,guards),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pred,guards)], null);
});
datascript.query.solve_rule = (function datascript$query$solve_rule(context,clause){
var final_attrs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(datascript.query.free_var_QMARK_,clause);
var final_attrs_map = cljs.core.zipmap(final_attrs,cljs.core.range.cljs$core$IFn$_invoke$arity$0());
var solve = ((function (final_attrs,final_attrs_map){
return (function (prefix_context,clauses){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(datascript.query._resolve_clause,prefix_context,clauses);
});})(final_attrs,final_attrs_map))
;
var empty_rels_QMARK_ = ((function (final_attrs,final_attrs_map,solve){
return (function (context__$1){
return cljs.core.some(((function (final_attrs,final_attrs_map,solve){
return (function (p1__73884_SHARP_){
return cljs.core.empty_QMARK_(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(p1__73884_SHARP_));
});})(final_attrs,final_attrs_map,solve))
,new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context__$1));
});})(final_attrs,final_attrs_map,solve))
;
var stack = (new cljs.core.List(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"prefix-clauses","prefix-clauses",1294180028),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"prefix-context","prefix-context",-1269613591),context,new cljs.core.Keyword(null,"clauses","clauses",1454841241),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clause], null),new cljs.core.Keyword(null,"used-args","used-args",23596256),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"pending-guards","pending-guards",-1255527308),cljs.core.PersistentArrayMap.EMPTY], null),null,(1),null));
var rel = (new datascript.query.Relation(final_attrs_map,cljs.core.PersistentVector.EMPTY,null,null,null));
while(true){
var temp__5820__auto__ = cljs.core.first(stack);
if((temp__5820__auto__ == null)){
return rel;
} else {
var frame = temp__5820__auto__;
var vec__73938 = cljs.core.split_with(((function (stack,rel,frame,temp__5820__auto__,final_attrs,final_attrs_map,solve,empty_rels_QMARK_){
return (function (p1__73887_SHARP_){
return (!(datascript.query.rule_QMARK_(context,p1__73887_SHARP_)));
});})(stack,rel,frame,temp__5820__auto__,final_attrs,final_attrs_map,solve,empty_rels_QMARK_))
,new cljs.core.Keyword(null,"clauses","clauses",1454841241).cljs$core$IFn$_invoke$arity$1(frame));
var clauses = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73938,(0),null);
var vec__73941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73938,(1),null);
var seq__73942 = cljs.core.seq(vec__73941);
var first__73943 = cljs.core.first(seq__73942);
var seq__73942__$1 = cljs.core.next(seq__73942);
var rule_clause = first__73943;
var next_clauses = seq__73942__$1;
if((rule_clause == null)){
var context__$1 = solve(new cljs.core.Keyword(null,"prefix-context","prefix-context",-1269613591).cljs$core$IFn$_invoke$arity$1(frame),clauses);
var tuples = (datascript.query._collect.cljs$core$IFn$_invoke$arity$2 ? datascript.query._collect.cljs$core$IFn$_invoke$arity$2(context__$1,final_attrs) : datascript.query._collect.call(null,context__$1,final_attrs));
var new_rel = (new datascript.query.Relation(final_attrs_map,tuples,null,null,null));
var G__74709 = cljs.core.next(stack);
var G__74710 = datascript.query.sum_rel(rel,new_rel);
stack = G__74709;
rel = G__74710;
continue;
} else {
var vec__73945 = rule_clause;
var seq__73946 = cljs.core.seq(vec__73945);
var first__73947 = cljs.core.first(seq__73946);
var seq__73946__$1 = cljs.core.next(seq__73946);
var rule = first__73947;
var call_args = seq__73946__$1;
var guards = datascript.query.rule_gen_guards(rule_clause,new cljs.core.Keyword(null,"used-args","used-args",23596256).cljs$core$IFn$_invoke$arity$1(frame));
var vec__73948 = datascript.query.split_guards(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"prefix-clauses","prefix-clauses",1294180028).cljs$core$IFn$_invoke$arity$1(frame),clauses),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(guards,new cljs.core.Keyword(null,"pending-guards","pending-guards",-1255527308).cljs$core$IFn$_invoke$arity$1(frame)));
var active_gs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73948,(0),null);
var pending_gs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73948,(1),null);
if(cljs.core.truth_(cljs.core.some(((function (stack,rel,vec__73945,seq__73946,first__73947,seq__73946__$1,rule,call_args,guards,vec__73948,active_gs,pending_gs,vec__73938,clauses,vec__73941,seq__73942,first__73943,seq__73942__$1,rule_clause,next_clauses,frame,temp__5820__auto__,final_attrs,final_attrs_map,solve,empty_rels_QMARK_){
return (function (p1__73888_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__73888_SHARP_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"-differ?","-differ?",1465687357,null))], null));
});})(stack,rel,vec__73945,seq__73946,first__73947,seq__73946__$1,rule,call_args,guards,vec__73948,active_gs,pending_gs,vec__73938,clauses,vec__73941,seq__73942,first__73943,seq__73942__$1,rule_clause,next_clauses,frame,temp__5820__auto__,final_attrs,final_attrs_map,solve,empty_rels_QMARK_))
,active_gs))){
var G__74714 = cljs.core.next(stack);
var G__74715 = rel;
stack = G__74714;
rel = G__74715;
continue;
} else {
var prefix_clauses = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clauses,active_gs);
var prefix_context = solve(new cljs.core.Keyword(null,"prefix-context","prefix-context",-1269613591).cljs$core$IFn$_invoke$arity$1(frame),prefix_clauses);
if(cljs.core.truth_(empty_rels_QMARK_(prefix_context))){
var G__74719 = cljs.core.next(stack);
var G__74720 = rel;
stack = G__74719;
rel = G__74720;
continue;
} else {
var used_args = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"used-args","used-args",23596256).cljs$core$IFn$_invoke$arity$1(frame),rule,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"used-args","used-args",23596256).cljs$core$IFn$_invoke$arity$1(frame),rule,cljs.core.PersistentVector.EMPTY),call_args));
var branches = datascript.query.expand_rule(rule_clause,context,used_args);
var G__74724 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var iter__4523__auto__ = ((function (stack,rel,used_args,branches,prefix_clauses,prefix_context,vec__73945,seq__73946,first__73947,seq__73946__$1,rule,call_args,guards,vec__73948,active_gs,pending_gs,vec__73938,clauses,vec__73941,seq__73942,first__73943,seq__73942__$1,rule_clause,next_clauses,frame,temp__5820__auto__,final_attrs,final_attrs_map,solve,empty_rels_QMARK_){
return (function datascript$query$solve_rule_$_iter__73955(s__73956){
return (new cljs.core.LazySeq(null,((function (stack,rel,used_args,branches,prefix_clauses,prefix_context,vec__73945,seq__73946,first__73947,seq__73946__$1,rule,call_args,guards,vec__73948,active_gs,pending_gs,vec__73938,clauses,vec__73941,seq__73942,first__73943,seq__73942__$1,rule_clause,next_clauses,frame,temp__5820__auto__,final_attrs,final_attrs_map,solve,empty_rels_QMARK_){
return (function (){
var s__73956__$1 = s__73956;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__73956__$1);
if(temp__5818__auto__){
var s__73956__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__73956__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__73956__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__73958 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__73957 = (0);
while(true){
if((i__73957 < size__4522__auto__)){
var branch = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__73957);
cljs.core.chunk_append(b__73958,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"prefix-clauses","prefix-clauses",1294180028),prefix_clauses,new cljs.core.Keyword(null,"prefix-context","prefix-context",-1269613591),prefix_context,new cljs.core.Keyword(null,"clauses","clauses",1454841241),datascript.query.concatv.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([branch,next_clauses], 0)),new cljs.core.Keyword(null,"used-args","used-args",23596256),used_args,new cljs.core.Keyword(null,"pending-guards","pending-guards",-1255527308),pending_gs], null));

var G__74739 = (i__73957 + (1));
i__73957 = G__74739;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__73958),datascript$query$solve_rule_$_iter__73955(cljs.core.chunk_rest(s__73956__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__73958),null);
}
} else {
var branch = cljs.core.first(s__73956__$2);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"prefix-clauses","prefix-clauses",1294180028),prefix_clauses,new cljs.core.Keyword(null,"prefix-context","prefix-context",-1269613591),prefix_context,new cljs.core.Keyword(null,"clauses","clauses",1454841241),datascript.query.concatv.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([branch,next_clauses], 0)),new cljs.core.Keyword(null,"used-args","used-args",23596256),used_args,new cljs.core.Keyword(null,"pending-guards","pending-guards",-1255527308),pending_gs], null),datascript$query$solve_rule_$_iter__73955(cljs.core.rest(s__73956__$2)));
}
} else {
return null;
}
break;
}
});})(stack,rel,used_args,branches,prefix_clauses,prefix_context,vec__73945,seq__73946,first__73947,seq__73946__$1,rule,call_args,guards,vec__73948,active_gs,pending_gs,vec__73938,clauses,vec__73941,seq__73942,first__73943,seq__73942__$1,rule_clause,next_clauses,frame,temp__5820__auto__,final_attrs,final_attrs_map,solve,empty_rels_QMARK_))
,null,null));
});})(stack,rel,used_args,branches,prefix_clauses,prefix_context,vec__73945,seq__73946,first__73947,seq__73946__$1,rule,call_args,guards,vec__73948,active_gs,pending_gs,vec__73938,clauses,vec__73941,seq__73942,first__73943,seq__73942__$1,rule_clause,next_clauses,frame,temp__5820__auto__,final_attrs,final_attrs_map,solve,empty_rels_QMARK_))
;
return iter__4523__auto__(branches);
})(),cljs.core.next(stack));
var G__74725 = rel;
stack = G__74724;
rel = G__74725;
continue;
}
}
}
}
break;
}
});
datascript.query.resolve_pattern_lookup_refs = (function datascript$query$resolve_pattern_lookup_refs(source,pattern){
if((((!((source == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === source.datascript$db$IDB$))))?true:(((!source.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(datascript.db.IDB,source):false)):cljs.core.native_satisfies_QMARK_(datascript.db.IDB,source))){
var vec__73972 = pattern;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73972,(0),null);
var a = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73972,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73972,(2),null);
var tx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73972,(3),null);
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_((function (){var or__4131__auto__ = datascript.query.lookup_ref_QMARK_(e);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return datascript.query.attr_QMARK_(e);
}
})())?datascript.db.entid_strict(source,e):e),a,(cljs.core.truth_((function (){var and__4120__auto__ = v;
if(cljs.core.truth_(and__4120__auto__)){
var and__4120__auto____$1 = datascript.query.attr_QMARK_(a);
if(and__4120__auto____$1){
var and__4120__auto____$2 = datascript.db.ref_QMARK_(source,a);
if(and__4120__auto____$2){
var or__4131__auto__ = datascript.query.lookup_ref_QMARK_(v);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return datascript.query.attr_QMARK_(v);
}
} else {
return and__4120__auto____$2;
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
})())?datascript.db.entid_strict(source,v):v),(cljs.core.truth_(datascript.query.lookup_ref_QMARK_(tx))?datascript.db.entid_strict(source,tx):tx)], null),(0),cljs.core.count(pattern));
} else {
return pattern;
}
});
datascript.query.dynamic_lookup_attrs = (function datascript$query$dynamic_lookup_attrs(source,pattern){
var vec__73986 = pattern;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73986,(0),null);
var a = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73986,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73986,(2),null);
var tx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__73986,(3),null);
var G__73989 = cljs.core.PersistentHashSet.EMPTY;
var G__73989__$1 = ((datascript.query.free_var_QMARK_(e))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__73989,e):G__73989);
var G__73989__$2 = ((datascript.query.free_var_QMARK_(tx))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__73989__$1,tx):G__73989__$1);
if(((datascript.query.free_var_QMARK_(v)) && ((!(datascript.query.free_var_QMARK_(a)))) && (datascript.db.ref_QMARK_(source,a)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__73989__$2,v);
} else {
return G__73989__$2;
}
});
datascript.query.limit_rel = (function datascript$query$limit_rel(rel,vars){
var temp__5822__auto__ = cljs.core.not_empty(cljs.core.select_keys(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel),vars));
if((temp__5822__auto__ == null)){
return null;
} else {
var attrs_SINGLEQUOTE_ = temp__5822__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(rel,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),attrs_SINGLEQUOTE_);
}
});
datascript.query.limit_context = (function datascript$query$limit_context(context,vars){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(context,new cljs.core.Keyword(null,"rels","rels",1770187185),cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__73994_SHARP_){
return datascript.query.limit_rel(p1__73994_SHARP_,vars);
}),new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context)));
});
datascript.query.check_bound = (function datascript$query$check_bound(context,vars,form){
var bound = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__74000_SHARP_){
return cljs.core.keys(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(p1__74000_SHARP_));
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context)], 0)));
if(clojure.set.subset_QMARK_(vars,bound)){
return null;
} else {
var missing = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set(vars),bound);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Insufficient bindings: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([missing], 0))," not bound in ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0))].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","where","query/where",-1935159429),new cljs.core.Keyword(null,"form","form",-1624062471),form,new cljs.core.Keyword(null,"vars","vars",-2046957217),missing], null));
}
});
datascript.query._resolve_clause = (function datascript$query$_resolve_clause(var_args){
var G__74010 = arguments.length;
switch (G__74010) {
case 2:
return datascript.query._resolve_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return datascript.query._resolve_clause.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

datascript.query._resolve_clause.cljs$core$IFn$_invoke$arity$2 = (function (context,clause){
return datascript.query._resolve_clause.cljs$core$IFn$_invoke$arity$3(context,clause,clause);
});

datascript.query._resolve_clause.cljs$core$IFn$_invoke$arity$3 = (function (context,clause,orig_clause){
while(true){
var pred__74017 = datascript.query.looks_like_QMARK_;
var expr__74018 = clause;
if(cljs.core.truth_((function (){var G__74020 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol_QMARK_,new cljs.core.Symbol(null,"*","*",345799209,null)], null)], null);
var G__74021 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74020,G__74021) : pred__74017.call(null,G__74020,G__74021));
})())){
return datascript.query.filter_by_pred(context,clause);
} else {
if(cljs.core.truth_((function (){var G__74022 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol_QMARK_,new cljs.core.Symbol(null,"*","*",345799209,null)], null),new cljs.core.Symbol(null,"_","_",-1201019570,null)], null);
var G__74023 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74022,G__74023) : pred__74017.call(null,G__74022,G__74023));
})())){
return datascript.query.bind_by_fn(context,clause);
} else {
if(cljs.core.truth_((function (){var G__74024 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [datascript.query.source_QMARK_,new cljs.core.Symbol(null,"*","*",345799209,null)], null);
var G__74025 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74024,G__74025) : pred__74017.call(null,G__74024,G__74025));
})())){
var vec__74026 = clause;
var seq__74027 = cljs.core.seq(vec__74026);
var first__74028 = cljs.core.first(seq__74027);
var seq__74027__$1 = cljs.core.next(seq__74027);
var source_sym = first__74028;
var rest = seq__74027__$1;
var _STAR_implicit_source_STAR__orig_val__74029 = datascript.query._STAR_implicit_source_STAR_;
var _STAR_implicit_source_STAR__temp_val__74030 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(context),source_sym);
datascript.query._STAR_implicit_source_STAR_ = _STAR_implicit_source_STAR__temp_val__74030;

try{return datascript.query._resolve_clause.cljs$core$IFn$_invoke$arity$3(context,rest,clause);
}finally {datascript.query._STAR_implicit_source_STAR_ = _STAR_implicit_source_STAR__orig_val__74029;
}} else {
if(cljs.core.truth_((function (){var G__74031 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.Symbol(null,"*","*",345799209,null)], null);
var G__74032 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74031,G__74032) : pred__74017.call(null,G__74031,G__74032));
})())){
var vec__74033 = clause;
var seq__74034 = cljs.core.seq(vec__74033);
var first__74035 = cljs.core.first(seq__74034);
var seq__74034__$1 = cljs.core.next(seq__74034);
var _ = first__74035;
var branches = seq__74034__$1;
var contexts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (context,clause,orig_clause,vec__74033,seq__74034,first__74035,seq__74034__$1,_,branches,pred__74017,expr__74018){
return (function (p1__74004_SHARP_){
return (datascript.query.resolve_clause.cljs$core$IFn$_invoke$arity$2 ? datascript.query.resolve_clause.cljs$core$IFn$_invoke$arity$2(context,p1__74004_SHARP_) : datascript.query.resolve_clause.call(null,context,p1__74004_SHARP_));
});})(context,clause,orig_clause,vec__74033,seq__74034,first__74035,seq__74034__$1,_,branches,pred__74017,expr__74018))
,branches);
var rels = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (context,clause,orig_clause,vec__74033,seq__74034,first__74035,seq__74034__$1,_,branches,contexts,pred__74017,expr__74018){
return (function (p1__74005_SHARP_){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.hash_join,new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(p1__74005_SHARP_));
});})(context,clause,orig_clause,vec__74033,seq__74034,first__74035,seq__74034__$1,_,branches,contexts,pred__74017,expr__74018))
,contexts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(contexts),new cljs.core.Keyword(null,"rels","rels",1770187185),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.sum_rel,rels)], null));
} else {
if(cljs.core.truth_((function (){var G__74041 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"or-join","or-join",591375469,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"*","*",345799209,null)], null),new cljs.core.Symbol(null,"*","*",345799209,null)], null),new cljs.core.Symbol(null,"*","*",345799209,null)], null);
var G__74042 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74041,G__74042) : pred__74017.call(null,G__74041,G__74042));
})())){
var vec__74044 = clause;
var seq__74045 = cljs.core.seq(vec__74044);
var first__74046 = cljs.core.first(seq__74045);
var seq__74045__$1 = cljs.core.next(seq__74045);
var _ = first__74046;
var first__74046__$1 = cljs.core.first(seq__74045__$1);
var seq__74045__$2 = cljs.core.next(seq__74045__$1);
var vec__74047 = first__74046__$1;
var seq__74048 = cljs.core.seq(vec__74047);
var first__74049 = cljs.core.first(seq__74048);
var seq__74048__$1 = cljs.core.next(seq__74048);
var req_vars = first__74049;
var vars = seq__74048__$1;
var branches = seq__74045__$2;
datascript.query.check_bound(context,req_vars,orig_clause);

var G__74886 = context;
var G__74887 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(new cljs.core.Symbol(null,"or-join","or-join",591375469,null),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(req_vars,vars),branches);
var G__74888 = clause;
context = G__74886;
clause = G__74887;
orig_clause = G__74888;
continue;
} else {
if(cljs.core.truth_((function (){var G__74054 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"or-join","or-join",591375469,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"*","*",345799209,null)], null),new cljs.core.Symbol(null,"*","*",345799209,null)], null);
var G__74055 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74054,G__74055) : pred__74017.call(null,G__74054,G__74055));
})())){
var vec__74059 = clause;
var seq__74060 = cljs.core.seq(vec__74059);
var first__74061 = cljs.core.first(seq__74060);
var seq__74060__$1 = cljs.core.next(seq__74060);
var _ = first__74061;
var first__74061__$1 = cljs.core.first(seq__74060__$1);
var seq__74060__$2 = cljs.core.next(seq__74060__$1);
var vars = first__74061__$1;
var branches = seq__74060__$2;
var vars__$1 = cljs.core.set(vars);
var join_context = datascript.query.limit_context(context,vars__$1);
var contexts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (context,clause,orig_clause,vec__74059,seq__74060,first__74061,seq__74060__$1,_,first__74061__$1,seq__74060__$2,vars,branches,vars__$1,join_context,pred__74017,expr__74018){
return (function (p1__74006_SHARP_){
return datascript.query.limit_context((datascript.query.resolve_clause.cljs$core$IFn$_invoke$arity$2 ? datascript.query.resolve_clause.cljs$core$IFn$_invoke$arity$2(join_context,p1__74006_SHARP_) : datascript.query.resolve_clause.call(null,join_context,p1__74006_SHARP_)),vars__$1);
});})(context,clause,orig_clause,vec__74059,seq__74060,first__74061,seq__74060__$1,_,first__74061__$1,seq__74060__$2,vars,branches,vars__$1,join_context,pred__74017,expr__74018))
,branches);
var rels = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (context,clause,orig_clause,vec__74059,seq__74060,first__74061,seq__74060__$1,_,first__74061__$1,seq__74060__$2,vars,branches,vars__$1,join_context,contexts,pred__74017,expr__74018){
return (function (p1__74007_SHARP_){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.hash_join,new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(p1__74007_SHARP_));
});})(context,clause,orig_clause,vec__74059,seq__74060,first__74061,seq__74060__$1,_,first__74061__$1,seq__74060__$2,vars,branches,vars__$1,join_context,contexts,pred__74017,expr__74018))
,contexts);
var sum_rel = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.sum_rel,rels);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(context,new cljs.core.Keyword(null,"rels","rels",1770187185),datascript.query.collapse_rels,sum_rel);
} else {
if(cljs.core.truth_((function (){var G__74062 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.Symbol(null,"*","*",345799209,null)], null);
var G__74063 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74062,G__74063) : pred__74017.call(null,G__74062,G__74063));
})())){
var vec__74064 = clause;
var seq__74065 = cljs.core.seq(vec__74064);
var first__74066 = cljs.core.first(seq__74065);
var seq__74065__$1 = cljs.core.next(seq__74065);
var _ = first__74066;
var clauses = seq__74065__$1;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(datascript.query.resolve_clause,context,clauses);
} else {
if(cljs.core.truth_((function (){var G__74068 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.Symbol(null,"*","*",345799209,null)], null);
var G__74069 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74068,G__74069) : pred__74017.call(null,G__74068,G__74069));
})())){
var vec__74070 = clause;
var seq__74071 = cljs.core.seq(vec__74070);
var first__74072 = cljs.core.first(seq__74071);
var seq__74071__$1 = cljs.core.next(seq__74071);
var _ = first__74072;
var clauses = seq__74071__$1;
var bound_vars = cljs.core.set(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(((function (context,clause,orig_clause,vec__74070,seq__74071,first__74072,seq__74071__$1,_,clauses,pred__74017,expr__74018){
return (function (p1__74008_SHARP_){
return cljs.core.keys(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(p1__74008_SHARP_));
});})(context,clause,orig_clause,vec__74070,seq__74071,first__74072,seq__74071__$1,_,clauses,pred__74017,expr__74018))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context)], 0)));
var negation_vars = datascript.query.collect_vars(clauses);
var ___$1 = ((cljs.core.empty_QMARK_(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(bound_vars,negation_vars)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Insufficient bindings: none of ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([negation_vars], 0))," is bound in ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([orig_clause], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("query","where","query/where",-1935159429),new cljs.core.Keyword(null,"form","form",-1624062471),orig_clause], null))})():null);
var context_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(context,new cljs.core.Keyword(null,"rels","rels",1770187185),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.hash_join,new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context))], null));
var negation_context = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(datascript.query.resolve_clause,context_SINGLEQUOTE_,clauses);
var negation = datascript.query.subtract_rel(datascript.query.single(new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context_SINGLEQUOTE_)),cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.hash_join,new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(negation_context)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(context_SINGLEQUOTE_,new cljs.core.Keyword(null,"rels","rels",1770187185),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [negation], null));
} else {
if(cljs.core.truth_((function (){var G__74079 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"not-join","not-join",-645515756,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"*","*",345799209,null)], null),new cljs.core.Symbol(null,"*","*",345799209,null)], null);
var G__74080 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74079,G__74080) : pred__74017.call(null,G__74079,G__74080));
})())){
var vec__74081 = clause;
var seq__74082 = cljs.core.seq(vec__74081);
var first__74083 = cljs.core.first(seq__74082);
var seq__74082__$1 = cljs.core.next(seq__74082);
var _ = first__74083;
var first__74083__$1 = cljs.core.first(seq__74082__$1);
var seq__74082__$2 = cljs.core.next(seq__74082__$1);
var vars = first__74083__$1;
var clauses = seq__74082__$2;
var ___$1 = datascript.query.check_bound(context,vars,orig_clause);
var context_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(context,new cljs.core.Keyword(null,"rels","rels",1770187185),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.hash_join,new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context))], null));
var join_context = datascript.query.limit_context(context_SINGLEQUOTE_,vars);
var negation_context = datascript.query.limit_context(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(datascript.query.resolve_clause,join_context,clauses),vars);
var negation = datascript.query.subtract_rel(datascript.query.single(new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context_SINGLEQUOTE_)),cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(datascript.query.hash_join,new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(negation_context)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(context_SINGLEQUOTE_,new cljs.core.Keyword(null,"rels","rels",1770187185),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [negation], null));
} else {
if(cljs.core.truth_((function (){var G__74085 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"*","*",345799209,null)], null);
var G__74086 = expr__74018;
return (pred__74017.cljs$core$IFn$_invoke$arity$2 ? pred__74017.cljs$core$IFn$_invoke$arity$2(G__74085,G__74086) : pred__74017.call(null,G__74085,G__74086));
})())){
var source = datascript.query._STAR_implicit_source_STAR_;
var pattern = datascript.query.resolve_pattern_lookup_refs(source,clause);
var relation = datascript.query.lookup_pattern(source,pattern);
var _STAR_lookup_attrs_STAR__orig_val__74094 = datascript.query._STAR_lookup_attrs_STAR_;
var _STAR_lookup_attrs_STAR__temp_val__74095 = (((((!((source == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === source.datascript$db$IDB$))))?true:(((!source.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(datascript.db.IDB,source):false)):cljs.core.native_satisfies_QMARK_(datascript.db.IDB,source)))?datascript.query.dynamic_lookup_attrs(source,pattern):datascript.query._STAR_lookup_attrs_STAR_);
datascript.query._STAR_lookup_attrs_STAR_ = _STAR_lookup_attrs_STAR__temp_val__74095;

try{return cljs.core.update.cljs$core$IFn$_invoke$arity$4(context,new cljs.core.Keyword(null,"rels","rels",1770187185),datascript.query.collapse_rels,relation);
}finally {datascript.query._STAR_lookup_attrs_STAR_ = _STAR_lookup_attrs_STAR__orig_val__74094;
}} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__74018)].join('')));
}
}
}
}
}
}
}
}
}
}
break;
}
});

datascript.query._resolve_clause.cljs$lang$maxFixedArity = 3;

datascript.query.resolve_clause = (function datascript$query$resolve_clause(context,clause){
if(datascript.query.rule_QMARK_(context,clause)){
if(datascript.query.source_QMARK_(cljs.core.first(clause))){
var _STAR_implicit_source_STAR__orig_val__74103 = datascript.query._STAR_implicit_source_STAR_;
var _STAR_implicit_source_STAR__temp_val__74104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(context),cljs.core.first(clause));
datascript.query._STAR_implicit_source_STAR_ = _STAR_implicit_source_STAR__temp_val__74104;

try{var G__74105 = context;
var G__74106 = cljs.core.next(clause);
return (datascript.query.resolve_clause.cljs$core$IFn$_invoke$arity$2 ? datascript.query.resolve_clause.cljs$core$IFn$_invoke$arity$2(G__74105,G__74106) : datascript.query.resolve_clause.call(null,G__74105,G__74106));
}finally {datascript.query._STAR_implicit_source_STAR_ = _STAR_implicit_source_STAR__orig_val__74103;
}} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(context,new cljs.core.Keyword(null,"rels","rels",1770187185),datascript.query.collapse_rels,datascript.query.solve_rule(context,clause));
}
} else {
return datascript.query._resolve_clause.cljs$core$IFn$_invoke$arity$2(context,clause);
}
});
datascript.query._q = (function datascript$query$_q(context,clauses){
var _STAR_implicit_source_STAR__orig_val__74109 = datascript.query._STAR_implicit_source_STAR_;
var _STAR_implicit_source_STAR__temp_val__74110 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(context),new cljs.core.Symbol(null,"$","$",-1580747756,null));
datascript.query._STAR_implicit_source_STAR_ = _STAR_implicit_source_STAR__temp_val__74110;

try{return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(datascript.query.resolve_clause,context,clauses);
}finally {datascript.query._STAR_implicit_source_STAR_ = _STAR_implicit_source_STAR__orig_val__74109;
}});
datascript.query._collect = (function datascript$query$_collect(var_args){
var G__74116 = arguments.length;
switch (G__74116) {
case 2:
return datascript.query._collect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return datascript.query._collect.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

datascript.query._collect.cljs$core$IFn$_invoke$arity$2 = (function (context,symbols){
var rels = new cljs.core.Keyword(null,"rels","rels",1770187185).cljs$core$IFn$_invoke$arity$1(context);
return datascript.query._collect.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [me.tonsky.persistent_sorted_set.arrays.make_array(cljs.core.count(symbols))], null),rels,symbols);
});

datascript.query._collect.cljs$core$IFn$_invoke$arity$3 = (function (acc,rels,symbols){
while(true){
var temp__5820__auto__ = cljs.core.first(rels);
if((temp__5820__auto__ == null)){
return acc;
} else {
var rel = temp__5820__auto__;
var keep_attrs = cljs.core.select_keys(new cljs.core.Keyword(null,"attrs","attrs",-2090668713).cljs$core$IFn$_invoke$arity$1(rel),symbols);
if(cljs.core.empty_QMARK_(keep_attrs)){
var G__74960 = acc;
var G__74961 = cljs.core.next(rels);
var G__74962 = symbols;
acc = G__74960;
rels = G__74961;
symbols = G__74962;
continue;
} else {
var copy_map = cljs.core.to_array(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (acc,rels,symbols,keep_attrs,rel,temp__5820__auto__){
return (function (p1__74113_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(keep_attrs,p1__74113_SHARP_);
});})(acc,rels,symbols,keep_attrs,rel,temp__5820__auto__))
,symbols));
var len = cljs.core.count(symbols);
var G__74963 = (function (){var iter__4523__auto__ = ((function (acc,rels,symbols,copy_map,len,keep_attrs,rel,temp__5820__auto__){
return (function datascript$query$iter__74121(s__74122){
return (new cljs.core.LazySeq(null,((function (acc,rels,symbols,copy_map,len,keep_attrs,rel,temp__5820__auto__){
return (function (){
var s__74122__$1 = s__74122;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__74122__$1);
if(temp__5818__auto__){
var xs__6376__auto__ = temp__5818__auto__;
var t1 = cljs.core.first(xs__6376__auto__);
var iterys__4519__auto__ = ((function (s__74122__$1,acc,rels,symbols,t1,xs__6376__auto__,temp__5818__auto__,copy_map,len,keep_attrs,rel,temp__5820__auto__){
return (function datascript$query$iter__74121_$_iter__74123(s__74124){
return (new cljs.core.LazySeq(null,((function (s__74122__$1,acc,rels,symbols,t1,xs__6376__auto__,temp__5818__auto__,copy_map,len,keep_attrs,rel,temp__5820__auto__){
return (function (){
var s__74124__$1 = s__74124;
while(true){
var temp__5818__auto____$1 = cljs.core.seq(s__74124__$1);
if(temp__5818__auto____$1){
var s__74124__$2 = temp__5818__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__74124__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__74124__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__74126 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__74125 = (0);
while(true){
if((i__74125 < size__4522__auto__)){
var t2 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__74125);
cljs.core.chunk_append(b__74126,(function (){var res = cljs.core.aclone(t1);
var n__4607__auto___74971 = len;
var i_74972 = (0);
while(true){
if((i_74972 < n__4607__auto___74971)){
var temp__5822__auto___74974 = (copy_map[i_74972]);
if((temp__5822__auto___74974 == null)){
} else {
var idx_74975 = temp__5822__auto___74974;
(res[i_74972] = (t2[idx_74975]));
}

var G__74977 = (i_74972 + (1));
i_74972 = G__74977;
continue;
} else {
}
break;
}

return res;
})());

var G__74978 = (i__74125 + (1));
i__74125 = G__74978;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__74126),datascript$query$iter__74121_$_iter__74123(cljs.core.chunk_rest(s__74124__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__74126),null);
}
} else {
var t2 = cljs.core.first(s__74124__$2);
return cljs.core.cons((function (){var res = cljs.core.aclone(t1);
var n__4607__auto___74991 = len;
var i_74992 = (0);
while(true){
if((i_74992 < n__4607__auto___74991)){
var temp__5822__auto___74993 = (copy_map[i_74992]);
if((temp__5822__auto___74993 == null)){
} else {
var idx_74995 = temp__5822__auto___74993;
(res[i_74992] = (t2[idx_74995]));
}

var G__74996 = (i_74992 + (1));
i_74992 = G__74996;
continue;
} else {
}
break;
}

return res;
})(),datascript$query$iter__74121_$_iter__74123(cljs.core.rest(s__74124__$2)));
}
} else {
return null;
}
break;
}
});})(s__74122__$1,acc,rels,symbols,t1,xs__6376__auto__,temp__5818__auto__,copy_map,len,keep_attrs,rel,temp__5820__auto__))
,null,null));
});})(s__74122__$1,acc,rels,symbols,t1,xs__6376__auto__,temp__5818__auto__,copy_map,len,keep_attrs,rel,temp__5820__auto__))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(rel)));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,datascript$query$iter__74121(cljs.core.rest(s__74122__$1)));
} else {
var G__75003 = cljs.core.rest(s__74122__$1);
s__74122__$1 = G__75003;
continue;
}
} else {
return null;
}
break;
}
});})(acc,rels,symbols,copy_map,len,keep_attrs,rel,temp__5820__auto__))
,null,null));
});})(acc,rels,symbols,copy_map,len,keep_attrs,rel,temp__5820__auto__))
;
return iter__4523__auto__(acc);
})();
var G__74964 = cljs.core.next(rels);
var G__74965 = symbols;
acc = G__74963;
rels = G__74964;
symbols = G__74965;
continue;
}
}
break;
}
});

datascript.query._collect.cljs$lang$maxFixedArity = 3;

datascript.query.collect = (function datascript$query$collect(context,symbols){
return cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,datascript.query._collect.cljs$core$IFn$_invoke$arity$2(context,symbols)));
});

/**
 * @interface
 */
datascript.query.IContextResolve = function(){};

datascript.query._context_resolve = (function datascript$query$_context_resolve(var$,context){
if((((!((var$ == null)))) && ((!((var$.datascript$query$IContextResolve$_context_resolve$arity$2 == null)))))){
return var$.datascript$query$IContextResolve$_context_resolve$arity$2(var$,context);
} else {
var x__4433__auto__ = (((var$ == null))?null:var$);
var m__4434__auto__ = (datascript.query._context_resolve[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(var$,context) : m__4434__auto__.call(null,var$,context));
} else {
var m__4431__auto__ = (datascript.query._context_resolve["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(var$,context) : m__4431__auto__.call(null,var$,context));
} else {
throw cljs.core.missing_protocol("IContextResolve.-context-resolve",var$);
}
}
}
});

datascript.parser.Variable.prototype.datascript$query$IContextResolve$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.Variable.prototype.datascript$query$IContextResolve$_context_resolve$arity$2 = (function (var$,context){
var var$__$1 = this;
return datascript.query.context_resolve_val(context,var$__$1.symbol);
});

datascript.parser.SrcVar.prototype.datascript$query$IContextResolve$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.SrcVar.prototype.datascript$query$IContextResolve$_context_resolve$arity$2 = (function (var$,context){
var var$__$1 = this;
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(context,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"sources","sources",-321166424),var$__$1.symbol], null));
});

datascript.parser.PlainSymbol.prototype.datascript$query$IContextResolve$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.PlainSymbol.prototype.datascript$query$IContextResolve$_context_resolve$arity$2 = (function (var$,_){
var var$__$1 = this;
var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(datascript.query.built_in_aggregates,var$__$1.symbol);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return datascript.query.resolve_sym(var$__$1.symbol);
}
});

datascript.parser.Constant.prototype.datascript$query$IContextResolve$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.Constant.prototype.datascript$query$IContextResolve$_context_resolve$arity$2 = (function (var$,_){
var var$__$1 = this;
return var$__$1.value;
});
datascript.query._aggregate = (function datascript$query$_aggregate(find_elements,context,tuples){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((function (element,fixed_value,i){
if(datascript.parser.aggregate_QMARK_(element)){
var f = datascript.query._context_resolve(new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(element),context);
var args = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (f){
return (function (p1__74150_SHARP_){
return datascript.query._context_resolve(p1__74150_SHARP_,context);
});})(f))
,cljs.core.butlast(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(element)));
var vals = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (f,args){
return (function (p1__74151_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__74151_SHARP_,i);
});})(f,args))
,tuples);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [vals], null)));
} else {
return fixed_value;
}
}),find_elements,cljs.core.first(tuples),cljs.core.range.cljs$core$IFn$_invoke$arity$0());
});
datascript.query.idxs_of = (function datascript$query$idxs_of(pred,coll){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (p1__74154_SHARP_,p2__74155_SHARP_){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(p1__74154_SHARP_) : pred.call(null,p1__74154_SHARP_)))){
return p2__74155_SHARP_;
} else {
return null;
}
}),coll,cljs.core.range.cljs$core$IFn$_invoke$arity$0()));
});
datascript.query.aggregate = (function datascript$query$aggregate(find_elements,context,resultset){
var group_idxs = datascript.query.idxs_of(cljs.core.complement(datascript.parser.aggregate_QMARK_),find_elements);
var group_fn = ((function (group_idxs){
return (function (tuple){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (group_idxs){
return (function (p1__74158_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__74158_SHARP_);
});})(group_idxs))
,group_idxs);
});})(group_idxs))
;
var grouped = cljs.core.group_by(group_fn,resultset);
var iter__4523__auto__ = ((function (group_idxs,group_fn,grouped){
return (function datascript$query$aggregate_$_iter__74161(s__74162){
return (new cljs.core.LazySeq(null,((function (group_idxs,group_fn,grouped){
return (function (){
var s__74162__$1 = s__74162;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__74162__$1);
if(temp__5818__auto__){
var s__74162__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__74162__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__74162__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__74164 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__74163 = (0);
while(true){
if((i__74163 < size__4522__auto__)){
var vec__74171 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__74163);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74171,(0),null);
var tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74171,(1),null);
cljs.core.chunk_append(b__74164,datascript.query._aggregate(find_elements,context,tuples));

var G__75061 = (i__74163 + (1));
i__74163 = G__75061;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__74164),datascript$query$aggregate_$_iter__74161(cljs.core.chunk_rest(s__74162__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__74164),null);
}
} else {
var vec__74174 = cljs.core.first(s__74162__$2);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74174,(0),null);
var tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74174,(1),null);
return cljs.core.cons(datascript.query._aggregate(find_elements,context,tuples),datascript$query$aggregate_$_iter__74161(cljs.core.rest(s__74162__$2)));
}
} else {
return null;
}
break;
}
});})(group_idxs,group_fn,grouped))
,null,null));
});})(group_idxs,group_fn,grouped))
;
return iter__4523__auto__(grouped);
});

/**
 * @interface
 */
datascript.query.IPostProcess = function(){};

datascript.query._post_process = (function datascript$query$_post_process(find,tuples){
if((((!((find == null)))) && ((!((find.datascript$query$IPostProcess$_post_process$arity$2 == null)))))){
return find.datascript$query$IPostProcess$_post_process$arity$2(find,tuples);
} else {
var x__4433__auto__ = (((find == null))?null:find);
var m__4434__auto__ = (datascript.query._post_process[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(find,tuples) : m__4434__auto__.call(null,find,tuples));
} else {
var m__4431__auto__ = (datascript.query._post_process["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(find,tuples) : m__4431__auto__.call(null,find,tuples));
} else {
throw cljs.core.missing_protocol("IPostProcess.-post-process",find);
}
}
}
});

datascript.parser.FindRel.prototype.datascript$query$IPostProcess$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.FindRel.prototype.datascript$query$IPostProcess$_post_process$arity$2 = (function (_,tuples){
var ___$1 = this;
return tuples;
});

datascript.parser.FindColl.prototype.datascript$query$IPostProcess$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.FindColl.prototype.datascript$query$IPostProcess$_post_process$arity$2 = (function (_,tuples){
var ___$1 = this;
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first),tuples);
});

datascript.parser.FindScalar.prototype.datascript$query$IPostProcess$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.FindScalar.prototype.datascript$query$IPostProcess$_post_process$arity$2 = (function (_,tuples){
var ___$1 = this;
return cljs.core.ffirst(tuples);
});

datascript.parser.FindTuple.prototype.datascript$query$IPostProcess$ = cljs.core.PROTOCOL_SENTINEL;

datascript.parser.FindTuple.prototype.datascript$query$IPostProcess$_post_process$arity$2 = (function (_,tuples){
var ___$1 = this;
return cljs.core.first(tuples);
});
datascript.query.pull = (function datascript$query$pull(find_elements,context,resultset){
var resolved = (function (){var iter__4523__auto__ = (function datascript$query$pull_$_iter__74184(s__74185){
return (new cljs.core.LazySeq(null,(function (){
var s__74185__$1 = s__74185;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__74185__$1);
if(temp__5818__auto__){
var s__74185__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__74185__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__74185__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__74187 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__74186 = (0);
while(true){
if((i__74186 < size__4522__auto__)){
var find = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__74186);
cljs.core.chunk_append(b__74187,((datascript.parser.pull_QMARK_(find))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [datascript.query._context_resolve(new cljs.core.Keyword(null,"source","source",-433931539).cljs$core$IFn$_invoke$arity$1(find),context),datascript.pull_parser.parse_pull(datascript.query._context_resolve(new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(find),context))], null):null));

var G__75084 = (i__74186 + (1));
i__74186 = G__75084;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__74187),datascript$query$pull_$_iter__74184(cljs.core.chunk_rest(s__74185__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__74187),null);
}
} else {
var find = cljs.core.first(s__74185__$2);
return cljs.core.cons(((datascript.parser.pull_QMARK_(find))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [datascript.query._context_resolve(new cljs.core.Keyword(null,"source","source",-433931539).cljs$core$IFn$_invoke$arity$1(find),context),datascript.pull_parser.parse_pull(datascript.query._context_resolve(new cljs.core.Keyword(null,"pattern","pattern",242135423).cljs$core$IFn$_invoke$arity$1(find),context))], null):null),datascript$query$pull_$_iter__74184(cljs.core.rest(s__74185__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(find_elements);
})();
var iter__4523__auto__ = ((function (resolved){
return (function datascript$query$pull_$_iter__74193(s__74194){
return (new cljs.core.LazySeq(null,((function (resolved){
return (function (){
var s__74194__$1 = s__74194;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__74194__$1);
if(temp__5818__auto__){
var s__74194__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__74194__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__74194__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__74196 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__74195 = (0);
while(true){
if((i__74195 < size__4522__auto__)){
var tuple = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__74195);
cljs.core.chunk_append(b__74196,cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(((function (i__74195,tuple,c__4521__auto__,size__4522__auto__,b__74196,s__74194__$2,temp__5818__auto__,resolved){
return (function (env,el){
if(cljs.core.truth_(env)){
var vec__74198 = env;
var src = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74198,(0),null);
var spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74198,(1),null);
return datascript.pull_api.pull_spec(src,spec,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [el], null),false);
} else {
return el;
}
});})(i__74195,tuple,c__4521__auto__,size__4522__auto__,b__74196,s__74194__$2,temp__5818__auto__,resolved))
,resolved,tuple));

var G__75094 = (i__74195 + (1));
i__74195 = G__75094;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__74196),datascript$query$pull_$_iter__74193(cljs.core.chunk_rest(s__74194__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__74196),null);
}
} else {
var tuple = cljs.core.first(s__74194__$2);
return cljs.core.cons(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(((function (tuple,s__74194__$2,temp__5818__auto__,resolved){
return (function (env,el){
if(cljs.core.truth_(env)){
var vec__74205 = env;
var src = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74205,(0),null);
var spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74205,(1),null);
return datascript.pull_api.pull_spec(src,spec,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [el], null),false);
} else {
return el;
}
});})(tuple,s__74194__$2,temp__5818__auto__,resolved))
,resolved,tuple),datascript$query$pull_$_iter__74193(cljs.core.rest(s__74194__$2)));
}
} else {
return null;
}
break;
}
});})(resolved))
,null,null));
});})(resolved))
;
return iter__4523__auto__(resultset);
});
datascript.query.query_cache = cljs.core.volatile_BANG_(datascript.lru.lru((100)));
datascript.query.memoized_parse_query = (function datascript$query$memoized_parse_query(q){
var temp__5820__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.deref(datascript.query.query_cache),q,null);
if((temp__5820__auto__ == null)){
var qp = datascript.parser.parse_query(q);
datascript.query.query_cache.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(datascript.query.query_cache.cljs$core$IDeref$_deref$arity$1(null),q,qp));

return qp;
} else {
var cached = temp__5820__auto__;
return cached;
}
});
datascript.query.q = (function datascript$query$q(var_args){
var args__4736__auto__ = [];
var len__4730__auto___75117 = arguments.length;
var i__4731__auto___75118 = (0);
while(true){
if((i__4731__auto___75118 < len__4730__auto___75117)){
args__4736__auto__.push((arguments[i__4731__auto___75118]));

var G__75120 = (i__4731__auto___75118 + (1));
i__4731__auto___75118 = G__75120;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return datascript.query.q.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

datascript.query.q.cljs$core$IFn$_invoke$arity$variadic = (function (q,inputs){
var parsed_q = datascript.query.memoized_parse_query(q);
var find = new cljs.core.Keyword(null,"qfind","qfind",1529332972).cljs$core$IFn$_invoke$arity$1(parsed_q);
var find_elements = datascript.parser.find_elements(find);
var find_vars = datascript.parser.find_vars(find);
var result_arity = cljs.core.count(find_elements);
var with$ = new cljs.core.Keyword(null,"qwith","qwith",-45809392).cljs$core$IFn$_invoke$arity$1(parsed_q);
var all_vars = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(find_vars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"symbol","symbol",-1038572696),with$));
var q__$1 = (function (){var G__74219 = q;
if(cljs.core.sequential_QMARK_(q)){
return datascript.parser.query__GT_map(G__74219);
} else {
return G__74219;
}
})();
var wheres = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q__$1);
var context = datascript.query.resolve_ins((new datascript.query.Context(cljs.core.PersistentVector.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,null,null,null)),new cljs.core.Keyword(null,"qin","qin",1372651151).cljs$core$IFn$_invoke$arity$1(parsed_q),inputs);
var resultset = datascript.query.collect(datascript.query._q(context,wheres),all_vars);
var G__74220 = resultset;
var G__74220__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"with","with",-1536296876).cljs$core$IFn$_invoke$arity$1(q__$1))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__74220,parsed_q,find,find_elements,find_vars,result_arity,with$,all_vars,q__$1,wheres,context,resultset){
return (function (p1__74213_SHARP_){
return cljs.core.vec(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(p1__74213_SHARP_,(0),result_arity));
});})(G__74220,parsed_q,find,find_elements,find_vars,result_arity,with$,all_vars,q__$1,wheres,context,resultset))
,G__74220):G__74220);
var G__74220__$2 = (cljs.core.truth_(cljs.core.some(datascript.parser.aggregate_QMARK_,find_elements))?datascript.query.aggregate(find_elements,context,G__74220__$1):G__74220__$1);
var G__74220__$3 = (cljs.core.truth_(cljs.core.some(datascript.parser.pull_QMARK_,find_elements))?datascript.query.pull(find_elements,context,G__74220__$2):G__74220__$2);
return datascript.query._post_process(find,G__74220__$3);

});

datascript.query.q.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
datascript.query.q.cljs$lang$applyTo = (function (seq74214){
var G__74215 = cljs.core.first(seq74214);
var seq74214__$1 = cljs.core.next(seq74214);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74215,seq74214__$1);
});


//# sourceMappingURL=datascript.query.js.map
