goog.provide('clojure.data');
goog.require('cljs.core');
goog.require('clojure.set');
/**
 * Internal helper for diff.
 */
clojure.data.atom_diff = (function clojure$data$atom_diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b,null], null);
}
});
/**
 * Convert an associative-by-numeric-index collection into
 * an equivalent vector, with nil for any missing keys
 */
clojure.data.vectorize = (function clojure$data$vectorize(m){
if(cljs.core.seq(m)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,p__46744){
var vec__46745 = p__46744;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46745,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46745,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,k,v);
}),cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.keys(m)),null)),m);
} else {
return null;
}
});
/**
 * Diff associative things a and b, comparing only the key k.
 */
clojure.data.diff_associative_key = (function clojure$data$diff_associative_key(a,b,k){
var va = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,k);
var vb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,k);
var vec__46754 = clojure.data.diff(va,vb);
var a_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46754,(0),null);
var b_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46754,(1),null);
var ab = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46754,(2),null);
var in_a = cljs.core.contains_QMARK_(a,k);
var in_b = cljs.core.contains_QMARK_(b,k);
var same = ((in_a) && (in_b) && ((((!((ab == null)))) || ((((va == null)) && ((vb == null)))))));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((((in_a) && ((((!((a_STAR_ == null)))) || ((!(same)))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,a_STAR_]):null),((((in_b) && ((((!((b_STAR_ == null)))) || ((!(same)))))))?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,b_STAR_]):null),((same)?cljs.core.PersistentArrayMap.createAsIfByAssoc([k,ab]):null)], null);
});
/**
 * Diff associative things a and b, comparing only keys in ks (if supplied).
 */
clojure.data.diff_associative = (function clojure$data$diff_associative(var_args){
var G__46766 = arguments.length;
switch (G__46766) {
case 2:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(a,b,clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(a),cljs.core.keys(b)));
});

clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3 = (function (a,b,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (diff1,diff2){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.merge,diff1,diff2));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,null], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(clojure.data.diff_associative_key,a,b),ks));
});

clojure.data.diff_associative.cljs$lang$maxFixedArity = 3;

clojure.data.diff_sequential = (function clojure$data$diff_sequential(a,b){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.data.vectorize,clojure.data.diff_associative.cljs$core$IFn$_invoke$arity$3(((cljs.core.vector_QMARK_(a))?a:cljs.core.vec(a)),((cljs.core.vector_QMARK_(b))?b:cljs.core.vec(b)),cljs.core.range.cljs$core$IFn$_invoke$arity$1((function (){var x__4219__auto__ = cljs.core.count(a);
var y__4220__auto__ = cljs.core.count(b);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})()))));
});
clojure.data.diff_set = (function clojure$data$diff_set(a,b){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b)),cljs.core.not_empty(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a)),cljs.core.not_empty(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(a,b))], null);
});

/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.EqualityPartition = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.equality_partition = (function clojure$data$equality_partition(x){
if((((!((x == null)))) && ((!((x.clojure$data$EqualityPartition$equality_partition$arity$1 == null)))))){
return x.clojure$data$EqualityPartition$equality_partition$arity$1(x);
} else {
var x__4433__auto__ = (((x == null))?null:x);
var m__4434__auto__ = (clojure.data.equality_partition[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4434__auto__.call(null,x));
} else {
var m__4431__auto__ = (clojure.data.equality_partition["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4431__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("EqualityPartition.equality-partition",x);
}
}
}
});


/**
 * Implementation detail. Subject to change.
 * @interface
 */
clojure.data.Diff = function(){};

/**
 * Implementation detail. Subject to change.
 */
clojure.data.diff_similar = (function clojure$data$diff_similar(a,b){
if((((!((a == null)))) && ((!((a.clojure$data$Diff$diff_similar$arity$2 == null)))))){
return a.clojure$data$Diff$diff_similar$arity$2(a,b);
} else {
var x__4433__auto__ = (((a == null))?null:a);
var m__4434__auto__ = (clojure.data.diff_similar[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4434__auto__.call(null,a,b));
} else {
var m__4431__auto__ = (clojure.data.diff_similar["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(a,b) : m__4431__auto__.call(null,a,b));
} else {
throw cljs.core.missing_protocol("Diff.diff-similar",a);
}
}
}
});

goog.object.set(clojure.data.EqualityPartition,"null",true);

var G__46788_46881 = clojure.data.equality_partition;
var G__46789_46882 = "null";
var G__46790_46883 = ((function (G__46788_46881,G__46789_46882){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__46788_46881,G__46789_46882))
;
goog.object.set(G__46788_46881,G__46789_46882,G__46790_46883);

goog.object.set(clojure.data.EqualityPartition,"string",true);

var G__46791_46884 = clojure.data.equality_partition;
var G__46792_46885 = "string";
var G__46793_46886 = ((function (G__46791_46884,G__46792_46885){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__46791_46884,G__46792_46885))
;
goog.object.set(G__46791_46884,G__46792_46885,G__46793_46886);

goog.object.set(clojure.data.EqualityPartition,"number",true);

var G__46796_46887 = clojure.data.equality_partition;
var G__46797_46888 = "number";
var G__46798_46889 = ((function (G__46796_46887,G__46797_46888){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__46796_46887,G__46797_46888))
;
goog.object.set(G__46796_46887,G__46797_46888,G__46798_46889);

goog.object.set(clojure.data.EqualityPartition,"array",true);

var G__46801_46892 = clojure.data.equality_partition;
var G__46802_46893 = "array";
var G__46803_46894 = ((function (G__46801_46892,G__46802_46893){
return (function (x){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
});})(G__46801_46892,G__46802_46893))
;
goog.object.set(G__46801_46892,G__46802_46893,G__46803_46894);

goog.object.set(clojure.data.EqualityPartition,"function",true);

var G__46804_46898 = clojure.data.equality_partition;
var G__46805_46899 = "function";
var G__46806_46900 = ((function (G__46804_46898,G__46805_46899){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__46804_46898,G__46805_46899))
;
goog.object.set(G__46804_46898,G__46805_46899,G__46806_46900);

goog.object.set(clojure.data.EqualityPartition,"boolean",true);

var G__46807_46901 = clojure.data.equality_partition;
var G__46808_46902 = "boolean";
var G__46809_46903 = ((function (G__46807_46901,G__46808_46902){
return (function (x){
return new cljs.core.Keyword(null,"atom","atom",-397043653);
});})(G__46807_46901,G__46808_46902))
;
goog.object.set(G__46807_46901,G__46808_46902,G__46809_46903);

goog.object.set(clojure.data.EqualityPartition,"_",true);

var G__46810_46904 = clojure.data.equality_partition;
var G__46811_46905 = "_";
var G__46812_46906 = ((function (G__46810_46904,G__46811_46905){
return (function (x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x))){
return new cljs.core.Keyword(null,"map","map",1371690461);
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x))){
return new cljs.core.Keyword(null,"set","set",304602554);
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x))){
return new cljs.core.Keyword(null,"sequential","sequential",-1082983960);
} else {
return new cljs.core.Keyword(null,"atom","atom",-397043653);

}
}
}
});})(G__46810_46904,G__46811_46905))
;
goog.object.set(G__46810_46904,G__46811_46905,G__46812_46906);
goog.object.set(clojure.data.Diff,"null",true);

var G__46819_46916 = clojure.data.diff_similar;
var G__46820_46917 = "null";
var G__46821_46918 = ((function (G__46819_46916,G__46820_46917){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__46819_46916,G__46820_46917))
;
goog.object.set(G__46819_46916,G__46820_46917,G__46821_46918);

goog.object.set(clojure.data.Diff,"string",true);

var G__46826_46920 = clojure.data.diff_similar;
var G__46827_46921 = "string";
var G__46828_46922 = ((function (G__46826_46920,G__46827_46921){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__46826_46920,G__46827_46921))
;
goog.object.set(G__46826_46920,G__46827_46921,G__46828_46922);

goog.object.set(clojure.data.Diff,"number",true);

var G__46829_46923 = clojure.data.diff_similar;
var G__46830_46924 = "number";
var G__46831_46925 = ((function (G__46829_46923,G__46830_46924){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__46829_46923,G__46830_46924))
;
goog.object.set(G__46829_46923,G__46830_46924,G__46831_46925);

goog.object.set(clojure.data.Diff,"array",true);

var G__46833_46926 = clojure.data.diff_similar;
var G__46834_46927 = "array";
var G__46835_46928 = ((function (G__46833_46926,G__46834_46927){
return (function (a,b){
return clojure.data.diff_sequential(a,b);
});})(G__46833_46926,G__46834_46927))
;
goog.object.set(G__46833_46926,G__46834_46927,G__46835_46928);

goog.object.set(clojure.data.Diff,"function",true);

var G__46836_46930 = clojure.data.diff_similar;
var G__46837_46931 = "function";
var G__46838_46932 = ((function (G__46836_46930,G__46837_46931){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__46836_46930,G__46837_46931))
;
goog.object.set(G__46836_46930,G__46837_46931,G__46838_46932);

goog.object.set(clojure.data.Diff,"boolean",true);

var G__46839_46934 = clojure.data.diff_similar;
var G__46840_46935 = "boolean";
var G__46841_46936 = ((function (G__46839_46934,G__46840_46935){
return (function (a,b){
return clojure.data.atom_diff(a,b);
});})(G__46839_46934,G__46840_46935))
;
goog.object.set(G__46839_46934,G__46840_46935,G__46841_46936);

goog.object.set(clojure.data.Diff,"_",true);

var G__46842_46939 = clojure.data.diff_similar;
var G__46843_46940 = "_";
var G__46844_46941 = ((function (G__46842_46939,G__46843_46940){
return (function (a,b){
var fexpr__46846 = (function (){var G__46847 = clojure.data.equality_partition(a);
var G__46847__$1 = (((G__46847 instanceof cljs.core.Keyword))?G__46847.fqn:null);
switch (G__46847__$1) {
case "atom":
return clojure.data.atom_diff;

break;
case "set":
return clojure.data.diff_set;

break;
case "sequential":
return clojure.data.diff_sequential;

break;
case "map":
return clojure.data.diff_associative;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46847__$1)].join('')));

}
})();
return (fexpr__46846.cljs$core$IFn$_invoke$arity$2 ? fexpr__46846.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__46846.call(null,a,b));
});})(G__46842_46939,G__46843_46940))
;
goog.object.set(G__46842_46939,G__46843_46940,G__46844_46941);
/**
 * Recursively compares a and b, returning a tuple of
 *   [things-only-in-a things-only-in-b things-in-both].
 *   Comparison rules:
 * 
 *   * For equal a and b, return [nil nil a].
 *   * Maps are subdiffed where keys match and values differ.
 *   * Sets are never subdiffed.
 *   * All sequential things are treated as associative collections
 *  by their indexes, with results returned as vectors.
 *   * Everything else (including strings!) is treated as
 *  an atom and compared for equality.
 */
clojure.data.diff = (function clojure$data$diff(a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,null,a], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.data.equality_partition(a),clojure.data.equality_partition(b))){
return clojure.data.diff_similar(a,b);
} else {
return clojure.data.atom_diff(a,b);
}
}
});

//# sourceMappingURL=clojure.data.js.map
