goog.provide('clojure.core.matrix.utils');
goog.require('cljs.core');
clojure.core.matrix.utils.class$ = cljs.core.type;
/**
 * returns true if the given object is a valid core.matrix array shape.
 */
clojure.core.matrix.utils.valid_shape_QMARK_ = (function clojure$core$matrix$utils$valid_shape_QMARK_(shape){
try{return (((cljs.core.count(shape) >= (0))) && (cljs.core.every_QMARK_(cljs.core.integer_QMARK_,shape)));
}catch (e53460){if((e53460 instanceof Error)){
var t = e53460;
return false;
} else {
throw e53460;

}
}});
/**
 * Returns true if two shapes are the same.
 */
clojure.core.matrix.utils.same_shape_object_QMARK_ = (function clojure$core$matrix$utils$same_shape_object_QMARK_(sa,sb){
if((sa === sb)){
return true;
} else {
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(sa),cljs.core.count(sb))){
return false;
} else {
var ca = cljs.core.count(sa);
var i = (0);
while(true){
if((i >= ca)){
return true;
} else {
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sa,i) === cljs.core.nth.cljs$core$IFn$_invoke$arity$2(sb,i))){
var G__53630 = (i + (1));
i = G__53630;
continue;
} else {
return false;
}
}
break;
}

}
}
});
/**
 * Returns the logical xor of a set of values, considered as booleans
 */
clojure.core.matrix.utils.xor = (function clojure$core$matrix$utils$xor(var_args){
var G__53479 = arguments.length;
switch (G__53479) {
case 0:
return clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___53632 = arguments.length;
var i__4731__auto___53633 = (0);
while(true){
if((i__4731__auto___53633 < len__4730__auto___53632)){
args_arr__4751__auto__.push((arguments[i__4731__auto___53633]));

var G__53634 = (i__4731__auto___53633 + (1));
i__4731__auto___53633 = G__53634;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$0 = (function (){
return false;
});

clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$1 = (function (x){
return cljs.core.boolean$(x);
});

clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if(cljs.core.truth_(x)){
return cljs.core.not(y);
} else {
return cljs.core.boolean$(y);
}
});

clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
var p = clojure.core.matrix.utils.xor.cljs$core$IFn$_invoke$arity$2(x,y);
var ss = cljs.core.seq(more);
while(true){
if(ss){
var G__53637 = (cljs.core.truth_(cljs.core.first(ss))?(!(p)):p);
var G__53638 = cljs.core.next(ss);
p = G__53637;
ss = G__53638;
continue;
} else {
return p;
}
break;
}
});

/** @this {Function} */
clojure.core.matrix.utils.xor.cljs$lang$applyTo = (function (seq53476){
var G__53477 = cljs.core.first(seq53476);
var seq53476__$1 = cljs.core.next(seq53476);
var G__53478 = cljs.core.first(seq53476__$1);
var seq53476__$2 = cljs.core.next(seq53476__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53477,G__53478,seq53476__$2);
});

clojure.core.matrix.utils.xor.cljs$lang$maxFixedArity = (2);

/**
 * Returns a copy of a double array
 */
clojure.core.matrix.utils.copy_double_array = (function clojure$core$matrix$utils$copy_double_array(arr){
return arr.slice((0));
});
/**
 * Returns a copy of a long array
 */
clojure.core.matrix.utils.copy_long_array = (function clojure$core$matrix$utils$copy_long_array(arr){
return arr.slice((0));
});
/**
 * Returns a copy of a long array
 */
clojure.core.matrix.utils.copy_object_array = (function clojure$core$matrix$utils$copy_object_array(arr){
return arr.slice((0));
});
/**
 * Returns a range of longs in a long[] array
 */
clojure.core.matrix.utils.long_range = (function clojure$core$matrix$utils$long_range(end){
var end__$1 = (end | (0));
var arr = cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(end__$1);
var n__4607__auto___53642 = end__$1;
var i_53643 = (0);
while(true){
if((i_53643 < n__4607__auto___53642)){
(arr[i_53643] = cljs.core.long$(i_53643));

var G__53644 = (i_53643 + (1));
i_53643 = G__53644;
continue;
} else {
}
break;
}

return arr;
});
/**
 * Creates a long array with the specified values.
 */
clojure.core.matrix.utils.long_array_of = (function clojure$core$matrix$utils$long_array_of(var_args){
var G__53530 = arguments.length;
switch (G__53530) {
case 0:
return clojure.core.matrix.utils.long_array_of.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return clojure.core.matrix.utils.long_array_of.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.matrix.utils.long_array_of.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___53648 = arguments.length;
var i__4731__auto___53649 = (0);
while(true){
if((i__4731__auto___53649 < len__4730__auto___53648)){
args_arr__4751__auto__.push((arguments[i__4731__auto___53649]));

var G__53650 = (i__4731__auto___53649 + (1));
i__4731__auto___53649 = G__53650;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return clojure.core.matrix.utils.long_array_of.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

clojure.core.matrix.utils.long_array_of.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((0));
});

clojure.core.matrix.utils.long_array_of.cljs$core$IFn$_invoke$arity$1 = (function (a){
var arr = cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((1));
(arr[(0)] = cljs.core.long$(a));

return arr;
});

clojure.core.matrix.utils.long_array_of.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var arr = cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((2));
(arr[(0)] = cljs.core.long$(a));

(arr[(1)] = cljs.core.long$(b));

return arr;
});

clojure.core.matrix.utils.long_array_of.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,more){
var arr = cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(((2) + cljs.core.count(more)));
(arr[(0)] = cljs.core.long$(a));

(arr[(1)] = cljs.core.long$(b));

var G__53542_53655 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [clojure.core.matrix.utils.x,more,clojure.core.matrix.utils.i], null);
var G__53543_53656 = (arr[((2) + clojure.core.matrix.utils.i)] = cljs.core.long$(clojure.core.matrix.utils.x));
(clojure.core.matrix.utils.doseq_indexed.cljs$core$IFn$_invoke$arity$2 ? clojure.core.matrix.utils.doseq_indexed.cljs$core$IFn$_invoke$arity$2(G__53542_53655,G__53543_53656) : clojure.core.matrix.utils.doseq_indexed.call(null,G__53542_53655,G__53543_53656));

return arr;
});

/** @this {Function} */
clojure.core.matrix.utils.long_array_of.cljs$lang$applyTo = (function (seq53527){
var G__53528 = cljs.core.first(seq53527);
var seq53527__$1 = cljs.core.next(seq53527);
var G__53529 = cljs.core.first(seq53527__$1);
var seq53527__$2 = cljs.core.next(seq53527__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53528,G__53529,seq53527__$2);
});

clojure.core.matrix.utils.long_array_of.cljs$lang$maxFixedArity = (2);

/**
 * Creates a long array with the specified values.
 */
clojure.core.matrix.utils.object_array_of = (function clojure$core$matrix$utils$object_array_of(var_args){
var G__53555 = arguments.length;
switch (G__53555) {
case 0:
return clojure.core.matrix.utils.object_array_of.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return clojure.core.matrix.utils.object_array_of.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.matrix.utils.object_array_of.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___53668 = arguments.length;
var i__4731__auto___53669 = (0);
while(true){
if((i__4731__auto___53669 < len__4730__auto___53668)){
args_arr__4751__auto__.push((arguments[i__4731__auto___53669]));

var G__53674 = (i__4731__auto___53669 + (1));
i__4731__auto___53669 = G__53674;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((2)),(0),null));
return clojure.core.matrix.utils.object_array_of.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4752__auto__);

}
});

clojure.core.matrix.utils.object_array_of.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((0));
});

clojure.core.matrix.utils.object_array_of.cljs$core$IFn$_invoke$arity$1 = (function (a){
var arr = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((1));
(arr[(0)] = a);

return arr;
});

clojure.core.matrix.utils.object_array_of.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var arr = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((2));
(arr[(0)] = a);

(arr[(1)] = b);

return arr;
});

clojure.core.matrix.utils.object_array_of.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,more){
var arr = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(((2) + cljs.core.count(more)));
(arr[(0)] = a);

(arr[(1)] = b);

var G__53564_53675 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [clojure.core.matrix.utils.x,more,clojure.core.matrix.utils.i], null);
var G__53565_53676 = (arr[((2) + clojure.core.matrix.utils.i)] = clojure.core.matrix.utils.x);
(clojure.core.matrix.utils.doseq_indexed.cljs$core$IFn$_invoke$arity$2 ? clojure.core.matrix.utils.doseq_indexed.cljs$core$IFn$_invoke$arity$2(G__53564_53675,G__53565_53676) : clojure.core.matrix.utils.doseq_indexed.call(null,G__53564_53675,G__53565_53676));

return arr;
});

/** @this {Function} */
clojure.core.matrix.utils.object_array_of.cljs$lang$applyTo = (function (seq53552){
var G__53553 = cljs.core.first(seq53552);
var seq53552__$1 = cljs.core.next(seq53552);
var G__53554 = cljs.core.first(seq53552__$1);
var seq53552__$2 = cljs.core.next(seq53552__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53553,G__53554,seq53552__$2);
});

clojure.core.matrix.utils.object_array_of.cljs$lang$maxFixedArity = (2);

/**
 * Returns the index of a value in a vector, or nil if not present
 */
clojure.core.matrix.utils.find_index = (function clojure$core$matrix$utils$find_index(v,value){
var n = cljs.core.count(v);
var i = (0);
while(true){
if((i < n)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i))){
return i;
} else {
var G__53681 = (i + (1));
i = G__53681;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns a sequence of all possible index vectors for a given shape, in row-major order
 */
clojure.core.matrix.utils.base_index_seq_for_shape = (function clojure$core$matrix$utils$base_index_seq_for_shape(sh){
var gen = (function clojure$core$matrix$utils$base_index_seq_for_shape_$_gen(prefix,rem){
if(cljs.core.truth_(rem)){
var nrem = cljs.core.next(rem);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(((function (nrem){
return (function (p1__53572_SHARP_){
return clojure$core$matrix$utils$base_index_seq_for_shape_$_gen(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,p1__53572_SHARP_),nrem);
});})(nrem))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.first(rem))], 0));
} else {
return (new cljs.core.List(null,prefix,null,(1),null));
}
});
return gen(cljs.core.PersistentVector.EMPTY,cljs.core.seq(sh));
});
/**
 * Returns the smallest shape that both shapes a and b can broadcast to, or nil if the the shapes
 * are not compatible.
 */
clojure.core.matrix.utils.broadcast_shape_STAR_ = (function clojure$core$matrix$utils$broadcast_shape_STAR_(var_args){
var G__53576 = arguments.length;
switch (G__53576) {
case 2:
return clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
if(cljs.core.empty_QMARK_(a)){
var or__4131__auto__ = b;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
if(cljs.core.empty_QMARK_(b)){
return a;
} else {
if(((1) === cljs.core.first(a))){
return clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.first(b),cljs.core.next(a),cljs.core.next(b));
} else {
if(((1) === cljs.core.first(b))){
return clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.first(a),cljs.core.next(a),cljs.core.next(b));
} else {
if((cljs.core.first(a) === cljs.core.first(b))){
return clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.first(a),cljs.core.next(a),cljs.core.next(b));
} else {
return null;

}
}
}
}
}
});

clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (prefix,a,b){
if(cljs.core.truth_((function (){var or__4131__auto__ = a;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return b;
}
})())){
var r = clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$2(a,b);
if(cljs.core.truth_(r)){
return cljs.core.cons(prefix,r);
} else {
return null;
}
} else {
return cljs.core.cons(prefix,null);
}
});

clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Returns the smallest compatible shape that a set of shapes can all broadcast to.
 * Returns nil if this is not possible (i.e. the shapes are incompatible).
 * Returns an empty list if both shape sequences are empty (i.e. represent scalars)
 */
clojure.core.matrix.utils.broadcast_shape = (function clojure$core$matrix$utils$broadcast_shape(var_args){
var G__53592 = arguments.length;
switch (G__53592) {
case 1:
return clojure.core.matrix.utils.broadcast_shape.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return clojure.core.matrix.utils.broadcast_shape.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

clojure.core.matrix.utils.broadcast_shape.cljs$core$IFn$_invoke$arity$1 = (function (a){
return a;
});

clojure.core.matrix.utils.broadcast_shape.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var a__$1 = cljs.core.seq(cljs.core.reverse(a));
var b__$1 = cljs.core.seq(cljs.core.reverse(b));
var r = clojure.core.matrix.utils.broadcast_shape_STAR_.cljs$core$IFn$_invoke$arity$2(a__$1,b__$1);
if(cljs.core.truth_(r)){
return cljs.core.reverse(r);
} else {
return null;
}
});

clojure.core.matrix.utils.broadcast_shape.cljs$lang$maxFixedArity = 2;

/**
 * Returns truthy if the first shape a can be broadcast to the shape b
 */
clojure.core.matrix.utils.can_broadcast = (function clojure$core$matrix$utils$can_broadcast(from_shape,to_shape){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("TODO: not yet implemented",cljs.core.PersistentArrayMap.EMPTY);
});
/**
 * Returns true if an argument is a protocol'
 */
clojure.core.matrix.utils.protocol_QMARK_ = (function clojure$core$matrix$utils$protocol_QMARK_(p){
var and__4120__auto__ = cljs.core.map_QMARK_(p);
if(and__4120__auto__){
var and__4120__auto____$1 = new cljs.core.Keyword(null,"on-interface","on-interface",1993482222).cljs$core$IFn$_invoke$arity$1(p);
if(cljs.core.truth_(and__4120__auto____$1)){
return new cljs.core.Keyword(null,"on-interface","on-interface",1993482222).cljs$core$IFn$_invoke$arity$1(p).isInterface();
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});
/**
 * Transform MapEntry to just map with some additional fields
 */
clojure.core.matrix.utils.enhance_protocol_kv = (function clojure$core$matrix$utils$enhance_protocol_kv(p__53609){
var vec__53610 = p__53609;
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53610,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53610,(1),null);
var m = cljs.core.meta(new cljs.core.Keyword(null,"var","var",-769682797).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(p)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.deref(p),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(m),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"name","name",1843675177),name], 0));
});
clojure.core.matrix.utils.update_indexed = (function clojure$core$matrix$utils$update_indexed(xs,idxs,f){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__53618_SHARP_,p2__53619_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__53618_SHARP_,p2__53619_SHARP_,(function (){var G__53620 = p2__53619_SHARP_;
var G__53621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__53618_SHARP_,p2__53619_SHARP_);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__53620,G__53621) : f.call(null,G__53620,G__53621));
})());
}),xs,idxs);
});

//# sourceMappingURL=clojure.core.matrix.utils.js.map
