goog.provide('clojure.core.matrix.impl.common');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.core.matrix.protocols');
goog.require('clojure.core.matrix.utils');
goog.require('clojure.core.matrix.implementations');
/**
 * Returns a list of available implementations' objects
 */
clojure.core.matrix.impl.common.get_impl_objs = (function clojure$core$matrix$impl$common$get_impl_objs(){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.second,(function (){var iter__4523__auto__ = (function clojure$core$matrix$impl$common$get_impl_objs_$_iter__53863(s__53864){
return (new cljs.core.LazySeq(null,(function (){
var s__53864__$1 = s__53864;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__53864__$1);
if(temp__5818__auto__){
var s__53864__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__53864__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__53864__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__53866 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__53865 = (0);
while(true){
if((i__53865 < size__4522__auto__)){
var vec__53867 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__53865);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53867,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53867,(1),null);
if(cljs.core.not((function (){var fexpr__53870 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"persistent-vector","persistent-vector",2032618025),null,new cljs.core.Keyword(null,"TODO","TODO",-523795145),null], null), null);
return (fexpr__53870.cljs$core$IFn$_invoke$arity$1 ? fexpr__53870.cljs$core$IFn$_invoke$arity$1(ns) : fexpr__53870.call(null,ns));
})())){
cljs.core.chunk_append(b__53866,(function (){try{return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"obj","obj",981763962),clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(name)], null);
}catch (e53871){if((e53871 instanceof Error)){
var t = e53871;
return null;
} else {
throw e53871;

}
}})());

var G__53923 = (i__53865 + (1));
i__53865 = G__53923;
continue;
} else {
var G__53924 = (i__53865 + (1));
i__53865 = G__53924;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__53866),clojure$core$matrix$impl$common$get_impl_objs_$_iter__53863(cljs.core.chunk_rest(s__53864__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__53866),null);
}
} else {
var vec__53873 = cljs.core.first(s__53864__$2);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53873,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53873,(1),null);
if(cljs.core.not((function (){var fexpr__53876 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"persistent-vector","persistent-vector",2032618025),null,new cljs.core.Keyword(null,"TODO","TODO",-523795145),null], null), null);
return (fexpr__53876.cljs$core$IFn$_invoke$arity$1 ? fexpr__53876.cljs$core$IFn$_invoke$arity$1(ns) : fexpr__53876.call(null,ns));
})())){
return cljs.core.cons((function (){try{return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"obj","obj",981763962),clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(name)], null);
}catch (e53877){if((e53877 instanceof Error)){
var t = e53877;
return null;
} else {
throw e53877;

}
}})(),clojure$core$matrix$impl$common$get_impl_objs_$_iter__53863(cljs.core.rest(s__53864__$2)));
} else {
var G__53925 = cljs.core.rest(s__53864__$2);
s__53864__$1 = G__53925;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(clojure.core.matrix.implementations.KNOWN_IMPLEMENTATIONS);
})());
});
/**
 * Constructs an array from the provided data, attempting to use the given implementation.
 * Uses a default implementation if needed
 */
clojure.core.matrix.impl.common.construct_matrix = (function clojure$core$matrix$impl$common$construct_matrix(impl,data){
var or__4131__auto__ = clojure.core.matrix.protocols.construct_matrix(impl,data);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = (function (){try{return clojure.core.matrix.protocols.construct_matrix(clojure.core.matrix.implementations._STAR_matrix_implementation_STAR_,data);
}catch (e53880){if((e53880 instanceof clojure.core.matrix.impl.common.ClassCastException)){
var t = e53880;
return null;
} else {
throw e53880;

}
}})();
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return clojure.core.matrix.protocols.construct_matrix(cljs.core.PersistentVector.EMPTY,data);
}
}
});
/**
 * Maps a function over all components of a persistent vector matrix. Like mapv but for matrices.
 * Assumes correct dimensionality / shape.
 * 
 * First array argument must be nested persistent vectors. Others may be
 * any arrays of the same shape.
 * 
 * Returns a nested persistent vector matrix or a scalar value.
 */
clojure.core.matrix.impl.common.mapmatrix = (function clojure$core$matrix$impl$common$mapmatrix(var_args){
var G__53888 = arguments.length;
switch (G__53888) {
case 2:
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4751__auto__ = [];
var len__4730__auto___53927 = arguments.length;
var i__4731__auto___53928 = (0);
while(true){
if((i__4731__auto___53928 < len__4730__auto___53927)){
args_arr__4751__auto__.push((arguments[i__4731__auto___53928]));

var G__53929 = (i__4731__auto___53928 + (1));
i__4731__auto___53928 = G__53929;
continue;
} else {
}
break;
}

var argseq__4752__auto__ = (new cljs.core.IndexedSeq(args_arr__4751__auto__.slice((4)),(0),null));
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4752__auto__);

}
});

clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$2 = (function (f,m){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
if(((0) === dims)){
var G__53889 = (function (){var x__53433__auto__ = m;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__53889) : f.call(null,G__53889));
} else {
if(((1) === dims)){
return clojure.core.matrix.impl.common.construct_matrix(m,cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,clojure.core.matrix.protocols.element_seq(m)));
} else {
var res = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.impl.common.mapmatrix,f),clojure.core.matrix.protocols.get_major_slice_seq(m));
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.coerce_param(m,res),cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(clojure.core.matrix.protocols.get_shape(m))], null),cljs.core.next(clojure.core.matrix.protocols.get_shape(res)))));

}
}
});

clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$3 = (function (f,m1,m2){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m1));
if(((0) === dims)){
var G__53892 = (function (){var x__53433__auto__ = m1;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})();
var G__53893 = (function (){var x__53433__auto__ = m2;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__53892,G__53893) : f.call(null,G__53892,G__53893));
} else {
if(((1) === dims)){
return clojure.core.matrix.impl.common.construct_matrix(m1,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,clojure.core.matrix.protocols.element_seq(m1),clojure.core.matrix.protocols.element_seq(m2)));
} else {
var res = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.impl.common.mapmatrix,f),clojure.core.matrix.protocols.get_major_slice_seq(m1),clojure.core.matrix.protocols.get_major_slice_seq(m2));
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.coerce_param(m1,res),cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(clojure.core.matrix.protocols.get_shape(m1))], null),cljs.core.next(clojure.core.matrix.protocols.get_shape(res)))));

}
}
});

clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$4 = (function (f,m1,m2,m3){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m1));
if(((0) === dims)){
var G__53894 = (function (){var x__53433__auto__ = m1;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})();
var G__53895 = (function (){var x__53433__auto__ = m2;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})();
var G__53896 = (function (){var x__53433__auto__ = m3;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})();
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__53894,G__53895,G__53896) : f.call(null,G__53894,G__53895,G__53896));
} else {
if(((1) === dims)){
return clojure.core.matrix.impl.common.construct_matrix(m1,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,clojure.core.matrix.protocols.element_seq(m1),clojure.core.matrix.protocols.element_seq(m2),clojure.core.matrix.protocols.element_seq(m3)));
} else {
var res = cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.impl.common.mapmatrix,f),clojure.core.matrix.protocols.get_major_slice_seq(m1),clojure.core.matrix.protocols.get_major_slice_seq(m2),clojure.core.matrix.protocols.get_major_slice_seq(m3));
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.coerce_param(m1,res),cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(clojure.core.matrix.protocols.get_shape(m1))], null),cljs.core.next(clojure.core.matrix.protocols.get_shape(res)))));

}
}
});

clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$variadic = (function (f,m1,m2,m3,more){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m1));
if(((0) === dims)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(function (){var x__53433__auto__ = m1;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})(),(function (){var x__53433__auto__ = m2;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})(),(function (){var x__53433__auto__ = m3;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_0d,more));
} else {
if(((1) === dims)){
return clojure.core.matrix.impl.common.construct_matrix(m1,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,clojure.core.matrix.protocols.element_seq(m1),clojure.core.matrix.protocols.element_seq(m2),clojure.core.matrix.protocols.element_seq(m3),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.element_seq,more)], 0)));
} else {
var res = cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.impl.common.mapmatrix,f),clojure.core.matrix.protocols.get_major_slice_seq(m1),clojure.core.matrix.protocols.get_major_slice_seq(m2),clojure.core.matrix.protocols.get_major_slice_seq(m3),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_major_slice_seq,more)], 0));
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.coerce_param(m1,res),cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(clojure.core.matrix.protocols.get_shape(m1))], null),cljs.core.next(clojure.core.matrix.protocols.get_shape(res)))));

}
}
});

/** @this {Function} */
clojure.core.matrix.impl.common.mapmatrix.cljs$lang$applyTo = (function (seq53883){
var G__53884 = cljs.core.first(seq53883);
var seq53883__$1 = cljs.core.next(seq53883);
var G__53885 = cljs.core.first(seq53883__$1);
var seq53883__$2 = cljs.core.next(seq53883__$1);
var G__53886 = cljs.core.first(seq53883__$2);
var seq53883__$3 = cljs.core.next(seq53883__$2);
var G__53887 = cljs.core.first(seq53883__$3);
var seq53883__$4 = cljs.core.next(seq53883__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53884,G__53885,G__53886,G__53887,seq53883__$4);
});

clojure.core.matrix.impl.common.mapmatrix.cljs$lang$maxFixedArity = (4);

/**
 * Logistic function, with primitive type hints
 */
clojure.core.matrix.impl.common.logistic_fn = (function clojure$core$matrix$impl$common$logistic_fn(t){
var e_t = (function (){var G__53915 = (- t);
return Math.exp(G__53915);
})();
return (1.0 / (1.0 + e_t));
});
/**
 * Softplus function, with primitive type hints
 */
clojure.core.matrix.impl.common.softplus_fn = (function clojure$core$matrix$impl$common$softplus_fn(t){
if((t > 100.0)){
return t;
} else {
var et = Math.exp(t);
var G__53919 = (1.0 + et);
return Math.log(G__53919);
}
});
/**
 * ReLU function, with primitive type hints
 */
clojure.core.matrix.impl.common.relu_fn = (function clojure$core$matrix$impl$common$relu_fn(t){
return Math.max(0.0,t);
});
/**
 * Returns true if matrix is square (2D with same number of rows and columns)
 */
clojure.core.matrix.impl.common.square_QMARK_ = (function clojure$core$matrix$impl$common$square_QMARK_(m){
return ((((2) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))) && ((cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0))) === cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(1))))));
});
/**
 * Returns true iff square matrix m is symmetric.
 */
clojure.core.matrix.impl.common.symmetric_matrix_entries_QMARK_ = (function clojure$core$matrix$impl$common$symmetric_matrix_entries_QMARK_(m){
var dim = cljs.core.long$(cljs.core.first(clojure.core.matrix.protocols.get_shape(m)));
var f = ((function (dim){
return (function clojure$core$matrix$impl$common$symmetric_matrix_entries_QMARK__$_f(i,j){
while(true){
if((i >= dim)){
return true;
} else {
if((j >= dim)){
var G__53968 = ((1) + i);
var G__53969 = ((2) + i);
i = G__53968;
j = G__53969;
continue;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_2d(m,i,j),clojure.core.matrix.protocols.get_2d(m,j,i))){
var G__53970 = i;
var G__53971 = (j + (1));
i = G__53970;
j = G__53971;
continue;
} else {
return false;

}
}
}
break;
}
});})(dim))
;
return f((0),(1));
});

//# sourceMappingURL=clojure.core.matrix.impl.common.js.map
