goog.provide('clograms.external');
goog.require('cljs.core');
goog.require('ajax.core');
goog.require('clograms.db');
goog.require('clograms.re_grams.re_grams');
goog.require('goog.string');
clograms.external.reload_config = (function clograms$external$reload_config(port){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"http-xhrio","http-xhrio",1846166714),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"uri","uri",-774711847),goog.string.format("http://localhost:%s/config",port),new cljs.core.Keyword(null,"timeout","timeout",-318625318),(8000),new cljs.core.Keyword(null,"response-format","response-format",1664465322),(ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0 ? ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0() : ajax.core.raw_response_format.call(null)),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","config-loaded","clograms.events/config-loaded",454416280)], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","reload-failed","clograms.events/reload-failed",491208769)], null)], null)], null);
});
clograms.external.reload_datascript_db = (function clograms$external$reload_datascript_db(port){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"http-xhrio","http-xhrio",1846166714),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"uri","uri",-774711847),goog.string.format("http://localhost:%s/db",port),new cljs.core.Keyword(null,"timeout","timeout",-318625318),(8000),new cljs.core.Keyword(null,"response-format","response-format",1664465322),(ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0 ? ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0() : ajax.core.raw_response_format.call(null)),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","db-loaded","clograms.events/db-loaded",1556484560)], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","reload-failed","clograms.events/reload-failed",491208769)], null)], null)], null);
});
clograms.external.load_diagram = (function clograms$external$load_diagram(port){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"http-xhrio","http-xhrio",1846166714),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"uri","uri",-774711847),goog.string.format("http://localhost:%s/diagram",port),new cljs.core.Keyword(null,"timeout","timeout",-318625318),(8000),new cljs.core.Keyword(null,"response-format","response-format",1664465322),(ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0 ? ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0() : ajax.core.raw_response_format.call(null)),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","diagram-loaded","clograms.events/diagram-loaded",1672036047)], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","diagram-load-failed","clograms.events/diagram-load-failed",-1724864909)], null)], null)], null);
});
clograms.external.save_diagram = (function clograms$external$save_diagram(diagram,port){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"http-xhrio","http-xhrio",1846166714),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"uri","uri",-774711847),goog.string.format("http://localhost:%s/diagram",port),new cljs.core.Keyword(null,"timeout","timeout",-318625318),(8000),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([diagram], 0)),new cljs.core.Keyword(null,"format","format",-1306924766),(ajax.core.text_request_format.cljs$core$IFn$_invoke$arity$0 ? ajax.core.text_request_format.cljs$core$IFn$_invoke$arity$0() : ajax.core.text_request_format.call(null)),new cljs.core.Keyword(null,"response-format","response-format",1664465322),(ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0 ? ajax.core.raw_response_format.cljs$core$IFn$_invoke$arity$0() : ajax.core.raw_response_format.call(null)),new cljs.core.Keyword(null,"on-success","on-success",1786904109),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","save-failed","clograms.events/save-failed",-1965035557)], null)], null)], null);
});
clograms.external.db_loaded = (function clograms$external$db_loaded(db,ds_db_str){
var datascript_db = clograms.db.deserialize_datascript_db(ds_db_str);
var main_project_id = clograms.db.main_project_id(datascript_db);
console.log("Have ",cljs.core.count(datascript_db),"datoms. Main project id ",main_project_id);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword("datascript","db","datascript/db",-1190971692),datascript_db,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("main-project","id","main-project/id",-197124273),main_project_id,new cljs.core.Keyword(null,"loading?","loading?",1905707049),false], 0));
});
clograms.external.config_loaded = (function clograms$external$config_loaded(p__77552,config_str){
var map__77553 = p__77552;
var map__77553__$1 = (((((!((map__77553 == null))))?(((((map__77553.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__77553.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__77553):map__77553);
var cofxs = map__77553__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77553__$1,new cljs.core.Keyword(null,"db","db",993250759));
var config = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(config_str);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"config","config",994861415),config),new cljs.core.Keyword(null,"start-websocket","start-websocket",599448134),config], null);
});
clograms.external.diagram_loaded = (function clograms$external$diagram_loaded(db,diagram_str){
var diagram = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(diagram_str),new cljs.core.Keyword("clograms.re-grams.re-grams","diagram","clograms.re-grams.re-grams/diagram",-337817884),(function (d){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("clograms.re-grams.re-grams","diagram","clograms.re-grams.re-grams/diagram",-337817884).cljs$core$IFn$_invoke$arity$1(clograms.re_grams.re_grams.initial_db()),d], 0));
}));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([db,diagram], 0));
});
clograms.external.new_datascript_db_datoms = (function clograms$external$new_datascript_db_datoms(db,datoms){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword("datascript","db","datascript/db",-1190971692),clograms.db.add_datoms,datoms);
});

//# sourceMappingURL=clograms.external.js.map
