goog.provide('clograms.diagram.tools');
goog.require('cljs.core');
goog.require('clograms.db');
goog.require('goog.string');
clograms.diagram.tools.select_color = (function clograms$diagram$tools$select_color(db,color){
return clograms.db.select_color(db,color);
});
clograms.diagram.tools.set_namespace_color = (function clograms$diagram$tools$set_namespace_color(db,ns_name){
return clograms.db.set_namespace_color(db,ns_name,clograms.db.selected_color(db));
});
clograms.diagram.tools.set_project_color = (function clograms$diagram$tools$set_project_color(db,project_name){
return clograms.db.set_project_color(db,project_name,clograms.db.selected_color(db));
});
clograms.diagram.tools.find_var_references = (function clograms$diagram$tools$find_var_references(db,var_id,node_id){
var references = clograms.db.var_x_refs(new cljs.core.Keyword("datascript","db","datascript/db",-1190971692).cljs$core$IFn$_invoke$arity$1(db),var_id);
var var_entity = clograms.db.var_entity(new cljs.core.Keyword("datascript","db","datascript/db",-1190971692).cljs$core$IFn$_invoke$arity$1(db),var_id);
return clograms.db.uncollapse_bottom_bar(clograms.db.set_var_references(clograms.db.set_bottom_bar_title(db,(function (){var G__77634 = "References: %s/%s (%s)";
var G__77635 = new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(var_entity);
var G__77636 = new cljs.core.Keyword("var","name","var/name",1843763042).cljs$core$IFn$_invoke$arity$1(var_entity);
var G__77637 = new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(var_entity);
return goog.string.format(G__77634,G__77635,G__77636,G__77637);
})()),node_id,references));
});
clograms.diagram.tools.find_project_protocols = (function clograms$diagram$tools$find_project_protocols(db,project_id){
var references = clograms.db.find_project_protocols(new cljs.core.Keyword("datascript","db","datascript/db",-1190971692).cljs$core$IFn$_invoke$arity$1(db),project_id);
var project_entity = clograms.db.project_entity(new cljs.core.Keyword("datascript","db","datascript/db",-1190971692).cljs$core$IFn$_invoke$arity$1(db),project_id);
return clograms.db.uncollapse_bottom_bar(clograms.db.set_var_references(clograms.db.set_bottom_bar_title(db,(function (){var G__77640 = "Protocols: %s (%s)";
var G__77641 = new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(project_entity);
var G__77642 = new cljs.core.Keyword("project","version","project/version",132630599).cljs$core$IFn$_invoke$arity$1(project_entity);
return goog.string.format(G__77640,G__77641,G__77642);
})()),null,references));
});
clograms.diagram.tools.find_project_multimethods = (function clograms$diagram$tools$find_project_multimethods(db,project_id){
var references = clograms.db.find_project_multimethods(new cljs.core.Keyword("datascript","db","datascript/db",-1190971692).cljs$core$IFn$_invoke$arity$1(db),project_id);
var project_entity = clograms.db.project_entity(new cljs.core.Keyword("datascript","db","datascript/db",-1190971692).cljs$core$IFn$_invoke$arity$1(db),project_id);
return clograms.db.uncollapse_bottom_bar(clograms.db.set_var_references(clograms.db.set_bottom_bar_title(db,(function (){var G__77649 = "Multimethods: %s (%s)";
var G__77650 = new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(project_entity);
var G__77651 = new cljs.core.Keyword("project","version","project/version",132630599).cljs$core$IFn$_invoke$arity$1(project_entity);
return goog.string.format(G__77649,G__77650,G__77651);
})()),null,references));
});
clograms.diagram.tools.find_unreferenced_functions = (function clograms$diagram$tools$find_unreferenced_functions(db,project_id){
var references = clograms.db.non_test_fns_ref_counts_in_project(new cljs.core.Keyword("datascript","db","datascript/db",-1190971692).cljs$core$IFn$_invoke$arity$1(db),project_id);
var project_entity = clograms.db.project_entity(new cljs.core.Keyword("datascript","db","datascript/db",-1190971692).cljs$core$IFn$_invoke$arity$1(db),project_id);
var possible_api = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (references,project_entity){
return (function (vr){
var allowed_refs = (function (){var G__77652 = (1);
var G__77652__$1 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(vr),"N/A"))?(G__77652 + (1)):G__77652);
return (G__77652__$1 + (new cljs.core.Keyword(null,"variadic-count","variadic-count",1374082953).cljs$core$IFn$_invoke$arity$1(vr) - (1)));

})();
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(vr),allowed_refs);
});})(references,project_entity))
,references);
return clograms.db.uncollapse_bottom_bar(clograms.db.set_var_references(clograms.db.set_bottom_bar_title(db,(function (){var G__77654 = "Unreferenced functions: %s (%s)";
var G__77655 = new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(project_entity);
var G__77656 = new cljs.core.Keyword("project","version","project/version",132630599).cljs$core$IFn$_invoke$arity$1(project_entity);
return goog.string.format(G__77654,G__77655,G__77656);
})()),null,possible_api));
});

//# sourceMappingURL=clograms.diagram.tools.js.map
