goog.provide('clograms.db');
goog.require('cljs.core');
goog.require('clograms.re_grams.re_grams');
goog.require('datascript.core');
goog.require('cljs.tools.reader');
goog.require('clojure.string');
goog.require('cognitect.transit');
goog.require('goog.string');
clograms.db.project_browser_transitions = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"projects","projects",-364845983),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),new cljs.core.Keyword(null,"vars","vars",-2046957217)], null);
clograms.db.project_browser_level_idx__GT_key = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (p1__75512_SHARP_,p2__75513_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__75512_SHARP_,p2__75513_SHARP_],null));
}),clograms.db.project_browser_transitions));
clograms.db.project_browser_level_key__GT_idx = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (p1__75517_SHARP_,p2__75516_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p2__75516_SHARP_,p1__75517_SHARP_],null));
}),clograms.db.project_browser_transitions));
clograms.db.diagram = (function clograms$db$diagram(db){
return new cljs.core.Keyword("clograms.re-grams.re-grams","diagram","clograms.re-grams.re-grams/diagram",-337817884).cljs$core$IFn$_invoke$arity$1(db);
});
clograms.db.select_project = (function clograms$db$select_project(db,p_id){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"projects-browser","projects-browser",-313228814),new cljs.core.Keyword(null,"selected-project","selected-project",993223033)], null),p_id);
});
clograms.db.selected_project = (function clograms$db$selected_project(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"projects-browser","projects-browser",-313228814),new cljs.core.Keyword(null,"selected-project","selected-project",993223033)], null));
});
clograms.db.select_namespace = (function clograms$db$select_namespace(db,ns_id){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"projects-browser","projects-browser",-313228814),new cljs.core.Keyword(null,"selected-namespace","selected-namespace",1751920)], null),ns_id);
});
clograms.db.selected_namespace = (function clograms$db$selected_namespace(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"projects-browser","projects-browser",-313228814),new cljs.core.Keyword(null,"selected-namespace","selected-namespace",1751920)], null));
});
clograms.db.set_ctx_menu = (function clograms$db$set_ctx_menu(db,ctx_menu){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"ctx-menu","ctx-menu",780654755),ctx_menu);
});
clograms.db.select_color = (function clograms$db$select_color(db,color){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"selected-color","selected-color",1741579979),color);
});
clograms.db.selected_color = (function clograms$db$selected_color(db){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.Keyword(null,"selected-color","selected-color",1741579979));
});
clograms.db.set_namespace_color = (function clograms$db$set_namespace_color(db,ns,color){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("namespace","colors","namespace/colors",-1722531529),ns], null),color);
});
clograms.db.namespace_colors = (function clograms$db$namespace_colors(db){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.Keyword("namespace","colors","namespace/colors",-1722531529));
});
clograms.db.set_project_color = (function clograms$db$set_project_color(db,project,color){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","colors","project/colors",-160871691),project], null),color);
});
clograms.db.project_colors = (function clograms$db$project_colors(db){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.Keyword("project","colors","project/colors",-160871691));
});
clograms.db.set_var_references = (function clograms$db$set_var_references(db,node_id,references){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bottom-bar","bottom-bar",-1450473630),new cljs.core.Keyword(null,"references","references",882562509)], null),(function (){var G__75580 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"vars","vars",-2046957217),references], null);
if(cljs.core.truth_(node_id)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__75580,new cljs.core.Keyword(null,"node-id","node-id",779482292),node_id);
} else {
return G__75580;
}
})());
});
clograms.db.current_var_references = (function clograms$db$current_var_references(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bottom-bar","bottom-bar",-1450473630),new cljs.core.Keyword(null,"references","references",882562509)], null));
});
clograms.db.set_bottom_bar_title = (function clograms$db$set_bottom_bar_title(db,title){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bottom-bar","bottom-bar",-1450473630),new cljs.core.Keyword(null,"title","title",636505583)], null),title);
});
clograms.db.bottom_bar_title = (function clograms$db$bottom_bar_title(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bottom-bar","bottom-bar",-1450473630),new cljs.core.Keyword(null,"title","title",636505583)], null));
});
clograms.db.bottom_bar = (function clograms$db$bottom_bar(db){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.Keyword(null,"bottom-bar","bottom-bar",-1450473630));
});
clograms.db.toggle_bottom_bar_collapse = (function clograms$db$toggle_bottom_bar_collapse(db){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bottom-bar","bottom-bar",-1450473630),new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674)], null),cljs.core.not);
});
clograms.db.uncollapse_bottom_bar = (function clograms$db$uncollapse_bottom_bar(db){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bottom-bar","bottom-bar",-1450473630),new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674)], null),false);
});
clograms.db.set_side_bar_search = (function clograms$db$set_side_bar_search(db,query){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"side-bar","side-bar",-1291968675),new cljs.core.Keyword(null,"query","query",-1288509510)], null),query);
});
clograms.db.side_bar_search = (function clograms$db$side_bar_search(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"side-bar","side-bar",-1291968675),new cljs.core.Keyword(null,"query","query",-1288509510)], null));
});
clograms.db.update_side_bar_browser_level = (function clograms$db$update_side_bar_browser_level(db,f){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"projects-browser","projects-browser",-313228814),new cljs.core.Keyword(null,"level","level",1290497552)], null),f);
});
clograms.db.loading_QMARK_ = (function clograms$db$loading_QMARK_(db){
return new cljs.core.Keyword(null,"loading?","loading?",1905707049).cljs$core$IFn$_invoke$arity$1(db);
});
clograms.db.selectable_colors = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["#984545",null,"#c5973c",null,"#afbc4f",null,"#68ba41",null], null), null);
clograms.db.default_db = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([clograms.re_grams.re_grams.initial_db(),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"side-bar","side-bar",-1291968675),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),""], null),new cljs.core.Keyword(null,"bottom-bar","bottom-bar",-1450473630),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674),true], null),new cljs.core.Keyword(null,"projects-browser","projects-browser",-313228814),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"level","level",1290497552),(0),new cljs.core.Keyword(null,"selected-project","selected-project",993223033),null,new cljs.core.Keyword(null,"selected-namespace","selected-namespace",1751920),null], null),new cljs.core.Keyword(null,"ctx-menu","ctx-menu",780654755),null,new cljs.core.Keyword(null,"selected-color","selected-color",1741579979),cljs.core.first(clograms.db.selectable_colors),new cljs.core.Keyword(null,"loading?","loading?",1905707049),true], null)], 0));
clograms.db.deserialize_source = (function clograms$db$deserialize_source(src_str){
try{return cljs.tools.reader.read_string.cljs$core$IFn$_invoke$arity$1(src_str);
}catch (e75585){if((e75585 instanceof Error)){
var e = e75585;
console.warn(["[Skipping] Couldn't parse source-form ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(src_str,(0),(30))),"... probably because of reg exp non compatible with JS"].join(''));

return null;
} else {
throw e75585;

}
}});
clograms.db.deserialize_datascript_db = (function clograms$db$deserialize_datascript_db(ds_db_str){
try{var json_reader = cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"json","json",1279968570));
var map__75588 = cognitect.transit.read(json_reader,ds_db_str);
var map__75588__$1 = (((((!((map__75588 == null))))?(((((map__75588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75588.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75588):map__75588);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75588__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var datoms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75588__$1,new cljs.core.Keyword(null,"datoms","datoms",-290874434));
var conn = datascript.core.create_conn.cljs$core$IFn$_invoke$arity$1(schema);
var start__4620__auto___76032 = cljs.core.system_time();
var ret__4621__auto___76033 = datascript.core.transact_BANG_.cljs$core$IFn$_invoke$arity$2(conn,datoms);
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Elapsed time: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.system_time() - start__4620__auto___76032).toFixed((6)))," msecs"].join('')], 0));


return datascript.core.db(conn);
}catch (e75587){if((e75587 instanceof Error)){
var e = e75587;
return console.error("Couldn't read db",cljs.core.ex_data(e),e);
} else {
throw e75587;

}
}});
clograms.db.add_datoms = (function clograms$db$add_datoms(datascript_db,datoms){
return datascript.core.db_with(datascript_db,datoms);
});
clograms.db.main_project_id = (function clograms$db$main_project_id(datascript_db){
var G__75621 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Symbol(null,".",".",1975675962,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?pn","?pn",704318294,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pn","?pn",704318294,null)], null)], null);
var G__75622 = datascript_db;
var G__75623 = new cljs.core.Symbol("clindex","main-project","clindex/main-project",-397257308,null);
return (datascript.core.q.cljs$core$IFn$_invoke$arity$3 ? datascript.core.q.cljs$core$IFn$_invoke$arity$3(G__75621,G__75622,G__75623) : datascript.core.q.call(null,G__75621,G__75622,G__75623));
});
clograms.db.function_entity = (function clograms$db$function_entity(datascript_db,var_id){
var var$ = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,var_id) : datascript.core.entity.call(null,datascript_db,var_id));
var func = new cljs.core.Keyword("var","function","var/function",-2127141960).cljs$core$IFn$_invoke$arity$1(var$);
var ns = new cljs.core.Keyword("namespace","_vars","namespace/_vars",1200630033).cljs$core$IFn$_invoke$arity$1(var$);
var proy = new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns);
return new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Keyword("var","name","var/name",1843763042).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword("var","docstring","var/docstring",879636808),new cljs.core.Keyword("var","docstring","var/docstring",879636808).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword("function","source-form","function/source-form",707695320),clograms.db.deserialize_source(new cljs.core.Keyword("source","form","source/form",-744337882).cljs$core$IFn$_invoke$arity$1(func)),new cljs.core.Keyword("function","source-str","function/source-str",-1969590176),new cljs.core.Keyword("source","str","source/str",1029813306).cljs$core$IFn$_invoke$arity$1(func),new cljs.core.Keyword("fspec.alpha","source-form","fspec.alpha/source-form",-959432353),clograms.db.deserialize_source(new cljs.core.Keyword("source","form","source/form",-744337882).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("function","spec.alpha","function/spec.alpha",-344793670).cljs$core$IFn$_invoke$arity$1(func))),new cljs.core.Keyword("function","args","function/args",1822107848),new cljs.core.Keyword("function","args","function/args",1822107848).cljs$core$IFn$_invoke$arity$1(func),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(proy)], null);
});
clograms.db.multimethod_entity = (function clograms$db$multimethod_entity(datascript_db,var_id){
var var$ = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,var_id) : datascript.core.entity.call(null,datascript_db,var_id));
var multi = new cljs.core.Keyword("var","multi","var/multi",-190176134).cljs$core$IFn$_invoke$arity$1(var$);
var ns = new cljs.core.Keyword("namespace","_vars","namespace/_vars",1200630033).cljs$core$IFn$_invoke$arity$1(var$);
var proy = new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Keyword("var","name","var/name",1843763042).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword("var","docstring","var/docstring",879636808),new cljs.core.Keyword("var","docstring","var/docstring",879636808).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword("multi","dispatch-form","multi/dispatch-form",-1933821625),clograms.db.deserialize_source(new cljs.core.Keyword("multi","dispatch-form","multi/dispatch-form",-1933821625).cljs$core$IFn$_invoke$arity$1(multi)),new cljs.core.Keyword("multi","methods","multi/methods",81209625),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (var$,multi,ns,proy){
return (function (multi_method){
var mm = cljs.core.select_keys(multi_method,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("multimethod","dispatch-val","multimethod/dispatch-val",-968274777),new cljs.core.Keyword("source","form","source/form",-744337882),new cljs.core.Keyword("source","str","source/str",1029813306)], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(mm,new cljs.core.Keyword("multimethod","source-form","multimethod/source-form",1877637206),clograms.db.deserialize_source(new cljs.core.Keyword("source","form","source/form",-744337882).cljs$core$IFn$_invoke$arity$1(mm))),new cljs.core.Keyword("multimethod","source-str","multimethod/source-str",2019463902),new cljs.core.Keyword("source","str","source/str",1029813306).cljs$core$IFn$_invoke$arity$1(mm));
});})(var$,multi,ns,proy))
,new cljs.core.Keyword("multi","methods","multi/methods",81209625).cljs$core$IFn$_invoke$arity$1(multi)),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(proy)], null);
});
clograms.db.var_entity = (function clograms$db$var_entity(datascript_db,var_id){
var var$ = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,var_id) : datascript.core.entity.call(null,datascript_db,var_id));
var ns = new cljs.core.Keyword("namespace","_vars","namespace/_vars",1200630033).cljs$core$IFn$_invoke$arity$1(var$);
var proy = new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Keyword("var","name","var/name",1843763042).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword("var","docstring","var/docstring",879636808),new cljs.core.Keyword("var","docstring","var/docstring",879636808).cljs$core$IFn$_invoke$arity$1(var$),new cljs.core.Keyword("var","type","var/type",1175435203),(cljs.core.truth_(new cljs.core.Keyword("var","function","var/function",-2127141960).cljs$core$IFn$_invoke$arity$1(var$))?new cljs.core.Keyword(null,"function","function",-2127255473):(cljs.core.truth_(new cljs.core.Keyword("var","multi","var/multi",-190176134).cljs$core$IFn$_invoke$arity$1(var$))?new cljs.core.Keyword(null,"multimethod","multimethod",1295398684):new cljs.core.Keyword(null,"var","var",-769682797)
)),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(proy)], null);
});
clograms.db.project_entity = (function clograms$db$project_entity(datascript_db,project_id){
var proj = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,project_id) : datascript.core.entity.call(null,datascript_db,project_id));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("project","id","project/id",-791740645),project_id,new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(proj),new cljs.core.Keyword("project","version","project/version",132630599),(function (){var or__4131__auto__ = new cljs.core.Keyword("project","version","project/version",132630599).cljs$core$IFn$_invoke$arity$1(proj);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "UNKNOWN";
}
})()], null);
});
clograms.db.namespace_entity = (function clograms$db$namespace_entity(datascript_db,namespace_id){
var ns = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,namespace_id) : datascript.core.entity.call(null,datascript_db,namespace_id));
var ns_proj = new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("namespace","id","namespace/id",1876690137),namespace_id,new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(ns_proj),new cljs.core.Keyword("project","id","project/id",-791740645),new cljs.core.Keyword("db","id","db/id",-1388397098).cljs$core$IFn$_invoke$arity$1(ns_proj),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns),new cljs.core.Keyword("namespace","docstring","namespace/docstring",-2121359436),new cljs.core.Keyword("namespace","docstring","namespace/docstring",-2121359436).cljs$core$IFn$_invoke$arity$1(ns)], null);
});
clograms.db.re_frame_subs_entity = (function clograms$db$re_frame_subs_entity(datascript_db,id){
var sub = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,id) : datascript.core.entity.call(null,datascript_db,id));
var ns = new cljs.core.Keyword("namespace","_re-frame-subs","namespace/_re-frame-subs",-210465305).cljs$core$IFn$_invoke$arity$1(sub);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword("re-frame.subs","key","re-frame.subs/key",1251175547),new cljs.core.Keyword("re-frame.subs","key","re-frame.subs/key",1251175547).cljs$core$IFn$_invoke$arity$1(sub),new cljs.core.Keyword("source","form","source/form",-744337882),clograms.db.deserialize_source(new cljs.core.Keyword("source","form","source/form",-744337882).cljs$core$IFn$_invoke$arity$1(sub)),new cljs.core.Keyword("source","str","source/str",1029813306),new cljs.core.Keyword("source","str","source/str",1029813306).cljs$core$IFn$_invoke$arity$1(sub),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns)),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns)], null);
});
clograms.db.re_frame_event_entity = (function clograms$db$re_frame_event_entity(datascript_db,id){
var e = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,id) : datascript.core.entity.call(null,datascript_db,id));
var ns = new cljs.core.Keyword("namespace","_re-frame-events","namespace/_re-frame-events",-1596028624).cljs$core$IFn$_invoke$arity$1(e);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword("re-frame.event","key","re-frame.event/key",-483453844),new cljs.core.Keyword("re-frame.event","key","re-frame.event/key",-483453844).cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword("source","form","source/form",-744337882),clograms.db.deserialize_source(new cljs.core.Keyword("source","form","source/form",-744337882).cljs$core$IFn$_invoke$arity$1(e)),new cljs.core.Keyword("source","str","source/str",1029813306),new cljs.core.Keyword("source","str","source/str",1029813306).cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns)),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns)], null);
});
clograms.db.re_frame_fx_entity = (function clograms$db$re_frame_fx_entity(datascript_db,id){
var e = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,id) : datascript.core.entity.call(null,datascript_db,id));
var ns = new cljs.core.Keyword("namespace","_re-frame-fxs","namespace/_re-frame-fxs",942507324).cljs$core$IFn$_invoke$arity$1(e);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword("re-frame.fx","key","re-frame.fx/key",1049543514),new cljs.core.Keyword("re-frame.fx","key","re-frame.fx/key",1049543514).cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword("source","form","source/form",-744337882),clograms.db.deserialize_source(new cljs.core.Keyword("source","form","source/form",-744337882).cljs$core$IFn$_invoke$arity$1(e)),new cljs.core.Keyword("source","str","source/str",1029813306),new cljs.core.Keyword("source","str","source/str",1029813306).cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns)),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns)], null);
});
clograms.db.re_frame_cofx_entity = (function clograms$db$re_frame_cofx_entity(datascript_db,id){
var e = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,id) : datascript.core.entity.call(null,datascript_db,id));
var ns = new cljs.core.Keyword("namespace","_re-frame-cofxs","namespace/_re-frame-cofxs",-867499705).cljs$core$IFn$_invoke$arity$1(e);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword("re-frame.cofx","key","re-frame.cofx/key",1250545838),new cljs.core.Keyword("re-frame.cofx","key","re-frame.cofx/key",1250545838).cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns)),new cljs.core.Keyword("source","form","source/form",-744337882),clograms.db.deserialize_source(new cljs.core.Keyword("source","form","source/form",-744337882).cljs$core$IFn$_invoke$arity$1(e)),new cljs.core.Keyword("source","str","source/str",1029813306),new cljs.core.Keyword("source","str","source/str",1029813306).cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns)], null);
});
clograms.db.spec_entity = (function clograms$db$spec_entity(datascript_db,spec_id){
var e = (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(datascript_db,spec_id) : datascript.core.entity.call(null,datascript_db,spec_id));
var ns = new cljs.core.Keyword("namespace","_specs-alpha","namespace/_specs-alpha",1921257114).cljs$core$IFn$_invoke$arity$1(e);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword("spec","id","spec/id",-1375690119),spec_id,new cljs.core.Keyword("spec.alpha","key","spec.alpha/key",1167320320),new cljs.core.Keyword("spec.alpha","key","spec.alpha/key",1167320320).cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword("spec.alpha","source-form","spec.alpha/source-form",867162693),clograms.db.deserialize_source(new cljs.core.Keyword("source","form","source/form",-744337882).cljs$core$IFn$_invoke$arity$1(e)),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","name","project/name",2022968152).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("project","_namespaces","project/_namespaces",-1358341483).cljs$core$IFn$_invoke$arity$1(ns)),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106).cljs$core$IFn$_invoke$arity$1(ns)], null);
});
clograms.db.all_projects = (function clograms$db$all_projects(datascript_db){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75840_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__75840_SHARP_,new cljs.core.Keyword("entity","type","entity/type",-1331966609),new cljs.core.Keyword(null,"project","project",1124394579));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75839_SHARP_){
return cljs.core.zipmap(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","id","project/id",-791740645),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("project","version","project/version",132630599)], null),p1__75839_SHARP_);
}),(function (){var G__75841 = new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null),new cljs.core.Symbol(null,"?pver","?pver",1265173010,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"get-else","get-else",1312024065,null),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","version","project/version",132630599),"UNKNOWN"),new cljs.core.Symbol(null,"?pver","?pver",1265173010,null)], null)], null);
var G__75842 = datascript_db;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$2 ? datascript.core.q.cljs$core$IFn$_invoke$arity$2(G__75841,G__75842) : datascript.core.q.call(null,G__75841,G__75842));
})()));
});
clograms.db.all_namespaces = (function clograms$db$all_namespaces(datascript_db){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75844_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__75844_SHARP_,new cljs.core.Keyword("entity","type","entity/type",-1331966609),new cljs.core.Keyword(null,"namespace","namespace",-377510372));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75843_SHARP_){
return cljs.core.zipmap(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("namespace","id","namespace/id",1876690137),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106)], null),p1__75843_SHARP_);
}),(function (){var G__75845 = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null)], null)], null);
var G__75846 = datascript_db;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$2 ? datascript.core.q.cljs$core$IFn$_invoke$arity$2(G__75845,G__75846) : datascript.core.q.call(null,G__75845,G__75846));
})()));
});
clograms.db.all_namespaces_for_project = (function clograms$db$all_namespaces_for_project(datascript_db,project_id){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75848_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__75848_SHARP_,new cljs.core.Keyword("entity","type","entity/type",-1331966609),new cljs.core.Keyword(null,"namespace","namespace",-377510372));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75847_SHARP_){
return cljs.core.zipmap(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","id","project/id",-791740645),new cljs.core.Keyword("namespace","id","namespace/id",1876690137),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106)], null),p1__75847_SHARP_);
}),(function (){var G__75850 = new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null)], null)], null);
var G__75851 = datascript_db;
var G__75852 = project_id;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$3 ? datascript.core.q.cljs$core$IFn$_invoke$arity$3(G__75850,G__75851,G__75852) : datascript.core.q.call(null,G__75850,G__75851,G__75852));
})()));
});
clograms.db.all_vars = (function clograms$db$all_vars(datascript_db){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (data){
var var$ = cljs.core.zipmap(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("var","id","var/id",-1388416211),new cljs.core.Keyword("var","name","var/name",1843763042)], null),data);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(var$,new cljs.core.Keyword("entity","type","entity/type",-1331966609),new cljs.core.Keyword(null,"var","var",-769682797));
}),(function (){var G__75853 = new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null),new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","vars","namespace/vars",1269978290),new cljs.core.Symbol(null,"?vid","?vid",806066053,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null)], null)], null);
var G__75854 = datascript_db;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$2 ? datascript.core.q.cljs$core$IFn$_invoke$arity$2(G__75853,G__75854) : datascript.core.q.call(null,G__75853,G__75854));
})());
});
clograms.db.all_vars_for_ns = (function clograms$db$all_vars_for_ns(datascript_db,ns_id){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (data){
var var$ = cljs.core.zipmap(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","id","project/id",-791740645),new cljs.core.Keyword("namespace","id","namespace/id",1876690137),new cljs.core.Keyword("var","id","var/id",-1388416211),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Keyword("var","public?","var/public?",786141630),new cljs.core.Keyword("var","line","var/line",212473964),new cljs.core.Keyword(null,"fn","fn",-1175266204),new cljs.core.Keyword(null,"multi","multi",-190293005)], null),data);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(var$,new cljs.core.Keyword("var","type","var/type",1175435203),((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("N/A",new cljs.core.Keyword(null,"fn","fn",-1175266204).cljs$core$IFn$_invoke$arity$1(var$)))?new cljs.core.Keyword(null,"function","function",-2127255473):((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("N/A",new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(var$)))?new cljs.core.Keyword(null,"multimethod","multimethod",1295398684):new cljs.core.Keyword(null,"var","var",-769682797)
)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("entity","type","entity/type",-1331966609),new cljs.core.Keyword(null,"var","var",-769682797)], 0)),new cljs.core.Keyword(null,"fn","fn",-1175266204),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"multi","multi",-190293005)], 0));
}),(function (){var G__75872 = new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null),new cljs.core.Symbol(null,"?vpub","?vpub",-2136864334,null),new cljs.core.Symbol(null,"?vline","?vline",-491271346,null),new cljs.core.Symbol(null,"?fid","?fid",1607941684,null),new cljs.core.Symbol(null,"?mid","?mid",-615418358,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","vars","namespace/vars",1269978290),new cljs.core.Symbol(null,"?vid","?vid",806066053,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","public?","var/public?",786141630),new cljs.core.Symbol(null,"?vpub","?vpub",-2136864334,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","line","var/line",212473964),new cljs.core.Symbol(null,"?vline","?vline",-491271346,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"get-else","get-else",1312024065,null),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","function","var/function",-2127141960),"N/A"),new cljs.core.Symbol(null,"?fid","?fid",1607941684,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"get-else","get-else",1312024065,null),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","multi","var/multi",-190176134),"N/A"),new cljs.core.Symbol(null,"?mid","?mid",-615418358,null)], null)], null);
var G__75873 = datascript_db;
var G__75874 = ns_id;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$3 ? datascript.core.q.cljs$core$IFn$_invoke$arity$3(G__75872,G__75873,G__75874) : datascript.core.q.call(null,G__75872,G__75873,G__75874));
})());
});
clograms.db.var_x_refs = (function clograms$db$var_x_refs(datascript_db,var_id){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__75881_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("var","id","var/id",-1388416211).cljs$core$IFn$_invoke$arity$1(p1__75881_SHARP_),var_id);
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75880_SHARP_){
return cljs.core.zipmap(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Keyword("function","source-str","function/source-str",-1969590176),new cljs.core.Keyword("var","id","var/id",-1388416211)], null),p1__75880_SHARP_);
}),(function (){var G__75885 = new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null),new cljs.core.Symbol(null,"?vrnsn","?vrnsn",-1127327570,null),new cljs.core.Symbol(null,"?in-fn","?in-fn",470918621,null),new cljs.core.Symbol(null,"?fsrcs","?fsrcs",509213998,null),new cljs.core.Symbol(null,"?fnvid","?fnvid",-2054574988,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nid","?nid",-558438146,null),new cljs.core.Keyword("namespace","vars","namespace/vars",1269978290),new cljs.core.Symbol(null,"?vid","?vid",806066053,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Symbol(null,"?vn","?vn",-2123879622,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","refs","var/refs",-1559869395),new cljs.core.Symbol(null,"?vrid","?vrid",-1809062908,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vrid","?vrid",-1809062908,null),new cljs.core.Keyword("var-ref","namespace","var-ref/namespace",-142762743),new cljs.core.Symbol(null,"?vrnid","?vrnid",-744773417,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vrid","?vrid",-1809062908,null),new cljs.core.Keyword("var-ref","in-function","var-ref/in-function",708624797),new cljs.core.Symbol(null,"?fnid","?fnid",-1218411618,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?fnvid","?fnvid",-2054574988,null),new cljs.core.Keyword("var","function","var/function",-2127141960),new cljs.core.Symbol(null,"?fnid","?fnid",-1218411618,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?fnid","?fnid",-1218411618,null),new cljs.core.Keyword("source","str","source/str",1029813306),new cljs.core.Symbol(null,"?fsrcs","?fsrcs",509213998,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?fnvid","?fnvid",-2054574988,null),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Symbol(null,"?in-fn","?in-fn",470918621,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vrnid","?vrnid",-744773417,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?vrnsn","?vrnsn",-1127327570,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?vrnid","?vrnid",-744773417,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"get-else","get-else",1312024065,null),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?fid","?fid",1607941684,null),new cljs.core.Keyword("file","name","file/name",1848919477),"N/A"),new cljs.core.Symbol(null,"?fname","?fname",-845790002,null)], null)], null);
var G__75886 = datascript_db;
var G__75887 = var_id;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$3 ? datascript.core.q.cljs$core$IFn$_invoke$arity$3(G__75885,G__75886,G__75887) : datascript.core.q.call(null,G__75885,G__75886,G__75887));
})()));
});
clograms.db.non_test_fns_ref_counts_in_project = (function clograms$db$non_test_fns_ref_counts_in_project(datascript_db,project_id){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (row){
var vr = cljs.core.zipmap(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Keyword("var","id","var/id",-1388416211),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"count","count",2139924085)], null),row);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(vr,new cljs.core.Keyword(null,"variadic-count","variadic-count",1374082953),cljs.core.count(new cljs.core.Keyword("function","args","function/args",1822107848).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("var","function","var/function",-2127141960).cljs$core$IFn$_invoke$arity$1((function (){var G__75955 = datascript_db;
var G__75956 = new cljs.core.Keyword("var","id","var/id",-1388416211).cljs$core$IFn$_invoke$arity$1(vr);
return (datascript.core.entity.cljs$core$IFn$_invoke$arity$2 ? datascript.core.entity.cljs$core$IFn$_invoke$arity$2(G__75955,G__75956) : datascript.core.entity.call(null,G__75955,G__75956));
})()))));
}),(function (){var G__75957 = new cljs.core.PersistentVector(null, 24, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null),new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Symbol(null,"?fspec","?fspec",1211186817,null),cljs.core.list(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"?vref","?vref",1957585889,null)),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","vars","namespace/vars",1269978290),new cljs.core.Symbol(null,"?vid","?vid",806066053,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","function","var/function",-2127141960),new cljs.core.Symbol(null,"?fid","?fid",1607941684,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"get-else","get-else",1312024065,null),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?fid","?fid",1607941684,null),new cljs.core.Keyword("function","spec.alpha","function/spec.alpha",-344793670),"N/A"),new cljs.core.Symbol(null,"?fspec","?fspec",1211186817,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","refs","var/refs",-1559869395),new cljs.core.Symbol(null,"?vref","?vref",1957585889,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vref","?vref",1957585889,null),new cljs.core.Keyword("var-ref","namespace","var-ref/namespace",-142762743),new cljs.core.Symbol(null,"?vrefns","?vrefns",1859885562,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?vrefns","?vrefns",1859885562,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vrefns","?vrefns",1859885562,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?vrefnsname","?vrefnsname",1972715594,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"?vrefnsname","?vrefnsname",1972715594,null)),new cljs.core.Symbol(null,"?vrefnsnamestr","?vrefnsnamestr",345512107,null)], null),cljs.core.list(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol("clojure.string","includes?","clojure.string/includes?",-1842146260,null),new cljs.core.Symbol(null,"?vrefnsnamestr","?vrefnsnamestr",345512107,null),"test")], null))], null);
var G__75958 = datascript_db;
var G__75959 = project_id;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$3 ? datascript.core.q.cljs$core$IFn$_invoke$arity$3(G__75957,G__75958,G__75959) : datascript.core.q.call(null,G__75957,G__75958,G__75959));
})());
});
clograms.db.all_re_frame_feature = (function clograms$db$all_re_frame_feature(datascript_db,feature_key){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75962_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__75962_SHARP_,new cljs.core.Keyword("entity","type","entity/type",-1331966609),feature_key);
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75961_SHARP_){
return cljs.core.zipmap(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword("re-frame","key","re-frame/key",702243096),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("project","name","project/name",2022968152)], null),p1__75961_SHARP_);
}),(function (){var G__75965 = new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?subid","?subid",-1949295096,null),new cljs.core.Symbol(null,"?subk","?subk",1295552310,null),new cljs.core.Symbol(null,"?nsn","?nsn",-1151721673,null),new cljs.core.Symbol(null,"?pn","?pn",704318294,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?key","?key",1400522271,null),new cljs.core.Symbol(null,"?nskey","?nskey",60446705,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?subid","?subid",-1949295096,null),new cljs.core.Symbol(null,"?key","?key",1400522271,null),new cljs.core.Symbol(null,"?subk","?subk",1295552310,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Symbol(null,"?nskey","?nskey",60446705,null),new cljs.core.Symbol(null,"?subid","?subid",-1949295096,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?nsn","?nsn",-1151721673,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pn","?pn",704318294,null)], null)], null);
var G__75966 = datascript_db;
var G__75967 = (function (){var G__75983 = feature_key;
var G__75983__$1 = (((G__75983 instanceof cljs.core.Keyword))?G__75983.fqn:null);
switch (G__75983__$1) {
case "re-frame-subs":
return new cljs.core.Keyword("re-frame.subs","key","re-frame.subs/key",1251175547);

break;
case "re-frame-event":
return new cljs.core.Keyword("re-frame.event","key","re-frame.event/key",-483453844);

break;
case "re-frame-fx":
return new cljs.core.Keyword("re-frame.fx","key","re-frame.fx/key",1049543514);

break;
case "re-frame-cofx":
return new cljs.core.Keyword("re-frame.cofx","key","re-frame.cofx/key",1250545838);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__75983__$1)].join('')));

}
})();
var G__75968 = (function (){var G__75984 = feature_key;
var G__75984__$1 = (((G__75984 instanceof cljs.core.Keyword))?G__75984.fqn:null);
switch (G__75984__$1) {
case "re-frame-subs":
return new cljs.core.Keyword("namespace","re-frame-subs","namespace/re-frame-subs",-1016012492);

break;
case "re-frame-event":
return new cljs.core.Keyword("namespace","re-frame-events","namespace/re-frame-events",-446267750);

break;
case "re-frame-fx":
return new cljs.core.Keyword("namespace","re-frame-fxs","namespace/re-frame-fxs",-2073781794);

break;
case "re-frame-cofx":
return new cljs.core.Keyword("namespace","re-frame-cofxs","namespace/re-frame-cofxs",1283971688);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__75984__$1)].join('')));

}
})();
return (datascript.core.q.cljs$core$IFn$_invoke$arity$4 ? datascript.core.q.cljs$core$IFn$_invoke$arity$4(G__75965,G__75966,G__75967,G__75968) : datascript.core.q.call(null,G__75965,G__75966,G__75967,G__75968));
})()));
});
clograms.db.all_specs = (function clograms$db$all_specs(datascript_db){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75987_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__75987_SHARP_,new cljs.core.Keyword("entity","type","entity/type",-1331966609),new cljs.core.Keyword(null,"spec","spec",347520401));
}),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75986_SHARP_){
return cljs.core.zipmap(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("spec","id","spec/id",-1375690119),new cljs.core.Keyword("spec.alpha","key","spec.alpha/key",1167320320)], null),p1__75986_SHARP_);
}),(function (){var G__75988 = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.Symbol(null,"?sk","?sk",758645482,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.Keyword("spec.alpha","key","spec.alpha/key",1167320320),new cljs.core.Symbol(null,"?sk","?sk",758645482,null)], null)], null);
var G__75989 = datascript_db;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$2 ? datascript.core.q.cljs$core$IFn$_invoke$arity$2(G__75988,G__75989) : datascript.core.q.call(null,G__75988,G__75989));
})()));
});
clograms.db.find_project_protocols = (function clograms$db$find_project_protocols(datascript_db,project_id){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75990_SHARP_){
return cljs.core.zipmap(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("var","id","var/id",-1388416211),new cljs.core.Keyword("var","name","var/name",1843763042)], null),p1__75990_SHARP_);
}),(function (){var G__75996 = new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null),new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","vars","namespace/vars",1269978290),new cljs.core.Symbol(null,"?vid","?vid",806066053,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","protocol?","var/protocol?",-541186306),true], null)], null);
var G__75997 = datascript_db;
var G__75998 = project_id;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$3 ? datascript.core.q.cljs$core$IFn$_invoke$arity$3(G__75996,G__75997,G__75998) : datascript.core.q.call(null,G__75996,G__75997,G__75998));
})());
});
clograms.db.find_project_multimethods = (function clograms$db$find_project_multimethods(datascript_db,project_id){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__75999_SHARP_){
return cljs.core.zipmap(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Keyword("var","id","var/id",-1388416211),new cljs.core.Keyword("var","name","var/name",1843763042)], null),p1__75999_SHARP_);
}),(function (){var G__76000 = new cljs.core.PersistentVector(null, 15, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"find","find",496279456),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null),new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null),new cljs.core.Keyword(null,"in","in",-1531184865),new cljs.core.Symbol(null,"$","$",-1580747756,null),new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","namespaces","project/namespaces",-1755603732),new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.Keyword("project","name","project/name",2022968152),new cljs.core.Symbol(null,"?pname","?pname",-1731541178,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","vars","namespace/vars",1269978290),new cljs.core.Symbol(null,"?vid","?vid",806066053,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?nsid","?nsid",-1012174648,null),new cljs.core.Keyword("namespace","name","namespace/name",-1551424106),new cljs.core.Symbol(null,"?nsname","?nsname",-1957842068,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","name","var/name",1843763042),new cljs.core.Symbol(null,"?vname","?vname",1697731498,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?vid","?vid",806066053,null),new cljs.core.Keyword("var","multi","var/multi",-190176134)], null)], null);
var G__76001 = datascript_db;
var G__76002 = project_id;
return (datascript.core.q.cljs$core$IFn$_invoke$arity$3 ? datascript.core.q.cljs$core$IFn$_invoke$arity$3(G__76000,G__76001,G__76002) : datascript.core.q.call(null,G__76000,G__76001,G__76002));
})());
});

//# sourceMappingURL=clograms.db.js.map
