goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__44091){
var map__44092 = p__44091;
var map__44092__$1 = (((((!((map__44092 == null))))?(((((map__44092.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44092.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44092):map__44092);
var m = map__44092__$1;
var n = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44092__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44092__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-------------------------"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return [(function (){var temp__5818__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5818__auto__)){
var ns = temp__5818__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})()], 0));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Protocol"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__44101_44486 = cljs.core.seq(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__44102_44487 = null;
var count__44103_44488 = (0);
var i__44104_44489 = (0);
while(true){
if((i__44104_44489 < count__44103_44488)){
var f_44495 = chunk__44102_44487.cljs$core$IIndexed$_nth$arity$2(null,i__44104_44489);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ",f_44495], 0));


var G__44498 = seq__44101_44486;
var G__44499 = chunk__44102_44487;
var G__44500 = count__44103_44488;
var G__44501 = (i__44104_44489 + (1));
seq__44101_44486 = G__44498;
chunk__44102_44487 = G__44499;
count__44103_44488 = G__44500;
i__44104_44489 = G__44501;
continue;
} else {
var temp__5818__auto___44502 = cljs.core.seq(seq__44101_44486);
if(temp__5818__auto___44502){
var seq__44101_44503__$1 = temp__5818__auto___44502;
if(cljs.core.chunked_seq_QMARK_(seq__44101_44503__$1)){
var c__4550__auto___44504 = cljs.core.chunk_first(seq__44101_44503__$1);
var G__44509 = cljs.core.chunk_rest(seq__44101_44503__$1);
var G__44510 = c__4550__auto___44504;
var G__44511 = cljs.core.count(c__4550__auto___44504);
var G__44512 = (0);
seq__44101_44486 = G__44509;
chunk__44102_44487 = G__44510;
count__44103_44488 = G__44511;
i__44104_44489 = G__44512;
continue;
} else {
var f_44516 = cljs.core.first(seq__44101_44503__$1);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ",f_44516], 0));


var G__44520 = cljs.core.next(seq__44101_44503__$1);
var G__44521 = null;
var G__44522 = (0);
var G__44523 = (0);
seq__44101_44486 = G__44520;
chunk__44102_44487 = G__44521;
count__44103_44488 = G__44522;
i__44104_44489 = G__44523;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_44524 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arglists_44524], 0));
} else {
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first(arglists_44524)))?cljs.core.second(arglists_44524):arglists_44524)], 0));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Special Form"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m)], 0));

if(cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
} else {
return null;
}
} else {
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Macro"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Spec"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["REPL Special Function"], 0));
} else {
}

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m)], 0));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__44112_44545 = cljs.core.seq(new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__44113_44546 = null;
var count__44114_44547 = (0);
var i__44115_44548 = (0);
while(true){
if((i__44115_44548 < count__44114_44547)){
var vec__44136_44551 = chunk__44113_44546.cljs$core$IIndexed$_nth$arity$2(null,i__44115_44548);
var name_44553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44136_44551,(0),null);
var map__44139_44554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44136_44551,(1),null);
var map__44139_44555__$1 = (((((!((map__44139_44554 == null))))?(((((map__44139_44554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44139_44554.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44139_44554):map__44139_44554);
var doc_44556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44139_44555__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_44557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44139_44555__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",name_44553], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",arglists_44557], 0));

if(cljs.core.truth_(doc_44556)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",doc_44556], 0));
} else {
}


var G__44566 = seq__44112_44545;
var G__44567 = chunk__44113_44546;
var G__44568 = count__44114_44547;
var G__44569 = (i__44115_44548 + (1));
seq__44112_44545 = G__44566;
chunk__44113_44546 = G__44567;
count__44114_44547 = G__44568;
i__44115_44548 = G__44569;
continue;
} else {
var temp__5818__auto___44570 = cljs.core.seq(seq__44112_44545);
if(temp__5818__auto___44570){
var seq__44112_44571__$1 = temp__5818__auto___44570;
if(cljs.core.chunked_seq_QMARK_(seq__44112_44571__$1)){
var c__4550__auto___44572 = cljs.core.chunk_first(seq__44112_44571__$1);
var G__44573 = cljs.core.chunk_rest(seq__44112_44571__$1);
var G__44574 = c__4550__auto___44572;
var G__44575 = cljs.core.count(c__4550__auto___44572);
var G__44576 = (0);
seq__44112_44545 = G__44573;
chunk__44113_44546 = G__44574;
count__44114_44547 = G__44575;
i__44115_44548 = G__44576;
continue;
} else {
var vec__44143_44578 = cljs.core.first(seq__44112_44571__$1);
var name_44579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44143_44578,(0),null);
var map__44146_44580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44143_44578,(1),null);
var map__44146_44581__$1 = (((((!((map__44146_44580 == null))))?(((((map__44146_44580.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44146_44580.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44146_44580):map__44146_44580);
var doc_44582 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44146_44581__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_44583 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44146_44581__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",name_44579], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",arglists_44583], 0));

if(cljs.core.truth_(doc_44582)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",doc_44582], 0));
} else {
}


var G__44591 = cljs.core.next(seq__44112_44571__$1);
var G__44592 = null;
var G__44593 = (0);
var G__44594 = (0);
seq__44112_44545 = G__44591;
chunk__44113_44546 = G__44592;
count__44114_44547 = G__44593;
i__44115_44548 = G__44594;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5818__auto__ = cljs.spec.alpha.get_spec(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name(n)),cljs.core.name(nm)));
if(cljs.core.truth_(temp__5818__auto__)){
var fnspec = temp__5818__auto__;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Spec"], 0));

var seq__44173 = cljs.core.seq(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__44174 = null;
var count__44175 = (0);
var i__44176 = (0);
while(true){
if((i__44176 < count__44175)){
var role = chunk__44174.cljs$core$IIndexed$_nth$arity$2(null,i__44176);
var temp__5818__auto___44598__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fnspec,role);
if(cljs.core.truth_(temp__5818__auto___44598__$1)){
var spec_44600 = temp__5818__auto___44598__$1;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n ",cljs.core.name(role),":"].join(''),cljs.spec.alpha.describe(spec_44600)], 0));
} else {
}


var G__44602 = seq__44173;
var G__44603 = chunk__44174;
var G__44604 = count__44175;
var G__44605 = (i__44176 + (1));
seq__44173 = G__44602;
chunk__44174 = G__44603;
count__44175 = G__44604;
i__44176 = G__44605;
continue;
} else {
var temp__5818__auto____$1 = cljs.core.seq(seq__44173);
if(temp__5818__auto____$1){
var seq__44173__$1 = temp__5818__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__44173__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__44173__$1);
var G__44609 = cljs.core.chunk_rest(seq__44173__$1);
var G__44610 = c__4550__auto__;
var G__44611 = cljs.core.count(c__4550__auto__);
var G__44612 = (0);
seq__44173 = G__44609;
chunk__44174 = G__44610;
count__44175 = G__44611;
i__44176 = G__44612;
continue;
} else {
var role = cljs.core.first(seq__44173__$1);
var temp__5818__auto___44613__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fnspec,role);
if(cljs.core.truth_(temp__5818__auto___44613__$2)){
var spec_44614 = temp__5818__auto___44613__$2;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n ",cljs.core.name(role),":"].join(''),cljs.spec.alpha.describe(spec_44614)], 0));
} else {
}


var G__44615 = cljs.core.next(seq__44173__$1);
var G__44616 = null;
var G__44617 = (0);
var G__44618 = (0);
seq__44173 = G__44615;
chunk__44174 = G__44616;
count__44175 = G__44617;
i__44176 = G__44618;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof EvalError))?new cljs.core.Symbol("js","EvalError","js/EvalError",1793498501,null):(((t instanceof RangeError))?new cljs.core.Symbol("js","RangeError","js/RangeError",1703848089,null):(((t instanceof ReferenceError))?new cljs.core.Symbol("js","ReferenceError","js/ReferenceError",-198403224,null):(((t instanceof SyntaxError))?new cljs.core.Symbol("js","SyntaxError","js/SyntaxError",-1527651665,null):(((t instanceof URIError))?new cljs.core.Symbol("js","URIError","js/URIError",505061350,null):(((t instanceof Error))?new cljs.core.Symbol("js","Error","js/Error",-1692659266,null):null
)))))))], null),(function (){var temp__5818__auto__ = cljs.core.ex_message(t);
if(cljs.core.truth_(temp__5818__auto__)){
var msg = temp__5818__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5818__auto__ = cljs.core.ex_data(t);
if(cljs.core.truth_(temp__5818__auto__)){
var ed = temp__5818__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})()], 0));
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__44641 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(via,t);
var G__44642 = cljs.core.ex_cause(t);
via = G__44641;
t = G__44642;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek(via);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5818__auto__ = cljs.core.ex_message(root);
if(cljs.core.truth_(temp__5818__auto__)){
var root_msg = temp__5818__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5818__auto__ = cljs.core.ex_data(root);
if(cljs.core.truth_(temp__5818__auto__)){
var data = temp__5818__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5818__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data(o));
if(cljs.core.truth_(temp__5818__auto__)){
var phase = temp__5818__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})()], 0));
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__44258 = datafied_throwable;
var map__44258__$1 = (((((!((map__44258 == null))))?(((((map__44258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44258.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44258):map__44258);
var via = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44258__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44258__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44258__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__44259 = cljs.core.last(via);
var map__44259__$1 = (((((!((map__44259 == null))))?(((((map__44259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44259.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44259):map__44259);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44259__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44259__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44259__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__44260 = data;
var map__44260__$1 = (((((!((map__44260 == null))))?(((((map__44260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44260.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44260):map__44260);
var problems = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44260__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44260__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44260__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__44261 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first(via));
var map__44261__$1 = (((((!((map__44261 == null))))?(((((map__44261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44261):map__44261);
var top_data = map__44261__$1;
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44261__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((function (){var G__44291 = phase;
var G__44291__$1 = (((G__44291 instanceof cljs.core.Keyword))?G__44291.fqn:null);
switch (G__44291__$1) {
case "read-source":
var map__44293 = data;
var map__44293__$1 = (((((!((map__44293 == null))))?(((((map__44293.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44293.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44293):map__44293);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44293__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44293__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__44307 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second(via)),top_data], 0));
var G__44307__$1 = (cljs.core.truth_(source)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44307,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__44307);
var G__44307__$2 = (cljs.core.truth_((function (){var fexpr__44309 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__44309.cljs$core$IFn$_invoke$arity$1 ? fexpr__44309.cljs$core$IFn$_invoke$arity$1(source) : fexpr__44309.call(null,source));
})())?cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__44307__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__44307__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44307__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__44307__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__44320 = top_data;
var G__44320__$1 = (cljs.core.truth_(source)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44320,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__44320);
var G__44320__$2 = (cljs.core.truth_((function (){var fexpr__44324 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__44324.cljs$core$IFn$_invoke$arity$1 ? fexpr__44324.cljs$core$IFn$_invoke$arity$1(source) : fexpr__44324.call(null,source));
})())?cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__44320__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__44320__$1);
var G__44320__$3 = (cljs.core.truth_(type)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44320__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__44320__$2);
var G__44320__$4 = (cljs.core.truth_(message)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44320__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__44320__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44320__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__44320__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__44343 = cljs.core.first(trace);
var source__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44343,(0),null);
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44343,(1),null);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44343,(2),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44343,(3),null);
var G__44350 = top_data;
var G__44350__$1 = (cljs.core.truth_(line)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44350,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__44350);
var G__44350__$2 = (cljs.core.truth_(file)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44350__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__44350__$1);
var G__44350__$3 = (cljs.core.truth_((function (){var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44350__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__44350__$2);
var G__44350__$4 = (cljs.core.truth_(type)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44350__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__44350__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44350__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__44350__$4;
}

break;
case "execution":
var vec__44372 = cljs.core.first(trace);
var source__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44372,(0),null);
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44372,(1),null);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44372,(2),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44372,(3),null);
var file__$1 = cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (vec__44372,source__$1,method,file,line,G__44291,G__44291__$1,map__44258,map__44258__$1,via,trace,phase,map__44259,map__44259__$1,type,message,data,map__44260,map__44260__$1,problems,fn,caller,map__44261,map__44261__$1,top_data,source){
return (function (p1__44253_SHARP_){
var or__4131__auto__ = (p1__44253_SHARP_ == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var fexpr__44377 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__44377.cljs$core$IFn$_invoke$arity$1 ? fexpr__44377.cljs$core$IFn$_invoke$arity$1(p1__44253_SHARP_) : fexpr__44377.call(null,p1__44253_SHARP_));
}
});})(vec__44372,source__$1,method,file,line,G__44291,G__44291__$1,map__44258,map__44258__$1,via,trace,phase,map__44259,map__44259__$1,type,message,data,map__44260,map__44260__$1,problems,fn,caller,map__44261,map__44261__$1,top_data,source))
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return line;
}
})();
var G__44380 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__44380__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44380,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__44380);
var G__44380__$2 = (cljs.core.truth_(message)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44380__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__44380__$1);
var G__44380__$3 = (cljs.core.truth_((function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var and__4120__auto__ = source__$1;
if(cljs.core.truth_(and__4120__auto__)){
return method;
} else {
return and__4120__auto__;
}
}
})())?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44380__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4131__auto__ = fn;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__44380__$2);
var G__44380__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44380__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__44380__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44380__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__44380__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44291__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__44399){
var map__44400 = p__44399;
var map__44400__$1 = (((((!((map__44400 == null))))?(((((map__44400.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44400.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44400):map__44400);
var triage_data = map__44400__$1;
var phase = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44400__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44400__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44400__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44400__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44400__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44400__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44400__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44400__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = source;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = line;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name((function (){var or__4131__auto__ = class$;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__44424 = phase;
var G__44424__$1 = (((G__44424 instanceof cljs.core.Keyword))?G__44424.fqn:null);
switch (G__44424__$1) {
case "read-source":
return (format.cljs$core$IFn$_invoke$arity$3 ? format.cljs$core$IFn$_invoke$arity$3("Syntax error reading source at (%s).\n%s\n",loc,cause) : format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause));

break;
case "macro-syntax-check":
var G__44426 = "Syntax error macroexpanding %sat (%s).\n%s";
var G__44427 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__44428 = loc;
var G__44429 = (cljs.core.truth_(spec)?(function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__44430_44849 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__44431_44850 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__44432_44851 = true;
var _STAR_print_fn_STAR__temp_val__44433_44853 = ((function (_STAR_print_newline_STAR__orig_val__44430_44849,_STAR_print_fn_STAR__orig_val__44431_44850,_STAR_print_newline_STAR__temp_val__44432_44851,sb__4661__auto__,G__44426,G__44427,G__44428,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__44430_44849,_STAR_print_fn_STAR__orig_val__44431_44850,_STAR_print_newline_STAR__temp_val__44432_44851,sb__4661__auto__,G__44426,G__44427,G__44428,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__44432_44851;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__44433_44853;

try{cljs.spec.alpha.explain_out(cljs.core.update.cljs$core$IFn$_invoke$arity$3(spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__44430_44849,_STAR_print_fn_STAR__orig_val__44431_44850,_STAR_print_newline_STAR__temp_val__44432_44851,_STAR_print_fn_STAR__temp_val__44433_44853,sb__4661__auto__,G__44426,G__44427,G__44428,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_STAR_print_newline_STAR__orig_val__44430_44849,_STAR_print_fn_STAR__orig_val__44431_44850,_STAR_print_newline_STAR__temp_val__44432_44851,_STAR_print_fn_STAR__temp_val__44433_44853,sb__4661__auto__,G__44426,G__44427,G__44428,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__44390_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__44390_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__44430_44849,_STAR_print_fn_STAR__orig_val__44431_44850,_STAR_print_newline_STAR__temp_val__44432_44851,_STAR_print_fn_STAR__temp_val__44433_44853,sb__4661__auto__,G__44426,G__44427,G__44428,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__44430_44849,_STAR_print_fn_STAR__orig_val__44431_44850,_STAR_print_newline_STAR__temp_val__44432_44851,_STAR_print_fn_STAR__temp_val__44433_44853,sb__4661__auto__,G__44426,G__44427,G__44428,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__44431_44850;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__44430_44849;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})():(format.cljs$core$IFn$_invoke$arity$2 ? format.cljs$core$IFn$_invoke$arity$2("%s\n",cause) : format.call(null,"%s\n",cause)));
return (format.cljs$core$IFn$_invoke$arity$4 ? format.cljs$core$IFn$_invoke$arity$4(G__44426,G__44427,G__44428,G__44429) : format.call(null,G__44426,G__44427,G__44428,G__44429));

break;
case "macroexpansion":
var G__44437 = "Unexpected error%s macroexpanding %sat (%s).\n%s\n";
var G__44438 = cause_type;
var G__44439 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__44440 = loc;
var G__44441 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__44437,G__44438,G__44439,G__44440,G__44441) : format.call(null,G__44437,G__44438,G__44439,G__44440,G__44441));

break;
case "compile-syntax-check":
var G__44443 = "Syntax error%s compiling %sat (%s).\n%s\n";
var G__44444 = cause_type;
var G__44445 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__44446 = loc;
var G__44447 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__44443,G__44444,G__44445,G__44446,G__44447) : format.call(null,G__44443,G__44444,G__44445,G__44446,G__44447));

break;
case "compilation":
var G__44449 = "Unexpected error%s compiling %sat (%s).\n%s\n";
var G__44450 = cause_type;
var G__44451 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__44452 = loc;
var G__44453 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__44449,G__44450,G__44451,G__44452,G__44453) : format.call(null,G__44449,G__44450,G__44451,G__44452,G__44453));

break;
case "read-eval-result":
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5("Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause) : format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause));

break;
case "print-eval-result":
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5("Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause) : format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause));

break;
case "execution":
if(cljs.core.truth_(spec)){
var G__44455 = "Execution error - invalid arguments to %s at (%s).\n%s";
var G__44456 = symbol;
var G__44457 = loc;
var G__44458 = (function (){var sb__4661__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__44459_44874 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__44460_44875 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__44461_44876 = true;
var _STAR_print_fn_STAR__temp_val__44462_44877 = ((function (_STAR_print_newline_STAR__orig_val__44459_44874,_STAR_print_fn_STAR__orig_val__44460_44875,_STAR_print_newline_STAR__temp_val__44461_44876,sb__4661__auto__,G__44455,G__44456,G__44457,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (x__4662__auto__){
return sb__4661__auto__.append(x__4662__auto__);
});})(_STAR_print_newline_STAR__orig_val__44459_44874,_STAR_print_fn_STAR__orig_val__44460_44875,_STAR_print_newline_STAR__temp_val__44461_44876,sb__4661__auto__,G__44455,G__44456,G__44457,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
;
cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__44461_44876;

cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__44462_44877;

try{cljs.spec.alpha.explain_out(cljs.core.update.cljs$core$IFn$_invoke$arity$3(spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),((function (_STAR_print_newline_STAR__orig_val__44459_44874,_STAR_print_fn_STAR__orig_val__44460_44875,_STAR_print_newline_STAR__temp_val__44461_44876,_STAR_print_fn_STAR__temp_val__44462_44877,sb__4661__auto__,G__44455,G__44456,G__44457,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (probs){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_STAR_print_newline_STAR__orig_val__44459_44874,_STAR_print_fn_STAR__orig_val__44460_44875,_STAR_print_newline_STAR__temp_val__44461_44876,_STAR_print_fn_STAR__temp_val__44462_44877,sb__4661__auto__,G__44455,G__44456,G__44457,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec){
return (function (p1__44396_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__44396_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
});})(_STAR_print_newline_STAR__orig_val__44459_44874,_STAR_print_fn_STAR__orig_val__44460_44875,_STAR_print_newline_STAR__temp_val__44461_44876,_STAR_print_fn_STAR__temp_val__44462_44877,sb__4661__auto__,G__44455,G__44456,G__44457,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
,probs);
});})(_STAR_print_newline_STAR__orig_val__44459_44874,_STAR_print_fn_STAR__orig_val__44460_44875,_STAR_print_newline_STAR__temp_val__44461_44876,_STAR_print_fn_STAR__temp_val__44462_44877,sb__4661__auto__,G__44455,G__44456,G__44457,G__44424,G__44424__$1,loc,class_name,simple_class,cause_type,format,map__44400,map__44400__$1,triage_data,phase,source,line,column,symbol,class$,cause,spec))
)
);
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__44460_44875;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__44459_44874;
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4661__auto__);
})();
return (format.cljs$core$IFn$_invoke$arity$4 ? format.cljs$core$IFn$_invoke$arity$4(G__44455,G__44456,G__44457,G__44458) : format.call(null,G__44455,G__44456,G__44457,G__44458));
} else {
var G__44463 = "Execution error%s at %s(%s).\n%s\n";
var G__44464 = cause_type;
var G__44465 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__44466 = loc;
var G__44467 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__44463,G__44464,G__44465,G__44466,G__44467) : format.call(null,G__44463,G__44464,G__44465,G__44466,G__44467));
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44424__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str(cljs.repl.ex_triage(cljs.repl.Error__GT_map(error)));
});

//# sourceMappingURL=cljs.repl.js.map
