goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__46732 = arguments.length;
switch (G__46732) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46737 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46737 = (function (f,blockable,meta46738){
this.f = f;
this.blockable = blockable;
this.meta46738 = meta46738;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async46737.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46739,meta46738__$1){
var self__ = this;
var _46739__$1 = this;
return (new cljs.core.async.t_cljs$core$async46737(self__.f,self__.blockable,meta46738__$1));
});

cljs.core.async.t_cljs$core$async46737.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46739){
var self__ = this;
var _46739__$1 = this;
return self__.meta46738;
});

cljs.core.async.t_cljs$core$async46737.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46737.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async46737.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async46737.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async46737.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta46738","meta46738",779191579,null)], null);
});

cljs.core.async.t_cljs$core$async46737.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46737.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46737";

cljs.core.async.t_cljs$core$async46737.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async46737");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46737.
 */
cljs.core.async.__GT_t_cljs$core$async46737 = (function cljs$core$async$__GT_t_cljs$core$async46737(f__$1,blockable__$1,meta46738){
return (new cljs.core.async.t_cljs$core$async46737(f__$1,blockable__$1,meta46738));
});

}

return (new cljs.core.async.t_cljs$core$async46737(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__46768 = arguments.length;
switch (G__46768) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__46775 = arguments.length;
switch (G__46775) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__46781 = arguments.length;
switch (G__46781) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_49035 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49035) : fn1.call(null,val_49035));
} else {
cljs.core.async.impl.dispatch.run(((function (val_49035,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49035) : fn1.call(null,val_49035));
});})(val_49035,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__46815 = arguments.length;
switch (G__46815) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5816__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5816__auto__)){
var ret = temp__5816__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5816__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5816__auto__)){
var retb = temp__5816__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5816__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5816__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___49064 = n;
var x_49065 = (0);
while(true){
if((x_49065 < n__4607__auto___49064)){
(a[x_49065] = x_49065);

var G__49067 = (x_49065 + (1));
x_49065 = G__49067;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46861 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46861 = (function (flag,meta46862){
this.flag = flag;
this.meta46862 = meta46862;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async46861.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_46863,meta46862__$1){
var self__ = this;
var _46863__$1 = this;
return (new cljs.core.async.t_cljs$core$async46861(self__.flag,meta46862__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async46861.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_46863){
var self__ = this;
var _46863__$1 = this;
return self__.meta46862;
});})(flag))
;

cljs.core.async.t_cljs$core$async46861.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46861.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async46861.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async46861.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async46861.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta46862","meta46862",-722150334,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async46861.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46861.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46861";

cljs.core.async.t_cljs$core$async46861.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async46861");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46861.
 */
cljs.core.async.__GT_t_cljs$core$async46861 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async46861(flag__$1,meta46862){
return (new cljs.core.async.t_cljs$core$async46861(flag__$1,meta46862));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async46861(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46878 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46878 = (function (flag,cb,meta46879){
this.flag = flag;
this.cb = cb;
this.meta46879 = meta46879;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async46878.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46880,meta46879__$1){
var self__ = this;
var _46880__$1 = this;
return (new cljs.core.async.t_cljs$core$async46878(self__.flag,self__.cb,meta46879__$1));
});

cljs.core.async.t_cljs$core$async46878.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46880){
var self__ = this;
var _46880__$1 = this;
return self__.meta46879;
});

cljs.core.async.t_cljs$core$async46878.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async46878.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async46878.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async46878.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async46878.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta46879","meta46879",1342917266,null)], null);
});

cljs.core.async.t_cljs$core$async46878.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async46878.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46878";

cljs.core.async.t_cljs$core$async46878.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async46878");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46878.
 */
cljs.core.async.__GT_t_cljs$core$async46878 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async46878(flag__$1,cb__$1,meta46879){
return (new cljs.core.async.t_cljs$core$async46878(flag__$1,cb__$1,meta46879));
});

}

return (new cljs.core.async.t_cljs$core$async46878(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46913_SHARP_){
var G__46933 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46913_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__46933) : fret.call(null,G__46933));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__46914_SHARP_){
var G__46938 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__46914_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__46938) : fret.call(null,G__46938));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__49119 = (i + (1));
i = G__49119;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5818__auto__ = (function (){var and__4120__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4120__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5818__auto__)){
var got = temp__5818__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___49146 = arguments.length;
var i__4731__auto___49147 = (0);
while(true){
if((i__4731__auto___49147 < len__4730__auto___49146)){
args__4736__auto__.push((arguments[i__4731__auto___49147]));

var G__49150 = (i__4731__auto___49147 + (1));
i__4731__auto___49147 = G__49150;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__46947){
var map__46948 = p__46947;
var map__46948__$1 = (((((!((map__46948 == null))))?(((((map__46948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46948.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46948):map__46948);
var opts = map__46948__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq46945){
var G__46946 = cljs.core.first(seq46945);
var seq46945__$1 = cljs.core.next(seq46945);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46946,seq46945__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__46952 = arguments.length;
switch (G__46952) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__46663__auto___49172 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___49172){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___49172){
return (function (state_47002){
var state_val_47003 = (state_47002[(1)]);
if((state_val_47003 === (7))){
var inst_46995 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
var statearr_47007_49175 = state_47002__$1;
(statearr_47007_49175[(2)] = inst_46995);

(statearr_47007_49175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (1))){
var state_47002__$1 = state_47002;
var statearr_47008_49178 = state_47002__$1;
(statearr_47008_49178[(2)] = null);

(statearr_47008_49178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (4))){
var inst_46974 = (state_47002[(7)]);
var inst_46974__$1 = (state_47002[(2)]);
var inst_46979 = (inst_46974__$1 == null);
var state_47002__$1 = (function (){var statearr_47010 = state_47002;
(statearr_47010[(7)] = inst_46974__$1);

return statearr_47010;
})();
if(cljs.core.truth_(inst_46979)){
var statearr_47011_49181 = state_47002__$1;
(statearr_47011_49181[(1)] = (5));

} else {
var statearr_47012_49184 = state_47002__$1;
(statearr_47012_49184[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (13))){
var state_47002__$1 = state_47002;
var statearr_47013_49186 = state_47002__$1;
(statearr_47013_49186[(2)] = null);

(statearr_47013_49186[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (6))){
var inst_46974 = (state_47002[(7)]);
var state_47002__$1 = state_47002;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47002__$1,(11),to,inst_46974);
} else {
if((state_val_47003 === (3))){
var inst_47000 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47002__$1,inst_47000);
} else {
if((state_val_47003 === (12))){
var state_47002__$1 = state_47002;
var statearr_47018_49192 = state_47002__$1;
(statearr_47018_49192[(2)] = null);

(statearr_47018_49192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (2))){
var state_47002__$1 = state_47002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47002__$1,(4),from);
} else {
if((state_val_47003 === (11))){
var inst_46988 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
if(cljs.core.truth_(inst_46988)){
var statearr_47019_49193 = state_47002__$1;
(statearr_47019_49193[(1)] = (12));

} else {
var statearr_47020_49195 = state_47002__$1;
(statearr_47020_49195[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (9))){
var state_47002__$1 = state_47002;
var statearr_47021_49199 = state_47002__$1;
(statearr_47021_49199[(2)] = null);

(statearr_47021_49199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (5))){
var state_47002__$1 = state_47002;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47022_49200 = state_47002__$1;
(statearr_47022_49200[(1)] = (8));

} else {
var statearr_47023_49201 = state_47002__$1;
(statearr_47023_49201[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (14))){
var inst_46993 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
var statearr_47025_49203 = state_47002__$1;
(statearr_47025_49203[(2)] = inst_46993);

(statearr_47025_49203[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (10))){
var inst_46985 = (state_47002[(2)]);
var state_47002__$1 = state_47002;
var statearr_47026_49205 = state_47002__$1;
(statearr_47026_49205[(2)] = inst_46985);

(statearr_47026_49205[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47003 === (8))){
var inst_46982 = cljs.core.async.close_BANG_(to);
var state_47002__$1 = state_47002;
var statearr_47027_49207 = state_47002__$1;
(statearr_47027_49207[(2)] = inst_46982);

(statearr_47027_49207[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___49172))
;
return ((function (switch__46368__auto__,c__46663__auto___49172){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_47028 = [null,null,null,null,null,null,null,null];
(statearr_47028[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_47028[(1)] = (1));

return statearr_47028;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_47002){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47002);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47029){if((e47029 instanceof Object)){
var ex__46372__auto__ = e47029;
var statearr_47030_49210 = state_47002;
(statearr_47030_49210[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47002);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47029;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49213 = state_47002;
state_47002 = G__49213;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_47002){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_47002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___49172))
})();
var state__46665__auto__ = (function (){var statearr_47031 = f__46664__auto__();
(statearr_47031[(6)] = c__46663__auto___49172);

return statearr_47031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___49172))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__47045){
var vec__47046 = p__47045;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47046,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47046,(1),null);
var job = vec__47046;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__46663__auto___49219 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___49219,res,vec__47046,v,p,job,jobs,results){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___49219,res,vec__47046,v,p,job,jobs,results){
return (function (state_47053){
var state_val_47054 = (state_47053[(1)]);
if((state_val_47054 === (1))){
var state_47053__$1 = state_47053;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47053__$1,(2),res,v);
} else {
if((state_val_47054 === (2))){
var inst_47050 = (state_47053[(2)]);
var inst_47051 = cljs.core.async.close_BANG_(res);
var state_47053__$1 = (function (){var statearr_47056 = state_47053;
(statearr_47056[(7)] = inst_47050);

return statearr_47056;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47053__$1,inst_47051);
} else {
return null;
}
}
});})(c__46663__auto___49219,res,vec__47046,v,p,job,jobs,results))
;
return ((function (switch__46368__auto__,c__46663__auto___49219,res,vec__47046,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0 = (function (){
var statearr_47057 = [null,null,null,null,null,null,null,null];
(statearr_47057[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__);

(statearr_47057[(1)] = (1));

return statearr_47057;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1 = (function (state_47053){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47053);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47058){if((e47058 instanceof Object)){
var ex__46372__auto__ = e47058;
var statearr_47059_49236 = state_47053;
(statearr_47059_49236[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47053);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47058;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49239 = state_47053;
state_47053 = G__49239;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = function(state_47053){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1.call(this,state_47053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___49219,res,vec__47046,v,p,job,jobs,results))
})();
var state__46665__auto__ = (function (){var statearr_47061 = f__46664__auto__();
(statearr_47061[(6)] = c__46663__auto___49219);

return statearr_47061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___49219,res,vec__47046,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__47062){
var vec__47063 = p__47062;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47063,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47063,(1),null);
var job = vec__47063;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___49242 = n;
var __49244 = (0);
while(true){
if((__49244 < n__4607__auto___49242)){
var G__47066_49245 = type;
var G__47066_49246__$1 = (((G__47066_49245 instanceof cljs.core.Keyword))?G__47066_49245.fqn:null);
switch (G__47066_49246__$1) {
case "compute":
var c__46663__auto___49249 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49244,c__46663__auto___49249,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (__49244,c__46663__auto___49249,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async){
return (function (state_47082){
var state_val_47083 = (state_47082[(1)]);
if((state_val_47083 === (1))){
var state_47082__$1 = state_47082;
var statearr_47084_49254 = state_47082__$1;
(statearr_47084_49254[(2)] = null);

(statearr_47084_49254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47083 === (2))){
var state_47082__$1 = state_47082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47082__$1,(4),jobs);
} else {
if((state_val_47083 === (3))){
var inst_47080 = (state_47082[(2)]);
var state_47082__$1 = state_47082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47082__$1,inst_47080);
} else {
if((state_val_47083 === (4))){
var inst_47072 = (state_47082[(2)]);
var inst_47073 = process(inst_47072);
var state_47082__$1 = state_47082;
if(cljs.core.truth_(inst_47073)){
var statearr_47085_49261 = state_47082__$1;
(statearr_47085_49261[(1)] = (5));

} else {
var statearr_47086_49262 = state_47082__$1;
(statearr_47086_49262[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47083 === (5))){
var state_47082__$1 = state_47082;
var statearr_47088_49263 = state_47082__$1;
(statearr_47088_49263[(2)] = null);

(statearr_47088_49263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47083 === (6))){
var state_47082__$1 = state_47082;
var statearr_47089_49266 = state_47082__$1;
(statearr_47089_49266[(2)] = null);

(statearr_47089_49266[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47083 === (7))){
var inst_47078 = (state_47082[(2)]);
var state_47082__$1 = state_47082;
var statearr_47090_49270 = state_47082__$1;
(statearr_47090_49270[(2)] = inst_47078);

(statearr_47090_49270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49244,c__46663__auto___49249,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async))
;
return ((function (__49244,switch__46368__auto__,c__46663__auto___49249,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0 = (function (){
var statearr_47091 = [null,null,null,null,null,null,null];
(statearr_47091[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__);

(statearr_47091[(1)] = (1));

return statearr_47091;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1 = (function (state_47082){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47082);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47092){if((e47092 instanceof Object)){
var ex__46372__auto__ = e47092;
var statearr_47093_49274 = state_47082;
(statearr_47093_49274[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47082);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47092;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49275 = state_47082;
state_47082 = G__49275;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = function(state_47082){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1.call(this,state_47082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__;
})()
;})(__49244,switch__46368__auto__,c__46663__auto___49249,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async))
})();
var state__46665__auto__ = (function (){var statearr_47095 = f__46664__auto__();
(statearr_47095[(6)] = c__46663__auto___49249);

return statearr_47095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(__49244,c__46663__auto___49249,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async))
);


break;
case "async":
var c__46663__auto___49283 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49244,c__46663__auto___49283,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (__49244,c__46663__auto___49283,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async){
return (function (state_47111){
var state_val_47112 = (state_47111[(1)]);
if((state_val_47112 === (1))){
var state_47111__$1 = state_47111;
var statearr_47120_49286 = state_47111__$1;
(statearr_47120_49286[(2)] = null);

(statearr_47120_49286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47112 === (2))){
var state_47111__$1 = state_47111;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47111__$1,(4),jobs);
} else {
if((state_val_47112 === (3))){
var inst_47109 = (state_47111[(2)]);
var state_47111__$1 = state_47111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47111__$1,inst_47109);
} else {
if((state_val_47112 === (4))){
var inst_47101 = (state_47111[(2)]);
var inst_47102 = async(inst_47101);
var state_47111__$1 = state_47111;
if(cljs.core.truth_(inst_47102)){
var statearr_47121_49291 = state_47111__$1;
(statearr_47121_49291[(1)] = (5));

} else {
var statearr_47124_49294 = state_47111__$1;
(statearr_47124_49294[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47112 === (5))){
var state_47111__$1 = state_47111;
var statearr_47125_49295 = state_47111__$1;
(statearr_47125_49295[(2)] = null);

(statearr_47125_49295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47112 === (6))){
var state_47111__$1 = state_47111;
var statearr_47126_49303 = state_47111__$1;
(statearr_47126_49303[(2)] = null);

(statearr_47126_49303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47112 === (7))){
var inst_47107 = (state_47111[(2)]);
var state_47111__$1 = state_47111;
var statearr_47127_49306 = state_47111__$1;
(statearr_47127_49306[(2)] = inst_47107);

(statearr_47127_49306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49244,c__46663__auto___49283,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async))
;
return ((function (__49244,switch__46368__auto__,c__46663__auto___49283,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0 = (function (){
var statearr_47128 = [null,null,null,null,null,null,null];
(statearr_47128[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__);

(statearr_47128[(1)] = (1));

return statearr_47128;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1 = (function (state_47111){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47111);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47129){if((e47129 instanceof Object)){
var ex__46372__auto__ = e47129;
var statearr_47130_49315 = state_47111;
(statearr_47130_49315[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47111);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47129;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49320 = state_47111;
state_47111 = G__49320;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = function(state_47111){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1.call(this,state_47111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__;
})()
;})(__49244,switch__46368__auto__,c__46663__auto___49283,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async))
})();
var state__46665__auto__ = (function (){var statearr_47132 = f__46664__auto__();
(statearr_47132[(6)] = c__46663__auto___49283);

return statearr_47132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(__49244,c__46663__auto___49283,G__47066_49245,G__47066_49246__$1,n__4607__auto___49242,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__47066_49246__$1)].join('')));

}

var G__49324 = (__49244 + (1));
__49244 = G__49324;
continue;
} else {
}
break;
}

var c__46663__auto___49326 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___49326,jobs,results,process,async){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___49326,jobs,results,process,async){
return (function (state_47154){
var state_val_47155 = (state_47154[(1)]);
if((state_val_47155 === (7))){
var inst_47150 = (state_47154[(2)]);
var state_47154__$1 = state_47154;
var statearr_47165_49331 = state_47154__$1;
(statearr_47165_49331[(2)] = inst_47150);

(statearr_47165_49331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47155 === (1))){
var state_47154__$1 = state_47154;
var statearr_47166_49332 = state_47154__$1;
(statearr_47166_49332[(2)] = null);

(statearr_47166_49332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47155 === (4))){
var inst_47135 = (state_47154[(7)]);
var inst_47135__$1 = (state_47154[(2)]);
var inst_47136 = (inst_47135__$1 == null);
var state_47154__$1 = (function (){var statearr_47171 = state_47154;
(statearr_47171[(7)] = inst_47135__$1);

return statearr_47171;
})();
if(cljs.core.truth_(inst_47136)){
var statearr_47172_49336 = state_47154__$1;
(statearr_47172_49336[(1)] = (5));

} else {
var statearr_47173_49338 = state_47154__$1;
(statearr_47173_49338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47155 === (6))){
var inst_47140 = (state_47154[(8)]);
var inst_47135 = (state_47154[(7)]);
var inst_47140__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_47141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47142 = [inst_47135,inst_47140__$1];
var inst_47143 = (new cljs.core.PersistentVector(null,2,(5),inst_47141,inst_47142,null));
var state_47154__$1 = (function (){var statearr_47174 = state_47154;
(statearr_47174[(8)] = inst_47140__$1);

return statearr_47174;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47154__$1,(8),jobs,inst_47143);
} else {
if((state_val_47155 === (3))){
var inst_47152 = (state_47154[(2)]);
var state_47154__$1 = state_47154;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47154__$1,inst_47152);
} else {
if((state_val_47155 === (2))){
var state_47154__$1 = state_47154;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47154__$1,(4),from);
} else {
if((state_val_47155 === (9))){
var inst_47147 = (state_47154[(2)]);
var state_47154__$1 = (function (){var statearr_47178 = state_47154;
(statearr_47178[(9)] = inst_47147);

return statearr_47178;
})();
var statearr_47179_49349 = state_47154__$1;
(statearr_47179_49349[(2)] = null);

(statearr_47179_49349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47155 === (5))){
var inst_47138 = cljs.core.async.close_BANG_(jobs);
var state_47154__$1 = state_47154;
var statearr_47181_49353 = state_47154__$1;
(statearr_47181_49353[(2)] = inst_47138);

(statearr_47181_49353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47155 === (8))){
var inst_47140 = (state_47154[(8)]);
var inst_47145 = (state_47154[(2)]);
var state_47154__$1 = (function (){var statearr_47182 = state_47154;
(statearr_47182[(10)] = inst_47145);

return statearr_47182;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47154__$1,(9),results,inst_47140);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___49326,jobs,results,process,async))
;
return ((function (switch__46368__auto__,c__46663__auto___49326,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0 = (function (){
var statearr_47183 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47183[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__);

(statearr_47183[(1)] = (1));

return statearr_47183;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1 = (function (state_47154){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47154);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47185){if((e47185 instanceof Object)){
var ex__46372__auto__ = e47185;
var statearr_47186_49366 = state_47154;
(statearr_47186_49366[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47185;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49371 = state_47154;
state_47154 = G__49371;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = function(state_47154){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1.call(this,state_47154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___49326,jobs,results,process,async))
})();
var state__46665__auto__ = (function (){var statearr_47187 = f__46664__auto__();
(statearr_47187[(6)] = c__46663__auto___49326);

return statearr_47187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___49326,jobs,results,process,async))
);


var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__,jobs,results,process,async){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__,jobs,results,process,async){
return (function (state_47225){
var state_val_47230 = (state_47225[(1)]);
if((state_val_47230 === (7))){
var inst_47221 = (state_47225[(2)]);
var state_47225__$1 = state_47225;
var statearr_47236_49384 = state_47225__$1;
(statearr_47236_49384[(2)] = inst_47221);

(statearr_47236_49384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (20))){
var state_47225__$1 = state_47225;
var statearr_47237_49390 = state_47225__$1;
(statearr_47237_49390[(2)] = null);

(statearr_47237_49390[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (1))){
var state_47225__$1 = state_47225;
var statearr_47238_49394 = state_47225__$1;
(statearr_47238_49394[(2)] = null);

(statearr_47238_49394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (4))){
var inst_47190 = (state_47225[(7)]);
var inst_47190__$1 = (state_47225[(2)]);
var inst_47191 = (inst_47190__$1 == null);
var state_47225__$1 = (function (){var statearr_47239 = state_47225;
(statearr_47239[(7)] = inst_47190__$1);

return statearr_47239;
})();
if(cljs.core.truth_(inst_47191)){
var statearr_47240_49404 = state_47225__$1;
(statearr_47240_49404[(1)] = (5));

} else {
var statearr_47241_49405 = state_47225__$1;
(statearr_47241_49405[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (15))){
var inst_47203 = (state_47225[(8)]);
var state_47225__$1 = state_47225;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47225__$1,(18),to,inst_47203);
} else {
if((state_val_47230 === (21))){
var inst_47216 = (state_47225[(2)]);
var state_47225__$1 = state_47225;
var statearr_47242_49410 = state_47225__$1;
(statearr_47242_49410[(2)] = inst_47216);

(statearr_47242_49410[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (13))){
var inst_47218 = (state_47225[(2)]);
var state_47225__$1 = (function (){var statearr_47243 = state_47225;
(statearr_47243[(9)] = inst_47218);

return statearr_47243;
})();
var statearr_47244_49417 = state_47225__$1;
(statearr_47244_49417[(2)] = null);

(statearr_47244_49417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (6))){
var inst_47190 = (state_47225[(7)]);
var state_47225__$1 = state_47225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47225__$1,(11),inst_47190);
} else {
if((state_val_47230 === (17))){
var inst_47211 = (state_47225[(2)]);
var state_47225__$1 = state_47225;
if(cljs.core.truth_(inst_47211)){
var statearr_47245_49419 = state_47225__$1;
(statearr_47245_49419[(1)] = (19));

} else {
var statearr_47246_49420 = state_47225__$1;
(statearr_47246_49420[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (3))){
var inst_47223 = (state_47225[(2)]);
var state_47225__$1 = state_47225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47225__$1,inst_47223);
} else {
if((state_val_47230 === (12))){
var inst_47200 = (state_47225[(10)]);
var state_47225__$1 = state_47225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47225__$1,(14),inst_47200);
} else {
if((state_val_47230 === (2))){
var state_47225__$1 = state_47225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47225__$1,(4),results);
} else {
if((state_val_47230 === (19))){
var state_47225__$1 = state_47225;
var statearr_47251_49421 = state_47225__$1;
(statearr_47251_49421[(2)] = null);

(statearr_47251_49421[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (11))){
var inst_47200 = (state_47225[(2)]);
var state_47225__$1 = (function (){var statearr_47252 = state_47225;
(statearr_47252[(10)] = inst_47200);

return statearr_47252;
})();
var statearr_47253_49423 = state_47225__$1;
(statearr_47253_49423[(2)] = null);

(statearr_47253_49423[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (9))){
var state_47225__$1 = state_47225;
var statearr_47254_49427 = state_47225__$1;
(statearr_47254_49427[(2)] = null);

(statearr_47254_49427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (5))){
var state_47225__$1 = state_47225;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47255_49428 = state_47225__$1;
(statearr_47255_49428[(1)] = (8));

} else {
var statearr_47256_49429 = state_47225__$1;
(statearr_47256_49429[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (14))){
var inst_47203 = (state_47225[(8)]);
var inst_47205 = (state_47225[(11)]);
var inst_47203__$1 = (state_47225[(2)]);
var inst_47204 = (inst_47203__$1 == null);
var inst_47205__$1 = cljs.core.not(inst_47204);
var state_47225__$1 = (function (){var statearr_47258 = state_47225;
(statearr_47258[(8)] = inst_47203__$1);

(statearr_47258[(11)] = inst_47205__$1);

return statearr_47258;
})();
if(inst_47205__$1){
var statearr_47259_49432 = state_47225__$1;
(statearr_47259_49432[(1)] = (15));

} else {
var statearr_47260_49433 = state_47225__$1;
(statearr_47260_49433[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (16))){
var inst_47205 = (state_47225[(11)]);
var state_47225__$1 = state_47225;
var statearr_47261_49434 = state_47225__$1;
(statearr_47261_49434[(2)] = inst_47205);

(statearr_47261_49434[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (10))){
var inst_47197 = (state_47225[(2)]);
var state_47225__$1 = state_47225;
var statearr_47262_49435 = state_47225__$1;
(statearr_47262_49435[(2)] = inst_47197);

(statearr_47262_49435[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (18))){
var inst_47208 = (state_47225[(2)]);
var state_47225__$1 = state_47225;
var statearr_47263_49436 = state_47225__$1;
(statearr_47263_49436[(2)] = inst_47208);

(statearr_47263_49436[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47230 === (8))){
var inst_47194 = cljs.core.async.close_BANG_(to);
var state_47225__$1 = state_47225;
var statearr_47266_49437 = state_47225__$1;
(statearr_47266_49437[(2)] = inst_47194);

(statearr_47266_49437[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto__,jobs,results,process,async))
;
return ((function (switch__46368__auto__,c__46663__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0 = (function (){
var statearr_47268 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47268[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__);

(statearr_47268[(1)] = (1));

return statearr_47268;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1 = (function (state_47225){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47225);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47269){if((e47269 instanceof Object)){
var ex__46372__auto__ = e47269;
var statearr_47270_49443 = state_47225;
(statearr_47270_49443[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47225);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47269;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49447 = state_47225;
state_47225 = G__49447;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__ = function(state_47225){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1.call(this,state_47225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46369__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__,jobs,results,process,async))
})();
var state__46665__auto__ = (function (){var statearr_47271 = f__46664__auto__();
(statearr_47271[(6)] = c__46663__auto__);

return statearr_47271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__,jobs,results,process,async))
);

return c__46663__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__47273 = arguments.length;
switch (G__47273) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__47284 = arguments.length;
switch (G__47284) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__47297 = arguments.length;
switch (G__47297) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__46663__auto___49468 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___49468,tc,fc){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___49468,tc,fc){
return (function (state_47327){
var state_val_47328 = (state_47327[(1)]);
if((state_val_47328 === (7))){
var inst_47323 = (state_47327[(2)]);
var state_47327__$1 = state_47327;
var statearr_47330_49479 = state_47327__$1;
(statearr_47330_49479[(2)] = inst_47323);

(statearr_47330_49479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (1))){
var state_47327__$1 = state_47327;
var statearr_47334_49480 = state_47327__$1;
(statearr_47334_49480[(2)] = null);

(statearr_47334_49480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (4))){
var inst_47302 = (state_47327[(7)]);
var inst_47302__$1 = (state_47327[(2)]);
var inst_47305 = (inst_47302__$1 == null);
var state_47327__$1 = (function (){var statearr_47335 = state_47327;
(statearr_47335[(7)] = inst_47302__$1);

return statearr_47335;
})();
if(cljs.core.truth_(inst_47305)){
var statearr_47336_49481 = state_47327__$1;
(statearr_47336_49481[(1)] = (5));

} else {
var statearr_47337_49486 = state_47327__$1;
(statearr_47337_49486[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (13))){
var state_47327__$1 = state_47327;
var statearr_47342_49488 = state_47327__$1;
(statearr_47342_49488[(2)] = null);

(statearr_47342_49488[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (6))){
var inst_47302 = (state_47327[(7)]);
var inst_47310 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47302) : p.call(null,inst_47302));
var state_47327__$1 = state_47327;
if(cljs.core.truth_(inst_47310)){
var statearr_47345_49489 = state_47327__$1;
(statearr_47345_49489[(1)] = (9));

} else {
var statearr_47346_49490 = state_47327__$1;
(statearr_47346_49490[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (3))){
var inst_47325 = (state_47327[(2)]);
var state_47327__$1 = state_47327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47327__$1,inst_47325);
} else {
if((state_val_47328 === (12))){
var state_47327__$1 = state_47327;
var statearr_47348_49496 = state_47327__$1;
(statearr_47348_49496[(2)] = null);

(statearr_47348_49496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (2))){
var state_47327__$1 = state_47327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47327__$1,(4),ch);
} else {
if((state_val_47328 === (11))){
var inst_47302 = (state_47327[(7)]);
var inst_47314 = (state_47327[(2)]);
var state_47327__$1 = state_47327;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47327__$1,(8),inst_47314,inst_47302);
} else {
if((state_val_47328 === (9))){
var state_47327__$1 = state_47327;
var statearr_47353_49503 = state_47327__$1;
(statearr_47353_49503[(2)] = tc);

(statearr_47353_49503[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (5))){
var inst_47307 = cljs.core.async.close_BANG_(tc);
var inst_47308 = cljs.core.async.close_BANG_(fc);
var state_47327__$1 = (function (){var statearr_47354 = state_47327;
(statearr_47354[(8)] = inst_47307);

return statearr_47354;
})();
var statearr_47355_49504 = state_47327__$1;
(statearr_47355_49504[(2)] = inst_47308);

(statearr_47355_49504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (14))){
var inst_47321 = (state_47327[(2)]);
var state_47327__$1 = state_47327;
var statearr_47356_49505 = state_47327__$1;
(statearr_47356_49505[(2)] = inst_47321);

(statearr_47356_49505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (10))){
var state_47327__$1 = state_47327;
var statearr_47357_49506 = state_47327__$1;
(statearr_47357_49506[(2)] = fc);

(statearr_47357_49506[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47328 === (8))){
var inst_47316 = (state_47327[(2)]);
var state_47327__$1 = state_47327;
if(cljs.core.truth_(inst_47316)){
var statearr_47358_49511 = state_47327__$1;
(statearr_47358_49511[(1)] = (12));

} else {
var statearr_47359_49512 = state_47327__$1;
(statearr_47359_49512[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___49468,tc,fc))
;
return ((function (switch__46368__auto__,c__46663__auto___49468,tc,fc){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_47361 = [null,null,null,null,null,null,null,null,null];
(statearr_47361[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_47361[(1)] = (1));

return statearr_47361;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_47327){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47327);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47362){if((e47362 instanceof Object)){
var ex__46372__auto__ = e47362;
var statearr_47363_49519 = state_47327;
(statearr_47363_49519[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47362;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49520 = state_47327;
state_47327 = G__49520;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_47327){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_47327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___49468,tc,fc))
})();
var state__46665__auto__ = (function (){var statearr_47367 = f__46664__auto__();
(statearr_47367[(6)] = c__46663__auto___49468);

return statearr_47367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___49468,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__){
return (function (state_47391){
var state_val_47392 = (state_47391[(1)]);
if((state_val_47392 === (7))){
var inst_47384 = (state_47391[(2)]);
var state_47391__$1 = state_47391;
var statearr_47393_49521 = state_47391__$1;
(statearr_47393_49521[(2)] = inst_47384);

(statearr_47393_49521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47392 === (1))){
var inst_47368 = init;
var state_47391__$1 = (function (){var statearr_47395 = state_47391;
(statearr_47395[(7)] = inst_47368);

return statearr_47395;
})();
var statearr_47396_49522 = state_47391__$1;
(statearr_47396_49522[(2)] = null);

(statearr_47396_49522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47392 === (4))){
var inst_47371 = (state_47391[(8)]);
var inst_47371__$1 = (state_47391[(2)]);
var inst_47372 = (inst_47371__$1 == null);
var state_47391__$1 = (function (){var statearr_47397 = state_47391;
(statearr_47397[(8)] = inst_47371__$1);

return statearr_47397;
})();
if(cljs.core.truth_(inst_47372)){
var statearr_47398_49530 = state_47391__$1;
(statearr_47398_49530[(1)] = (5));

} else {
var statearr_47399_49531 = state_47391__$1;
(statearr_47399_49531[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47392 === (6))){
var inst_47368 = (state_47391[(7)]);
var inst_47375 = (state_47391[(9)]);
var inst_47371 = (state_47391[(8)]);
var inst_47375__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_47368,inst_47371) : f.call(null,inst_47368,inst_47371));
var inst_47376 = cljs.core.reduced_QMARK_(inst_47375__$1);
var state_47391__$1 = (function (){var statearr_47401 = state_47391;
(statearr_47401[(9)] = inst_47375__$1);

return statearr_47401;
})();
if(inst_47376){
var statearr_47402_49533 = state_47391__$1;
(statearr_47402_49533[(1)] = (8));

} else {
var statearr_47403_49534 = state_47391__$1;
(statearr_47403_49534[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47392 === (3))){
var inst_47386 = (state_47391[(2)]);
var state_47391__$1 = state_47391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47391__$1,inst_47386);
} else {
if((state_val_47392 === (2))){
var state_47391__$1 = state_47391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47391__$1,(4),ch);
} else {
if((state_val_47392 === (9))){
var inst_47375 = (state_47391[(9)]);
var inst_47368 = inst_47375;
var state_47391__$1 = (function (){var statearr_47405 = state_47391;
(statearr_47405[(7)] = inst_47368);

return statearr_47405;
})();
var statearr_47406_49535 = state_47391__$1;
(statearr_47406_49535[(2)] = null);

(statearr_47406_49535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47392 === (5))){
var inst_47368 = (state_47391[(7)]);
var state_47391__$1 = state_47391;
var statearr_47407_49536 = state_47391__$1;
(statearr_47407_49536[(2)] = inst_47368);

(statearr_47407_49536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47392 === (10))){
var inst_47382 = (state_47391[(2)]);
var state_47391__$1 = state_47391;
var statearr_47412_49537 = state_47391__$1;
(statearr_47412_49537[(2)] = inst_47382);

(statearr_47412_49537[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47392 === (8))){
var inst_47375 = (state_47391[(9)]);
var inst_47378 = cljs.core.deref(inst_47375);
var state_47391__$1 = state_47391;
var statearr_47415_49538 = state_47391__$1;
(statearr_47415_49538[(2)] = inst_47378);

(statearr_47415_49538[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto__))
;
return ((function (switch__46368__auto__,c__46663__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__46369__auto__ = null;
var cljs$core$async$reduce_$_state_machine__46369__auto____0 = (function (){
var statearr_47422 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47422[(0)] = cljs$core$async$reduce_$_state_machine__46369__auto__);

(statearr_47422[(1)] = (1));

return statearr_47422;
});
var cljs$core$async$reduce_$_state_machine__46369__auto____1 = (function (state_47391){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47391);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47424){if((e47424 instanceof Object)){
var ex__46372__auto__ = e47424;
var statearr_47425_49539 = state_47391;
(statearr_47425_49539[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47391);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47424;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49540 = state_47391;
state_47391 = G__49540;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__46369__auto__ = function(state_47391){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__46369__auto____1.call(this,state_47391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__46369__auto____0;
cljs$core$async$reduce_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__46369__auto____1;
return cljs$core$async$reduce_$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__))
})();
var state__46665__auto__ = (function (){var statearr_47430 = f__46664__auto__();
(statearr_47430[(6)] = c__46663__auto__);

return statearr_47430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__))
);

return c__46663__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__,f__$1){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__,f__$1){
return (function (state_47442){
var state_val_47443 = (state_47442[(1)]);
if((state_val_47443 === (1))){
var inst_47437 = cljs.core.async.reduce(f__$1,init,ch);
var state_47442__$1 = state_47442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47442__$1,(2),inst_47437);
} else {
if((state_val_47443 === (2))){
var inst_47439 = (state_47442[(2)]);
var inst_47440 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_47439) : f__$1.call(null,inst_47439));
var state_47442__$1 = state_47442;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47442__$1,inst_47440);
} else {
return null;
}
}
});})(c__46663__auto__,f__$1))
;
return ((function (switch__46368__auto__,c__46663__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__46369__auto__ = null;
var cljs$core$async$transduce_$_state_machine__46369__auto____0 = (function (){
var statearr_47453 = [null,null,null,null,null,null,null];
(statearr_47453[(0)] = cljs$core$async$transduce_$_state_machine__46369__auto__);

(statearr_47453[(1)] = (1));

return statearr_47453;
});
var cljs$core$async$transduce_$_state_machine__46369__auto____1 = (function (state_47442){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47442);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47457){if((e47457 instanceof Object)){
var ex__46372__auto__ = e47457;
var statearr_47458_49549 = state_47442;
(statearr_47458_49549[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47442);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47457;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49550 = state_47442;
state_47442 = G__49550;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__46369__auto__ = function(state_47442){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__46369__auto____1.call(this,state_47442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__46369__auto____0;
cljs$core$async$transduce_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__46369__auto____1;
return cljs$core$async$transduce_$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__,f__$1))
})();
var state__46665__auto__ = (function (){var statearr_47463 = f__46664__auto__();
(statearr_47463[(6)] = c__46663__auto__);

return statearr_47463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__,f__$1))
);

return c__46663__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__47465 = arguments.length;
switch (G__47465) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__){
return (function (state_47493){
var state_val_47494 = (state_47493[(1)]);
if((state_val_47494 === (7))){
var inst_47472 = (state_47493[(2)]);
var state_47493__$1 = state_47493;
var statearr_47498_49560 = state_47493__$1;
(statearr_47498_49560[(2)] = inst_47472);

(statearr_47498_49560[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (1))){
var inst_47466 = cljs.core.seq(coll);
var inst_47467 = inst_47466;
var state_47493__$1 = (function (){var statearr_47499 = state_47493;
(statearr_47499[(7)] = inst_47467);

return statearr_47499;
})();
var statearr_47500_49561 = state_47493__$1;
(statearr_47500_49561[(2)] = null);

(statearr_47500_49561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (4))){
var inst_47467 = (state_47493[(7)]);
var inst_47470 = cljs.core.first(inst_47467);
var state_47493__$1 = state_47493;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47493__$1,(7),ch,inst_47470);
} else {
if((state_val_47494 === (13))){
var inst_47486 = (state_47493[(2)]);
var state_47493__$1 = state_47493;
var statearr_47502_49564 = state_47493__$1;
(statearr_47502_49564[(2)] = inst_47486);

(statearr_47502_49564[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (6))){
var inst_47475 = (state_47493[(2)]);
var state_47493__$1 = state_47493;
if(cljs.core.truth_(inst_47475)){
var statearr_47503_49566 = state_47493__$1;
(statearr_47503_49566[(1)] = (8));

} else {
var statearr_47504_49567 = state_47493__$1;
(statearr_47504_49567[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (3))){
var inst_47490 = (state_47493[(2)]);
var state_47493__$1 = state_47493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47493__$1,inst_47490);
} else {
if((state_val_47494 === (12))){
var state_47493__$1 = state_47493;
var statearr_47505_49569 = state_47493__$1;
(statearr_47505_49569[(2)] = null);

(statearr_47505_49569[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (2))){
var inst_47467 = (state_47493[(7)]);
var state_47493__$1 = state_47493;
if(cljs.core.truth_(inst_47467)){
var statearr_47506_49570 = state_47493__$1;
(statearr_47506_49570[(1)] = (4));

} else {
var statearr_47507_49571 = state_47493__$1;
(statearr_47507_49571[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (11))){
var inst_47483 = cljs.core.async.close_BANG_(ch);
var state_47493__$1 = state_47493;
var statearr_47511_49572 = state_47493__$1;
(statearr_47511_49572[(2)] = inst_47483);

(statearr_47511_49572[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (9))){
var state_47493__$1 = state_47493;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47512_49575 = state_47493__$1;
(statearr_47512_49575[(1)] = (11));

} else {
var statearr_47513_49577 = state_47493__$1;
(statearr_47513_49577[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (5))){
var inst_47467 = (state_47493[(7)]);
var state_47493__$1 = state_47493;
var statearr_47514_49579 = state_47493__$1;
(statearr_47514_49579[(2)] = inst_47467);

(statearr_47514_49579[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (10))){
var inst_47488 = (state_47493[(2)]);
var state_47493__$1 = state_47493;
var statearr_47518_49583 = state_47493__$1;
(statearr_47518_49583[(2)] = inst_47488);

(statearr_47518_49583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47494 === (8))){
var inst_47467 = (state_47493[(7)]);
var inst_47477 = cljs.core.next(inst_47467);
var inst_47467__$1 = inst_47477;
var state_47493__$1 = (function (){var statearr_47519 = state_47493;
(statearr_47519[(7)] = inst_47467__$1);

return statearr_47519;
})();
var statearr_47520_49588 = state_47493__$1;
(statearr_47520_49588[(2)] = null);

(statearr_47520_49588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto__))
;
return ((function (switch__46368__auto__,c__46663__auto__){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_47521 = [null,null,null,null,null,null,null,null];
(statearr_47521[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_47521[(1)] = (1));

return statearr_47521;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_47493){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47493);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47522){if((e47522 instanceof Object)){
var ex__46372__auto__ = e47522;
var statearr_47523_49592 = state_47493;
(statearr_47523_49592[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47493);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47522;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49593 = state_47493;
state_47493 = G__49593;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_47493){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_47493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__))
})();
var state__46665__auto__ = (function (){var statearr_47524 = f__46664__auto__();
(statearr_47524[(6)] = c__46663__auto__);

return statearr_47524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__))
);

return c__46663__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4434__auto__.call(null,_));
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4431__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4434__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4431__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47550 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47550 = (function (ch,cs,meta47551){
this.ch = ch;
this.cs = cs;
this.meta47551 = meta47551;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async47550.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_47552,meta47551__$1){
var self__ = this;
var _47552__$1 = this;
return (new cljs.core.async.t_cljs$core$async47550(self__.ch,self__.cs,meta47551__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async47550.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_47552){
var self__ = this;
var _47552__$1 = this;
return self__.meta47551;
});})(cs))
;

cljs.core.async.t_cljs$core$async47550.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async47550.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async47550.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async47550.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47550.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47550.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async47550.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47551","meta47551",2067177932,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async47550.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47550.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47550";

cljs.core.async.t_cljs$core$async47550.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async47550");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47550.
 */
cljs.core.async.__GT_t_cljs$core$async47550 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async47550(ch__$1,cs__$1,meta47551){
return (new cljs.core.async.t_cljs$core$async47550(ch__$1,cs__$1,meta47551));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async47550(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__46663__auto___49628 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___49628,cs,m,dchan,dctr,done){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___49628,cs,m,dchan,dctr,done){
return (function (state_47706){
var state_val_47707 = (state_47706[(1)]);
if((state_val_47707 === (7))){
var inst_47700 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47710_49632 = state_47706__$1;
(statearr_47710_49632[(2)] = inst_47700);

(statearr_47710_49632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (20))){
var inst_47593 = (state_47706[(7)]);
var inst_47607 = cljs.core.first(inst_47593);
var inst_47608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47607,(0),null);
var inst_47610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47607,(1),null);
var state_47706__$1 = (function (){var statearr_47711 = state_47706;
(statearr_47711[(8)] = inst_47608);

return statearr_47711;
})();
if(cljs.core.truth_(inst_47610)){
var statearr_47713_49635 = state_47706__$1;
(statearr_47713_49635[(1)] = (22));

} else {
var statearr_47714_49636 = state_47706__$1;
(statearr_47714_49636[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (27))){
var inst_47639 = (state_47706[(9)]);
var inst_47641 = (state_47706[(10)]);
var inst_47646 = (state_47706[(11)]);
var inst_47562 = (state_47706[(12)]);
var inst_47646__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_47639,inst_47641);
var inst_47647 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47646__$1,inst_47562,done);
var state_47706__$1 = (function (){var statearr_47720 = state_47706;
(statearr_47720[(11)] = inst_47646__$1);

return statearr_47720;
})();
if(cljs.core.truth_(inst_47647)){
var statearr_47721_49639 = state_47706__$1;
(statearr_47721_49639[(1)] = (30));

} else {
var statearr_47723_49641 = state_47706__$1;
(statearr_47723_49641[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (1))){
var state_47706__$1 = state_47706;
var statearr_47725_49644 = state_47706__$1;
(statearr_47725_49644[(2)] = null);

(statearr_47725_49644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (24))){
var inst_47593 = (state_47706[(7)]);
var inst_47615 = (state_47706[(2)]);
var inst_47616 = cljs.core.next(inst_47593);
var inst_47571 = inst_47616;
var inst_47572 = null;
var inst_47573 = (0);
var inst_47574 = (0);
var state_47706__$1 = (function (){var statearr_47728 = state_47706;
(statearr_47728[(13)] = inst_47573);

(statearr_47728[(14)] = inst_47574);

(statearr_47728[(15)] = inst_47571);

(statearr_47728[(16)] = inst_47572);

(statearr_47728[(17)] = inst_47615);

return statearr_47728;
})();
var statearr_47729_49650 = state_47706__$1;
(statearr_47729_49650[(2)] = null);

(statearr_47729_49650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (39))){
var state_47706__$1 = state_47706;
var statearr_47736_49654 = state_47706__$1;
(statearr_47736_49654[(2)] = null);

(statearr_47736_49654[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (4))){
var inst_47562 = (state_47706[(12)]);
var inst_47562__$1 = (state_47706[(2)]);
var inst_47563 = (inst_47562__$1 == null);
var state_47706__$1 = (function (){var statearr_47738 = state_47706;
(statearr_47738[(12)] = inst_47562__$1);

return statearr_47738;
})();
if(cljs.core.truth_(inst_47563)){
var statearr_47739_49658 = state_47706__$1;
(statearr_47739_49658[(1)] = (5));

} else {
var statearr_47742_49659 = state_47706__$1;
(statearr_47742_49659[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (15))){
var inst_47573 = (state_47706[(13)]);
var inst_47574 = (state_47706[(14)]);
var inst_47571 = (state_47706[(15)]);
var inst_47572 = (state_47706[(16)]);
var inst_47589 = (state_47706[(2)]);
var inst_47590 = (inst_47574 + (1));
var tmp47730 = inst_47573;
var tmp47731 = inst_47571;
var tmp47732 = inst_47572;
var inst_47571__$1 = tmp47731;
var inst_47572__$1 = tmp47732;
var inst_47573__$1 = tmp47730;
var inst_47574__$1 = inst_47590;
var state_47706__$1 = (function (){var statearr_47744 = state_47706;
(statearr_47744[(18)] = inst_47589);

(statearr_47744[(13)] = inst_47573__$1);

(statearr_47744[(14)] = inst_47574__$1);

(statearr_47744[(15)] = inst_47571__$1);

(statearr_47744[(16)] = inst_47572__$1);

return statearr_47744;
})();
var statearr_47745_49660 = state_47706__$1;
(statearr_47745_49660[(2)] = null);

(statearr_47745_49660[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (21))){
var inst_47619 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47749_49661 = state_47706__$1;
(statearr_47749_49661[(2)] = inst_47619);

(statearr_47749_49661[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (31))){
var inst_47646 = (state_47706[(11)]);
var inst_47650 = done(null);
var inst_47651 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47646);
var state_47706__$1 = (function (){var statearr_47750 = state_47706;
(statearr_47750[(19)] = inst_47650);

return statearr_47750;
})();
var statearr_47751_49667 = state_47706__$1;
(statearr_47751_49667[(2)] = inst_47651);

(statearr_47751_49667[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (32))){
var inst_47639 = (state_47706[(9)]);
var inst_47641 = (state_47706[(10)]);
var inst_47640 = (state_47706[(20)]);
var inst_47638 = (state_47706[(21)]);
var inst_47653 = (state_47706[(2)]);
var inst_47654 = (inst_47641 + (1));
var tmp47746 = inst_47639;
var tmp47747 = inst_47640;
var tmp47748 = inst_47638;
var inst_47638__$1 = tmp47748;
var inst_47639__$1 = tmp47746;
var inst_47640__$1 = tmp47747;
var inst_47641__$1 = inst_47654;
var state_47706__$1 = (function (){var statearr_47752 = state_47706;
(statearr_47752[(9)] = inst_47639__$1);

(statearr_47752[(10)] = inst_47641__$1);

(statearr_47752[(20)] = inst_47640__$1);

(statearr_47752[(21)] = inst_47638__$1);

(statearr_47752[(22)] = inst_47653);

return statearr_47752;
})();
var statearr_47753_49672 = state_47706__$1;
(statearr_47753_49672[(2)] = null);

(statearr_47753_49672[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (40))){
var inst_47672 = (state_47706[(23)]);
var inst_47676 = done(null);
var inst_47677 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47672);
var state_47706__$1 = (function (){var statearr_47757 = state_47706;
(statearr_47757[(24)] = inst_47676);

return statearr_47757;
})();
var statearr_47758_49678 = state_47706__$1;
(statearr_47758_49678[(2)] = inst_47677);

(statearr_47758_49678[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (33))){
var inst_47659 = (state_47706[(25)]);
var inst_47665 = cljs.core.chunked_seq_QMARK_(inst_47659);
var state_47706__$1 = state_47706;
if(inst_47665){
var statearr_47763_49680 = state_47706__$1;
(statearr_47763_49680[(1)] = (36));

} else {
var statearr_47768_49681 = state_47706__$1;
(statearr_47768_49681[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (13))){
var inst_47583 = (state_47706[(26)]);
var inst_47586 = cljs.core.async.close_BANG_(inst_47583);
var state_47706__$1 = state_47706;
var statearr_47769_49682 = state_47706__$1;
(statearr_47769_49682[(2)] = inst_47586);

(statearr_47769_49682[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (22))){
var inst_47608 = (state_47706[(8)]);
var inst_47612 = cljs.core.async.close_BANG_(inst_47608);
var state_47706__$1 = state_47706;
var statearr_47774_49684 = state_47706__$1;
(statearr_47774_49684[(2)] = inst_47612);

(statearr_47774_49684[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (36))){
var inst_47659 = (state_47706[(25)]);
var inst_47667 = cljs.core.chunk_first(inst_47659);
var inst_47668 = cljs.core.chunk_rest(inst_47659);
var inst_47669 = cljs.core.count(inst_47667);
var inst_47638 = inst_47668;
var inst_47639 = inst_47667;
var inst_47640 = inst_47669;
var inst_47641 = (0);
var state_47706__$1 = (function (){var statearr_47779 = state_47706;
(statearr_47779[(9)] = inst_47639);

(statearr_47779[(10)] = inst_47641);

(statearr_47779[(20)] = inst_47640);

(statearr_47779[(21)] = inst_47638);

return statearr_47779;
})();
var statearr_47780_49692 = state_47706__$1;
(statearr_47780_49692[(2)] = null);

(statearr_47780_49692[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (41))){
var inst_47659 = (state_47706[(25)]);
var inst_47679 = (state_47706[(2)]);
var inst_47680 = cljs.core.next(inst_47659);
var inst_47638 = inst_47680;
var inst_47639 = null;
var inst_47640 = (0);
var inst_47641 = (0);
var state_47706__$1 = (function (){var statearr_47781 = state_47706;
(statearr_47781[(27)] = inst_47679);

(statearr_47781[(9)] = inst_47639);

(statearr_47781[(10)] = inst_47641);

(statearr_47781[(20)] = inst_47640);

(statearr_47781[(21)] = inst_47638);

return statearr_47781;
})();
var statearr_47782_49695 = state_47706__$1;
(statearr_47782_49695[(2)] = null);

(statearr_47782_49695[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (43))){
var state_47706__$1 = state_47706;
var statearr_47783_49696 = state_47706__$1;
(statearr_47783_49696[(2)] = null);

(statearr_47783_49696[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (29))){
var inst_47688 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47790_49698 = state_47706__$1;
(statearr_47790_49698[(2)] = inst_47688);

(statearr_47790_49698[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (44))){
var inst_47697 = (state_47706[(2)]);
var state_47706__$1 = (function (){var statearr_47794 = state_47706;
(statearr_47794[(28)] = inst_47697);

return statearr_47794;
})();
var statearr_47796_49699 = state_47706__$1;
(statearr_47796_49699[(2)] = null);

(statearr_47796_49699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (6))){
var inst_47630 = (state_47706[(29)]);
var inst_47629 = cljs.core.deref(cs);
var inst_47630__$1 = cljs.core.keys(inst_47629);
var inst_47631 = cljs.core.count(inst_47630__$1);
var inst_47632 = cljs.core.reset_BANG_(dctr,inst_47631);
var inst_47637 = cljs.core.seq(inst_47630__$1);
var inst_47638 = inst_47637;
var inst_47639 = null;
var inst_47640 = (0);
var inst_47641 = (0);
var state_47706__$1 = (function (){var statearr_47797 = state_47706;
(statearr_47797[(9)] = inst_47639);

(statearr_47797[(10)] = inst_47641);

(statearr_47797[(29)] = inst_47630__$1);

(statearr_47797[(20)] = inst_47640);

(statearr_47797[(21)] = inst_47638);

(statearr_47797[(30)] = inst_47632);

return statearr_47797;
})();
var statearr_47802_49705 = state_47706__$1;
(statearr_47802_49705[(2)] = null);

(statearr_47802_49705[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (28))){
var inst_47659 = (state_47706[(25)]);
var inst_47638 = (state_47706[(21)]);
var inst_47659__$1 = cljs.core.seq(inst_47638);
var state_47706__$1 = (function (){var statearr_47803 = state_47706;
(statearr_47803[(25)] = inst_47659__$1);

return statearr_47803;
})();
if(inst_47659__$1){
var statearr_47807_49706 = state_47706__$1;
(statearr_47807_49706[(1)] = (33));

} else {
var statearr_47810_49707 = state_47706__$1;
(statearr_47810_49707[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (25))){
var inst_47641 = (state_47706[(10)]);
var inst_47640 = (state_47706[(20)]);
var inst_47643 = (inst_47641 < inst_47640);
var inst_47644 = inst_47643;
var state_47706__$1 = state_47706;
if(cljs.core.truth_(inst_47644)){
var statearr_47811_49715 = state_47706__$1;
(statearr_47811_49715[(1)] = (27));

} else {
var statearr_47812_49716 = state_47706__$1;
(statearr_47812_49716[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (34))){
var state_47706__$1 = state_47706;
var statearr_47816_49717 = state_47706__$1;
(statearr_47816_49717[(2)] = null);

(statearr_47816_49717[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (17))){
var state_47706__$1 = state_47706;
var statearr_47818_49718 = state_47706__$1;
(statearr_47818_49718[(2)] = null);

(statearr_47818_49718[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (3))){
var inst_47702 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47706__$1,inst_47702);
} else {
if((state_val_47707 === (12))){
var inst_47624 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47819_49719 = state_47706__$1;
(statearr_47819_49719[(2)] = inst_47624);

(statearr_47819_49719[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (2))){
var state_47706__$1 = state_47706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47706__$1,(4),ch);
} else {
if((state_val_47707 === (23))){
var state_47706__$1 = state_47706;
var statearr_47822_49720 = state_47706__$1;
(statearr_47822_49720[(2)] = null);

(statearr_47822_49720[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (35))){
var inst_47686 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47825_49721 = state_47706__$1;
(statearr_47825_49721[(2)] = inst_47686);

(statearr_47825_49721[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (19))){
var inst_47593 = (state_47706[(7)]);
var inst_47597 = cljs.core.chunk_first(inst_47593);
var inst_47598 = cljs.core.chunk_rest(inst_47593);
var inst_47599 = cljs.core.count(inst_47597);
var inst_47571 = inst_47598;
var inst_47572 = inst_47597;
var inst_47573 = inst_47599;
var inst_47574 = (0);
var state_47706__$1 = (function (){var statearr_47826 = state_47706;
(statearr_47826[(13)] = inst_47573);

(statearr_47826[(14)] = inst_47574);

(statearr_47826[(15)] = inst_47571);

(statearr_47826[(16)] = inst_47572);

return statearr_47826;
})();
var statearr_47827_49725 = state_47706__$1;
(statearr_47827_49725[(2)] = null);

(statearr_47827_49725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (11))){
var inst_47571 = (state_47706[(15)]);
var inst_47593 = (state_47706[(7)]);
var inst_47593__$1 = cljs.core.seq(inst_47571);
var state_47706__$1 = (function (){var statearr_47828 = state_47706;
(statearr_47828[(7)] = inst_47593__$1);

return statearr_47828;
})();
if(inst_47593__$1){
var statearr_47829_49727 = state_47706__$1;
(statearr_47829_49727[(1)] = (16));

} else {
var statearr_47830_49728 = state_47706__$1;
(statearr_47830_49728[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (9))){
var inst_47626 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47831_49729 = state_47706__$1;
(statearr_47831_49729[(2)] = inst_47626);

(statearr_47831_49729[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (5))){
var inst_47569 = cljs.core.deref(cs);
var inst_47570 = cljs.core.seq(inst_47569);
var inst_47571 = inst_47570;
var inst_47572 = null;
var inst_47573 = (0);
var inst_47574 = (0);
var state_47706__$1 = (function (){var statearr_47832 = state_47706;
(statearr_47832[(13)] = inst_47573);

(statearr_47832[(14)] = inst_47574);

(statearr_47832[(15)] = inst_47571);

(statearr_47832[(16)] = inst_47572);

return statearr_47832;
})();
var statearr_47835_49741 = state_47706__$1;
(statearr_47835_49741[(2)] = null);

(statearr_47835_49741[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (14))){
var state_47706__$1 = state_47706;
var statearr_47840_49745 = state_47706__$1;
(statearr_47840_49745[(2)] = null);

(statearr_47840_49745[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (45))){
var inst_47694 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47842_49748 = state_47706__$1;
(statearr_47842_49748[(2)] = inst_47694);

(statearr_47842_49748[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (26))){
var inst_47630 = (state_47706[(29)]);
var inst_47690 = (state_47706[(2)]);
var inst_47691 = cljs.core.seq(inst_47630);
var state_47706__$1 = (function (){var statearr_47843 = state_47706;
(statearr_47843[(31)] = inst_47690);

return statearr_47843;
})();
if(inst_47691){
var statearr_47844_49750 = state_47706__$1;
(statearr_47844_49750[(1)] = (42));

} else {
var statearr_47845_49751 = state_47706__$1;
(statearr_47845_49751[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (16))){
var inst_47593 = (state_47706[(7)]);
var inst_47595 = cljs.core.chunked_seq_QMARK_(inst_47593);
var state_47706__$1 = state_47706;
if(inst_47595){
var statearr_47846_49756 = state_47706__$1;
(statearr_47846_49756[(1)] = (19));

} else {
var statearr_47847_49760 = state_47706__$1;
(statearr_47847_49760[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (38))){
var inst_47683 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47848_49761 = state_47706__$1;
(statearr_47848_49761[(2)] = inst_47683);

(statearr_47848_49761[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (30))){
var state_47706__$1 = state_47706;
var statearr_47849_49762 = state_47706__$1;
(statearr_47849_49762[(2)] = null);

(statearr_47849_49762[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (10))){
var inst_47574 = (state_47706[(14)]);
var inst_47572 = (state_47706[(16)]);
var inst_47582 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_47572,inst_47574);
var inst_47583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47582,(0),null);
var inst_47584 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47582,(1),null);
var state_47706__$1 = (function (){var statearr_47855 = state_47706;
(statearr_47855[(26)] = inst_47583);

return statearr_47855;
})();
if(cljs.core.truth_(inst_47584)){
var statearr_47856_49771 = state_47706__$1;
(statearr_47856_49771[(1)] = (13));

} else {
var statearr_47858_49772 = state_47706__$1;
(statearr_47858_49772[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (18))){
var inst_47622 = (state_47706[(2)]);
var state_47706__$1 = state_47706;
var statearr_47859_49777 = state_47706__$1;
(statearr_47859_49777[(2)] = inst_47622);

(statearr_47859_49777[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (42))){
var state_47706__$1 = state_47706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47706__$1,(45),dchan);
} else {
if((state_val_47707 === (37))){
var inst_47659 = (state_47706[(25)]);
var inst_47672 = (state_47706[(23)]);
var inst_47562 = (state_47706[(12)]);
var inst_47672__$1 = cljs.core.first(inst_47659);
var inst_47673 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47672__$1,inst_47562,done);
var state_47706__$1 = (function (){var statearr_47867 = state_47706;
(statearr_47867[(23)] = inst_47672__$1);

return statearr_47867;
})();
if(cljs.core.truth_(inst_47673)){
var statearr_47869_49779 = state_47706__$1;
(statearr_47869_49779[(1)] = (39));

} else {
var statearr_47870_49780 = state_47706__$1;
(statearr_47870_49780[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47707 === (8))){
var inst_47573 = (state_47706[(13)]);
var inst_47574 = (state_47706[(14)]);
var inst_47576 = (inst_47574 < inst_47573);
var inst_47577 = inst_47576;
var state_47706__$1 = state_47706;
if(cljs.core.truth_(inst_47577)){
var statearr_47877_49781 = state_47706__$1;
(statearr_47877_49781[(1)] = (10));

} else {
var statearr_47880_49782 = state_47706__$1;
(statearr_47880_49782[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___49628,cs,m,dchan,dctr,done))
;
return ((function (switch__46368__auto__,c__46663__auto___49628,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__46369__auto__ = null;
var cljs$core$async$mult_$_state_machine__46369__auto____0 = (function (){
var statearr_47887 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47887[(0)] = cljs$core$async$mult_$_state_machine__46369__auto__);

(statearr_47887[(1)] = (1));

return statearr_47887;
});
var cljs$core$async$mult_$_state_machine__46369__auto____1 = (function (state_47706){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_47706);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e47888){if((e47888 instanceof Object)){
var ex__46372__auto__ = e47888;
var statearr_47889_49793 = state_47706;
(statearr_47889_49793[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47706);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47888;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49794 = state_47706;
state_47706 = G__49794;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__46369__auto__ = function(state_47706){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__46369__auto____1.call(this,state_47706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__46369__auto____0;
cljs$core$async$mult_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__46369__auto____1;
return cljs$core$async$mult_$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___49628,cs,m,dchan,dctr,done))
})();
var state__46665__auto__ = (function (){var statearr_47890 = f__46664__auto__();
(statearr_47890[(6)] = c__46663__auto___49628);

return statearr_47890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___49628,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__47893 = arguments.length;
switch (G__47893) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4434__auto__.call(null,m,state_map));
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4431__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4434__auto__.call(null,m,mode));
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4431__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___49813 = arguments.length;
var i__4731__auto___49814 = (0);
while(true){
if((i__4731__auto___49814 < len__4730__auto___49813)){
args__4736__auto__.push((arguments[i__4731__auto___49814]));

var G__49820 = (i__4731__auto___49814 + (1));
i__4731__auto___49814 = G__49820;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__47920){
var map__47921 = p__47920;
var map__47921__$1 = (((((!((map__47921 == null))))?(((((map__47921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47921.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47921):map__47921);
var opts = map__47921__$1;
var statearr_47924_49826 = state;
(statearr_47924_49826[(1)] = cont_block);


var temp__5818__auto__ = cljs.core.async.do_alts(((function (map__47921,map__47921__$1,opts){
return (function (val){
var statearr_47931_49827 = state;
(statearr_47931_49827[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__47921,map__47921__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5818__auto__)){
var cb = temp__5818__auto__;
var statearr_47936_49829 = state;
(statearr_47936_49829[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq47911){
var G__47912 = cljs.core.first(seq47911);
var seq47911__$1 = cljs.core.next(seq47911);
var G__47913 = cljs.core.first(seq47911__$1);
var seq47911__$2 = cljs.core.next(seq47911__$1);
var G__47914 = cljs.core.first(seq47911__$2);
var seq47911__$3 = cljs.core.next(seq47911__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47912,G__47913,G__47914,seq47911__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47942 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47942 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta47943){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta47943 = meta47943;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_47944,meta47943__$1){
var self__ = this;
var _47944__$1 = this;
return (new cljs.core.async.t_cljs$core$async47942(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta47943__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_47944){
var self__ = this;
var _47944__$1 = this;
return self__.meta47943;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta47943","meta47943",-1512538473,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async47942.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async47942.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47942";

cljs.core.async.t_cljs$core$async47942.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async47942");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47942.
 */
cljs.core.async.__GT_t_cljs$core$async47942 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async47942(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47943){
return (new cljs.core.async.t_cljs$core$async47942(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47943));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async47942(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46663__auto___49909 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___49909,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___49909,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_48053){
var state_val_48054 = (state_48053[(1)]);
if((state_val_48054 === (7))){
var inst_47967 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
var statearr_48059_49921 = state_48053__$1;
(statearr_48059_49921[(2)] = inst_47967);

(statearr_48059_49921[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (20))){
var inst_47980 = (state_48053[(7)]);
var state_48053__$1 = state_48053;
var statearr_48060_49929 = state_48053__$1;
(statearr_48060_49929[(2)] = inst_47980);

(statearr_48060_49929[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (27))){
var state_48053__$1 = state_48053;
var statearr_48063_49931 = state_48053__$1;
(statearr_48063_49931[(2)] = null);

(statearr_48063_49931[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (1))){
var inst_47952 = (state_48053[(8)]);
var inst_47952__$1 = calc_state();
var inst_47956 = (inst_47952__$1 == null);
var inst_47957 = cljs.core.not(inst_47956);
var state_48053__$1 = (function (){var statearr_48064 = state_48053;
(statearr_48064[(8)] = inst_47952__$1);

return statearr_48064;
})();
if(inst_47957){
var statearr_48065_49933 = state_48053__$1;
(statearr_48065_49933[(1)] = (2));

} else {
var statearr_48066_49937 = state_48053__$1;
(statearr_48066_49937[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (24))){
var inst_48013 = (state_48053[(9)]);
var inst_48027 = (state_48053[(10)]);
var inst_48004 = (state_48053[(11)]);
var inst_48027__$1 = (inst_48004.cljs$core$IFn$_invoke$arity$1 ? inst_48004.cljs$core$IFn$_invoke$arity$1(inst_48013) : inst_48004.call(null,inst_48013));
var state_48053__$1 = (function (){var statearr_48067 = state_48053;
(statearr_48067[(10)] = inst_48027__$1);

return statearr_48067;
})();
if(cljs.core.truth_(inst_48027__$1)){
var statearr_48068_49945 = state_48053__$1;
(statearr_48068_49945[(1)] = (29));

} else {
var statearr_48069_49946 = state_48053__$1;
(statearr_48069_49946[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (4))){
var inst_47970 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
if(cljs.core.truth_(inst_47970)){
var statearr_48070_49950 = state_48053__$1;
(statearr_48070_49950[(1)] = (8));

} else {
var statearr_48071_49951 = state_48053__$1;
(statearr_48071_49951[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (15))){
var inst_47998 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
if(cljs.core.truth_(inst_47998)){
var statearr_48072_49958 = state_48053__$1;
(statearr_48072_49958[(1)] = (19));

} else {
var statearr_48073_49959 = state_48053__$1;
(statearr_48073_49959[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (21))){
var inst_48003 = (state_48053[(12)]);
var inst_48003__$1 = (state_48053[(2)]);
var inst_48004 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48003__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48005 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48003__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48003__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_48053__$1 = (function (){var statearr_48074 = state_48053;
(statearr_48074[(13)] = inst_48005);

(statearr_48074[(12)] = inst_48003__$1);

(statearr_48074[(11)] = inst_48004);

return statearr_48074;
})();
return cljs.core.async.ioc_alts_BANG_(state_48053__$1,(22),inst_48006);
} else {
if((state_val_48054 === (31))){
var inst_48035 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
if(cljs.core.truth_(inst_48035)){
var statearr_48075_49963 = state_48053__$1;
(statearr_48075_49963[(1)] = (32));

} else {
var statearr_48076_49964 = state_48053__$1;
(statearr_48076_49964[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (32))){
var inst_48012 = (state_48053[(14)]);
var state_48053__$1 = state_48053;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48053__$1,(35),out,inst_48012);
} else {
if((state_val_48054 === (33))){
var inst_48003 = (state_48053[(12)]);
var inst_47980 = inst_48003;
var state_48053__$1 = (function (){var statearr_48077 = state_48053;
(statearr_48077[(7)] = inst_47980);

return statearr_48077;
})();
var statearr_48078_49971 = state_48053__$1;
(statearr_48078_49971[(2)] = null);

(statearr_48078_49971[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (13))){
var inst_47980 = (state_48053[(7)]);
var inst_47987 = inst_47980.cljs$lang$protocol_mask$partition0$;
var inst_47988 = (inst_47987 & (64));
var inst_47989 = inst_47980.cljs$core$ISeq$;
var inst_47990 = (cljs.core.PROTOCOL_SENTINEL === inst_47989);
var inst_47991 = ((inst_47988) || (inst_47990));
var state_48053__$1 = state_48053;
if(cljs.core.truth_(inst_47991)){
var statearr_48079_49972 = state_48053__$1;
(statearr_48079_49972[(1)] = (16));

} else {
var statearr_48080_49973 = state_48053__$1;
(statearr_48080_49973[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (22))){
var inst_48012 = (state_48053[(14)]);
var inst_48013 = (state_48053[(9)]);
var inst_48011 = (state_48053[(2)]);
var inst_48012__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48011,(0),null);
var inst_48013__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48011,(1),null);
var inst_48014 = (inst_48012__$1 == null);
var inst_48015 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48013__$1,change);
var inst_48016 = ((inst_48014) || (inst_48015));
var state_48053__$1 = (function (){var statearr_48081 = state_48053;
(statearr_48081[(14)] = inst_48012__$1);

(statearr_48081[(9)] = inst_48013__$1);

return statearr_48081;
})();
if(cljs.core.truth_(inst_48016)){
var statearr_48082_49974 = state_48053__$1;
(statearr_48082_49974[(1)] = (23));

} else {
var statearr_48083_49975 = state_48053__$1;
(statearr_48083_49975[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (36))){
var inst_48003 = (state_48053[(12)]);
var inst_47980 = inst_48003;
var state_48053__$1 = (function (){var statearr_48084 = state_48053;
(statearr_48084[(7)] = inst_47980);

return statearr_48084;
})();
var statearr_48085_49976 = state_48053__$1;
(statearr_48085_49976[(2)] = null);

(statearr_48085_49976[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (29))){
var inst_48027 = (state_48053[(10)]);
var state_48053__$1 = state_48053;
var statearr_48086_49987 = state_48053__$1;
(statearr_48086_49987[(2)] = inst_48027);

(statearr_48086_49987[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (6))){
var state_48053__$1 = state_48053;
var statearr_48087_49989 = state_48053__$1;
(statearr_48087_49989[(2)] = false);

(statearr_48087_49989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (28))){
var inst_48023 = (state_48053[(2)]);
var inst_48024 = calc_state();
var inst_47980 = inst_48024;
var state_48053__$1 = (function (){var statearr_48089 = state_48053;
(statearr_48089[(15)] = inst_48023);

(statearr_48089[(7)] = inst_47980);

return statearr_48089;
})();
var statearr_48093_49992 = state_48053__$1;
(statearr_48093_49992[(2)] = null);

(statearr_48093_49992[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (25))){
var inst_48049 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
var statearr_48097_49995 = state_48053__$1;
(statearr_48097_49995[(2)] = inst_48049);

(statearr_48097_49995[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (34))){
var inst_48047 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
var statearr_48098_49997 = state_48053__$1;
(statearr_48098_49997[(2)] = inst_48047);

(statearr_48098_49997[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (17))){
var state_48053__$1 = state_48053;
var statearr_48099_50002 = state_48053__$1;
(statearr_48099_50002[(2)] = false);

(statearr_48099_50002[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (3))){
var state_48053__$1 = state_48053;
var statearr_48100_50005 = state_48053__$1;
(statearr_48100_50005[(2)] = false);

(statearr_48100_50005[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (12))){
var inst_48051 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48053__$1,inst_48051);
} else {
if((state_val_48054 === (2))){
var inst_47952 = (state_48053[(8)]);
var inst_47959 = inst_47952.cljs$lang$protocol_mask$partition0$;
var inst_47960 = (inst_47959 & (64));
var inst_47961 = inst_47952.cljs$core$ISeq$;
var inst_47962 = (cljs.core.PROTOCOL_SENTINEL === inst_47961);
var inst_47963 = ((inst_47960) || (inst_47962));
var state_48053__$1 = state_48053;
if(cljs.core.truth_(inst_47963)){
var statearr_48101_50017 = state_48053__$1;
(statearr_48101_50017[(1)] = (5));

} else {
var statearr_48102_50018 = state_48053__$1;
(statearr_48102_50018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (23))){
var inst_48012 = (state_48053[(14)]);
var inst_48018 = (inst_48012 == null);
var state_48053__$1 = state_48053;
if(cljs.core.truth_(inst_48018)){
var statearr_48103_50025 = state_48053__$1;
(statearr_48103_50025[(1)] = (26));

} else {
var statearr_48104_50026 = state_48053__$1;
(statearr_48104_50026[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (35))){
var inst_48038 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
if(cljs.core.truth_(inst_48038)){
var statearr_48105_50028 = state_48053__$1;
(statearr_48105_50028[(1)] = (36));

} else {
var statearr_48110_50029 = state_48053__$1;
(statearr_48110_50029[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (19))){
var inst_47980 = (state_48053[(7)]);
var inst_48000 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_47980);
var state_48053__$1 = state_48053;
var statearr_48111_50031 = state_48053__$1;
(statearr_48111_50031[(2)] = inst_48000);

(statearr_48111_50031[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (11))){
var inst_47980 = (state_48053[(7)]);
var inst_47984 = (inst_47980 == null);
var inst_47985 = cljs.core.not(inst_47984);
var state_48053__$1 = state_48053;
if(inst_47985){
var statearr_48112_50034 = state_48053__$1;
(statearr_48112_50034[(1)] = (13));

} else {
var statearr_48113_50037 = state_48053__$1;
(statearr_48113_50037[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (9))){
var inst_47952 = (state_48053[(8)]);
var state_48053__$1 = state_48053;
var statearr_48114_50039 = state_48053__$1;
(statearr_48114_50039[(2)] = inst_47952);

(statearr_48114_50039[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (5))){
var state_48053__$1 = state_48053;
var statearr_48115_50041 = state_48053__$1;
(statearr_48115_50041[(2)] = true);

(statearr_48115_50041[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (14))){
var state_48053__$1 = state_48053;
var statearr_48116_50044 = state_48053__$1;
(statearr_48116_50044[(2)] = false);

(statearr_48116_50044[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (26))){
var inst_48013 = (state_48053[(9)]);
var inst_48020 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_48013);
var state_48053__$1 = state_48053;
var statearr_48117_50045 = state_48053__$1;
(statearr_48117_50045[(2)] = inst_48020);

(statearr_48117_50045[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (16))){
var state_48053__$1 = state_48053;
var statearr_48118_50049 = state_48053__$1;
(statearr_48118_50049[(2)] = true);

(statearr_48118_50049[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (38))){
var inst_48043 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
var statearr_48119_50052 = state_48053__$1;
(statearr_48119_50052[(2)] = inst_48043);

(statearr_48119_50052[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (30))){
var inst_48013 = (state_48053[(9)]);
var inst_48005 = (state_48053[(13)]);
var inst_48004 = (state_48053[(11)]);
var inst_48030 = cljs.core.empty_QMARK_(inst_48004);
var inst_48031 = (inst_48005.cljs$core$IFn$_invoke$arity$1 ? inst_48005.cljs$core$IFn$_invoke$arity$1(inst_48013) : inst_48005.call(null,inst_48013));
var inst_48032 = cljs.core.not(inst_48031);
var inst_48033 = ((inst_48030) && (inst_48032));
var state_48053__$1 = state_48053;
var statearr_48120_50062 = state_48053__$1;
(statearr_48120_50062[(2)] = inst_48033);

(statearr_48120_50062[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (10))){
var inst_47952 = (state_48053[(8)]);
var inst_47976 = (state_48053[(2)]);
var inst_47977 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47976,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_47978 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47976,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_47979 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47976,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_47980 = inst_47952;
var state_48053__$1 = (function (){var statearr_48122 = state_48053;
(statearr_48122[(16)] = inst_47979);

(statearr_48122[(7)] = inst_47980);

(statearr_48122[(17)] = inst_47978);

(statearr_48122[(18)] = inst_47977);

return statearr_48122;
})();
var statearr_48123_50071 = state_48053__$1;
(statearr_48123_50071[(2)] = null);

(statearr_48123_50071[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (18))){
var inst_47995 = (state_48053[(2)]);
var state_48053__$1 = state_48053;
var statearr_48124_50073 = state_48053__$1;
(statearr_48124_50073[(2)] = inst_47995);

(statearr_48124_50073[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (37))){
var state_48053__$1 = state_48053;
var statearr_48125_50076 = state_48053__$1;
(statearr_48125_50076[(2)] = null);

(statearr_48125_50076[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48054 === (8))){
var inst_47952 = (state_48053[(8)]);
var inst_47973 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_47952);
var state_48053__$1 = state_48053;
var statearr_48126_50078 = state_48053__$1;
(statearr_48126_50078[(2)] = inst_47973);

(statearr_48126_50078[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___49909,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__46368__auto__,c__46663__auto___49909,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__46369__auto__ = null;
var cljs$core$async$mix_$_state_machine__46369__auto____0 = (function (){
var statearr_48127 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48127[(0)] = cljs$core$async$mix_$_state_machine__46369__auto__);

(statearr_48127[(1)] = (1));

return statearr_48127;
});
var cljs$core$async$mix_$_state_machine__46369__auto____1 = (function (state_48053){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48053);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48128){if((e48128 instanceof Object)){
var ex__46372__auto__ = e48128;
var statearr_48129_50082 = state_48053;
(statearr_48129_50082[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48053);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48128;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50087 = state_48053;
state_48053 = G__50087;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__46369__auto__ = function(state_48053){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__46369__auto____1.call(this,state_48053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__46369__auto____0;
cljs$core$async$mix_$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__46369__auto____1;
return cljs$core$async$mix_$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___49909,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__46665__auto__ = (function (){var statearr_48130 = f__46664__auto__();
(statearr_48130[(6)] = c__46663__auto___49909);

return statearr_48130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___49909,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4434__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4431__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4434__auto__.call(null,p,v,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4431__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__48136 = arguments.length;
switch (G__48136) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4434__auto__.call(null,p));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4431__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4434__auto__.call(null,p,v));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4431__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__48143 = arguments.length;
switch (G__48143) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4131__auto__,mults){
return (function (p1__48141_SHARP_){
if(cljs.core.truth_((p1__48141_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__48141_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__48141_SHARP_.call(null,topic)))){
return p1__48141_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__48141_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48148 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48148 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta48149){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta48149 = meta48149;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_48150,meta48149__$1){
var self__ = this;
var _48150__$1 = this;
return (new cljs.core.async.t_cljs$core$async48148(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta48149__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_48150){
var self__ = this;
var _48150__$1 = this;
return self__.meta48149;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5818__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5818__auto__)){
var m = temp__5818__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48148.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48148.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta48149","meta48149",-1303029755,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async48148.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48148.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48148";

cljs.core.async.t_cljs$core$async48148.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async48148");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48148.
 */
cljs.core.async.__GT_t_cljs$core$async48148 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async48148(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48149){
return (new cljs.core.async.t_cljs$core$async48148(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48149));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async48148(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46663__auto___50149 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50149,mults,ensure_mult,p){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50149,mults,ensure_mult,p){
return (function (state_48236){
var state_val_48237 = (state_48236[(1)]);
if((state_val_48237 === (7))){
var inst_48232 = (state_48236[(2)]);
var state_48236__$1 = state_48236;
var statearr_48238_50158 = state_48236__$1;
(statearr_48238_50158[(2)] = inst_48232);

(statearr_48238_50158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (20))){
var state_48236__$1 = state_48236;
var statearr_48239_50160 = state_48236__$1;
(statearr_48239_50160[(2)] = null);

(statearr_48239_50160[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (1))){
var state_48236__$1 = state_48236;
var statearr_48240_50167 = state_48236__$1;
(statearr_48240_50167[(2)] = null);

(statearr_48240_50167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (24))){
var inst_48215 = (state_48236[(7)]);
var inst_48224 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_48215);
var state_48236__$1 = state_48236;
var statearr_48241_50175 = state_48236__$1;
(statearr_48241_50175[(2)] = inst_48224);

(statearr_48241_50175[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (4))){
var inst_48163 = (state_48236[(8)]);
var inst_48163__$1 = (state_48236[(2)]);
var inst_48164 = (inst_48163__$1 == null);
var state_48236__$1 = (function (){var statearr_48242 = state_48236;
(statearr_48242[(8)] = inst_48163__$1);

return statearr_48242;
})();
if(cljs.core.truth_(inst_48164)){
var statearr_48243_50189 = state_48236__$1;
(statearr_48243_50189[(1)] = (5));

} else {
var statearr_48244_50191 = state_48236__$1;
(statearr_48244_50191[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (15))){
var inst_48207 = (state_48236[(2)]);
var state_48236__$1 = state_48236;
var statearr_48245_50192 = state_48236__$1;
(statearr_48245_50192[(2)] = inst_48207);

(statearr_48245_50192[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (21))){
var inst_48229 = (state_48236[(2)]);
var state_48236__$1 = (function (){var statearr_48250 = state_48236;
(statearr_48250[(9)] = inst_48229);

return statearr_48250;
})();
var statearr_48251_50193 = state_48236__$1;
(statearr_48251_50193[(2)] = null);

(statearr_48251_50193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (13))){
var inst_48188 = (state_48236[(10)]);
var inst_48190 = cljs.core.chunked_seq_QMARK_(inst_48188);
var state_48236__$1 = state_48236;
if(inst_48190){
var statearr_48256_50198 = state_48236__$1;
(statearr_48256_50198[(1)] = (16));

} else {
var statearr_48258_50201 = state_48236__$1;
(statearr_48258_50201[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (22))){
var inst_48221 = (state_48236[(2)]);
var state_48236__$1 = state_48236;
if(cljs.core.truth_(inst_48221)){
var statearr_48260_50206 = state_48236__$1;
(statearr_48260_50206[(1)] = (23));

} else {
var statearr_48261_50207 = state_48236__$1;
(statearr_48261_50207[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (6))){
var inst_48217 = (state_48236[(11)]);
var inst_48163 = (state_48236[(8)]);
var inst_48215 = (state_48236[(7)]);
var inst_48215__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_48163) : topic_fn.call(null,inst_48163));
var inst_48216 = cljs.core.deref(mults);
var inst_48217__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48216,inst_48215__$1);
var state_48236__$1 = (function (){var statearr_48266 = state_48236;
(statearr_48266[(11)] = inst_48217__$1);

(statearr_48266[(7)] = inst_48215__$1);

return statearr_48266;
})();
if(cljs.core.truth_(inst_48217__$1)){
var statearr_48267_50217 = state_48236__$1;
(statearr_48267_50217[(1)] = (19));

} else {
var statearr_48268_50218 = state_48236__$1;
(statearr_48268_50218[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (25))){
var inst_48226 = (state_48236[(2)]);
var state_48236__$1 = state_48236;
var statearr_48269_50223 = state_48236__$1;
(statearr_48269_50223[(2)] = inst_48226);

(statearr_48269_50223[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (17))){
var inst_48188 = (state_48236[(10)]);
var inst_48198 = cljs.core.first(inst_48188);
var inst_48199 = cljs.core.async.muxch_STAR_(inst_48198);
var inst_48200 = cljs.core.async.close_BANG_(inst_48199);
var inst_48201 = cljs.core.next(inst_48188);
var inst_48174 = inst_48201;
var inst_48175 = null;
var inst_48176 = (0);
var inst_48177 = (0);
var state_48236__$1 = (function (){var statearr_48272 = state_48236;
(statearr_48272[(12)] = inst_48176);

(statearr_48272[(13)] = inst_48175);

(statearr_48272[(14)] = inst_48200);

(statearr_48272[(15)] = inst_48174);

(statearr_48272[(16)] = inst_48177);

return statearr_48272;
})();
var statearr_48273_50239 = state_48236__$1;
(statearr_48273_50239[(2)] = null);

(statearr_48273_50239[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (3))){
var inst_48234 = (state_48236[(2)]);
var state_48236__$1 = state_48236;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48236__$1,inst_48234);
} else {
if((state_val_48237 === (12))){
var inst_48210 = (state_48236[(2)]);
var state_48236__$1 = state_48236;
var statearr_48275_50247 = state_48236__$1;
(statearr_48275_50247[(2)] = inst_48210);

(statearr_48275_50247[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (2))){
var state_48236__$1 = state_48236;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48236__$1,(4),ch);
} else {
if((state_val_48237 === (23))){
var state_48236__$1 = state_48236;
var statearr_48276_50253 = state_48236__$1;
(statearr_48276_50253[(2)] = null);

(statearr_48276_50253[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (19))){
var inst_48217 = (state_48236[(11)]);
var inst_48163 = (state_48236[(8)]);
var inst_48219 = cljs.core.async.muxch_STAR_(inst_48217);
var state_48236__$1 = state_48236;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48236__$1,(22),inst_48219,inst_48163);
} else {
if((state_val_48237 === (11))){
var inst_48188 = (state_48236[(10)]);
var inst_48174 = (state_48236[(15)]);
var inst_48188__$1 = cljs.core.seq(inst_48174);
var state_48236__$1 = (function (){var statearr_48281 = state_48236;
(statearr_48281[(10)] = inst_48188__$1);

return statearr_48281;
})();
if(inst_48188__$1){
var statearr_48282_50273 = state_48236__$1;
(statearr_48282_50273[(1)] = (13));

} else {
var statearr_48283_50274 = state_48236__$1;
(statearr_48283_50274[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (9))){
var inst_48212 = (state_48236[(2)]);
var state_48236__$1 = state_48236;
var statearr_48288_50283 = state_48236__$1;
(statearr_48288_50283[(2)] = inst_48212);

(statearr_48288_50283[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (5))){
var inst_48171 = cljs.core.deref(mults);
var inst_48172 = cljs.core.vals(inst_48171);
var inst_48173 = cljs.core.seq(inst_48172);
var inst_48174 = inst_48173;
var inst_48175 = null;
var inst_48176 = (0);
var inst_48177 = (0);
var state_48236__$1 = (function (){var statearr_48290 = state_48236;
(statearr_48290[(12)] = inst_48176);

(statearr_48290[(13)] = inst_48175);

(statearr_48290[(15)] = inst_48174);

(statearr_48290[(16)] = inst_48177);

return statearr_48290;
})();
var statearr_48292_50304 = state_48236__$1;
(statearr_48292_50304[(2)] = null);

(statearr_48292_50304[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (14))){
var state_48236__$1 = state_48236;
var statearr_48296_50309 = state_48236__$1;
(statearr_48296_50309[(2)] = null);

(statearr_48296_50309[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (16))){
var inst_48188 = (state_48236[(10)]);
var inst_48192 = cljs.core.chunk_first(inst_48188);
var inst_48193 = cljs.core.chunk_rest(inst_48188);
var inst_48194 = cljs.core.count(inst_48192);
var inst_48174 = inst_48193;
var inst_48175 = inst_48192;
var inst_48176 = inst_48194;
var inst_48177 = (0);
var state_48236__$1 = (function (){var statearr_48298 = state_48236;
(statearr_48298[(12)] = inst_48176);

(statearr_48298[(13)] = inst_48175);

(statearr_48298[(15)] = inst_48174);

(statearr_48298[(16)] = inst_48177);

return statearr_48298;
})();
var statearr_48299_50330 = state_48236__$1;
(statearr_48299_50330[(2)] = null);

(statearr_48299_50330[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (10))){
var inst_48176 = (state_48236[(12)]);
var inst_48175 = (state_48236[(13)]);
var inst_48174 = (state_48236[(15)]);
var inst_48177 = (state_48236[(16)]);
var inst_48182 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_48175,inst_48177);
var inst_48183 = cljs.core.async.muxch_STAR_(inst_48182);
var inst_48184 = cljs.core.async.close_BANG_(inst_48183);
var inst_48185 = (inst_48177 + (1));
var tmp48293 = inst_48176;
var tmp48294 = inst_48175;
var tmp48295 = inst_48174;
var inst_48174__$1 = tmp48295;
var inst_48175__$1 = tmp48294;
var inst_48176__$1 = tmp48293;
var inst_48177__$1 = inst_48185;
var state_48236__$1 = (function (){var statearr_48304 = state_48236;
(statearr_48304[(12)] = inst_48176__$1);

(statearr_48304[(17)] = inst_48184);

(statearr_48304[(13)] = inst_48175__$1);

(statearr_48304[(15)] = inst_48174__$1);

(statearr_48304[(16)] = inst_48177__$1);

return statearr_48304;
})();
var statearr_48305_50350 = state_48236__$1;
(statearr_48305_50350[(2)] = null);

(statearr_48305_50350[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (18))){
var inst_48204 = (state_48236[(2)]);
var state_48236__$1 = state_48236;
var statearr_48306_50355 = state_48236__$1;
(statearr_48306_50355[(2)] = inst_48204);

(statearr_48306_50355[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48237 === (8))){
var inst_48176 = (state_48236[(12)]);
var inst_48177 = (state_48236[(16)]);
var inst_48179 = (inst_48177 < inst_48176);
var inst_48180 = inst_48179;
var state_48236__$1 = state_48236;
if(cljs.core.truth_(inst_48180)){
var statearr_48307_50360 = state_48236__$1;
(statearr_48307_50360[(1)] = (10));

} else {
var statearr_48308_50361 = state_48236__$1;
(statearr_48308_50361[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___50149,mults,ensure_mult,p))
;
return ((function (switch__46368__auto__,c__46663__auto___50149,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_48309 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48309[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_48309[(1)] = (1));

return statearr_48309;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_48236){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48236);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48310){if((e48310 instanceof Object)){
var ex__46372__auto__ = e48310;
var statearr_48311_50365 = state_48236;
(statearr_48311_50365[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48236);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48310;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50369 = state_48236;
state_48236 = G__50369;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_48236){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_48236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50149,mults,ensure_mult,p))
})();
var state__46665__auto__ = (function (){var statearr_48312 = f__46664__auto__();
(statearr_48312[(6)] = c__46663__auto___50149);

return statearr_48312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50149,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__48314 = arguments.length;
switch (G__48314) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__48319 = arguments.length;
switch (G__48319) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__48321 = arguments.length;
switch (G__48321) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__46663__auto___50404 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50404,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50404,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_48371){
var state_val_48372 = (state_48371[(1)]);
if((state_val_48372 === (7))){
var state_48371__$1 = state_48371;
var statearr_48373_50427 = state_48371__$1;
(statearr_48373_50427[(2)] = null);

(statearr_48373_50427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (1))){
var state_48371__$1 = state_48371;
var statearr_48374_50430 = state_48371__$1;
(statearr_48374_50430[(2)] = null);

(statearr_48374_50430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (4))){
var inst_48329 = (state_48371[(7)]);
var inst_48331 = (inst_48329 < cnt);
var state_48371__$1 = state_48371;
if(cljs.core.truth_(inst_48331)){
var statearr_48375_50445 = state_48371__$1;
(statearr_48375_50445[(1)] = (6));

} else {
var statearr_48376_50447 = state_48371__$1;
(statearr_48376_50447[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (15))){
var inst_48362 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
var statearr_48379_50452 = state_48371__$1;
(statearr_48379_50452[(2)] = inst_48362);

(statearr_48379_50452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (13))){
var inst_48355 = cljs.core.async.close_BANG_(out);
var state_48371__$1 = state_48371;
var statearr_48380_50486 = state_48371__$1;
(statearr_48380_50486[(2)] = inst_48355);

(statearr_48380_50486[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (6))){
var state_48371__$1 = state_48371;
var statearr_48381_50491 = state_48371__$1;
(statearr_48381_50491[(2)] = null);

(statearr_48381_50491[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (3))){
var inst_48365 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48371__$1,inst_48365);
} else {
if((state_val_48372 === (12))){
var inst_48352 = (state_48371[(8)]);
var inst_48352__$1 = (state_48371[(2)]);
var inst_48353 = cljs.core.some(cljs.core.nil_QMARK_,inst_48352__$1);
var state_48371__$1 = (function (){var statearr_48382 = state_48371;
(statearr_48382[(8)] = inst_48352__$1);

return statearr_48382;
})();
if(cljs.core.truth_(inst_48353)){
var statearr_48383_50504 = state_48371__$1;
(statearr_48383_50504[(1)] = (13));

} else {
var statearr_48385_50505 = state_48371__$1;
(statearr_48385_50505[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (2))){
var inst_48327 = cljs.core.reset_BANG_(dctr,cnt);
var inst_48329 = (0);
var state_48371__$1 = (function (){var statearr_48386 = state_48371;
(statearr_48386[(9)] = inst_48327);

(statearr_48386[(7)] = inst_48329);

return statearr_48386;
})();
var statearr_48387_50509 = state_48371__$1;
(statearr_48387_50509[(2)] = null);

(statearr_48387_50509[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (11))){
var inst_48329 = (state_48371[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_48371,(10),Object,null,(9));
var inst_48339 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_48329) : chs__$1.call(null,inst_48329));
var inst_48340 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_48329) : done.call(null,inst_48329));
var inst_48341 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_48339,inst_48340);
var state_48371__$1 = state_48371;
var statearr_48388_50513 = state_48371__$1;
(statearr_48388_50513[(2)] = inst_48341);


cljs.core.async.impl.ioc_helpers.process_exception(state_48371__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (9))){
var inst_48329 = (state_48371[(7)]);
var inst_48343 = (state_48371[(2)]);
var inst_48344 = (inst_48329 + (1));
var inst_48329__$1 = inst_48344;
var state_48371__$1 = (function (){var statearr_48389 = state_48371;
(statearr_48389[(10)] = inst_48343);

(statearr_48389[(7)] = inst_48329__$1);

return statearr_48389;
})();
var statearr_48390_50523 = state_48371__$1;
(statearr_48390_50523[(2)] = null);

(statearr_48390_50523[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (5))){
var inst_48350 = (state_48371[(2)]);
var state_48371__$1 = (function (){var statearr_48391 = state_48371;
(statearr_48391[(11)] = inst_48350);

return statearr_48391;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48371__$1,(12),dchan);
} else {
if((state_val_48372 === (14))){
var inst_48352 = (state_48371[(8)]);
var inst_48357 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_48352);
var state_48371__$1 = state_48371;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48371__$1,(16),out,inst_48357);
} else {
if((state_val_48372 === (16))){
var inst_48359 = (state_48371[(2)]);
var state_48371__$1 = (function (){var statearr_48392 = state_48371;
(statearr_48392[(12)] = inst_48359);

return statearr_48392;
})();
var statearr_48393_50536 = state_48371__$1;
(statearr_48393_50536[(2)] = null);

(statearr_48393_50536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (10))){
var inst_48334 = (state_48371[(2)]);
var inst_48335 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_48371__$1 = (function (){var statearr_48394 = state_48371;
(statearr_48394[(13)] = inst_48334);

return statearr_48394;
})();
var statearr_48395_50538 = state_48371__$1;
(statearr_48395_50538[(2)] = inst_48335);


cljs.core.async.impl.ioc_helpers.process_exception(state_48371__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48372 === (8))){
var inst_48348 = (state_48371[(2)]);
var state_48371__$1 = state_48371;
var statearr_48396_50539 = state_48371__$1;
(statearr_48396_50539[(2)] = inst_48348);

(statearr_48396_50539[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___50404,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__46368__auto__,c__46663__auto___50404,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_48398 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48398[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_48398[(1)] = (1));

return statearr_48398;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_48371){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48371);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48401){if((e48401 instanceof Object)){
var ex__46372__auto__ = e48401;
var statearr_48402_50546 = state_48371;
(statearr_48402_50546[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48371);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48401;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50547 = state_48371;
state_48371 = G__50547;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_48371){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_48371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50404,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__46665__auto__ = (function (){var statearr_48403 = f__46664__auto__();
(statearr_48403[(6)] = c__46663__auto___50404);

return statearr_48403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50404,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__48411 = arguments.length;
switch (G__48411) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46663__auto___50557 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50557,out){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50557,out){
return (function (state_48457){
var state_val_48458 = (state_48457[(1)]);
if((state_val_48458 === (7))){
var inst_48428 = (state_48457[(7)]);
var inst_48429 = (state_48457[(8)]);
var inst_48428__$1 = (state_48457[(2)]);
var inst_48429__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48428__$1,(0),null);
var inst_48430 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48428__$1,(1),null);
var inst_48432 = (inst_48429__$1 == null);
var state_48457__$1 = (function (){var statearr_48464 = state_48457;
(statearr_48464[(7)] = inst_48428__$1);

(statearr_48464[(9)] = inst_48430);

(statearr_48464[(8)] = inst_48429__$1);

return statearr_48464;
})();
if(cljs.core.truth_(inst_48432)){
var statearr_48465_50572 = state_48457__$1;
(statearr_48465_50572[(1)] = (8));

} else {
var statearr_48466_50573 = state_48457__$1;
(statearr_48466_50573[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (1))){
var inst_48416 = cljs.core.vec(chs);
var inst_48417 = inst_48416;
var state_48457__$1 = (function (){var statearr_48467 = state_48457;
(statearr_48467[(10)] = inst_48417);

return statearr_48467;
})();
var statearr_48469_50578 = state_48457__$1;
(statearr_48469_50578[(2)] = null);

(statearr_48469_50578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (4))){
var inst_48417 = (state_48457[(10)]);
var state_48457__$1 = state_48457;
return cljs.core.async.ioc_alts_BANG_(state_48457__$1,(7),inst_48417);
} else {
if((state_val_48458 === (6))){
var inst_48453 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
var statearr_48470_50583 = state_48457__$1;
(statearr_48470_50583[(2)] = inst_48453);

(statearr_48470_50583[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (3))){
var inst_48455 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48457__$1,inst_48455);
} else {
if((state_val_48458 === (2))){
var inst_48417 = (state_48457[(10)]);
var inst_48420 = cljs.core.count(inst_48417);
var inst_48421 = (inst_48420 > (0));
var state_48457__$1 = state_48457;
if(cljs.core.truth_(inst_48421)){
var statearr_48472_50602 = state_48457__$1;
(statearr_48472_50602[(1)] = (4));

} else {
var statearr_48473_50608 = state_48457__$1;
(statearr_48473_50608[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (11))){
var inst_48417 = (state_48457[(10)]);
var inst_48445 = (state_48457[(2)]);
var tmp48471 = inst_48417;
var inst_48417__$1 = tmp48471;
var state_48457__$1 = (function (){var statearr_48474 = state_48457;
(statearr_48474[(10)] = inst_48417__$1);

(statearr_48474[(11)] = inst_48445);

return statearr_48474;
})();
var statearr_48475_50622 = state_48457__$1;
(statearr_48475_50622[(2)] = null);

(statearr_48475_50622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (9))){
var inst_48429 = (state_48457[(8)]);
var state_48457__$1 = state_48457;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48457__$1,(11),out,inst_48429);
} else {
if((state_val_48458 === (5))){
var inst_48451 = cljs.core.async.close_BANG_(out);
var state_48457__$1 = state_48457;
var statearr_48476_50625 = state_48457__$1;
(statearr_48476_50625[(2)] = inst_48451);

(statearr_48476_50625[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (10))){
var inst_48448 = (state_48457[(2)]);
var state_48457__$1 = state_48457;
var statearr_48477_50626 = state_48457__$1;
(statearr_48477_50626[(2)] = inst_48448);

(statearr_48477_50626[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48458 === (8))){
var inst_48417 = (state_48457[(10)]);
var inst_48428 = (state_48457[(7)]);
var inst_48430 = (state_48457[(9)]);
var inst_48429 = (state_48457[(8)]);
var inst_48440 = (function (){var cs = inst_48417;
var vec__48424 = inst_48428;
var v = inst_48429;
var c = inst_48430;
return ((function (cs,vec__48424,v,c,inst_48417,inst_48428,inst_48430,inst_48429,state_val_48458,c__46663__auto___50557,out){
return (function (p1__48404_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__48404_SHARP_);
});
;})(cs,vec__48424,v,c,inst_48417,inst_48428,inst_48430,inst_48429,state_val_48458,c__46663__auto___50557,out))
})();
var inst_48441 = cljs.core.filterv(inst_48440,inst_48417);
var inst_48417__$1 = inst_48441;
var state_48457__$1 = (function (){var statearr_48478 = state_48457;
(statearr_48478[(10)] = inst_48417__$1);

return statearr_48478;
})();
var statearr_48479_50635 = state_48457__$1;
(statearr_48479_50635[(2)] = null);

(statearr_48479_50635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___50557,out))
;
return ((function (switch__46368__auto__,c__46663__auto___50557,out){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_48480 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48480[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_48480[(1)] = (1));

return statearr_48480;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_48457){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48457);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48481){if((e48481 instanceof Object)){
var ex__46372__auto__ = e48481;
var statearr_48482_50636 = state_48457;
(statearr_48482_50636[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48457);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48481;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50645 = state_48457;
state_48457 = G__50645;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_48457){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_48457);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50557,out))
})();
var state__46665__auto__ = (function (){var statearr_48483 = f__46664__auto__();
(statearr_48483[(6)] = c__46663__auto___50557);

return statearr_48483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50557,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__48485 = arguments.length;
switch (G__48485) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46663__auto___50660 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50660,out){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50660,out){
return (function (state_48512){
var state_val_48513 = (state_48512[(1)]);
if((state_val_48513 === (7))){
var inst_48494 = (state_48512[(7)]);
var inst_48494__$1 = (state_48512[(2)]);
var inst_48495 = (inst_48494__$1 == null);
var inst_48496 = cljs.core.not(inst_48495);
var state_48512__$1 = (function (){var statearr_48514 = state_48512;
(statearr_48514[(7)] = inst_48494__$1);

return statearr_48514;
})();
if(inst_48496){
var statearr_48515_50664 = state_48512__$1;
(statearr_48515_50664[(1)] = (8));

} else {
var statearr_48516_50665 = state_48512__$1;
(statearr_48516_50665[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48513 === (1))){
var inst_48489 = (0);
var state_48512__$1 = (function (){var statearr_48517 = state_48512;
(statearr_48517[(8)] = inst_48489);

return statearr_48517;
})();
var statearr_48518_50666 = state_48512__$1;
(statearr_48518_50666[(2)] = null);

(statearr_48518_50666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48513 === (4))){
var state_48512__$1 = state_48512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48512__$1,(7),ch);
} else {
if((state_val_48513 === (6))){
var inst_48507 = (state_48512[(2)]);
var state_48512__$1 = state_48512;
var statearr_48519_50667 = state_48512__$1;
(statearr_48519_50667[(2)] = inst_48507);

(statearr_48519_50667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48513 === (3))){
var inst_48509 = (state_48512[(2)]);
var inst_48510 = cljs.core.async.close_BANG_(out);
var state_48512__$1 = (function (){var statearr_48520 = state_48512;
(statearr_48520[(9)] = inst_48509);

return statearr_48520;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48512__$1,inst_48510);
} else {
if((state_val_48513 === (2))){
var inst_48489 = (state_48512[(8)]);
var inst_48491 = (inst_48489 < n);
var state_48512__$1 = state_48512;
if(cljs.core.truth_(inst_48491)){
var statearr_48521_50672 = state_48512__$1;
(statearr_48521_50672[(1)] = (4));

} else {
var statearr_48522_50673 = state_48512__$1;
(statearr_48522_50673[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48513 === (11))){
var inst_48489 = (state_48512[(8)]);
var inst_48499 = (state_48512[(2)]);
var inst_48500 = (inst_48489 + (1));
var inst_48489__$1 = inst_48500;
var state_48512__$1 = (function (){var statearr_48524 = state_48512;
(statearr_48524[(8)] = inst_48489__$1);

(statearr_48524[(10)] = inst_48499);

return statearr_48524;
})();
var statearr_48525_50674 = state_48512__$1;
(statearr_48525_50674[(2)] = null);

(statearr_48525_50674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48513 === (9))){
var state_48512__$1 = state_48512;
var statearr_48528_50675 = state_48512__$1;
(statearr_48528_50675[(2)] = null);

(statearr_48528_50675[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48513 === (5))){
var state_48512__$1 = state_48512;
var statearr_48529_50676 = state_48512__$1;
(statearr_48529_50676[(2)] = null);

(statearr_48529_50676[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48513 === (10))){
var inst_48504 = (state_48512[(2)]);
var state_48512__$1 = state_48512;
var statearr_48530_50677 = state_48512__$1;
(statearr_48530_50677[(2)] = inst_48504);

(statearr_48530_50677[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48513 === (8))){
var inst_48494 = (state_48512[(7)]);
var state_48512__$1 = state_48512;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48512__$1,(11),out,inst_48494);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___50660,out))
;
return ((function (switch__46368__auto__,c__46663__auto___50660,out){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_48531 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48531[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_48531[(1)] = (1));

return statearr_48531;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_48512){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48512);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48532){if((e48532 instanceof Object)){
var ex__46372__auto__ = e48532;
var statearr_48533_50680 = state_48512;
(statearr_48533_50680[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48512);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48532;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50681 = state_48512;
state_48512 = G__50681;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_48512){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_48512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50660,out))
})();
var state__46665__auto__ = (function (){var statearr_48534 = f__46664__auto__();
(statearr_48534[(6)] = c__46663__auto___50660);

return statearr_48534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50660,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48537 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48537 = (function (f,ch,meta48538){
this.f = f;
this.ch = ch;
this.meta48538 = meta48538;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48539,meta48538__$1){
var self__ = this;
var _48539__$1 = this;
return (new cljs.core.async.t_cljs$core$async48537(self__.f,self__.ch,meta48538__$1));
});

cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48539){
var self__ = this;
var _48539__$1 = this;
return self__.meta48538;
});

cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48546 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48546 = (function (f,ch,meta48538,_,fn1,meta48547){
this.f = f;
this.ch = ch;
this.meta48538 = meta48538;
this._ = _;
this.fn1 = fn1;
this.meta48547 = meta48547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async48546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_48548,meta48547__$1){
var self__ = this;
var _48548__$1 = this;
return (new cljs.core.async.t_cljs$core$async48546(self__.f,self__.ch,self__.meta48538,self__._,self__.fn1,meta48547__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async48546.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_48548){
var self__ = this;
var _48548__$1 = this;
return self__.meta48547;
});})(___$1))
;

cljs.core.async.t_cljs$core$async48546.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48546.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48546.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async48546.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__48535_SHARP_){
var G__48550 = (((p1__48535_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__48535_SHARP_) : self__.f.call(null,p1__48535_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__48550) : f1.call(null,G__48550));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async48546.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48538","meta48538",735823566,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48537","cljs.core.async/t_cljs$core$async48537",1075915679,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48547","meta48547",528936139,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async48546.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48546.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48546";

cljs.core.async.t_cljs$core$async48546.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async48546");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48546.
 */
cljs.core.async.__GT_t_cljs$core$async48546 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48546(f__$1,ch__$1,meta48538__$1,___$2,fn1__$1,meta48547){
return (new cljs.core.async.t_cljs$core$async48546(f__$1,ch__$1,meta48538__$1,___$2,fn1__$1,meta48547));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async48546(self__.f,self__.ch,self__.meta48538,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__48551 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__48551) : self__.f.call(null,G__48551));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48537.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async48537.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48538","meta48538",735823566,null)], null);
});

cljs.core.async.t_cljs$core$async48537.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48537.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48537";

cljs.core.async.t_cljs$core$async48537.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async48537");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48537.
 */
cljs.core.async.__GT_t_cljs$core$async48537 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48537(f__$1,ch__$1,meta48538){
return (new cljs.core.async.t_cljs$core$async48537(f__$1,ch__$1,meta48538));
});

}

return (new cljs.core.async.t_cljs$core$async48537(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48552 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48552 = (function (f,ch,meta48553){
this.f = f;
this.ch = ch;
this.meta48553 = meta48553;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48554,meta48553__$1){
var self__ = this;
var _48554__$1 = this;
return (new cljs.core.async.t_cljs$core$async48552(self__.f,self__.ch,meta48553__$1));
});

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48554){
var self__ = this;
var _48554__$1 = this;
return self__.meta48553;
});

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48552.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async48552.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48553","meta48553",1549055030,null)], null);
});

cljs.core.async.t_cljs$core$async48552.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48552.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48552";

cljs.core.async.t_cljs$core$async48552.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async48552");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48552.
 */
cljs.core.async.__GT_t_cljs$core$async48552 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48552(f__$1,ch__$1,meta48553){
return (new cljs.core.async.t_cljs$core$async48552(f__$1,ch__$1,meta48553));
});

}

return (new cljs.core.async.t_cljs$core$async48552(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48558 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48558 = (function (p,ch,meta48559){
this.p = p;
this.ch = ch;
this.meta48559 = meta48559;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48560,meta48559__$1){
var self__ = this;
var _48560__$1 = this;
return (new cljs.core.async.t_cljs$core$async48558(self__.p,self__.ch,meta48559__$1));
});

cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48560){
var self__ = this;
var _48560__$1 = this;
return self__.meta48559;
});

cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async48558.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async48558.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48559","meta48559",533840735,null)], null);
});

cljs.core.async.t_cljs$core$async48558.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async48558.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48558";

cljs.core.async.t_cljs$core$async48558.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async48558");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48558.
 */
cljs.core.async.__GT_t_cljs$core$async48558 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48558(p__$1,ch__$1,meta48559){
return (new cljs.core.async.t_cljs$core$async48558(p__$1,ch__$1,meta48559));
});

}

return (new cljs.core.async.t_cljs$core$async48558(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__48572 = arguments.length;
switch (G__48572) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46663__auto___50716 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50716,out){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50716,out){
return (function (state_48596){
var state_val_48597 = (state_48596[(1)]);
if((state_val_48597 === (7))){
var inst_48592 = (state_48596[(2)]);
var state_48596__$1 = state_48596;
var statearr_48601_50717 = state_48596__$1;
(statearr_48601_50717[(2)] = inst_48592);

(statearr_48601_50717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48597 === (1))){
var state_48596__$1 = state_48596;
var statearr_48602_50718 = state_48596__$1;
(statearr_48602_50718[(2)] = null);

(statearr_48602_50718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48597 === (4))){
var inst_48578 = (state_48596[(7)]);
var inst_48578__$1 = (state_48596[(2)]);
var inst_48579 = (inst_48578__$1 == null);
var state_48596__$1 = (function (){var statearr_48603 = state_48596;
(statearr_48603[(7)] = inst_48578__$1);

return statearr_48603;
})();
if(cljs.core.truth_(inst_48579)){
var statearr_48604_50720 = state_48596__$1;
(statearr_48604_50720[(1)] = (5));

} else {
var statearr_48605_50721 = state_48596__$1;
(statearr_48605_50721[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48597 === (6))){
var inst_48578 = (state_48596[(7)]);
var inst_48583 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_48578) : p.call(null,inst_48578));
var state_48596__$1 = state_48596;
if(cljs.core.truth_(inst_48583)){
var statearr_48606_50723 = state_48596__$1;
(statearr_48606_50723[(1)] = (8));

} else {
var statearr_48607_50724 = state_48596__$1;
(statearr_48607_50724[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48597 === (3))){
var inst_48594 = (state_48596[(2)]);
var state_48596__$1 = state_48596;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48596__$1,inst_48594);
} else {
if((state_val_48597 === (2))){
var state_48596__$1 = state_48596;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48596__$1,(4),ch);
} else {
if((state_val_48597 === (11))){
var inst_48586 = (state_48596[(2)]);
var state_48596__$1 = state_48596;
var statearr_48608_50732 = state_48596__$1;
(statearr_48608_50732[(2)] = inst_48586);

(statearr_48608_50732[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48597 === (9))){
var state_48596__$1 = state_48596;
var statearr_48609_50737 = state_48596__$1;
(statearr_48609_50737[(2)] = null);

(statearr_48609_50737[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48597 === (5))){
var inst_48581 = cljs.core.async.close_BANG_(out);
var state_48596__$1 = state_48596;
var statearr_48610_50748 = state_48596__$1;
(statearr_48610_50748[(2)] = inst_48581);

(statearr_48610_50748[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48597 === (10))){
var inst_48589 = (state_48596[(2)]);
var state_48596__$1 = (function (){var statearr_48611 = state_48596;
(statearr_48611[(8)] = inst_48589);

return statearr_48611;
})();
var statearr_48612_50753 = state_48596__$1;
(statearr_48612_50753[(2)] = null);

(statearr_48612_50753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48597 === (8))){
var inst_48578 = (state_48596[(7)]);
var state_48596__$1 = state_48596;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48596__$1,(11),out,inst_48578);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___50716,out))
;
return ((function (switch__46368__auto__,c__46663__auto___50716,out){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_48616 = [null,null,null,null,null,null,null,null,null];
(statearr_48616[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_48616[(1)] = (1));

return statearr_48616;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_48596){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48596);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48617){if((e48617 instanceof Object)){
var ex__46372__auto__ = e48617;
var statearr_48618_50760 = state_48596;
(statearr_48618_50760[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48617;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50766 = state_48596;
state_48596 = G__50766;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_48596){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_48596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50716,out))
})();
var state__46665__auto__ = (function (){var statearr_48619 = f__46664__auto__();
(statearr_48619[(6)] = c__46663__auto___50716);

return statearr_48619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50716,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__48621 = arguments.length;
switch (G__48621) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__){
return (function (state_48685){
var state_val_48686 = (state_48685[(1)]);
if((state_val_48686 === (7))){
var inst_48681 = (state_48685[(2)]);
var state_48685__$1 = state_48685;
var statearr_48687_50807 = state_48685__$1;
(statearr_48687_50807[(2)] = inst_48681);

(statearr_48687_50807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (20))){
var inst_48650 = (state_48685[(7)]);
var inst_48661 = (state_48685[(2)]);
var inst_48662 = cljs.core.next(inst_48650);
var inst_48636 = inst_48662;
var inst_48637 = null;
var inst_48638 = (0);
var inst_48639 = (0);
var state_48685__$1 = (function (){var statearr_48691 = state_48685;
(statearr_48691[(8)] = inst_48636);

(statearr_48691[(9)] = inst_48661);

(statearr_48691[(10)] = inst_48638);

(statearr_48691[(11)] = inst_48637);

(statearr_48691[(12)] = inst_48639);

return statearr_48691;
})();
var statearr_48692_50820 = state_48685__$1;
(statearr_48692_50820[(2)] = null);

(statearr_48692_50820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (1))){
var state_48685__$1 = state_48685;
var statearr_48693_50828 = state_48685__$1;
(statearr_48693_50828[(2)] = null);

(statearr_48693_50828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (4))){
var inst_48625 = (state_48685[(13)]);
var inst_48625__$1 = (state_48685[(2)]);
var inst_48626 = (inst_48625__$1 == null);
var state_48685__$1 = (function (){var statearr_48694 = state_48685;
(statearr_48694[(13)] = inst_48625__$1);

return statearr_48694;
})();
if(cljs.core.truth_(inst_48626)){
var statearr_48695_50840 = state_48685__$1;
(statearr_48695_50840[(1)] = (5));

} else {
var statearr_48696_50845 = state_48685__$1;
(statearr_48696_50845[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (15))){
var state_48685__$1 = state_48685;
var statearr_48700_50852 = state_48685__$1;
(statearr_48700_50852[(2)] = null);

(statearr_48700_50852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (21))){
var state_48685__$1 = state_48685;
var statearr_48701_50862 = state_48685__$1;
(statearr_48701_50862[(2)] = null);

(statearr_48701_50862[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (13))){
var inst_48636 = (state_48685[(8)]);
var inst_48638 = (state_48685[(10)]);
var inst_48637 = (state_48685[(11)]);
var inst_48639 = (state_48685[(12)]);
var inst_48646 = (state_48685[(2)]);
var inst_48647 = (inst_48639 + (1));
var tmp48697 = inst_48636;
var tmp48698 = inst_48638;
var tmp48699 = inst_48637;
var inst_48636__$1 = tmp48697;
var inst_48637__$1 = tmp48699;
var inst_48638__$1 = tmp48698;
var inst_48639__$1 = inst_48647;
var state_48685__$1 = (function (){var statearr_48702 = state_48685;
(statearr_48702[(8)] = inst_48636__$1);

(statearr_48702[(10)] = inst_48638__$1);

(statearr_48702[(14)] = inst_48646);

(statearr_48702[(11)] = inst_48637__$1);

(statearr_48702[(12)] = inst_48639__$1);

return statearr_48702;
})();
var statearr_48703_50877 = state_48685__$1;
(statearr_48703_50877[(2)] = null);

(statearr_48703_50877[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (22))){
var state_48685__$1 = state_48685;
var statearr_48704_50878 = state_48685__$1;
(statearr_48704_50878[(2)] = null);

(statearr_48704_50878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (6))){
var inst_48625 = (state_48685[(13)]);
var inst_48634 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48625) : f.call(null,inst_48625));
var inst_48635 = cljs.core.seq(inst_48634);
var inst_48636 = inst_48635;
var inst_48637 = null;
var inst_48638 = (0);
var inst_48639 = (0);
var state_48685__$1 = (function (){var statearr_48705 = state_48685;
(statearr_48705[(8)] = inst_48636);

(statearr_48705[(10)] = inst_48638);

(statearr_48705[(11)] = inst_48637);

(statearr_48705[(12)] = inst_48639);

return statearr_48705;
})();
var statearr_48706_50882 = state_48685__$1;
(statearr_48706_50882[(2)] = null);

(statearr_48706_50882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (17))){
var inst_48650 = (state_48685[(7)]);
var inst_48654 = cljs.core.chunk_first(inst_48650);
var inst_48655 = cljs.core.chunk_rest(inst_48650);
var inst_48656 = cljs.core.count(inst_48654);
var inst_48636 = inst_48655;
var inst_48637 = inst_48654;
var inst_48638 = inst_48656;
var inst_48639 = (0);
var state_48685__$1 = (function (){var statearr_48707 = state_48685;
(statearr_48707[(8)] = inst_48636);

(statearr_48707[(10)] = inst_48638);

(statearr_48707[(11)] = inst_48637);

(statearr_48707[(12)] = inst_48639);

return statearr_48707;
})();
var statearr_48708_50884 = state_48685__$1;
(statearr_48708_50884[(2)] = null);

(statearr_48708_50884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (3))){
var inst_48683 = (state_48685[(2)]);
var state_48685__$1 = state_48685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48685__$1,inst_48683);
} else {
if((state_val_48686 === (12))){
var inst_48670 = (state_48685[(2)]);
var state_48685__$1 = state_48685;
var statearr_48709_50888 = state_48685__$1;
(statearr_48709_50888[(2)] = inst_48670);

(statearr_48709_50888[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (2))){
var state_48685__$1 = state_48685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48685__$1,(4),in$);
} else {
if((state_val_48686 === (23))){
var inst_48679 = (state_48685[(2)]);
var state_48685__$1 = state_48685;
var statearr_48710_50892 = state_48685__$1;
(statearr_48710_50892[(2)] = inst_48679);

(statearr_48710_50892[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (19))){
var inst_48665 = (state_48685[(2)]);
var state_48685__$1 = state_48685;
var statearr_48711_50893 = state_48685__$1;
(statearr_48711_50893[(2)] = inst_48665);

(statearr_48711_50893[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (11))){
var inst_48650 = (state_48685[(7)]);
var inst_48636 = (state_48685[(8)]);
var inst_48650__$1 = cljs.core.seq(inst_48636);
var state_48685__$1 = (function (){var statearr_48712 = state_48685;
(statearr_48712[(7)] = inst_48650__$1);

return statearr_48712;
})();
if(inst_48650__$1){
var statearr_48713_50894 = state_48685__$1;
(statearr_48713_50894[(1)] = (14));

} else {
var statearr_48714_50895 = state_48685__$1;
(statearr_48714_50895[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (9))){
var inst_48672 = (state_48685[(2)]);
var inst_48673 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_48685__$1 = (function (){var statearr_48715 = state_48685;
(statearr_48715[(15)] = inst_48672);

return statearr_48715;
})();
if(cljs.core.truth_(inst_48673)){
var statearr_48716_50900 = state_48685__$1;
(statearr_48716_50900[(1)] = (21));

} else {
var statearr_48717_50901 = state_48685__$1;
(statearr_48717_50901[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (5))){
var inst_48628 = cljs.core.async.close_BANG_(out);
var state_48685__$1 = state_48685;
var statearr_48718_50902 = state_48685__$1;
(statearr_48718_50902[(2)] = inst_48628);

(statearr_48718_50902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (14))){
var inst_48650 = (state_48685[(7)]);
var inst_48652 = cljs.core.chunked_seq_QMARK_(inst_48650);
var state_48685__$1 = state_48685;
if(inst_48652){
var statearr_48719_50903 = state_48685__$1;
(statearr_48719_50903[(1)] = (17));

} else {
var statearr_48720_50904 = state_48685__$1;
(statearr_48720_50904[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (16))){
var inst_48668 = (state_48685[(2)]);
var state_48685__$1 = state_48685;
var statearr_48722_50906 = state_48685__$1;
(statearr_48722_50906[(2)] = inst_48668);

(statearr_48722_50906[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48686 === (10))){
var inst_48637 = (state_48685[(11)]);
var inst_48639 = (state_48685[(12)]);
var inst_48644 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_48637,inst_48639);
var state_48685__$1 = state_48685;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48685__$1,(13),out,inst_48644);
} else {
if((state_val_48686 === (18))){
var inst_48650 = (state_48685[(7)]);
var inst_48659 = cljs.core.first(inst_48650);
var state_48685__$1 = state_48685;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48685__$1,(20),out,inst_48659);
} else {
if((state_val_48686 === (8))){
var inst_48638 = (state_48685[(10)]);
var inst_48639 = (state_48685[(12)]);
var inst_48641 = (inst_48639 < inst_48638);
var inst_48642 = inst_48641;
var state_48685__$1 = state_48685;
if(cljs.core.truth_(inst_48642)){
var statearr_48723_50907 = state_48685__$1;
(statearr_48723_50907[(1)] = (10));

} else {
var statearr_48724_50908 = state_48685__$1;
(statearr_48724_50908[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto__))
;
return ((function (switch__46368__auto__,c__46663__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__46369__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__46369__auto____0 = (function (){
var statearr_48725 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48725[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__46369__auto__);

(statearr_48725[(1)] = (1));

return statearr_48725;
});
var cljs$core$async$mapcat_STAR__$_state_machine__46369__auto____1 = (function (state_48685){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48685);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48730){if((e48730 instanceof Object)){
var ex__46372__auto__ = e48730;
var statearr_48731_50912 = state_48685;
(statearr_48731_50912[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48685);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48730;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50913 = state_48685;
state_48685 = G__50913;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__46369__auto__ = function(state_48685){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__46369__auto____1.call(this,state_48685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__46369__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__46369__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__))
})();
var state__46665__auto__ = (function (){var statearr_48736 = f__46664__auto__();
(statearr_48736[(6)] = c__46663__auto__);

return statearr_48736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__))
);

return c__46663__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__48742 = arguments.length;
switch (G__48742) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__48746 = arguments.length;
switch (G__48746) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__48748 = arguments.length;
switch (G__48748) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46663__auto___50928 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50928,out){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50928,out){
return (function (state_48772){
var state_val_48773 = (state_48772[(1)]);
if((state_val_48773 === (7))){
var inst_48767 = (state_48772[(2)]);
var state_48772__$1 = state_48772;
var statearr_48774_50932 = state_48772__$1;
(statearr_48774_50932[(2)] = inst_48767);

(statearr_48774_50932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (1))){
var inst_48749 = null;
var state_48772__$1 = (function (){var statearr_48775 = state_48772;
(statearr_48775[(7)] = inst_48749);

return statearr_48775;
})();
var statearr_48776_50933 = state_48772__$1;
(statearr_48776_50933[(2)] = null);

(statearr_48776_50933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (4))){
var inst_48752 = (state_48772[(8)]);
var inst_48752__$1 = (state_48772[(2)]);
var inst_48753 = (inst_48752__$1 == null);
var inst_48754 = cljs.core.not(inst_48753);
var state_48772__$1 = (function (){var statearr_48777 = state_48772;
(statearr_48777[(8)] = inst_48752__$1);

return statearr_48777;
})();
if(inst_48754){
var statearr_48778_50937 = state_48772__$1;
(statearr_48778_50937[(1)] = (5));

} else {
var statearr_48781_50938 = state_48772__$1;
(statearr_48781_50938[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (6))){
var state_48772__$1 = state_48772;
var statearr_48782_50940 = state_48772__$1;
(statearr_48782_50940[(2)] = null);

(statearr_48782_50940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (3))){
var inst_48769 = (state_48772[(2)]);
var inst_48770 = cljs.core.async.close_BANG_(out);
var state_48772__$1 = (function (){var statearr_48784 = state_48772;
(statearr_48784[(9)] = inst_48769);

return statearr_48784;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48772__$1,inst_48770);
} else {
if((state_val_48773 === (2))){
var state_48772__$1 = state_48772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48772__$1,(4),ch);
} else {
if((state_val_48773 === (11))){
var inst_48752 = (state_48772[(8)]);
var inst_48761 = (state_48772[(2)]);
var inst_48749 = inst_48752;
var state_48772__$1 = (function (){var statearr_48785 = state_48772;
(statearr_48785[(10)] = inst_48761);

(statearr_48785[(7)] = inst_48749);

return statearr_48785;
})();
var statearr_48786_50943 = state_48772__$1;
(statearr_48786_50943[(2)] = null);

(statearr_48786_50943[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (9))){
var inst_48752 = (state_48772[(8)]);
var state_48772__$1 = state_48772;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48772__$1,(11),out,inst_48752);
} else {
if((state_val_48773 === (5))){
var inst_48752 = (state_48772[(8)]);
var inst_48749 = (state_48772[(7)]);
var inst_48756 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48752,inst_48749);
var state_48772__$1 = state_48772;
if(inst_48756){
var statearr_48788_50945 = state_48772__$1;
(statearr_48788_50945[(1)] = (8));

} else {
var statearr_48789_50946 = state_48772__$1;
(statearr_48789_50946[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (10))){
var inst_48764 = (state_48772[(2)]);
var state_48772__$1 = state_48772;
var statearr_48790_50947 = state_48772__$1;
(statearr_48790_50947[(2)] = inst_48764);

(statearr_48790_50947[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48773 === (8))){
var inst_48749 = (state_48772[(7)]);
var tmp48787 = inst_48749;
var inst_48749__$1 = tmp48787;
var state_48772__$1 = (function (){var statearr_48791 = state_48772;
(statearr_48791[(7)] = inst_48749__$1);

return statearr_48791;
})();
var statearr_48794_50948 = state_48772__$1;
(statearr_48794_50948[(2)] = null);

(statearr_48794_50948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___50928,out))
;
return ((function (switch__46368__auto__,c__46663__auto___50928,out){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_48799 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48799[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_48799[(1)] = (1));

return statearr_48799;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_48772){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48772);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48802){if((e48802 instanceof Object)){
var ex__46372__auto__ = e48802;
var statearr_48803_50951 = state_48772;
(statearr_48803_50951[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48772);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48802;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50952 = state_48772;
state_48772 = G__50952;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_48772){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_48772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50928,out))
})();
var state__46665__auto__ = (function (){var statearr_48804 = f__46664__auto__();
(statearr_48804[(6)] = c__46663__auto___50928);

return statearr_48804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50928,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__48806 = arguments.length;
switch (G__48806) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46663__auto___50958 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50958,out){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50958,out){
return (function (state_48852){
var state_val_48853 = (state_48852[(1)]);
if((state_val_48853 === (7))){
var inst_48848 = (state_48852[(2)]);
var state_48852__$1 = state_48852;
var statearr_48862_50959 = state_48852__$1;
(statearr_48862_50959[(2)] = inst_48848);

(statearr_48862_50959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (1))){
var inst_48811 = (new Array(n));
var inst_48813 = inst_48811;
var inst_48814 = (0);
var state_48852__$1 = (function (){var statearr_48864 = state_48852;
(statearr_48864[(7)] = inst_48814);

(statearr_48864[(8)] = inst_48813);

return statearr_48864;
})();
var statearr_48865_50961 = state_48852__$1;
(statearr_48865_50961[(2)] = null);

(statearr_48865_50961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (4))){
var inst_48817 = (state_48852[(9)]);
var inst_48817__$1 = (state_48852[(2)]);
var inst_48819 = (inst_48817__$1 == null);
var inst_48820 = cljs.core.not(inst_48819);
var state_48852__$1 = (function (){var statearr_48866 = state_48852;
(statearr_48866[(9)] = inst_48817__$1);

return statearr_48866;
})();
if(inst_48820){
var statearr_48867_50962 = state_48852__$1;
(statearr_48867_50962[(1)] = (5));

} else {
var statearr_48868_50963 = state_48852__$1;
(statearr_48868_50963[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (15))){
var inst_48842 = (state_48852[(2)]);
var state_48852__$1 = state_48852;
var statearr_48870_50964 = state_48852__$1;
(statearr_48870_50964[(2)] = inst_48842);

(statearr_48870_50964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (13))){
var state_48852__$1 = state_48852;
var statearr_48873_50966 = state_48852__$1;
(statearr_48873_50966[(2)] = null);

(statearr_48873_50966[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (6))){
var inst_48814 = (state_48852[(7)]);
var inst_48836 = (inst_48814 > (0));
var state_48852__$1 = state_48852;
if(cljs.core.truth_(inst_48836)){
var statearr_48874_50968 = state_48852__$1;
(statearr_48874_50968[(1)] = (12));

} else {
var statearr_48875_50969 = state_48852__$1;
(statearr_48875_50969[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (3))){
var inst_48850 = (state_48852[(2)]);
var state_48852__$1 = state_48852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48852__$1,inst_48850);
} else {
if((state_val_48853 === (12))){
var inst_48813 = (state_48852[(8)]);
var inst_48840 = cljs.core.vec(inst_48813);
var state_48852__$1 = state_48852;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48852__$1,(15),out,inst_48840);
} else {
if((state_val_48853 === (2))){
var state_48852__$1 = state_48852;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48852__$1,(4),ch);
} else {
if((state_val_48853 === (11))){
var inst_48830 = (state_48852[(2)]);
var inst_48831 = (new Array(n));
var inst_48813 = inst_48831;
var inst_48814 = (0);
var state_48852__$1 = (function (){var statearr_48880 = state_48852;
(statearr_48880[(7)] = inst_48814);

(statearr_48880[(10)] = inst_48830);

(statearr_48880[(8)] = inst_48813);

return statearr_48880;
})();
var statearr_48881_50974 = state_48852__$1;
(statearr_48881_50974[(2)] = null);

(statearr_48881_50974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (9))){
var inst_48813 = (state_48852[(8)]);
var inst_48828 = cljs.core.vec(inst_48813);
var state_48852__$1 = state_48852;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48852__$1,(11),out,inst_48828);
} else {
if((state_val_48853 === (5))){
var inst_48814 = (state_48852[(7)]);
var inst_48823 = (state_48852[(11)]);
var inst_48817 = (state_48852[(9)]);
var inst_48813 = (state_48852[(8)]);
var inst_48822 = (inst_48813[inst_48814] = inst_48817);
var inst_48823__$1 = (inst_48814 + (1));
var inst_48824 = (inst_48823__$1 < n);
var state_48852__$1 = (function (){var statearr_48885 = state_48852;
(statearr_48885[(11)] = inst_48823__$1);

(statearr_48885[(12)] = inst_48822);

return statearr_48885;
})();
if(cljs.core.truth_(inst_48824)){
var statearr_48886_50975 = state_48852__$1;
(statearr_48886_50975[(1)] = (8));

} else {
var statearr_48887_50980 = state_48852__$1;
(statearr_48887_50980[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (14))){
var inst_48845 = (state_48852[(2)]);
var inst_48846 = cljs.core.async.close_BANG_(out);
var state_48852__$1 = (function (){var statearr_48889 = state_48852;
(statearr_48889[(13)] = inst_48845);

return statearr_48889;
})();
var statearr_48890_50982 = state_48852__$1;
(statearr_48890_50982[(2)] = inst_48846);

(statearr_48890_50982[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (10))){
var inst_48834 = (state_48852[(2)]);
var state_48852__$1 = state_48852;
var statearr_48893_50983 = state_48852__$1;
(statearr_48893_50983[(2)] = inst_48834);

(statearr_48893_50983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48853 === (8))){
var inst_48823 = (state_48852[(11)]);
var inst_48813 = (state_48852[(8)]);
var tmp48888 = inst_48813;
var inst_48813__$1 = tmp48888;
var inst_48814 = inst_48823;
var state_48852__$1 = (function (){var statearr_48894 = state_48852;
(statearr_48894[(7)] = inst_48814);

(statearr_48894[(8)] = inst_48813__$1);

return statearr_48894;
})();
var statearr_48895_50985 = state_48852__$1;
(statearr_48895_50985[(2)] = null);

(statearr_48895_50985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___50958,out))
;
return ((function (switch__46368__auto__,c__46663__auto___50958,out){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_48899 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48899[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_48899[(1)] = (1));

return statearr_48899;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_48852){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48852);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e48900){if((e48900 instanceof Object)){
var ex__46372__auto__ = e48900;
var statearr_48903_50986 = state_48852;
(statearr_48903_50986[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48852);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48900;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50987 = state_48852;
state_48852 = G__50987;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_48852){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_48852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50958,out))
})();
var state__46665__auto__ = (function (){var statearr_48908 = f__46664__auto__();
(statearr_48908[(6)] = c__46663__auto___50958);

return statearr_48908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50958,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__48913 = arguments.length;
switch (G__48913) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46663__auto___50996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50996,out){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50996,out){
return (function (state_48958){
var state_val_48959 = (state_48958[(1)]);
if((state_val_48959 === (7))){
var inst_48954 = (state_48958[(2)]);
var state_48958__$1 = state_48958;
var statearr_48962_50998 = state_48958__$1;
(statearr_48962_50998[(2)] = inst_48954);

(statearr_48962_50998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (1))){
var inst_48917 = [];
var inst_48918 = inst_48917;
var inst_48919 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_48958__$1 = (function (){var statearr_48966 = state_48958;
(statearr_48966[(7)] = inst_48919);

(statearr_48966[(8)] = inst_48918);

return statearr_48966;
})();
var statearr_48967_50999 = state_48958__$1;
(statearr_48967_50999[(2)] = null);

(statearr_48967_50999[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (4))){
var inst_48922 = (state_48958[(9)]);
var inst_48922__$1 = (state_48958[(2)]);
var inst_48923 = (inst_48922__$1 == null);
var inst_48924 = cljs.core.not(inst_48923);
var state_48958__$1 = (function (){var statearr_48968 = state_48958;
(statearr_48968[(9)] = inst_48922__$1);

return statearr_48968;
})();
if(inst_48924){
var statearr_48969_51000 = state_48958__$1;
(statearr_48969_51000[(1)] = (5));

} else {
var statearr_48970_51001 = state_48958__$1;
(statearr_48970_51001[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (15))){
var inst_48948 = (state_48958[(2)]);
var state_48958__$1 = state_48958;
var statearr_48971_51002 = state_48958__$1;
(statearr_48971_51002[(2)] = inst_48948);

(statearr_48971_51002[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (13))){
var state_48958__$1 = state_48958;
var statearr_48972_51003 = state_48958__$1;
(statearr_48972_51003[(2)] = null);

(statearr_48972_51003[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (6))){
var inst_48918 = (state_48958[(8)]);
var inst_48943 = inst_48918.length;
var inst_48944 = (inst_48943 > (0));
var state_48958__$1 = state_48958;
if(cljs.core.truth_(inst_48944)){
var statearr_48976_51004 = state_48958__$1;
(statearr_48976_51004[(1)] = (12));

} else {
var statearr_48980_51005 = state_48958__$1;
(statearr_48980_51005[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (3))){
var inst_48956 = (state_48958[(2)]);
var state_48958__$1 = state_48958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48958__$1,inst_48956);
} else {
if((state_val_48959 === (12))){
var inst_48918 = (state_48958[(8)]);
var inst_48946 = cljs.core.vec(inst_48918);
var state_48958__$1 = state_48958;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48958__$1,(15),out,inst_48946);
} else {
if((state_val_48959 === (2))){
var state_48958__$1 = state_48958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48958__$1,(4),ch);
} else {
if((state_val_48959 === (11))){
var inst_48926 = (state_48958[(10)]);
var inst_48922 = (state_48958[(9)]);
var inst_48936 = (state_48958[(2)]);
var inst_48937 = [];
var inst_48938 = inst_48937.push(inst_48922);
var inst_48918 = inst_48937;
var inst_48919 = inst_48926;
var state_48958__$1 = (function (){var statearr_48981 = state_48958;
(statearr_48981[(11)] = inst_48938);

(statearr_48981[(7)] = inst_48919);

(statearr_48981[(8)] = inst_48918);

(statearr_48981[(12)] = inst_48936);

return statearr_48981;
})();
var statearr_48983_51015 = state_48958__$1;
(statearr_48983_51015[(2)] = null);

(statearr_48983_51015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (9))){
var inst_48918 = (state_48958[(8)]);
var inst_48934 = cljs.core.vec(inst_48918);
var state_48958__$1 = state_48958;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48958__$1,(11),out,inst_48934);
} else {
if((state_val_48959 === (5))){
var inst_48919 = (state_48958[(7)]);
var inst_48926 = (state_48958[(10)]);
var inst_48922 = (state_48958[(9)]);
var inst_48926__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48922) : f.call(null,inst_48922));
var inst_48927 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48926__$1,inst_48919);
var inst_48928 = cljs.core.keyword_identical_QMARK_(inst_48919,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_48929 = ((inst_48927) || (inst_48928));
var state_48958__$1 = (function (){var statearr_48989 = state_48958;
(statearr_48989[(10)] = inst_48926__$1);

return statearr_48989;
})();
if(cljs.core.truth_(inst_48929)){
var statearr_48991_51030 = state_48958__$1;
(statearr_48991_51030[(1)] = (8));

} else {
var statearr_48995_51031 = state_48958__$1;
(statearr_48995_51031[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (14))){
var inst_48951 = (state_48958[(2)]);
var inst_48952 = cljs.core.async.close_BANG_(out);
var state_48958__$1 = (function (){var statearr_48997 = state_48958;
(statearr_48997[(13)] = inst_48951);

return statearr_48997;
})();
var statearr_48998_51039 = state_48958__$1;
(statearr_48998_51039[(2)] = inst_48952);

(statearr_48998_51039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (10))){
var inst_48941 = (state_48958[(2)]);
var state_48958__$1 = state_48958;
var statearr_48999_51040 = state_48958__$1;
(statearr_48999_51040[(2)] = inst_48941);

(statearr_48999_51040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48959 === (8))){
var inst_48926 = (state_48958[(10)]);
var inst_48922 = (state_48958[(9)]);
var inst_48918 = (state_48958[(8)]);
var inst_48931 = inst_48918.push(inst_48922);
var tmp48996 = inst_48918;
var inst_48918__$1 = tmp48996;
var inst_48919 = inst_48926;
var state_48958__$1 = (function (){var statearr_49000 = state_48958;
(statearr_49000[(7)] = inst_48919);

(statearr_49000[(14)] = inst_48931);

(statearr_49000[(8)] = inst_48918__$1);

return statearr_49000;
})();
var statearr_49001_51053 = state_48958__$1;
(statearr_49001_51053[(2)] = null);

(statearr_49001_51053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___50996,out))
;
return ((function (switch__46368__auto__,c__46663__auto___50996,out){
return (function() {
var cljs$core$async$state_machine__46369__auto__ = null;
var cljs$core$async$state_machine__46369__auto____0 = (function (){
var statearr_49002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49002[(0)] = cljs$core$async$state_machine__46369__auto__);

(statearr_49002[(1)] = (1));

return statearr_49002;
});
var cljs$core$async$state_machine__46369__auto____1 = (function (state_48958){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_48958);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e49003){if((e49003 instanceof Object)){
var ex__46372__auto__ = e49003;
var statearr_49004_51055 = state_48958;
(statearr_49004_51055[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48958);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49003;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51056 = state_48958;
state_48958 = G__51056;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
cljs$core$async$state_machine__46369__auto__ = function(state_48958){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46369__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46369__auto____1.call(this,state_48958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46369__auto____0;
cljs$core$async$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46369__auto____1;
return cljs$core$async$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50996,out))
})();
var state__46665__auto__ = (function (){var statearr_49005 = f__46664__auto__();
(statearr_49005[(6)] = c__46663__auto___50996);

return statearr_49005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50996,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=cljs.core.async.js.map
