(ns clograms.ui.main-screen
  (:require [clograms.ui.utils :as utils :refer [run-now run-later event-handler]])
  (:import [javafx.scene Scene SceneBuilder]
           [javafx.stage Stage StageBuilder]
           [javafx.embed.swing JFXPanel]
           [javafx.scene.layout VBoxBuilder]
           [javafx.scene.control ButtonBuilder]))

(defonce force-toolkit-init (javafx.embed.swing.JFXPanel.))


(defn build-root-cmp []
  (.. VBoxBuilder create
      (minHeight 480)
      (minWidth 640)
      (children [(.. ButtonBuilder create
                     (text "Say \"Hello Clojureeeeee\"!")
                     (onAction (event-handler [_] (println "Hello Clojure!")))
                     build)])
      build))

(defn build-stage [root-cmp]
  (.. StageBuilder create
      (title "Hello JavaFX")
      (scene (.. SceneBuilder create
                 (height 480)
                 (width 640)
                 (root root-cmp)
                 build))
      build))

(def stage (atom nil))

(comment

  (run-now (reset! stage (build-stage (build-root-cmp))))
  (run-now (.show @stage))

  )
