(ns clograms.ui.fastfx-workbench
  (:require [clograms.ui.fastfx :as ffx]
            [clograms.ui.compute-graph :as cg]))

(def basic-root-cmp-desc
  {:fx/type :javafx.stage.Stage
   :title "Hello World"
   :min-width 300
   :min-height 300
   :scene {:fx/type :javafx.scene.Scene
           :fx/ctor-args [{:fx/type :javafx.scene.layout.HBox
                           :children [{:fx/type :javafx.scene.text.Text
                                       :text [:<< ::cg/root :txt-text]}
                                      {:fx/type :javafx.scene.control.Button
                                       :text [:<< ::cg/root :btn-text]}]}]}})

(def basic-state {:btn-text "Button"
                  :txt-text "Some text"})

(def basic-c-graph (cg/make-naive-compute-graph))


(comment


  (ffx/re-render basic-root-cmp-desc
                 basic-c-graph
                 basic-state)

  )
