goog.provide('taoensso.sente');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('taoensso.encore');
goog.require('taoensso.timbre');
goog.require('taoensso.sente.interfaces');
if(cljs.core.vector_QMARK_(taoensso.encore.encore_version)){
taoensso.encore.assert_min_encore_version(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(105),(0)], null));
} else {
taoensso.encore.assert_min_encore_version(2.105);
}
/**
 * Useful for identifying client/server mismatch
 */
taoensso.sente.sente_version = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(11),(0)], null);
taoensso.sente.node_target_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs");
if((typeof taoensso !== 'undefined') && (typeof taoensso.sente !== 'undefined') && (typeof taoensso.sente.debug_mode_QMARK__ !== 'undefined')){
} else {
taoensso.sente.debug_mode_QMARK__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
}
taoensso.sente.expected = (function taoensso$sente$expected(expected,x){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"expected","expected",1583670997),expected,new cljs.core.Keyword(null,"actual","actual",107306363),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword(null,"value","value",305978217),x], null)], null);
});
/**
 * Returns nil if given argument is a valid [ev-id ?ev-data] form. Otherwise
 *   returns a map of validation errors like `{:wrong-type {:expected _ :actual _}}`.
 */
taoensso.sente.validate_event = (function taoensso$sente$validate_event(x){
if((!(cljs.core.vector_QMARK_(x)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wrong-type","wrong-type",929556915),taoensso.sente.expected(new cljs.core.Keyword(null,"vector","vector",1902966158),x)], null);
} else {
if(cljs.core.not((function (){var G__85454 = cljs.core.count(x);
var fexpr__85453 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null);
return (fexpr__85453.cljs$core$IFn$_invoke$arity$1 ? fexpr__85453.cljs$core$IFn$_invoke$arity$1(G__85454) : fexpr__85453.call(null,G__85454));
})())){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wrong-length","wrong-length",1367572281),taoensso.sente.expected(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null),x)], null);
} else {
var vec__85459 = x;
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85459,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85459,(1),null);
if((!((ev_id instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wrong-id-type","wrong-id-type",-1213601689),taoensso.sente.expected(new cljs.core.Keyword(null,"keyword","keyword",811389747),ev_id)], null);
} else {
if(cljs.core.not(cljs.core.namespace(ev_id))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"unnamespaced-id","unnamespaced-id",1976189772),taoensso.sente.expected(new cljs.core.Keyword(null,"namespaced-keyword","namespaced-keyword",131372895),ev_id)], null);
} else {
return null;

}
}

}
}
});
/**
 * Returns given argument if it is a valid [ev-id ?ev-data] form. Otherwise
 *   throws a validation exception.
 */
taoensso.sente.assert_event = (function taoensso$sente$assert_event(x){
var temp__5818__auto__ = taoensso.sente.validate_event(x);
if(cljs.core.truth_(temp__5818__auto__)){
var errs = temp__5818__auto__;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid event",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"given","given",716253602),x,new cljs.core.Keyword(null,"errors","errors",-908790718),errs], null));
} else {
return null;
}
});
/**
 * Valid [ev-id ?ev-data] form?
 */
taoensso.sente.event_QMARK_ = (function taoensso$sente$event_QMARK_(x){
return (taoensso.sente.validate_event(x) == null);
});
taoensso.sente.as_event = (function taoensso$sente$as_event(x){
var temp__5816__auto__ = taoensso.sente.validate_event(x);
if(cljs.core.truth_(temp__5816__auto__)){
var errs = temp__5816__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-event","chsk/bad-event",-565206930),x], null);
} else {
return x;
}
});
taoensso.sente.client_event_msg_QMARK_ = (function taoensso$sente$client_event_msg_QMARK_(x){
var and__4120__auto__ = cljs.core.map_QMARK_(x);
if(and__4120__auto__){
var and__4120__auto____$1 = taoensso.encore.ks_EQ_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null),x);
if(and__4120__auto____$1){
var map__85507 = x;
var map__85507__$1 = (((((!((map__85507 == null))))?(((((map__85507.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85507.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85507):map__85507);
var ch_recv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85507__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85507__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85507__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85507__$1,new cljs.core.Keyword(null,"event","event",301435442));
return ((taoensso.encore.chan_QMARK_(ch_recv)) && (cljs.core.ifn_QMARK_(send_fn)) && (taoensso.encore.atom_QMARK_(state)) && (taoensso.sente.event_QMARK_(event)));
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});
taoensso.sente.server_event_msg_QMARK_ = (function taoensso$sente$server_event_msg_QMARK_(x){
var and__4120__auto__ = cljs.core.map_QMARK_(x);
if(and__4120__auto__){
var and__4120__auto____$1 = taoensso.encore.ks_EQ_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),null,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),null,new cljs.core.Keyword(null,"uid","uid",-1447769400),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null),x);
if(and__4120__auto____$1){
var map__85561 = x;
var map__85561__$1 = (((((!((map__85561 == null))))?(((((map__85561.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85561.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85561):map__85561);
var ch_recv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85561__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85561__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var connected_uids = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85561__$1,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231));
var ring_req = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85561__$1,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961));
var client_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85561__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85561__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85561__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
return ((taoensso.encore.chan_QMARK_(ch_recv)) && (cljs.core.ifn_QMARK_(send_fn)) && (taoensso.encore.atom_QMARK_(connected_uids)) && (cljs.core.map_QMARK_(ring_req)) && (taoensso.encore.nblank_str_QMARK_(client_id)) && (taoensso.sente.event_QMARK_(event)) && ((((_QMARK_reply_fn == null)) || (cljs.core.ifn_QMARK_(_QMARK_reply_fn)))));
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});
/**
 * All server `event-msg`s go through this
 */
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_ = (function taoensso$sente$put_server_event_msg_GT_ch_recv_BANG_(ch_recv,p__85585){
var map__85586 = p__85585;
var map__85586__$1 = (((((!((map__85586 == null))))?(((((map__85586.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85586.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85586):map__85586);
var ev_msg = map__85586__$1;
var event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85586__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85586__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var vec__85597 = taoensso.sente.as_event(event);
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85597,(0),null);
var ev__QMARK_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85597,(1),null);
var valid_event = vec__85597;
var ev_msg_STAR_ = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ev_msg,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"event","event",301435442),valid_event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null)], 0));
if((!(taoensso.sente.server_event_msg_QMARK_(ev_msg_STAR_)))){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,189,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__85597,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__85586,map__85586__$1,ev_msg,event,_QMARK_reply_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad ev-msg: %s",ev_msg], null);
});})(vec__85597,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__85586,map__85586__$1,ev_msg,event,_QMARK_reply_fn))
,null)),null,1336087030);
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch_recv,ev_msg_STAR_);
}
});
taoensso.sente.cb_error_QMARK_ = (function taoensso$sente$cb_error_QMARK_(cb_reply_clj){
var fexpr__85612 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264),null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439),null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489),null], null), null);
return (fexpr__85612.cljs$core$IFn$_invoke$arity$1 ? fexpr__85612.cljs$core$IFn$_invoke$arity$1(cb_reply_clj) : fexpr__85612.call(null,cb_reply_clj));
});
taoensso.sente.cb_success_QMARK_ = (function taoensso$sente$cb_success_QMARK_(cb_reply_clj){
return cljs.core.not(taoensso.sente.cb_error_QMARK_(cb_reply_clj));
});
/**
 * prefixed-pstr->[clj ?cb-uuid]
 */
taoensso.sente.unpack = (function taoensso$sente$unpack(packer,prefixed_pstr){
if(typeof prefixed_pstr === 'string'){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",203,"(string? prefixed-pstr)",prefixed_pstr,null,null);
}

var wrapped_QMARK_ = taoensso.encore.str_starts_with_QMARK_(prefixed_pstr,"+");
var pstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(prefixed_pstr,(1));
var clj = (function (){try{return taoensso.sente.interfaces.unpack(packer,pstr);
}catch (e85636){var t = e85636;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente",null,210,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (t,wrapped_QMARK_,pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad package: %s (%s)",pstr,t], null);
});})(t,wrapped_QMARK_,pstr))
,null)),null,1727396023);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-package","chsk/bad-package",501893679),pstr], null);
}})();
var vec__85633 = ((wrapped_QMARK_)?clj:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,null], null));
var clj__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85633,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85633,(1),null);
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),_QMARK_cb_uuid))?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):_QMARK_cb_uuid);
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,216,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (wrapped_QMARK_,pstr,clj,vec__85633,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unpacking: %s -> %s",prefixed_pstr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null)], null);
});})(wrapped_QMARK_,pstr,clj,vec__85633,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1))
,null)),null,-1243912260);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null);
});
/**
 * clj->prefixed-pstr
 */
taoensso.sente.pack = (function taoensso$sente$pack(var_args){
var G__85648 = arguments.length;
switch (G__85648) {
case 2:
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$2 = (function (packer,clj){
var pstr = ["-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack(packer,clj))].join('');
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,223,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Packing (unwrapped): %s -> %s",clj,pstr], null);
});})(pstr))
,null)),null,-2134170373);

return pstr;
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$3 = (function (packer,clj,_QMARK_cb_uuid){
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_cb_uuid,new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321)))?(0):_QMARK_cb_uuid);
var wrapped_clj = (cljs.core.truth_(_QMARK_cb_uuid__$1)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,_QMARK_cb_uuid__$1], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj], null));
var pstr = ["+",cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack(packer,wrapped_clj))].join('');
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,232,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (_QMARK_cb_uuid__$1,wrapped_clj,pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Packing (wrapped): %s -> %s",wrapped_clj,pstr], null);
});})(_QMARK_cb_uuid__$1,wrapped_clj,pstr))
,null)),null,-316164204);

return pstr;
});

taoensso.sente.pack.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {taoensso.sente.interfaces.IPacker}
*/
taoensso.sente.EdnPacker = (function (){
});
taoensso.sente.EdnPacker.prototype.taoensso$sente$interfaces$IPacker$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.EdnPacker.prototype.taoensso$sente$interfaces$IPacker$pack$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return taoensso.encore.pr_edn.cljs$core$IFn$_invoke$arity$1(x);
});

taoensso.sente.EdnPacker.prototype.taoensso$sente$interfaces$IPacker$unpack$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return taoensso.encore.read_edn.cljs$core$IFn$_invoke$arity$1(s);
});

taoensso.sente.EdnPacker.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

taoensso.sente.EdnPacker.cljs$lang$type = true;

taoensso.sente.EdnPacker.cljs$lang$ctorStr = "taoensso.sente/EdnPacker";

taoensso.sente.EdnPacker.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"taoensso.sente/EdnPacker");
});

/**
 * Positional factory function for taoensso.sente/EdnPacker.
 */
taoensso.sente.__GT_EdnPacker = (function taoensso$sente$__GT_EdnPacker(){
return (new taoensso.sente.EdnPacker());
});

taoensso.sente.default_edn_packer = (new taoensso.sente.EdnPacker());
taoensso.sente.coerce_packer = (function taoensso$sente$coerce_packer(x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.Keyword(null,"edn","edn",1317840885))){
return taoensso.sente.default_edn_packer;
} else {
var e = (function (){try{if((function (){var fexpr__85681 = (function (p1__85664_SHARP_){
if((!((p1__85664_SHARP_ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__85664_SHARP_.taoensso$sente$interfaces$IPacker$)))){
return true;
} else {
if((!p1__85664_SHARP_.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(taoensso.sente.interfaces.IPacker,p1__85664_SHARP_);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(taoensso.sente.interfaces.IPacker,p1__85664_SHARP_);
}
});
return fexpr__85681(x);
})()){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e85674){if((e85674 instanceof Error)){
var e = e85674;
return e;
} else {
throw e85674;

}
}})();
if((e == null)){
return x;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",245,"((fn* [p1__85664#] (satisfies? interfaces/IPacker p1__85664#)) x)",x,e,null);
}
}
});
taoensso.sente.next_idx_BANG_ = (taoensso.encore.idx_fn.cljs$core$IFn$_invoke$arity$0 ? taoensso.encore.idx_fn.cljs$core$IFn$_invoke$arity$0() : taoensso.encore.idx_fn.call(null));


taoensso.sente.bad_origin_QMARK_ = (function taoensso$sente$bad_origin_QMARK_(allowed_origins,p__85689){
var map__85690 = p__85689;
var map__85690__$1 = (((((!((map__85690 == null))))?(((((map__85690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85690):map__85690);
var ring_req = map__85690__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85690__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var origin = cljs.core.get.cljs$core$IFn$_invoke$arity$2(headers,"origin");
var referer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(headers,"referer","");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(allowed_origins,new cljs.core.Keyword(null,"all","all",892129742))){
return false;
} else {
if(cljs.core.contains_QMARK_(cljs.core.set(allowed_origins),origin)){
return false;
} else {
if(cljs.core.truth_(taoensso.encore.rsome(((function (origin,referer,map__85690,map__85690__$1,ring_req,headers){
return (function (p1__85688_SHARP_){
return clojure.string.starts_with_QMARK_(referer,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__85688_SHARP_),"/"].join(''));
});})(origin,referer,map__85690,map__85690__$1,ring_req,headers))
,allowed_origins))){
return false;
} else {
return true;

}
}
}
});
/**
 * Takes a web server adapter[1] and returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *  :send-fn ; (fn [user-id ev] for server>user push.
 *  :ajax-post-fn                ; (fn [ring-req]) for Ring CSRF-POST + chsk URL.
 *  :ajax-get-or-ws-handshake-fn ; (fn [ring-req]) for Ring GET + chsk URL.
 *  :connected-uids ; Watchable, read-only (atom {:ws #{_} :ajax #{_} :any #{_}}).
 * 
 *   Common options:
 *  :user-id-fn        ;  (fn [ring-req]) -> unique user-id for server>user push.
 *  :csrf-token-fn     ; ?(fn [ring-req]) -> CSRF-token for Ajax POSTs and WS handshake.
 *                     ;                     CSRF check will be skipped iff nil (NOT RECOMMENDED!).
 *  :handshake-data-fn ; (fn [ring-req]) -> arb user data to append to handshake evs.
 *  :ws-kalive-ms      ; Ping to keep a WebSocket conn alive if no activity
 *                     ; w/in given msecs. Should be different to client's :ws-kalive-ms.
 *  :lp-timeout-ms     ; Timeout (repoll) long-polling Ajax conns after given msecs.
 *  :send-buf-ms-ajax  ; [2]
 *  :send-buf-ms-ws    ; [2]
 *  :packer            ; :edn (default), or an IPacker implementation.
 *  :allowed-origins   ; e.g. #{"http://site.com" ...}, defaults to :all. ; Alpha
 * 
 *   [1] e.g. `(taoensso.sente.server-adapters.http-kit/get-sch-adapter)` or
 *         `(taoensso.sente.server-adapters.immutant/get-sch-adapter)`.
 *    You must have the necessary web-server dependency in your project.clj and
 *    the necessary entry in your namespace's `ns` form.
 * 
 *   [2] Optimization to allow transparent batching of rapidly-triggered
 *    server>user pushes. This is esp. important for Ajax clients which use a
 *    (slow) reconnecting poller. Actual event dispatch may occur <= given ms
 *    after send call (larger values => larger batch windows).
 */
taoensso.sente.make_channel_socket_server_BANG_ = (function taoensso$sente$make_channel_socket_server_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___87320 = arguments.length;
var i__4731__auto___87321 = (0);
while(true){
if((i__4731__auto___87321 < len__4730__auto___87320)){
args__4736__auto__.push((arguments[i__4731__auto___87321]));

var G__87322 = (i__4731__auto___87321 + (1));
i__4731__auto___87321 = G__87322;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (web_server_ch_adapter,p__85722){
var vec__85726 = p__85722;
var map__85729 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85726,(0),null);
var map__85729__$1 = (((((!((map__85729 == null))))?(((((map__85729.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85729.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85729):map__85729);
var ws_kalive_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"secs","secs",1532330091),(25)], 0)));
var send_buf_ms_ws = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"send-buf-ms-ws","send-buf-ms-ws",-1149586238),(30));
var allowed_origins = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"allowed-origins","allowed-origins",1477851683),new cljs.core.Keyword(null,"all","all",892129742));
var lp_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"lp-timeout-ms","lp-timeout-ms",-1451963133),taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"secs","secs",1532330091),(20)], 0)));
var csrf_token_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"csrf-token-fn","csrf-token-fn",-1846298394),((function (vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms){
return (function (ring_req){
var or__4131__auto__ = new cljs.core.Keyword(null,"anti-forgery-token","anti-forgery-token",806990841).cljs$core$IFn$_invoke$arity$1(ring_req);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856)], null));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var or__4131__auto____$2 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword("ring.middleware.anti-forgery","anti-forgery-token","ring.middleware.anti-forgery/anti-forgery-token",571563484)], null));
if(cljs.core.truth_(or__4131__auto____$2)){
return or__4131__auto____$2;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),"__anti-forgery-token"], null));
}
}
}
});})(vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms))
);
var packer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
var send_buf_ms_ajax = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"send-buf-ms-ajax","send-buf-ms-ajax",1546129037),(100));
var bad_origin_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"bad-origin-fn","bad-origin-fn",1385595727),((function (vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax){
return (function (_ring_req){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(403),new cljs.core.Keyword(null,"body","body",-2049205669),"Unauthorized origin"], null);
});})(vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax))
);
var handshake_data_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"handshake-data-fn","handshake-data-fn",2011983089),((function (vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn){
return (function (ring_req){
return null;
});})(vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn))
);
var user_id_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"user-id-fn","user-id-fn",-1532150029),((function (vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn){
return (function (ring_req){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"uid","uid",-1447769400)], null));
});})(vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn))
);
var recv_buf_or_n = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer((1000)));
var bad_csrf_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85729__$1,new cljs.core.Keyword(null,"bad-csrf-fn","bad-csrf-fn",16619032),((function (vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n){
return (function (_ring_req){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(403),new cljs.core.Keyword(null,"body","body",-2049205669),"Bad CSRF token"], null);
});})(vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n))
);
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var e = (function (){try{if(taoensso.encore.pos_int_QMARK_(send_buf_ms_ajax)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e85742){if((e85742 instanceof Error)){
var e = e85742;
return e;
} else {
throw e85742;

}
}})();
if((e == null)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",345,"(enc/pos-int? send-buf-ms-ajax)",send_buf_ms_ajax,e,null);
}
})(),(function (){var e = (function (){try{if(taoensso.encore.pos_int_QMARK_(send_buf_ms_ws)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e85746){if((e85746 instanceof Error)){
var e = e85746;
return e;
} else {
throw e85746;

}
}})();
if((e == null)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",345,"(enc/pos-int? send-buf-ms-ws)",send_buf_ms_ws,e,null);
}
})()], null);

var e_87332 = (function (){try{if((function (){var fexpr__85753 = ((function (vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (p1__85697_SHARP_){
if((!((p1__85697_SHARP_ == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__85697_SHARP_.taoensso$sente$interfaces$IServerChanAdapter$)))){
return true;
} else {
if((!p1__85697_SHARP_.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(taoensso.sente.interfaces.IServerChanAdapter,p1__85697_SHARP_);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(taoensso.sente.interfaces.IServerChanAdapter,p1__85697_SHARP_);
}
});})(vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
return fexpr__85753(web_server_ch_adapter);
})()){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e85751){if((e85751 instanceof Error)){
var e = e85751;
return e;
} else {
throw e85751;

}
}})();
if((e_87332 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",346,"((fn* [p1__85697#] (satisfies? interfaces/IServerChanAdapter p1__85697#)) web-server-ch-adapter)",web_server_ch_adapter,e_87332,null);
}

var max_ms_87333 = taoensso.sente.default_client_side_ajax_timeout_ms;
if((lp_timeout_ms >= max_ms_87333)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([":lp-timeout-ms must be < ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_ms_87333)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lp-timeout-ms","lp-timeout-ms",-1451963133),lp_timeout_ms,new cljs.core.Keyword(null,"default-client-side-ajax-timeout-ms","default-client-side-ajax-timeout-ms",1149929762),max_ms_87333], null));
} else {
}

var allowed_origins__$1 = (cljs.core.truth_((function (){var fexpr__85762 = ((function (vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (x){
var or__4131__auto__ = cljs.core.set_QMARK_(x);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var fexpr__85767 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all","all",892129742),null], null), null);
return (fexpr__85767.cljs$core$IFn$_invoke$arity$1 ? fexpr__85767.cljs$core$IFn$_invoke$arity$1(x) : fexpr__85767.call(null,x));
}
});})(vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
return fexpr__85762(allowed_origins);
})())?allowed_origins:taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",355,"([:or set? #{:all}] allowed-origins)",allowed_origins,null,null));
var packer__$1 = taoensso.sente.coerce_packer(packer);
var ch_recv = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(recv_buf_or_n);
var user_id_fn__$1 = ((function (allowed_origins__$1,packer__$1,ch_recv,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (ring_req,client_id){
var or__4131__auto__ = (function (){var G__85773 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ring_req,new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id);
return (user_id_fn.cljs$core$IFn$_invoke$arity$1 ? user_id_fn.cljs$core$IFn$_invoke$arity$1(G__85773) : user_id_fn.call(null,G__85773));
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486);
}
});})(allowed_origins__$1,packer__$1,ch_recv,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
var conns_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var send_buffers_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var connected_uids_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.PersistentHashSet.EMPTY], null));
var upd_conn_BANG_ = ((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() {
var G__87340 = null;
var G__87340__3 = (function (conn_type,uid,client_id){
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type,uid,client_id], null),((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (_QMARK_v){
var vec__85783 = _QMARK_v;
var _QMARK_sch = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85783,(0),null);
var _udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85783,(1),null);
var new_udt = taoensso.encore.now_udt();
return taoensso.encore.swapped(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_sch,new_udt], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"init?","init?",438181499),(_QMARK_v == null),new cljs.core.Keyword(null,"udt","udt",2011712751),new_udt,new cljs.core.Keyword(null,"?sch","?sch",2064493898),_QMARK_sch], null));
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);
});
var G__87340__4 = (function (conn_type,uid,client_id,new__QMARK_sch){
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type,uid,client_id], null),((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (_QMARK_v){
var new_udt = taoensso.encore.now_udt();
return taoensso.encore.swapped(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new__QMARK_sch,new_udt], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"init?","init?",438181499),(_QMARK_v == null),new cljs.core.Keyword(null,"udt","udt",2011712751),new_udt,new cljs.core.Keyword(null,"?sch","?sch",2064493898),new__QMARK_sch], null));
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);
});
G__87340 = function(conn_type,uid,client_id,new__QMARK_sch){
switch(arguments.length){
case 3:
return G__87340__3.call(this,conn_type,uid,client_id);
case 4:
return G__87340__4.call(this,conn_type,uid,client_id,new__QMARK_sch);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__87340.cljs$core$IFn$_invoke$arity$3 = G__87340__3;
G__87340.cljs$core$IFn$_invoke$arity$4 = G__87340__4;
return G__87340;
})()
;})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
var connect_uid_BANG_ = ((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (conn_type,uid){
if(cljs.core.truth_((function (){var e = (function (){try{if(taoensso.truss.impl.some_QMARK_(uid)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e85790){if((e85790 instanceof Error)){
var e = e85790;
return e;
} else {
throw e85790;

}
}})();
if((e == null)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",391,"(taoensso.truss.impl/some? uid)",uid,e,null);
}
})())){
} else {
throw (new Error("Assert failed: (have? uid)"));
}

var newly_connected_QMARK_ = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(connected_uids_,cljs.core.PersistentVector.EMPTY,((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (p__85791){
var map__85792 = p__85791;
var map__85792__$1 = (((((!((map__85792 == null))))?(((((map__85792.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85792.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85792):map__85792);
var old_m = map__85792__$1;
var ws = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85792__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85792__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85792__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var new_m = (function (){var G__85794 = conn_type;
var G__85794__$1 = (((G__85794 instanceof cljs.core.Keyword))?G__85794.fqn:null);
switch (G__85794__$1) {
case "ws":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ws,uid),new cljs.core.Keyword(null,"ajax","ajax",814345549),ajax__$1,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(any,uid)], null);

break;
case "ajax":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),ws,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ajax__$1,uid),new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(any,uid)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__85794__$1)].join('')));

}
})();
return taoensso.encore.swapped(new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((((!(cljs.core.contains_QMARK_(old_any,uid)))) && (cljs.core.contains_QMARK_(new_any,uid)))){
return new cljs.core.Keyword(null,"newly-connected","newly-connected",-2029862681);
} else {
return null;
}
})());
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);
return newly_connected_QMARK_;
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
var upd_connected_uid_BANG_ = ((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (uid){
if(cljs.core.truth_((function (){var e = (function (){try{if(taoensso.truss.impl.some_QMARK_(uid)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e85795){if((e85795 instanceof Error)){
var e = e85795;
return e;
} else {
throw e85795;

}
}})();
if((e == null)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",408,"(taoensso.truss.impl/some? uid)",uid,e,null);
}
})())){
} else {
throw (new Error("Assert failed: (have? uid)"));
}

var newly_disconnected_QMARK_ = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(connected_uids_,cljs.core.PersistentVector.EMPTY,((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (p__85796){
var map__85797 = p__85796;
var map__85797__$1 = (((((!((map__85797 == null))))?(((((map__85797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85797.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85797):map__85797);
var old_m = map__85797__$1;
var ws = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85797__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85797__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85797__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var conns_SINGLEQUOTE_ = cljs.core.deref(conns_);
var any_ws_clients_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ws","ws",86841443).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_ajax_clients_QMARK_ = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ajax","ajax",814345549).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_clients_QMARK_ = ((any_ws_clients_QMARK_) || (any_ajax_clients_QMARK_));
var new_m = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),((any_ws_clients_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ws,uid):cljs.core.disj.cljs$core$IFn$_invoke$arity$2(ws,uid)),new cljs.core.Keyword(null,"ajax","ajax",814345549),((any_ajax_clients_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ajax__$1,uid):cljs.core.disj.cljs$core$IFn$_invoke$arity$2(ajax__$1,uid)),new cljs.core.Keyword(null,"any","any",1705907423),((any_clients_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(any,uid):cljs.core.disj.cljs$core$IFn$_invoke$arity$2(any,uid))], null);
return taoensso.encore.swapped(new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if(((cljs.core.contains_QMARK_(old_any,uid)) && ((!(cljs.core.contains_QMARK_(new_any,uid)))))){
return new cljs.core.Keyword(null,"newly-disconnected","newly-disconnected",-1586164962);
} else {
return null;
}
})());
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);
return newly_disconnected_QMARK_;
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
var send_fn = ((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() { 
var G__87430__delegate = function (user_id,ev,p__85804){
var vec__85805 = p__85804;
var map__85808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85805,(0),null);
var map__85808__$1 = (((((!((map__85808 == null))))?(((((map__85808.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__85808.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__85808):map__85808);
var opts = map__85808__$1;
var flush_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85808__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var uid_87431 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(user_id,new cljs.core.Keyword("sente","all-users-without-uid","sente/all-users-without-uid",-42979578)))?new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486):user_id);
var __87432 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,434,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (uid_87431,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (->uid %s) %s",uid_87431,ev], null);
});})(uid_87431,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,2034919495);
var __87433__$1 = (cljs.core.truth_(uid_87431)?null:(function(){throw (new Error(["Assert failed: ",["Support for sending to `nil` user-ids has been REMOVED. ","Please send to `:sente/all-users-without-uid` instead."].join(''),"\n","uid"].join('')))})());
var __87434__$2 = taoensso.sente.assert_event(ev);
var ev_uuid_87435 = taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
var flush_buffer_BANG__87436 = ((function (uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (conn_type){
var temp__5818__auto__ = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(send_buffers_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type], null),((function (uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (m){
var vec__85812 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,uid_87431);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85812,(0),null);
var ev_uuids = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85812,(1),null);
if(cljs.core.contains_QMARK_(ev_uuids,ev_uuid_87435)){
return taoensso.encore.swapped(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,uid_87431),cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,uid_87431));
} else {
return taoensso.encore.swapped(m,null);
}
});})(uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);
if(cljs.core.truth_(temp__5818__auto__)){
var pulled = temp__5818__auto__;
var vec__85815 = pulled;
var buffered_evs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85815,(0),null);
var ev_uuids = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85815,(1),null);
if(cljs.core.vector_QMARK_(buffered_evs)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",461,"(vector? buffered-evs)",buffered_evs,null,null);
}

if(cljs.core.set_QMARK_(ev_uuids)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",462,"(set? ev-uuids)",ev_uuids,null,null);
}

var buffered_evs_ppstr = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$2(packer__$1,buffered_evs);
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,465,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (buffered_evs_ppstr,vec__85815,buffered_evs,ev_uuids,pulled,temp__5818__auto__,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["buffered-evs-ppstr: %s",buffered_evs_ppstr], null);
});})(buffered_evs_ppstr,vec__85815,buffered_evs,ev_uuids,pulled,temp__5818__auto__,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,-230735505);

var G__85820 = conn_type;
var G__85820__$1 = (((G__85820 instanceof cljs.core.Keyword))?G__85820.fqn:null);
switch (G__85820__$1) {
case "ws":
return (taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_.cljs$core$IFn$_invoke$arity$4 ? taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_.cljs$core$IFn$_invoke$arity$4(conns_,uid_87431,buffered_evs_ppstr,upd_conn_BANG_) : taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_.call(null,conns_,uid_87431,buffered_evs_ppstr,upd_conn_BANG_));

break;
case "ajax":
return (taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$3 ? taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.cljs$core$IFn$_invoke$arity$3(conns_,uid_87431,buffered_evs_ppstr) : taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.call(null,conns_,uid_87431,buffered_evs_ppstr));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__85820__$1)].join('')));

}
} else {
return null;
}
});})(uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ev,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","close","chsk/close",1840295819)], null))){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente",null,474,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk closing (client may reconnect): %s",uid_87431], null);
});})(uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,1008757315);

if(cljs.core.truth_(flush_QMARK_)){
flush_buffer_BANG__87436(new cljs.core.Keyword(null,"ws","ws",86841443));

flush_buffer_BANG__87436(new cljs.core.Keyword(null,"ajax","ajax",814345549));
} else {
}

var seq__85821_87451 = cljs.core.seq(cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid_87431], null))));
var chunk__85822_87452 = null;
var count__85823_87453 = (0);
var i__85824_87454 = (0);
while(true){
if((i__85824_87454 < count__85823_87453)){
var vec__85834_87455 = chunk__85822_87452.cljs$core$IIndexed$_nth$arity$2(null,i__85824_87454);
var _QMARK_sch_87456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85834_87455,(0),null);
var _udt_87457 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85834_87455,(1),null);
var temp__5818__auto___87459 = _QMARK_sch_87456;
if(cljs.core.truth_(temp__5818__auto___87459)){
var sch_87460 = temp__5818__auto___87459;
taoensso.sente.interfaces.sch_close_BANG_(sch_87460);
} else {
}


var G__87462 = seq__85821_87451;
var G__87463 = chunk__85822_87452;
var G__87464 = count__85823_87453;
var G__87465 = (i__85824_87454 + (1));
seq__85821_87451 = G__87462;
chunk__85822_87452 = G__87463;
count__85823_87453 = G__87464;
i__85824_87454 = G__87465;
continue;
} else {
var temp__5818__auto___87467 = cljs.core.seq(seq__85821_87451);
if(temp__5818__auto___87467){
var seq__85821_87468__$1 = temp__5818__auto___87467;
if(cljs.core.chunked_seq_QMARK_(seq__85821_87468__$1)){
var c__4550__auto___87470 = cljs.core.chunk_first(seq__85821_87468__$1);
var G__87472 = cljs.core.chunk_rest(seq__85821_87468__$1);
var G__87473 = c__4550__auto___87470;
var G__87474 = cljs.core.count(c__4550__auto___87470);
var G__87475 = (0);
seq__85821_87451 = G__87472;
chunk__85822_87452 = G__87473;
count__85823_87453 = G__87474;
i__85824_87454 = G__87475;
continue;
} else {
var vec__85837_87477 = cljs.core.first(seq__85821_87468__$1);
var _QMARK_sch_87478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85837_87477,(0),null);
var _udt_87479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85837_87477,(1),null);
var temp__5818__auto___87481__$1 = _QMARK_sch_87478;
if(cljs.core.truth_(temp__5818__auto___87481__$1)){
var sch_87482 = temp__5818__auto___87481__$1;
taoensso.sente.interfaces.sch_close_BANG_(sch_87482);
} else {
}


var G__87483 = cljs.core.next(seq__85821_87468__$1);
var G__87484 = null;
var G__87485 = (0);
var G__87486 = (0);
seq__85821_87451 = G__87483;
chunk__85822_87452 = G__87484;
count__85823_87453 = G__87485;
i__85824_87454 = G__87486;
continue;
}
} else {
}
}
break;
}

var seq__85840_87488 = cljs.core.seq(cljs.core.vals(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid_87431], null))));
var chunk__85841_87489 = null;
var count__85842_87490 = (0);
var i__85843_87491 = (0);
while(true){
if((i__85843_87491 < count__85842_87490)){
var vec__85850_87492 = chunk__85841_87489.cljs$core$IIndexed$_nth$arity$2(null,i__85843_87491);
var _QMARK_sch_87493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85850_87492,(0),null);
var _udt_87494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85850_87492,(1),null);
var temp__5818__auto___87496 = _QMARK_sch_87493;
if(cljs.core.truth_(temp__5818__auto___87496)){
var sch_87497 = temp__5818__auto___87496;
taoensso.sente.interfaces.sch_close_BANG_(sch_87497);
} else {
}


var G__87498 = seq__85840_87488;
var G__87499 = chunk__85841_87489;
var G__87500 = count__85842_87490;
var G__87501 = (i__85843_87491 + (1));
seq__85840_87488 = G__87498;
chunk__85841_87489 = G__87499;
count__85842_87490 = G__87500;
i__85843_87491 = G__87501;
continue;
} else {
var temp__5818__auto___87503 = cljs.core.seq(seq__85840_87488);
if(temp__5818__auto___87503){
var seq__85840_87504__$1 = temp__5818__auto___87503;
if(cljs.core.chunked_seq_QMARK_(seq__85840_87504__$1)){
var c__4550__auto___87505 = cljs.core.chunk_first(seq__85840_87504__$1);
var G__87506 = cljs.core.chunk_rest(seq__85840_87504__$1);
var G__87507 = c__4550__auto___87505;
var G__87508 = cljs.core.count(c__4550__auto___87505);
var G__87509 = (0);
seq__85840_87488 = G__87506;
chunk__85841_87489 = G__87507;
count__85842_87490 = G__87508;
i__85843_87491 = G__87509;
continue;
} else {
var vec__85853_87510 = cljs.core.first(seq__85840_87504__$1);
var _QMARK_sch_87511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85853_87510,(0),null);
var _udt_87512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85853_87510,(1),null);
var temp__5818__auto___87514__$1 = _QMARK_sch_87511;
if(cljs.core.truth_(temp__5818__auto___87514__$1)){
var sch_87515 = temp__5818__auto___87514__$1;
taoensso.sente.interfaces.sch_close_BANG_(sch_87515);
} else {
}


var G__87516 = cljs.core.next(seq__85840_87504__$1);
var G__87517 = null;
var G__87518 = (0);
var G__87519 = (0);
seq__85840_87488 = G__87516;
chunk__85841_87489 = G__87517;
count__85842_87490 = G__87518;
i__85843_87491 = G__87519;
continue;
}
} else {
}
}
break;
}
} else {
var seq__85856_87520 = cljs.core.seq(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"ajax","ajax",814345549)], null));
var chunk__85857_87521 = null;
var count__85858_87522 = (0);
var i__85859_87523 = (0);
while(true){
if((i__85859_87523 < count__85858_87522)){
var conn_type_87525 = chunk__85857_87521.cljs$core$IIndexed$_nth$arity$2(null,i__85859_87523);
taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type_87525,uid_87431], null),((function (seq__85856_87520,chunk__85857_87521,count__85858_87522,i__85859_87523,conn_type_87525,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (_QMARK_v){
if(cljs.core.not(_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.createAsIfByAssoc([ev_uuid_87435])], null);
} else {
var vec__85866 = _QMARK_v;
var buffered_evs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85866,(0),null);
var ev_uuids = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85866,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(buffered_evs,ev),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ev_uuids,ev_uuid_87435)], null);
}
});})(seq__85856_87520,chunk__85857_87521,count__85858_87522,i__85859_87523,conn_type_87525,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);


var G__87529 = seq__85856_87520;
var G__87530 = chunk__85857_87521;
var G__87531 = count__85858_87522;
var G__87532 = (i__85859_87523 + (1));
seq__85856_87520 = G__87529;
chunk__85857_87521 = G__87530;
count__85858_87522 = G__87531;
i__85859_87523 = G__87532;
continue;
} else {
var temp__5818__auto___87533 = cljs.core.seq(seq__85856_87520);
if(temp__5818__auto___87533){
var seq__85856_87535__$1 = temp__5818__auto___87533;
if(cljs.core.chunked_seq_QMARK_(seq__85856_87535__$1)){
var c__4550__auto___87536 = cljs.core.chunk_first(seq__85856_87535__$1);
var G__87538 = cljs.core.chunk_rest(seq__85856_87535__$1);
var G__87539 = c__4550__auto___87536;
var G__87540 = cljs.core.count(c__4550__auto___87536);
var G__87541 = (0);
seq__85856_87520 = G__87538;
chunk__85857_87521 = G__87539;
count__85858_87522 = G__87540;
i__85859_87523 = G__87541;
continue;
} else {
var conn_type_87542 = cljs.core.first(seq__85856_87535__$1);
taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type_87542,uid_87431], null),((function (seq__85856_87520,chunk__85857_87521,count__85858_87522,i__85859_87523,conn_type_87542,seq__85856_87535__$1,temp__5818__auto___87533,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (_QMARK_v){
if(cljs.core.not(_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.createAsIfByAssoc([ev_uuid_87435])], null);
} else {
var vec__85869 = _QMARK_v;
var buffered_evs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85869,(0),null);
var ev_uuids = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85869,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(buffered_evs,ev),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ev_uuids,ev_uuid_87435)], null);
}
});})(seq__85856_87520,chunk__85857_87521,count__85858_87522,i__85859_87523,conn_type_87542,seq__85856_87535__$1,temp__5818__auto___87533,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);


var G__87547 = cljs.core.next(seq__85856_87535__$1);
var G__87548 = null;
var G__87549 = (0);
var G__87550 = (0);
seq__85856_87520 = G__87547;
chunk__85857_87521 = G__87548;
count__85858_87522 = G__87549;
i__85859_87523 = G__87550;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(flush_QMARK_)){
flush_buffer_BANG__87436(new cljs.core.Keyword(null,"ws","ws",86841443));

flush_buffer_BANG__87436(new cljs.core.Keyword(null,"ajax","ajax",814345549));
} else {
var ws_timeout_87551 = cljs.core.async.timeout(send_buf_ms_ws);
var ajax_timeout_87552 = cljs.core.async.timeout(send_buf_ms_ajax);
var c__46663__auto___87554 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___87554,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___87554,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (state_85876){
var state_val_85877 = (state_85876[(1)]);
if((state_val_85877 === (1))){
var state_85876__$1 = state_85876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85876__$1,(2),ws_timeout_87551);
} else {
if((state_val_85877 === (2))){
var inst_85873 = (state_85876[(2)]);
var inst_85874 = flush_buffer_BANG__87436(new cljs.core.Keyword(null,"ws","ws",86841443));
var state_85876__$1 = (function (){var statearr_85878 = state_85876;
(statearr_85878[(7)] = inst_85873);

return statearr_85878;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_85876__$1,inst_85874);
} else {
return null;
}
}
});})(c__46663__auto___87554,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
return ((function (switch__46368__auto__,c__46663__auto___87554,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() {
var taoensso$sente$state_machine__46369__auto__ = null;
var taoensso$sente$state_machine__46369__auto____0 = (function (){
var statearr_85879 = [null,null,null,null,null,null,null,null];
(statearr_85879[(0)] = taoensso$sente$state_machine__46369__auto__);

(statearr_85879[(1)] = (1));

return statearr_85879;
});
var taoensso$sente$state_machine__46369__auto____1 = (function (state_85876){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_85876);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e85880){if((e85880 instanceof Object)){
var ex__46372__auto__ = e85880;
var statearr_85881_87564 = state_85876;
(statearr_85881_87564[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_85876);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85880;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87565 = state_85876;
state_85876 = G__87565;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$state_machine__46369__auto__ = function(state_85876){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__46369__auto____1.call(this,state_85876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__46369__auto____0;
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__46369__auto____1;
return taoensso$sente$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___87554,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var state__46665__auto__ = (function (){var statearr_85882 = f__46664__auto__();
(statearr_85882[(6)] = c__46663__auto___87554);

return statearr_85882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___87554,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);


var c__46663__auto___87569 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___87569,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___87569,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (state_85889){
var state_val_85890 = (state_85889[(1)]);
if((state_val_85890 === (1))){
var state_85889__$1 = state_85889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85889__$1,(2),ajax_timeout_87552);
} else {
if((state_val_85890 === (2))){
var inst_85886 = (state_85889[(2)]);
var inst_85887 = flush_buffer_BANG__87436(new cljs.core.Keyword(null,"ajax","ajax",814345549));
var state_85889__$1 = (function (){var statearr_85891 = state_85889;
(statearr_85891[(7)] = inst_85886);

return statearr_85891;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_85889__$1,inst_85887);
} else {
return null;
}
}
});})(c__46663__auto___87569,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
return ((function (switch__46368__auto__,c__46663__auto___87569,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() {
var taoensso$sente$state_machine__46369__auto__ = null;
var taoensso$sente$state_machine__46369__auto____0 = (function (){
var statearr_85892 = [null,null,null,null,null,null,null,null];
(statearr_85892[(0)] = taoensso$sente$state_machine__46369__auto__);

(statearr_85892[(1)] = (1));

return statearr_85892;
});
var taoensso$sente$state_machine__46369__auto____1 = (function (state_85889){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_85889);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e85893){if((e85893 instanceof Object)){
var ex__46372__auto__ = e85893;
var statearr_85894_87571 = state_85889;
(statearr_85894_87571[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_85889);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85893;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87573 = state_85889;
state_85889 = G__87573;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$state_machine__46369__auto__ = function(state_85889){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__46369__auto____1.call(this,state_85889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__46369__auto____0;
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__46369__auto____1;
return taoensso$sente$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___87569,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var state__46665__auto__ = (function (){var statearr_85895 = f__46664__auto__();
(statearr_85895[(6)] = c__46663__auto___87569);

return statearr_85895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___87569,ws_timeout_87551,ajax_timeout_87552,uid_87431,__87432,__87433__$1,__87434__$2,ev_uuid_87435,flush_buffer_BANG__87436,vec__85805,map__85808,map__85808__$1,opts,flush_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);

}
}

return null;
};
var G__87430 = function (user_id,ev,var_args){
var p__85804 = null;
if (arguments.length > 2) {
var G__87575__i = 0, G__87575__a = new Array(arguments.length -  2);
while (G__87575__i < G__87575__a.length) {G__87575__a[G__87575__i] = arguments[G__87575__i + 2]; ++G__87575__i;}
  p__85804 = new cljs.core.IndexedSeq(G__87575__a,0,null);
} 
return G__87430__delegate.call(this,user_id,ev,p__85804);};
G__87430.cljs$lang$maxFixedArity = 2;
G__87430.cljs$lang$applyTo = (function (arglist__87576){
var user_id = cljs.core.first(arglist__87576);
arglist__87576 = cljs.core.next(arglist__87576);
var ev = cljs.core.first(arglist__87576);
var p__85804 = cljs.core.rest(arglist__87576);
return G__87430__delegate(user_id,ev,p__85804);
});
G__87430.cljs$core$IFn$_invoke$arity$variadic = G__87430__delegate;
return G__87430;
})()
;})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
var bad_csrf_QMARK_ = ((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (ring_req){
if((csrf_token_fn == null)){
return false;
} else {
var temp__5816__auto__ = (csrf_token_fn.cljs$core$IFn$_invoke$arity$1 ? csrf_token_fn.cljs$core$IFn$_invoke$arity$1(ring_req) : csrf_token_fn.call(null,ring_req));
if(cljs.core.truth_(temp__5816__auto__)){
var reference_csrf_token = temp__5816__auto__;
var csrf_token_from_client = (function (){var or__4131__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856)], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"x-csrf-token"], null));
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"x-xsrf-token"], null));
}
}
})();
return cljs.core.not(taoensso.encore.const_str_EQ_(reference_csrf_token,csrf_token_from_client));
} else {
return true;
}
}
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
var ev_msg_const = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_], null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_,new cljs.core.Keyword(null,"ajax-post-fn","ajax-post-fn",1830071264),((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (ring_req){
if(bad_csrf_QMARK_(ring_req)){
return (bad_csrf_fn.cljs$core$IFn$_invoke$arity$1 ? bad_csrf_fn.cljs$core$IFn$_invoke$arity$1(ring_req) : bad_csrf_fn.call(null,ring_req));
} else {
if(taoensso.sente.bad_origin_QMARK_(allowed_origins__$1,ring_req)){
return (bad_origin_fn.cljs$core$IFn$_invoke$arity$1 ? bad_origin_fn.cljs$core$IFn$_invoke$arity$1(ring_req) : bad_origin_fn.call(null,ring_req));
} else {
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp(web_server_ch_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (server_ch,websocket_QMARK_){
if(cljs.core.not(websocket_QMARK_)){
} else {
throw (new Error("Assert failed: (not websocket?)"));
}

var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var ppstr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(params,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252));
var client_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var vec__85896 = taoensso.sente.unpack(packer__$1,ppstr);
var clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85896,(0),null);
var has_cb_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85896,(1),null);
var reply_fn = (function (){var replied_QMARK__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return ((function (replied_QMARK__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (resp_clj){
if(cljs.core.compare_and_set_BANG_(replied_QMARK__,false,true)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,571,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (replied_QMARK__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ajax post reply): %s",resp_clj], null);
});})(replied_QMARK__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,1200736067);

return taoensso.sente.interfaces.sch_send_BANG_(server_ch,websocket_QMARK_,taoensso.sente.pack.cljs$core$IFn$_invoke$arity$2(packer__$1,resp_clj));
} else {
return null;
}
});
;})(replied_QMARK__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_(ch_recv,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),clj,new cljs.core.Keyword(null,"uid","uid",-1447769400),user_id_fn__$1(ring_req,client_id),new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),(cljs.core.truth_(has_cb_QMARK_)?reply_fn:null)], null)], 0)));

if(cljs.core.truth_(has_cb_QMARK_)){
var temp__5818__auto__ = lp_timeout_ms;
if(cljs.core.truth_(temp__5818__auto__)){
var ms = temp__5818__auto__;
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__,ms,temp__5818__auto__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,reply_fn,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__,ms,temp__5818__auto__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,reply_fn,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (state_85904){
var state_val_85905 = (state_85904[(1)]);
if((state_val_85905 === (1))){
var inst_85899 = cljs.core.async.timeout(ms);
var state_85904__$1 = state_85904;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85904__$1,(2),inst_85899);
} else {
if((state_val_85905 === (2))){
var inst_85901 = (state_85904[(2)]);
var inst_85902 = (function (){var G__85906 = new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489);
return reply_fn(G__85906);
})();
var state_85904__$1 = (function (){var statearr_85907 = state_85904;
(statearr_85907[(7)] = inst_85901);

return statearr_85907;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_85904__$1,inst_85902);
} else {
return null;
}
}
});})(c__46663__auto__,ms,temp__5818__auto__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,reply_fn,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
return ((function (switch__46368__auto__,c__46663__auto__,ms,temp__5818__auto__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,reply_fn,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() {
var taoensso$sente$state_machine__46369__auto__ = null;
var taoensso$sente$state_machine__46369__auto____0 = (function (){
var statearr_85909 = [null,null,null,null,null,null,null,null];
(statearr_85909[(0)] = taoensso$sente$state_machine__46369__auto__);

(statearr_85909[(1)] = (1));

return statearr_85909;
});
var taoensso$sente$state_machine__46369__auto____1 = (function (state_85904){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_85904);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e85910){if((e85910 instanceof Object)){
var ex__46372__auto__ = e85910;
var statearr_85911_87616 = state_85904;
(statearr_85911_87616[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_85904);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85910;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87618 = state_85904;
state_85904 = G__87618;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$state_machine__46369__auto__ = function(state_85904){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__46369__auto____1.call(this,state_85904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__46369__auto____0;
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__46369__auto____1;
return taoensso$sente$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__,ms,temp__5818__auto__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,reply_fn,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var state__46665__auto__ = (function (){var statearr_85912 = f__46664__auto__();
(statearr_85912[(6)] = c__46663__auto__);

return statearr_85912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__,ms,temp__5818__auto__,params,ppstr,client_id,vec__85896,clj,has_cb_QMARK_,reply_fn,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);

return c__46663__auto__;
} else {
return null;
}
} else {
var G__85913 = new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337);
return reply_fn(G__85913);
}
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
], null));

}
}
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,new cljs.core.Keyword(null,"ajax-get-or-ws-handshake-fn","ajax-get-or-ws-handshake-fn",-1210409233),((function (allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (ring_req){
var sch_uuid = taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((6));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var client_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var uid = user_id_fn__$1(ring_req,client_id);
var receive_event_msg_BANG_ = ((function (sch_uuid,params,client_id,uid,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() {
var taoensso$sente$self = null;
var taoensso$sente$self__1 = (function (event){
return taoensso$sente$self.cljs$core$IFn$_invoke$arity$2(event,null);
});
var taoensso$sente$self__2 = (function (event,_QMARK_reply_fn){
return taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_(ch_recv,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null)], 0)));
});
taoensso$sente$self = function(event,_QMARK_reply_fn){
switch(arguments.length){
case 1:
return taoensso$sente$self__1.call(this,event);
case 2:
return taoensso$sente$self__2.call(this,event,_QMARK_reply_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$self.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$self__1;
taoensso$sente$self.cljs$core$IFn$_invoke$arity$2 = taoensso$sente$self__2;
return taoensso$sente$self;
})()
;})(sch_uuid,params,client_id,uid,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
var send_handshake_BANG_ = ((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (server_ch,websocket_QMARK_){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,615,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-handshake!"], null);
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,2061419783);

var _QMARK_handshake_data = (handshake_data_fn.cljs$core$IFn$_invoke$arity$1 ? handshake_data_fn.cljs$core$IFn$_invoke$arity$1(ring_req) : handshake_data_fn.call(null,ring_req));
var handshake_ev = (((_QMARK_handshake_data == null))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,null], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,null,_QMARK_handshake_data], null)], null));
return taoensso.sente.interfaces.sch_send_BANG_(server_ch,websocket_QMARK_,taoensso.sente.pack.cljs$core$IFn$_invoke$arity$2(packer__$1,handshake_ev));
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
if(clojure.string.blank_QMARK_(client_id)){
var err_msg = "Client's Ring request doesn't have a client id. Does your server have the necessary keyword Ring middleware (`wrap-params` & `wrap-keyword-params`)?";
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente",null,628,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (err_msg,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[err_msg,": %s"].join(''),ring_req], null);
});})(err_msg,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,-716404168);

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(err_msg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req], null));
} else {
if(bad_csrf_QMARK_(ring_req)){
return (bad_csrf_fn.cljs$core$IFn$_invoke$arity$1 ? bad_csrf_fn.cljs$core$IFn$_invoke$arity$1(ring_req) : bad_csrf_fn.call(null,ring_req));
} else {
if(taoensso.sente.bad_origin_QMARK_(allowed_origins__$1,ring_req)){
return (bad_origin_fn.cljs$core$IFn$_invoke$arity$1 ? bad_origin_fn.cljs$core$IFn$_invoke$arity$1(ring_req) : bad_origin_fn.call(null,ring_req));
} else {
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp(web_server_ch_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (server_ch,websocket_QMARK_){
if(cljs.core.truth_(websocket_QMARK_)){
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,644,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["New WebSocket channel: %s (%s)",uid,sch_uuid], null);
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,-1111096877);
var updated_conn = upd_conn_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id,server_ch);
var udt_open = new cljs.core.Keyword(null,"udt","udt",2011712751).cljs$core$IFn$_invoke$arity$1(updated_conn);
if(cljs.core.truth_(connect_uid_BANG_(new cljs.core.Keyword(null,"ws","ws",86841443),uid))){
receive_event_msg_BANG_.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954),uid], null));
} else {
}

send_handshake_BANG_(server_ch,websocket_QMARK_);

var temp__5818__auto__ = ws_kalive_ms;
if(cljs.core.truth_(temp__5818__auto__)){
var ms = temp__5818__auto__;
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (state_85950){
var state_val_85951 = (state_85950[(1)]);
if((state_val_85951 === (7))){
var inst_85946 = (state_85950[(2)]);
var state_85950__$1 = state_85950;
var statearr_85953_87630 = state_85950__$1;
(statearr_85953_87630[(2)] = inst_85946);

(statearr_85953_87630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (1))){
var inst_85915 = udt_open;
var state_85950__$1 = (function (){var statearr_85954 = state_85950;
(statearr_85954[(7)] = inst_85915);

return statearr_85954;
})();
var statearr_85955_87631 = state_85950__$1;
(statearr_85955_87631[(2)] = null);

(statearr_85955_87631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (4))){
var inst_85924 = (state_85950[(8)]);
var inst_85919 = (state_85950[(2)]);
var inst_85920 = cljs.core.deref(conns_);
var inst_85921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85922 = [new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id];
var inst_85923 = (new cljs.core.PersistentVector(null,3,(5),inst_85921,inst_85922,null));
var inst_85924__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_85920,inst_85923);
var state_85950__$1 = (function (){var statearr_85956 = state_85950;
(statearr_85956[(9)] = inst_85919);

(statearr_85956[(8)] = inst_85924__$1);

return statearr_85956;
})();
if(cljs.core.truth_(inst_85924__$1)){
var statearr_85957_87632 = state_85950__$1;
(statearr_85957_87632[(1)] = (5));

} else {
var statearr_85958_87633 = state_85950__$1;
(statearr_85958_87633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (13))){
var inst_85930 = (state_85950[(10)]);
var inst_85939 = (state_85950[(2)]);
var inst_85915 = inst_85930;
var state_85950__$1 = (function (){var statearr_85959 = state_85950;
(statearr_85959[(7)] = inst_85915);

(statearr_85959[(11)] = inst_85939);

return statearr_85959;
})();
var statearr_85960_87634 = state_85950__$1;
(statearr_85960_87634[(2)] = null);

(statearr_85960_87634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (6))){
var state_85950__$1 = state_85950;
var statearr_85961_87635 = state_85950__$1;
(statearr_85961_87635[(2)] = null);

(statearr_85961_87635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (3))){
var inst_85948 = (state_85950[(2)]);
var state_85950__$1 = state_85950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85950__$1,inst_85948);
} else {
if((state_val_85951 === (12))){
var state_85950__$1 = state_85950;
var statearr_85962_87636 = state_85950__$1;
(statearr_85962_87636[(2)] = null);

(statearr_85962_87636[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (2))){
var inst_85917 = cljs.core.async.timeout(ms);
var state_85950__$1 = state_85950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85950__$1,(4),inst_85917);
} else {
if((state_val_85951 === (11))){
var inst_85935 = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$2(packer__$1,new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304));
var inst_85936 = taoensso.sente.interfaces.sch_send_BANG_(server_ch,websocket_QMARK_,inst_85935);
var state_85950__$1 = state_85950;
var statearr_85963_87639 = state_85950__$1;
(statearr_85963_87639[(2)] = inst_85936);

(statearr_85963_87639[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (9))){
var state_85950__$1 = state_85950;
var statearr_85964_87641 = state_85950__$1;
(statearr_85964_87641[(2)] = null);

(statearr_85964_87641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (5))){
var inst_85924 = (state_85950[(8)]);
var inst_85929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_85924,(0),null);
var inst_85930 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_85924,(1),null);
var inst_85931 = taoensso.sente.interfaces.sch_open_QMARK_(server_ch);
var state_85950__$1 = (function (){var statearr_85965 = state_85950;
(statearr_85965[(10)] = inst_85930);

(statearr_85965[(12)] = inst_85929);

return statearr_85965;
})();
if(cljs.core.truth_(inst_85931)){
var statearr_85966_87645 = state_85950__$1;
(statearr_85966_87645[(1)] = (8));

} else {
var statearr_85967_87646 = state_85950__$1;
(statearr_85967_87646[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (10))){
var inst_85943 = (state_85950[(2)]);
var state_85950__$1 = state_85950;
var statearr_85968_87647 = state_85950__$1;
(statearr_85968_87647[(2)] = inst_85943);

(statearr_85968_87647[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_85951 === (8))){
var inst_85915 = (state_85950[(7)]);
var inst_85930 = (state_85950[(10)]);
var inst_85933 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_85930,inst_85915);
var state_85950__$1 = state_85950;
if(inst_85933){
var statearr_85970_87649 = state_85950__$1;
(statearr_85970_87649[(1)] = (11));

} else {
var statearr_85971_87652 = state_85950__$1;
(statearr_85971_87652[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
return ((function (switch__46368__auto__,c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() {
var taoensso$sente$state_machine__46369__auto__ = null;
var taoensso$sente$state_machine__46369__auto____0 = (function (){
var statearr_85972 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_85972[(0)] = taoensso$sente$state_machine__46369__auto__);

(statearr_85972[(1)] = (1));

return statearr_85972;
});
var taoensso$sente$state_machine__46369__auto____1 = (function (state_85950){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_85950);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e85973){if((e85973 instanceof Object)){
var ex__46372__auto__ = e85973;
var statearr_85974_87655 = state_85950;
(statearr_85974_87655[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_85950);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e85973;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87660 = state_85950;
state_85950 = G__87660;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$state_machine__46369__auto__ = function(state_85950){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__46369__auto____1.call(this,state_85950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__46369__auto____0;
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__46369__auto____1;
return taoensso$sente$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var state__46665__auto__ = (function (){var statearr_85975 = f__46664__auto__();
(statearr_85975[(6)] = c__46663__auto__);

return statearr_85975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);

return c__46663__auto__;
} else {
return null;
}
} else {
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,673,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["New Ajax handshake/poll: %s (%s)",uid,sch_uuid], null);
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,2113274970);
var updated_conn = upd_conn_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"ajax","ajax",814345549),uid,client_id,server_ch);
var udt_open = new cljs.core.Keyword(null,"udt","udt",2011712751).cljs$core$IFn$_invoke$arity$1(updated_conn);
var handshake_QMARK_ = (function (){var or__4131__auto__ = new cljs.core.Keyword(null,"init?","init?",438181499).cljs$core$IFn$_invoke$arity$1(updated_conn);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"handshake?","handshake?",-423743093).cljs$core$IFn$_invoke$arity$1(params);
}
})();
if(cljs.core.truth_(connect_uid_BANG_(new cljs.core.Keyword(null,"ajax","ajax",814345549),uid))){
receive_event_msg_BANG_.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954),uid], null));
} else {
}

if(cljs.core.truth_(handshake_QMARK_)){
return send_handshake_BANG_(server_ch,websocket_QMARK_);
} else {
var temp__5818__auto__ = lp_timeout_ms;
if(cljs.core.truth_(temp__5818__auto__)){
var ms = temp__5818__auto__;
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (state_86001){
var state_val_86002 = (state_86001[(1)]);
if((state_val_86002 === (1))){
var inst_85976 = cljs.core.async.timeout(ms);
var state_86001__$1 = state_86001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86001__$1,(2),inst_85976);
} else {
if((state_val_86002 === (2))){
var inst_85983 = (state_86001[(7)]);
var inst_85978 = (state_86001[(2)]);
var inst_85979 = cljs.core.deref(conns_);
var inst_85980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85981 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid,client_id];
var inst_85982 = (new cljs.core.PersistentVector(null,3,(5),inst_85980,inst_85981,null));
var inst_85983__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_85979,inst_85982);
var state_86001__$1 = (function (){var statearr_86007 = state_86001;
(statearr_86007[(7)] = inst_85983__$1);

(statearr_86007[(8)] = inst_85978);

return statearr_86007;
})();
if(cljs.core.truth_(inst_85983__$1)){
var statearr_86008_87667 = state_86001__$1;
(statearr_86008_87667[(1)] = (3));

} else {
var statearr_86009_87668 = state_86001__$1;
(statearr_86009_87668[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86002 === (3))){
var inst_85983 = (state_86001[(7)]);
var inst_85988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_85983,(0),null);
var inst_85989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_85983,(1),null);
var inst_85990 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_85989,udt_open);
var state_86001__$1 = (function (){var statearr_86011 = state_86001;
(statearr_86011[(9)] = inst_85988);

return statearr_86011;
})();
if(inst_85990){
var statearr_86012_87672 = state_86001__$1;
(statearr_86012_87672[(1)] = (6));

} else {
var statearr_86013_87673 = state_86001__$1;
(statearr_86013_87673[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86002 === (4))){
var state_86001__$1 = state_86001;
var statearr_86014_87674 = state_86001__$1;
(statearr_86014_87674[(2)] = null);

(statearr_86014_87674[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86002 === (5))){
var inst_85999 = (state_86001[(2)]);
var state_86001__$1 = state_86001;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86001__$1,inst_85999);
} else {
if((state_val_86002 === (6))){
var inst_85992 = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$2(packer__$1,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
var inst_85993 = taoensso.sente.interfaces.sch_send_BANG_(server_ch,websocket_QMARK_,inst_85992);
var state_86001__$1 = state_86001;
var statearr_86016_87675 = state_86001__$1;
(statearr_86016_87675[(2)] = inst_85993);

(statearr_86016_87675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86002 === (7))){
var state_86001__$1 = state_86001;
var statearr_86017_87676 = state_86001__$1;
(statearr_86017_87676[(2)] = null);

(statearr_86017_87676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86002 === (8))){
var inst_85996 = (state_86001[(2)]);
var state_86001__$1 = state_86001;
var statearr_86018_87677 = state_86001__$1;
(statearr_86018_87677[(2)] = inst_85996);

(statearr_86018_87677[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
return ((function (switch__46368__auto__,c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() {
var taoensso$sente$state_machine__46369__auto__ = null;
var taoensso$sente$state_machine__46369__auto____0 = (function (){
var statearr_86023 = [null,null,null,null,null,null,null,null,null,null];
(statearr_86023[(0)] = taoensso$sente$state_machine__46369__auto__);

(statearr_86023[(1)] = (1));

return statearr_86023;
});
var taoensso$sente$state_machine__46369__auto____1 = (function (state_86001){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_86001);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e86024){if((e86024 instanceof Object)){
var ex__46372__auto__ = e86024;
var statearr_86025_87678 = state_86001;
(statearr_86025_87678[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_86001);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e86024;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87679 = state_86001;
state_86001 = G__87679;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$state_machine__46369__auto__ = function(state_86001){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__46369__auto____1.call(this,state_86001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__46369__auto____0;
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__46369__auto____1;
return taoensso$sente$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var state__46665__auto__ = (function (){var statearr_86026 = f__46664__auto__();
(statearr_86026[(6)] = c__46663__auto__);

return statearr_86026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__,ms,temp__5818__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);

return c__46663__auto__;
} else {
return null;
}
}
}
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,new cljs.core.Keyword(null,"on-msg","on-msg",-2021925279),((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (server_ch,websocket_QMARK_,req_ppstr){
if(cljs.core.truth_(websocket_QMARK_)){
} else {
throw (new Error("Assert failed: websocket?"));
}

upd_conn_BANG_.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id);

var vec__86027 = taoensso.sente.unpack(packer__$1,req_ppstr);
var clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86027,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86027,(1),null);
return receive_event_msg_BANG_.cljs$core$IFn$_invoke$arity$2(clj,(cljs.core.truth_(_QMARK_cb_uuid)?((function (vec__86027,clj,_QMARK_cb_uuid,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function taoensso$sente$reply_fn(resp_clj){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,703,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__86027,clj,_QMARK_cb_uuid,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ws reply): %s",resp_clj], null);
});})(vec__86027,clj,_QMARK_cb_uuid,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,1892478498);

return taoensso.sente.interfaces.sch_send_BANG_(server_ch,websocket_QMARK_,taoensso.sente.pack.cljs$core$IFn$_invoke$arity$3(packer__$1,resp_clj,_QMARK_cb_uuid));
});})(vec__86027,clj,_QMARK_cb_uuid,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
:null));
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (server_ch,websocket_QMARK_,_status){
var conn_type = (cljs.core.truth_(websocket_QMARK_)?new cljs.core.Keyword(null,"ws","ws",86841443):new cljs.core.Keyword(null,"ajax","ajax",814345549));
var _ = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,712,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (conn_type,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s channel closed: %s (%s)",(cljs.core.truth_(websocket_QMARK_)?"WebSocket":"Ajax"),uid,sch_uuid], null);
});})(conn_type,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,-164600231);
var updated_conn = upd_conn_BANG_.cljs$core$IFn$_invoke$arity$4(conn_type,uid,client_id,null);
var udt_close = new cljs.core.Keyword(null,"udt","udt",2011712751).cljs$core$IFn$_invoke$arity$1(updated_conn);
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (state_86098){
var state_val_86099 = (state_86098[(1)]);
if((state_val_86099 === (7))){
var state_86098__$1 = state_86098;
var statearr_86100_87685 = state_86098__$1;
(statearr_86100_87685[(2)] = null);

(statearr_86100_87685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (1))){
var inst_86032 = cljs.core.async.timeout((5000));
var state_86098__$1 = state_86098;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86098__$1,(2),inst_86032);
} else {
if((state_val_86099 === (4))){
var state_86098__$1 = state_86098;
var statearr_86102_87686 = state_86098__$1;
(statearr_86102_87686[(2)] = null);

(statearr_86102_87686[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (13))){
var state_86098__$1 = state_86098;
var statearr_86103_87687 = state_86098__$1;
(statearr_86103_87687[(2)] = null);

(statearr_86103_87687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (6))){
var inst_86044 = (state_86098[(7)]);
var inst_86069 = (state_86098[(8)]);
var inst_86043 = (state_86098[(9)]);
var inst_86045 = (state_86098[(10)]);
var inst_86064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86065 = [conn_type,uid,client_id];
var inst_86066 = (new cljs.core.PersistentVector(null,3,(5),inst_86064,inst_86065,null));
var inst_86068 = (function (){var vec__86035 = inst_86043;
var __QMARK_sch = inst_86044;
var udt_t1 = inst_86045;
return ((function (vec__86035,__QMARK_sch,udt_t1,inst_86044,inst_86069,inst_86043,inst_86045,inst_86064,inst_86065,inst_86066,state_val_86099,c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (p__86067){
var vec__86114 = p__86067;
var _sch = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86114,(0),null);
var udt_t1__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86114,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(udt_t1__$1,udt_close)){
return taoensso.encore.swapped(new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782),true);
} else {
return taoensso.encore.swapped(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [_sch,udt_t1__$1], null),false);
}
});
;})(vec__86035,__QMARK_sch,udt_t1,inst_86044,inst_86069,inst_86043,inst_86045,inst_86064,inst_86065,inst_86066,state_val_86099,c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var inst_86069__$1 = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(conns_,inst_86066,inst_86068);
var state_86098__$1 = (function (){var statearr_86119 = state_86098;
(statearr_86119[(8)] = inst_86069__$1);

return statearr_86119;
})();
if(cljs.core.truth_(inst_86069__$1)){
var statearr_86120_87692 = state_86098__$1;
(statearr_86120_87692[(1)] = (9));

} else {
var statearr_86121_87693 = state_86098__$1;
(statearr_86121_87693[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (3))){
var inst_86044 = (state_86098[(7)]);
var inst_86043 = (state_86098[(9)]);
var inst_86045 = (state_86098[(10)]);
var inst_86049 = (function (){var vec__86035 = inst_86043;
var __QMARK_sch = inst_86044;
var udt_t1 = inst_86045;
return ((function (vec__86035,__QMARK_sch,udt_t1,inst_86044,inst_86043,inst_86045,state_val_86099,c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["close-timeout: %s %s %s %s",conn_type,uid,sch_uuid,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(udt_t1,udt_close),udt_t1,udt_close], null)], null);
});
;})(vec__86035,__QMARK_sch,udt_t1,inst_86044,inst_86043,inst_86045,state_val_86099,c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var inst_86053 = (new cljs.core.Delay(inst_86049,null));
var inst_86054 = taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente",null,726,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_86053,null,349008002);
var state_86098__$1 = state_86098;
var statearr_86135_87697 = state_86098__$1;
(statearr_86135_87697[(2)] = inst_86054);

(statearr_86135_87697[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (12))){
var inst_86080 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86081 = [new cljs.core.Keyword("chsk","uidport-close","chsk/uidport-close",901058678),uid];
var inst_86082 = (new cljs.core.PersistentVector(null,2,(5),inst_86080,inst_86081,null));
var inst_86083 = receive_event_msg_BANG_.cljs$core$IFn$_invoke$arity$1(inst_86082);
var state_86098__$1 = state_86098;
var statearr_86139_87698 = state_86098__$1;
(statearr_86139_87698[(2)] = inst_86083);

(statearr_86139_87698[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (2))){
var inst_86043 = (state_86098[(9)]);
var inst_86034 = (state_86098[(2)]);
var inst_86038 = cljs.core.deref(conns_);
var inst_86039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86041 = [conn_type,uid,client_id];
var inst_86042 = (new cljs.core.PersistentVector(null,3,(5),inst_86039,inst_86041,null));
var inst_86043__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_86038,inst_86042);
var inst_86044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86043__$1,(0),null);
var inst_86045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86043__$1,(1),null);
var inst_86046 = cljs.core.deref(taoensso.sente.debug_mode_QMARK__);
var state_86098__$1 = (function (){var statearr_86142 = state_86098;
(statearr_86142[(11)] = inst_86034);

(statearr_86142[(7)] = inst_86044);

(statearr_86142[(9)] = inst_86043__$1);

(statearr_86142[(10)] = inst_86045);

return statearr_86142;
})();
if(cljs.core.truth_(inst_86046)){
var statearr_86143_87703 = state_86098__$1;
(statearr_86143_87703[(1)] = (3));

} else {
var statearr_86146_87704 = state_86098__$1;
(statearr_86146_87704[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (11))){
var inst_86090 = (state_86098[(2)]);
var state_86098__$1 = state_86098;
var statearr_86147_87705 = state_86098__$1;
(statearr_86147_87705[(2)] = inst_86090);

(statearr_86147_87705[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (9))){
var inst_86044 = (state_86098[(7)]);
var inst_86069 = (state_86098[(8)]);
var inst_86043 = (state_86098[(9)]);
var inst_86045 = (state_86098[(10)]);
var inst_86071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86072 = [conn_type,uid];
var inst_86073 = (new cljs.core.PersistentVector(null,2,(5),inst_86071,inst_86072,null));
var inst_86074 = (function (){var vec__86035 = inst_86043;
var __QMARK_sch = inst_86044;
var udt_t1 = inst_86045;
var disconnect_QMARK_ = inst_86069;
return ((function (vec__86035,__QMARK_sch,udt_t1,disconnect_QMARK_,inst_86044,inst_86069,inst_86043,inst_86045,inst_86071,inst_86072,inst_86073,state_val_86099,c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (_QMARK_m){
if(cljs.core.empty_QMARK_(_QMARK_m)){
return new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782);
} else {
return _QMARK_m;
}
});
;})(vec__86035,__QMARK_sch,udt_t1,disconnect_QMARK_,inst_86044,inst_86069,inst_86043,inst_86045,inst_86071,inst_86072,inst_86073,state_val_86099,c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var inst_86075 = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(conns_,inst_86073,inst_86074);
var inst_86078 = upd_connected_uid_BANG_(uid);
var state_86098__$1 = (function (){var statearr_86151 = state_86098;
(statearr_86151[(12)] = inst_86075);

return statearr_86151;
})();
if(cljs.core.truth_(inst_86078)){
var statearr_86152_87706 = state_86098__$1;
(statearr_86152_87706[(1)] = (12));

} else {
var statearr_86153_87707 = state_86098__$1;
(statearr_86153_87707[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (5))){
var inst_86045 = (state_86098[(10)]);
var inst_86057 = (state_86098[(2)]);
var inst_86058 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_86045,udt_close);
var state_86098__$1 = (function (){var statearr_86154 = state_86098;
(statearr_86154[(13)] = inst_86057);

return statearr_86154;
})();
if(inst_86058){
var statearr_86156_87708 = state_86098__$1;
(statearr_86156_87708[(1)] = (6));

} else {
var statearr_86157_87709 = state_86098__$1;
(statearr_86157_87709[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (14))){
var inst_86087 = (state_86098[(2)]);
var state_86098__$1 = state_86098;
var statearr_86158_87710 = state_86098__$1;
(statearr_86158_87710[(2)] = inst_86087);

(statearr_86158_87710[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (10))){
var state_86098__$1 = state_86098;
var statearr_86159_87714 = state_86098__$1;
(statearr_86159_87714[(2)] = null);

(statearr_86159_87714[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86099 === (8))){
var inst_86093 = (state_86098[(2)]);
var state_86098__$1 = state_86098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86098__$1,inst_86093);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
;
return ((function (switch__46368__auto__,c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function() {
var taoensso$sente$state_machine__46369__auto__ = null;
var taoensso$sente$state_machine__46369__auto____0 = (function (){
var statearr_86178 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_86178[(0)] = taoensso$sente$state_machine__46369__auto__);

(statearr_86178[(1)] = (1));

return statearr_86178;
});
var taoensso$sente$state_machine__46369__auto____1 = (function (state_86098){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_86098);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e86183){if((e86183 instanceof Object)){
var ex__46372__auto__ = e86183;
var statearr_86187_87715 = state_86098;
(statearr_86187_87715[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_86098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e86183;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87716 = state_86098;
state_86098 = G__87716;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$state_machine__46369__auto__ = function(state_86098){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__46369__auto____1.call(this,state_86098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__46369__auto____0;
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__46369__auto____1;
return taoensso$sente$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
})();
var state__46665__auto__ = (function (){var statearr_86188 = f__46664__auto__();
(statearr_86188[(6)] = c__46663__auto__);

return statearr_86188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
);

return c__46663__auto__;
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (server_ch,websocket_QMARK_,error){
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente",null,748,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ring-req->server-ch-resp error: %s (%s)",error,uid,sch_uuid], null);
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
,null)),null,-174332952);
});})(sch_uuid,params,client_id,uid,receive_event_msg_BANG_,send_handshake_BANG_,allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
], null));

}
}
}
});})(allowed_origins__$1,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,bad_csrf_QMARK_,ev_msg_const,vec__85726,map__85729,map__85729__$1,ws_kalive_ms,send_buf_ms_ws,allowed_origins,lp_timeout_ms,csrf_token_fn,packer,send_buf_ms_ajax,bad_origin_fn,handshake_data_fn,user_id_fn,recv_buf_or_n,bad_csrf_fn))
], null);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$applyTo = (function (seq85715){
var G__85716 = cljs.core.first(seq85715);
var seq85715__$1 = cljs.core.next(seq85715);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__85716,seq85715__$1);
});

/**
 * Actually pushes buffered events (as packed-str) to all uid's WebSocket conns.
 */
taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ws_clients_BANG_(conns_,uid,buffered_evs_pstr,upd_conn_BANG_){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,754,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ws-clients!: %s",buffered_evs_pstr], null);
}),null)),null,1433519097);

var seq__86209 = cljs.core.seq(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid], null)));
var chunk__86210 = null;
var count__86211 = (0);
var i__86212 = (0);
while(true){
if((i__86212 < count__86211)){
var vec__86269 = chunk__86210.cljs$core$IIndexed$_nth$arity$2(null,i__86212);
var client_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86269,(0),null);
var vec__86272 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86269,(1),null);
var _QMARK_sch = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86272,(0),null);
var _udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86272,(1),null);
var temp__5818__auto___87722 = _QMARK_sch;
if(cljs.core.truth_(temp__5818__auto___87722)){
var sch_87723 = temp__5818__auto___87722;
var G__86279_87724 = new cljs.core.Keyword(null,"ws","ws",86841443);
var G__86280_87725 = uid;
var G__86281_87726 = client_id;
(upd_conn_BANG_.cljs$core$IFn$_invoke$arity$3 ? upd_conn_BANG_.cljs$core$IFn$_invoke$arity$3(G__86279_87724,G__86280_87725,G__86281_87726) : upd_conn_BANG_.call(null,G__86279_87724,G__86280_87725,G__86281_87726));

taoensso.sente.interfaces.sch_send_BANG_(sch_87723,new cljs.core.Keyword(null,"websocket","websocket",-1714963101),buffered_evs_pstr);
} else {
}


var G__87731 = seq__86209;
var G__87732 = chunk__86210;
var G__87733 = count__86211;
var G__87734 = (i__86212 + (1));
seq__86209 = G__87731;
chunk__86210 = G__87732;
count__86211 = G__87733;
i__86212 = G__87734;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__86209);
if(temp__5818__auto__){
var seq__86209__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__86209__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__86209__$1);
var G__87735 = cljs.core.chunk_rest(seq__86209__$1);
var G__87736 = c__4550__auto__;
var G__87737 = cljs.core.count(c__4550__auto__);
var G__87738 = (0);
seq__86209 = G__87735;
chunk__86210 = G__87736;
count__86211 = G__87737;
i__86212 = G__87738;
continue;
} else {
var vec__86292 = cljs.core.first(seq__86209__$1);
var client_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86292,(0),null);
var vec__86295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86292,(1),null);
var _QMARK_sch = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86295,(0),null);
var _udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86295,(1),null);
var temp__5818__auto___87739__$1 = _QMARK_sch;
if(cljs.core.truth_(temp__5818__auto___87739__$1)){
var sch_87741 = temp__5818__auto___87739__$1;
var G__86303_87742 = new cljs.core.Keyword(null,"ws","ws",86841443);
var G__86304_87743 = uid;
var G__86305_87744 = client_id;
(upd_conn_BANG_.cljs$core$IFn$_invoke$arity$3 ? upd_conn_BANG_.cljs$core$IFn$_invoke$arity$3(G__86303_87742,G__86304_87743,G__86305_87744) : upd_conn_BANG_.call(null,G__86303_87742,G__86304_87743,G__86305_87744));

taoensso.sente.interfaces.sch_send_BANG_(sch_87741,new cljs.core.Keyword(null,"websocket","websocket",-1714963101),buffered_evs_pstr);
} else {
}


var G__87747 = cljs.core.next(seq__86209__$1);
var G__87748 = null;
var G__87749 = (0);
var G__87750 = (0);
seq__86209 = G__87747;
chunk__86210 = G__87748;
count__86211 = G__87749;
i__86212 = G__87750;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Actually pushes buffered events (as packed-str) to all uid's Ajax conns.
 *   Allows some time for possible Ajax poller reconnects.
 */
taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG_(conns_,uid,buffered_evs_pstr){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,764,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ajax-clients!: %s",buffered_evs_pstr], null);
}),null)),null,-847708050);

var ms_backoffs = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(90),(180),(360),(720),(1440)], null);
var client_ids_unsatisfied = cljs.core.keys(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid], null)));
if(cljs.core.empty_QMARK_(client_ids_unsatisfied)){
return null;
} else {
var c__46663__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto__,ms_backoffs,client_ids_unsatisfied){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto__,ms_backoffs,client_ids_unsatisfied){
return (function (state_86393){
var state_val_86394 = (state_86393[(1)]);
if((state_val_86394 === (7))){
var inst_86348 = (state_86393[(7)]);
var inst_86338 = (state_86393[(8)]);
var inst_86337 = (state_86393[(9)]);
var inst_86360 = (function (){var n = inst_86337;
var client_ids_satisfied = inst_86338;
var _QMARK_pulled = inst_86348;
return ((function (n,client_ids_satisfied,_QMARK_pulled,inst_86348,inst_86338,inst_86337,state_val_86394,c__46663__auto__,ms_backoffs,client_ids_unsatisfied){
return (function (s,client_id,p__86359){
var vec__86396 = p__86359;
var _QMARK_sch = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86396,(0),null);
var _udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86396,(1),null);
var sent_QMARK_ = (function (){var temp__5818__auto__ = _QMARK_sch;
if(cljs.core.truth_(temp__5818__auto__)){
var sch = temp__5818__auto__;
return taoensso.sente.interfaces.sch_send_BANG_(_QMARK_sch,cljs.core.not(new cljs.core.Keyword(null,"websocket","websocket",-1714963101)),buffered_evs_pstr);
} else {
return null;
}
})();
if(cljs.core.truth_(sent_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,client_id);
} else {
return s;
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,inst_86348,inst_86338,inst_86337,state_val_86394,c__46663__auto__,ms_backoffs,client_ids_unsatisfied))
})();
var inst_86361 = cljs.core.PersistentHashSet.EMPTY;
var inst_86362 = cljs.core.reduce_kv(inst_86360,inst_86361,inst_86348);
var state_86393__$1 = state_86393;
var statearr_86399_87762 = state_86393__$1;
(statearr_86399_87762[(2)] = inst_86362);

(statearr_86399_87762[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (1))){
var inst_86336 = cljs.core.PersistentHashSet.EMPTY;
var inst_86337 = (0);
var inst_86338 = inst_86336;
var state_86393__$1 = (function (){var statearr_86403 = state_86393;
(statearr_86403[(8)] = inst_86338);

(statearr_86403[(9)] = inst_86337);

return statearr_86403;
})();
var statearr_86404_87763 = state_86393__$1;
(statearr_86404_87763[(2)] = null);

(statearr_86404_87763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (4))){
var state_86393__$1 = state_86393;
var statearr_86406_87767 = state_86393__$1;
(statearr_86406_87767[(2)] = true);

(statearr_86406_87767[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (15))){
var inst_86385 = (state_86393[(2)]);
var state_86393__$1 = state_86393;
var statearr_86408_87769 = state_86393__$1;
(statearr_86408_87769[(2)] = inst_86385);

(statearr_86408_87769[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (13))){
var inst_86367 = (state_86393[(10)]);
var inst_86376 = cljs.core.rand_int(inst_86367);
var inst_86377 = (inst_86367 + inst_86376);
var inst_86378 = cljs.core.async.timeout(inst_86377);
var state_86393__$1 = state_86393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86393__$1,(16),inst_86378);
} else {
if((state_val_86394 === (6))){
var inst_86348 = (state_86393[(7)]);
var inst_86357 = (state_86393[(2)]);
var state_86393__$1 = (function (){var statearr_86414 = state_86393;
(statearr_86414[(11)] = inst_86357);

return statearr_86414;
})();
if(cljs.core.truth_(inst_86348)){
var statearr_86421_87775 = state_86393__$1;
(statearr_86421_87775[(1)] = (7));

} else {
var statearr_86422_87777 = state_86393__$1;
(statearr_86422_87777[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (3))){
var inst_86390 = (state_86393[(2)]);
var state_86393__$1 = state_86393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86393__$1,inst_86390);
} else {
if((state_val_86394 === (12))){
var inst_86388 = (state_86393[(2)]);
var state_86393__$1 = state_86393;
var statearr_86431_87784 = state_86393__$1;
(statearr_86431_87784[(2)] = inst_86388);

(statearr_86431_87784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (2))){
var inst_86348 = (state_86393[(7)]);
var inst_86338 = (state_86393[(8)]);
var inst_86337 = (state_86393[(9)]);
var inst_86344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86345 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid];
var inst_86346 = (new cljs.core.PersistentVector(null,2,(5),inst_86344,inst_86345,null));
var inst_86347 = (function (){var n = inst_86337;
var client_ids_satisfied = inst_86338;
return ((function (n,client_ids_satisfied,inst_86348,inst_86338,inst_86337,inst_86344,inst_86345,inst_86346,state_val_86394,c__46663__auto__,ms_backoffs,client_ids_unsatisfied){
return (function (m){
var ks_to_pull = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(client_ids_satisfied,cljs.core.keys(m));
if(cljs.core.empty_QMARK_(ks_to_pull)){
return taoensso.encore.swapped(m,null);
} else {
return taoensso.encore.swapped(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (ks_to_pull,n,client_ids_satisfied,inst_86348,inst_86338,inst_86337,inst_86344,inst_86345,inst_86346,state_val_86394,c__46663__auto__,ms_backoffs,client_ids_unsatisfied){
return (function (m__$1,k){
var vec__86440 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m__$1,k);
var _QMARK_sch = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86440,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86440,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,k,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,udt], null));
});})(ks_to_pull,n,client_ids_satisfied,inst_86348,inst_86338,inst_86337,inst_86344,inst_86345,inst_86346,state_val_86394,c__46663__auto__,ms_backoffs,client_ids_unsatisfied))
,m,ks_to_pull),cljs.core.select_keys(m,ks_to_pull));
}
});
;})(n,client_ids_satisfied,inst_86348,inst_86338,inst_86337,inst_86344,inst_86345,inst_86346,state_val_86394,c__46663__auto__,ms_backoffs,client_ids_unsatisfied))
})();
var inst_86348__$1 = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(conns_,inst_86346,inst_86347);
var inst_86351 = (function (){var n = inst_86337;
var client_ids_satisfied = inst_86338;
var _QMARK_pulled = inst_86348__$1;
return ((function (n,client_ids_satisfied,_QMARK_pulled,inst_86348,inst_86338,inst_86337,inst_86344,inst_86345,inst_86346,inst_86347,inst_86348__$1,state_val_86394,c__46663__auto__,ms_backoffs,client_ids_unsatisfied){
return (function (x){
var or__4131__auto__ = (x == null);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var fexpr__86449 = taoensso.truss.impl.non_throwing(cljs.core.map_QMARK_);
return fexpr__86449(x);
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,inst_86348,inst_86338,inst_86337,inst_86344,inst_86345,inst_86346,inst_86347,inst_86348__$1,state_val_86394,c__46663__auto__,ms_backoffs,client_ids_unsatisfied))
})();
var inst_86352 = inst_86351(inst_86348__$1);
var state_86393__$1 = (function (){var statearr_86450 = state_86393;
(statearr_86450[(7)] = inst_86348__$1);

return statearr_86450;
})();
if(cljs.core.truth_(inst_86352)){
var statearr_86451_87796 = state_86393__$1;
(statearr_86451_87796[(1)] = (4));

} else {
var statearr_86452_87797 = state_86393__$1;
(statearr_86452_87797[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (11))){
var state_86393__$1 = state_86393;
var statearr_86457_87798 = state_86393__$1;
(statearr_86457_87798[(2)] = null);

(statearr_86457_87798[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (9))){
var inst_86338 = (state_86393[(8)]);
var inst_86367 = (state_86393[(10)]);
var inst_86337 = (state_86393[(9)]);
var inst_86365 = (state_86393[(2)]);
var inst_86366 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_86338,inst_86365);
var inst_86367__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(ms_backoffs,inst_86337);
var state_86393__$1 = (function (){var statearr_86464 = state_86393;
(statearr_86464[(12)] = inst_86366);

(statearr_86464[(10)] = inst_86367__$1);

return statearr_86464;
})();
if(cljs.core.truth_(inst_86367__$1)){
var statearr_86465_87802 = state_86393__$1;
(statearr_86465_87802[(1)] = (10));

} else {
var statearr_86466_87803 = state_86393__$1;
(statearr_86466_87803[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (5))){
var inst_86348 = (state_86393[(7)]);
var inst_86355 = taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",791,"([:or nil? map?] ?pulled)",inst_86348,null,null);
var state_86393__$1 = state_86393;
var statearr_86471_87807 = state_86393__$1;
(statearr_86471_87807[(2)] = inst_86355);

(statearr_86471_87807[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (14))){
var state_86393__$1 = state_86393;
var statearr_86476_87808 = state_86393__$1;
(statearr_86476_87808[(2)] = null);

(statearr_86476_87808[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (16))){
var inst_86366 = (state_86393[(12)]);
var inst_86337 = (state_86393[(9)]);
var inst_86380 = (state_86393[(2)]);
var inst_86381 = (inst_86337 + (1));
var inst_86337__$1 = inst_86381;
var inst_86338 = inst_86366;
var state_86393__$1 = (function (){var statearr_86480 = state_86393;
(statearr_86480[(8)] = inst_86338);

(statearr_86480[(13)] = inst_86380);

(statearr_86480[(9)] = inst_86337__$1);

return statearr_86480;
})();
var statearr_86485_87812 = state_86393__$1;
(statearr_86485_87812[(2)] = null);

(statearr_86485_87812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (10))){
var inst_86366 = (state_86393[(12)]);
var inst_86371 = cljs.core.complement(inst_86366);
var inst_86373 = taoensso.encore.rsome(inst_86371,client_ids_unsatisfied);
var state_86393__$1 = state_86393;
if(cljs.core.truth_(inst_86373)){
var statearr_86490_87816 = state_86393__$1;
(statearr_86490_87816[(1)] = (13));

} else {
var statearr_86491_87817 = state_86393__$1;
(statearr_86491_87817[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86394 === (8))){
var state_86393__$1 = state_86393;
var statearr_86492_87818 = state_86393__$1;
(statearr_86492_87818[(2)] = null);

(statearr_86492_87818[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto__,ms_backoffs,client_ids_unsatisfied))
;
return ((function (switch__46368__auto__,c__46663__auto__,ms_backoffs,client_ids_unsatisfied){
return (function() {
var taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto__ = null;
var taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto____0 = (function (){
var statearr_86498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_86498[(0)] = taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto__);

(statearr_86498[(1)] = (1));

return statearr_86498;
});
var taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto____1 = (function (state_86393){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_86393);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e86502){if((e86502 instanceof Object)){
var ex__46372__auto__ = e86502;
var statearr_86503_87822 = state_86393;
(statearr_86503_87822[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_86393);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e86502;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87823 = state_86393;
state_86393 = G__87823;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto__ = function(state_86393){
switch(arguments.length){
case 0:
return taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto____1.call(this,state_86393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto____0;
taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto____1;
return taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto__,ms_backoffs,client_ids_unsatisfied))
})();
var state__46665__auto__ = (function (){var statearr_86509 = f__46664__auto__();
(statearr_86509[(6)] = c__46663__auto__);

return statearr_86509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto__,ms_backoffs,client_ids_unsatisfied))
);

return c__46663__auto__;
}
});
/**
 * Alias of `taoensso.encore/ajax-lite`
 */
taoensso.sente.ajax_lite = taoensso.encore.ajax_lite;

/**
 * @interface
 */
taoensso.sente.IChSocket = function(){};

taoensso.sente._chsk_connect_BANG_ = (function taoensso$sente$_chsk_connect_BANG_(chsk){
if((((!((chsk == null)))) && ((!((chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 == null)))))){
return chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(chsk);
} else {
var x__4433__auto__ = (((chsk == null))?null:chsk);
var m__4434__auto__ = (taoensso.sente._chsk_connect_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__4434__auto__.call(null,chsk));
} else {
var m__4431__auto__ = (taoensso.sente._chsk_connect_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__4431__auto__.call(null,chsk));
} else {
throw cljs.core.missing_protocol("IChSocket.-chsk-connect!",chsk);
}
}
}
});

taoensso.sente._chsk_disconnect_BANG_ = (function taoensso$sente$_chsk_disconnect_BANG_(chsk,reason){
if((((!((chsk == null)))) && ((!((chsk.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2 == null)))))){
return chsk.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2(chsk,reason);
} else {
var x__4433__auto__ = (((chsk == null))?null:chsk);
var m__4434__auto__ = (taoensso.sente._chsk_disconnect_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(chsk,reason) : m__4434__auto__.call(null,chsk,reason));
} else {
var m__4431__auto__ = (taoensso.sente._chsk_disconnect_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(chsk,reason) : m__4431__auto__.call(null,chsk,reason));
} else {
throw cljs.core.missing_protocol("IChSocket.-chsk-disconnect!",chsk);
}
}
}
});

taoensso.sente._chsk_reconnect_BANG_ = (function taoensso$sente$_chsk_reconnect_BANG_(chsk){
if((((!((chsk == null)))) && ((!((chsk.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1 == null)))))){
return chsk.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1(chsk);
} else {
var x__4433__auto__ = (((chsk == null))?null:chsk);
var m__4434__auto__ = (taoensso.sente._chsk_reconnect_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__4434__auto__.call(null,chsk));
} else {
var m__4431__auto__ = (taoensso.sente._chsk_reconnect_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__4431__auto__.call(null,chsk));
} else {
throw cljs.core.missing_protocol("IChSocket.-chsk-reconnect!",chsk);
}
}
}
});

taoensso.sente._chsk_send_BANG_ = (function taoensso$sente$_chsk_send_BANG_(chsk,ev,opts){
if((((!((chsk == null)))) && ((!((chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 == null)))))){
return chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3(chsk,ev,opts);
} else {
var x__4433__auto__ = (((chsk == null))?null:chsk);
var m__4434__auto__ = (taoensso.sente._chsk_send_BANG_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(chsk,ev,opts) : m__4434__auto__.call(null,chsk,ev,opts));
} else {
var m__4431__auto__ = (taoensso.sente._chsk_send_BANG_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(chsk,ev,opts) : m__4431__auto__.call(null,chsk,ev,opts));
} else {
throw cljs.core.missing_protocol("IChSocket.-chsk-send!",chsk);
}
}
}
});

taoensso.sente.chsk_connect_BANG_ = (function taoensso$sente$chsk_connect_BANG_(chsk){
return taoensso.sente._chsk_connect_BANG_(chsk);
});

taoensso.sente.chsk_disconnect_BANG_ = (function taoensso$sente$chsk_disconnect_BANG_(chsk){
return taoensso.sente._chsk_disconnect_BANG_(chsk,new cljs.core.Keyword(null,"requested-disconnect","requested-disconnect",1037120641));
});

/**
 * Useful for reauthenticating after login/logout, etc.
 */
taoensso.sente.chsk_reconnect_BANG_ = (function taoensso$sente$chsk_reconnect_BANG_(chsk){
return taoensso.sente._chsk_reconnect_BANG_(chsk);
});

/**
 * Deprecated
 */
taoensso.sente.chsk_destroy_BANG_ = taoensso.sente.chsk_disconnect_BANG_;
/**
 * Sends `[ev-id ev-?data :as event]`, returns true on apparent success.
 */
taoensso.sente.chsk_send_BANG_ = (function taoensso$sente$chsk_send_BANG_(var_args){
var G__86573 = arguments.length;
switch (G__86573) {
case 2:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (chsk,ev){
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3(chsk,ev,cljs.core.PersistentArrayMap.EMPTY);
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (chsk,ev,_QMARK_timeout_ms,_QMARK_cb){
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3(chsk,ev,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"cb","cb",589947841),_QMARK_cb], null));
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (chsk,ev,opts){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,841,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (%s) %s",cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"cb","cb",589947841),cljs.core.boolean$(new cljs.core.Keyword(null,"cb","cb",589947841).cljs$core$IFn$_invoke$arity$1(opts))),ev], null);
}),null)),null,230879420);

return taoensso.sente._chsk_send_BANG_(chsk,ev,opts);
});

taoensso.sente.chsk_send_BANG_.cljs$lang$maxFixedArity = 4;

taoensso.sente.chsk_send__GT_closed_BANG_ = (function taoensso$sente$chsk_send__GT_closed_BANG_(_QMARK_cb_fn){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,846,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
}),null)),null,-306039549);

if(cljs.core.truth_(_QMARK_cb_fn)){
var G__86588_87846 = new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264);
(_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__86588_87846) : _QMARK_cb_fn.call(null,G__86588_87846));
} else {
}

return false;
});
taoensso.sente.assert_send_args = (function taoensso$sente$assert_send_args(x,_QMARK_timeout_ms,_QMARK_cb){
taoensso.sente.assert_event(x);

if((((((_QMARK_timeout_ms == null)) && ((_QMARK_cb == null)))) || (taoensso.encore.nat_int_QMARK_(_QMARK_timeout_ms)))){
} else {
throw (new Error(["Assert failed: ",["cb requires a timeout; timeout-ms should be a +ive integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_timeout_ms)].join(''),"\n","(or (and (nil? ?timeout-ms) (nil? ?cb)) (and (enc/nat-int? ?timeout-ms)))"].join('')));
}

if((((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_(_QMARK_cb)) || (taoensso.encore.chan_QMARK_(_QMARK_cb)))){
return null;
} else {
throw (new Error(["Assert failed: ",["cb should be nil, an ifn, or a channel: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(_QMARK_cb))].join(''),"\n","(or (nil? ?cb) (ifn? ?cb) (enc/chan? ?cb))"].join('')));
}
});
taoensso.sente.pull_unused_cb_fn_BANG_ = (function taoensso$sente$pull_unused_cb_fn_BANG_(cbs_waiting_,_QMARK_cb_uuid){
var temp__5818__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__5818__auto__)){
var cb_uuid = temp__5818__auto__;
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid], null),((function (cb_uuid,temp__5818__auto__){
return (function (_QMARK_f){
return taoensso.encore.swapped(new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782),_QMARK_f);
});})(cb_uuid,temp__5818__auto__))
);
} else {
return null;
}
});
/**
 * Atomically swaps the value of chk's :state_ atom.
 */
taoensso.sente.swap_chsk_state_BANG_ = (function taoensso$sente$swap_chsk_state_BANG_(chsk,f){
var vec__86602 = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk),(function (old_state){
var new_state = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_state) : f.call(null,old_state));
var new_state__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"first-open?","first-open?",396686530).cljs$core$IFn$_invoke$arity$1(old_state))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_state,new cljs.core.Keyword(null,"first-open?","first-open?",396686530),false):new_state);
var new_state__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(new_state__$1))?cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new_state__$1,new cljs.core.Keyword(null,"udt-next-reconnect","udt-next-reconnect",-1990375733)):new_state__$1);
return taoensso.encore.swapped(new_state__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state__$2], null));
}));
var old_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86602,(0),null);
var new_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86602,(1),null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_state,new_state)){
var output = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(chsk,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"state","state",-1988618099)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),output], null));

return output;
} else {
return null;
}
});
taoensso.sente.chsk_state__GT_closed = (function taoensso$sente$chsk_state__GT_closed(state,reason){
var e_87855 = (function (){try{if(cljs.core.map_QMARK_(state)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e86619){if((e86619 instanceof Error)){
var e = e86619;
return e;
} else {
throw e86619;

}
}})();
if((e_87855 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",893,"(map? state)",state,e_87855,null);
}

var e_87857 = (function (){try{if((function (){var fexpr__86625 = (function (x){
return cljs.core.contains_QMARK_((function (){var G__86626 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"requested-disconnect","requested-disconnect",1037120641),null,new cljs.core.Keyword(null,"downgrading-ws-to-ajax","downgrading-ws-to-ajax",402136720),null,new cljs.core.Keyword(null,"unexpected","unexpected",-1137752424),null,new cljs.core.Keyword(null,"requested-reconnect","requested-reconnect",2008347707),null], null), null);
return (taoensso.truss.impl.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.truss.impl.set_STAR_.cljs$core$IFn$_invoke$arity$1(G__86626) : taoensso.truss.impl.set_STAR_.call(null,G__86626));
})(),x);
});
return fexpr__86625(reason);
})()){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e86623){if((e86623 instanceof Error)){
var e = e86623;
return e;
} else {
throw e86623;

}
}})();
if((e_87857 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",894,"([:el #{:requested-disconnect :downgrading-ws-to-ajax :unexpected :requested-reconnect}] reason)",reason,e_87857,null);
}

if(cljs.core.truth_((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(state);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(reason,new cljs.core.Keyword(null,"unexpected","unexpected",-1137752424));
}
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(state,new cljs.core.Keyword(null,"udt-next-reconnect","udt-next-reconnect",-1990375733)),new cljs.core.Keyword(null,"open?","open?",1238443125),false,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"last-close","last-close",-2054255782),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"udt","udt",2011712751),taoensso.encore.now_udt(),new cljs.core.Keyword(null,"reason","reason",-2070751759),reason], null)], 0));
} else {
return state;
}
});
/**
 * Experimental, undocumented. Allows a core.async channel to be provided
 *   instead of a cb-fn. The channel will receive values of form
 *   [<event-id>.cb <reply>].
 */
taoensso.sente.cb_chan_as_fn = (function taoensso$sente$cb_chan_as_fn(_QMARK_cb,ev){
if((((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_(_QMARK_cb)))){
return _QMARK_cb;
} else {
var e_87860 = (function (){try{if(taoensso.encore.chan_QMARK_(_QMARK_cb)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e86637){if((e86637 instanceof Error)){
var e = e86637;
return e;
} else {
throw e86637;

}
}})();
if((e_87860 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",915,"(enc/chan? ?cb)",_QMARK_cb,e_87860,null);
}

taoensso.sente.assert_event(ev);

var vec__86640 = ev;
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86640,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86640,(1),null);
var cb_ch = _QMARK_cb;
return ((function (vec__86640,ev_id,_,cb_ch){
return (function (reply){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cb_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([taoensso.encore.as_qname(ev_id),".cb"].join('')),reply], null));
});
;})(vec__86640,ev_id,_,cb_ch))
}
});
taoensso.sente.receive_buffered_evs_BANG_ = (function taoensso$sente$receive_buffered_evs_BANG_(chs,clj){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,926,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["receive-buffered-evs!: %s",clj], null);
}),null)),null,-2091908270);

var buffered_evs = ((cljs.core.vector_QMARK_(clj))?clj:taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",927,"(vector? clj)",clj,null,null));
var seq__86646 = cljs.core.seq(buffered_evs);
var chunk__86647 = null;
var count__86648 = (0);
var i__86649 = (0);
while(true){
if((i__86649 < count__86648)){
var ev = chunk__86647.cljs$core$IIndexed$_nth$arity$2(null,i__86649);
taoensso.sente.assert_event(ev);

var vec__86671_87864 = ev;
var id_87865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86671_87864,(0),null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(id_87865),"chsk")){
} else {
throw (new Error("Assert failed: (not= (namespace id) \"chsk\")"));
}

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);


var G__87867 = seq__86646;
var G__87868 = chunk__86647;
var G__87869 = count__86648;
var G__87870 = (i__86649 + (1));
seq__86646 = G__87867;
chunk__86647 = G__87868;
count__86648 = G__87869;
i__86649 = G__87870;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__86646);
if(temp__5818__auto__){
var seq__86646__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__86646__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__86646__$1);
var G__87871 = cljs.core.chunk_rest(seq__86646__$1);
var G__87872 = c__4550__auto__;
var G__87873 = cljs.core.count(c__4550__auto__);
var G__87874 = (0);
seq__86646 = G__87871;
chunk__86647 = G__87872;
count__86648 = G__87873;
i__86649 = G__87874;
continue;
} else {
var ev = cljs.core.first(seq__86646__$1);
taoensso.sente.assert_event(ev);

var vec__86680_87875 = ev;
var id_87876 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86680_87875,(0),null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(id_87876),"chsk")){
} else {
throw (new Error("Assert failed: (not= (namespace id) \"chsk\")"));
}

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);


var G__87878 = cljs.core.next(seq__86646__$1);
var G__87879 = null;
var G__87880 = (0);
var G__87881 = (0);
seq__86646 = G__87878;
chunk__86647 = G__87879;
count__86648 = G__87880;
i__86649 = G__87881;
continue;
}
} else {
return null;
}
}
break;
}
});
taoensso.sente.handshake_QMARK_ = (function taoensso$sente$handshake_QMARK_(x){
var and__4120__auto__ = cljs.core.vector_QMARK_(x);
if(and__4120__auto__){
var vec__86692 = x;
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86692,(0),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x1,new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686));
} else {
return and__4120__auto__;
}
});
taoensso.sente.receive_handshake_BANG_ = (function taoensso$sente$receive_handshake_BANG_(chsk_type,chsk,clj){
var e_87884 = (function (){try{if((function (){var fexpr__86712 = (function (x){
return cljs.core.contains_QMARK_((function (){var G__86713 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null], null), null);
return (taoensso.truss.impl.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.truss.impl.set_STAR_.cljs$core$IFn$_invoke$arity$1(G__86713) : taoensso.truss.impl.set_STAR_.call(null,G__86713));
})(),x);
});
return fexpr__86712(chsk_type);
})()){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e86710){if((e86710 instanceof Error)){
var e = e86710;
return e;
} else {
throw e86710;

}
}})();
if((e_87884 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",941,"([:el #{:ws :ajax}] chsk-type)",chsk_type,e_87884,null);
}

var e_87886 = (function (){try{if(taoensso.sente.handshake_QMARK_(clj)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e86720){if((e86720 instanceof Error)){
var e = e86720;
return e;
} else {
throw e86720;

}
}})();
if((e_87886 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",942,"(handshake? clj)",clj,e_87886,null);
}

taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,943,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["receive-handshake! (%s): %s",chsk_type,clj], null);
}),null)),null,-818325944);

var vec__86725 = clj;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86725,(0),null);
var vec__86728 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86725,(1),null);
var _QMARK_uid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86728,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86728,(1),null);
var _QMARK_handshake_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86728,(2),null);
var map__86731 = chsk;
var map__86731__$1 = (((((!((map__86731 == null))))?(((((map__86731.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__86731.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__86731):map__86731);
var chs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86731__$1,new cljs.core.Keyword(null,"chs","chs",376886120));
var ever_opened_QMARK__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86731__$1,new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913));
var first_handshake_QMARK_ = cljs.core.compare_and_set_BANG_(ever_opened_QMARK__,false,true);
var new_state = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"type","type",1174270348),chsk_type,new cljs.core.Keyword(null,"open?","open?",1238443125),true,new cljs.core.Keyword(null,"ever-opened?","ever-opened?",1128459732),true,new cljs.core.Keyword(null,"uid","uid",-1447769400),_QMARK_uid,new cljs.core.Keyword(null,"handshake-data","handshake-data",-278378864),_QMARK_handshake_data,new cljs.core.Keyword(null,"first-open?","first-open?",396686530),first_handshake_QMARK_], null);
var handshake_ev = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_uid,null,_QMARK_handshake_data,first_handshake_QMARK_], null)], null);
taoensso.sente.assert_event(handshake_ev);

taoensso.sente.swap_chsk_state_BANG_(chsk,((function (vec__86725,_,vec__86728,_QMARK_uid,___$1,_QMARK_handshake_data,map__86731,map__86731__$1,chs,ever_opened_QMARK__,first_handshake_QMARK_,new_state,handshake_ev){
return (function (p1__86699_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p1__86699_SHARP_,new_state], 0));
});})(vec__86725,_,vec__86728,_QMARK_uid,___$1,_QMARK_handshake_data,map__86731,map__86731__$1,chs,ever_opened_QMARK__,first_handshake_QMARK_,new_state,handshake_ev))
);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(chs),handshake_ev);

return new cljs.core.Keyword(null,"handled","handled",1889700151);
});
/**
 * nnil iff the websocket npm library[1] is available.
 *   Easiest way to install:
 *     1. Add the lein-npm[2] plugin to your `project.clj`,
 *     2. Add: `:npm {:dependencies [[websocket "1.0.23"]]}`
 * 
 *   [1] Ref. https://www.npmjs.com/package/websocket
 *   [2] Ref. https://github.com/RyanMcG/lein-npm
 */
taoensso.sente._QMARK_node_npm_websocket_ = (new cljs.core.Delay((function (){
if(((taoensso.sente.node_target_QMARK_) && ((typeof require !== 'undefined')))){
try{return require("websocket");
}catch (e86745){var e = e86745;
return null;
}} else {
return null;
}
}),null));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChWebSocket = (function (client_id,chs,params,packer,url,ws_kalive_ms,state_,instance_handle_,retry_count_,ever_opened_QMARK__,backoff_ms_fn,cbs_waiting_,socket_,udt_last_comms_,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.ws_kalive_ms = ws_kalive_ms;
this.state_ = state_;
this.instance_handle_ = instance_handle_;
this.retry_count_ = retry_count_;
this.ever_opened_QMARK__ = ever_opened_QMARK__;
this.backoff_ms_fn = backoff_ms_fn;
this.cbs_waiting_ = cbs_waiting_;
this.socket_ = socket_;
this.udt_last_comms_ = udt_last_comms_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k86763,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__86776 = k86763;
var G__86776__$1 = (((G__86776 instanceof cljs.core.Keyword))?G__86776.fqn:null);
switch (G__86776__$1) {
case "client-id":
return self__.client_id;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "packer":
return self__.packer;

break;
case "url":
return self__.url;

break;
case "ws-kalive-ms":
return self__.ws_kalive_ms;

break;
case "state_":
return self__.state_;

break;
case "instance-handle_":
return self__.instance_handle_;

break;
case "retry-count_":
return self__.retry_count_;

break;
case "ever-opened?_":
return self__.ever_opened_QMARK__;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "cbs-waiting_":
return self__.cbs_waiting_;

break;
case "socket_":
return self__.socket_;

break;
case "udt-last-comms_":
return self__.udt_last_comms_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k86763,else__4388__auto__);

}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__86777){
var vec__86778 = p__86777;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86778,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86778,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#taoensso.sente.ChWebSocket{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),self__.ws_kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),self__.instance_handle_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),self__.ever_opened_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"udt-last-comms_","udt-last-comms_",-145799639),self__.udt_last_comms_],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__86762){
var self__ = this;
var G__86762__$1 = this;
return (new cljs.core.RecordIter((0),G__86762__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"udt-last-comms_","udt-last-comms_",-145799639)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__86786 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (1998688700 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__86786(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this86764,other86765){
var self__ = this;
var this86764__$1 = this;
return (((!((other86765 == null)))) && ((this86764__$1.constructor === other86765.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.client_id,other86765.client_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.chs,other86765.chs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.params,other86765.params)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.packer,other86765.packer)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.url,other86765.url)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.ws_kalive_ms,other86765.ws_kalive_ms)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.state_,other86765.state_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.instance_handle_,other86765.instance_handle_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.retry_count_,other86765.retry_count_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.ever_opened_QMARK__,other86765.ever_opened_QMARK__)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.backoff_ms_fn,other86765.backoff_ms_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.cbs_waiting_,other86765.cbs_waiting_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.socket_,other86765.socket_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.udt_last_comms_,other86765.udt_last_comms_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86764__$1.__extmap,other86765.__extmap)));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),null,new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"udt-last-comms_","udt-last-comms_",-145799639),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__86762){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__86791 = cljs.core.keyword_identical_QMARK_;
var expr__86792 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__86794 = new cljs.core.Keyword(null,"client-id","client-id",-464622140);
var G__86795 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86794,G__86795) : pred__86791.call(null,G__86794,G__86795));
})())){
return (new taoensso.sente.ChWebSocket(G__86762,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86796 = new cljs.core.Keyword(null,"chs","chs",376886120);
var G__86797 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86796,G__86797) : pred__86791.call(null,G__86796,G__86797));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,G__86762,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86798 = new cljs.core.Keyword(null,"params","params",710516235);
var G__86799 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86798,G__86799) : pred__86791.call(null,G__86798,G__86799));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,G__86762,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86802 = new cljs.core.Keyword(null,"packer","packer",66077544);
var G__86803 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86802,G__86803) : pred__86791.call(null,G__86802,G__86803));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,G__86762,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86804 = new cljs.core.Keyword(null,"url","url",276297046);
var G__86805 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86804,G__86805) : pred__86791.call(null,G__86804,G__86805));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__86762,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86806 = new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968);
var G__86807 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86806,G__86807) : pred__86791.call(null,G__86806,G__86807));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__86762,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86808 = new cljs.core.Keyword(null,"state_","state_",957667102);
var G__86809 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86808,G__86809) : pred__86791.call(null,G__86808,G__86809));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,G__86762,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86810 = new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457);
var G__86811 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86810,G__86811) : pred__86791.call(null,G__86810,G__86811));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,G__86762,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86812 = new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093);
var G__86813 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86812,G__86813) : pred__86791.call(null,G__86812,G__86813));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,G__86762,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86814 = new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913);
var G__86815 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86814,G__86815) : pred__86791.call(null,G__86814,G__86815));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,G__86762,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86816 = new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955);
var G__86817 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86816,G__86817) : pred__86791.call(null,G__86816,G__86817));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,G__86762,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86820 = new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061);
var G__86821 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86820,G__86821) : pred__86791.call(null,G__86820,G__86821));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,G__86762,self__.socket_,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86822 = new cljs.core.Keyword(null,"socket_","socket_",-361048908);
var G__86823 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86822,G__86823) : pred__86791.call(null,G__86822,G__86823));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,G__86762,self__.udt_last_comms_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86826 = new cljs.core.Keyword(null,"udt-last-comms_","udt-last-comms_",-145799639);
var G__86827 = expr__86792;
return (pred__86791.cljs$core$IFn$_invoke$arity$2 ? pred__86791.cljs$core$IFn$_invoke$arity$2(G__86826,G__86827) : pred__86791.call(null,G__86826,G__86827));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,G__86762,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__86762),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"params","params",710516235),self__.params,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"url","url",276297046),self__.url,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),self__.ws_kalive_ms,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),self__.instance_handle_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),self__.ever_opened_QMARK__,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"udt-last-comms_","udt-last-comms_",-145799639),self__.udt_last_comms_,null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__86762){
var self__ = this;
var this__4384__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.ws_kalive_ms,self__.state_,self__.instance_handle_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.udt_last_comms_,G__86762,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2 = (function (chsk,reason){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_(self__.instance_handle_,null);

taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (chsk__$1){
return (function (p1__86754_SHARP_){
return taoensso.sente.chsk_state__GT_closed(p1__86754_SHARP_,reason);
});})(chsk__$1))
);

var temp__5818__auto__ = cljs.core.deref(self__.socket_);
if(cljs.core.truth_(temp__5818__auto__)){
var s = temp__5818__auto__;
return s.close((1000),"CLOSE_NORMAL");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
chsk__$1.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2(null,new cljs.core.Keyword(null,"requested-reconnect","requested-reconnect",2008347707));

return chsk__$1.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(null);
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,opts){
var self__ = this;
var chsk__$1 = this;
var map__86834 = opts;
var map__86834__$1 = (((((!((map__86834 == null))))?(((((map__86834.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__86834.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__86834):map__86834);
var _QMARK_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86834__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86834__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__86834__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var _ = taoensso.sente.assert_send_args(ev,_QMARK_timeout_ms,_QMARK_cb);
var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn(_QMARK_cb,ev);
if(cljs.core.not(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.state_)))){
return taoensso.sente.chsk_send__GT_closed_BANG_(_QMARK_cb_fn);
} else {
var _QMARK_cb_uuid = (cljs.core.truth_(_QMARK_cb_fn)?taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((6)):null);
var ppstr = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$3(self__.packer,ev,_QMARK_cb_uuid);
var temp__5818__auto___87965 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__5818__auto___87965)){
var cb_uuid_87966 = temp__5818__auto___87965;
taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid_87966], null),(function (){var e = (function (){try{if(taoensso.truss.impl.some_QMARK_(_QMARK_cb_fn)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e86838){if((e86838 instanceof Error)){
var e = e86838;
return e;
} else {
throw e86838;

}
}})();
if((e == null)){
return _QMARK_cb_fn;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",1028,"(taoensso.truss.impl/some? ?cb-fn)",_QMARK_cb_fn,e,null);
}
})());

var temp__5818__auto___87970__$1 = _QMARK_timeout_ms;
if(cljs.core.truth_(temp__5818__auto___87970__$1)){
var timeout_ms_87971 = temp__5818__auto___87970__$1;
var c__46663__auto___87972 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___87972,timeout_ms_87971,temp__5818__auto___87970__$1,cb_uuid_87966,temp__5818__auto___87965,_QMARK_cb_uuid,ppstr,map__86834,map__86834__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___87972,timeout_ms_87971,temp__5818__auto___87970__$1,cb_uuid_87966,temp__5818__auto___87965,_QMARK_cb_uuid,ppstr,map__86834,map__86834__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (state_86849){
var state_val_86850 = (state_86849[(1)]);
if((state_val_86850 === (1))){
var inst_86839 = cljs.core.async.timeout(timeout_ms_87971);
var state_86849__$1 = state_86849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86849__$1,(2),inst_86839);
} else {
if((state_val_86850 === (2))){
var inst_86842 = (state_86849[(7)]);
var inst_86841 = (state_86849[(2)]);
var inst_86842__$1 = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,_QMARK_cb_uuid);
var state_86849__$1 = (function (){var statearr_86851 = state_86849;
(statearr_86851[(8)] = inst_86841);

(statearr_86851[(7)] = inst_86842__$1);

return statearr_86851;
})();
if(cljs.core.truth_(inst_86842__$1)){
var statearr_86852_87982 = state_86849__$1;
(statearr_86852_87982[(1)] = (3));

} else {
var statearr_86853_87983 = state_86849__$1;
(statearr_86853_87983[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86850 === (3))){
var inst_86842 = (state_86849[(7)]);
var inst_86844 = (function (){var G__86857 = new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489);
return (inst_86842.cljs$core$IFn$_invoke$arity$1 ? inst_86842.cljs$core$IFn$_invoke$arity$1(G__86857) : inst_86842.call(null,G__86857));
})();
var state_86849__$1 = state_86849;
var statearr_86858_87984 = state_86849__$1;
(statearr_86858_87984[(2)] = inst_86844);

(statearr_86858_87984[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86850 === (4))){
var state_86849__$1 = state_86849;
var statearr_86859_87985 = state_86849__$1;
(statearr_86859_87985[(2)] = null);

(statearr_86859_87985[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86850 === (5))){
var inst_86847 = (state_86849[(2)]);
var state_86849__$1 = state_86849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86849__$1,inst_86847);
} else {
return null;
}
}
}
}
}
});})(c__46663__auto___87972,timeout_ms_87971,temp__5818__auto___87970__$1,cb_uuid_87966,temp__5818__auto___87965,_QMARK_cb_uuid,ppstr,map__86834,map__86834__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
;
return ((function (switch__46368__auto__,c__46663__auto___87972,timeout_ms_87971,temp__5818__auto___87970__$1,cb_uuid_87966,temp__5818__auto___87965,_QMARK_cb_uuid,ppstr,map__86834,map__86834__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function() {
var taoensso$sente$state_machine__46369__auto__ = null;
var taoensso$sente$state_machine__46369__auto____0 = (function (){
var statearr_86862 = [null,null,null,null,null,null,null,null,null];
(statearr_86862[(0)] = taoensso$sente$state_machine__46369__auto__);

(statearr_86862[(1)] = (1));

return statearr_86862;
});
var taoensso$sente$state_machine__46369__auto____1 = (function (state_86849){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_86849);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e86863){if((e86863 instanceof Object)){
var ex__46372__auto__ = e86863;
var statearr_86864_87988 = state_86849;
(statearr_86864_87988[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_86849);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e86863;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__87990 = state_86849;
state_86849 = G__87990;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$state_machine__46369__auto__ = function(state_86849){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__46369__auto____1.call(this,state_86849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__46369__auto____0;
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__46369__auto____1;
return taoensso$sente$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___87972,timeout_ms_87971,temp__5818__auto___87970__$1,cb_uuid_87966,temp__5818__auto___87965,_QMARK_cb_uuid,ppstr,map__86834,map__86834__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
})();
var state__46665__auto__ = (function (){var statearr_86865 = f__46664__auto__();
(statearr_86865[(6)] = c__46663__auto___87972);

return statearr_86865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___87972,timeout_ms_87971,temp__5818__auto___87970__$1,cb_uuid_87966,temp__5818__auto___87965,_QMARK_cb_uuid,ppstr,map__86834,map__86834__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
);

} else {
}
} else {
}

try{cljs.core.deref(self__.socket_).send(ppstr);

cljs.core.reset_BANG_(self__.udt_last_comms_,taoensso.encore.now_udt());

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}catch (e86866){var e = e86866;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente",null,1040,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,_QMARK_cb_uuid,ppstr,map__86834,map__86834__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk send error"], null);
});})(e,_QMARK_cb_uuid,ppstr,map__86834,map__86834__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
,null)),null,1061200933);

var temp__5818__auto___87996 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__5818__auto___87996)){
var cb_uuid_87997 = temp__5818__auto___87996;
var cb_fn_STAR__87998 = (function (){var or__4131__auto__ = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,cb_uuid_87997);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var e__$1 = (function (){try{if(taoensso.truss.impl.some_QMARK_(_QMARK_cb_fn)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e86867){if((e86867 instanceof Error)){
var e__$1 = e86867;
return e__$1;
} else {
throw e86867;

}
}})();
if((e__$1 == null)){
return _QMARK_cb_fn;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",1043,"(taoensso.truss.impl/some? ?cb-fn)",_QMARK_cb_fn,e__$1,null);
}
}
})();
var G__86868_87999 = new cljs.core.Keyword("chsk","error","chsk/error",-984175439);
(cb_fn_STAR__87998.cljs$core$IFn$_invoke$arity$1 ? cb_fn_STAR__87998.cljs$core$IFn$_invoke$arity$1(G__86868_87999) : cb_fn_STAR__87998.call(null,G__86868_87999));
} else {
}

return false;
}}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__5818__auto__ = (function (){var or__4131__auto__ = taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2(goog.global,"WebSocket");
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2(goog.global,"MozWebSocket");
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(taoensso.sente._QMARK_node_npm_websocket_),"w3cwebsocket");
}
}
})();
if(cljs.core.truth_(temp__5818__auto__)){
var WebSocket = temp__5818__auto__;
var instance_handle = cljs.core.reset_BANG_(self__.instance_handle_,taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0());
var have_handle_QMARK_ = ((function (instance_handle,WebSocket,temp__5818__auto__,chsk__$1){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.instance_handle_),instance_handle);
});})(instance_handle,WebSocket,temp__5818__auto__,chsk__$1))
;
var connect_fn = ((function (instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function taoensso$sente$connect_fn(){
if(have_handle_QMARK_()){
var retry_fn = ((function (instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (){
if(have_handle_QMARK_()){
var retry_count_STAR_ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.retry_count_,cljs.core.inc);
var backoff_ms = (self__.backoff_ms_fn.cljs$core$IFn$_invoke$arity$1 ? self__.backoff_ms_fn.cljs$core$IFn$_invoke$arity$1(retry_count_STAR_) : self__.backoff_ms_fn.call(null,retry_count_STAR_));
var udt_next_reconnect = (taoensso.encore.now_udt() + backoff_ms);
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1065,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect attempt (%s) in %s ms",retry_count_STAR_,backoff_ms], null);
});})(retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
,null)),null,1134296239);

goog.global.setTimeout(taoensso$sente$connect_fn,backoff_ms);

return taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (p1__86757_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__86757_SHARP_,new cljs.core.Keyword(null,"udt-next-reconnect","udt-next-reconnect",-1990375733),udt_next_reconnect);
});})(retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
);
} else {
return null;
}
});})(instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
;
var _QMARK_socket = (function (){try{return (new WebSocket(taoensso.encore.merge_url_with_query_string(self__.url,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([self__.params,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.state_))], null)], 0)))));
}catch (e86874){var e = e86874;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente",null,1080,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,retry_fn,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"WebSocket error"], null);
});})(e,retry_fn,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
,null)),null,1993397381);

return null;
}})();
if(cljs.core.not(_QMARK_socket)){
return retry_fn();
} else {
return cljs.core.reset_BANG_(self__.socket_,(function (){var G__86878 = _QMARK_socket;
(G__86878["onerror"] = ((function (G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (ws_ev){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente",null,1090,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["WebSocket error: %s",(function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(ws_ev);
}catch (e86879){var _ = e86879;
return ws_ev;
}})()], null);
});})(G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
,null)),null,-2120417541);

var last_ws_error = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"udt","udt",2011712751),taoensso.encore.now_udt(),new cljs.core.Keyword(null,"ev","ev",-406827324),ws_ev], null);
return taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (last_ws_error,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (p1__86759_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__86759_SHARP_,new cljs.core.Keyword(null,"last-ws-error","last-ws-error",-820288502),last_ws_error);
});})(last_ws_error,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
);
});})(G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
);

(G__86878["onmessage"] = ((function (G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (ws_ev){
var ppstr = taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2(ws_ev,"data");
var vec__86882 = taoensso.sente.unpack(self__.packer,ppstr);
var clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86882,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86882,(1),null);
cljs.core.reset_BANG_(self__.udt_last_comms_,taoensso.encore.now_udt());

var or__4131__auto__ = ((taoensso.sente.handshake_QMARK_(clj))?(function (){
taoensso.sente.receive_handshake_BANG_(new cljs.core.Keyword(null,"ws","ws",86841443),chsk__$1,clj);

cljs.core.reset_BANG_(self__.retry_count_,(0));

return new cljs.core.Keyword(null,"handshake","handshake",68079331);
})()
:null);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clj,new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304)))?(function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(self__.chs),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304)], null));

return new cljs.core.Keyword(null,"noop","noop",-673731258);
})()
:null);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
var temp__5816__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__5816__auto__)){
var cb_uuid = temp__5816__auto__;
var temp__5816__auto____$1 = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,cb_uuid);
if(cljs.core.truth_(temp__5816__auto____$1)){
var cb_fn = temp__5816__auto____$1;
return (cb_fn.cljs$core$IFn$_invoke$arity$1 ? cb_fn.cljs$core$IFn$_invoke$arity$1(clj) : cb_fn.call(null,clj));
} else {
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1126,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (temp__5816__auto____$1,cb_uuid,temp__5816__auto__,or__4131__auto____$1,or__4131__auto__,ppstr,vec__86882,clj,_QMARK_cb_uuid,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",clj], null);
});})(temp__5816__auto____$1,cb_uuid,temp__5816__auto__,or__4131__auto____$1,or__4131__auto__,ppstr,vec__86882,clj,_QMARK_cb_uuid,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
,null)),null,2000185018);
}
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_(self__.chs,buffered_evs);
}
}
}
});})(G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
);

(G__86878["onclose"] = ((function (G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (ws_ev){
var clean_QMARK_ = taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2(ws_ev,"wasClean");
var code = taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2(ws_ev,"code");
var reason = taoensso.encore.oget.cljs$core$IFn$_invoke$arity$2(ws_ev,"reason");
var last_ws_close = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"udt","udt",2011712751),taoensso.encore.now_udt(),new cljs.core.Keyword(null,"ev","ev",-406827324),ws_ev,new cljs.core.Keyword(null,"clean?","clean?",-1675631009),clean_QMARK_,new cljs.core.Keyword(null,"code","code",1586293142),code,new cljs.core.Keyword(null,"reason","reason",-2070751759),reason], null);
if(cljs.core.truth_(clean_QMARK_)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente",null,1148,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (clean_QMARK_,code,reason,last_ws_close,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Clean WebSocket close, will not attempt reconnect"], null);
});})(clean_QMARK_,code,reason,last_ws_close,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
,null)),null,247301955);

return taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (clean_QMARK_,code,reason,last_ws_close,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (p1__86760_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__86760_SHARP_,new cljs.core.Keyword(null,"last-ws-close","last-ws-close",-798104932),last_ws_close);
});})(clean_QMARK_,code,reason,last_ws_close,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
);
} else {
taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (clean_QMARK_,code,reason,last_ws_close,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1){
return (function (p1__86761_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(taoensso.sente.chsk_state__GT_closed(p1__86761_SHARP_,new cljs.core.Keyword(null,"unexpected","unexpected",-1137752424)),new cljs.core.Keyword(null,"last-ws-close","last-ws-close",-798104932),last_ws_close);
});})(clean_QMARK_,code,reason,last_ws_close,G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
);

return retry_fn();
}
});})(G__86878,retry_fn,_QMARK_socket,instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
);

return G__86878;
})());
}
} else {
return null;
}
});})(instance_handle,have_handle_QMARK_,WebSocket,temp__5818__auto__,chsk__$1))
;
var temp__5818__auto___88018__$1 = self__.ws_kalive_ms;
if(cljs.core.truth_(temp__5818__auto___88018__$1)){
var ms_88019 = temp__5818__auto___88018__$1;
var c__46663__auto___88020 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___88020,ms_88019,temp__5818__auto___88018__$1,instance_handle,have_handle_QMARK_,connect_fn,WebSocket,temp__5818__auto__,chsk__$1){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___88020,ms_88019,temp__5818__auto___88018__$1,instance_handle,have_handle_QMARK_,connect_fn,WebSocket,temp__5818__auto__,chsk__$1){
return (function (state_86917){
var state_val_86918 = (state_86917[(1)]);
if((state_val_86918 === (7))){
var inst_86913 = (state_86917[(2)]);
var state_86917__$1 = state_86917;
var statearr_86919_88021 = state_86917__$1;
(statearr_86919_88021[(2)] = inst_86913);

(statearr_86919_88021[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86918 === (1))){
var state_86917__$1 = state_86917;
var statearr_86921_88022 = state_86917__$1;
(statearr_86921_88022[(2)] = null);

(statearr_86921_88022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86918 === (4))){
var inst_86894 = (state_86917[(2)]);
var inst_86895 = have_handle_QMARK_();
var state_86917__$1 = (function (){var statearr_86923 = state_86917;
(statearr_86923[(7)] = inst_86894);

return statearr_86923;
})();
if(inst_86895){
var statearr_86924_88023 = state_86917__$1;
(statearr_86924_88023[(1)] = (5));

} else {
var statearr_86925_88024 = state_86917__$1;
(statearr_86925_88024[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86918 === (6))){
var state_86917__$1 = state_86917;
var statearr_86929_88025 = state_86917__$1;
(statearr_86929_88025[(2)] = null);

(statearr_86929_88025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86918 === (3))){
var inst_86915 = (state_86917[(2)]);
var state_86917__$1 = state_86917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86917__$1,inst_86915);
} else {
if((state_val_86918 === (2))){
var inst_86891 = cljs.core.deref(self__.udt_last_comms_);
var inst_86892 = cljs.core.async.timeout(ms_88019);
var state_86917__$1 = (function (){var statearr_86930 = state_86917;
(statearr_86930[(8)] = inst_86891);

return statearr_86930;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86917__$1,(4),inst_86892);
} else {
if((state_val_86918 === (9))){
var state_86917__$1 = state_86917;
var statearr_86931_88026 = state_86917__$1;
(statearr_86931_88026[(2)] = null);

(statearr_86931_88026[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86918 === (5))){
var inst_86891 = (state_86917[(8)]);
var inst_86897 = cljs.core.deref(self__.udt_last_comms_);
var inst_86898 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_86891,inst_86897);
var state_86917__$1 = state_86917;
if(inst_86898){
var statearr_86932_88027 = state_86917__$1;
(statearr_86932_88027[(1)] = (8));

} else {
var statearr_86933_88028 = state_86917__$1;
(statearr_86933_88028[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86918 === (10))){
var inst_86909 = (state_86917[(2)]);
var state_86917__$1 = (function (){var statearr_86935 = state_86917;
(statearr_86935[(9)] = inst_86909);

return statearr_86935;
})();
var statearr_86937_88030 = state_86917__$1;
(statearr_86937_88030[(2)] = null);

(statearr_86937_88030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_86918 === (8))){
var inst_86900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86901 = [new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304)];
var inst_86902 = (new cljs.core.PersistentVector(null,1,(5),inst_86900,inst_86901,null));
var inst_86903 = [new cljs.core.Keyword(null,"flush?","flush?",-108887231)];
var inst_86904 = [true];
var inst_86905 = cljs.core.PersistentHashMap.fromArrays(inst_86903,inst_86904);
var inst_86906 = chsk__$1.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3(null,inst_86902,inst_86905);
var state_86917__$1 = state_86917;
var statearr_86938_88034 = state_86917__$1;
(statearr_86938_88034[(2)] = inst_86906);

(statearr_86938_88034[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___88020,ms_88019,temp__5818__auto___88018__$1,instance_handle,have_handle_QMARK_,connect_fn,WebSocket,temp__5818__auto__,chsk__$1))
;
return ((function (switch__46368__auto__,c__46663__auto___88020,ms_88019,temp__5818__auto___88018__$1,instance_handle,have_handle_QMARK_,connect_fn,WebSocket,temp__5818__auto__,chsk__$1){
return (function() {
var taoensso$sente$state_machine__46369__auto__ = null;
var taoensso$sente$state_machine__46369__auto____0 = (function (){
var statearr_86944 = [null,null,null,null,null,null,null,null,null,null];
(statearr_86944[(0)] = taoensso$sente$state_machine__46369__auto__);

(statearr_86944[(1)] = (1));

return statearr_86944;
});
var taoensso$sente$state_machine__46369__auto____1 = (function (state_86917){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_86917);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e86945){if((e86945 instanceof Object)){
var ex__46372__auto__ = e86945;
var statearr_86947_88040 = state_86917;
(statearr_86947_88040[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_86917);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e86945;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88042 = state_86917;
state_86917 = G__88042;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$state_machine__46369__auto__ = function(state_86917){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__46369__auto____1.call(this,state_86917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__46369__auto____0;
taoensso$sente$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__46369__auto____1;
return taoensso$sente$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___88020,ms_88019,temp__5818__auto___88018__$1,instance_handle,have_handle_QMARK_,connect_fn,WebSocket,temp__5818__auto__,chsk__$1))
})();
var state__46665__auto__ = (function (){var statearr_86948 = f__46664__auto__();
(statearr_86948[(6)] = c__46663__auto___88020);

return statearr_86948;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___88020,ms_88019,temp__5818__auto___88018__$1,instance_handle,have_handle_QMARK_,connect_fn,WebSocket,temp__5818__auto__,chsk__$1))
);

} else {
}

cljs.core.reset_BANG_(self__.retry_count_,(0));

connect_fn();

return chsk__$1;
} else {
return null;
}
});

taoensso.sente.ChWebSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"ws-kalive-ms","ws-kalive-ms",-1212255801,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"instance-handle_","instance-handle_",-282852930,null),new cljs.core.Symbol(null,"retry-count_","retry-count_",1660769620,null),new cljs.core.Symbol(null,"ever-opened?_","ever-opened?_",-1013096856,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null),new cljs.core.Symbol(null,"cbs-waiting_","cbs-waiting_",121502466,null),new cljs.core.Symbol(null,"socket_","socket_",1279482619,null),new cljs.core.Symbol(null,"udt-last-comms_","udt-last-comms_",1494731888,null)], null);
});

taoensso.sente.ChWebSocket.cljs$lang$type = true;

taoensso.sente.ChWebSocket.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"taoensso.sente/ChWebSocket",null,(1),null));
});

taoensso.sente.ChWebSocket.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"taoensso.sente/ChWebSocket");
});

/**
 * Positional factory function for taoensso.sente/ChWebSocket.
 */
taoensso.sente.__GT_ChWebSocket = (function taoensso$sente$__GT_ChWebSocket(client_id,chs,params,packer,url,ws_kalive_ms,state_,instance_handle_,retry_count_,ever_opened_QMARK__,backoff_ms_fn,cbs_waiting_,socket_,udt_last_comms_){
return (new taoensso.sente.ChWebSocket(client_id,chs,params,packer,url,ws_kalive_ms,state_,instance_handle_,retry_count_,ever_opened_QMARK__,backoff_ms_fn,cbs_waiting_,socket_,udt_last_comms_,null,null,null));
});

/**
 * Factory function for taoensso.sente/ChWebSocket, taking a map of keywords to field values.
 */
taoensso.sente.map__GT_ChWebSocket = (function taoensso$sente$map__GT_ChWebSocket(G__86768){
var extmap__4424__auto__ = (function (){var G__86949 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__86768,new cljs.core.Keyword(null,"client-id","client-id",-464622140),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908),new cljs.core.Keyword(null,"udt-last-comms_","udt-last-comms_",-145799639)], 0));
if(cljs.core.record_QMARK_(G__86768)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__86949);
} else {
return G__86949;
}
})();
return (new taoensso.sente.ChWebSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"socket_","socket_",-361048908).cljs$core$IFn$_invoke$arity$1(G__86768),new cljs.core.Keyword(null,"udt-last-comms_","udt-last-comms_",-145799639).cljs$core$IFn$_invoke$arity$1(G__86768),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

taoensso.sente.new_ChWebSocket = (function taoensso$sente$new_ChWebSocket(opts,csrf_token){
return taoensso.sente.map__GT_ChWebSocket(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"state_","state_",957667102),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"ever-opened?","ever-opened?",1128459732),false,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),csrf_token], null)),new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"socket_","socket_",-361048908),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null),new cljs.core.Keyword(null,"udt-last-comms_","udt-last-comms_",-145799639),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null)], null),opts], 0)));
});
/**
 * We must set *some* client-side timeout otherwise an unpredictable (and
 *   probably too short) browser default will be used. Must be > server's
 *   :lp-timeout-ms.
 */
taoensso.sente.default_client_side_ajax_timeout_ms = taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"secs","secs",1532330091),(60)], 0));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAjaxSocket = (function (client_id,chs,params,packer,url,state_,instance_handle_,ever_opened_QMARK__,backoff_ms_fn,ajax_opts,curr_xhr_,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.instance_handle_ = instance_handle_;
this.ever_opened_QMARK__ = ever_opened_QMARK__;
this.backoff_ms_fn = backoff_ms_fn;
this.ajax_opts = ajax_opts;
this.curr_xhr_ = curr_xhr_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k86966,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__86970 = k86966;
var G__86970__$1 = (((G__86970 instanceof cljs.core.Keyword))?G__86970.fqn:null);
switch (G__86970__$1) {
case "client-id":
return self__.client_id;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "packer":
return self__.packer;

break;
case "url":
return self__.url;

break;
case "state_":
return self__.state_;

break;
case "instance-handle_":
return self__.instance_handle_;

break;
case "ever-opened?_":
return self__.ever_opened_QMARK__;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "ajax-opts":
return self__.ajax_opts;

break;
case "curr-xhr_":
return self__.curr_xhr_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k86966,else__4388__auto__);

}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__86971){
var vec__86972 = p__86971;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86972,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86972,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#taoensso.sente.ChAjaxSocket{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),self__.instance_handle_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),self__.ever_opened_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__86965){
var self__ = this;
var G__86965__$1 = this;
return (new cljs.core.RecordIter((0),G__86965__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__86979 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-266770752 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__86979(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this86967,other86968){
var self__ = this;
var this86967__$1 = this;
return (((!((other86968 == null)))) && ((this86967__$1.constructor === other86968.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.client_id,other86968.client_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.chs,other86968.chs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.params,other86968.params)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.packer,other86968.packer)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.url,other86968.url)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.state_,other86968.state_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.instance_handle_,other86968.instance_handle_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.ever_opened_QMARK__,other86968.ever_opened_QMARK__)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.backoff_ms_fn,other86968.backoff_ms_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.ajax_opts,other86968.ajax_opts)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.curr_xhr_,other86968.curr_xhr_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86967__$1.__extmap,other86968.__extmap)));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),null,new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__86965){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__86982 = cljs.core.keyword_identical_QMARK_;
var expr__86983 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__86985 = new cljs.core.Keyword(null,"client-id","client-id",-464622140);
var G__86986 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__86985,G__86986) : pred__86982.call(null,G__86985,G__86986));
})())){
return (new taoensso.sente.ChAjaxSocket(G__86965,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86987 = new cljs.core.Keyword(null,"chs","chs",376886120);
var G__86988 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__86987,G__86988) : pred__86982.call(null,G__86987,G__86988));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,G__86965,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86989 = new cljs.core.Keyword(null,"params","params",710516235);
var G__86990 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__86989,G__86990) : pred__86982.call(null,G__86989,G__86990));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,G__86965,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86991 = new cljs.core.Keyword(null,"packer","packer",66077544);
var G__86992 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__86991,G__86992) : pred__86982.call(null,G__86991,G__86992));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,G__86965,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86993 = new cljs.core.Keyword(null,"url","url",276297046);
var G__86994 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__86993,G__86994) : pred__86982.call(null,G__86993,G__86994));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__86965,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86995 = new cljs.core.Keyword(null,"state_","state_",957667102);
var G__86996 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__86995,G__86996) : pred__86982.call(null,G__86995,G__86996));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__86965,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86999 = new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457);
var G__87000 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__86999,G__87000) : pred__86982.call(null,G__86999,G__87000));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__86965,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__87002 = new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913);
var G__87003 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__87002,G__87003) : pred__86982.call(null,G__87002,G__87003));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,G__86965,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__87004 = new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955);
var G__87005 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__87004,G__87005) : pred__86982.call(null,G__87004,G__87005));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,G__86965,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__87007 = new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109);
var G__87008 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__87007,G__87008) : pred__86982.call(null,G__87007,G__87008));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,G__86965,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__87010 = new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696);
var G__87011 = expr__86983;
return (pred__86982.cljs$core$IFn$_invoke$arity$2 ? pred__86982.cljs$core$IFn$_invoke$arity$2(G__87010,G__87011) : pred__86982.call(null,G__87010,G__87011));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,G__86965,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__86965),null));
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"params","params",710516235),self__.params,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"url","url",276297046),self__.url,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),self__.instance_handle_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),self__.ever_opened_QMARK__,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_,null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__86965){
var self__ = this;
var this__4384__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.instance_handle_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,G__86965,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2 = (function (chsk,reason){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_(self__.instance_handle_,null);

taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (chsk__$1){
return (function (p1__86958_SHARP_){
return taoensso.sente.chsk_state__GT_closed(p1__86958_SHARP_,reason);
});})(chsk__$1))
);

var temp__5818__auto__ = cljs.core.deref(self__.curr_xhr_);
if(cljs.core.truth_(temp__5818__auto__)){
var x = temp__5818__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
chsk__$1.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2(null,new cljs.core.Keyword(null,"requested-reconnect","requested-reconnect",2008347707));

return chsk__$1.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(null);
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,opts){
var self__ = this;
var chsk__$1 = this;
var map__87014 = opts;
var map__87014__$1 = (((((!((map__87014 == null))))?(((((map__87014.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87014.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87014):map__87014);
var _QMARK_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87014__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87014__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87014__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var _ = taoensso.sente.assert_send_args(ev,_QMARK_timeout_ms,_QMARK_cb);
var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn(_QMARK_cb,ev);
if(cljs.core.not(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.state_)))){
return taoensso.sente.chsk_send__GT_closed_BANG_(_QMARK_cb_fn);
} else {
var csrf_token = new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.state_));
var G__87017_88099 = self__.url;
var G__87018_88100 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),(function (){var or__4131__auto__ = _QMARK_timeout_ms;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return taoensso.sente.default_client_side_ajax_timeout_ms;
}
}
})(),new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"X-CSRF-Token","X-CSRF-Token",1562992453),csrf_token], null)], 0)),new cljs.core.Keyword(null,"params","params",710516235),(function (){var ppstr = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$3(self__.packer,ev,(cljs.core.truth_(_QMARK_cb_fn)?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):null));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([self__.params,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"udt","udt",2011712751),taoensso.encore.now_udt(),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),csrf_token,new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252),ppstr], null)], 0));
})()], null)], 0));
var G__87019_88101 = ((function (G__87017_88099,G__87018_88100,csrf_token,map__87014,map__87014__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function taoensso$sente$ajax_cb(p__87022){
var map__87023 = p__87022;
var map__87023__$1 = (((((!((map__87023 == null))))?(((((map__87023.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87023.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87023):map__87023);
var _QMARK_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87023__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87023__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
if(cljs.core.truth_(_QMARK_cb_fn)){
var G__87025 = new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489);
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__87025) : _QMARK_cb_fn.call(null,G__87025));
} else {
return null;
}
} else {
taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (map__87023,map__87023__$1,_QMARK_error,_QMARK_content,G__87017_88099,G__87018_88100,csrf_token,map__87014,map__87014__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (p1__86959_SHARP_){
return taoensso.sente.chsk_state__GT_closed(p1__86959_SHARP_,new cljs.core.Keyword(null,"unexpected","unexpected",-1137752424));
});})(map__87023,map__87023__$1,_QMARK_error,_QMARK_content,G__87017_88099,G__87018_88100,csrf_token,map__87014,map__87014__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
);

if(cljs.core.truth_(_QMARK_cb_fn)){
var G__87026 = new cljs.core.Keyword("chsk","error","chsk/error",-984175439);
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__87026) : _QMARK_cb_fn.call(null,G__87026));
} else {
return null;
}
}
} else {
var content = _QMARK_content;
var resp_ppstr = content;
var vec__87027 = taoensso.sente.unpack(self__.packer,resp_ppstr);
var resp_clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87027,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87027,(1),null);
if(cljs.core.truth_(_QMARK_cb_fn)){
(_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(resp_clj) : _QMARK_cb_fn.call(null,resp_clj));
} else {
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(resp_clj,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337))){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1269,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (content,resp_ppstr,vec__87027,resp_clj,___$1,map__87023,map__87023__$1,_QMARK_error,_QMARK_content,G__87017_88099,G__87018_88100,csrf_token,map__87014,map__87014__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",resp_clj], null);
});})(content,resp_ppstr,vec__87027,resp_clj,___$1,map__87023,map__87023__$1,_QMARK_error,_QMARK_content,G__87017_88099,G__87018_88100,csrf_token,map__87014,map__87014__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
,null)),null,2124565173);
} else {
}
}

return taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (content,resp_ppstr,vec__87027,resp_clj,___$1,map__87023,map__87023__$1,_QMARK_error,_QMARK_content,G__87017_88099,G__87018_88100,csrf_token,map__87014,map__87014__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (p1__86960_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__86960_SHARP_,new cljs.core.Keyword(null,"open?","open?",1238443125),true);
});})(content,resp_ppstr,vec__87027,resp_clj,___$1,map__87023,map__87023__$1,_QMARK_error,_QMARK_content,G__87017_88099,G__87018_88100,csrf_token,map__87014,map__87014__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
);
}
});})(G__87017_88099,G__87018_88100,csrf_token,map__87014,map__87014__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
;
(taoensso.sente.ajax_lite.cljs$core$IFn$_invoke$arity$3 ? taoensso.sente.ajax_lite.cljs$core$IFn$_invoke$arity$3(G__87017_88099,G__87018_88100,G__87019_88101) : taoensso.sente.ajax_lite.call(null,G__87017_88099,G__87018_88100,G__87019_88101));

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var instance_handle = cljs.core.reset_BANG_(self__.instance_handle_,taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0());
var have_handle_QMARK_ = ((function (instance_handle,chsk__$1){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.instance_handle_),instance_handle);
});})(instance_handle,chsk__$1))
;
var poll_fn = ((function (instance_handle,have_handle_QMARK_,chsk__$1){
return (function taoensso$sente$poll_fn(retry_count){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,1279,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (instance_handle,have_handle_QMARK_,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["async-poll-for-update!"], null);
});})(instance_handle,have_handle_QMARK_,chsk__$1))
,null)),null,-1769957641);

if(have_handle_QMARK_()){
var retry_fn = ((function (instance_handle,have_handle_QMARK_,chsk__$1){
return (function (){
if(have_handle_QMARK_()){
var retry_count_STAR_ = (retry_count + (1));
var backoff_ms = (self__.backoff_ms_fn.cljs$core$IFn$_invoke$arity$1 ? self__.backoff_ms_fn.cljs$core$IFn$_invoke$arity$1(retry_count_STAR_) : self__.backoff_ms_fn.call(null,retry_count_STAR_));
var udt_next_reconnect = (taoensso.encore.now_udt() + backoff_ms);
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1287,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect attempt (%s) in %s ms",retry_count_STAR_,backoff_ms], null);
});})(retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,chsk__$1))
,null)),null,-888053242);

goog.global.setTimeout(((function (retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,chsk__$1){
return (function (){
return taoensso$sente$poll_fn(retry_count_STAR_);
});})(retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,chsk__$1))
,backoff_ms);

return taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,chsk__$1){
return (function (p1__86961_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__86961_SHARP_,new cljs.core.Keyword(null,"udt-next-reconnect","udt-next-reconnect",-1990375733),udt_next_reconnect);
});})(retry_count_STAR_,backoff_ms,udt_next_reconnect,instance_handle,have_handle_QMARK_,chsk__$1))
);
} else {
return null;
}
});})(instance_handle,have_handle_QMARK_,chsk__$1))
;
return cljs.core.reset_BANG_(self__.curr_xhr_,(function (){var G__87030 = self__.url;
var G__87031 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return taoensso.sente.default_client_side_ajax_timeout_ms;
}
})(),new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([self__.params,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"udt","udt",2011712751),taoensso.encore.now_udt(),new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null),(cljs.core.truth_(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.state_)))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handshake?","handshake?",-423743093),true], null))], 0)),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"X-CSRF-Token","X-CSRF-Token",1562992453),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.state_))], null)], 0))], null)], 0));
var G__87032 = ((function (G__87030,G__87031,retry_fn,instance_handle,have_handle_QMARK_,chsk__$1){
return (function taoensso$sente$poll_fn_$_ajax_cb(p__87033){
var map__87034 = p__87033;
var map__87034__$1 = (((((!((map__87034 == null))))?(((((map__87034.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87034.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87034):map__87034);
var _QMARK_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87034__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87034__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
return taoensso$sente$poll_fn((0));
} else {
taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (map__87034,map__87034__$1,_QMARK_error,_QMARK_content,G__87030,G__87031,retry_fn,instance_handle,have_handle_QMARK_,chsk__$1){
return (function (p1__86962_SHARP_){
return taoensso.sente.chsk_state__GT_closed(p1__86962_SHARP_,new cljs.core.Keyword(null,"unexpected","unexpected",-1137752424));
});})(map__87034,map__87034__$1,_QMARK_error,_QMARK_content,G__87030,G__87031,retry_fn,instance_handle,have_handle_QMARK_,chsk__$1))
);

return retry_fn();

}
} else {
var content = _QMARK_content;
var ppstr = content;
var vec__87036 = taoensso.sente.unpack(self__.packer,ppstr);
var clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87036,(0),null);
var handshake_QMARK_ = taoensso.sente.handshake_QMARK_(clj);
if(handshake_QMARK_){
taoensso.sente.receive_handshake_BANG_(new cljs.core.Keyword(null,"ajax","ajax",814345549),chsk__$1,clj);
} else {
}

taoensso.sente.swap_chsk_state_BANG_(chsk__$1,((function (content,ppstr,vec__87036,clj,handshake_QMARK_,map__87034,map__87034__$1,_QMARK_error,_QMARK_content,G__87030,G__87031,retry_fn,instance_handle,have_handle_QMARK_,chsk__$1){
return (function (p1__86964_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__86964_SHARP_,new cljs.core.Keyword(null,"open?","open?",1238443125),true);
});})(content,ppstr,vec__87036,clj,handshake_QMARK_,map__87034,map__87034__$1,_QMARK_error,_QMARK_content,G__87030,G__87031,retry_fn,instance_handle,have_handle_QMARK_,chsk__$1))
);

taoensso$sente$poll_fn((0));

if(handshake_QMARK_){
return null;
} else {
var or__4131__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clj,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489)))?(function (){
if(cljs.core.truth_(cljs.core.deref(taoensso.sente.debug_mode_QMARK__))){
taoensso.sente.receive_buffered_evs_BANG_(self__.chs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("debug","timeout","debug/timeout",309499949)], null)], null));
} else {
}

return new cljs.core.Keyword(null,"noop","noop",-673731258);
})()
:null);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_(self__.chs,buffered_evs);
}
}
}
});})(G__87030,G__87031,retry_fn,instance_handle,have_handle_QMARK_,chsk__$1))
;
return (taoensso.sente.ajax_lite.cljs$core$IFn$_invoke$arity$3 ? taoensso.sente.ajax_lite.cljs$core$IFn$_invoke$arity$3(G__87030,G__87031,G__87032) : taoensso.sente.ajax_lite.call(null,G__87030,G__87031,G__87032));
})());
} else {
return null;
}
});})(instance_handle,have_handle_QMARK_,chsk__$1))
;
poll_fn((0));

return chsk__$1;
});

taoensso.sente.ChAjaxSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"instance-handle_","instance-handle_",-282852930,null),new cljs.core.Symbol(null,"ever-opened?_","ever-opened?_",-1013096856,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null),new cljs.core.Symbol(null,"ajax-opts","ajax-opts",1122292418,null),new cljs.core.Symbol(null,"curr-xhr_","curr-xhr_",321757831,null)], null);
});

taoensso.sente.ChAjaxSocket.cljs$lang$type = true;

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"taoensso.sente/ChAjaxSocket",null,(1),null));
});

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"taoensso.sente/ChAjaxSocket");
});

/**
 * Positional factory function for taoensso.sente/ChAjaxSocket.
 */
taoensso.sente.__GT_ChAjaxSocket = (function taoensso$sente$__GT_ChAjaxSocket(client_id,chs,params,packer,url,state_,instance_handle_,ever_opened_QMARK__,backoff_ms_fn,ajax_opts,curr_xhr_){
return (new taoensso.sente.ChAjaxSocket(client_id,chs,params,packer,url,state_,instance_handle_,ever_opened_QMARK__,backoff_ms_fn,ajax_opts,curr_xhr_,null,null,null));
});

/**
 * Factory function for taoensso.sente/ChAjaxSocket, taking a map of keywords to field values.
 */
taoensso.sente.map__GT_ChAjaxSocket = (function taoensso$sente$map__GT_ChAjaxSocket(G__86969){
var extmap__4424__auto__ = (function (){var G__87042 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__86969,new cljs.core.Keyword(null,"client-id","client-id",-464622140),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696)], 0));
if(cljs.core.record_QMARK_(G__86969)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__87042);
} else {
return G__87042;
}
})();
return (new taoensso.sente.ChAjaxSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109).cljs$core$IFn$_invoke$arity$1(G__86969),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696).cljs$core$IFn$_invoke$arity$1(G__86969),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

taoensso.sente.new_ChAjaxSocket = (function taoensso$sente$new_ChAjaxSocket(opts,csrf_token){
return taoensso.sente.map__GT_ChAjaxSocket(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"state_","state_",957667102),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ajax","ajax",814345549),new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"ever-opened?","ever-opened?",1128459732),false,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),csrf_token], null)),new cljs.core.Keyword(null,"instance-handle_","instance-handle_",-1923384457),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null)], null),opts], 0)));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAutoSocket = (function (ws_chsk_opts,ajax_chsk_opts,state_,impl_,__meta,__extmap,__hash){
this.ws_chsk_opts = ws_chsk_opts;
this.ajax_chsk_opts = ajax_chsk_opts;
this.state_ = state_;
this.impl_ = impl_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
taoensso.sente.ChAutoSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k87045,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__87049 = k87045;
var G__87049__$1 = (((G__87049 instanceof cljs.core.Keyword))?G__87049.fqn:null);
switch (G__87049__$1) {
case "ws-chsk-opts":
return self__.ws_chsk_opts;

break;
case "ajax-chsk-opts":
return self__.ajax_chsk_opts;

break;
case "state_":
return self__.state_;

break;
case "impl_":
return self__.impl_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k87045,else__4388__auto__);

}
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__87050){
var vec__87051 = p__87050;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87051,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87051,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#taoensso.sente.ChAutoSocket{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),self__.ws_chsk_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),self__.ajax_chsk_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"impl_","impl_",1218818179),self__.impl_],null))], null),self__.__extmap));
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__87044){
var self__ = this;
var G__87044__$1 = this;
return (new cljs.core.RecordIter((0),G__87044__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"impl_","impl_",1218818179)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,self__.impl_,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (4 + cljs.core.count(self__.__extmap));
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__87058 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1193508708 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__87058(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this87046,other87047){
var self__ = this;
var this87046__$1 = this;
return (((!((other87047 == null)))) && ((this87046__$1.constructor === other87047.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this87046__$1.ws_chsk_opts,other87047.ws_chsk_opts)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this87046__$1.ajax_chsk_opts,other87047.ajax_chsk_opts)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this87046__$1.state_,other87047.state_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this87046__$1.impl_,other87047.impl_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this87046__$1.__extmap,other87047.__extmap)));
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"impl_","impl_",1218818179),null,new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),null,new cljs.core.Keyword(null,"state_","state_",957667102),null,new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,self__.impl_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__87044){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__87067 = cljs.core.keyword_identical_QMARK_;
var expr__87068 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__87070 = new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104);
var G__87071 = expr__87068;
return (pred__87067.cljs$core$IFn$_invoke$arity$2 ? pred__87067.cljs$core$IFn$_invoke$arity$2(G__87070,G__87071) : pred__87067.call(null,G__87070,G__87071));
})())){
return (new taoensso.sente.ChAutoSocket(G__87044,self__.ajax_chsk_opts,self__.state_,self__.impl_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__87072 = new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327);
var G__87073 = expr__87068;
return (pred__87067.cljs$core$IFn$_invoke$arity$2 ? pred__87067.cljs$core$IFn$_invoke$arity$2(G__87072,G__87073) : pred__87067.call(null,G__87072,G__87073));
})())){
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,G__87044,self__.state_,self__.impl_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__87074 = new cljs.core.Keyword(null,"state_","state_",957667102);
var G__87075 = expr__87068;
return (pred__87067.cljs$core$IFn$_invoke$arity$2 ? pred__87067.cljs$core$IFn$_invoke$arity$2(G__87074,G__87075) : pred__87067.call(null,G__87074,G__87075));
})())){
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,G__87044,self__.impl_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__87076 = new cljs.core.Keyword(null,"impl_","impl_",1218818179);
var G__87077 = expr__87068;
return (pred__87067.cljs$core$IFn$_invoke$arity$2 ? pred__87067.cljs$core$IFn$_invoke$arity$2(G__87076,G__87077) : pred__87067.call(null,G__87076,G__87077));
})())){
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,G__87044,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,self__.impl_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__87044),null));
}
}
}
}
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),self__.ws_chsk_opts,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),self__.ajax_chsk_opts,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"impl_","impl_",1218818179),self__.impl_,null))], null),self__.__extmap));
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__87044){
var self__ = this;
var this__4384__auto____$1 = this;
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,self__.impl_,G__87044,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAutoSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2 = (function (chsk,reason){
var self__ = this;
var chsk__$1 = this;
var temp__5818__auto__ = cljs.core.deref(self__.impl_);
if(cljs.core.truth_(temp__5818__auto__)){
var impl = temp__5818__auto__;
return taoensso.sente._chsk_disconnect_BANG_(impl,reason);
} else {
return null;
}
});

taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__5818__auto__ = cljs.core.deref(self__.impl_);
if(cljs.core.truth_(temp__5818__auto__)){
var impl = temp__5818__auto__;
taoensso.sente._chsk_disconnect_BANG_(impl,new cljs.core.Keyword(null,"requested-reconnect","requested-reconnect",2008347707));

return chsk__$1.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(null);
} else {
return null;
}
});

taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,opts){
var self__ = this;
var chsk__$1 = this;
var temp__5816__auto__ = cljs.core.deref(self__.impl_);
if(cljs.core.truth_(temp__5816__auto__)){
var impl = temp__5816__auto__;
return taoensso.sente._chsk_send_BANG_(impl,ev,opts);
} else {
var map__87079 = opts;
var map__87079__$1 = (((((!((map__87079 == null))))?(((((map__87079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87079.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87079):map__87079);
var _QMARK_cb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87079__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn(_QMARK_cb,ev);
return taoensso.sente.chsk_send__GT_closed_BANG_(_QMARK_cb_fn);
}
});

taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var ajax_chsk_opts__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.ajax_chsk_opts,new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_);
var ws_chsk_opts__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.ws_chsk_opts,new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_);
var ajax_conn_BANG_ = ((function (ajax_chsk_opts__$1,ws_chsk_opts__$1,chsk__$1){
return (function (){
cljs.core.remove_watch(self__.state_,new cljs.core.Keyword("chsk","auto-ajax-downgrade","chsk/auto-ajax-downgrade",-831528080));

return taoensso.sente.new_ChAjaxSocket(ajax_chsk_opts__$1,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.state_))).taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(null);
});})(ajax_chsk_opts__$1,ws_chsk_opts__$1,chsk__$1))
;
var ws_conn_BANG_ = ((function (ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1){
return (function (){
var downgraded_QMARK___88198 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false);
cljs.core.add_watch(self__.state_,new cljs.core.Keyword("chsk","auto-ajax-downgrade","chsk/auto-ajax-downgrade",-831528080),((function (downgraded_QMARK___88198,ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1){
return (function (_,___$1,old_state,new_state){
var temp__5818__auto__ = cljs.core.deref(self__.impl_);
if(cljs.core.truth_(temp__5818__auto__)){
var impl = temp__5818__auto__;
var temp__5818__auto____$1 = new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913).cljs$core$IFn$_invoke$arity$1(impl);
if(cljs.core.truth_(temp__5818__auto____$1)){
var ever_opened_QMARK__ = temp__5818__auto____$1;
if(cljs.core.truth_(cljs.core.deref(ever_opened_QMARK__))){
return null;
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"last-ws-error","last-ws-error",-820288502).cljs$core$IFn$_invoke$arity$1(new_state))){
if(cljs.core.compare_and_set_BANG_(downgraded_QMARK___88198,false,true)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1420,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (ever_opened_QMARK__,temp__5818__auto____$1,impl,temp__5818__auto__,downgraded_QMARK___88198,ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Permanently downgrading :auto chsk -> :ajax"], null);
});})(ever_opened_QMARK__,temp__5818__auto____$1,impl,temp__5818__auto__,downgraded_QMARK___88198,ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1))
,null)),null,445265692);

taoensso.sente._chsk_disconnect_BANG_(impl,new cljs.core.Keyword(null,"downgrading-ws-to-ajax","downgrading-ws-to-ajax",402136720));

return cljs.core.reset_BANG_(self__.impl_,ajax_conn_BANG_());
} else {
return null;
}
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});})(downgraded_QMARK___88198,ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1))
);

return taoensso.sente.new_ChWebSocket(ws_chsk_opts__$1,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.state_))).taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(null);
});})(ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1))
;
cljs.core.reset_BANG_(self__.impl_,(function (){var or__4131__auto__ = ws_conn_BANG_();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ajax_conn_BANG_();
}
})());

return chsk__$1;
});

taoensso.sente.ChAutoSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ws-chsk-opts","ws-chsk-opts",-349638577,null),new cljs.core.Symbol(null,"ajax-chsk-opts","ajax-chsk-opts",-1051844442,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"impl_","impl_",-1435617590,null)], null);
});

taoensso.sente.ChAutoSocket.cljs$lang$type = true;

taoensso.sente.ChAutoSocket.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"taoensso.sente/ChAutoSocket",null,(1),null));
});

taoensso.sente.ChAutoSocket.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"taoensso.sente/ChAutoSocket");
});

/**
 * Positional factory function for taoensso.sente/ChAutoSocket.
 */
taoensso.sente.__GT_ChAutoSocket = (function taoensso$sente$__GT_ChAutoSocket(ws_chsk_opts,ajax_chsk_opts,state_,impl_){
return (new taoensso.sente.ChAutoSocket(ws_chsk_opts,ajax_chsk_opts,state_,impl_,null,null,null));
});

/**
 * Factory function for taoensso.sente/ChAutoSocket, taking a map of keywords to field values.
 */
taoensso.sente.map__GT_ChAutoSocket = (function taoensso$sente$map__GT_ChAutoSocket(G__87048){
var extmap__4424__auto__ = (function (){var G__87081 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__87048,new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"impl_","impl_",1218818179)], 0));
if(cljs.core.record_QMARK_(G__87048)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__87081);
} else {
return G__87081;
}
})();
return (new taoensso.sente.ChAutoSocket(new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104).cljs$core$IFn$_invoke$arity$1(G__87048),new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327).cljs$core$IFn$_invoke$arity$1(G__87048),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__87048),new cljs.core.Keyword(null,"impl_","impl_",1218818179).cljs$core$IFn$_invoke$arity$1(G__87048),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

taoensso.sente.new_ChAutoSocket = (function taoensso$sente$new_ChAutoSocket(opts,csrf_token){
return taoensso.sente.map__GT_ChAutoSocket(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state_","state_",957667102),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"auto","auto",-566279492),new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"ever-opened?","ever-opened?",1128459732),false,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),csrf_token], null)),new cljs.core.Keyword(null,"impl_","impl_",1218818179),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null)], null),opts], 0)));
});
taoensso.sente.get_chsk_url = (function taoensso$sente$get_chsk_url(protocol,host,path,type){
var protocol__$1 = (function (){var G__87082 = protocol;
var G__87082__$1 = (((G__87082 instanceof cljs.core.Keyword))?G__87082.fqn:null);
switch (G__87082__$1) {
case "http":
return "http:";

break;
case "https":
return "https:";

break;
default:
return protocol;

}
})();
var protocol__$2 = (function (){var e = (function (){try{if((function (){var fexpr__87087 = ((function (protocol__$1){
return (function (x){
return cljs.core.contains_QMARK_((function (){var G__87088 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["https:",null,"http:",null], null), null);
return (taoensso.truss.impl.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.truss.impl.set_STAR_.cljs$core$IFn$_invoke$arity$1(G__87088) : taoensso.truss.impl.set_STAR_.call(null,G__87088));
})(),x);
});})(protocol__$1))
;
return fexpr__87087(protocol__$1);
})()){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e87084){if((e87084 instanceof Error)){
var e = e87084;
return e;
} else {
throw e87084;

}
}})();
if((e == null)){
return protocol__$1;
} else {
return taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",1440,"([:el #{\"https:\" \"http:\"}] protocol)",protocol__$1,e,null);
}
})();
var protocol__$3 = (function (){var G__87089 = type;
var G__87089__$1 = (((G__87089 instanceof cljs.core.Keyword))?G__87089.fqn:null);
switch (G__87089__$1) {
case "ajax":
return protocol__$2;

break;
case "ws":
var G__87090 = protocol__$2;
switch (G__87090) {
case "https:":
return "wss:";

break;
case "http:":
return "ws:";

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__87090)].join('')));

}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__87089__$1)].join('')));

}
})();
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol__$3),"//",taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([host,path], 0))].join('');
});
/**
 * Returns nil on failure, or a map with keys:
 *     :ch-recv ; core.async channel to receive `event-msg`s (internal or from
 *              ; clients). May `put!` (inject) arbitrary `event`s to this channel.
 *     :send-fn ; (fn [event & [?timeout-ms ?cb-fn]]) for client>server send.
 *     :state   ; Watchable, read-only (atom {:type _ :open? _ :uid _ :csrf-token _}).
 *     :chsk    ; IChSocket implementer. You can usu. ignore this.
 * 
 *   Common options:
 *     :type           ; e/o #{:auto :ws :ajax}. You'll usually want the default (:auto).
 *     :protocol       ; Server protocol, e/o #{:http :https}.
 *     :host           ; Server host (defaults to current page's host).
 *     :port           ; Server port (defaults to current page's port).
 *     :params         ; Map of any params to incl. in chsk Ring requests (handy
 *                     ; for application-level auth, etc.).
 *     :packer         ; :edn (default), or an IPacker implementation.
 *     :ajax-opts      ; Base opts map provided to `taoensso.encore/ajax-lite`.
 *     :wrap-recv-evs? ; Should events from server be wrapped in [:chsk/recv _]?
 *     :ws-kalive-ms   ; Ping to keep a WebSocket conn alive if no activity
 *                     ; w/in given msecs. Should be different to server's :ws-kalive-ms.
 */
taoensso.sente.make_channel_socket_client_BANG_ = (function taoensso$sente$make_channel_socket_client_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___88231 = arguments.length;
var i__4731__auto___88232 = (0);
while(true){
if((i__4731__auto___88232 < len__4730__auto___88231)){
args__4736__auto__.push((arguments[i__4731__auto___88232]));

var G__88233 = (i__4731__auto___88232 + (1));
i__4731__auto___88232 = G__88233;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (path,_QMARK_csrf_token,p__87094){
var vec__87095 = p__87094;
var map__87098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87095,(0),null);
var map__87098__$1 = (((((!((map__87098 == null))))?(((((map__87098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87098):map__87098);
var opts = map__87098__$1;
var ajax_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87098__$1,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109));
var ws_kalive_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87098__$1,new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"secs","secs",1532330091),(20)], 0)));
var client_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87098__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140),(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"client-uuid","client-uuid",-1717531965).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
}
})());
var protocol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87098__$1,new cljs.core.Keyword(null,"protocol","protocol",652470118));
var packer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87098__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87098__$1,new cljs.core.Keyword(null,"params","params",710516235));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87098__$1,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"auto","auto",-566279492));
var port = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87098__$1,new cljs.core.Keyword(null,"port","port",1534937262));
var host = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87098__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var recv_buf_or_n = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87098__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer((2048)));
var backoff_ms_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87098__$1,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),taoensso.encore.exp_backoff);
var wrap_recv_evs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87098__$1,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),true);
var _deprecated_more_opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87095,(1),null);
var e_88245 = (function (){try{if((function (){var fexpr__87102 = ((function (vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (x){
return cljs.core.contains_QMARK_((function (){var G__87103 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null);
return (taoensso.truss.impl.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.truss.impl.set_STAR_.cljs$core$IFn$_invoke$arity$1(G__87103) : taoensso.truss.impl.set_STAR_.call(null,G__87103));
})(),x);
});})(vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
;
return fexpr__87102(type);
})()){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e87100){if((e87100 instanceof Error)){
var e = e87100;
return e;
} else {
throw e87100;

}
}})();
if((e_88245 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",1483,"([:in #{:ws :ajax :auto}] type)",type,e_88245,null);
}

var e_88251 = (function (){try{if(taoensso.encore.nblank_str_QMARK_(client_id)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e87104){if((e87104 instanceof Error)){
var e = e87104;
return e;
} else {
throw e87104;

}
}})();
if((e_88251 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_(true,"taoensso.sente",1484,"(enc/nblank-str? client-id)",client_id,e_88251,null);
}

if((!((_deprecated_more_opts == null)))){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1486,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["`make-channel-socket-client!` fn signature CHANGED with Sente v0.10.0."], null);
});})(vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null,849031080);
} else {
}

if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"lp-timeout","lp-timeout",1149461302))){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1487,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [":lp-timeout opt has CHANGED; please use :lp-timout-ms."], null);
});})(vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null,-1120064264);
} else {
}

if((((!(typeof _QMARK_csrf_token === 'string'))) || (clojure.string.blank_QMARK_(_QMARK_csrf_token)))){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1490,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["WARNING: no CSRF token provided. Connections will FAIL if server-side CSRF check is enabled (as it is by default)."], null);
});})(vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null,-358248509);
} else {
}

var packer__$1 = taoensso.sente.coerce_packer(packer);
var vec__87105 = (function (){var win_loc = taoensso.encore.get_win_loc();
var path__$1 = (function (){var or__4131__auto__ = path;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"pathname","pathname",-1420497528).cljs$core$IFn$_invoke$arity$1(win_loc);
}
})();
var temp__5816__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5816__auto__)){
var f = temp__5816__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__87108 = path__$1;
var G__87109 = win_loc;
var G__87110 = new cljs.core.Keyword(null,"ws","ws",86841443);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__87108,G__87109,G__87110) : f.call(null,G__87108,G__87109,G__87110));
})(),(function (){var G__87111 = path__$1;
var G__87112 = win_loc;
var G__87113 = new cljs.core.Keyword(null,"ajax","ajax",814345549);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__87111,G__87112,G__87113) : f.call(null,G__87111,G__87112,G__87113));
})()], null);
} else {
var protocol__$1 = (function (){var or__4131__auto__ = protocol;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(win_loc);
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return new cljs.core.Keyword(null,"http","http",382524695);
}
}
})();
var host__$1 = (cljs.core.truth_(port)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"hostname","hostname",2105669933).cljs$core$IFn$_invoke$arity$1(win_loc)),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(port)].join(''):new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(win_loc));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.sente.get_chsk_url(protocol__$1,host__$1,path__$1,new cljs.core.Keyword(null,"ws","ws",86841443)),taoensso.sente.get_chsk_url(protocol__$1,host__$1,path__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549))], null);
}
})();
var ws_url = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87105,(0),null);
var ajax_url = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87105,(1),null);
var private_chs = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"internal","internal",-854870097),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((128))),new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((10))),new cljs.core.Keyword(null,"<server","<server",-2135373537),(function (){var buf = cljs.core.async.sliding_buffer((512));
if(cljs.core.truth_(wrap_recv_evs_QMARK_)){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (buf,packer__$1,vec__87105,ws_url,ajax_url,vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","recv","chsk/recv",561097091),ev], null);
});})(buf,packer__$1,vec__87105,ws_url,ajax_url,vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
));
} else {
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf);
}
})()], null);
var common_chsk_opts = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"chs","chs",376886120),private_chs,new cljs.core.Keyword(null,"params","params",710516235),params,new cljs.core.Keyword(null,"packer","packer",66077544),packer__$1,new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),ws_kalive_ms], null);
var ws_chsk_opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([common_chsk_opts,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),ws_url,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),backoff_ms_fn], null)], 0));
var ajax_chsk_opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([common_chsk_opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),ajax_url,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),ajax_opts,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),backoff_ms_fn], null)], 0));
var auto_chsk_opts = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),ws_chsk_opts,new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),ajax_chsk_opts], null);
var _QMARK_chsk = taoensso.sente._chsk_connect_BANG_((function (){var G__87114 = type;
var G__87114__$1 = (((G__87114 instanceof cljs.core.Keyword))?G__87114.fqn:null);
switch (G__87114__$1) {
case "ws":
return taoensso.sente.new_ChWebSocket(ws_chsk_opts,_QMARK_csrf_token);

break;
case "ajax":
return taoensso.sente.new_ChAjaxSocket(ajax_chsk_opts,_QMARK_csrf_token);

break;
case "auto":
return taoensso.sente.new_ChAutoSocket(auto_chsk_opts,_QMARK_csrf_token);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__87114__$1)].join('')));

}
})());
var temp__5816__auto__ = _QMARK_chsk;
if(cljs.core.truth_(temp__5816__auto__)){
var chsk = temp__5816__auto__;
var chsk_state_ = new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk);
var internal_ch = new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(private_chs);
var send_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.sente.chsk_send_BANG_,chsk);
var ev_ch = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(private_chs),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(private_chs),new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(private_chs)], null),recv_buf_or_n);
var ev_msg_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((1),cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (chsk_state_,internal_ch,send_fn,ev_ch,chsk,temp__5816__auto__,packer__$1,vec__87105,ws_url,ajax_url,private_chs,common_chsk_opts,ws_chsk_opts,ajax_chsk_opts,auto_chsk_opts,_QMARK_chsk,vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
var vec__87121 = taoensso.sente.as_event(ev);
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87121,(0),null);
var ev__QMARK_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87121,(1),null);
var ev__$1 = vec__87121;
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),internal_ch,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),chsk_state_,new cljs.core.Keyword(null,"event","event",301435442),ev__$1,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null);
});})(chsk_state_,internal_ch,send_fn,ev_ch,chsk,temp__5816__auto__,packer__$1,vec__87105,ws_url,ajax_url,private_chs,common_chsk_opts,ws_chsk_opts,ajax_chsk_opts,auto_chsk_opts,_QMARK_chsk,vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
));
cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2(ev_ch,ev_msg_ch);

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"chsk","chsk",-863703081),chsk,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ev_msg_ch,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk)], null);
} else {
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente",null,1580,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (temp__5816__auto__,packer__$1,vec__87105,ws_url,ajax_url,private_chs,common_chsk_opts,ws_chsk_opts,ajax_chsk_opts,auto_chsk_opts,_QMARK_chsk,vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Failed to create channel socket"], null);
});})(temp__5816__auto__,packer__$1,vec__87105,ws_url,ajax_url,private_chs,common_chsk_opts,ws_chsk_opts,ajax_chsk_opts,auto_chsk_opts,_QMARK_chsk,vec__87095,map__87098,map__87098__$1,opts,ajax_opts,ws_kalive_ms,client_id,protocol,packer,params,type,port,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null,1856967074);
}
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$applyTo = (function (seq87091){
var G__87092 = cljs.core.first(seq87091);
var seq87091__$1 = cljs.core.next(seq87091);
var G__87093 = cljs.core.first(seq87091__$1);
var seq87091__$2 = cljs.core.next(seq87091__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__87092,G__87093,seq87091__$2);
});

taoensso.sente._start_chsk_router_BANG_ = (function taoensso$sente$_start_chsk_router_BANG_(server_QMARK_,ch_recv,event_msg_handler,opts){
var map__87125 = opts;
var map__87125__$1 = (((((!((map__87125 == null))))?(((((map__87125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87125.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87125):map__87125);
var trace_evs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87125__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87125__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var simple_auto_threading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87125__$1,new cljs.core.Keyword(null,"simple-auto-threading?","simple-auto-threading?",1950754184));
var ch_ctrl = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var execute1 = ((function (map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl){
return (function (f){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});})(map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl))
;
var c__46663__auto___88279 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1){
return (function (state_87207){
var state_val_87208 = (state_87207[(1)]);
if((state_val_87208 === (7))){
var inst_87200 = (state_87207[(2)]);
var state_87207__$1 = state_87207;
var statearr_87213_88284 = state_87207__$1;
(statearr_87213_88284[(2)] = inst_87200);

(statearr_87213_88284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (1))){
var state_87207__$1 = state_87207;
var statearr_87214_88285 = state_87207__$1;
(statearr_87214_88285[(2)] = null);

(statearr_87214_88285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (4))){
var inst_87157 = (state_87207[(7)]);
var inst_87150 = (state_87207[(8)]);
var inst_87148 = (state_87207[(9)]);
var inst_87149 = (state_87207[(10)]);
var inst_87148__$1 = (state_87207[(2)]);
var inst_87149__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87148__$1,(0),null);
var inst_87150__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87148__$1,(1),null);
var inst_87155 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_87150__$1,ch_ctrl);
var inst_87156 = (inst_87149__$1 == null);
var inst_87157__$1 = ((inst_87155) || (inst_87156));
var state_87207__$1 = (function (){var statearr_87215 = state_87207;
(statearr_87215[(7)] = inst_87157__$1);

(statearr_87215[(8)] = inst_87150__$1);

(statearr_87215[(9)] = inst_87148__$1);

(statearr_87215[(10)] = inst_87149__$1);

return statearr_87215;
})();
if(cljs.core.truth_(inst_87157__$1)){
var statearr_87216_88290 = state_87207__$1;
(statearr_87216_88290[(1)] = (5));

} else {
var statearr_87217_88291 = state_87207__$1;
(statearr_87217_88291[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (15))){
var inst_87149 = (state_87207[(10)]);
var state_87207__$1 = state_87207;
var statearr_87218_88292 = state_87207__$1;
(statearr_87218_88292[(2)] = inst_87149);

(statearr_87218_88292[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (13))){
var inst_87183 = (state_87207[(2)]);
var state_87207__$1 = state_87207;
var statearr_87219_88294 = state_87207__$1;
(statearr_87219_88294[(2)] = inst_87183);

(statearr_87219_88294[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (6))){
var inst_87149 = (state_87207[(10)]);
var inst_87169 = (inst_87149 == null);
var inst_87170 = cljs.core.not(inst_87169);
var state_87207__$1 = state_87207;
if(inst_87170){
var statearr_87220_88295 = state_87207__$1;
(statearr_87220_88295[(1)] = (8));

} else {
var statearr_87221_88297 = state_87207__$1;
(statearr_87221_88297[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (3))){
var inst_87203 = (state_87207[(2)]);
var state_87207__$1 = state_87207;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87207__$1,inst_87203);
} else {
if((state_val_87208 === (12))){
var state_87207__$1 = state_87207;
var statearr_87225_88300 = state_87207__$1;
(statearr_87225_88300[(2)] = false);

(statearr_87225_88300[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (2))){
var inst_87143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_87145 = [ch_recv,ch_ctrl];
var inst_87146 = (new cljs.core.PersistentVector(null,2,(5),inst_87143,inst_87145,null));
var state_87207__$1 = state_87207;
return cljs.core.async.ioc_alts_BANG_(state_87207__$1,(4),inst_87146);
} else {
if((state_val_87208 === (11))){
var state_87207__$1 = state_87207;
var statearr_87227_88302 = state_87207__$1;
(statearr_87227_88302[(2)] = true);

(statearr_87227_88302[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (9))){
var state_87207__$1 = state_87207;
var statearr_87230_88303 = state_87207__$1;
(statearr_87230_88303[(2)] = false);

(statearr_87230_88303[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (5))){
var state_87207__$1 = state_87207;
var statearr_87231_88304 = state_87207__$1;
(statearr_87231_88304[(2)] = null);

(statearr_87231_88304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (14))){
var inst_87149 = (state_87207[(10)]);
var inst_87189 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_87149);
var state_87207__$1 = state_87207;
var statearr_87232_88309 = state_87207__$1;
(statearr_87232_88309[(2)] = inst_87189);

(statearr_87232_88309[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (16))){
var inst_87157 = (state_87207[(7)]);
var inst_87150 = (state_87207[(8)]);
var inst_87148 = (state_87207[(9)]);
var inst_87149 = (state_87207[(10)]);
var inst_87192 = (state_87207[(2)]);
var inst_87193 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_87192,new cljs.core.Keyword(null,"event","event",301435442));
var inst_87196 = (function (){var vec__87139 = inst_87148;
var v = inst_87149;
var p = inst_87150;
var stop_QMARK_ = inst_87157;
var map__87162 = inst_87192;
var event_msg = inst_87192;
var event = inst_87193;
return ((function (vec__87139,v,p,stop_QMARK_,map__87162,event_msg,event,inst_87157,inst_87150,inst_87148,inst_87149,inst_87192,inst_87193,state_val_87208,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1){
return (function (){
try{if(cljs.core.truth_(trace_evs_QMARK_)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente",null,1607,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__87139,v,p,stop_QMARK_,map__87162,event_msg,event,inst_87157,inst_87150,inst_87148,inst_87149,inst_87192,inst_87193,state_val_87208,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Pre-handler event: %s",event], null);
});})(vec__87139,v,p,stop_QMARK_,map__87162,event_msg,event,inst_87157,inst_87150,inst_87148,inst_87149,inst_87192,inst_87193,state_val_87208,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1))
,null)),null,1306612228);
} else {
}

var G__87235 = (cljs.core.truth_(server_QMARK_)?(function (){var e = (function (){try{if(taoensso.sente.server_event_msg_QMARK_(event_msg)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e87236){if((e87236 instanceof Error)){
var e = e87236;
return e;
} else {
throw e87236;

}
}})();
if((e == null)){
return event_msg;
} else {
return taoensso.truss.impl._invar_violation_BANG_(null,"taoensso.sente",1610,"(server-event-msg? event-msg)",event_msg,e,null);
}
})():(function (){var e = (function (){try{if(taoensso.sente.client_event_msg_QMARK_(event_msg)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e87237){if((e87237 instanceof Error)){
var e = e87237;
return e;
} else {
throw e87237;

}
}})();
if((e == null)){
return event_msg;
} else {
return taoensso.truss.impl._invar_violation_BANG_(null,"taoensso.sente",1611,"(client-event-msg? event-msg)",event_msg,e,null);
}
})());
return (event_msg_handler.cljs$core$IFn$_invoke$arity$1 ? event_msg_handler.cljs$core$IFn$_invoke$arity$1(G__87235) : event_msg_handler.call(null,G__87235));
}catch (e87233){if((e87233 instanceof Error)){
var e1 = e87233;
try{var temp__5816__auto__ = error_handler;
if(cljs.core.truth_(temp__5816__auto__)){
var eh = temp__5816__auto__;
return (error_handler.cljs$core$IFn$_invoke$arity$2 ? error_handler.cljs$core$IFn$_invoke$arity$2(e1,event_msg) : error_handler.call(null,e1,event_msg));
} else {
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente",null,1616,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (temp__5816__auto__,e1,vec__87139,v,p,stop_QMARK_,map__87162,event_msg,event,inst_87157,inst_87150,inst_87148,inst_87149,inst_87192,inst_87193,state_val_87208,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e1,"Chsk router `event-msg-handler` error: %s",event], null);
});})(temp__5816__auto__,e1,vec__87139,v,p,stop_QMARK_,map__87162,event_msg,event,inst_87157,inst_87150,inst_87148,inst_87149,inst_87192,inst_87193,state_val_87208,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1))
,null)),null,158561963);
}
}catch (e87234){if((e87234 instanceof Error)){
var e2 = e87234;
return taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$10(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente",null,1617,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e2,e1,vec__87139,v,p,stop_QMARK_,map__87162,event_msg,event,inst_87157,inst_87150,inst_87148,inst_87149,inst_87192,inst_87193,state_val_87208,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e2,"Chsk router `error-handler` error: %s",event], null);
});})(e2,e1,vec__87139,v,p,stop_QMARK_,map__87162,event_msg,event,inst_87157,inst_87150,inst_87148,inst_87149,inst_87192,inst_87193,state_val_87208,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1))
,null)),null,327963220);
} else {
throw e87234;

}
}} else {
throw e87233;

}
}});
;})(vec__87139,v,p,stop_QMARK_,map__87162,event_msg,event,inst_87157,inst_87150,inst_87148,inst_87149,inst_87192,inst_87193,state_val_87208,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1))
})();
var inst_87197 = execute1(inst_87196);
var state_87207__$1 = (function (){var statearr_87238 = state_87207;
(statearr_87238[(11)] = inst_87197);

return statearr_87238;
})();
var statearr_87239_88312 = state_87207__$1;
(statearr_87239_88312[(2)] = null);

(statearr_87239_88312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (10))){
var inst_87187 = (state_87207[(2)]);
var state_87207__$1 = state_87207;
if(cljs.core.truth_(inst_87187)){
var statearr_87240_88314 = state_87207__$1;
(statearr_87240_88314[(1)] = (14));

} else {
var statearr_87241_88315 = state_87207__$1;
(statearr_87241_88315[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_87208 === (8))){
var inst_87149 = (state_87207[(10)]);
var inst_87175 = inst_87149.cljs$lang$protocol_mask$partition0$;
var inst_87176 = (inst_87175 & (64));
var inst_87177 = inst_87149.cljs$core$ISeq$;
var inst_87178 = (cljs.core.PROTOCOL_SENTINEL === inst_87177);
var inst_87179 = ((inst_87176) || (inst_87178));
var state_87207__$1 = state_87207;
if(cljs.core.truth_(inst_87179)){
var statearr_87242_88317 = state_87207__$1;
(statearr_87242_88317[(1)] = (11));

} else {
var statearr_87243_88319 = state_87207__$1;
(statearr_87243_88319[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1))
;
return ((function (switch__46368__auto__,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1){
return (function() {
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto__ = null;
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto____0 = (function (){
var statearr_87244 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_87244[(0)] = taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto__);

(statearr_87244[(1)] = (1));

return statearr_87244;
});
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto____1 = (function (state_87207){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_87207);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e87245){if((e87245 instanceof Object)){
var ex__46372__auto__ = e87245;
var statearr_87246_88321 = state_87207;
(statearr_87246_88321[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_87207);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e87245;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__88322 = state_87207;
state_87207 = G__88322;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto__ = function(state_87207){
switch(arguments.length){
case 0:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto____0.call(this);
case 1:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto____1.call(this,state_87207);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto____0;
taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto____1;
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1))
})();
var state__46665__auto__ = (function (){var statearr_87247 = f__46664__auto__();
(statearr_87247[(6)] = c__46663__auto___88279);

return statearr_87247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___88279,map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1))
);


return ((function (map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1){
return (function taoensso$sente$_start_chsk_router_BANG__$_stop_BANG_(){
return cljs.core.async.close_BANG_(ch_ctrl);
});
;})(map__87125,map__87125__$1,trace_evs_QMARK_,error_handler,simple_auto_threading_QMARK_,ch_ctrl,execute1))
});
/**
 * Creates a simple go-loop to call `(event-msg-handler <server-event-msg>)`
 *   and log any errors. Returns a `(fn stop! [])`. Note that advanced users may
 *   prefer to just write their own loop against `ch-recv`.
 * 
 *   Nb performance note: since your `event-msg-handler` fn will be executed
 *   within a simple go block, you'll want this fn to be ~non-blocking
 *   (you'll especially want to avoid blocking IO) to avoid starving the
 *   core.async thread pool under load. To avoid blocking, you can use futures,
 *   agents, core.async, etc. as appropriate.
 * 
 *   Or for simple automatic future-based threading of every request, enable
 *   the `:simple-auto-threading?` opt (disabled by default).
 */
taoensso.sente.start_server_chsk_router_BANG_ = (function taoensso$sente$start_server_chsk_router_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___88326 = arguments.length;
var i__4731__auto___88327 = (0);
while(true){
if((i__4731__auto___88327 < len__4730__auto___88326)){
args__4736__auto__.push((arguments[i__4731__auto___88327]));

var G__88328 = (i__4731__auto___88327 + (1));
i__4731__auto___88327 = G__88328;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__87257){
var vec__87258 = p__87257;
var map__87261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87258,(0),null);
var map__87261__$1 = (((((!((map__87261 == null))))?(((((map__87261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87261):map__87261);
var opts = map__87261__$1;
var trace_evs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87261__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87261__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var simple_auto_threading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87261__$1,new cljs.core.Keyword(null,"simple-auto-threading?","simple-auto-threading?",1950754184));
return taoensso.sente._start_chsk_router_BANG_(new cljs.core.Keyword(null,"server","server",1499190120),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$applyTo = (function (seq87251){
var G__87252 = cljs.core.first(seq87251);
var seq87251__$1 = cljs.core.next(seq87251);
var G__87253 = cljs.core.first(seq87251__$1);
var seq87251__$2 = cljs.core.next(seq87251__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__87252,G__87253,seq87251__$2);
});

/**
 * Creates a simple go-loop to call `(event-msg-handler <server-event-msg>)`
 *   and log any errors. Returns a `(fn stop! [])`. Note that advanced users may
 *   prefer to just write their own loop against `ch-recv`.
 * 
 *   Nb performance note: since your `event-msg-handler` fn will be executed
 *   within a simple go block, you'll want this fn to be ~non-blocking
 *   (you'll especially want to avoid blocking IO) to avoid starving the
 *   core.async thread pool under load. To avoid blocking, you can use futures,
 *   agents, core.async, etc. as appropriate.
 */
taoensso.sente.start_client_chsk_router_BANG_ = (function taoensso$sente$start_client_chsk_router_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___88336 = arguments.length;
var i__4731__auto___88337 = (0);
while(true){
if((i__4731__auto___88337 < len__4730__auto___88336)){
args__4736__auto__.push((arguments[i__4731__auto___88337]));

var G__88338 = (i__4731__auto___88337 + (1));
i__4731__auto___88337 = G__88338;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__87274){
var vec__87276 = p__87274;
var map__87279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87276,(0),null);
var map__87279__$1 = (((((!((map__87279 == null))))?(((((map__87279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87279.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87279):map__87279);
var opts = map__87279__$1;
var trace_evs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87279__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87279__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_(cljs.core.not(new cljs.core.Keyword(null,"server","server",1499190120)),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$applyTo = (function (seq87268){
var G__87269 = cljs.core.first(seq87268);
var seq87268__$1 = cljs.core.next(seq87268);
var G__87270 = cljs.core.first(seq87268__$1);
var seq87268__$2 = cljs.core.next(seq87268__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__87269,G__87270,seq87268__$2);
});

taoensso.sente.event_msg_QMARK_ = taoensso.sente.client_event_msg_QMARK_;
/**
 * Platform-specific alias for `make-channel-socket-server!` or
 *   `make-channel-socket-client!`. Please see the appropriate aliased fn
 * docstring for details.
 */
taoensso.sente.make_channel_socket_BANG_ = taoensso.sente.make_channel_socket_client_BANG_;
/**
 * Platform-specific alias for `start-server-chsk-router!` or
 *   `start-client-chsk-router!`. Please see the appropriate aliased fn
 *   docstring for details.
 */
taoensso.sente.start_chsk_router_BANG_ = taoensso.sente.start_client_chsk_router_BANG_;
/**
 * DEPRECATED: Please use `start-chsk-router!` instead
 */
taoensso.sente.start_chsk_router_loop_BANG_ = (function taoensso$sente$start_chsk_router_loop_BANG_(event_handler,ch_recv){
return taoensso.sente.start_client_chsk_router_BANG_(ch_recv,(function (ev_msg){
var G__87285 = new cljs.core.Keyword(null,"event","event",301435442).cljs$core$IFn$_invoke$arity$1(ev_msg);
var G__87286 = new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(ev_msg);
return (event_handler.cljs$core$IFn$_invoke$arity$2 ? event_handler.cljs$core$IFn$_invoke$arity$2(G__87285,G__87286) : event_handler.call(null,G__87285,G__87286));
}));
});

/**
 * DEPRECATED. Please use `timbre/set-level!` instead
 */
taoensso.sente.set_logging_level_BANG_ = taoensso.timbre.set_level_BANG_;

/**
 * DEPRECATED: Please use `ajax-lite` instead
 */
taoensso.sente.ajax_call = taoensso.encore.ajax_lite;

/**
 * DEPRECATED
 */
taoensso.sente.default_chsk_url_fn = (function taoensso$sente$default_chsk_url_fn(path,p__87290,websocket_QMARK_){
var map__87291 = p__87290;
var map__87291__$1 = (((((!((map__87291 == null))))?(((((map__87291.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__87291.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__87291):map__87291);
var location = map__87291__$1;
var protocol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87291__$1,new cljs.core.Keyword(null,"protocol","protocol",652470118));
var host = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87291__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var pathname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87291__$1,new cljs.core.Keyword(null,"pathname","pathname",-1420497528));
var protocol__$1 = (cljs.core.truth_(websocket_QMARK_)?((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,"https:"))?"wss:":"ws:"):protocol);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol__$1),"//",cljs.core.str.cljs$core$IFn$_invoke$arity$1(host),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = path;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return pathname;
}
})())].join('');
});

//# sourceMappingURL=taoensso.sente.js.map
