goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4434__auto__.call(null,this$));
} else {
var m__4431__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4431__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
var x__4433__auto__ = (((this$ == null))?null:this$);
var m__4434__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4434__auto__.call(null,this$));
} else {
var m__4431__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4431__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__49187 = coll;
var G__49188 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__49187,G__49188) : shadow.dom.lazy_native_coll_seq.call(null,G__49187,G__49188));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
});

shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4131__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return not_found;
}
});

shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
});

shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
});

shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
});

shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
});

shadow.dom.NativeColl.cljs$lang$type = true;

shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl";

shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"shadow.dom/NativeColl");
});

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__49212 = arguments.length;
switch (G__49212) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
});

shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
});

shadow.dom.query_one.cljs$lang$maxFixedArity = 2;

shadow.dom.query = (function shadow$dom$query(var_args){
var G__49215 = arguments.length;
switch (G__49215) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
});

shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
});

shadow.dom.query.cljs$lang$maxFixedArity = 2;

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__49226 = arguments.length;
switch (G__49226) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
});

shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
});

shadow.dom.by_id.cljs$lang$maxFixedArity = 2;

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__49241 = arguments.length;
switch (G__49241) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
e.cancelBubble = true;

e.returnValue = false;
}

return e;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
});

shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4;

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__49247 = arguments.length;
switch (G__49247) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
var G__49253 = document;
var G__49255 = shadow.dom.dom_node(el);
return goog.dom.contains(G__49253,G__49255);
});

shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
var G__49257 = shadow.dom.dom_node(parent);
var G__49258 = shadow.dom.dom_node(el);
return goog.dom.contains(G__49257,G__49258);
});

shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2;

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
var G__49259 = shadow.dom.dom_node(el);
var G__49260 = cls;
return goog.dom.classlist.add(G__49259,G__49260);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
var G__49264 = shadow.dom.dom_node(el);
var G__49265 = cls;
return goog.dom.classlist.remove(G__49264,G__49265);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__49271 = arguments.length;
switch (G__49271) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
var G__49272 = shadow.dom.dom_node(el);
var G__49273 = cls;
return goog.dom.classlist.toggle(G__49272,G__49273);
});

shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
});

shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3;

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4131__auto__ = (!((typeof document !== 'undefined')));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e49279){if((e49279 instanceof Object)){
var e = e49279;
return console.log("didnt support attachEvent",el,e);
} else {
throw e49279;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4131__auto__ = (!((typeof document !== 'undefined')));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__49287 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__49288 = null;
var count__49289 = (0);
var i__49290 = (0);
while(true){
if((i__49290 < count__49289)){
var el = chunk__49288.cljs$core$IIndexed$_nth$arity$2(null,i__49290);
var handler_50148__$1 = ((function (seq__49287,chunk__49288,count__49289,i__49290,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__49287,chunk__49288,count__49289,i__49290,el))
;
var G__49311_50151 = el;
var G__49312_50152 = cljs.core.name(ev);
var G__49313_50153 = handler_50148__$1;
shadow.dom.dom_listen(G__49311_50151,G__49312_50152,G__49313_50153);


var G__50154 = seq__49287;
var G__50155 = chunk__49288;
var G__50156 = count__49289;
var G__50157 = (i__49290 + (1));
seq__49287 = G__50154;
chunk__49288 = G__50155;
count__49289 = G__50156;
i__49290 = G__50157;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__49287);
if(temp__5818__auto__){
var seq__49287__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49287__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__49287__$1);
var G__50163 = cljs.core.chunk_rest(seq__49287__$1);
var G__50164 = c__4550__auto__;
var G__50165 = cljs.core.count(c__4550__auto__);
var G__50166 = (0);
seq__49287 = G__50163;
chunk__49288 = G__50164;
count__49289 = G__50165;
i__49290 = G__50166;
continue;
} else {
var el = cljs.core.first(seq__49287__$1);
var handler_50173__$1 = ((function (seq__49287,chunk__49288,count__49289,i__49290,el,seq__49287__$1,temp__5818__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__49287,chunk__49288,count__49289,i__49290,el,seq__49287__$1,temp__5818__auto__))
;
var G__49321_50176 = el;
var G__49322_50177 = cljs.core.name(ev);
var G__49323_50178 = handler_50173__$1;
shadow.dom.dom_listen(G__49321_50176,G__49322_50177,G__49323_50178);


var G__50182 = cljs.core.next(seq__49287__$1);
var G__50183 = null;
var G__50184 = (0);
var G__50185 = (0);
seq__49287 = G__50182;
chunk__49288 = G__50183;
count__49289 = G__50184;
i__49290 = G__50185;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__49328 = arguments.length;
switch (G__49328) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
});

shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
var G__49333 = shadow.dom.dom_node(el);
var G__49334 = cljs.core.name(ev);
var G__49335 = handler__$1;
return shadow.dom.dom_listen(G__49333,G__49334,G__49335);
}
});

shadow.dom.on.cljs$lang$maxFixedArity = 4;

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
var G__49339 = shadow.dom.dom_node(el);
var G__49340 = cljs.core.name(ev);
var G__49341 = handler;
return shadow.dom.dom_listen_remove(G__49339,G__49340,G__49341);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__49342 = cljs.core.seq(events);
var chunk__49343 = null;
var count__49344 = (0);
var i__49345 = (0);
while(true){
if((i__49345 < count__49344)){
var vec__49355 = chunk__49343.cljs$core$IIndexed$_nth$arity$2(null,i__49345);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49355,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49355,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__50209 = seq__49342;
var G__50210 = chunk__49343;
var G__50211 = count__49344;
var G__50212 = (i__49345 + (1));
seq__49342 = G__50209;
chunk__49343 = G__50210;
count__49344 = G__50211;
i__49345 = G__50212;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__49342);
if(temp__5818__auto__){
var seq__49342__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49342__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__49342__$1);
var G__50219 = cljs.core.chunk_rest(seq__49342__$1);
var G__50220 = c__4550__auto__;
var G__50221 = cljs.core.count(c__4550__auto__);
var G__50222 = (0);
seq__49342 = G__50219;
chunk__49343 = G__50220;
count__49344 = G__50221;
i__49345 = G__50222;
continue;
} else {
var vec__49363 = cljs.core.first(seq__49342__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49363,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49363,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__50229 = cljs.core.next(seq__49342__$1);
var G__50230 = null;
var G__50231 = (0);
var G__50232 = (0);
seq__49342 = G__50229;
chunk__49343 = G__50230;
count__49344 = G__50231;
i__49345 = G__50232;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__49372 = cljs.core.seq(styles);
var chunk__49373 = null;
var count__49374 = (0);
var i__49375 = (0);
while(true){
if((i__49375 < count__49374)){
var vec__49395 = chunk__49373.cljs$core$IIndexed$_nth$arity$2(null,i__49375);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49395,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49395,(1),null);
var G__49398_50242 = dom;
var G__49399_50243 = cljs.core.name(k);
var G__49400_50244 = (((v == null))?"":v);
goog.style.setStyle(G__49398_50242,G__49399_50243,G__49400_50244);


var G__50248 = seq__49372;
var G__50249 = chunk__49373;
var G__50250 = count__49374;
var G__50251 = (i__49375 + (1));
seq__49372 = G__50248;
chunk__49373 = G__50249;
count__49374 = G__50250;
i__49375 = G__50251;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__49372);
if(temp__5818__auto__){
var seq__49372__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49372__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__49372__$1);
var G__50254 = cljs.core.chunk_rest(seq__49372__$1);
var G__50255 = c__4550__auto__;
var G__50256 = cljs.core.count(c__4550__auto__);
var G__50257 = (0);
seq__49372 = G__50254;
chunk__49373 = G__50255;
count__49374 = G__50256;
i__49375 = G__50257;
continue;
} else {
var vec__49407 = cljs.core.first(seq__49372__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49407,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49407,(1),null);
var G__49413_50261 = dom;
var G__49414_50262 = cljs.core.name(k);
var G__49415_50263 = (((v == null))?"":v);
goog.style.setStyle(G__49413_50261,G__49414_50262,G__49415_50263);


var G__50269 = cljs.core.next(seq__49372__$1);
var G__50270 = null;
var G__50271 = (0);
var G__50272 = (0);
seq__49372 = G__50269;
chunk__49373 = G__50270;
count__49374 = G__50271;
i__49375 = G__50272;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__49418_50280 = key;
var G__49418_50281__$1 = (((G__49418_50280 instanceof cljs.core.Keyword))?G__49418_50280.fqn:null);
switch (G__49418_50281__$1) {
case "id":
el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value);

break;
case "class":
el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value);

break;
case "for":
el.htmlFor = value;

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_50319 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4131__auto__ = goog.string.startsWith(ks_50319,"data-");
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return goog.string.startsWith(ks_50319,"aria-");
}
})())){
el.setAttribute(ks_50319,value);
} else {
(el[ks_50319] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
var G__49430 = shadow.dom.dom_node(el);
var G__49431 = cls;
return goog.dom.classlist.contains(G__49430,G__49431);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__49439){
var map__49440 = p__49439;
var map__49440__$1 = (((((!((map__49440 == null))))?(((((map__49440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49440):map__49440);
var props = map__49440__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49440__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__49444 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49444,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49444,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49444,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__49448 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__49448,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__49448;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__49451 = arguments.length;
switch (G__49451) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5818__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5818__auto__)){
var n = temp__5818__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5818__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5818__auto__)){
var n = temp__5818__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
});

shadow.dom.append.cljs$lang$maxFixedArity = 2;

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__49455){
var vec__49456 = p__49455;
var seq__49457 = cljs.core.seq(vec__49456);
var first__49458 = cljs.core.first(seq__49457);
var seq__49457__$1 = cljs.core.next(seq__49457);
var nn = first__49458;
var first__49458__$1 = cljs.core.first(seq__49457__$1);
var seq__49457__$2 = cljs.core.next(seq__49457__$1);
var np = first__49458__$1;
var nc = seq__49457__$2;
var node = vec__49456;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49459 = nn;
var G__49460 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49459,G__49460) : create_fn.call(null,G__49459,G__49460));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49462 = nn;
var G__49463 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49462,G__49463) : create_fn.call(null,G__49462,G__49463));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__49465 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49465,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49465,(1),null);
var seq__49469_50387 = cljs.core.seq(node_children);
var chunk__49470_50388 = null;
var count__49471_50389 = (0);
var i__49472_50390 = (0);
while(true){
if((i__49472_50390 < count__49471_50389)){
var child_struct_50392 = chunk__49470_50388.cljs$core$IIndexed$_nth$arity$2(null,i__49472_50390);
var children_50393 = shadow.dom.dom_node(child_struct_50392);
if(cljs.core.seq_QMARK_(children_50393)){
var seq__49513_50395 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50393));
var chunk__49515_50396 = null;
var count__49516_50397 = (0);
var i__49517_50398 = (0);
while(true){
if((i__49517_50398 < count__49516_50397)){
var child_50399 = chunk__49515_50396.cljs$core$IIndexed$_nth$arity$2(null,i__49517_50398);
if(cljs.core.truth_(child_50399)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50399);


var G__50400 = seq__49513_50395;
var G__50401 = chunk__49515_50396;
var G__50402 = count__49516_50397;
var G__50403 = (i__49517_50398 + (1));
seq__49513_50395 = G__50400;
chunk__49515_50396 = G__50401;
count__49516_50397 = G__50402;
i__49517_50398 = G__50403;
continue;
} else {
var G__50410 = seq__49513_50395;
var G__50411 = chunk__49515_50396;
var G__50412 = count__49516_50397;
var G__50413 = (i__49517_50398 + (1));
seq__49513_50395 = G__50410;
chunk__49515_50396 = G__50411;
count__49516_50397 = G__50412;
i__49517_50398 = G__50413;
continue;
}
} else {
var temp__5818__auto___50414 = cljs.core.seq(seq__49513_50395);
if(temp__5818__auto___50414){
var seq__49513_50419__$1 = temp__5818__auto___50414;
if(cljs.core.chunked_seq_QMARK_(seq__49513_50419__$1)){
var c__4550__auto___50420 = cljs.core.chunk_first(seq__49513_50419__$1);
var G__50421 = cljs.core.chunk_rest(seq__49513_50419__$1);
var G__50422 = c__4550__auto___50420;
var G__50423 = cljs.core.count(c__4550__auto___50420);
var G__50424 = (0);
seq__49513_50395 = G__50421;
chunk__49515_50396 = G__50422;
count__49516_50397 = G__50423;
i__49517_50398 = G__50424;
continue;
} else {
var child_50431 = cljs.core.first(seq__49513_50419__$1);
if(cljs.core.truth_(child_50431)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50431);


var G__50435 = cljs.core.next(seq__49513_50419__$1);
var G__50436 = null;
var G__50437 = (0);
var G__50438 = (0);
seq__49513_50395 = G__50435;
chunk__49515_50396 = G__50436;
count__49516_50397 = G__50437;
i__49517_50398 = G__50438;
continue;
} else {
var G__50441 = cljs.core.next(seq__49513_50419__$1);
var G__50442 = null;
var G__50443 = (0);
var G__50444 = (0);
seq__49513_50395 = G__50441;
chunk__49515_50396 = G__50442;
count__49516_50397 = G__50443;
i__49517_50398 = G__50444;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50393);
}


var G__50448 = seq__49469_50387;
var G__50449 = chunk__49470_50388;
var G__50450 = count__49471_50389;
var G__50451 = (i__49472_50390 + (1));
seq__49469_50387 = G__50448;
chunk__49470_50388 = G__50449;
count__49471_50389 = G__50450;
i__49472_50390 = G__50451;
continue;
} else {
var temp__5818__auto___50453 = cljs.core.seq(seq__49469_50387);
if(temp__5818__auto___50453){
var seq__49469_50455__$1 = temp__5818__auto___50453;
if(cljs.core.chunked_seq_QMARK_(seq__49469_50455__$1)){
var c__4550__auto___50456 = cljs.core.chunk_first(seq__49469_50455__$1);
var G__50457 = cljs.core.chunk_rest(seq__49469_50455__$1);
var G__50458 = c__4550__auto___50456;
var G__50459 = cljs.core.count(c__4550__auto___50456);
var G__50460 = (0);
seq__49469_50387 = G__50457;
chunk__49470_50388 = G__50458;
count__49471_50389 = G__50459;
i__49472_50390 = G__50460;
continue;
} else {
var child_struct_50461 = cljs.core.first(seq__49469_50455__$1);
var children_50462 = shadow.dom.dom_node(child_struct_50461);
if(cljs.core.seq_QMARK_(children_50462)){
var seq__49524_50463 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50462));
var chunk__49526_50464 = null;
var count__49527_50465 = (0);
var i__49528_50466 = (0);
while(true){
if((i__49528_50466 < count__49527_50465)){
var child_50468 = chunk__49526_50464.cljs$core$IIndexed$_nth$arity$2(null,i__49528_50466);
if(cljs.core.truth_(child_50468)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50468);


var G__50469 = seq__49524_50463;
var G__50470 = chunk__49526_50464;
var G__50471 = count__49527_50465;
var G__50472 = (i__49528_50466 + (1));
seq__49524_50463 = G__50469;
chunk__49526_50464 = G__50470;
count__49527_50465 = G__50471;
i__49528_50466 = G__50472;
continue;
} else {
var G__50474 = seq__49524_50463;
var G__50475 = chunk__49526_50464;
var G__50476 = count__49527_50465;
var G__50477 = (i__49528_50466 + (1));
seq__49524_50463 = G__50474;
chunk__49526_50464 = G__50475;
count__49527_50465 = G__50476;
i__49528_50466 = G__50477;
continue;
}
} else {
var temp__5818__auto___50478__$1 = cljs.core.seq(seq__49524_50463);
if(temp__5818__auto___50478__$1){
var seq__49524_50479__$1 = temp__5818__auto___50478__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49524_50479__$1)){
var c__4550__auto___50480 = cljs.core.chunk_first(seq__49524_50479__$1);
var G__50481 = cljs.core.chunk_rest(seq__49524_50479__$1);
var G__50482 = c__4550__auto___50480;
var G__50483 = cljs.core.count(c__4550__auto___50480);
var G__50484 = (0);
seq__49524_50463 = G__50481;
chunk__49526_50464 = G__50482;
count__49527_50465 = G__50483;
i__49528_50466 = G__50484;
continue;
} else {
var child_50485 = cljs.core.first(seq__49524_50479__$1);
if(cljs.core.truth_(child_50485)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50485);


var G__50487 = cljs.core.next(seq__49524_50479__$1);
var G__50488 = null;
var G__50489 = (0);
var G__50490 = (0);
seq__49524_50463 = G__50487;
chunk__49526_50464 = G__50488;
count__49527_50465 = G__50489;
i__49528_50466 = G__50490;
continue;
} else {
var G__50492 = cljs.core.next(seq__49524_50479__$1);
var G__50493 = null;
var G__50494 = (0);
var G__50495 = (0);
seq__49524_50463 = G__50492;
chunk__49526_50464 = G__50493;
count__49527_50465 = G__50494;
i__49528_50466 = G__50495;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50462);
}


var G__50500 = cljs.core.next(seq__49469_50455__$1);
var G__50501 = null;
var G__50502 = (0);
var G__50503 = (0);
seq__49469_50387 = G__50500;
chunk__49470_50388 = G__50501;
count__49471_50389 = G__50502;
i__49472_50390 = G__50503;
continue;
}
} else {
}
}
break;
}

return node;
});
cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
});

cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
});
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL;

DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
var G__49541 = shadow.dom.dom_node(node);
return goog.dom.removeChildren(G__49541);
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__49545 = cljs.core.seq(node);
var chunk__49546 = null;
var count__49547 = (0);
var i__49548 = (0);
while(true){
if((i__49548 < count__49547)){
var n = chunk__49546.cljs$core$IIndexed$_nth$arity$2(null,i__49548);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__50515 = seq__49545;
var G__50516 = chunk__49546;
var G__50517 = count__49547;
var G__50518 = (i__49548 + (1));
seq__49545 = G__50515;
chunk__49546 = G__50516;
count__49547 = G__50517;
i__49548 = G__50518;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__49545);
if(temp__5818__auto__){
var seq__49545__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49545__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__49545__$1);
var G__50519 = cljs.core.chunk_rest(seq__49545__$1);
var G__50520 = c__4550__auto__;
var G__50521 = cljs.core.count(c__4550__auto__);
var G__50522 = (0);
seq__49545 = G__50519;
chunk__49546 = G__50520;
count__49547 = G__50521;
i__49548 = G__50522;
continue;
} else {
var n = cljs.core.first(seq__49545__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__50524 = cljs.core.next(seq__49545__$1);
var G__50525 = null;
var G__50526 = (0);
var G__50527 = (0);
seq__49545 = G__50524;
chunk__49546 = G__50525;
count__49547 = G__50526;
i__49548 = G__50527;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
var G__49552 = shadow.dom.dom_node(new$);
var G__49553 = shadow.dom.dom_node(old);
return goog.dom.replaceNode(G__49552,G__49553);
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__49559 = arguments.length;
switch (G__49559) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return shadow.dom.dom_node(el).innerText = new_text;
});

shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
});

shadow.dom.text.cljs$lang$maxFixedArity = 2;

shadow.dom.check = (function shadow$dom$check(var_args){
var G__49563 = arguments.length;
switch (G__49563) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
});

shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return shadow.dom.dom_node(el).checked = checked;
});

shadow.dom.check.cljs$lang$maxFixedArity = 2;

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__49584 = arguments.length;
switch (G__49584) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
});

shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4131__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return default$;
}
});

shadow.dom.attr.cljs$lang$maxFixedArity = 3;

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return shadow.dom.dom_node(node).innerHTML = text;
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___50549 = arguments.length;
var i__4731__auto___50551 = (0);
while(true){
if((i__4731__auto___50551 < len__4730__auto___50549)){
args__4736__auto__.push((arguments[i__4731__auto___50551]));

var G__50552 = (i__4731__auto___50551 + (1));
i__4731__auto___50551 = G__50552;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__49596_50553 = cljs.core.seq(nodes);
var chunk__49597_50554 = null;
var count__49598_50555 = (0);
var i__49599_50556 = (0);
while(true){
if((i__49599_50556 < count__49598_50555)){
var node_50558 = chunk__49597_50554.cljs$core$IIndexed$_nth$arity$2(null,i__49599_50556);
fragment.appendChild(shadow.dom._to_dom(node_50558));


var G__50559 = seq__49596_50553;
var G__50560 = chunk__49597_50554;
var G__50561 = count__49598_50555;
var G__50562 = (i__49599_50556 + (1));
seq__49596_50553 = G__50559;
chunk__49597_50554 = G__50560;
count__49598_50555 = G__50561;
i__49599_50556 = G__50562;
continue;
} else {
var temp__5818__auto___50564 = cljs.core.seq(seq__49596_50553);
if(temp__5818__auto___50564){
var seq__49596_50565__$1 = temp__5818__auto___50564;
if(cljs.core.chunked_seq_QMARK_(seq__49596_50565__$1)){
var c__4550__auto___50566 = cljs.core.chunk_first(seq__49596_50565__$1);
var G__50567 = cljs.core.chunk_rest(seq__49596_50565__$1);
var G__50568 = c__4550__auto___50566;
var G__50569 = cljs.core.count(c__4550__auto___50566);
var G__50570 = (0);
seq__49596_50553 = G__50567;
chunk__49597_50554 = G__50568;
count__49598_50555 = G__50569;
i__49599_50556 = G__50570;
continue;
} else {
var node_50571 = cljs.core.first(seq__49596_50565__$1);
fragment.appendChild(shadow.dom._to_dom(node_50571));


var G__50574 = cljs.core.next(seq__49596_50565__$1);
var G__50575 = null;
var G__50576 = (0);
var G__50577 = (0);
seq__49596_50553 = G__50574;
chunk__49597_50554 = G__50575;
count__49598_50555 = G__50576;
i__49599_50556 = G__50577;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
});

shadow.dom.fragment.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
shadow.dom.fragment.cljs$lang$applyTo = (function (seq49594){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49594));
});

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__49604_50579 = cljs.core.seq(scripts);
var chunk__49605_50580 = null;
var count__49606_50581 = (0);
var i__49607_50582 = (0);
while(true){
if((i__49607_50582 < count__49606_50581)){
var vec__49615_50584 = chunk__49605_50580.cljs$core$IIndexed$_nth$arity$2(null,i__49607_50582);
var script_tag_50585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49615_50584,(0),null);
var script_body_50586 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49615_50584,(1),null);
eval(script_body_50586);


var G__50591 = seq__49604_50579;
var G__50592 = chunk__49605_50580;
var G__50593 = count__49606_50581;
var G__50594 = (i__49607_50582 + (1));
seq__49604_50579 = G__50591;
chunk__49605_50580 = G__50592;
count__49606_50581 = G__50593;
i__49607_50582 = G__50594;
continue;
} else {
var temp__5818__auto___50595 = cljs.core.seq(seq__49604_50579);
if(temp__5818__auto___50595){
var seq__49604_50600__$1 = temp__5818__auto___50595;
if(cljs.core.chunked_seq_QMARK_(seq__49604_50600__$1)){
var c__4550__auto___50601 = cljs.core.chunk_first(seq__49604_50600__$1);
var G__50604 = cljs.core.chunk_rest(seq__49604_50600__$1);
var G__50605 = c__4550__auto___50601;
var G__50606 = cljs.core.count(c__4550__auto___50601);
var G__50607 = (0);
seq__49604_50579 = G__50604;
chunk__49605_50580 = G__50605;
count__49606_50581 = G__50606;
i__49607_50582 = G__50607;
continue;
} else {
var vec__49619_50615 = cljs.core.first(seq__49604_50600__$1);
var script_tag_50616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49619_50615,(0),null);
var script_body_50617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49619_50615,(1),null);
eval(script_body_50617);


var G__50618 = cljs.core.next(seq__49604_50600__$1);
var G__50619 = null;
var G__50620 = (0);
var G__50621 = (0);
seq__49604_50579 = G__50618;
chunk__49605_50580 = G__50619;
count__49606_50581 = G__50620;
i__49607_50582 = G__50621;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scripts){
return (function (s__$1,p__49624){
var vec__49625 = p__49624;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49625,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49625,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
});})(scripts))
,s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
el.innerHTML = s;

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
var G__49633 = shadow.dom.dom_node(el);
var G__49634 = cls;
return goog.dom.getAncestorByClass(G__49633,G__49634);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__49638 = arguments.length;
switch (G__49638) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
var G__49642 = shadow.dom.dom_node(el);
var G__49643 = cljs.core.name(tag);
return goog.dom.getAncestorByTagNameAndClass(G__49642,G__49643);
});

shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
var G__49646 = shadow.dom.dom_node(el);
var G__49647 = cljs.core.name(tag);
var G__49648 = cljs.core.name(cls);
return goog.dom.getAncestorByTagNameAndClass(G__49646,G__49647,G__49648);
});

shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3;

shadow.dom.get_value = (function shadow$dom$get_value(dom){
var G__49651 = shadow.dom.dom_node(dom);
return goog.dom.forms.getValue(G__49651);
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
var G__49655 = shadow.dom.dom_node(dom);
var G__49656 = value;
return goog.dom.forms.setValue(G__49655,G__49656);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__49662 = cljs.core.seq(style_keys);
var chunk__49663 = null;
var count__49664 = (0);
var i__49665 = (0);
while(true){
if((i__49665 < count__49664)){
var it = chunk__49663.cljs$core$IIndexed$_nth$arity$2(null,i__49665);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50640 = seq__49662;
var G__50641 = chunk__49663;
var G__50642 = count__49664;
var G__50643 = (i__49665 + (1));
seq__49662 = G__50640;
chunk__49663 = G__50641;
count__49664 = G__50642;
i__49665 = G__50643;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__49662);
if(temp__5818__auto__){
var seq__49662__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49662__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__49662__$1);
var G__50646 = cljs.core.chunk_rest(seq__49662__$1);
var G__50647 = c__4550__auto__;
var G__50648 = cljs.core.count(c__4550__auto__);
var G__50649 = (0);
seq__49662 = G__50646;
chunk__49663 = G__50647;
count__49664 = G__50648;
i__49665 = G__50649;
continue;
} else {
var it = cljs.core.first(seq__49662__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50650 = cljs.core.next(seq__49662__$1);
var G__50651 = null;
var G__50652 = (0);
var G__50653 = (0);
seq__49662 = G__50650;
chunk__49663 = G__50651;
count__49664 = G__50652;
i__49665 = G__50653;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k49674,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__49685 = k49674;
var G__49685__$1 = (((G__49685 instanceof cljs.core.Keyword))?G__49685.fqn:null);
switch (G__49685__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49674,else__4388__auto__);

}
});

shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__49687){
var vec__49689 = p__49687;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49689,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49689,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49673){
var self__ = this;
var G__49673__$1 = this;
return (new cljs.core.RecordIter((0),G__49673__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__49701 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__49701(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49676,other49677){
var self__ = this;
var this49676__$1 = this;
return (((!((other49677 == null)))) && ((this49676__$1.constructor === other49677.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49676__$1.x,other49677.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49676__$1.y,other49677.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49676__$1.__extmap,other49677.__extmap)));
});

shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__49673){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__49708 = cljs.core.keyword_identical_QMARK_;
var expr__49709 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__49711 = new cljs.core.Keyword(null,"x","x",2099068185);
var G__49712 = expr__49709;
return (pred__49708.cljs$core$IFn$_invoke$arity$2 ? pred__49708.cljs$core$IFn$_invoke$arity$2(G__49711,G__49712) : pred__49708.call(null,G__49711,G__49712));
})())){
return (new shadow.dom.Coordinate(G__49673,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49713 = new cljs.core.Keyword(null,"y","y",-1757859776);
var G__49714 = expr__49709;
return (pred__49708.cljs$core$IFn$_invoke$arity$2 ? pred__49708.cljs$core$IFn$_invoke$arity$2(G__49713,G__49714) : pred__49708.call(null,G__49713,G__49714));
})())){
return (new shadow.dom.Coordinate(self__.x,G__49673,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__49673),null));
}
}
});

shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
});

shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__49673){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__49673,self__.__extmap,self__.__hash));
});

shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
});

shadow.dom.Coordinate.cljs$lang$type = true;

shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
});

shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"shadow.dom/Coordinate");
});

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__49679){
var extmap__4424__auto__ = (function (){var G__49722 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49679,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__49679)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49722);
} else {
return G__49722;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__49679),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__49679),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = (function (){var G__49724 = shadow.dom.dom_node(el);
return goog.style.getPosition(G__49724);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = (function (){var G__49726 = shadow.dom.dom_node(el);
return goog.style.getClientPosition(G__49726);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = (function (){var G__49730 = shadow.dom.dom_node(el);
return goog.style.getPageOffset(G__49730);
})();
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4385__auto__,k__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
return this__4385__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4386__auto__,null);
});

shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4387__auto__,k49735,else__4388__auto__){
var self__ = this;
var this__4387__auto____$1 = this;
var G__49749 = k49735;
var G__49749__$1 = (((G__49749 instanceof cljs.core.Keyword))?G__49749.fqn:null);
switch (G__49749__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49735,else__4388__auto__);

}
});

shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4404__auto__,f__4405__auto__,init__4406__auto__){
var self__ = this;
var this__4404__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (this__4404__auto____$1){
return (function (ret__4407__auto__,p__49755){
var vec__49757 = p__49755;
var k__4408__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49757,(0),null);
var v__4409__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49757,(1),null);
return (f__4405__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4405__auto__.cljs$core$IFn$_invoke$arity$3(ret__4407__auto__,k__4408__auto__,v__4409__auto__) : f__4405__auto__.call(null,ret__4407__auto__,k__4408__auto__,v__4409__auto__));
});})(this__4404__auto____$1))
,init__4406__auto__,this__4404__auto____$1);
});

shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4399__auto__,writer__4400__auto__,opts__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
var pr_pair__4402__auto__ = ((function (this__4399__auto____$1){
return (function (keyval__4403__auto__){
return cljs.core.pr_sequential_writer(writer__4400__auto__,cljs.core.pr_writer,""," ","",opts__4401__auto__,keyval__4403__auto__);
});})(this__4399__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__4400__auto__,pr_pair__4402__auto__,"#shadow.dom.Size{",", ","}",opts__4401__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49734){
var self__ = this;
var G__49734__$1 = this;
return (new cljs.core.RecordIter((0),G__49734__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4383__auto__){
var self__ = this;
var this__4383__auto____$1 = this;
return self__.__meta;
});

shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4380__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4389__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4381__auto__){
var self__ = this;
var this__4381__auto____$1 = this;
var h__4243__auto__ = self__.__hash;
if((!((h__4243__auto__ == null)))){
return h__4243__auto__;
} else {
var h__4243__auto____$1 = (function (){var fexpr__49778 = ((function (h__4243__auto__,this__4381__auto____$1){
return (function (coll__4382__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4382__auto__));
});})(h__4243__auto__,this__4381__auto____$1))
;
return fexpr__49778(this__4381__auto____$1);
})();
self__.__hash = h__4243__auto____$1;

return h__4243__auto____$1;
}
});

shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49736,other49737){
var self__ = this;
var this49736__$1 = this;
return (((!((other49737 == null)))) && ((this49736__$1.constructor === other49737.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49736__$1.w,other49737.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49736__$1.h,other49737.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49736__$1.__extmap,other49737.__extmap)));
});

shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4394__auto__,k__4395__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4395__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4394__auto____$1),self__.__meta),k__4395__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4395__auto__)),null));
}
});

shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4392__auto__,k__4393__auto__,G__49734){
var self__ = this;
var this__4392__auto____$1 = this;
var pred__49783 = cljs.core.keyword_identical_QMARK_;
var expr__49784 = k__4393__auto__;
if(cljs.core.truth_((function (){var G__49789 = new cljs.core.Keyword(null,"w","w",354169001);
var G__49790 = expr__49784;
return (pred__49783.cljs$core$IFn$_invoke$arity$2 ? pred__49783.cljs$core$IFn$_invoke$arity$2(G__49789,G__49790) : pred__49783.call(null,G__49789,G__49790));
})())){
return (new shadow.dom.Size(G__49734,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49791 = new cljs.core.Keyword(null,"h","h",1109658740);
var G__49792 = expr__49784;
return (pred__49783.cljs$core$IFn$_invoke$arity$2 ? pred__49783.cljs$core$IFn$_invoke$arity$2(G__49791,G__49792) : pred__49783.call(null,G__49791,G__49792));
})())){
return (new shadow.dom.Size(self__.w,G__49734,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4393__auto__,G__49734),null));
}
}
});

shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4397__auto__){
var self__ = this;
var this__4397__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
});

shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4384__auto__,G__49734){
var self__ = this;
var this__4384__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__49734,self__.__extmap,self__.__hash));
});

shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4390__auto__,entry__4391__auto__){
var self__ = this;
var this__4390__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4391__auto__)){
return this__4390__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4391__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4390__auto____$1,entry__4391__auto__);
}
});

shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
});

shadow.dom.Size.cljs$lang$type = true;

shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4428__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
});

shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4428__auto__,writer__4429__auto__){
return cljs.core._write(writer__4429__auto__,"shadow.dom/Size");
});

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__49740){
var extmap__4424__auto__ = (function (){var G__49796 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49740,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__49740)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49796);
} else {
return G__49796;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__49740),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__49740),null,cljs.core.not_empty(extmap__4424__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj((function (){var G__49797 = shadow.dom.dom_node(el);
return goog.style.getSize(G__49797);
})());
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(shadow.dom.get_size(el));
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4604__auto__ = opts;
var l__4605__auto__ = a__4604__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4605__auto__)){
var G__50698 = (i + (1));
var G__50699 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__50698;
ret = G__50699;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__49803){
var vec__49804 = p__49803;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49804,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49804,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params)))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__49821 = arguments.length;
switch (G__49821) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
});

shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
});

shadow.dom.redirect.cljs$lang$maxFixedArity = 2;

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return document.location.href = document.location.href;
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__49830_50709 = new_node;
var G__49831_50710 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingAfter(G__49830_50709,G__49831_50710);

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
var G__49835_50711 = new_node;
var G__49836_50712 = shadow.dom.dom_node(ref);
goog.dom.insertSiblingBefore(G__49835_50711,G__49836_50712);

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5816__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5816__auto__)){
var child = temp__5816__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__50714 = ps;
var G__50715 = (i + (1));
el__$1 = G__50714;
i = G__50715;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
var G__49846 = shadow.dom.dom_node(el);
return goog.dom.getParentElement(G__49846);
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,((function (parent){
return (function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
});})(parent))
,null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
var G__49858 = shadow.dom.dom_node(el);
return goog.dom.getNextElementSibling(G__49858);
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
var G__49864 = shadow.dom.dom_node(el);
return goog.dom.getPreviousElementSibling(G__49864);
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__49869 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49869,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49869,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49869,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__49873_50725 = cljs.core.seq(props);
var chunk__49875_50726 = null;
var count__49876_50727 = (0);
var i__49877_50728 = (0);
while(true){
if((i__49877_50728 < count__49876_50727)){
var vec__49889_50729 = chunk__49875_50726.cljs$core$IIndexed$_nth$arity$2(null,i__49877_50728);
var k_50730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49889_50729,(0),null);
var v_50731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49889_50729,(1),null);
el.setAttributeNS((function (){var temp__5818__auto__ = cljs.core.namespace(k_50730);
if(cljs.core.truth_(temp__5818__auto__)){
var ns = temp__5818__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50730),v_50731);


var G__50733 = seq__49873_50725;
var G__50734 = chunk__49875_50726;
var G__50735 = count__49876_50727;
var G__50736 = (i__49877_50728 + (1));
seq__49873_50725 = G__50733;
chunk__49875_50726 = G__50734;
count__49876_50727 = G__50735;
i__49877_50728 = G__50736;
continue;
} else {
var temp__5818__auto___50738 = cljs.core.seq(seq__49873_50725);
if(temp__5818__auto___50738){
var seq__49873_50739__$1 = temp__5818__auto___50738;
if(cljs.core.chunked_seq_QMARK_(seq__49873_50739__$1)){
var c__4550__auto___50740 = cljs.core.chunk_first(seq__49873_50739__$1);
var G__50741 = cljs.core.chunk_rest(seq__49873_50739__$1);
var G__50742 = c__4550__auto___50740;
var G__50743 = cljs.core.count(c__4550__auto___50740);
var G__50744 = (0);
seq__49873_50725 = G__50741;
chunk__49875_50726 = G__50742;
count__49876_50727 = G__50743;
i__49877_50728 = G__50744;
continue;
} else {
var vec__49901_50745 = cljs.core.first(seq__49873_50739__$1);
var k_50746 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49901_50745,(0),null);
var v_50747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49901_50745,(1),null);
el.setAttributeNS((function (){var temp__5818__auto____$1 = cljs.core.namespace(k_50746);
if(cljs.core.truth_(temp__5818__auto____$1)){
var ns = temp__5818__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50746),v_50747);


var G__50749 = cljs.core.next(seq__49873_50739__$1);
var G__50750 = null;
var G__50751 = (0);
var G__50752 = (0);
seq__49873_50725 = G__50749;
chunk__49875_50726 = G__50750;
count__49876_50727 = G__50751;
i__49877_50728 = G__50752;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__49912 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49912,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49912,(1),null);
var seq__49915_50754 = cljs.core.seq(node_children);
var chunk__49917_50755 = null;
var count__49918_50756 = (0);
var i__49919_50757 = (0);
while(true){
if((i__49919_50757 < count__49918_50756)){
var child_struct_50758 = chunk__49917_50755.cljs$core$IIndexed$_nth$arity$2(null,i__49919_50757);
if((!((child_struct_50758 == null)))){
if(typeof child_struct_50758 === 'string'){
var text_50759 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50759),child_struct_50758].join(''));
} else {
var children_50761 = shadow.dom.svg_node(child_struct_50758);
if(cljs.core.seq_QMARK_(children_50761)){
var seq__49965_50762 = cljs.core.seq(children_50761);
var chunk__49967_50763 = null;
var count__49968_50764 = (0);
var i__49969_50765 = (0);
while(true){
if((i__49969_50765 < count__49968_50764)){
var child_50767 = chunk__49967_50763.cljs$core$IIndexed$_nth$arity$2(null,i__49969_50765);
if(cljs.core.truth_(child_50767)){
node.appendChild(child_50767);


var G__50768 = seq__49965_50762;
var G__50769 = chunk__49967_50763;
var G__50770 = count__49968_50764;
var G__50771 = (i__49969_50765 + (1));
seq__49965_50762 = G__50768;
chunk__49967_50763 = G__50769;
count__49968_50764 = G__50770;
i__49969_50765 = G__50771;
continue;
} else {
var G__50772 = seq__49965_50762;
var G__50773 = chunk__49967_50763;
var G__50774 = count__49968_50764;
var G__50775 = (i__49969_50765 + (1));
seq__49965_50762 = G__50772;
chunk__49967_50763 = G__50773;
count__49968_50764 = G__50774;
i__49969_50765 = G__50775;
continue;
}
} else {
var temp__5818__auto___50777 = cljs.core.seq(seq__49965_50762);
if(temp__5818__auto___50777){
var seq__49965_50778__$1 = temp__5818__auto___50777;
if(cljs.core.chunked_seq_QMARK_(seq__49965_50778__$1)){
var c__4550__auto___50779 = cljs.core.chunk_first(seq__49965_50778__$1);
var G__50780 = cljs.core.chunk_rest(seq__49965_50778__$1);
var G__50781 = c__4550__auto___50779;
var G__50782 = cljs.core.count(c__4550__auto___50779);
var G__50783 = (0);
seq__49965_50762 = G__50780;
chunk__49967_50763 = G__50781;
count__49968_50764 = G__50782;
i__49969_50765 = G__50783;
continue;
} else {
var child_50784 = cljs.core.first(seq__49965_50778__$1);
if(cljs.core.truth_(child_50784)){
node.appendChild(child_50784);


var G__50789 = cljs.core.next(seq__49965_50778__$1);
var G__50790 = null;
var G__50791 = (0);
var G__50792 = (0);
seq__49965_50762 = G__50789;
chunk__49967_50763 = G__50790;
count__49968_50764 = G__50791;
i__49969_50765 = G__50792;
continue;
} else {
var G__50794 = cljs.core.next(seq__49965_50778__$1);
var G__50795 = null;
var G__50796 = (0);
var G__50797 = (0);
seq__49965_50762 = G__50794;
chunk__49967_50763 = G__50795;
count__49968_50764 = G__50796;
i__49969_50765 = G__50797;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50761);
}
}


var G__50799 = seq__49915_50754;
var G__50800 = chunk__49917_50755;
var G__50801 = count__49918_50756;
var G__50802 = (i__49919_50757 + (1));
seq__49915_50754 = G__50799;
chunk__49917_50755 = G__50800;
count__49918_50756 = G__50801;
i__49919_50757 = G__50802;
continue;
} else {
var G__50803 = seq__49915_50754;
var G__50804 = chunk__49917_50755;
var G__50805 = count__49918_50756;
var G__50806 = (i__49919_50757 + (1));
seq__49915_50754 = G__50803;
chunk__49917_50755 = G__50804;
count__49918_50756 = G__50805;
i__49919_50757 = G__50806;
continue;
}
} else {
var temp__5818__auto___50808 = cljs.core.seq(seq__49915_50754);
if(temp__5818__auto___50808){
var seq__49915_50809__$1 = temp__5818__auto___50808;
if(cljs.core.chunked_seq_QMARK_(seq__49915_50809__$1)){
var c__4550__auto___50810 = cljs.core.chunk_first(seq__49915_50809__$1);
var G__50812 = cljs.core.chunk_rest(seq__49915_50809__$1);
var G__50813 = c__4550__auto___50810;
var G__50814 = cljs.core.count(c__4550__auto___50810);
var G__50815 = (0);
seq__49915_50754 = G__50812;
chunk__49917_50755 = G__50813;
count__49918_50756 = G__50814;
i__49919_50757 = G__50815;
continue;
} else {
var child_struct_50817 = cljs.core.first(seq__49915_50809__$1);
if((!((child_struct_50817 == null)))){
if(typeof child_struct_50817 === 'string'){
var text_50818 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50818),child_struct_50817].join(''));
} else {
var children_50819 = shadow.dom.svg_node(child_struct_50817);
if(cljs.core.seq_QMARK_(children_50819)){
var seq__49977_50821 = cljs.core.seq(children_50819);
var chunk__49979_50822 = null;
var count__49980_50823 = (0);
var i__49981_50824 = (0);
while(true){
if((i__49981_50824 < count__49980_50823)){
var child_50827 = chunk__49979_50822.cljs$core$IIndexed$_nth$arity$2(null,i__49981_50824);
if(cljs.core.truth_(child_50827)){
node.appendChild(child_50827);


var G__50829 = seq__49977_50821;
var G__50830 = chunk__49979_50822;
var G__50831 = count__49980_50823;
var G__50832 = (i__49981_50824 + (1));
seq__49977_50821 = G__50829;
chunk__49979_50822 = G__50830;
count__49980_50823 = G__50831;
i__49981_50824 = G__50832;
continue;
} else {
var G__50833 = seq__49977_50821;
var G__50834 = chunk__49979_50822;
var G__50835 = count__49980_50823;
var G__50836 = (i__49981_50824 + (1));
seq__49977_50821 = G__50833;
chunk__49979_50822 = G__50834;
count__49980_50823 = G__50835;
i__49981_50824 = G__50836;
continue;
}
} else {
var temp__5818__auto___50837__$1 = cljs.core.seq(seq__49977_50821);
if(temp__5818__auto___50837__$1){
var seq__49977_50838__$1 = temp__5818__auto___50837__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49977_50838__$1)){
var c__4550__auto___50839 = cljs.core.chunk_first(seq__49977_50838__$1);
var G__50841 = cljs.core.chunk_rest(seq__49977_50838__$1);
var G__50842 = c__4550__auto___50839;
var G__50843 = cljs.core.count(c__4550__auto___50839);
var G__50844 = (0);
seq__49977_50821 = G__50841;
chunk__49979_50822 = G__50842;
count__49980_50823 = G__50843;
i__49981_50824 = G__50844;
continue;
} else {
var child_50846 = cljs.core.first(seq__49977_50838__$1);
if(cljs.core.truth_(child_50846)){
node.appendChild(child_50846);


var G__50847 = cljs.core.next(seq__49977_50838__$1);
var G__50848 = null;
var G__50849 = (0);
var G__50850 = (0);
seq__49977_50821 = G__50847;
chunk__49979_50822 = G__50848;
count__49980_50823 = G__50849;
i__49981_50824 = G__50850;
continue;
} else {
var G__50854 = cljs.core.next(seq__49977_50838__$1);
var G__50855 = null;
var G__50856 = (0);
var G__50857 = (0);
seq__49977_50821 = G__50854;
chunk__49979_50822 = G__50855;
count__49980_50823 = G__50856;
i__49981_50824 = G__50857;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50819);
}
}


var G__50858 = cljs.core.next(seq__49915_50809__$1);
var G__50859 = null;
var G__50860 = (0);
var G__50861 = (0);
seq__49915_50754 = G__50858;
chunk__49917_50755 = G__50859;
count__49918_50756 = G__50860;
i__49919_50757 = G__50861;
continue;
} else {
var G__50863 = cljs.core.next(seq__49915_50809__$1);
var G__50864 = null;
var G__50865 = (0);
var G__50866 = (0);
seq__49915_50754 = G__50863;
chunk__49917_50755 = G__50864;
count__49918_50756 = G__50865;
i__49919_50757 = G__50866;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

var G__49999_50867 = shadow.dom._to_svg;
var G__50000_50868 = "string";
var G__50001_50869 = ((function (G__49999_50867,G__50000_50868){
return (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
});})(G__49999_50867,G__50000_50868))
;
goog.object.set(G__49999_50867,G__50000_50868,G__50001_50869);

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
});

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
});

goog.object.set(shadow.dom.SVGElement,"null",true);

var G__50014_50874 = shadow.dom._to_svg;
var G__50015_50875 = "null";
var G__50016_50876 = ((function (G__50014_50874,G__50015_50875){
return (function (_){
return null;
});})(G__50014_50874,G__50015_50875))
;
goog.object.set(G__50014_50874,G__50015_50875,G__50016_50876);
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4736__auto__ = [];
var len__4730__auto___50879 = arguments.length;
var i__4731__auto___50880 = (0);
while(true){
if((i__4731__auto___50880 < len__4730__auto___50879)){
args__4736__auto__.push((arguments[i__4731__auto___50880]));

var G__50881 = (i__4731__auto___50880 + (1));
i__4731__auto___50880 = G__50881;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
});

shadow.dom.svg.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
shadow.dom.svg.cljs$lang$applyTo = (function (seq50019){
var G__50020 = cljs.core.first(seq50019);
var seq50019__$1 = cljs.core.next(seq50019);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50020,seq50019__$1);
});

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__50038 = arguments.length;
switch (G__50038) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
});

shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = ((function (buf,chan){
return (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});})(buf,chan))
;
var G__50046_50885 = shadow.dom.dom_node(el);
var G__50047_50886 = cljs.core.name(event);
var G__50048_50887 = event_fn;
shadow.dom.dom_listen(G__50046_50885,G__50047_50886,G__50048_50887);

if(cljs.core.truth_((function (){var and__4120__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4120__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4120__auto__;
}
})())){
var c__46663__auto___50889 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__46663__auto___50889,buf,chan,event_fn){
return (function (){
var f__46664__auto__ = (function (){var switch__46368__auto__ = ((function (c__46663__auto___50889,buf,chan,event_fn){
return (function (state_50058){
var state_val_50059 = (state_50058[(1)]);
if((state_val_50059 === (1))){
var state_50058__$1 = state_50058;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50058__$1,(2),once_or_cleanup);
} else {
if((state_val_50059 === (2))){
var inst_50054 = (state_50058[(2)]);
var inst_50055 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_50058__$1 = (function (){var statearr_50061 = state_50058;
(statearr_50061[(7)] = inst_50054);

return statearr_50061;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_50058__$1,inst_50055);
} else {
return null;
}
}
});})(c__46663__auto___50889,buf,chan,event_fn))
;
return ((function (switch__46368__auto__,c__46663__auto___50889,buf,chan,event_fn){
return (function() {
var shadow$dom$state_machine__46369__auto__ = null;
var shadow$dom$state_machine__46369__auto____0 = (function (){
var statearr_50064 = [null,null,null,null,null,null,null,null];
(statearr_50064[(0)] = shadow$dom$state_machine__46369__auto__);

(statearr_50064[(1)] = (1));

return statearr_50064;
});
var shadow$dom$state_machine__46369__auto____1 = (function (state_50058){
while(true){
var ret_value__46370__auto__ = (function (){try{while(true){
var result__46371__auto__ = switch__46368__auto__(state_50058);
if(cljs.core.keyword_identical_QMARK_(result__46371__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46371__auto__;
}
break;
}
}catch (e50066){if((e50066 instanceof Object)){
var ex__46372__auto__ = e50066;
var statearr_50068_50896 = state_50058;
(statearr_50068_50896[(5)] = ex__46372__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50058);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50066;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46370__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50899 = state_50058;
state_50058 = G__50899;
continue;
} else {
return ret_value__46370__auto__;
}
break;
}
});
shadow$dom$state_machine__46369__auto__ = function(state_50058){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__46369__auto____0.call(this);
case 1:
return shadow$dom$state_machine__46369__auto____1.call(this,state_50058);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__46369__auto____0;
shadow$dom$state_machine__46369__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__46369__auto____1;
return shadow$dom$state_machine__46369__auto__;
})()
;})(switch__46368__auto__,c__46663__auto___50889,buf,chan,event_fn))
})();
var state__46665__auto__ = (function (){var statearr_50070 = f__46664__auto__();
(statearr_50070[(6)] = c__46663__auto___50889);

return statearr_50070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46665__auto__);
});})(c__46663__auto___50889,buf,chan,event_fn))
);

} else {
}

return chan;
});

shadow.dom.event_chan.cljs$lang$maxFixedArity = 4;


//# sourceMappingURL=shadow.dom.js.map
