goog.provide('re_frame.trace');
goog.require('cljs.core');
goog.require('re_frame.interop');
goog.require('re_frame.loggers');
goog.require('goog.functions');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/Day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__53122){
var map__53123 = p__53122;
var map__53123__$1 = (((((!((map__53123 == null))))?(((((map__53123.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__53123.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53123):map__53123);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53123__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53123__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53123__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53123__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4131__auto__ = child_of;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__53125_53152 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__53126_53153 = null;
var count__53127_53154 = (0);
var i__53128_53155 = (0);
while(true){
if((i__53128_53155 < count__53127_53154)){
var vec__53139_53156 = chunk__53126_53153.cljs$core$IIndexed$_nth$arity$2(null,i__53128_53155);
var k_53157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53139_53156,(0),null);
var cb_53158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53139_53156,(1),null);
try{var G__53143_53159 = cljs.core.deref(re_frame.trace.traces);
(cb_53158.cljs$core$IFn$_invoke$arity$1 ? cb_53158.cljs$core$IFn$_invoke$arity$1(G__53143_53159) : cb_53158.call(null,G__53143_53159));
}catch (e53142){var e_53160 = e53142;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_53157,"while storing",cljs.core.deref(re_frame.trace.traces),e_53160], 0));
}

var G__53161 = seq__53125_53152;
var G__53162 = chunk__53126_53153;
var G__53163 = count__53127_53154;
var G__53164 = (i__53128_53155 + (1));
seq__53125_53152 = G__53161;
chunk__53126_53153 = G__53162;
count__53127_53154 = G__53163;
i__53128_53155 = G__53164;
continue;
} else {
var temp__5818__auto___53165 = cljs.core.seq(seq__53125_53152);
if(temp__5818__auto___53165){
var seq__53125_53166__$1 = temp__5818__auto___53165;
if(cljs.core.chunked_seq_QMARK_(seq__53125_53166__$1)){
var c__4550__auto___53167 = cljs.core.chunk_first(seq__53125_53166__$1);
var G__53168 = cljs.core.chunk_rest(seq__53125_53166__$1);
var G__53169 = c__4550__auto___53167;
var G__53170 = cljs.core.count(c__4550__auto___53167);
var G__53171 = (0);
seq__53125_53152 = G__53168;
chunk__53126_53153 = G__53169;
count__53127_53154 = G__53170;
i__53128_53155 = G__53171;
continue;
} else {
var vec__53144_53172 = cljs.core.first(seq__53125_53166__$1);
var k_53173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53144_53172,(0),null);
var cb_53174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53144_53172,(1),null);
try{var G__53148_53176 = cljs.core.deref(re_frame.trace.traces);
(cb_53174.cljs$core$IFn$_invoke$arity$1 ? cb_53174.cljs$core$IFn$_invoke$arity$1(G__53148_53176) : cb_53174.call(null,G__53148_53176));
}catch (e53147){var e_53177 = e53147;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_53173,"while storing",cljs.core.deref(re_frame.trace.traces),e_53177], 0));
}

var G__53178 = cljs.core.next(seq__53125_53166__$1);
var G__53179 = null;
var G__53180 = (0);
var G__53181 = (0);
seq__53125_53152 = G__53178;
chunk__53126_53153 = G__53179;
count__53127_53154 = G__53180;
i__53128_53155 = G__53181;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
