goog.provide('flow_storm.api');
goog.require('cljs.core');
goog.require('flow_storm.tracer');
flow_storm.api.traced_vars_orig_fns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Connects to flow-storm debugger.
 *   Once connected, all generated traces are sent to the debugger thru
 *   a websocket connection.
 *   Optionally you can provide a map with :host and :port keys.
 */
flow_storm.api.connect = flow_storm.tracer.connect;
/**
 * Adds a watch to ref with ref-name that traces its value changes.
 */
flow_storm.api.trace_ref = flow_storm.tracer.trace_ref;
/**
 * Removes the watch added by trace-ref.
 */
flow_storm.api.untrace_ref = flow_storm.tracer.untrace_ref;
flow_storm.api.trace_re_frame = (function flow_storm$api$trace_re_frame(){
var register_trace_cb = (((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.register_trace_cb !== 'undefined'))?(new cljs.core.Var((function (){
return re_frame.trace.register_trace_cb;
}),cljs.core.with_meta(new cljs.core.Symbol("re-frame.trace","register-trace-cb","re-frame.trace/register-trace-cb",-1257060230,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true], null)),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"re-frame.trace","re-frame.trace",-1584328505,null),new cljs.core.Symbol(null,"register-trace-cb","register-trace-cb",-161644692,null),"re_frame/trace.cljc",(24),(1),(33),(33),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),"Registers a tracing callback function which will receive a collection of one or more traces.\n  Will replace an existing callback function if it shares the same key.",(cljs.core.truth_(re_frame.trace.register_trace_cb)?re_frame.trace.register_trace_cb.cljs$lang$test:null)]))):null);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["register-trace-cb",register_trace_cb], 0));

var G__70170 = new cljs.core.Keyword(null,"flow-storm","flow-storm",-1356628559);
var G__70171 = ((function (G__70170,register_trace_cb){
return (function (traces){
var seq__70172 = cljs.core.seq(traces);
var chunk__70173 = null;
var count__70174 = (0);
var i__70175 = (0);
while(true){
if((i__70175 < count__70174)){
var t = chunk__70173.cljs$core$IIndexed$_nth$arity$2(null,i__70175);
cljs.core.tap_GT_(t);


var G__70176 = seq__70172;
var G__70177 = chunk__70173;
var G__70178 = count__70174;
var G__70179 = (i__70175 + (1));
seq__70172 = G__70176;
chunk__70173 = G__70177;
count__70174 = G__70178;
i__70175 = G__70179;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__70172);
if(temp__5754__auto__){
var seq__70172__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__70172__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__70172__$1);
var G__70180 = cljs.core.chunk_rest(seq__70172__$1);
var G__70181 = c__4550__auto__;
var G__70182 = cljs.core.count(c__4550__auto__);
var G__70183 = (0);
seq__70172 = G__70180;
chunk__70173 = G__70181;
count__70174 = G__70182;
i__70175 = G__70183;
continue;
} else {
var t = cljs.core.first(seq__70172__$1);
cljs.core.tap_GT_(t);


var G__70184 = cljs.core.next(seq__70172__$1);
var G__70185 = null;
var G__70186 = (0);
var G__70187 = (0);
seq__70172 = G__70184;
chunk__70173 = G__70185;
count__70174 = G__70186;
i__70175 = G__70187;
continue;
}
} else {
return null;
}
}
break;
}
});})(G__70170,register_trace_cb))
;
return (register_trace_cb.cljs$core$IFn$_invoke$arity$2 ? register_trace_cb.cljs$core$IFn$_invoke$arity$2(G__70170,G__70171) : register_trace_cb.call(null,G__70170,G__70171));
});

//# sourceMappingURL=flow_storm.api.js.map
