goog.provide('editscript.diff.quick');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('editscript.edit');
goog.require('editscript.util.common');
editscript.diff.quick.diff_STAR_ = (function editscript$diff$quick$diff_STAR_(script,path,a,b){
return null;
});
editscript.diff.quick.diff_map = (function editscript$diff$quick$diff_map(script,path,a,b){
cljs.core.reduce_kv((function (_,ka,va){
var path_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,ka);
if(cljs.core.contains_QMARK_(b,ka)){
var G__91375 = script;
var G__91376 = path_SINGLEQUOTE_;
var G__91377 = va;
var G__91378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,ka);
return (editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91375,G__91376,G__91377,G__91378) : editscript.diff.quick.diff_STAR_.call(null,G__91375,G__91376,G__91377,G__91378));
} else {
var G__91380 = script;
var G__91381 = path_SINGLEQUOTE_;
var G__91382 = va;
var G__91383 = editscript.edit.nada();
return (editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91380,G__91381,G__91382,G__91383) : editscript.diff.quick.diff_STAR_.call(null,G__91380,G__91381,G__91382,G__91383));
}
}),null,a);

return cljs.core.reduce_kv((function (_,kb,vb){
if(cljs.core.contains_QMARK_(a,kb)){
return null;
} else {
var G__91384 = script;
var G__91385 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,kb);
var G__91386 = editscript.edit.nada();
var G__91387 = vb;
return (editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91384,G__91385,G__91386,G__91387) : editscript.diff.quick.diff_STAR_.call(null,G__91384,G__91385,G__91386,G__91387));
}
}),null,b);
});
/**
 * Based on 'Wu, S. et al., 1990, An O(NP) Sequence Comparison Algorithm,
 *   Information Processing Letters, 35:6, p317-23.'
 * 
 *   A greedy algorithm, attempting to get to the furthest points with a given
 *   number of edits. Very fast. However, it does not have replacement operations,
 *   so it is not very useful for nested trees. It can also only do unit cost for
 *   addition and deletion. 
 */
editscript.diff.quick.vec_edits_STAR_ = (function editscript$diff$quick$vec_edits_STAR_(a,b,n,m){
var delta = (n - m);
var snake = ((function (delta){
return (function (k,x){
var x__$1 = x;
var y = (x__$1 - k);
while(true){
var ax = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,x__$1);
var by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,y);
if((((x__$1 < n)) && ((y < m)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.type(ax),cljs.core.type(by))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ax,by)))){
var G__91502 = (x__$1 + (1));
var G__91503 = (y + (1));
x__$1 = G__91502;
y = G__91503;
continue;
} else {
return x__$1;
}
break;
}
});})(delta))
;
var fp_fn = ((function (delta,snake){
return (function (fp,k){
var vec__91407 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(fp,(k - (1)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-1),cljs.core.PersistentVector.EMPTY], null));
var dk_1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91407,(0),null);
var vk_1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91407,(1),null);
var dk_1__$1 = (dk_1 + (1));
var vec__91410 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(fp,(k + (1)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(-1),cljs.core.PersistentVector.EMPTY], null));
var dk_PLUS_1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91410,(0),null);
var vk_PLUS_1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91410,(1),null);
var x = (function (){var x__4219__auto__ = dk_1__$1;
var y__4220__auto__ = dk_PLUS_1;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var sk = snake(k,x);
var ops = (function (){var es = (((dk_1__$1 > dk_PLUS_1))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vk_1,new cljs.core.Keyword(null,"-","-",-2112348439)):cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vk_PLUS_1,new cljs.core.Keyword(null,"+","+",1913524883)));
if((sk > x)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(es,(sk - x));
} else {
return es;
}
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(fp,k,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sk,ops], null));
});})(delta,snake))
;
var fp = (function (){var p = (0);
var fp = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
var fp__$1 = (function (){var k = ((-1) * p);
var fp__$1 = fp;
while(true){
if((k < delta)){
var G__91504 = (k + (1));
var G__91505 = fp_fn(fp__$1,k);
k = G__91504;
fp__$1 = G__91505;
continue;
} else {
return fp__$1;
}
break;
}
})();
var fp__$2 = (function (){var k = (delta + p);
var fp__$2 = fp__$1;
while(true){
if((delta < k)){
var G__91506 = (k - (1));
var G__91507 = fp_fn(fp__$2,k);
k = G__91506;
fp__$2 = G__91507;
continue;
} else {
return fp__$2;
}
break;
}
})();
var fp__$3 = fp_fn(fp__$2,delta);
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,cljs.core.first(cljs.core.get.cljs$core$IFn$_invoke$arity$2(fp__$3,delta)))))){
var G__91508 = (p + (1));
var G__91509 = fp__$3;
p = G__91508;
fp = G__91509;
continue;
} else {
return cljs.core.persistent_BANG_(fp__$3);
}
break;
}
})();
return cljs.core.rest(cljs.core.second(cljs.core.get.cljs$core$IFn$_invoke$arity$2(fp,delta)));
});
editscript.diff.quick.swap_ops = (function editscript$diff$quick$swap_ops(edits){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (op){
var G__91429 = op;
var G__91429__$1 = (((G__91429 instanceof cljs.core.Keyword))?G__91429.fqn:null);
switch (G__91429__$1) {
case "+":
return new cljs.core.Keyword(null,"-","-",-2112348439);

break;
case "-":
return new cljs.core.Keyword(null,"+","+",1913524883);

break;
default:
return op;

}
}),edits));
});
/**
 * Aggressively turn :- and :+ into replacements.
 */
editscript.diff.quick.min_PLUS_plus__GT_replace = (function editscript$diff$quick$min_PLUS_plus__GT_replace(v){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(cljs.core.integer_QMARK_),cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (coll){
var m = cljs.core.first(coll);
if(((cljs.core.integer_QMARK_(m)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(coll))))){
return coll;
} else {
var p = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(m,new cljs.core.Keyword(null,"-","-",-2112348439)))?new cljs.core.Keyword(null,"+","+",1913524883):new cljs.core.Keyword(null,"-","-",-2112348439));
var vec__91431 = cljs.core.split_with(((function (p,m){
return (function (p1__91430_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__91430_SHARP_,m);
});})(p,m))
,coll);
var ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91431,(0),null);
var ps = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91431,(1),null);
var mc = cljs.core.count(ms);
var pc = cljs.core.count(ps);
var delta = (function (){var G__91434 = (mc - pc);
return Math.abs(G__91434);
})();
var rs = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((function (){var x__4219__auto__ = mc;
var y__4220__auto__ = pc;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})() - delta),new cljs.core.Keyword(null,"r","r",-471384190));
if((mc < pc)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(rs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(delta,p));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mc,pc)){
return rs;
} else {
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(delta,m),rs);

}
}
}
}))),v);
});
editscript.diff.quick.vec_edits = (function editscript$diff$quick$vec_edits(a,b){
var n = cljs.core.count(a);
var m = cljs.core.count(b);
return editscript.diff.quick.min_PLUS_plus__GT_replace((((n < m))?editscript.diff.quick.swap_ops(editscript.diff.quick.vec_edits_STAR_(b,a,m,n)):editscript.diff.quick.vec_edits_STAR_(a,b,n,m)));
});
/**
 * Adjust the indices to have a correct editscript
 */
editscript.diff.quick.diff_vec = (function editscript$diff$quick$diff_vec(script,path,a,b){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__91435,op){
var vec__91436 = p__91435;
var ia = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91436,(0),null);
var ia_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91436,(1),null);
var ib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__91436,(2),null);
var G__91439 = op;
var G__91439__$1 = (((G__91439 instanceof cljs.core.Keyword))?G__91439.fqn:null);
switch (G__91439__$1) {
case "-":
var G__91440_91512 = script;
var G__91441_91513 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,ia_SINGLEQUOTE_);
var G__91442_91514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,ia);
var G__91443_91515 = editscript.edit.nada();
(editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91440_91512,G__91441_91513,G__91442_91514,G__91443_91515) : editscript.diff.quick.diff_STAR_.call(null,G__91440_91512,G__91441_91513,G__91442_91514,G__91443_91515));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ia + (1)),ia_SINGLEQUOTE_,ib], null);

break;
case "+":
var G__91444_91516 = script;
var G__91445_91517 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,ia_SINGLEQUOTE_);
var G__91446_91518 = editscript.edit.nada();
var G__91447_91519 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,ib);
(editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91444_91516,G__91445_91517,G__91446_91518,G__91447_91519) : editscript.diff.quick.diff_STAR_.call(null,G__91444_91516,G__91445_91517,G__91446_91518,G__91447_91519));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [ia,(ia_SINGLEQUOTE_ + (1)),(ib + (1))], null);

break;
case "r":
var G__91448_91520 = script;
var G__91449_91521 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,ia_SINGLEQUOTE_);
var G__91450_91522 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(a,ia);
var G__91451_91523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b,ib);
(editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91448_91520,G__91449_91521,G__91450_91522,G__91451_91523) : editscript.diff.quick.diff_STAR_.call(null,G__91448_91520,G__91449_91521,G__91450_91522,G__91451_91523));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ia + (1)),(ia_SINGLEQUOTE_ + (1)),(ib + (1))], null);

break;
default:
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ia + op),(ia_SINGLEQUOTE_ + op),(ib + op)], null);

}
}),cljs.core.transient$(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0)], null)),editscript.diff.quick.vec_edits(a,b));
});
editscript.diff.quick.diff_set = (function editscript$diff$quick$diff_set(script,path,a,b){
var seq__91452_91524 = cljs.core.seq(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(a,b));
var chunk__91453_91525 = null;
var count__91454_91526 = (0);
var i__91455_91527 = (0);
while(true){
if((i__91455_91527 < count__91454_91526)){
var va_91528 = chunk__91453_91525.cljs$core$IIndexed$_nth$arity$2(null,i__91455_91527);
var G__91464_91529 = script;
var G__91465_91530 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,va_91528);
var G__91466_91531 = va_91528;
var G__91467_91532 = editscript.edit.nada();
(editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91464_91529,G__91465_91530,G__91466_91531,G__91467_91532) : editscript.diff.quick.diff_STAR_.call(null,G__91464_91529,G__91465_91530,G__91466_91531,G__91467_91532));


var G__91533 = seq__91452_91524;
var G__91534 = chunk__91453_91525;
var G__91535 = count__91454_91526;
var G__91536 = (i__91455_91527 + (1));
seq__91452_91524 = G__91533;
chunk__91453_91525 = G__91534;
count__91454_91526 = G__91535;
i__91455_91527 = G__91536;
continue;
} else {
var temp__5754__auto___91537 = cljs.core.seq(seq__91452_91524);
if(temp__5754__auto___91537){
var seq__91452_91538__$1 = temp__5754__auto___91537;
if(cljs.core.chunked_seq_QMARK_(seq__91452_91538__$1)){
var c__4550__auto___91539 = cljs.core.chunk_first(seq__91452_91538__$1);
var G__91540 = cljs.core.chunk_rest(seq__91452_91538__$1);
var G__91541 = c__4550__auto___91539;
var G__91542 = cljs.core.count(c__4550__auto___91539);
var G__91543 = (0);
seq__91452_91524 = G__91540;
chunk__91453_91525 = G__91541;
count__91454_91526 = G__91542;
i__91455_91527 = G__91543;
continue;
} else {
var va_91544 = cljs.core.first(seq__91452_91538__$1);
var G__91468_91545 = script;
var G__91469_91546 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,va_91544);
var G__91470_91547 = va_91544;
var G__91471_91548 = editscript.edit.nada();
(editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91468_91545,G__91469_91546,G__91470_91547,G__91471_91548) : editscript.diff.quick.diff_STAR_.call(null,G__91468_91545,G__91469_91546,G__91470_91547,G__91471_91548));


var G__91549 = cljs.core.next(seq__91452_91538__$1);
var G__91550 = null;
var G__91551 = (0);
var G__91552 = (0);
seq__91452_91524 = G__91549;
chunk__91453_91525 = G__91550;
count__91454_91526 = G__91551;
i__91455_91527 = G__91552;
continue;
}
} else {
}
}
break;
}

var seq__91472 = cljs.core.seq(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(b,a));
var chunk__91473 = null;
var count__91474 = (0);
var i__91475 = (0);
while(true){
if((i__91475 < count__91474)){
var vb = chunk__91473.cljs$core$IIndexed$_nth$arity$2(null,i__91475);
var G__91484_91553 = script;
var G__91485_91554 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,vb);
var G__91486_91555 = editscript.edit.nada();
var G__91487_91556 = vb;
(editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91484_91553,G__91485_91554,G__91486_91555,G__91487_91556) : editscript.diff.quick.diff_STAR_.call(null,G__91484_91553,G__91485_91554,G__91486_91555,G__91487_91556));


var G__91557 = seq__91472;
var G__91558 = chunk__91473;
var G__91559 = count__91474;
var G__91560 = (i__91475 + (1));
seq__91472 = G__91557;
chunk__91473 = G__91558;
count__91474 = G__91559;
i__91475 = G__91560;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__91472);
if(temp__5754__auto__){
var seq__91472__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__91472__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__91472__$1);
var G__91561 = cljs.core.chunk_rest(seq__91472__$1);
var G__91562 = c__4550__auto__;
var G__91563 = cljs.core.count(c__4550__auto__);
var G__91564 = (0);
seq__91472 = G__91561;
chunk__91473 = G__91562;
count__91474 = G__91563;
i__91475 = G__91564;
continue;
} else {
var vb = cljs.core.first(seq__91472__$1);
var G__91488_91565 = script;
var G__91489_91566 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,vb);
var G__91490_91567 = editscript.edit.nada();
var G__91491_91568 = vb;
(editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4 ? editscript.diff.quick.diff_STAR_.cljs$core$IFn$_invoke$arity$4(G__91488_91565,G__91489_91566,G__91490_91567,G__91491_91568) : editscript.diff.quick.diff_STAR_.call(null,G__91488_91565,G__91489_91566,G__91490_91567,G__91491_91568));


var G__91569 = cljs.core.next(seq__91472__$1);
var G__91570 = null;
var G__91571 = (0);
var G__91572 = (0);
seq__91472 = G__91569;
chunk__91473 = G__91570;
count__91474 = G__91571;
i__91475 = G__91572;
continue;
}
} else {
return null;
}
}
break;
}
});
editscript.diff.quick.diff_lst = (function editscript$diff$quick$diff_lst(script,path,a,b){
return editscript.diff.quick.diff_vec(script,path,cljs.core.vec(a),cljs.core.vec(b));
});
editscript.diff.quick.diff_STAR_ = (function editscript$diff$quick$diff_STAR_(script,path,a,b){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return null;
} else {
var G__91492 = editscript.edit.get_type(a);
var G__91492__$1 = (((G__91492 instanceof cljs.core.Keyword))?G__91492.fqn:null);
switch (G__91492__$1) {
case "nil":
return editscript.edit.add_data(script,path,b);

break;
case "map":
var G__91493 = editscript.edit.get_type(b);
var G__91493__$1 = (((G__91493 instanceof cljs.core.Keyword))?G__91493.fqn:null);
switch (G__91493__$1) {
case "nil":
return editscript.edit.delete_data(script,path);

break;
case "map":
var fexpr__91494 = new cljs.core.Var(function(){return editscript.diff.quick.diff_map;},new cljs.core.Symbol("editscript.diff.quick","diff-map","editscript.diff.quick/diff-map",1973051147,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,cljs.core.with_meta(new cljs.core.Symbol(null,"editscript.diff.quick","editscript.diff.quick",165700457,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-doc","no-doc",1559921891),true], null)),new cljs.core.Symbol(null,"diff-map","diff-map",-711364586,null),"editscript/diff/quick.cljc",16,1,22,22,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"script","script",336087726,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"b","b",-1172211299,null)], null)),null,(cljs.core.truth_(editscript.diff.quick.diff_map)?editscript.diff.quick.diff_map.cljs$lang$test:null)]));
return (fexpr__91494.cljs$core$IFn$_invoke$arity$4 ? fexpr__91494.cljs$core$IFn$_invoke$arity$4(script,path,a,b) : fexpr__91494.call(null,script,path,a,b));

break;
default:
return editscript.edit.replace_data(script,path,b);

}

break;
case "vec":
var G__91495 = editscript.edit.get_type(b);
var G__91495__$1 = (((G__91495 instanceof cljs.core.Keyword))?G__91495.fqn:null);
switch (G__91495__$1) {
case "nil":
return editscript.edit.delete_data(script,path);

break;
case "vec":
var fexpr__91496 = new cljs.core.Var(function(){return editscript.diff.quick.diff_vec;},new cljs.core.Symbol("editscript.diff.quick","diff-vec","editscript.diff.quick/diff-vec",-1781503036,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,cljs.core.with_meta(new cljs.core.Symbol(null,"editscript.diff.quick","editscript.diff.quick",165700457,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-doc","no-doc",1559921891),true], null)),new cljs.core.Symbol(null,"diff-vec","diff-vec",-170849589,null),"editscript/diff/quick.cljc",16,1,121,121,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"script","script",336087726,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"b","b",-1172211299,null)], null)),"Adjust the indices to have a correct editscript",(cljs.core.truth_(editscript.diff.quick.diff_vec)?editscript.diff.quick.diff_vec.cljs$lang$test:null)]));
return (fexpr__91496.cljs$core$IFn$_invoke$arity$4 ? fexpr__91496.cljs$core$IFn$_invoke$arity$4(script,path,a,b) : fexpr__91496.call(null,script,path,a,b));

break;
default:
return editscript.edit.replace_data(script,path,b);

}

break;
case "set":
var G__91497 = editscript.edit.get_type(b);
var G__91497__$1 = (((G__91497 instanceof cljs.core.Keyword))?G__91497.fqn:null);
switch (G__91497__$1) {
case "nil":
return editscript.edit.delete_data(script,path);

break;
case "set":
var fexpr__91498 = new cljs.core.Var(function(){return editscript.diff.quick.diff_set;},new cljs.core.Symbol("editscript.diff.quick","diff-set","editscript.diff.quick/diff-set",1246078730,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,cljs.core.with_meta(new cljs.core.Symbol(null,"editscript.diff.quick","editscript.diff.quick",165700457,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-doc","no-doc",1559921891),true], null)),new cljs.core.Symbol(null,"diff-set","diff-set",-364591609,null),"editscript/diff/quick.cljc",16,1,137,137,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"script","script",336087726,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"b","b",-1172211299,null)], null)),null,(cljs.core.truth_(editscript.diff.quick.diff_set)?editscript.diff.quick.diff_set.cljs$lang$test:null)]));
return (fexpr__91498.cljs$core$IFn$_invoke$arity$4 ? fexpr__91498.cljs$core$IFn$_invoke$arity$4(script,path,a,b) : fexpr__91498.call(null,script,path,a,b));

break;
default:
return editscript.edit.replace_data(script,path,b);

}

break;
case "lst":
var G__91499 = editscript.edit.get_type(b);
var G__91499__$1 = (((G__91499 instanceof cljs.core.Keyword))?G__91499.fqn:null);
switch (G__91499__$1) {
case "nil":
return editscript.edit.delete_data(script,path);

break;
case "lst":
var fexpr__91500 = new cljs.core.Var(function(){return editscript.diff.quick.diff_lst;},new cljs.core.Symbol("editscript.diff.quick","diff-lst","editscript.diff.quick/diff-lst",-1885319001,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,cljs.core.with_meta(new cljs.core.Symbol(null,"editscript.diff.quick","editscript.diff.quick",165700457,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"no-doc","no-doc",1559921891),true], null)),new cljs.core.Symbol(null,"diff-lst","diff-lst",799109538,null),"editscript/diff/quick.cljc",16,1,144,144,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"script","script",336087726,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"a","a",-482876059,null),new cljs.core.Symbol(null,"b","b",-1172211299,null)], null)),null,(cljs.core.truth_(editscript.diff.quick.diff_lst)?editscript.diff.quick.diff_lst.cljs$lang$test:null)]));
return (fexpr__91500.cljs$core$IFn$_invoke$arity$4 ? fexpr__91500.cljs$core$IFn$_invoke$arity$4(script,path,a,b) : fexpr__91500.call(null,script,path,a,b));

break;
default:
return editscript.edit.replace_data(script,path,b);

}

break;
case "val":
var G__91501 = editscript.edit.get_type(b);
var G__91501__$1 = (((G__91501 instanceof cljs.core.Keyword))?G__91501.fqn:null);
switch (G__91501__$1) {
case "nil":
return editscript.edit.delete_data(script,path);

break;
default:
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a,b)){
return null;
} else {
return editscript.edit.replace_data(script,path,b);
}

}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__91492__$1)].join('')));

}
}
});
/**
 * Create an EditScript that represents the difference between `b` and `a`
 *   This algorithm is fast, but it does not attempt to generate an EditScript
 *   that is minimal in size
 */
editscript.diff.quick.diff = (function editscript$diff$quick$diff(a,b){
var script = editscript.edit.edits__GT_script(cljs.core.PersistentVector.EMPTY);
editscript.diff.quick.diff_STAR_(script,cljs.core.PersistentVector.EMPTY,a,b);

return script;
});

//# sourceMappingURL=editscript.diff.quick.js.map
