goog.provide('clojure.core.rrb_vector.transients');
goog.require('cljs.core');
goog.require('clojure.core.rrb_vector.nodes');
goog.require('clojure.core.rrb_vector.trees');
clojure.core.rrb_vector.transients.ensure_editable = (function clojure$core$rrb_vector$transients$ensure_editable(edit,node){
if((node.edit === edit)){
return node;
} else {
var new_arr = cljs.core.aclone(node.arr);
if(((33) === new_arr.length)){
(new_arr[(32)] = cljs.core.aclone((new_arr[(32)])));
} else {
}

return (new cljs.core.VectorNode(edit,new_arr));
}
});
clojure.core.rrb_vector.transients.editable_root = (function clojure$core$rrb_vector$transients$editable_root(root){
var new_arr = cljs.core.aclone(root.arr);
if(((33) === new_arr.length)){
(new_arr[(32)] = cljs.core.aclone((new_arr[(32)])));
} else {
}

return (new cljs.core.VectorNode(({}),new_arr));
});
clojure.core.rrb_vector.transients.editable_tail = (function clojure$core$rrb_vector$transients$editable_tail(tail){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tail,(0),ret,(0),tail.length);

return ret;
});
clojure.core.rrb_vector.transients.push_tail_BANG_ = (function clojure$core$rrb_vector$transients$push_tail_BANG_(shift,cnt,root_edit,current_node,tail_node){
var ret = clojure.core.rrb_vector.transients.ensure_editable(root_edit,current_node);
if(clojure.core.rrb_vector.nodes.regular_QMARK_(ret)){
var n_81077 = ret;
var shift_81078__$1 = shift;
while(true){
var arr_81079 = n_81077.arr;
var subidx_81080 = (((cnt - (1)) >> shift_81078__$1) & (31));
if((shift_81078__$1 === (5))){
(arr_81079[subidx_81080] = tail_node);
} else {
var child_81081 = (arr_81079[subidx_81080]);
if((child_81081 == null)){
(arr_81079[subidx_81080] = clojure.core.rrb_vector.trees.new_path(tail_node.arr,root_edit,(shift_81078__$1 - (5)),tail_node));
} else {
var editable_child_81082 = clojure.core.rrb_vector.transients.ensure_editable(root_edit,child_81081);
(arr_81079[subidx_81080] = editable_child_81082);

var G__81083 = editable_child_81082;
var G__81084 = (shift_81078__$1 - (5));
n_81077 = G__81083;
shift_81078__$1 = G__81084;
continue;
}
}
break;
}

return ret;
} else {
var arr = ret.arr;
var rngs = clojure.core.rrb_vector.nodes.node_ranges(ret);
var li = ((rngs[(32)]) - (1));
var cret = (((shift === (5)))?null:(function (){var child = clojure.core.rrb_vector.transients.ensure_editable(root_edit,(arr[li]));
var ccnt = ((((li > (0)))?((rngs[li]) - (rngs[(li - (1))])):(rngs[(0)])) + (32));
if((!(clojure.core.rrb_vector.nodes.overflow_QMARK_(child,(shift - (5)),ccnt)))){
var G__81049 = (shift - (5));
var G__81050 = ccnt;
var G__81051 = root_edit;
var G__81052 = child;
var G__81053 = tail_node;
return (clojure.core.rrb_vector.transients.push_tail_BANG_.cljs$core$IFn$_invoke$arity$5 ? clojure.core.rrb_vector.transients.push_tail_BANG_.cljs$core$IFn$_invoke$arity$5(G__81049,G__81050,G__81051,G__81052,G__81053) : clojure.core.rrb_vector.transients.push_tail_BANG_.call(null,G__81049,G__81050,G__81051,G__81052,G__81053));
} else {
return null;
}
})());
if(cljs.core.truth_(cret)){
(arr[li] = cret);

(rngs[li] = ((rngs[li]) + (32)));

return ret;
} else {
if((li >= (31))){
var msg_81085 = ["Assigning index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((li + (1)))," of vector"," object array to become a node, when that"," index should only be used for storing"," range arrays."].join('');
var data_81086 = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"shift","shift",997140064),shift,new cljs.core.Keyword(null,"cnd","cnd",-521882032),cnt,new cljs.core.Keyword(null,"current-node","current-node",-814308842),current_node,new cljs.core.Keyword(null,"tail-node","tail-node",-1373693221),tail_node,new cljs.core.Keyword(null,"rngs","rngs",-8039697),rngs,new cljs.core.Keyword(null,"li","li",723558921),li,new cljs.core.Keyword(null,"cret","cret",2090504467),cret], null);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg_81085,data_81086);
} else {
}

(arr[(li + (1))] = clojure.core.rrb_vector.trees.new_path(tail_node.arr,root_edit,(shift - (5)),tail_node));

(rngs[(li + (1))] = ((rngs[li]) + (32)));

(rngs[(32)] = ((rngs[(32)]) + (1)));

return ret;
}
}
});
clojure.core.rrb_vector.transients.pop_tail_BANG_ = (function clojure$core$rrb_vector$transients$pop_tail_BANG_(shift,cnt,root_edit,current_node){
var ret = clojure.core.rrb_vector.transients.ensure_editable(root_edit,current_node);
if(clojure.core.rrb_vector.nodes.regular_QMARK_(ret)){
var subidx = (((cnt - (2)) >> shift) & (31));
if((shift > (5))){
var child = (function (){var G__81056 = (shift - (5));
var G__81057 = cnt;
var G__81058 = root_edit;
var G__81059 = (ret.arr[subidx]);
return (clojure.core.rrb_vector.transients.pop_tail_BANG_.cljs$core$IFn$_invoke$arity$4 ? clojure.core.rrb_vector.transients.pop_tail_BANG_.cljs$core$IFn$_invoke$arity$4(G__81056,G__81057,G__81058,G__81059) : clojure.core.rrb_vector.transients.pop_tail_BANG_.call(null,G__81056,G__81057,G__81058,G__81059));
})();
if((((child == null)) && ((subidx === (0))))){
return null;
} else {
var arr = ret.arr;
(arr[subidx] = child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var arr = ret.arr;
(arr[subidx] = null);

return ret;

}
}
} else {
var rngs = clojure.core.rrb_vector.nodes.node_ranges(ret);
var subidx = ((rngs[(32)]) - (1));
if((shift > (5))){
var child = (ret.arr[subidx]);
var child_cnt = (((subidx === (0)))?(rngs[(0)]):((rngs[subidx]) - (rngs[(subidx - (1))])));
var new_child = (function (){var G__81060 = (shift - (5));
var G__81061 = child_cnt;
var G__81062 = root_edit;
var G__81063 = child;
return (clojure.core.rrb_vector.transients.pop_tail_BANG_.cljs$core$IFn$_invoke$arity$4 ? clojure.core.rrb_vector.transients.pop_tail_BANG_.cljs$core$IFn$_invoke$arity$4(G__81060,G__81061,G__81062,G__81063) : clojure.core.rrb_vector.transients.pop_tail_BANG_.call(null,G__81060,G__81061,G__81062,G__81063));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
if(clojure.core.rrb_vector.nodes.regular_QMARK_(child)){
var arr = ret.arr;
(rngs[subidx] = ((rngs[subidx]) - (32)));

(arr[subidx] = new_child);

if((new_child == null)){
(rngs[(32)] = ((rngs[(32)]) - (1)));
} else {
}

return ret;
} else {
var rng = clojure.core.rrb_vector.nodes.last_range(child);
var diff = (rng - (cljs.core.truth_(new_child)?clojure.core.rrb_vector.nodes.last_range(new_child):(0)));
var arr = ret.arr;
(rngs[subidx] = ((rngs[subidx]) - diff));

(arr[subidx] = new_child);

if((new_child == null)){
(rngs[(32)] = ((rngs[(32)]) - (1)));
} else {
}

return ret;

}
}
} else {
if((subidx === (0))){
return null;
} else {
var arr = ret.arr;
var child = (arr[subidx]);
(arr[subidx] = null);

(rngs[subidx] = (0));

(rngs[(32)] = ((rngs[(32)]) - (1)));

return ret;

}
}
}
});
clojure.core.rrb_vector.transients.do_assoc_BANG_ = (function clojure$core$rrb_vector$transients$do_assoc_BANG_(shift,root_edit,current_node,i,val){
var ret = clojure.core.rrb_vector.transients.ensure_editable(root_edit,current_node);
if(clojure.core.rrb_vector.nodes.regular_QMARK_(ret)){
var shift_81104__$1 = shift;
var node_81105 = ret;
while(true){
if((shift_81104__$1 === (0))){
var arr_81106 = node_81105.arr;
(arr_81106[(i & (31))] = val);
} else {
var arr_81107 = node_81105.arr;
var subidx_81108 = ((i >> shift_81104__$1) & (31));
var child_81109 = clojure.core.rrb_vector.transients.ensure_editable(root_edit,(arr_81107[subidx_81108]));
(arr_81107[subidx_81108] = child_81109);

var G__81110 = (shift_81104__$1 - (5));
var G__81111 = child_81109;
shift_81104__$1 = G__81110;
node_81105 = G__81111;
continue;
}
break;
}
} else {
var arr_81112 = ret.arr;
var rngs_81113 = clojure.core.rrb_vector.nodes.node_ranges(ret);
var subidx_81114 = ((i >> shift) & (31));
var subidx_81116__$1 = (function (){var subidx__$1 = subidx_81114;
while(true){
if((i < ((rngs_81113[subidx__$1]) | (0)))){
return subidx__$1;
} else {
var G__81120 = (subidx__$1 + (1));
subidx__$1 = G__81120;
continue;
}
break;
}
})();
var i_81117__$1 = (((subidx_81116__$1 === (0)))?i:(i - (rngs_81113[(subidx_81116__$1 - (1))])));
(arr_81112[subidx_81116__$1] = (function (){var G__81072 = (shift - (5));
var G__81073 = root_edit;
var G__81074 = (arr_81112[subidx_81116__$1]);
var G__81075 = i_81117__$1;
var G__81076 = val;
return (clojure.core.rrb_vector.transients.do_assoc_BANG_.cljs$core$IFn$_invoke$arity$5 ? clojure.core.rrb_vector.transients.do_assoc_BANG_.cljs$core$IFn$_invoke$arity$5(G__81072,G__81073,G__81074,G__81075,G__81076) : clojure.core.rrb_vector.transients.do_assoc_BANG_.call(null,G__81072,G__81073,G__81074,G__81075,G__81076));
})());
}

return ret;
});

//# sourceMappingURL=clojure.core.rrb_vector.transients.js.map
