goog.provide('clojure.core.matrix.impl.persistent_vector');
goog.require('cljs.core');
goog.require('clojure.core.matrix.protocols');
goog.require('clojure.core.matrix.implementations');
goog.require('clojure.core.matrix.impl.common');
goog.require('clojure.core.matrix.impl.mathsops');
/**
 * Ensures a vector is fully coerced to nested persistent vectors
 */
clojure.core.matrix.impl.persistent_vector.coerce_nested = (function clojure$core$matrix$impl$persistent_vector$coerce_nested(v){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.impl.persistent_vector.persistent_vector_coerce,v);
});
/**
 * Maps a function over a persistent vector, only modifying the vector if the function
 * returns a different value
 */
clojure.core.matrix.impl.persistent_vector.mapv_identity_check = (function clojure$core$matrix$impl$persistent_vector$mapv_identity_check(f,v){
var n = cljs.core.count(v);
var i = (0);
var v__$1 = v;
while(true){
if((i < n)){
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v__$1,i);
var y = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x));
var G__61461 = (i + (1));
var G__61462 = (((x === y))?v__$1:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v__$1,i,y));
i = G__61461;
v__$1 = G__61462;
continue;
} else {
return v__$1;
}
break;
}
});
clojure.core.matrix.impl.persistent_vector.check_vector_shape = (function clojure$core$matrix$impl$persistent_vector$check_vector_shape(v,shape){
var and__4120__auto__ = (v instanceof cljs.core.PersistentVector);
if(and__4120__auto__){
var and__4120__auto____$1 = (cljs.core.count(v) === cljs.core.long$(cljs.core.first(shape)));
if(and__4120__auto____$1){
var temp__5816__auto__ = cljs.core.next(shape);
if(temp__5816__auto__){
var ns = temp__5816__auto__;
return cljs.core.every_QMARK_(((function (ns,temp__5816__auto__,and__4120__auto____$1,and__4120__auto__){
return (function (p1__61273_SHARP_){
return (clojure.core.matrix.impl.persistent_vector.check_vector_shape.cljs$core$IFn$_invoke$arity$2 ? clojure.core.matrix.impl.persistent_vector.check_vector_shape.cljs$core$IFn$_invoke$arity$2(p1__61273_SHARP_,ns) : clojure.core.matrix.impl.persistent_vector.check_vector_shape.call(null,p1__61273_SHARP_,ns));
});})(ns,temp__5816__auto__,and__4120__auto____$1,and__4120__auto__))
,v);
} else {
return cljs.core.every_QMARK_(((function (temp__5816__auto__,and__4120__auto____$1,and__4120__auto__){
return (function (p1__61274_SHARP_){
return (!((p1__61274_SHARP_ instanceof cljs.core.PersistentVector)));
});})(temp__5816__auto__,and__4120__auto____$1,and__4120__auto__))
,v);
}
} else {
return and__4120__auto____$1;
}
} else {
return and__4120__auto__;
}
});
/**
 * Test if array is already in nested persistent vector array format.
 */
clojure.core.matrix.impl.persistent_vector.is_nested_persistent_vectors_QMARK_ = (function clojure$core$matrix$impl$persistent_vector$is_nested_persistent_vectors_QMARK_(x){
if(typeof x === 'number'){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.is_scalar_QMARK_(x))){
return true;
} else {
if((!((x instanceof cljs.core.PersistentVector)))){
return false;
} else {
return ((cljs.core.every_QMARK_(clojure.core.matrix.impl.persistent_vector.is_nested_persistent_vectors_QMARK_,x)) && (clojure.core.matrix.impl.persistent_vector.check_vector_shape(x,clojure.core.matrix.protocols.get_shape(x))));

}
}
}
});
/**
 * Coerces to nested persistent vectors
 */
clojure.core.matrix.impl.persistent_vector.persistent_vector_coerce = (function clojure$core$matrix$impl$persistent_vector$persistent_vector_coerce(x){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(x));
if((dims > (0))){
return clojure.core.matrix.protocols.convert_to_nested_vectors(x);
} else {
if((((dims === (0))) && (cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(x))))){
return clojure.core.matrix.protocols.get_0d(x);
} else {
if((x == null)){
return x;
} else {
if((x instanceof cljs.core.IIterable)){
return clojure.core.matrix.impl.persistent_vector.coerce_nested(x);
} else {
if(cljs.core.sequential_QMARK_(x)){
return clojure.core.matrix.impl.persistent_vector.coerce_nested(x);
} else {
return x;

}
}
}
}
}
});
/**
 * Calculates the dimensionality (== nesting depth) of nested persistent vectors
 */
clojure.core.matrix.impl.persistent_vector.vector_dimensionality = (function clojure$core$matrix$impl$persistent_vector$vector_dimensionality(m){
if(cljs.core.vector_QMARK_(m)){
if((cljs.core.count(m) > (0))){
return ((1) + (function (){var G__61292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,(0));
return (clojure.core.matrix.impl.persistent_vector.vector_dimensionality.cljs$core$IFn$_invoke$arity$1 ? clojure.core.matrix.impl.persistent_vector.vector_dimensionality.cljs$core$IFn$_invoke$arity$1(G__61292) : clojure.core.matrix.impl.persistent_vector.vector_dimensionality.call(null,G__61292));
})());
} else {
return (1);
}
} else {
return cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));

}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImplementation$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (m){
var m__$1 = this;
return new cljs.core.Keyword(null,"persistent-vector","persistent-vector",2032618025);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (m){
var m__$1 = this;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Implementation for nested Clojure persistent vectors\n             used as matrices"], null);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (m,length){
var m__$1 = this;
return cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(length,0.0));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (m,rows,columns){
var m__$1 = this;
return cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(rows,clojure.core.matrix.protocols.new_vector(m__$1,columns)));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (m,dims){
var m__$1 = this;
var temp__5816__auto__ = cljs.core.seq(dims);
if(temp__5816__auto__){
var dims__$1 = temp__5816__auto__;
return cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.first(dims__$1),clojure.core.matrix.protocols.new_matrix_nd(m__$1,cljs.core.next(dims__$1))));
} else {
return 0.0;
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (m,data){
var m__$1 = this;
return clojure.core.matrix.impl.persistent_vector.persistent_vector_coerce(data);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (m,dims){
var m__$1 = this;
return true;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PBroadcast$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PBroadcast$broadcast$arity$2 = (function (m,target_shape){
var m__$1 = this;
var mshape = clojure.core.matrix.protocols.get_shape(m__$1);
var dims = cljs.core.long$(cljs.core.count(mshape));
var tdims = cljs.core.long$(cljs.core.count(target_shape));
if((dims > tdims)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't broadcast to a lower dimensional shape",cljs.core.PersistentArrayMap.EMPTY);
} else {
if((!(cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._EQ__EQ_,mshape,cljs.core.take_last(dims,target_shape)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Incompatible shapes, cannot broadcast shape ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec(mshape))," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec(target_shape))].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (mshape,dims,tdims,m__$1){
return (function (m__$2,dup){
return cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(dup,m__$2));
});})(mshape,dims,tdims,m__$1))
,m__$1,cljs.core.reverse(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(dims,target_shape)));

}
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PBroadcastLike$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PBroadcastLike$broadcast_like$arity$2 = (function (m,a){
var m__$1 = this;
return clojure.core.matrix.protocols.broadcast(a,clojure.core.matrix.protocols.get_shape(m__$1));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PBroadcastCoerce$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PBroadcastCoerce$broadcast_coerce$arity$2 = (function (m,a){
var m__$1 = this;
return clojure.core.matrix.protocols.broadcast(clojure.core.matrix.impl.persistent_vector.persistent_vector_coerce(a),clojure.core.matrix.protocols.get_shape(m__$1));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m,x){
var m__$1 = this;
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(x | (0)));
var x__53433__auto__ = r;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m,x,y){
var m__$1 = this;
var row = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(x | (0)));
return clojure.core.matrix.protocols.get_1d(row,y);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m,indexes){
var m__$1 = this;
var temp__5816__auto__ = cljs.core.seq(indexes);
if(temp__5816__auto__){
var indexes__$1 = temp__5816__auto__;
var temp__5816__auto____$1 = cljs.core.next(indexes__$1);
if(temp__5816__auto____$1){
var next_indexes = temp__5816__auto____$1;
var m__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(cljs.core.first(indexes__$1) | (0)));
return clojure.core.matrix.protocols.get_nd(m__$2,next_indexes);
} else {
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(cljs.core.first(indexes__$1) | (0)));
}
} else {
return m__$1;
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedSetting$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_1d$arity$3 = (function (m,row,v){
var m__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,row,v);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_2d$arity$4 = (function (m,row,column,v){
var m__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,row,clojure.core.matrix.protocols.set_1d((m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(row) : m__$1.call(null,row)),column,v));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedSetting$set_nd$arity$3 = (function (m,indexes,v){
var m__$1 = this;
var temp__5816__auto__ = cljs.core.seq(indexes);
if(temp__5816__auto__){
var indexes__$1 = temp__5816__auto__;
var fi = cljs.core.first(indexes__$1);
if(((1) === cljs.core.count(indexes__$1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,fi,v);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,fi,clojure.core.matrix.protocols.set_nd((m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(fi) : m__$1.call(null,fi)),cljs.core.next(indexes__$1),v));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Trying to set on a persistent vector with insufficient indexes?",cljs.core.PersistentArrayMap.EMPTY);
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexedSetting$is_mutable_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return false;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixSlices$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixSlices$get_row$arity$2 = (function (m,i){
var m__$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.long$(i));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixSlices$get_column$arity$2 = (function (m,i){
var m__$1 = this;
return clojure.core.matrix.protocols.get_slice(m__$1,(1),i);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixSlices$get_major_slice$arity$2 = (function (m,i){
var m__$1 = this;
var sl = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.long$(i));
return sl;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixSlices$get_slice$arity$3 = (function (m,dimension,i){
var m__$1 = this;
var dimension__$1 = cljs.core.long$(dimension);
if((dimension__$1 === (0))){
return clojure.core.matrix.protocols.get_major_slice(m__$1,i);
} else {
var sd = (dimension__$1 - (1));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (sd,dimension__$1,m__$1){
return (function (p1__61328_SHARP_){
return clojure.core.matrix.protocols.get_slice(p1__61328_SHARP_,sd,i);
});})(sd,dimension__$1,m__$1))
,m__$1);
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixRows$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixRows$get_rows$arity$1 = (function (m){
var m__$1 = this;
return m__$1;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixColumns$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixColumns$get_columns$arity$1 = (function (m){
var m__$1 = this;
return cljs.core.vec((function (){var iter__4523__auto__ = ((function (m__$1){
return (function clojure$core$matrix$impl$persistent_vector$iter__61337(s__61338){
return (new cljs.core.LazySeq(null,((function (m__$1){
return (function (){
var s__61338__$1 = s__61338;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__61338__$1);
if(temp__5818__auto__){
var s__61338__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__61338__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__61338__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__61340 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__61339 = (0);
while(true){
if((i__61339 < size__4522__auto__)){
var j = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__61339);
cljs.core.chunk_append(b__61340,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (i__61339,j,c__4521__auto__,size__4522__auto__,b__61340,s__61338__$2,temp__5818__auto__,m__$1){
return (function (p1__61336_SHARP_){
return clojure.core.matrix.protocols.get_1d(p1__61336_SHARP_,j);
});})(i__61339,j,c__4521__auto__,size__4522__auto__,b__61340,s__61338__$2,temp__5818__auto__,m__$1))
,m__$1));

var G__61494 = (i__61339 + (1));
i__61339 = G__61494;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__61340),clojure$core$matrix$impl$persistent_vector$iter__61337(cljs.core.chunk_rest(s__61338__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__61340),null);
}
} else {
var j = cljs.core.first(s__61338__$2);
return cljs.core.cons(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (j,s__61338__$2,temp__5818__auto__,m__$1){
return (function (p1__61336_SHARP_){
return clojure.core.matrix.protocols.get_1d(p1__61336_SHARP_,j);
});})(j,s__61338__$2,temp__5818__auto__,m__$1))
,m__$1),clojure$core$matrix$impl$persistent_vector$iter__61337(cljs.core.rest(s__61338__$2)));
}
} else {
return null;
}
break;
}
});})(m__$1))
,null,null));
});})(m__$1))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(m__$1,(1))));
})());
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSliceView$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSliceView$get_major_slice_view$arity$2 = (function (m,i){
var m__$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,i);
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSliceView2$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSliceView2$get_slice_view$arity$3 = (function (m,dimension,i){
var m__$1 = this;
return clojure.core.matrix.protocols.get_slice(m__$1,dimension,i);
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSliceSeq$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSliceSeq$get_major_slice_seq$arity$1 = (function (m){
var m__$1 = this;
return m__$1;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSliceJoin$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSliceJoin$join$arity$2 = (function (m,a){
var m__$1 = this;
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m__$1));
var adims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a));
if((dims === adims)){
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_major_slice_seq(m__$1),clojure.core.matrix.protocols.get_major_slice_seq(a)));
} else {
if((dims === (adims + (1)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(m__$1,a);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Joining with array of incompatible size",cljs.core.PersistentArrayMap.EMPTY);

}
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PRotate$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PRotate$rotate$arity$3 = (function (m,dim,places){
var m__$1 = this;
var dim__$1 = cljs.core.long$(dim);
var places__$1 = cljs.core.long$(places);
if(((0) === dim__$1)){
var c = cljs.core.long$(cljs.core.count(m__$1));
var sh = cljs.core.long$((((c > (0)))?cljs.core.mod(places__$1,c):(0)));
if((sh === (0))){
return m__$1;
} else {
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(m__$1,sh,c),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(m__$1,(0),sh)));
}
} else {
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (dim__$1,places__$1,m__$1){
return (function (s){
return clojure.core.matrix.protocols.rotate(s,(dim__$1 - (1)),places__$1);
});})(dim__$1,places__$1,m__$1))
,m__$1);
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PTransposeDims$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PTransposeDims$transpose_dims$arity$2 = (function (m,ordering){
var m__$1 = this;
var temp__5816__auto__ = cljs.core.seq(ordering);
if(temp__5816__auto__){
var ordering__$1 = temp__5816__auto__;
var dim = cljs.core.long$(cljs.core.first(ordering__$1));
var next_ordering = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (dim,ordering__$1,temp__5816__auto__,m__$1){
return (function (i){
if((i < dim)){
return i;
} else {
return (i - (1));
}
});})(dim,ordering__$1,temp__5816__auto__,m__$1))
,cljs.core.next(ordering__$1));
var slice_range = cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(m__$1,dim));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (dim,next_ordering,slice_range,ordering__$1,temp__5816__auto__,m__$1){
return (function (si){
return clojure.core.matrix.protocols.transpose_dims(clojure.core.matrix.protocols.get_slice(m__$1,dim,si),next_ordering);
});})(dim,next_ordering,slice_range,ordering__$1,temp__5816__auto__,m__$1))
,slice_range);
} else {
return m__$1;
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$POrder$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$POrder$order$arity$2 = (function (m,indices){
var m__$1 = this;
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m__$1){
return (function (p1__61347_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,p1__61347_SHARP_);
});})(m__$1))
,clojure.core.matrix.protocols.element_seq(indices));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$POrder$order$arity$3 = (function (m,dimension,indices){
var m__$1 = this;
var dimension__$1 = cljs.core.long$(dimension);
if((dimension__$1 === (0))){
return clojure.core.matrix.protocols.order.cljs$core$IFn$_invoke$arity$2(m__$1,indices);
} else {
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (dimension__$1,m__$1){
return (function (p1__61348_SHARP_){
return clojure.core.matrix.protocols.order.cljs$core$IFn$_invoke$arity$3(p1__61348_SHARP_,(dimension__$1 - (1)),indices);
});})(dimension__$1,m__$1))
,m__$1);
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSubVector$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSubVector$subvector$arity$3 = (function (m,start,length){
var m__$1 = this;
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(m__$1,start,(cljs.core.long$(start) + cljs.core.long$(length)));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PValidateShape$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PValidateShape$validate_shape$arity$1 = (function (m){
var m__$1 = this;
if(clojure.core.matrix.protocols.same_shapes_QMARK_(m__$1)){
return clojure.core.matrix.protocols.get_shape(m__$1);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Inconsistent shape for persistent vector array.",cljs.core.PersistentArrayMap.EMPTY);
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PValidateShape$validate_shape$arity$2 = (function (m,shape){
var m__$1 = this;
if(cljs.core.empty_QMARK_(shape)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Expected empty shape for persistent vector: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m__$1)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

if(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core._EQ_,cljs.core.next(shape),cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.validate_shape,m__$1)))){
return shape;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Inconsistent shape for persistent vector array, expected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shape)," on array ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m__$1)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixAdd$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixAdd$matrix_add$arity$2 = (function (m,a){
var m__$1 = this;
var vec__61349 = clojure.core.matrix.protocols.broadcast_compatible(m__$1,a);
var m__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61349,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61349,(1),null);
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,m__$2,clojure.core.matrix.impl.persistent_vector.persistent_vector_coerce(a__$1));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixAdd$matrix_sub$arity$2 = (function (m,a){
var m__$1 = this;
var vec__61352 = clojure.core.matrix.protocols.broadcast_compatible(m__$1,a);
var m__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61352,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61352,(1),null);
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$3(cljs.core._,m__$2,clojure.core.matrix.impl.persistent_vector.persistent_vector_coerce(a__$1));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorOps$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorOps$vector_dot$arity$2 = (function (a,b){
var a__$1 = this;
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b));
if((((dims === (1))) && (((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b)))))){
var n = cljs.core.long$(cljs.core.count(a__$1));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(n,cljs.core.long$(cljs.core.long$(clojure.core.matrix.protocols.dimension_count(b,(0)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Mismatched vector sizes",cljs.core.PersistentArrayMap.EMPTY);
} else {
if((b instanceof cljs.core.List)){
var b__$1 = b;
var i = (0);
var res = 0.0;
while(true){
if((i >= n)){
return res;
} else {
var G__61515 = (i + (1));
var G__61516 = (res + (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a__$1,(i | (0))) * b__$1.get((i | (0)))));
i = G__61515;
res = G__61516;
continue;
}
break;
}
} else {
if((Array === b.constructor)){
var i = (0);
var res = 0.0;
while(true){
if((i >= n)){
return res;
} else {
var G__61517 = (i + (1));
var G__61518 = (res + (cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a__$1,(i | (0))) * cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b,i)));
i = G__61517;
res = G__61518;
continue;
}
break;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,a__$1,clojure.core.matrix.protocols.element_seq(b)));

}
}
}
} else {
return clojure.core.matrix.protocols.inner_product(a__$1,b);

}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorOps$length$arity$1 = (function (a){
var a__$1 = this;
if(typeof cljs.core.first(a__$1) === 'number'){
var n = cljs.core.long$(cljs.core.count(a__$1));
var i = (0);
var res = 0.0;
while(true){
if((i < n)){
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a__$1,i);
var G__61519 = (i + (1));
var G__61520 = (res + (x * x));
i = G__61519;
res = G__61520;
continue;
} else {
return Math.sqrt(res);
}
break;
}
} else {
var G__61356 = clojure.core.matrix.protocols.length_squared(a__$1);
return Math.sqrt(G__61356);
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorOps$length_squared$arity$1 = (function (a){
var a__$1 = this;
if(typeof cljs.core.first(a__$1) === 'number'){
var n = cljs.core.long$(cljs.core.count(a__$1));
var i = (0);
var res = 0.0;
while(true){
if((i < n)){
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a__$1,i);
var G__61522 = (i + (1));
var G__61523 = (res + (x * x));
i = G__61522;
res = G__61523;
continue;
} else {
return res;
}
break;
}
} else {
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$3(a__$1,((function (a__$1){
return (function (r,x){
return (r + (x * x));
});})(a__$1))
,0.0);
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorOps$normalise$arity$1 = (function (a){
var a__$1 = this;
return clojure.core.matrix.protocols.scale(a__$1,(1.0 / (function (){var G__61357 = clojure.core.matrix.protocols.length_squared(a__$1);
return Math.sqrt(G__61357);
})()));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMutableMatrixConstruction$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMutableMatrixConstruction$mutable_matrix$arity$1 = (function (m){
var m__$1 = this;
return null;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImmutableMatrixConstruction$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PImmutableMatrixConstruction$immutable_matrix$arity$1 = (function (m){
var m__$1 = this;
return m__$1;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorDistance$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorDistance$distance$arity$2 = (function (a,b){
var a__$1 = this;
return clojure.core.matrix.protocols.length(clojure.core.matrix.protocols.matrix_sub(b,a__$1));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSummable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSummable$element_sum$arity$1 = (function (a){
var a__$1 = this;
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$2(a__$1,cljs.core._PLUS_);
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PCoercion$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PCoercion$coerce_param$arity$2 = (function (m,param){
var m__$1 = this;
return clojure.core.matrix.impl.persistent_vector.persistent_vector_coerce(param);
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixEquality$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixEquality$matrix_equals$arity$2 = (function (a,b){
var a__$1 = this;
var bdims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b));
var acount = cljs.core.long$(cljs.core.count(a__$1));
if((bdims <= (0))){
return false;
} else {
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(acount,clojure.core.matrix.protocols.dimension_count(b,(0)))){
return false;
} else {
if(((1) === bdims)){
var and__4120__auto__ = ((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a__$1)));
if(and__4120__auto__){
var i = (0);
while(true){
if((i < acount)){
if(cljs.core.truth_(clojure.core.matrix.protocols.matrix_equals(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a__$1,i),clojure.core.matrix.protocols.get_1d(b,i)))){
var G__61528 = (i + (1));
i = G__61528;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return and__4120__auto__;
}
} else {
if(cljs.core.vector_QMARK_(b)){
var n = acount;
var i = (0);
while(true){
if((i < n)){
if(cljs.core.truth_(clojure.core.matrix.protocols.matrix_equals(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a__$1,i),(b.cljs$core$IFn$_invoke$arity$1 ? b.cljs$core$IFn$_invoke$arity$1(i) : b.call(null,i))))){
var G__61529 = (i + (1));
i = G__61529;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
var sa = cljs.core.seq(a__$1);
var sb = clojure.core.matrix.protocols.get_major_slice_seq(b);
while(true){
if(sa){
if(cljs.core.truth_(clojure.core.matrix.protocols.matrix_equals(cljs.core.first(sa),cljs.core.first(sb)))){
var G__61530 = cljs.core.next(sa);
var G__61531 = cljs.core.next(sb);
sa = G__61530;
sb = G__61531;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}

}
}
}
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixMultiply$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixMultiply$element_multiply$arity$2 = (function (m,a){
var m__$1 = this;
if(typeof a === 'number'){
return clojure.core.matrix.protocols.scale(m__$1,a);
} else {
var vec__61363 = clojure.core.matrix.protocols.broadcast_compatible(m__$1,a);
var m__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61363,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61363,(1),null);
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m__$2,cljs.core._STAR_,a__$1);
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixMultiply$matrix_multiply$arity$2 = (function (m,a){
var m__$1 = this;
var mdims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m__$1));
var adims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a));
if((adims === (0))){
return clojure.core.matrix.protocols.scale(m__$1,a);
} else {
if((((mdims === (1))) && ((adims === (2))))){
return cljs.core.vec((function (){var iter__4523__auto__ = ((function (mdims,adims,m__$1){
return (function clojure$core$matrix$impl$persistent_vector$iter__61366(s__61367){
return (new cljs.core.LazySeq(null,((function (mdims,adims,m__$1){
return (function (){
var s__61367__$1 = s__61367;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__61367__$1);
if(temp__5818__auto__){
var s__61367__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__61367__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__61367__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__61369 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__61368 = (0);
while(true){
if((i__61368 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__61368);
cljs.core.chunk_append(b__61369,(function (){var r = clojure.core.matrix.protocols.get_column(a,i);
return clojure.core.matrix.protocols.vector_dot(m__$1,r);
})());

var G__61558 = (i__61368 + (1));
i__61368 = G__61558;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__61369),clojure$core$matrix$impl$persistent_vector$iter__61366(cljs.core.chunk_rest(s__61367__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__61369),null);
}
} else {
var i = cljs.core.first(s__61367__$2);
return cljs.core.cons((function (){var r = clojure.core.matrix.protocols.get_column(a,i);
return clojure.core.matrix.protocols.vector_dot(m__$1,r);
})(),clojure$core$matrix$impl$persistent_vector$iter__61366(cljs.core.rest(s__61367__$2)));
}
} else {
return null;
}
break;
}
});})(mdims,adims,m__$1))
,null,null));
});})(mdims,adims,m__$1))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(a,(1))));
})());
} else {
if((((mdims === (1))) && ((adims === (1))))){
return clojure.core.matrix.protocols.vector_dot(m__$1,a);
} else {
if((((mdims === (2))) && ((adims === (1))))){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (mdims,adims,m__$1){
return (function (p1__61362_SHARP_){
return clojure.core.matrix.protocols.vector_dot(p1__61362_SHARP_,a);
});})(mdims,adims,m__$1))
,m__$1);
} else {
if((((mdims === (2))) && ((adims === (2))))){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (mdims,adims,m__$1){
return (function (r){
return cljs.core.vec((function (){var iter__4523__auto__ = ((function (mdims,adims,m__$1){
return (function clojure$core$matrix$impl$persistent_vector$iter__61370(s__61371){
return (new cljs.core.LazySeq(null,((function (mdims,adims,m__$1){
return (function (){
var s__61371__$1 = s__61371;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__61371__$1);
if(temp__5818__auto__){
var s__61371__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__61371__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__61371__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__61373 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__61372 = (0);
while(true){
if((i__61372 < size__4522__auto__)){
var j = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__61372);
cljs.core.chunk_append(b__61373,clojure.core.matrix.protocols.vector_dot(r,clojure.core.matrix.protocols.get_column(a,j)));

var G__61565 = (i__61372 + (1));
i__61372 = G__61565;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__61373),clojure$core$matrix$impl$persistent_vector$iter__61370(cljs.core.chunk_rest(s__61371__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__61373),null);
}
} else {
var j = cljs.core.first(s__61371__$2);
return cljs.core.cons(clojure.core.matrix.protocols.vector_dot(r,clojure.core.matrix.protocols.get_column(a,j)),clojure$core$matrix$impl$persistent_vector$iter__61370(cljs.core.rest(s__61371__$2)));
}
} else {
return null;
}
break;
}
});})(mdims,adims,m__$1))
,null,null));
});})(mdims,adims,m__$1))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(a,(1))));
})());
});})(mdims,adims,m__$1))
,m__$1);
} else {
return clojure.core.matrix.protocols.inner_product(m__$1,a);

}
}
}
}
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixProducts$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixProducts$inner_product$arity$2 = (function (m,a){
var m__$1 = this;
var adims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a));
var mdims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m__$1));
if(((0) === adims)){
return clojure.core.matrix.protocols.scale(m__$1,clojure.core.matrix.protocols.get_0d(a));
} else {
if((!((cljs.core.long$(cljs.core.last(clojure.core.matrix.protocols.get_shape(m__$1))) === cljs.core.long$(cljs.core.first(clojure.core.matrix.protocols.get_shape(a))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Incompatible shapes for inner product: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.get_shape(m__$1))," and ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.get_shape(a))].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
if(((1) === mdims)){
if(((1) === adims)){
return clojure.core.matrix.protocols.element_sum(clojure.core.matrix.protocols.element_multiply(m__$1,a));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.matrix_add,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (adims,mdims,m__$1){
return (function (sl,x){
return clojure.core.matrix.protocols.scale(sl,x);
});})(adims,mdims,m__$1))
,clojure.core.matrix.protocols.get_major_slice_seq(a),clojure.core.matrix.protocols.get_major_slice_seq(m__$1)));
}
} else {
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (adims,mdims,m__$1){
return (function (p1__61376_SHARP_){
return clojure.core.matrix.protocols.inner_product(p1__61376_SHARP_,a);
});})(adims,mdims,m__$1))
,clojure.core.matrix.protocols.get_major_slice_seq(m__$1));

}
}
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixProducts$outer_product$arity$2 = (function (m,a){
var m__$1 = this;
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m__$1,((function (m__$1){
return (function (v){
return clojure.core.matrix.protocols.pre_scale(a,v);
});})(m__$1))
);
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorTransform$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorTransform$vector_transform$arity$2 = (function (m,a){
var m__$1 = this;
return clojure.core.matrix.protocols.matrix_multiply(m__$1,a);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PVectorTransform$vector_transform_BANG_$arity$2 = (function (m,a){
var m__$1 = this;
return clojure.core.matrix.protocols.assign_BANG_(a,clojure.core.matrix.protocols.matrix_multiply(m__$1,a));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixScaling$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixScaling$scale$arity$2 = (function (m,a){
var m__$1 = this;
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$2(((function (m__$1){
return (function (p1__61381_SHARP_){
return (p1__61381_SHARP_ * a);
});})(m__$1))
,m__$1);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMatrixScaling$pre_scale$arity$2 = (function (m,a){
var m__$1 = this;
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$2(((function (m__$1){
return (function (p1__61382_SHARP_){
return (a * p1__61382_SHARP_);
});})(m__$1))
,m__$1);
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSquare$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSquare$square$arity$1 = (function (m){
var m__$1 = this;
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,m__$1,m__$1);
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PRowOperations$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PRowOperations$swap_rows$arity$3 = (function (m,i,j){
var m__$1 = this;
var i__$1 = cljs.core.long$(i);
var j__$1 = cljs.core.long$(j);
if((i__$1 === j__$1)){
return m__$1;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,i__$1,(m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(j__$1) : m__$1.call(null,j__$1))),j__$1,(m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(i__$1) : m__$1.call(null,i__$1)));
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PRowOperations$multiply_row$arity$3 = (function (m,i,factor){
var m__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,i,clojure.core.matrix.protocols.scale((m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(i) : m__$1.call(null,i)),factor));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PRowOperations$add_row$arity$4 = (function (m,i,j,factor){
var m__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,i,clojure.core.matrix.protocols.matrix_add((m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(i) : m__$1.call(null,i)),clojure.core.matrix.protocols.matrix_multiply((m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(j) : m__$1.call(null,j)),factor)));
});
clojure.core.matrix.impl.persistent_vector.build_maths_function = (function clojure$core$matrix$impl$persistent_vector$build_maths_function(p__61384){
var vec__61385 = p__61384;
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61385,(0),null);
var func = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61385,(1),null);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,name,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,new cljs.core.Symbol(null,"m","m",-1021758608,null),null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("clojure.core.matrix.impl.common","mapmatrix","clojure.core.matrix.impl.common/mapmatrix",1588740294,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","fn","cljs.core/fn",-1065745098,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,new cljs.core.Symbol(null,"x__61383__auto__","x__61383__auto__",534492310,null),null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","double","cljs.core/double",-1119390159,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,func,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","double","cljs.core/double",-1119390159,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__61383__auto__","x__61383__auto__",534492310,null),null,(1),null))))),null,(1),null))))),null,(1),null))))),null,(1),null))], 0)))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,new cljs.core.Symbol(null,"m","m",-1021758608,null),null,(1),null))], 0)))),null,(1),null))], 0))));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (m){
var m__$1 = this;
if(((0) === cljs.core.count(m__$1))){
return (1);
} else {
return (cljs.core.long$(clojure.core.matrix.protocols.dimensionality(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(0)))) + (1));
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (m){
var m__$1 = this;
var pv__60478__auto__ = m__$1;
return ((((0) === cljs.core.count(pv__60478__auto__))) || (((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv__60478__auto__,(0)))))));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return false;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (m){
var m__$1 = this;
var c = cljs.core.count(m__$1);
return cljs.core.cons(c,(((c > (0)))?clojure.core.matrix.protocols.get_shape(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(0))):null));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (m,x){
var m__$1 = this;
var x__$1 = cljs.core.long$(x);
if((x__$1 === (0))){
return cljs.core.count(m__$1);
} else {
return clojure.core.matrix.protocols.dimension_count(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(0)),(x__$1 - (1)));
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PElementCount$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PElementCount$element_count$arity$1 = (function (m){
var m__$1 = this;
var c = cljs.core.long$(cljs.core.count(m__$1));
if((c === (0))){
return (0);
} else {
return (c * clojure.core.matrix.protocols.element_count(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(0))));
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PConversion$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PConversion$convert_to_nested_vectors$arity$1 = (function (m){
var m__$1 = this;
if(clojure.core.matrix.impl.persistent_vector.is_nested_persistent_vectors_QMARK_(m__$1)){
return m__$1;
} else {
var m__$2 = clojure.core.matrix.impl.persistent_vector.mapv_identity_check(clojure.core.matrix.protocols.convert_to_nested_vectors,m__$1);
var m_shapes = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_shape,m__$2);
if(cljs.core.every_QMARK_(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,cljs.core.first(m_shapes)),cljs.core.rest(m_shapes))){
return m__$2;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't convert to persistent vector array: inconsistent shape.",cljs.core.PersistentArrayMap.EMPTY);
}
}
});
/**
 * Copy an arbitrary array to a region of a double array.
 * Assumes size represents the element count of the array, must be greater than zero.
 */
clojure.core.matrix.impl.persistent_vector.copy_to_double_array_BANG_ = (function clojure$core$matrix$impl$persistent_vector$copy_to_double_array_BANG_(m,arr,off,size){
if(typeof m === 'number'){
if((size === (1))){
return (arr[off] = m);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid shape while copying to double array",cljs.core.PersistentArrayMap.EMPTY);
}
} else {
if(cljs.core.vector_QMARK_(m)){
var m__$1 = m;
var ct = cljs.core.count(m__$1);
var skip = cljs.core.quot(size,ct);
var n__4607__auto__ = ct;
var i = (0);
while(true){
if((i < n__4607__auto__)){
var slc_61631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,i);
var G__61390_61632 = slc_61631;
var G__61391_61633 = arr;
var G__61392_61634 = (off + (i * skip));
var G__61393_61635 = skip;
(clojure.core.matrix.impl.persistent_vector.copy_to_double_array_BANG_.cljs$core$IFn$_invoke$arity$4 ? clojure.core.matrix.impl.persistent_vector.copy_to_double_array_BANG_.cljs$core$IFn$_invoke$arity$4(G__61390_61632,G__61391_61633,G__61392_61634,G__61393_61635) : clojure.core.matrix.impl.persistent_vector.copy_to_double_array_BANG_.call(null,G__61390_61632,G__61391_61633,G__61392_61634,G__61393_61635));

var G__61636 = (i + (1));
i = G__61636;
continue;
} else {
return null;
}
break;
}
} else {
var vals__53374__auto__ = cljs.core.seq(clojure.core.matrix.protocols.element_seq(m));
var i = cljs.core.long$((0));
while(true){
if(vals__53374__auto__){
var v = cljs.core.first(vals__53374__auto__);
(arr[(off + i)] = v);

var G__61637 = cljs.core.next(vals__53374__auto__);
var G__61638 = (i + (1));
vals__53374__auto__ = G__61637;
i = G__61638;
continue;
} else {
return null;
}
break;
}

}
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDoubleArrayOutput$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDoubleArrayOutput$to_double_array$arity$1 = (function (m){
var m__$1 = this;
var size = cljs.core.long$(clojure.core.matrix.protocols.element_count(m__$1));
var arr = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(size);
var ct = cljs.core.count(m__$1);
if((size > (0))){
clojure.core.matrix.impl.persistent_vector.copy_to_double_array_BANG_(m__$1,arr,(0),size);
} else {
}

return arr;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PDoubleArrayOutput$as_double_array$arity$1 = (function (m){
var m__$1 = this;
return null;
});
clojure.core.matrix.impl.persistent_vector.copy_to_object_array = (function clojure$core$matrix$impl$persistent_vector$copy_to_object_array(m,arr,off,size){
var ct = cljs.core.count(m);
if((!(cljs.core.vector_QMARK_(m)))){
var vals__53374__auto___61651 = cljs.core.seq(clojure.core.matrix.protocols.element_seq(m));
var i_61652 = cljs.core.long$((0));
while(true){
if(vals__53374__auto___61651){
var v_61653 = cljs.core.first(vals__53374__auto___61651);
(arr[(off + i_61652)] = v_61653);

var G__61654 = cljs.core.next(vals__53374__auto___61651);
var G__61655 = (i_61652 + (1));
vals__53374__auto___61651 = G__61654;
i_61652 = G__61655;
continue;
} else {
}
break;
}
} else {
if((((size === ct)) && ((!(cljs.core.vector_QMARK_(cljs.core.nth.cljs$core$IFn$_invoke$arity$3(m,(0),null))))))){
var n__4607__auto___61661 = size;
var i_61663 = (0);
while(true){
if((i_61663 < n__4607__auto___61661)){
(arr[(off + i_61663)] = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,i_61663));

var G__61667 = (i_61663 + (1));
i_61663 = G__61667;
continue;
} else {
}
break;
}
} else {
var skip_61670 = cljs.core.quot(size,ct);
var n__4607__auto___61671 = ct;
var i_61673 = (0);
while(true){
if((i_61673 < n__4607__auto___61671)){
var G__61394_61676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,i_61673);
var G__61395_61677 = arr;
var G__61396_61678 = (off + (i_61673 * skip_61670));
var G__61397_61679 = skip_61670;
(clojure.core.matrix.impl.persistent_vector.copy_to_object_array.cljs$core$IFn$_invoke$arity$4 ? clojure.core.matrix.impl.persistent_vector.copy_to_object_array.cljs$core$IFn$_invoke$arity$4(G__61394_61676,G__61395_61677,G__61396_61678,G__61397_61679) : clojure.core.matrix.impl.persistent_vector.copy_to_object_array.call(null,G__61394_61676,G__61395_61677,G__61396_61678,G__61397_61679));

var G__61687 = (i_61673 + (1));
i_61673 = G__61687;
continue;
} else {
}
break;
}

}
}

return arr;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PObjectArrayOutput$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PObjectArrayOutput$to_object_array$arity$1 = (function (m){
var m__$1 = this;
var size = cljs.core.long$(clojure.core.matrix.protocols.element_count(m__$1));
var arr = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(size);
var ct = cljs.core.count(m__$1);
clojure.core.matrix.impl.persistent_vector.copy_to_object_array(m__$1,arr,(0),size);

return arr;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PObjectArrayOutput$as_object_array$arity$1 = (function (m){
var m__$1 = this;
return null;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m){
var m__$1 = this;
if(((0) === cljs.core.count(m__$1))){
return null;
} else {
if((cljs.core.long$(clojure.core.matrix.protocols.dimensionality(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(0)))) >= (1))){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(clojure.core.matrix.protocols.element_seq,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m__$1], 0));
} else {
return m__$1;

}
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_map$arity$2 = (function (m,f){
var m__$1 = this;
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$2(f,m__$1);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_map$arity$3 = (function (m,f,a){
var m__$1 = this;
var vec__61400 = clojure.core.matrix.protocols.broadcast_same_shape(m__$1,a);
var m__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61400,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61400,(1),null);
return clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$3(f,m__$2,a__$1);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_map$arity$4 = (function (m,f,a,more){
var m__$1 = this;
var arrays = cljs.core.cons(m__$1,cljs.core.cons(a,more));
var shapes = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_shape,arrays);
var sh = (function (){var or__4131__auto__ = clojure.core.matrix.protocols.common_shape(shapes);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Attempt to do element map with incompatible shapes: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_shape,arrays))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
})();
var arrays__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (arrays,shapes,sh,m__$1){
return (function (p1__61398_SHARP_){
return clojure.core.matrix.protocols.broadcast(p1__61398_SHARP_,sh);
});})(arrays,shapes,sh,m__$1))
,arrays);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.core.matrix.impl.common.mapmatrix,f,arrays__$1);
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_map_BANG_$arity$2 = (function (m,f){
var m__$1 = this;
var seq__61403_61693 = cljs.core.seq(m__$1);
var chunk__61404_61694 = null;
var count__61405_61695 = (0);
var i__61406_61696 = (0);
while(true){
if((i__61406_61696 < count__61405_61695)){
var s_61697 = chunk__61404_61694.cljs$core$IIndexed$_nth$arity$2(null,i__61406_61696);
clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(s_61697,f);


var G__61700 = seq__61403_61693;
var G__61701 = chunk__61404_61694;
var G__61702 = count__61405_61695;
var G__61703 = (i__61406_61696 + (1));
seq__61403_61693 = G__61700;
chunk__61404_61694 = G__61701;
count__61405_61695 = G__61702;
i__61406_61696 = G__61703;
continue;
} else {
var temp__5818__auto___61704 = cljs.core.seq(seq__61403_61693);
if(temp__5818__auto___61704){
var seq__61403_61705__$1 = temp__5818__auto___61704;
if(cljs.core.chunked_seq_QMARK_(seq__61403_61705__$1)){
var c__4550__auto___61707 = cljs.core.chunk_first(seq__61403_61705__$1);
var G__61709 = cljs.core.chunk_rest(seq__61403_61705__$1);
var G__61710 = c__4550__auto___61707;
var G__61711 = cljs.core.count(c__4550__auto___61707);
var G__61712 = (0);
seq__61403_61693 = G__61709;
chunk__61404_61694 = G__61710;
count__61405_61695 = G__61711;
i__61406_61696 = G__61712;
continue;
} else {
var s_61713 = cljs.core.first(seq__61403_61705__$1);
clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(s_61713,f);


var G__61715 = cljs.core.next(seq__61403_61705__$1);
var G__61716 = null;
var G__61717 = (0);
var G__61718 = (0);
seq__61403_61693 = G__61715;
chunk__61404_61694 = G__61716;
count__61405_61695 = G__61717;
i__61406_61696 = G__61718;
continue;
}
} else {
}
}
break;
}

return m__$1;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_map_BANG_$arity$3 = (function (m,f,a){
var m__$1 = this;
var n__4607__auto___61721 = cljs.core.count(m__$1);
var i_61722 = (0);
while(true){
if((i_61722 < n__4607__auto___61721)){
clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$3((m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(i_61722) : m__$1.call(null,i_61722)),f,clojure.core.matrix.protocols.get_major_slice(a,i_61722));

var G__61724 = (i_61722 + (1));
i_61722 = G__61724;
continue;
} else {
}
break;
}

return m__$1;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_map_BANG_$arity$4 = (function (m,f,a,more){
var m__$1 = this;
var n__4607__auto___61725 = cljs.core.count(m__$1);
var i_61726 = (0);
while(true){
if((i_61726 < n__4607__auto___61725)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$5(clojure.core.matrix.protocols.element_map_BANG_,(m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(i_61726) : m__$1.call(null,i_61726)),f,clojure.core.matrix.protocols.get_major_slice(a,i_61726),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i_61726,n__4607__auto___61725,m__$1){
return (function (p1__61399_SHARP_){
return clojure.core.matrix.protocols.get_major_slice(p1__61399_SHARP_,i_61726);
});})(i_61726,n__4607__auto___61725,m__$1))
,more));

var G__61727 = (i_61726 + (1));
i_61726 = G__61727;
continue;
} else {
}
break;
}

return m__$1;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_reduce$arity$2 = (function (m,f){
var m__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(f,clojure.core.matrix.protocols.element_seq(m__$1));
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_reduce$arity$3 = (function (m,f,init){
var m__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,init,clojure.core.matrix.protocols.element_seq(m__$1));
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMapIndexed$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMapIndexed$element_map_indexed$arity$2 = (function (ms,f){
var ms__$1 = this;
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(ms__$1));
if(((0) === dims)){
var G__61432 = cljs.core.PersistentVector.EMPTY;
var G__61433 = (function (){var x__53433__auto__ = ms__$1;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__61432,G__61433) : f.call(null,G__61432,G__61433));
} else {
if(((1) === dims)){
return cljs.core.vec((function (){var iter__4523__auto__ = ((function (dims,ms__$1){
return (function clojure$core$matrix$impl$persistent_vector$iter__61434(s__61435){
return (new cljs.core.LazySeq(null,((function (dims,ms__$1){
return (function (){
var s__61435__$1 = s__61435;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__61435__$1);
if(temp__5818__auto__){
var s__61435__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__61435__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__61435__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__61437 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__61436 = (0);
while(true){
if((i__61436 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__61436);
cljs.core.chunk_append(b__61437,(function (){var G__61438 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [i], null);
var G__61439 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ms__$1,i);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__61438,G__61439) : f.call(null,G__61438,G__61439));
})());

var G__61730 = (i__61436 + (1));
i__61436 = G__61730;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__61437),clojure$core$matrix$impl$persistent_vector$iter__61434(cljs.core.chunk_rest(s__61435__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__61437),null);
}
} else {
var i = cljs.core.first(s__61435__$2);
return cljs.core.cons((function (){var G__61440 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [i], null);
var G__61441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ms__$1,i);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__61440,G__61441) : f.call(null,G__61440,G__61441));
})(),clojure$core$matrix$impl$persistent_vector$iter__61434(cljs.core.rest(s__61435__$2)));
}
} else {
return null;
}
break;
}
});})(dims,ms__$1))
,null,null));
});})(dims,ms__$1))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ms__$1)));
})());
} else {
return cljs.core.vec((function (){var iter__4523__auto__ = ((function (dims,ms__$1){
return (function clojure$core$matrix$impl$persistent_vector$iter__61442(s__61443){
return (new cljs.core.LazySeq(null,((function (dims,ms__$1){
return (function (){
var s__61443__$1 = s__61443;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__61443__$1);
if(temp__5818__auto__){
var s__61443__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__61443__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__61443__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__61445 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__61444 = (0);
while(true){
if((i__61444 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__61444);
cljs.core.chunk_append(b__61445,clojure.core.matrix.protocols.element_map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ms__$1,i),((function (i__61444,i,c__4521__auto__,size__4522__auto__,b__61445,s__61443__$2,temp__5818__auto__,dims,ms__$1){
return (function (p1__61412_SHARP_,p2__61413_SHARP_){
var G__61446 = cljs.core.cons(i,p1__61412_SHARP_);
var G__61447 = p2__61413_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__61446,G__61447) : f.call(null,G__61446,G__61447));
});})(i__61444,i,c__4521__auto__,size__4522__auto__,b__61445,s__61443__$2,temp__5818__auto__,dims,ms__$1))
));

var G__61731 = (i__61444 + (1));
i__61444 = G__61731;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__61445),clojure$core$matrix$impl$persistent_vector$iter__61442(cljs.core.chunk_rest(s__61443__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__61445),null);
}
} else {
var i = cljs.core.first(s__61443__$2);
return cljs.core.cons(clojure.core.matrix.protocols.element_map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ms__$1,i),((function (i,s__61443__$2,temp__5818__auto__,dims,ms__$1){
return (function (p1__61412_SHARP_,p2__61413_SHARP_){
var G__61448 = cljs.core.cons(i,p1__61412_SHARP_);
var G__61449 = p2__61413_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__61448,G__61449) : f.call(null,G__61448,G__61449));
});})(i,s__61443__$2,temp__5818__auto__,dims,ms__$1))
),clojure$core$matrix$impl$persistent_vector$iter__61442(cljs.core.rest(s__61443__$2)));
}
} else {
return null;
}
break;
}
});})(dims,ms__$1))
,null,null));
});})(dims,ms__$1))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ms__$1)));
})());

}
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMapIndexed$element_map_indexed$arity$3 = (function (ms,f,as){
var ms__$1 = this;
var as__$1 = clojure.core.matrix.protocols.broadcast_like(ms__$1,as);
var dima = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(as__$1));
if(cljs.core.truth_(clojure.core.matrix.protocols.is_vector_QMARK_(ms__$1))){
if((dima > (1))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("mapping with array of higher dimensionality?",cljs.core.PersistentArrayMap.EMPTY);
} else {
}

if(((((1) === dima)) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.dimension_count(ms__$1,(0)),clojure.core.matrix.protocols.dimension_count(as__$1,(0)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Incompatible vector sizes",cljs.core.PersistentArrayMap.EMPTY);
} else {
}

if(((0) === dima)){
var v = (function (){var x__53433__auto__ = as__$1;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})();
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (v,as__$1,dima,ms__$1){
return (function (p1__61414_SHARP_,p2__61415_SHARP_){
var G__61450 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__61414_SHARP_], null);
var G__61451 = p2__61415_SHARP_;
var G__61452 = v;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__61450,G__61451,G__61452) : f.call(null,G__61450,G__61451,G__61452));
});})(v,as__$1,dima,ms__$1))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ms__$1)));

return ms__$1;
} else {
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(((function (as__$1,dima,ms__$1){
return (function() { 
var G__61741__delegate = function (p1__61416_SHARP_,rest__61417_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__61416_SHARP_], null),rest__61417_SHARP_);
};
var G__61741 = function (p1__61416_SHARP_,var_args){
var rest__61417_SHARP_ = null;
if (arguments.length > 1) {
var G__61742__i = 0, G__61742__a = new Array(arguments.length -  1);
while (G__61742__i < G__61742__a.length) {G__61742__a[G__61742__i] = arguments[G__61742__i + 1]; ++G__61742__i;}
  rest__61417_SHARP_ = new cljs.core.IndexedSeq(G__61742__a,0,null);
} 
return G__61741__delegate.call(this,p1__61416_SHARP_,rest__61417_SHARP_);};
G__61741.cljs$lang$maxFixedArity = 1;
G__61741.cljs$lang$applyTo = (function (arglist__61743){
var p1__61416_SHARP_ = cljs.core.first(arglist__61743);
var rest__61417_SHARP_ = cljs.core.rest(arglist__61743);
return G__61741__delegate(p1__61416_SHARP_,rest__61417_SHARP_);
});
G__61741.cljs$core$IFn$_invoke$arity$variadic = G__61741__delegate;
return G__61741;
})()
;})(as__$1,dima,ms__$1))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ms__$1)),ms__$1,clojure.core.matrix.protocols.element_seq(as__$1));
}
} else {
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(((function (as__$1,dima,ms__$1){
return (function (i,m,a){
return clojure.core.matrix.protocols.element_map_indexed.cljs$core$IFn$_invoke$arity$3(m,((function (as__$1,dima,ms__$1){
return (function() { 
var G__61744__delegate = function (p1__61418_SHARP_,rest__61419_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cons(i,p1__61418_SHARP_),rest__61419_SHARP_);
};
var G__61744 = function (p1__61418_SHARP_,var_args){
var rest__61419_SHARP_ = null;
if (arguments.length > 1) {
var G__61745__i = 0, G__61745__a = new Array(arguments.length -  1);
while (G__61745__i < G__61745__a.length) {G__61745__a[G__61745__i] = arguments[G__61745__i + 1]; ++G__61745__i;}
  rest__61419_SHARP_ = new cljs.core.IndexedSeq(G__61745__a,0,null);
} 
return G__61744__delegate.call(this,p1__61418_SHARP_,rest__61419_SHARP_);};
G__61744.cljs$lang$maxFixedArity = 1;
G__61744.cljs$lang$applyTo = (function (arglist__61746){
var p1__61418_SHARP_ = cljs.core.first(arglist__61746);
var rest__61419_SHARP_ = cljs.core.rest(arglist__61746);
return G__61744__delegate(p1__61418_SHARP_,rest__61419_SHARP_);
});
G__61744.cljs$core$IFn$_invoke$arity$variadic = G__61744__delegate;
return G__61744;
})()
;})(as__$1,dima,ms__$1))
,a);
});})(as__$1,dima,ms__$1))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ms__$1)),ms__$1,clojure.core.matrix.protocols.get_major_slice_seq(as__$1));
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMapIndexed$element_map_indexed$arity$4 = (function (ms,f,as,more){
var ms__$1 = this;
if(cljs.core.truth_(clojure.core.matrix.protocols.is_vector_QMARK_(ms__$1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.mapv,((function (ms__$1){
return (function() { 
var G__61747__delegate = function (p1__61420_SHARP_,rest__61421_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__61420_SHARP_], null),rest__61421_SHARP_);
};
var G__61747 = function (p1__61420_SHARP_,var_args){
var rest__61421_SHARP_ = null;
if (arguments.length > 1) {
var G__61748__i = 0, G__61748__a = new Array(arguments.length -  1);
while (G__61748__i < G__61748__a.length) {G__61748__a[G__61748__i] = arguments[G__61748__i + 1]; ++G__61748__i;}
  rest__61421_SHARP_ = new cljs.core.IndexedSeq(G__61748__a,0,null);
} 
return G__61747__delegate.call(this,p1__61420_SHARP_,rest__61421_SHARP_);};
G__61747.cljs$lang$maxFixedArity = 1;
G__61747.cljs$lang$applyTo = (function (arglist__61749){
var p1__61420_SHARP_ = cljs.core.first(arglist__61749);
var rest__61421_SHARP_ = cljs.core.rest(arglist__61749);
return G__61747__delegate(p1__61420_SHARP_,rest__61421_SHARP_);
});
G__61747.cljs$core$IFn$_invoke$arity$variadic = G__61747__delegate;
return G__61747;
})()
;})(ms__$1))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ms__$1)),ms__$1,as,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.mapv,((function (ms__$1){
return (function() { 
var G__61750__delegate = function (i,m,a,mr){
return clojure.core.matrix.protocols.element_map_indexed.cljs$core$IFn$_invoke$arity$4(m,((function (ms__$1){
return (function() { 
var G__61751__delegate = function (p1__61422_SHARP_,rest__61423_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cons(i,p1__61422_SHARP_),rest__61423_SHARP_);
};
var G__61751 = function (p1__61422_SHARP_,var_args){
var rest__61423_SHARP_ = null;
if (arguments.length > 1) {
var G__61752__i = 0, G__61752__a = new Array(arguments.length -  1);
while (G__61752__i < G__61752__a.length) {G__61752__a[G__61752__i] = arguments[G__61752__i + 1]; ++G__61752__i;}
  rest__61423_SHARP_ = new cljs.core.IndexedSeq(G__61752__a,0,null);
} 
return G__61751__delegate.call(this,p1__61422_SHARP_,rest__61423_SHARP_);};
G__61751.cljs$lang$maxFixedArity = 1;
G__61751.cljs$lang$applyTo = (function (arglist__61753){
var p1__61422_SHARP_ = cljs.core.first(arglist__61753);
var rest__61423_SHARP_ = cljs.core.rest(arglist__61753);
return G__61751__delegate(p1__61422_SHARP_,rest__61423_SHARP_);
});
G__61751.cljs$core$IFn$_invoke$arity$variadic = G__61751__delegate;
return G__61751;
})()
;})(ms__$1))
,a,mr);
};
var G__61750 = function (i,m,a,var_args){
var mr = null;
if (arguments.length > 3) {
var G__61755__i = 0, G__61755__a = new Array(arguments.length -  3);
while (G__61755__i < G__61755__a.length) {G__61755__a[G__61755__i] = arguments[G__61755__i + 3]; ++G__61755__i;}
  mr = new cljs.core.IndexedSeq(G__61755__a,0,null);
} 
return G__61750__delegate.call(this,i,m,a,mr);};
G__61750.cljs$lang$maxFixedArity = 3;
G__61750.cljs$lang$applyTo = (function (arglist__61758){
var i = cljs.core.first(arglist__61758);
arglist__61758 = cljs.core.next(arglist__61758);
var m = cljs.core.first(arglist__61758);
arglist__61758 = cljs.core.next(arglist__61758);
var a = cljs.core.first(arglist__61758);
var mr = cljs.core.rest(arglist__61758);
return G__61750__delegate(i,m,a,mr);
});
G__61750.cljs$core$IFn$_invoke$arity$variadic = G__61750__delegate;
return G__61750;
})()
;})(ms__$1))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(ms__$1)),ms__$1,as,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0));
}
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMapIndexed$element_map_indexed_BANG_$arity$2 = (function (m,f){
var m__$1 = this;
var n__4607__auto___61760 = cljs.core.count(m__$1);
var i_61761 = (0);
while(true){
if((i_61761 < n__4607__auto___61760)){
clojure.core.matrix.protocols.element_map_indexed_BANG_.cljs$core$IFn$_invoke$arity$2((m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(i_61761) : m__$1.call(null,i_61761)),((function (i_61761,n__4607__auto___61760,m__$1){
return (function (p1__61424_SHARP_,p2__61425_SHARP_){
var G__61454 = cljs.core.cons(i_61761,p1__61424_SHARP_);
var G__61455 = p2__61425_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__61454,G__61455) : f.call(null,G__61454,G__61455));
});})(i_61761,n__4607__auto___61760,m__$1))
);

var G__61763 = (i_61761 + (1));
i_61761 = G__61763;
continue;
} else {
}
break;
}

return m__$1;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMapIndexed$element_map_indexed_BANG_$arity$3 = (function (m,f,a){
var m__$1 = this;
var n__4607__auto___61765 = cljs.core.count(m__$1);
var i_61766 = (0);
while(true){
if((i_61766 < n__4607__auto___61765)){
clojure.core.matrix.protocols.element_map_indexed_BANG_.cljs$core$IFn$_invoke$arity$3((m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(i_61766) : m__$1.call(null,i_61766)),((function (i_61766,n__4607__auto___61765,m__$1){
return (function() { 
var G__61767__delegate = function (p1__61426_SHARP_,rest__61427_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cons(i_61766,p1__61426_SHARP_),rest__61427_SHARP_);
};
var G__61767 = function (p1__61426_SHARP_,var_args){
var rest__61427_SHARP_ = null;
if (arguments.length > 1) {
var G__61770__i = 0, G__61770__a = new Array(arguments.length -  1);
while (G__61770__i < G__61770__a.length) {G__61770__a[G__61770__i] = arguments[G__61770__i + 1]; ++G__61770__i;}
  rest__61427_SHARP_ = new cljs.core.IndexedSeq(G__61770__a,0,null);
} 
return G__61767__delegate.call(this,p1__61426_SHARP_,rest__61427_SHARP_);};
G__61767.cljs$lang$maxFixedArity = 1;
G__61767.cljs$lang$applyTo = (function (arglist__61774){
var p1__61426_SHARP_ = cljs.core.first(arglist__61774);
var rest__61427_SHARP_ = cljs.core.rest(arglist__61774);
return G__61767__delegate(p1__61426_SHARP_,rest__61427_SHARP_);
});
G__61767.cljs$core$IFn$_invoke$arity$variadic = G__61767__delegate;
return G__61767;
})()
;})(i_61766,n__4607__auto___61765,m__$1))
,clojure.core.matrix.protocols.get_major_slice(a,i_61766));

var G__61775 = (i_61766 + (1));
i_61766 = G__61775;
continue;
} else {
}
break;
}

return m__$1;
});

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PMapIndexed$element_map_indexed_BANG_$arity$4 = (function (m,f,a,more){
var m__$1 = this;
var n__4607__auto___61777 = cljs.core.count(m__$1);
var i_61778 = (0);
while(true){
if((i_61778 < n__4607__auto___61777)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$5(clojure.core.matrix.protocols.element_map_indexed_BANG_,(m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(i_61778) : m__$1.call(null,i_61778)),((function (i_61778,n__4607__auto___61777,m__$1){
return (function() { 
var G__61780__delegate = function (p1__61428_SHARP_,rest__61429_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cons(i_61778,p1__61428_SHARP_),rest__61429_SHARP_);
};
var G__61780 = function (p1__61428_SHARP_,var_args){
var rest__61429_SHARP_ = null;
if (arguments.length > 1) {
var G__61781__i = 0, G__61781__a = new Array(arguments.length -  1);
while (G__61781__i < G__61781__a.length) {G__61781__a[G__61781__i] = arguments[G__61781__i + 1]; ++G__61781__i;}
  rest__61429_SHARP_ = new cljs.core.IndexedSeq(G__61781__a,0,null);
} 
return G__61780__delegate.call(this,p1__61428_SHARP_,rest__61429_SHARP_);};
G__61780.cljs$lang$maxFixedArity = 1;
G__61780.cljs$lang$applyTo = (function (arglist__61782){
var p1__61428_SHARP_ = cljs.core.first(arglist__61782);
var rest__61429_SHARP_ = cljs.core.rest(arglist__61782);
return G__61780__delegate(p1__61428_SHARP_,rest__61429_SHARP_);
});
G__61780.cljs$core$IFn$_invoke$arity$variadic = G__61780__delegate;
return G__61780;
})()
;})(i_61778,n__4607__auto___61777,m__$1))
,clojure.core.matrix.protocols.get_major_slice(a,i_61778),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i_61778,n__4607__auto___61777,m__$1){
return (function (p1__61430_SHARP_){
return clojure.core.matrix.protocols.get_major_slice(p1__61430_SHARP_,i_61778);
});})(i_61778,n__4607__auto___61777,m__$1))
,more));

var G__61787 = (i_61778 + (1));
i_61778 = G__61787;
continue;
} else {
}
break;
}

return m__$1;
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSelect$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PSelect$select$arity$2 = (function (a,args){
var a__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(args))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),clojure.core.matrix.protocols.dimensionality(a__$1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (a__$1){
return (function (p1__61456_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a__$1,p1__61456_SHARP_);
});})(a__$1))
,cljs.core.first(args)));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Array dimension does not match length of args",cljs.core.PersistentArrayMap.EMPTY);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (a__$1){
return (function (p1__61457_SHARP_){
return clojure.core.matrix.protocols.select(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a__$1,p1__61457_SHARP_),cljs.core.next(args));
});})(a__$1))
,cljs.core.first(args)));
}
});
cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexImplementation$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.clojure$core$matrix$protocols$PIndexImplementation$index_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return true;
});
clojure.core.matrix.implementations.register_implementation.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1)], null));

//# sourceMappingURL=clojure.core.matrix.impl.persistent_vector.js.map
