goog.provide('clojure.core.matrix.impl.double_array');
goog.require('cljs.core');
goog.require('clojure.core.matrix.protocols');
goog.require('clojure.core.matrix.implementations');
goog.require('clojure.core.matrix.impl.wrappers');
goog.require('clojure.core.matrix.impl.common');
goog.require('clojure.core.matrix.utils');
/**
 * Creates a new zero-filled nested double array of the given shape
 */
clojure.core.matrix.impl.double_array.new_double_array = (function clojure$core$matrix$impl$double_array$new_double_array(shape){
var dims = cljs.core.count(shape);
if(((0) === dims)){
return 0.0;
} else {
if(((1) === dims)){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((cljs.core.first(shape) | (0)));
} else {
var ns = cljs.core.next(shape);
var rn = cljs.core.long$(cljs.core.first(shape));
var r0 = (clojure.core.matrix.impl.double_array.new_double_array.cljs$core$IFn$_invoke$arity$1 ? clojure.core.matrix.impl.double_array.new_double_array.cljs$core$IFn$_invoke$arity$1(ns) : clojure.core.matrix.impl.double_array.new_double_array.call(null,ns));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cons(r0,(function (){var iter__4523__auto__ = ((function (ns,rn,r0,dims){
return (function clojure$core$matrix$impl$double_array$new_double_array_$_iter__62580(s__62581){
return (new cljs.core.LazySeq(null,((function (ns,rn,r0,dims){
return (function (){
var s__62581__$1 = s__62581;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__62581__$1);
if(temp__5818__auto__){
var s__62581__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__62581__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__62581__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__62583 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__62582 = (0);
while(true){
if((i__62582 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__62582);
cljs.core.chunk_append(b__62583,(clojure.core.matrix.impl.double_array.new_double_array.cljs$core$IFn$_invoke$arity$1 ? clojure.core.matrix.impl.double_array.new_double_array.cljs$core$IFn$_invoke$arity$1(ns) : clojure.core.matrix.impl.double_array.new_double_array.call(null,ns)));

var G__62909 = (i__62582 + (1));
i__62582 = G__62909;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__62583),clojure$core$matrix$impl$double_array$new_double_array_$_iter__62580(cljs.core.chunk_rest(s__62581__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__62583),null);
}
} else {
var i = cljs.core.first(s__62581__$2);
return cljs.core.cons((clojure.core.matrix.impl.double_array.new_double_array.cljs$core$IFn$_invoke$arity$1 ? clojure.core.matrix.impl.double_array.new_double_array.cljs$core$IFn$_invoke$arity$1(ns) : clojure.core.matrix.impl.double_array.new_double_array.call(null,ns)),clojure$core$matrix$impl$double_array$new_double_array_$_iter__62580(cljs.core.rest(s__62581__$2)));
}
} else {
return null;
}
break;
}
});})(ns,rn,r0,dims))
,null,null));
});})(ns,rn,r0,dims))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1((rn - (1))));
})()));

}
}
});
clojure.core.matrix.impl.double_array.construct_double_array = (function clojure$core$matrix$impl$double_array$construct_double_array(data){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(data));
if((dims === (1))){
var n = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(data,(0)));
var r = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(n);
var n__4607__auto___62910 = n;
var i_62911 = (0);
while(true){
if((i_62911 < n__4607__auto___62910)){
(r[i_62911] = clojure.core.matrix.protocols.get_1d(data,i_62911));

var G__62912 = (i_62911 + (1));
i_62911 = G__62912;
continue;
} else {
}
break;
}

return r;
} else {
if((dims === (0))){
return clojure.core.matrix.protocols.get_0d(data);
} else {
return null;

}
}
});
goog.object.set(clojure.core.matrix.protocols.PImmutableAssignment,"array",true);

var G__62586_62913 = clojure.core.matrix.protocols.assign;
var G__62587_62914 = "array";
var G__62588_62915 = ((function (G__62586_62913,G__62587_62914){
return (function (m,source){
return null;
});})(G__62586_62913,G__62587_62914))
;
goog.object.set(G__62586_62913,G__62587_62914,G__62588_62915);
goog.object.set(clojure.core.matrix.protocols.PAssignment,"array",true);

var G__62592_62916 = clojure.core.matrix.protocols.assign_BANG_;
var G__62593_62917 = "array";
var G__62594_62918 = ((function (G__62592_62916,G__62593_62917){
return (function (m,source){
var n__4607__auto___62924 = cljs.core.count(source);
var i_62925 = (0);
while(true){
if((i_62925 < n__4607__auto___62924)){
clojure.core.matrix.protocols.set_1d_BANG_(m,i_62925,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(source,i_62925));

var G__62932 = (i_62925 + (1));
i_62925 = G__62932;
continue;
} else {
}
break;
}

return m;
});})(G__62592_62916,G__62593_62917))
;
goog.object.set(G__62592_62916,G__62593_62917,G__62594_62918);

var G__62595_62933 = clojure.core.matrix.protocols.assign_array_BANG_;
var G__62596_62934 = "array";
var G__62597_62935 = ((function (G__62595_62933,G__62596_62934){
return (function (m,arr,start,length){
var length_62937__$1 = cljs.core.long$(length);
var start_62938__$1 = cljs.core.long$(start);
var n__4607__auto___62940 = length_62937__$1;
var i_62941 = (0);
while(true){
if((i_62941 < n__4607__auto___62940)){
clojure.core.matrix.protocols.set_1d_BANG_(m,i_62941,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arr,(start_62938__$1 + i_62941)));

var G__62943 = (i_62941 + (1));
i_62941 = G__62943;
continue;
} else {
}
break;
}

return m;
});})(G__62595_62933,G__62596_62934))
;
goog.object.set(G__62595_62933,G__62596_62934,G__62597_62935);
goog.object.set(clojure.core.matrix.protocols.PImplementation,"array",true);

var G__62598_62945 = clojure.core.matrix.protocols.implementation_key;
var G__62599_62946 = "array";
var G__62600_62947 = ((function (G__62598_62945,G__62599_62946){
return (function (m){
return new cljs.core.Keyword(null,"number-array","number-array",-676376237);
});})(G__62598_62945,G__62599_62946))
;
goog.object.set(G__62598_62945,G__62599_62946,G__62600_62947);

var G__62601_62949 = clojure.core.matrix.protocols.meta_info;
var G__62602_62950 = "array";
var G__62603_62951 = ((function (G__62601_62949,G__62602_62950){
return (function (m){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Clojure.core.matrix implementation for JS arrays"], null);
});})(G__62601_62949,G__62602_62950))
;
goog.object.set(G__62601_62949,G__62602_62950,G__62603_62951);

var G__62604_62953 = clojure.core.matrix.protocols.new_vector;
var G__62605_62954 = "array";
var G__62606_62955 = ((function (G__62604_62953,G__62605_62954){
return (function (m,length){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((length | (0)));
});})(G__62604_62953,G__62605_62954))
;
goog.object.set(G__62604_62953,G__62605_62954,G__62606_62955);

var G__62607_62956 = clojure.core.matrix.protocols.new_matrix;
var G__62608_62957 = "array";
var G__62609_62958 = ((function (G__62607_62956,G__62608_62957){
return (function (m,rows,columns){
return clojure.core.matrix.impl.double_array.new_double_array(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rows,columns], null));
});})(G__62607_62956,G__62608_62957))
;
goog.object.set(G__62607_62956,G__62608_62957,G__62609_62958);

var G__62610_62959 = clojure.core.matrix.protocols.new_matrix_nd;
var G__62611_62960 = "array";
var G__62612_62961 = ((function (G__62610_62959,G__62611_62960){
return (function (m,shape){
return clojure.core.matrix.impl.double_array.new_double_array(shape);
});})(G__62610_62959,G__62611_62960))
;
goog.object.set(G__62610_62959,G__62611_62960,G__62612_62961);

var G__62613_62962 = clojure.core.matrix.protocols.construct_matrix;
var G__62614_62963 = "array";
var G__62615_62964 = ((function (G__62613_62962,G__62614_62963){
return (function (m,data){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(data));
if((dims === (2))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Double arrays in cljs only support a single dimension currently - submit a patch!",cljs.core.PersistentArrayMap.EMPTY);
} else {
if((dims === (1))){
var n = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(data,(0)));
var arr = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(n);
var n__4607__auto___62968 = n;
var i_62969 = (0);
while(true){
if((i_62969 < n__4607__auto___62968)){
(arr[i_62969] = clojure.core.matrix.protocols.get_1d(data,i_62969));

var G__62970 = (i_62969 + (1));
i_62969 = G__62970;
continue;
} else {
}
break;
}

return arr;
} else {
if((dims === (0))){
return clojure.core.matrix.protocols.get_0d(data);
} else {
return null;

}
}
}
});})(G__62613_62962,G__62614_62963))
;
goog.object.set(G__62613_62962,G__62614_62963,G__62615_62964);

var G__62616_62973 = clojure.core.matrix.protocols.supports_dimensionality_QMARK_;
var G__62617_62974 = "array";
var G__62618_62975 = ((function (G__62616_62973,G__62617_62974){
return (function (m,dims){
var dims__$1 = cljs.core.long$(dims);
return (((dims__$1 === (1))) || ((dims__$1 === (2))));
});})(G__62616_62973,G__62617_62974))
;
goog.object.set(G__62616_62973,G__62617_62974,G__62618_62975);
goog.object.set(clojure.core.matrix.protocols.PDimensionInfo,"array",true);

var G__62620_62980 = clojure.core.matrix.protocols.dimensionality;
var G__62621_62981 = "array";
var G__62622_62982 = ((function (G__62620_62980,G__62621_62981){
return (function (m){
return (1);
});})(G__62620_62980,G__62621_62981))
;
goog.object.set(G__62620_62980,G__62621_62981,G__62622_62982);

var G__62624_62983 = clojure.core.matrix.protocols.is_vector_QMARK_;
var G__62625_62984 = "array";
var G__62626_62985 = ((function (G__62624_62983,G__62625_62984){
return (function (m){
return true;
});})(G__62624_62983,G__62625_62984))
;
goog.object.set(G__62624_62983,G__62625_62984,G__62626_62985);

var G__62627_62986 = clojure.core.matrix.protocols.is_scalar_QMARK_;
var G__62628_62987 = "array";
var G__62629_62988 = ((function (G__62627_62986,G__62628_62987){
return (function (m){
return false;
});})(G__62627_62986,G__62628_62987))
;
goog.object.set(G__62627_62986,G__62628_62987,G__62629_62988);

var G__62630_62990 = clojure.core.matrix.protocols.get_shape;
var G__62631_62991 = "array";
var G__62632_62992 = ((function (G__62630_62990,G__62631_62991){
return (function (m){
return (new cljs.core.List(null,cljs.core.count(m),null,(1),null));
});})(G__62630_62990,G__62631_62991))
;
goog.object.set(G__62630_62990,G__62631_62991,G__62632_62992);

var G__62633_62996 = clojure.core.matrix.protocols.dimension_count;
var G__62634_62997 = "array";
var G__62635_62998 = ((function (G__62633_62996,G__62634_62997){
return (function (m,x){
if((cljs.core.long$(x) === (0))){
return cljs.core.count(m);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Double array does not have dimension: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__62633_62996,G__62634_62997))
;
goog.object.set(G__62633_62996,G__62634_62997,G__62635_62998);
goog.object.set(clojure.core.matrix.protocols.PReshaping,"array",true);

var G__62637_63003 = clojure.core.matrix.protocols.reshape;
var G__62638_63004 = "array";
var G__62639_63005 = ((function (G__62637_63003,G__62638_63004){
return (function (m,shape){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_shape(m),shape)){
return m;
} else {
var gv = clojure.core.matrix.protocols.generic_value(m);
var es = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.element_seq(m),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(gv));
var partition_shape = ((function (gv,es,G__62637_63003,G__62638_63004){
return (function clojure$core$matrix$impl$double_array$partition_shape(es__$1,shape__$1){
var temp__5816__auto__ = cljs.core.seq(shape__$1);
if(temp__5816__auto__){
var s = temp__5816__auto__;
var ns = cljs.core.next(s);
var plen = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(1),ns);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ns,plen,s,temp__5816__auto__,gv,es,G__62637_63003,G__62638_63004){
return (function (p1__62636_SHARP_){
return clojure$core$matrix$impl$double_array$partition_shape(p1__62636_SHARP_,ns);
});})(ns,plen,s,temp__5816__auto__,gv,es,G__62637_63003,G__62638_63004))
,cljs.core.partition.cljs$core$IFn$_invoke$arity$2(plen,es__$1));
} else {
return cljs.core.first(es__$1);
}
});})(gv,es,G__62637_63003,G__62638_63004))
;
var temp__5816__auto__ = cljs.core.seq(shape);
if(temp__5816__auto__){
var shape__$1 = temp__5816__auto__;
var fs = cljs.core.long$(cljs.core.first(shape__$1));
var parts = partition_shape(es,shape__$1);
var or__4131__auto__ = clojure.core.matrix.protocols.construct_matrix(m,cljs.core.take.cljs$core$IFn$_invoke$arity$2(fs,parts));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return clojure.core.matrix.protocols.construct_matrix(cljs.core.PersistentVector.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(fs,parts));
}
} else {
return cljs.core.first(es);
}
}
});})(G__62637_63003,G__62638_63004))
;
goog.object.set(G__62637_63003,G__62638_63004,G__62639_63005);
goog.object.set(clojure.core.matrix.protocols.PTypeInfo,"array",true);

var G__62641_63019 = clojure.core.matrix.protocols.element_type;
var G__62642_63020 = "array";
var G__62643_63021 = ((function (G__62641_63019,G__62642_63020){
return (function (m){
return Number;
});})(G__62641_63019,G__62642_63020))
;
goog.object.set(G__62641_63019,G__62642_63020,G__62643_63021);
goog.object.set(clojure.core.matrix.protocols.PIndexedAccess,"array",true);

var G__62647_63024 = clojure.core.matrix.protocols.get_1d;
var G__62648_63025 = "array";
var G__62649_63026 = ((function (G__62647_63024,G__62648_63025){
return (function (m,x){
return (m[(x | (0))]);
});})(G__62647_63024,G__62648_63025))
;
goog.object.set(G__62647_63024,G__62648_63025,G__62649_63026);

var G__62651_63027 = clojure.core.matrix.protocols.get_2d;
var G__62652_63028 = "array";
var G__62653_63029 = ((function (G__62651_63027,G__62652_63028){
return (function (m,row,column){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do get-2D from 1D double array",cljs.core.PersistentArrayMap.EMPTY);
});})(G__62651_63027,G__62652_63028))
;
goog.object.set(G__62651_63027,G__62652_63028,G__62653_63029);

var G__62654_63030 = clojure.core.matrix.protocols.get_nd;
var G__62655_63031 = "array";
var G__62656_63032 = ((function (G__62654_63030,G__62655_63031){
return (function (m,indexes){
if(((1) === cljs.core.count(indexes))){
return (m[(cljs.core.first(indexes) | (0))]);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't get from double array with dimensionality: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(indexes))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__62654_63030,G__62655_63031))
;
goog.object.set(G__62654_63030,G__62655_63031,G__62656_63032);
goog.object.set(clojure.core.matrix.protocols.PIndexedSetting,"array",true);

var G__62658_63037 = clojure.core.matrix.protocols.set_1d;
var G__62659_63038 = "array";
var G__62660_63039 = ((function (G__62658_63037,G__62659_63038){
return (function (m,x,v){
var arr = m.slice();
(arr[(x | (0))] = v);

return arr;
});})(G__62658_63037,G__62659_63038))
;
goog.object.set(G__62658_63037,G__62659_63038,G__62660_63039);

var G__62662_63040 = clojure.core.matrix.protocols.set_2d;
var G__62663_63041 = "array";
var G__62664_63042 = ((function (G__62662_63040,G__62663_63041){
return (function (m,x,y,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 2D set on double array",cljs.core.PersistentArrayMap.EMPTY);
});})(G__62662_63040,G__62663_63041))
;
goog.object.set(G__62662_63040,G__62663_63041,G__62664_63042);

var G__62665_63043 = clojure.core.matrix.protocols.set_nd;
var G__62666_63044 = "array";
var G__62667_63045 = ((function (G__62665_63043,G__62666_63044){
return (function (m,indexes,v){
if(((1) === cljs.core.count(indexes))){
var arr = m.slice();
var x = (cljs.core.first(indexes) | (0));
(arr[(x | (0))] = v);

return arr;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't set on double array with dimensionality: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(indexes))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__62665_63043,G__62666_63044))
;
goog.object.set(G__62665_63043,G__62666_63044,G__62667_63045);

var G__62668_63050 = clojure.core.matrix.protocols.is_mutable_QMARK_;
var G__62669_63051 = "array";
var G__62670_63052 = ((function (G__62668_63050,G__62669_63051){
return (function (m){
return true;
});})(G__62668_63050,G__62669_63051))
;
goog.object.set(G__62668_63050,G__62669_63051,G__62670_63052);
goog.object.set(clojure.core.matrix.protocols.PIndexedSettingMutable,"array",true);

var G__62671_63055 = clojure.core.matrix.protocols.set_1d_BANG_;
var G__62672_63056 = "array";
var G__62673_63057 = ((function (G__62671_63055,G__62672_63056){
return (function (m,x,v){
(m[(x | (0))] = v);

return m;
});})(G__62671_63055,G__62672_63056))
;
goog.object.set(G__62671_63055,G__62672_63056,G__62673_63057);

var G__62674_63059 = clojure.core.matrix.protocols.set_2d_BANG_;
var G__62675_63060 = "array";
var G__62676_63061 = ((function (G__62674_63059,G__62675_63060){
return (function (m,x,y,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 2D set on double array",cljs.core.PersistentArrayMap.EMPTY);
});})(G__62674_63059,G__62675_63060))
;
goog.object.set(G__62674_63059,G__62675_63060,G__62676_63061);

var G__62677_63063 = clojure.core.matrix.protocols.set_nd_BANG_;
var G__62678_63064 = "array";
var G__62679_63065 = ((function (G__62677_63063,G__62678_63064){
return (function (m,indexes,v){
if(((1) === cljs.core.count(indexes))){
(m[(cljs.core.first(indexes) | (0))] = v);

return m;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't set on double array with dimensionality: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(indexes))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__62677_63063,G__62678_63064))
;
goog.object.set(G__62677_63063,G__62678_63064,G__62679_63065);
goog.object.set(clojure.core.matrix.protocols.PMutableMatrixConstruction,"array",true);

var G__62680_63070 = clojure.core.matrix.protocols.mutable_matrix;
var G__62681_63071 = "array";
var G__62682_63072 = ((function (G__62680_63070,G__62681_63071){
return (function (m){
return m.slice();
});})(G__62680_63070,G__62681_63071))
;
goog.object.set(G__62680_63070,G__62681_63071,G__62682_63072);
goog.object.set(clojure.core.matrix.protocols.PMatrixScaling,"array",true);

var G__62683_63074 = clojure.core.matrix.protocols.scale;
var G__62684_63075 = "array";
var G__62685_63076 = ((function (G__62683_63074,G__62684_63075){
return (function (m,a){
var m__$1 = m;
var len = m__$1.length;
var arr = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(len);
var a__$1 = a;
var n__4607__auto___63079 = len;
var i_63082 = (0);
while(true){
if((i_63082 < n__4607__auto___63079)){
(arr[i_63082] = (a__$1 * (m__$1[i_63082])));

var G__63083 = (i_63082 + (1));
i_63082 = G__63083;
continue;
} else {
}
break;
}

return arr;
});})(G__62683_63074,G__62684_63075))
;
goog.object.set(G__62683_63074,G__62684_63075,G__62685_63076);

var G__62686_63091 = clojure.core.matrix.protocols.pre_scale;
var G__62687_63092 = "array";
var G__62688_63093 = ((function (G__62686_63091,G__62687_63092){
return (function (m,a){
var m__$1 = m;
var len = m__$1.length;
var arr = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(len);
var a__$1 = a;
var n__4607__auto___63094 = len;
var i_63095 = (0);
while(true){
if((i_63095 < n__4607__auto___63094)){
(arr[i_63095] = (a__$1 * (m__$1[i_63095])));

var G__63097 = (i_63095 + (1));
i_63095 = G__63097;
continue;
} else {
}
break;
}

return arr;
});})(G__62686_63091,G__62687_63092))
;
goog.object.set(G__62686_63091,G__62687_63092,G__62688_63093);
goog.object.set(clojure.core.matrix.protocols.PMatrixMutableScaling,"array",true);

var G__62689_63098 = clojure.core.matrix.protocols.scale_BANG_;
var G__62690_63099 = "array";
var G__62691_63100 = ((function (G__62689_63098,G__62690_63099){
return (function (m,a){
var m__$1 = m;
var a__$1 = a;
var n__4607__auto__ = m__$1.length;
var i = (0);
while(true){
if((i < n__4607__auto__)){
(m__$1[i] = (a__$1 * (m__$1[i])));

var G__63112 = (i + (1));
i = G__63112;
continue;
} else {
return null;
}
break;
}
});})(G__62689_63098,G__62690_63099))
;
goog.object.set(G__62689_63098,G__62690_63099,G__62691_63100);

var G__62692_63113 = clojure.core.matrix.protocols.pre_scale_BANG_;
var G__62693_63114 = "array";
var G__62694_63115 = ((function (G__62692_63113,G__62693_63114){
return (function (m,a){
var m__$1 = m;
var a__$1 = a;
var n__4607__auto__ = m__$1.length;
var i = (0);
while(true){
if((i < n__4607__auto__)){
(m__$1[i] = (a__$1 * (m__$1[i])));

var G__63121 = (i + (1));
i = G__63121;
continue;
} else {
return null;
}
break;
}
});})(G__62692_63113,G__62693_63114))
;
goog.object.set(G__62692_63113,G__62693_63114,G__62694_63115);
goog.object.set(clojure.core.matrix.protocols.PConversion,"array",true);

var G__62695_63124 = clojure.core.matrix.protocols.convert_to_nested_vectors;
var G__62696_63125 = "array";
var G__62697_63126 = ((function (G__62695_63124,G__62696_63125){
return (function (m){
return cljs.core.vec(m);
});})(G__62695_63124,G__62696_63125))
;
goog.object.set(G__62695_63124,G__62696_63125,G__62697_63126);
goog.object.set(clojure.core.matrix.protocols.PFunctionalOperations,"array",true);

var G__62699_63131 = clojure.core.matrix.protocols.element_seq;
var G__62700_63132 = "array";
var G__62701_63133 = ((function (G__62699_63131,G__62700_63132){
return (function (m){
return m;
});})(G__62699_63131,G__62700_63132))
;
goog.object.set(G__62699_63131,G__62700_63132,G__62701_63133);

var G__62702_63137 = clojure.core.matrix.protocols.element_map;
var G__62703_63138 = "array";
var G__62704_63139 = ((function (G__62702_63137,G__62703_63138){
return (function() {
var G__63140 = null;
var G__63140__2 = (function (m,f){
var cnt = m.length;
var r = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(cnt);
var n__4607__auto___63144 = cnt;
var i_63146 = (0);
while(true){
if((i_63146 < n__4607__auto___63144)){
(r[i_63146] = (function (){var G__62705 = (m[i_63146]);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__62705) : f.call(null,G__62705));
})());

var G__63150 = (i_63146 + (1));
i_63146 = G__63150;
continue;
} else {
}
break;
}

return r;
});
var G__63140__3 = (function (m,f,a){
var r = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(m);
var a__$1 = clojure.core.matrix.protocols.broadcast_coerce(r,a);
var n__4607__auto___63151 = m.length;
var i_63152 = (0);
while(true){
if((i_63152 < n__4607__auto___63151)){
(r[i_63152] = (function (){var G__62706 = (m[i_63152]);
var G__62707 = (a__$1[i_63152]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__62706,G__62707) : f.call(null,G__62706,G__62707));
})());

var G__63156 = (i_63152 + (1));
i_63152 = G__63156;
continue;
} else {
}
break;
}

return r;
});
var G__63140__4 = (function (m,f,a,more){
var r = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(m);
var a__$1 = clojure.core.matrix.protocols.broadcast_coerce(m,a);
var more__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (r,a__$1,G__62702_63137,G__62703_63138){
return (function (p1__62698_SHARP_){
return clojure.core.matrix.protocols.broadcast_coerce(m,p1__62698_SHARP_);
});})(r,a__$1,G__62702_63137,G__62703_63138))
,more);
var more_count = cljs.core.long$(cljs.core.count(more__$1));
var vs = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(more_count);
var n__4607__auto___63165 = m.length;
var i_63167 = (0);
while(true){
if((i_63167 < n__4607__auto___63165)){
var n__4607__auto___63168__$1 = more_count;
var j_63169 = (0);
while(true){
if((j_63169 < n__4607__auto___63168__$1)){
(vs[j_63169] = ((more__$1.cljs$core$IFn$_invoke$arity$1 ? more__$1.cljs$core$IFn$_invoke$arity$1(j_63169) : more__$1.call(null,j_63169))[i_63167]));

var G__63172 = (j_63169 + (1));
j_63169 = G__63172;
continue;
} else {
}
break;
}

(r[i_63167] = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,(m[i_63167]),(a__$1[i_63167]),vs));

var G__63176 = (i_63167 + (1));
i_63167 = G__63176;
continue;
} else {
}
break;
}

return r;
});
G__63140 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__63140__2.call(this,m,f);
case 3:
return G__63140__3.call(this,m,f,a);
case 4:
return G__63140__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__63140.cljs$core$IFn$_invoke$arity$2 = G__63140__2;
G__63140.cljs$core$IFn$_invoke$arity$3 = G__63140__3;
G__63140.cljs$core$IFn$_invoke$arity$4 = G__63140__4;
return G__63140;
})()
;})(G__62702_63137,G__62703_63138))
;
goog.object.set(G__62702_63137,G__62703_63138,G__62704_63139);

var G__62708_63184 = clojure.core.matrix.protocols.element_map_BANG_;
var G__62709_63185 = "array";
var G__62710_63186 = ((function (G__62708_63184,G__62709_63185){
return (function() {
var G__63187 = null;
var G__63187__2 = (function (m,f){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,f));
});
var G__63187__3 = (function (m,f,a){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,f,a));
});
var G__63187__4 = (function (m,f,a,more){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$4(m,f,a,more));
});
G__63187 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__63187__2.call(this,m,f);
case 3:
return G__63187__3.call(this,m,f,a);
case 4:
return G__63187__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__63187.cljs$core$IFn$_invoke$arity$2 = G__63187__2;
G__63187.cljs$core$IFn$_invoke$arity$3 = G__63187__3;
G__63187.cljs$core$IFn$_invoke$arity$4 = G__63187__4;
return G__63187;
})()
;})(G__62708_63184,G__62709_63185))
;
goog.object.set(G__62708_63184,G__62709_63185,G__62710_63186);

var G__62711_63193 = clojure.core.matrix.protocols.element_reduce;
var G__62712_63194 = "array";
var G__62713_63195 = ((function (G__62711_63193,G__62712_63194){
return (function() {
var G__63196 = null;
var G__63196__2 = (function (m,f){
var m__$1 = m;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(f,m__$1);
});
var G__63196__3 = (function (m,f,init){
var m__$1 = m;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,init,m__$1);
});
G__63196 = function(m,f,init){
switch(arguments.length){
case 2:
return G__63196__2.call(this,m,f);
case 3:
return G__63196__3.call(this,m,f,init);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__63196.cljs$core$IFn$_invoke$arity$2 = G__63196__2;
G__63196.cljs$core$IFn$_invoke$arity$3 = G__63196__3;
return G__63196;
})()
;})(G__62711_63193,G__62712_63194))
;
goog.object.set(G__62711_63193,G__62712_63194,G__62713_63195);
goog.object.set(clojure.core.matrix.protocols.PIndexImplementation,"array",true);

var G__62714_63205 = clojure.core.matrix.protocols.index_QMARK_;
var G__62715_63206 = "array";
var G__62716_63207 = ((function (G__62714_63205,G__62715_63206){
return (function (m){
return true;
});})(G__62714_63205,G__62715_63206))
;
goog.object.set(G__62714_63205,G__62715_63206,G__62716_63207);

var G__62717_63209 = clojure.core.matrix.protocols.index_to_longs;
var G__62718_63210 = "array";
var G__62719_63211 = ((function (G__62717_63209,G__62718_63210){
return (function (m){
return m;
});})(G__62717_63209,G__62718_63210))
;
goog.object.set(G__62717_63209,G__62718_63210,G__62719_63211);

var G__62720_63212 = clojure.core.matrix.protocols.index_to_ints;
var G__62721_63213 = "array";
var G__62722_63214 = ((function (G__62720_63212,G__62721_63213){
return (function (m){
return m;
});})(G__62720_63212,G__62721_63213))
;
goog.object.set(G__62720_63212,G__62721_63213,G__62722_63214);

var G__62723_63215 = clojure.core.matrix.protocols.index_from_longs;
var G__62724_63216 = "array";
var G__62725_63217 = ((function (G__62723_63215,G__62724_63216){
return (function (m,xs){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(xs);
});})(G__62723_63215,G__62724_63216))
;
goog.object.set(G__62723_63215,G__62724_63216,G__62725_63217);

var G__62726_63221 = clojure.core.matrix.protocols.index_from_ints;
var G__62727_63222 = "array";
var G__62728_63223 = ((function (G__62726_63221,G__62727_63222){
return (function (m,xs){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(xs);
});})(G__62726_63221,G__62727_63222))
;
goog.object.set(G__62726_63221,G__62727_63222,G__62728_63223);

var G__62729_63228 = clojure.core.matrix.protocols.index_coerce;
var G__62730_63229 = "array";
var G__62731_63230 = ((function (G__62729_63228,G__62730_63229){
return (function (m,a){
return m;
});})(G__62729_63228,G__62730_63229))
;
goog.object.set(G__62729_63228,G__62730_63229,G__62731_63230);
goog.object.set(clojure.core.matrix.protocols.PBroadcast,"array",true);

var G__62732_63233 = clojure.core.matrix.protocols.broadcast;
var G__62733_63234 = "array";
var G__62734_63235 = ((function (G__62732_63233,G__62733_63234){
return (function (m,new_shape){
var nshape = new_shape;
var mshape = clojure.core.matrix.protocols.get_shape(m);
var mdims = cljs.core.count(mshape);
var ndims = cljs.core.count(nshape);
if((((mdims === ndims)) && (clojure.core.matrix.utils.same_shape_object_QMARK_(nshape,mshape)))){
return m;
} else {
return clojure.core.matrix.impl.wrappers.wrap_broadcast(m,new_shape);

}
});})(G__62732_63233,G__62733_63234))
;
goog.object.set(G__62732_63233,G__62733_63234,G__62734_63235);
goog.object.set(clojure.core.matrix.protocols.PNumerical,"array",true);

var G__62736_63241 = clojure.core.matrix.protocols.numerical_QMARK_;
var G__62737_63242 = "array";
var G__62738_63243 = ((function (G__62736_63241,G__62737_63242){
return (function (m){
return true;
});})(G__62736_63241,G__62737_63242))
;
goog.object.set(G__62736_63241,G__62737_63242,G__62738_63243);
goog.object.set(clojure.core.matrix.protocols.PSubVector,"array",true);

var G__62741_63244 = clojure.core.matrix.protocols.subvector;
var G__62742_63245 = "array";
var G__62743_63246 = ((function (G__62741_63244,G__62742_63245){
return (function (m,start,length){
return clojure.core.matrix.impl.wrappers.wrap_nd(m).clojure$core$matrix$protocols$PSubVector$subvector$arity$3(null,start,length);
});})(G__62741_63244,G__62742_63245))
;
goog.object.set(G__62741_63244,G__62742_63245,G__62743_63246);
goog.object.set(clojure.core.matrix.protocols.PMatrixEquality,"array",true);

var G__62747_63250 = clojure.core.matrix.protocols.matrix_equals;
var G__62748_63251 = "array";
var G__62749_63252 = ((function (G__62747_63250,G__62748_63251){
return (function (a,b){
if((a === b)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_(a,b))){
if(((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a)))){
return (clojure.core.matrix.protocols.get_0d(a) === (function (){var x__53433__auto__ = b;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_(cljs.core.false_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq(a),clojure.core.matrix.protocols.element_seq(b)));
}
} else {
return false;

}
}
});})(G__62747_63250,G__62748_63251))
;
goog.object.set(G__62747_63250,G__62748_63251,G__62749_63252);
goog.object.set(clojure.core.matrix.protocols.PSameShape,"array",true);

var G__62755_63259 = clojure.core.matrix.protocols.same_shape_QMARK_;
var G__62756_63260 = "array";
var G__62757_63261 = ((function (G__62755_63259,G__62756_63260){
return (function (a,b){
return clojure.core.matrix.utils.same_shape_object_QMARK_(clojure.core.matrix.protocols.get_shape(a),clojure.core.matrix.protocols.get_shape(b));
});})(G__62755_63259,G__62756_63260))
;
goog.object.set(G__62755_63259,G__62756_63260,G__62757_63261);
goog.object.set(clojure.core.matrix.protocols.PSelect,"array",true);

var G__62758_63266 = clojure.core.matrix.protocols.select;
var G__62759_63267 = "array";
var G__62760_63268 = ((function (G__62758_63266,G__62759_63267){
return (function (a,area){
var or__4131__auto__ = clojure.core.matrix.protocols.select_view(a,area);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return clojure.core.matrix.impl.wrappers.wrap_selection(a,area);
}
});})(G__62758_63266,G__62759_63267))
;
goog.object.set(G__62758_63266,G__62759_63267,G__62760_63268);
goog.object.set(clojure.core.matrix.protocols.PLogistic,"array",true);

var G__62761_63272 = clojure.core.matrix.protocols.logistic;
var G__62762_63273 = "array";
var G__62763_63274 = ((function (G__62761_63272,G__62762_63273){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.logistic_fn);
});})(G__62761_63272,G__62762_63273))
;
goog.object.set(G__62761_63272,G__62762_63273,G__62763_63274);
goog.object.set(clojure.core.matrix.protocols.PLogisticMutable,"array",true);

var G__62764_63279 = clojure.core.matrix.protocols.logistic_BANG_;
var G__62765_63280 = "array";
var G__62766_63281 = ((function (G__62764_63279,G__62765_63280){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.logistic_fn);
});})(G__62764_63279,G__62765_63280))
;
goog.object.set(G__62764_63279,G__62765_63280,G__62766_63281);
goog.object.set(clojure.core.matrix.protocols.PSoftplus,"array",true);

var G__62767_63285 = clojure.core.matrix.protocols.softplus;
var G__62768_63286 = "array";
var G__62769_63287 = ((function (G__62767_63285,G__62768_63286){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.softplus_fn);
});})(G__62767_63285,G__62768_63286))
;
goog.object.set(G__62767_63285,G__62768_63286,G__62769_63287);
goog.object.set(clojure.core.matrix.protocols.PSoftmax,"array",true);

var G__62771_63290 = clojure.core.matrix.protocols.softmax;
var G__62772_63291 = "array";
var G__62773_63292 = ((function (G__62771_63290,G__62772_63291){
return (function (m){
var em = clojure.core.matrix.protocols.exp(m);
return clojure.core.matrix.protocols.element_divide.cljs$core$IFn$_invoke$arity$2(em,clojure.core.matrix.protocols.element_sum(em));
});})(G__62771_63290,G__62772_63291))
;
goog.object.set(G__62771_63290,G__62772_63291,G__62773_63292);
goog.object.set(clojure.core.matrix.protocols.PSoftmaxMutable,"array",true);

var G__62774_63296 = clojure.core.matrix.protocols.softmax_BANG_;
var G__62775_63297 = "array";
var G__62776_63298 = ((function (G__62774_63296,G__62775_63297){
return (function (m){
clojure.core.matrix.protocols.exp_BANG_(m);

clojure.core.matrix.protocols.element_divide_BANG_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.protocols.element_sum(m));

return m;
});})(G__62774_63296,G__62775_63297))
;
goog.object.set(G__62774_63296,G__62775_63297,G__62776_63298);
goog.object.set(clojure.core.matrix.protocols.PSoftplusMutable,"array",true);

var G__62777_63300 = clojure.core.matrix.protocols.softplus_BANG_;
var G__62778_63301 = "array";
var G__62779_63302 = ((function (G__62777_63300,G__62778_63301){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.softplus_fn);
});})(G__62777_63300,G__62778_63301))
;
goog.object.set(G__62777_63300,G__62778_63301,G__62779_63302);
goog.object.set(clojure.core.matrix.protocols.PReLU,"array",true);

var G__62787_63305 = clojure.core.matrix.protocols.relu;
var G__62788_63306 = "array";
var G__62789_63307 = ((function (G__62787_63305,G__62788_63306){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.relu_fn);
});})(G__62787_63305,G__62788_63306))
;
goog.object.set(G__62787_63305,G__62788_63306,G__62789_63307);
goog.object.set(clojure.core.matrix.protocols.PReLUMutable,"array",true);

var G__62798_63311 = clojure.core.matrix.protocols.relu_BANG_;
var G__62799_63312 = "array";
var G__62800_63313 = ((function (G__62798_63311,G__62799_63312){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.relu_fn);
});})(G__62798_63311,G__62799_63312))
;
goog.object.set(G__62798_63311,G__62799_63312,G__62800_63313);
goog.object.set(clojure.core.matrix.protocols.PMatrixPredicates,"array",true);

var G__62806_63314 = clojure.core.matrix.protocols.identity_matrix_QMARK_;
var G__62807_63315 = "array";
var G__62808_63316 = ((function (G__62806_63314,G__62807_63315){
return (function (m){
var rc = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
var cc = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(1)));
if((((cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)) === (2))) && ((rc === cc)))){
var i = cljs.core.long$((0));
while(true){
if((i < rc)){
if((function (){var j = cljs.core.long$((0));
while(true){
if((j < cc)){
var elem = clojure.core.matrix.protocols.get_2d(m,i,j);
if(typeof elem === 'number'){
if((i === j)){
if((elem === 1.0)){
var G__63322 = (j + (1));
j = G__63322;
continue;
} else {
return false;
}
} else {
if((elem === (0))){
var G__63323 = (j + (1));
j = G__63323;
continue;
} else {
return false;
}
}
} else {
return false;
}
} else {
return true;
}
break;
}
})()){
var G__63325 = (i + (1));
i = G__63325;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});})(G__62806_63314,G__62807_63315))
;
goog.object.set(G__62806_63314,G__62807_63315,G__62808_63316);

var G__62809_63328 = clojure.core.matrix.protocols.zero_matrix_QMARK_;
var G__62810_63329 = "array";
var G__62811_63330 = ((function (G__62809_63328,G__62810_63329){
return (function (m){
return cljs.core.every_QMARK_(((function (G__62809_63328,G__62810_63329){
return (function (p1__62805_SHARP_){
return ((typeof p1__62805_SHARP_ === 'number') && ((p1__62805_SHARP_ === (0))));
});})(G__62809_63328,G__62810_63329))
,clojure.core.matrix.protocols.element_seq(m));
});})(G__62809_63328,G__62810_63329))
;
goog.object.set(G__62809_63328,G__62810_63329,G__62811_63330);

var G__62813_63334 = clojure.core.matrix.protocols.symmetric_QMARK_;
var G__62814_63335 = "array";
var G__62815_63336 = ((function (G__62813_63334,G__62814_63335){
return (function (m){
var G__62816 = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
switch (G__62816) {
case (0):
return true;

break;
case (1):
return true;

break;
case (2):
var and__4120__auto__ = clojure.core.matrix.impl.common.square_QMARK_(m);
if(and__4120__auto__){
return clojure.core.matrix.impl.common.symmetric_matrix_entries_QMARK_(m);
} else {
return and__4120__auto__;
}

break;
default:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.protocols.transpose(m));

}
});})(G__62813_63334,G__62814_63335))
;
goog.object.set(G__62813_63334,G__62814_63335,G__62815_63336);

goog.object.set(clojure.core.matrix.protocols.PMatrixPredicates,"number",true);

var G__62817_63341 = clojure.core.matrix.protocols.identity_matrix_QMARK_;
var G__62818_63342 = "number";
var G__62819_63343 = ((function (G__62817_63341,G__62818_63342){
return (function (m){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),m);
});})(G__62817_63341,G__62818_63342))
;
goog.object.set(G__62817_63341,G__62818_63342,G__62819_63343);

var G__62820_63346 = clojure.core.matrix.protocols.zero_matrix_QMARK_;
var G__62821_63347 = "number";
var G__62822_63348 = ((function (G__62820_63346,G__62821_63347){
return (function (m){
return (m === (0));
});})(G__62820_63346,G__62821_63347))
;
goog.object.set(G__62820_63346,G__62821_63347,G__62822_63348);

var G__62823_63350 = clojure.core.matrix.protocols.symmetric_QMARK_;
var G__62824_63351 = "number";
var G__62825_63352 = ((function (G__62823_63350,G__62824_63351){
return (function (m){
return true;
});})(G__62823_63350,G__62824_63351))
;
goog.object.set(G__62823_63350,G__62824_63351,G__62825_63352);
goog.object.set(clojure.core.matrix.protocols.PSummable,"array",true);

var G__62826_63354 = clojure.core.matrix.protocols.element_sum;
var G__62827_63355 = "array";
var G__62828_63356 = ((function (G__62826_63354,G__62827_63355){
return (function (a){
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$2(a,(cljs.core.truth_(clojure.core.matrix.protocols.numerical_QMARK_(a))?cljs.core._PLUS_:clojure.core.matrix.protocols.matrix_add));
});})(G__62826_63354,G__62827_63355))
;
goog.object.set(G__62826_63354,G__62827_63355,G__62828_63356);
goog.object.set(clojure.core.matrix.protocols.PMatrixMultiply,"array",true);

var G__62830_63358 = clojure.core.matrix.protocols.matrix_multiply;
var G__62831_63359 = "array";
var G__62832_63360 = ((function (G__62830_63358,G__62831_63359){
return (function (m,a){
var mdims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
var adims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a));
if((adims === (0))){
return clojure.core.matrix.protocols.scale(m,a);
} else {
if((((mdims === (1))) && ((adims === (1))))){
return clojure.core.matrix.protocols.vector_dot(m,a);
} else {
if((((mdims === (1))) && ((adims === (2))))){
var vec__62833 = clojure.core.matrix.protocols.get_shape(a);
var arows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62833,(0),null);
var acols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62833,(1),null);
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.matrix_multiply(clojure.core.matrix.protocols.reshape(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),arows], null)),a),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acols], null));
} else {
if((((mdims === (2))) && ((adims === (1))))){
var vec__62838 = clojure.core.matrix.protocols.get_shape(m);
var mrows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62838,(0),null);
var mcols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62838,(1),null);
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.matrix_multiply(m,clojure.core.matrix.protocols.reshape(a,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mcols,(1)], null))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [mcols], null));
} else {
if((((mdims === (2))) && ((adims === (2))))){
var mutable = clojure.core.matrix.protocols.is_mutable_QMARK_(m);
var vec__62841 = clojure.core.matrix.protocols.get_shape(m);
var mrows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62841,(0),null);
var mcols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62841,(1),null);
var vec__62844 = clojure.core.matrix.protocols.get_shape(a);
var arows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62844,(0),null);
var acols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62844,(1),null);
var new_m_type = (cljs.core.truth_(mutable)?m:clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ndarray","ndarray",1659822393)));
var new_m = clojure.core.matrix.protocols.new_matrix(new_m_type,mrows,acols);
var i_63381 = cljs.core.long$((0));
while(true){
if((i_63381 < mrows)){
var j_63382 = cljs.core.long$((0));
while(true){
if((j_63382 < acols)){
clojure.core.matrix.protocols.set_2d_BANG_(new_m,i_63381,j_63382,(0));

var G__63384 = (j_63382 + (1));
j_63382 = G__63384;
continue;
} else {
}
break;
}

var G__63387 = (i_63381 + (1));
i_63381 = G__63387;
continue;
} else {
}
break;
}


var i_63388 = cljs.core.long$((0));
while(true){
if((i_63388 < mrows)){
var j_63390 = cljs.core.long$((0));
while(true){
if((j_63390 < acols)){
var k_63391 = cljs.core.long$((0));
while(true){
if((k_63391 < mcols)){
clojure.core.matrix.protocols.set_2d_BANG_(new_m,i_63388,j_63390,(clojure.core.matrix.protocols.get_2d(new_m,i_63388,j_63390) + (clojure.core.matrix.protocols.get_2d(m,i_63388,k_63391) * clojure.core.matrix.protocols.get_2d(a,k_63391,j_63390))));

var G__63394 = (k_63391 + (1));
k_63391 = G__63394;
continue;
} else {
}
break;
}

var G__63395 = (j_63390 + (1));
j_63390 = G__63395;
continue;
} else {
}
break;
}

var G__63398 = (i_63388 + (1));
i_63388 = G__63398;
continue;
} else {
}
break;
}


return new_m;
} else {
return null;
}
}
}
}
}
});})(G__62830_63358,G__62831_63359))
;
goog.object.set(G__62830_63358,G__62831_63359,G__62832_63360);

var G__62851_63399 = clojure.core.matrix.protocols.element_multiply;
var G__62852_63400 = "array";
var G__62853_63401 = ((function (G__62851_63399,G__62852_63400){
return (function (m,a){
if(typeof a === 'number'){
return clojure.core.matrix.protocols.scale(m,a);
} else {
var vec__62854 = clojure.core.matrix.protocols.broadcast_compatible(m,a);
var m__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62854,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62854,(1),null);
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core._STAR_,a__$1);
}
});})(G__62851_63399,G__62852_63400))
;
goog.object.set(G__62851_63399,G__62852_63400,G__62853_63401);
goog.object.set(clojure.core.matrix.protocols.PMatrixMultiplyMutable,"array",true);

var G__62857_63410 = clojure.core.matrix.protocols.element_multiply_BANG_;
var G__62858_63411 = "array";
var G__62859_63412 = ((function (G__62857_63410,G__62858_63411){
return (function (m,a){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_multiply(m,a));
});})(G__62857_63410,G__62858_63411))
;
goog.object.set(G__62857_63410,G__62858_63411,G__62859_63412);

var G__62860_63413 = clojure.core.matrix.protocols.matrix_multiply_BANG_;
var G__62861_63414 = "array";
var G__62862_63415 = ((function (G__62860_63413,G__62861_63414){
return (function (m,a){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.matrix_multiply(m,a));
});})(G__62860_63413,G__62861_63414))
;
goog.object.set(G__62860_63413,G__62861_63414,G__62862_63415);
goog.object.set(clojure.core.matrix.protocols.PMatrixDivide,"array",true);

var G__62863_63418 = clojure.core.matrix.protocols.element_divide;
var G__62864_63419 = "array";
var G__62865_63420 = ((function (G__62863_63418,G__62864_63419){
return (function() {
var G__63421 = null;
var G__63421__1 = (function (m){
if(cljs.core.truth_(clojure.core.matrix.protocols.get_shape(m))){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.protocols.element_divide);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Don't know how to take reciprocal of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(m))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});
var G__63421__2 = (function (m,a){
return clojure.core.matrix.protocols.element_multiply(m,clojure.core.matrix.protocols.element_divide.cljs$core$IFn$_invoke$arity$1(a));
});
G__63421 = function(m,a){
switch(arguments.length){
case 1:
return G__63421__1.call(this,m);
case 2:
return G__63421__2.call(this,m,a);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__63421.cljs$core$IFn$_invoke$arity$1 = G__63421__1;
G__63421.cljs$core$IFn$_invoke$arity$2 = G__63421__2;
return G__63421;
})()
;})(G__62863_63418,G__62864_63419))
;
goog.object.set(G__62863_63418,G__62864_63419,G__62865_63420);
goog.object.set(clojure.core.matrix.protocols.PMatrixDivideMutable,"array",true);

var G__62868_63431 = clojure.core.matrix.protocols.element_divide_BANG_;
var G__62869_63432 = "array";
var G__62870_63433 = ((function (G__62868_63431,G__62869_63432){
return (function() {
var G__63435 = null;
var G__63435__1 = (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,cljs.core._SLASH_);
});
var G__63435__2 = (function (m,a){
var vec__62872 = clojure.core.matrix.protocols.broadcast_compatible(m,a);
var m__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62872,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62872,(1),null);
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core._SLASH_,a__$1);
});
G__63435 = function(m,a){
switch(arguments.length){
case 1:
return G__63435__1.call(this,m);
case 2:
return G__63435__2.call(this,m,a);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__63435.cljs$core$IFn$_invoke$arity$1 = G__63435__1;
G__63435.cljs$core$IFn$_invoke$arity$2 = G__63435__2;
return G__63435;
})()
;})(G__62868_63431,G__62869_63432))
;
goog.object.set(G__62868_63431,G__62869_63432,G__62870_63433);
goog.object.set(clojure.core.matrix.protocols.PBroadcastCoerce,"array",true);

var G__62877_63443 = clojure.core.matrix.protocols.broadcast_coerce;
var G__62878_63444 = "array";
var G__62879_63445 = ((function (G__62877_63443,G__62878_63444){
return (function (m,a){
return clojure.core.matrix.protocols.coerce_param(m,clojure.core.matrix.protocols.broadcast_like(m,a));
});})(G__62877_63443,G__62878_63444))
;
goog.object.set(G__62877_63443,G__62878_63444,G__62879_63445);
goog.object.set(clojure.core.matrix.protocols.PCoercion,"array",true);

var G__62880_63449 = clojure.core.matrix.protocols.coerce_param;
var G__62881_63450 = "array";
var G__62882_63451 = ((function (G__62880_63449,G__62881_63450){
return (function (m,param){
var param__$1 = (((param instanceof cljs.core.ISeq))?clojure.core.matrix.protocols.convert_to_nested_vectors(param):param);
var or__4131__auto__ = clojure.core.matrix.protocols.construct_matrix(m,param__$1);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return param__$1;
}
});})(G__62880_63449,G__62881_63450))
;
goog.object.set(G__62880_63449,G__62881_63450,G__62882_63451);
goog.object.set(clojure.core.matrix.protocols.PBroadcastLike,"array",true);

var G__62886_63455 = clojure.core.matrix.protocols.broadcast_like;
var G__62887_63456 = "array";
var G__62888_63457 = ((function (G__62886_63455,G__62887_63456){
return (function (m,a){
var sm = clojure.core.matrix.protocols.get_shape(m);
var sa = clojure.core.matrix.protocols.get_shape(a);
if(clojure.core.matrix.utils.same_shape_object_QMARK_(sm,sa)){
return a;
} else {
return clojure.core.matrix.protocols.broadcast(a,sm);
}
});})(G__62886_63455,G__62887_63456))
;
goog.object.set(G__62886_63455,G__62887_63456,G__62888_63457);
goog.object.set(clojure.core.matrix.protocols.PMatrixOps,"array",true);

var G__62894_63463 = clojure.core.matrix.protocols.trace;
var G__62895_63464 = "array";
var G__62896_63465 = ((function (G__62894_63463,G__62895_63464){
return (function (m){
if(((2) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Trace requires a 2D matrix",cljs.core.PersistentArrayMap.EMPTY);
}

var rc = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
var cc = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(1)));
var dims = Math.min(rc,cc);
var i = (0);
var res = 0.0;
while(true){
if((i >= dims)){
return res;
} else {
var G__63470 = (i + (1));
var G__63471 = (res + clojure.core.matrix.protocols.get_2d(m,i,i));
i = G__63470;
res = G__63471;
continue;
}
break;
}
});})(G__62894_63463,G__62895_63464))
;
goog.object.set(G__62894_63463,G__62895_63464,G__62896_63465);

var G__62902_63474 = clojure.core.matrix.protocols.determinant;
var G__62903_63475 = "array";
var G__62904_63476 = ((function (G__62902_63474,G__62903_63475){
return (function (m){
return null;
});})(G__62902_63474,G__62903_63475))
;
goog.object.set(G__62902_63474,G__62903_63475,G__62904_63476);

var G__62905_63481 = clojure.core.matrix.protocols.inverse;
var G__62906_63482 = "array";
var G__62907_63483 = ((function (G__62905_63481,G__62906_63482){
return (function (m){
return null;
});})(G__62905_63481,G__62906_63482))
;
goog.object.set(G__62905_63481,G__62906_63482,G__62907_63483);

//# sourceMappingURL=clojure.core.matrix.impl.double_array.js.map
