goog.provide('clojure.core.matrix.impl.defaults');
goog.require('cljs.core');
goog.require('clojure.core.matrix.protocols');
goog.require('clojure.core.matrix.impl.wrappers');
goog.require('clojure.core.matrix.impl.mathsops');
goog.require('clojure.core.matrix.implementations');
goog.require('clojure.core.matrix.impl.double_array');
goog.require('clojure.core.matrix.impl.common');
goog.require('clojure.core.matrix.utils');
clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = null;
/**
 * Returns the total count of elements in an array
 */
clojure.core.matrix.impl.defaults.calc_element_count = (function clojure$core$matrix$impl$defaults$calc_element_count(m){
var temp__5816__auto__ = clojure.core.matrix.protocols.get_shape(m);
if(cljs.core.truth_(temp__5816__auto__)){
var sh = temp__5816__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,sh);
} else {
return (1);
}
});
/**
 * Constructs a new mutable matrix with the given data.
 */
clojure.core.matrix.impl.defaults.construct_mutable_matrix = (function clojure$core$matrix$impl$defaults$construct_mutable_matrix(m){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
var type = clojure.core.matrix.protocols.element_type(m);
var double_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Number,type);
if((dims === (0))){
return clojure.core.matrix.impl.wrappers.wrap_scalar(clojure.core.matrix.protocols.get_0d(m));
} else {
if((((dims === (1))) && (double_QMARK_))){
return clojure.core.matrix.protocols.coerce_param(clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"aljabr","aljabr",1424034715)),m);
} else {
if(double_QMARK_){
return clojure.core.matrix.protocols.coerce_param(clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"aljabr","aljabr",1424034715)),m);
} else {
return clojure.core.matrix.protocols.coerce_param(clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"aljabr","aljabr",1424034715)),m);

}
}
}
});
goog.object.set(clojure.core.matrix.protocols.PImplementation,"object",true);

var G__66242_69942 = clojure.core.matrix.protocols.implementation_key;
var G__66243_69943 = "object";
var G__66244_69944 = ((function (G__66242_69942,G__66243_69943){
return (function (m){
return new cljs.core.Keyword(null,"default","default",-1987822328);
});})(G__66242_69942,G__66243_69943))
;
goog.object.set(G__66242_69942,G__66243_69943,G__66244_69944);

var G__66248_69945 = clojure.core.matrix.protocols.meta_info;
var G__66249_69946 = "object";
var G__66250_69947 = ((function (G__66248_69945,G__66249_69946){
return (function (m){
return cljs.core.PersistentArrayMap.EMPTY;
});})(G__66248_69945,G__66249_69946))
;
goog.object.set(G__66248_69945,G__66249_69946,G__66250_69947);

var G__66252_69948 = clojure.core.matrix.protocols.construct_matrix;
var G__66253_69949 = "object";
var G__66254_69950 = ((function (G__66252_69948,G__66253_69949){
return (function (m,data){
return clojure.core.matrix.protocols.construct_matrix(cljs.core.PersistentVector.EMPTY,data);
});})(G__66252_69948,G__66253_69949))
;
goog.object.set(G__66252_69948,G__66253_69949,G__66254_69950);

var G__66255_69951 = clojure.core.matrix.protocols.new_vector;
var G__66256_69952 = "object";
var G__66257_69953 = ((function (G__66255_69951,G__66256_69952){
return (function (m,length){
return clojure.core.matrix.protocols.new_vector(cljs.core.PersistentVector.EMPTY,length);
});})(G__66255_69951,G__66256_69952))
;
goog.object.set(G__66255_69951,G__66256_69952,G__66257_69953);

var G__66267_69964 = clojure.core.matrix.protocols.new_matrix;
var G__66268_69965 = "object";
var G__66269_69966 = ((function (G__66267_69964,G__66268_69965){
return (function (m,rows,columns){
return clojure.core.matrix.protocols.new_matrix(cljs.core.PersistentVector.EMPTY,rows,columns);
});})(G__66267_69964,G__66268_69965))
;
goog.object.set(G__66267_69964,G__66268_69965,G__66269_69966);

var G__66272_69967 = clojure.core.matrix.protocols.new_matrix_nd;
var G__66273_69968 = "object";
var G__66274_69969 = ((function (G__66272_69967,G__66273_69968){
return (function (m,shape){
return clojure.core.matrix.protocols.new_matrix_nd(cljs.core.PersistentVector.EMPTY,shape);
});})(G__66272_69967,G__66273_69968))
;
goog.object.set(G__66272_69967,G__66273_69968,G__66274_69969);

var G__66278_69970 = clojure.core.matrix.protocols.supports_dimensionality_QMARK_;
var G__66279_69971 = "object";
var G__66280_69972 = ((function (G__66278_69970,G__66279_69971){
return (function (m,dimensions){
return true;
});})(G__66278_69970,G__66279_69971))
;
goog.object.set(G__66278_69970,G__66279_69971,G__66280_69972);

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PImplementation$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PImplementation$implementation_key$arity$1 = (function (m){
var m__$1 = this;
return m__$1;
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PImplementation$meta_info$arity$1 = (function (m){
var m__$1 = this;
return clojure.core.matrix.protocols.meta_info(clojure.core.matrix.implementations.get_canonical_object_or_throw(m__$1));
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PImplementation$construct_matrix$arity$2 = (function (m,data){
var m__$1 = this;
return clojure.core.matrix.protocols.construct_matrix(clojure.core.matrix.implementations.get_canonical_object_or_throw(m__$1),data);
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PImplementation$new_vector$arity$2 = (function (m,length){
var m__$1 = this;
return clojure.core.matrix.protocols.new_vector(clojure.core.matrix.implementations.get_canonical_object_or_throw(m__$1),length);
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix$arity$3 = (function (m,rows,columns){
var m__$1 = this;
return clojure.core.matrix.protocols.new_matrix(clojure.core.matrix.implementations.get_canonical_object_or_throw(m__$1),rows,columns);
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PImplementation$new_matrix_nd$arity$2 = (function (m,shape){
var m__$1 = this;
return clojure.core.matrix.protocols.new_matrix_nd(clojure.core.matrix.implementations.get_canonical_object_or_throw(m__$1),shape);
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PImplementation$supports_dimensionality_QMARK_$arity$2 = (function (m,dimensions){
var m__$1 = this;
return clojure.core.matrix.protocols.supports_dimensionality_QMARK_(clojure.core.matrix.implementations.get_canonical_object_or_throw(m__$1),dimensions);
});
goog.object.set(clojure.core.matrix.protocols.PSparse,"null",true);

var G__66342_69981 = clojure.core.matrix.protocols.sparse_coerce;
var G__66343_69982 = "null";
var G__66344_69983 = ((function (G__66342_69981,G__66343_69982){
return (function (m,data){
return clojure.core.matrix.protocols.sparse(data);
});})(G__66342_69981,G__66343_69982))
;
goog.object.set(G__66342_69981,G__66343_69982,G__66344_69983);

var G__66346_69985 = clojure.core.matrix.protocols.sparse;
var G__66347_69986 = "null";
var G__66348_69987 = ((function (G__66346_69985,G__66347_69986){
return (function (m){
return null;
});})(G__66346_69985,G__66347_69986))
;
goog.object.set(G__66346_69985,G__66347_69986,G__66348_69987);

goog.object.set(clojure.core.matrix.protocols.PSparse,"object",true);

var G__66353_69989 = clojure.core.matrix.protocols.sparse_coerce;
var G__66354_69990 = "object";
var G__66355_69991 = ((function (G__66353_69989,G__66354_69990){
return (function (m,data){
return null;
});})(G__66353_69989,G__66354_69990))
;
goog.object.set(G__66353_69989,G__66354_69990,G__66355_69991);

var G__66356_69992 = clojure.core.matrix.protocols.sparse;
var G__66357_69993 = "object";
var G__66358_69994 = ((function (G__66356_69992,G__66357_69993){
return (function (m){
return m;
});})(G__66356_69992,G__66357_69993))
;
goog.object.set(G__66356_69992,G__66357_69993,G__66358_69994);
goog.object.set(clojure.core.matrix.protocols.PNative,"null",true);

var G__66363_70002 = clojure.core.matrix.protocols.native$;
var G__66364_70003 = "null";
var G__66365_70004 = ((function (G__66363_70002,G__66364_70003){
return (function (m){
return null;
});})(G__66363_70002,G__66364_70003))
;
goog.object.set(G__66363_70002,G__66364_70003,G__66365_70004);

var G__66368_70007 = clojure.core.matrix.protocols.native_QMARK_;
var G__66369_70008 = "null";
var G__66370_70009 = ((function (G__66368_70007,G__66369_70008){
return (function (m){
return false;
});})(G__66368_70007,G__66369_70008))
;
goog.object.set(G__66368_70007,G__66369_70008,G__66370_70009);

goog.object.set(clojure.core.matrix.protocols.PNative,"object",true);

var G__66373_70013 = clojure.core.matrix.protocols.native$;
var G__66374_70014 = "object";
var G__66375_70015 = ((function (G__66373_70013,G__66374_70014){
return (function (m){
return null;
});})(G__66373_70013,G__66374_70014))
;
goog.object.set(G__66373_70013,G__66374_70014,G__66375_70015);

var G__66377_70016 = clojure.core.matrix.protocols.native_QMARK_;
var G__66378_70017 = "object";
var G__66379_70018 = ((function (G__66377_70016,G__66378_70017){
return (function (m){
return false;
});})(G__66377_70016,G__66378_70017))
;
goog.object.set(G__66377_70016,G__66378_70017,G__66379_70018);
goog.object.set(clojure.core.matrix.protocols.PNewSparseArray,"object",true);

var G__66382_70021 = clojure.core.matrix.protocols.new_sparse_array;
var G__66383_70022 = "object";
var G__66384_70023 = ((function (G__66382_70021,G__66383_70022){
return (function (m,shape){
return null;
});})(G__66382_70021,G__66383_70022))
;
goog.object.set(G__66382_70021,G__66383_70022,G__66384_70023);
goog.object.set(clojure.core.matrix.protocols.PDense,"null",true);

var G__66387_70026 = clojure.core.matrix.protocols.dense_coerce;
var G__66388_70027 = "null";
var G__66389_70028 = ((function (G__66387_70026,G__66388_70027){
return (function (m,data){
return clojure.core.matrix.protocols.dense(data);
});})(G__66387_70026,G__66388_70027))
;
goog.object.set(G__66387_70026,G__66388_70027,G__66389_70028);

var G__66392_70029 = clojure.core.matrix.protocols.dense;
var G__66393_70030 = "null";
var G__66394_70031 = ((function (G__66392_70029,G__66393_70030){
return (function (m){
return null;
});})(G__66392_70029,G__66393_70030))
;
goog.object.set(G__66392_70029,G__66393_70030,G__66394_70031);

goog.object.set(clojure.core.matrix.protocols.PDense,"object",true);

var G__66401_70033 = clojure.core.matrix.protocols.dense_coerce;
var G__66402_70034 = "object";
var G__66403_70035 = ((function (G__66401_70033,G__66402_70034){
return (function (m,data){
return null;
});})(G__66401_70033,G__66402_70034))
;
goog.object.set(G__66401_70033,G__66402_70034,G__66403_70035);

var G__66406_70036 = clojure.core.matrix.protocols.dense;
var G__66407_70037 = "object";
var G__66408_70038 = ((function (G__66406_70036,G__66407_70037){
return (function (m){
return m;
});})(G__66406_70036,G__66407_70037))
;
goog.object.set(G__66406_70036,G__66407_70037,G__66408_70038);
goog.object.set(clojure.core.matrix.protocols.PIndexedAccess,"null",true);

var G__66413_70043 = clojure.core.matrix.protocols.get_1d;
var G__66414_70044 = "null";
var G__66415_70045 = ((function (G__66413_70043,G__66414_70044){
return (function (m,x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 1D get on nil",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66413_70043,G__66414_70044))
;
goog.object.set(G__66413_70043,G__66414_70044,G__66415_70045);

var G__66416_70052 = clojure.core.matrix.protocols.get_2d;
var G__66417_70053 = "null";
var G__66418_70054 = ((function (G__66416_70052,G__66417_70053){
return (function (m,x,y){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 2D get on nil",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66416_70052,G__66417_70053))
;
goog.object.set(G__66416_70052,G__66417_70053,G__66418_70054);

var G__66424_70056 = clojure.core.matrix.protocols.get_nd;
var G__66425_70057 = "null";
var G__66426_70058 = ((function (G__66424_70056,G__66425_70057){
return (function (m,indexes){
var temp__5816__auto__ = cljs.core.seq(indexes);
if(temp__5816__auto__){
var s = temp__5816__auto__;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't do ND get on nil with indexes: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return m;
}
});})(G__66424_70056,G__66425_70057))
;
goog.object.set(G__66424_70056,G__66425_70057,G__66426_70058);

goog.object.set(clojure.core.matrix.protocols.PIndexedAccess,"number",true);

var G__66428_70061 = clojure.core.matrix.protocols.get_1d;
var G__66429_70062 = "number";
var G__66430_70063 = ((function (G__66428_70061,G__66429_70062){
return (function (m,x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 1D get on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66428_70061,G__66429_70062))
;
goog.object.set(G__66428_70061,G__66429_70062,G__66430_70063);

var G__66432_70066 = clojure.core.matrix.protocols.get_2d;
var G__66433_70067 = "number";
var G__66434_70068 = ((function (G__66432_70066,G__66433_70067){
return (function (m,x,y){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 2D get on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66432_70066,G__66433_70067))
;
goog.object.set(G__66432_70066,G__66433_70067,G__66434_70068);

var G__66435_70072 = clojure.core.matrix.protocols.get_nd;
var G__66436_70073 = "number";
var G__66437_70074 = ((function (G__66435_70072,G__66436_70073){
return (function (m,indexes){
var temp__5816__auto__ = cljs.core.seq(indexes);
if(temp__5816__auto__){
var s = temp__5816__auto__;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't do ND get on a scalar number with indexes: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return m;
}
});})(G__66435_70072,G__66436_70073))
;
goog.object.set(G__66435_70072,G__66436_70073,G__66437_70074);

goog.object.set(clojure.core.matrix.protocols.PIndexedAccess,"object",true);

var G__66440_70082 = clojure.core.matrix.protocols.get_1d;
var G__66441_70083 = "object";
var G__66442_70084 = ((function (G__66440_70082,G__66441_70083){
return (function (m,x){
if((Array === m.constructor)){
return clojure.core.matrix.protocols.get_0d(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,x));
} else {
return clojure.core.matrix.protocols.get_nd(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null));

}
});})(G__66440_70082,G__66441_70083))
;
goog.object.set(G__66440_70082,G__66441_70083,G__66442_70084);

var G__66443_70089 = clojure.core.matrix.protocols.get_2d;
var G__66444_70090 = "object";
var G__66445_70091 = ((function (G__66443_70089,G__66444_70090){
return (function (m,x,y){
if((Array === m.constructor)){
return clojure.core.matrix.protocols.get_1d(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,x),y);
} else {
return clojure.core.matrix.protocols.get_nd(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y], null));

}
});})(G__66443_70089,G__66444_70090))
;
goog.object.set(G__66443_70089,G__66444_70090,G__66445_70091);

var G__66448_70101 = clojure.core.matrix.protocols.get_nd;
var G__66449_70102 = "object";
var G__66450_70103 = ((function (G__66448_70101,G__66449_70102){
return (function (m,indexes){
if(cljs.core.seq(indexes)){
if((Array === m.constructor)){
return clojure.core.matrix.protocols.get_nd(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,cljs.core.first(indexes)),cljs.core.next(indexes));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Indexed get failed, not defined for:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(m))].join(''),cljs.core.PersistentArrayMap.EMPTY);

}
} else {
return clojure.core.matrix.protocols.get_0d(m);
}
});})(G__66448_70101,G__66449_70102))
;
goog.object.set(G__66448_70101,G__66449_70102,G__66450_70103);

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m,x){
var m__$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,x);
});

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m,x,y){
var m__$1 = this;
if(cljs.core.seqable_QMARK_(cljs.core.first(m__$1))){
return clojure.core.matrix.protocols.get_1d(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,x),y);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 2D get on a lazy seq",cljs.core.PersistentArrayMap.EMPTY);
}
});

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m,indexes){
var m__$1 = this;
if(cljs.core.seq(indexes)){
return clojure.core.matrix.protocols.get_nd(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.first(indexes)),cljs.core.next(indexes));
} else {
return clojure.core.matrix.protocols.get_0d(m__$1);
}
});

cljs.core.Range.prototype.clojure$core$matrix$protocols$PIndexedAccess$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Range.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_1d$arity$2 = (function (m,x){
var m__$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,x);
});

cljs.core.Range.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_2d$arity$3 = (function (m,x,y){
var m__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 2D get on a range",cljs.core.PersistentArrayMap.EMPTY);
});

cljs.core.Range.prototype.clojure$core$matrix$protocols$PIndexedAccess$get_nd$arity$2 = (function (m,indexes){
var m__$1 = this;
if(cljs.core.seq(indexes)){
return clojure.core.matrix.protocols.get_nd(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,cljs.core.first(indexes)),cljs.core.next(indexes));
} else {
return clojure.core.matrix.protocols.get_0d(m__$1);
}
});
goog.object.set(clojure.core.matrix.protocols.PArrayMetrics,"null",true);

var G__66465_70125 = clojure.core.matrix.protocols.nonzero_count;
var G__66466_70126 = "null";
var G__66467_70127 = ((function (G__66465_70125,G__66466_70126){
return (function (m){
return (1);
});})(G__66465_70125,G__66466_70126))
;
goog.object.set(G__66465_70125,G__66466_70126,G__66467_70127);

goog.object.set(clojure.core.matrix.protocols.PArrayMetrics,"number",true);

var G__66469_70130 = clojure.core.matrix.protocols.nonzero_count;
var G__66470_70131 = "number";
var G__66471_70132 = ((function (G__66469_70130,G__66470_70131){
return (function (m){
if((m === (0))){
return (0);
} else {
return (1);
}
});})(G__66469_70130,G__66470_70131))
;
goog.object.set(G__66469_70130,G__66470_70131,G__66471_70132);

goog.object.set(clojure.core.matrix.protocols.PArrayMetrics,"object",true);

var G__66472_70135 = clojure.core.matrix.protocols.nonzero_count;
var G__66473_70136 = "object";
var G__66474_70137 = ((function (G__66472_70135,G__66473_70136){
return (function (m){
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$3(m,((function (G__66472_70135,G__66473_70136){
return (function (cnt,e){
if((e === (0))){
return cnt;
} else {
return (cnt + (1));
}
});})(G__66472_70135,G__66473_70136))
,(0));
});})(G__66472_70135,G__66473_70136))
;
goog.object.set(G__66472_70135,G__66473_70136,G__66474_70137);
goog.object.set(clojure.core.matrix.protocols.PZeroDimensionConstruction,"null",true);

var G__66480_70143 = clojure.core.matrix.protocols.new_scalar_array;
var G__66481_70144 = "null";
var G__66482_70145 = ((function (G__66480_70143,G__66481_70144){
return (function() {
var G__70146 = null;
var G__70146__1 = (function (m){
return 0.0;
});
var G__70146__2 = (function (m,value){
return clojure.core.matrix.impl.wrappers.wrap_scalar(value);
});
G__70146 = function(m,value){
switch(arguments.length){
case 1:
return G__70146__1.call(this,m);
case 2:
return G__70146__2.call(this,m,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__70146.cljs$core$IFn$_invoke$arity$1 = G__70146__1;
G__70146.cljs$core$IFn$_invoke$arity$2 = G__70146__2;
return G__70146;
})()
;})(G__66480_70143,G__66481_70144))
;
goog.object.set(G__66480_70143,G__66481_70144,G__66482_70145);

goog.object.set(clojure.core.matrix.protocols.PZeroDimensionConstruction,"object",true);

var G__66483_70149 = clojure.core.matrix.protocols.new_scalar_array;
var G__66484_70150 = "object";
var G__66485_70151 = ((function (G__66483_70149,G__66484_70150){
return (function() {
var G__70153 = null;
var G__70153__1 = (function (m){
return clojure.core.matrix.impl.wrappers.wrap_scalar(0.0);
});
var G__70153__2 = (function (m,value){
return clojure.core.matrix.impl.wrappers.wrap_scalar(value);
});
G__70153 = function(m,value){
switch(arguments.length){
case 1:
return G__70153__1.call(this,m);
case 2:
return G__70153__2.call(this,m,value);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__70153.cljs$core$IFn$_invoke$arity$1 = G__70153__1;
G__70153.cljs$core$IFn$_invoke$arity$2 = G__70153__2;
return G__70153;
})()
;})(G__66483_70149,G__66484_70150))
;
goog.object.set(G__66483_70149,G__66484_70150,G__66485_70151);
goog.object.set(clojure.core.matrix.protocols.PZeroDimensionAccess,"null",true);

var G__66488_70156 = clojure.core.matrix.protocols.get_0d;
var G__66489_70157 = "null";
var G__66490_70158 = ((function (G__66488_70156,G__66489_70157){
return (function (m){
return null;
});})(G__66488_70156,G__66489_70157))
;
goog.object.set(G__66488_70156,G__66489_70157,G__66490_70158);

var G__66491_70162 = clojure.core.matrix.protocols.set_0d_BANG_;
var G__66492_70163 = "null";
var G__66493_70164 = ((function (G__66491_70162,G__66492_70163){
return (function (m,value){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't set the value of nil!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66491_70162,G__66492_70163))
;
goog.object.set(G__66491_70162,G__66492_70163,G__66493_70164);

goog.object.set(clojure.core.matrix.protocols.PZeroDimensionAccess,"string",true);

var G__66494_70167 = clojure.core.matrix.protocols.get_0d;
var G__66495_70168 = "string";
var G__66496_70169 = ((function (G__66494_70167,G__66495_70168){
return (function (m){
return m;
});})(G__66494_70167,G__66495_70168))
;
goog.object.set(G__66494_70167,G__66495_70168,G__66496_70169);

var G__66497_70173 = clojure.core.matrix.protocols.set_0d_BANG_;
var G__66498_70174 = "string";
var G__66499_70175 = ((function (G__66497_70173,G__66498_70174){
return (function (m,value){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't set a string value!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66497_70173,G__66498_70174))
;
goog.object.set(G__66497_70173,G__66498_70174,G__66499_70175);

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PZeroDimensionAccess$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PZeroDimensionAccess$get_0d$arity$1 = (function (m){
var m__$1 = this;
return m__$1;
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PZeroDimensionAccess$set_0d_BANG_$arity$2 = (function (m,value){
var m__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't set a keyword!",cljs.core.PersistentArrayMap.EMPTY);
});

goog.object.set(clojure.core.matrix.protocols.PZeroDimensionAccess,"number",true);

var G__66504_70187 = clojure.core.matrix.protocols.get_0d;
var G__66505_70188 = "number";
var G__66506_70190 = ((function (G__66504_70187,G__66505_70188){
return (function (m){
return m;
});})(G__66504_70187,G__66505_70188))
;
goog.object.set(G__66504_70187,G__66505_70188,G__66506_70190);

var G__66515_70192 = clojure.core.matrix.protocols.set_0d_BANG_;
var G__66516_70193 = "number";
var G__66517_70194 = ((function (G__66515_70192,G__66516_70193){
return (function (m,value){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't set a scalar number!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66515_70192,G__66516_70193))
;
goog.object.set(G__66515_70192,G__66516_70193,G__66517_70194);

goog.object.set(clojure.core.matrix.protocols.PZeroDimensionAccess,"object",true);

var G__66521_70198 = clojure.core.matrix.protocols.get_0d;
var G__66522_70199 = "object";
var G__66523_70200 = ((function (G__66521_70198,G__66522_70199){
return (function (m){
return m;
});})(G__66521_70198,G__66522_70199))
;
goog.object.set(G__66521_70198,G__66522_70199,G__66523_70200);

var G__66525_70202 = clojure.core.matrix.protocols.set_0d_BANG_;
var G__66526_70203 = "object";
var G__66527_70204 = ((function (G__66525_70202,G__66526_70203){
return (function (m,value){
return clojure.core.matrix.protocols.set_nd_BANG_(m,cljs.core.PersistentVector.EMPTY,value);
});})(G__66525_70202,G__66526_70203))
;
goog.object.set(G__66525_70202,G__66526_70203,G__66527_70204);
goog.object.set(clojure.core.matrix.protocols.PZeroDimensionSet,"null",true);

var G__66530_70206 = clojure.core.matrix.protocols.set_0d;
var G__66531_70207 = "null";
var G__66532_70208 = ((function (G__66530_70206,G__66531_70207){
return (function (m,value){
return value;
});})(G__66530_70206,G__66531_70207))
;
goog.object.set(G__66530_70206,G__66531_70207,G__66532_70208);

goog.object.set(clojure.core.matrix.protocols.PZeroDimensionSet,"object",true);

var G__66535_70211 = clojure.core.matrix.protocols.set_0d;
var G__66536_70212 = "object";
var G__66537_70214 = ((function (G__66535_70211,G__66536_70212){
return (function (m,value){
return value;
});})(G__66535_70211,G__66536_70212))
;
goog.object.set(G__66535_70211,G__66536_70212,G__66537_70214);
goog.object.set(clojure.core.matrix.protocols.PIndexedSetting,"null",true);

var G__66543_70217 = clojure.core.matrix.protocols.set_1d;
var G__66544_70218 = "null";
var G__66545_70219 = ((function (G__66543_70217,G__66544_70218){
return (function (m,row,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 1D set on nil",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66543_70217,G__66544_70218))
;
goog.object.set(G__66543_70217,G__66544_70218,G__66545_70219);

var G__66546_70222 = clojure.core.matrix.protocols.set_2d;
var G__66547_70223 = "null";
var G__66548_70224 = ((function (G__66546_70222,G__66547_70223){
return (function (m,row,column,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 2D set on nil",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66546_70222,G__66547_70223))
;
goog.object.set(G__66546_70222,G__66547_70223,G__66548_70224);

var G__66551_70232 = clojure.core.matrix.protocols.set_nd;
var G__66552_70233 = "null";
var G__66553_70234 = ((function (G__66551_70232,G__66552_70233){
return (function (m,indexes,v){
if(cljs.core.seq(indexes)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't do ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(indexes)),"D set on nil"].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return v;
}
});})(G__66551_70232,G__66552_70233))
;
goog.object.set(G__66551_70232,G__66552_70233,G__66553_70234);

var G__66554_70237 = clojure.core.matrix.protocols.is_mutable_QMARK_;
var G__66555_70238 = "null";
var G__66556_70239 = ((function (G__66554_70237,G__66555_70238){
return (function (m){
return false;
});})(G__66554_70237,G__66555_70238))
;
goog.object.set(G__66554_70237,G__66555_70238,G__66556_70239);

goog.object.set(clojure.core.matrix.protocols.PIndexedSetting,"number",true);

var G__66560_70244 = clojure.core.matrix.protocols.set_1d;
var G__66561_70245 = "number";
var G__66562_70246 = ((function (G__66560_70244,G__66561_70245){
return (function (m,row,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 1D set on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66560_70244,G__66561_70245))
;
goog.object.set(G__66560_70244,G__66561_70245,G__66562_70246);

var G__66564_70248 = clojure.core.matrix.protocols.set_2d;
var G__66565_70249 = "number";
var G__66566_70250 = ((function (G__66564_70248,G__66565_70249){
return (function (m,row,column,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do 2D set on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__66564_70248,G__66565_70249))
;
goog.object.set(G__66564_70248,G__66565_70249,G__66566_70250);

var G__66568_70251 = clojure.core.matrix.protocols.set_nd;
var G__66569_70252 = "number";
var G__66570_70253 = ((function (G__66568_70251,G__66569_70252){
return (function (m,indexes,v){
if(cljs.core.seq(indexes)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't do ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(indexes)),"D set on a scalar number"].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return v;
}
});})(G__66568_70251,G__66569_70252))
;
goog.object.set(G__66568_70251,G__66569_70252,G__66570_70253);

var G__66581_70258 = clojure.core.matrix.protocols.is_mutable_QMARK_;
var G__66582_70259 = "number";
var G__66583_70260 = ((function (G__66581_70258,G__66582_70259){
return (function (m){
return false;
});})(G__66581_70258,G__66582_70259))
;
goog.object.set(G__66581_70258,G__66582_70259,G__66583_70260);

goog.object.set(clojure.core.matrix.protocols.PIndexedSetting,"object",true);

var G__66584_70266 = clojure.core.matrix.protocols.set_1d;
var G__66585_70267 = "object";
var G__66586_70268 = ((function (G__66584_70266,G__66585_70267){
return (function (m,row,v){
var m__$1 = clojure.core.matrix.protocols.clone(m);
clojure.core.matrix.protocols.set_1d_BANG_(m__$1,row,v);

return m__$1;
});})(G__66584_70266,G__66585_70267))
;
goog.object.set(G__66584_70266,G__66585_70267,G__66586_70268);

var G__66589_70272 = clojure.core.matrix.protocols.set_2d;
var G__66590_70273 = "object";
var G__66591_70274 = ((function (G__66589_70272,G__66590_70273){
return (function (m,row,column,v){
var m__$1 = clojure.core.matrix.protocols.clone(m);
clojure.core.matrix.protocols.set_2d_BANG_(m__$1,row,column,v);

return m__$1;
});})(G__66589_70272,G__66590_70273))
;
goog.object.set(G__66589_70272,G__66590_70273,G__66591_70274);

var G__66594_70277 = clojure.core.matrix.protocols.set_nd;
var G__66595_70278 = "object";
var G__66596_70279 = ((function (G__66594_70277,G__66595_70278){
return (function (m,indexes,v){
var m__$1 = clojure.core.matrix.protocols.clone(m);
clojure.core.matrix.protocols.set_nd_BANG_(m__$1,indexes,v);

return m__$1;
});})(G__66594_70277,G__66595_70278))
;
goog.object.set(G__66594_70277,G__66595_70278,G__66596_70279);

var G__66598_70287 = clojure.core.matrix.protocols.is_mutable_QMARK_;
var G__66599_70288 = "object";
var G__66600_70289 = ((function (G__66598_70287,G__66599_70288){
return (function (m){
return true;
});})(G__66598_70287,G__66599_70288))
;
goog.object.set(G__66598_70287,G__66599_70288,G__66600_70289);
goog.object.set(clojure.core.matrix.protocols.PNumerical,"number",true);

var G__66606_70292 = clojure.core.matrix.protocols.numerical_QMARK_;
var G__66607_70293 = "number";
var G__66608_70294 = ((function (G__66606_70292,G__66607_70293){
return (function (m){
return true;
});})(G__66606_70292,G__66607_70293))
;
goog.object.set(G__66606_70292,G__66607_70293,G__66608_70294);

goog.object.set(clojure.core.matrix.protocols.PNumerical,"null",true);

var G__66609_70295 = clojure.core.matrix.protocols.numerical_QMARK_;
var G__66610_70296 = "null";
var G__66611_70297 = ((function (G__66609_70295,G__66610_70296){
return (function (m){
return false;
});})(G__66609_70295,G__66610_70296))
;
goog.object.set(G__66609_70295,G__66610_70296,G__66611_70297);

goog.object.set(clojure.core.matrix.protocols.PNumerical,"object",true);

var G__66614_70304 = clojure.core.matrix.protocols.numerical_QMARK_;
var G__66615_70305 = "object";
var G__66616_70306 = ((function (G__66614_70304,G__66615_70305){
return (function (m){
if(cljs.core.truth_(clojure.core.matrix.protocols.is_scalar_QMARK_(m))){
return false;
} else {
return cljs.core.every_QMARK_(cljs.core.number_QMARK_,clojure.core.matrix.protocols.element_seq(m));
}
});})(G__66614_70304,G__66615_70305))
;
goog.object.set(G__66614_70304,G__66615_70305,G__66616_70306);
goog.object.set(clojure.core.matrix.protocols.PVectorOps,"number",true);

var G__66629_70313 = clojure.core.matrix.protocols.vector_dot;
var G__66630_70314 = "number";
var G__66631_70315 = ((function (G__66629_70313,G__66630_70314){
return (function (a,b){
return clojure.core.matrix.protocols.pre_scale(b,a);
});})(G__66629_70313,G__66630_70314))
;
goog.object.set(G__66629_70313,G__66630_70314,G__66631_70315);

var G__66632_70323 = clojure.core.matrix.protocols.length;
var G__66633_70324 = "number";
var G__66634_70325 = ((function (G__66632_70323,G__66633_70324){
return (function (a){
var G__66637 = a;
return Math.abs(G__66637);
});})(G__66632_70323,G__66633_70324))
;
goog.object.set(G__66632_70323,G__66633_70324,G__66634_70325);

var G__66639_70326 = clojure.core.matrix.protocols.length_squared;
var G__66640_70327 = "number";
var G__66641_70328 = ((function (G__66639_70326,G__66640_70327){
return (function (a){
var a__$1 = a;
return (a__$1 * a__$1);
});})(G__66639_70326,G__66640_70327))
;
goog.object.set(G__66639_70326,G__66640_70327,G__66641_70328);

var G__66644_70331 = clojure.core.matrix.protocols.normalise;
var G__66645_70332 = "number";
var G__66646_70333 = ((function (G__66644_70331,G__66645_70332){
return (function (a){
var a__$1 = a;
if((a__$1 > 0.0)){
return 1.0;
} else {
if((a__$1 < 0.0)){
return -1.0;
} else {
return 0.0;

}
}
});})(G__66644_70331,G__66645_70332))
;
goog.object.set(G__66644_70331,G__66645_70332,G__66646_70333);

goog.object.set(clojure.core.matrix.protocols.PVectorOps,"object",true);

var G__66652_70337 = clojure.core.matrix.protocols.vector_dot;
var G__66653_70338 = "object";
var G__66654_70339 = ((function (G__66652_70337,G__66653_70338){
return (function (a,b){
if(((((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a)))) && (((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b)))))){
return clojure.core.matrix.protocols.element_sum(clojure.core.matrix.protocols.element_multiply(a,b));
} else {
return null;
}
});})(G__66652_70337,G__66653_70338))
;
goog.object.set(G__66652_70337,G__66653_70338,G__66654_70339);

var G__66657_70348 = clojure.core.matrix.protocols.length;
var G__66658_70349 = "object";
var G__66659_70350 = ((function (G__66657_70348,G__66658_70349){
return (function (a){
var G__66660 = clojure.core.matrix.protocols.length_squared(a);
return Math.sqrt(G__66660);
});})(G__66657_70348,G__66658_70349))
;
goog.object.set(G__66657_70348,G__66658_70349,G__66659_70350);

var G__66661_70355 = clojure.core.matrix.protocols.length_squared;
var G__66662_70356 = "object";
var G__66663_70357 = ((function (G__66661_70355,G__66662_70356){
return (function (a){
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$3(a,((function (G__66661_70355,G__66662_70356){
return (function (r,x){
return (r + (x * x));
});})(G__66661_70355,G__66662_70356))
,0.0);
});})(G__66661_70355,G__66662_70356))
;
goog.object.set(G__66661_70355,G__66662_70356,G__66663_70357);

var G__66666_70365 = clojure.core.matrix.protocols.normalise;
var G__66667_70366 = "object";
var G__66668_70367 = ((function (G__66666_70365,G__66667_70366){
return (function (a){
return clojure.core.matrix.protocols.scale(a,(1.0 / (function (){var G__66669 = clojure.core.matrix.protocols.length_squared(a);
return Math.sqrt(G__66669);
})()));
});})(G__66666_70365,G__66667_70366))
;
goog.object.set(G__66666_70365,G__66667_70366,G__66668_70367);
goog.object.set(clojure.core.matrix.protocols.PVectorDistance,"number",true);

var G__66678_70375 = clojure.core.matrix.protocols.distance;
var G__66679_70376 = "number";
var G__66680_70377 = ((function (G__66678_70375,G__66679_70376){
return (function (a,b){
if(typeof b === 'number'){
var G__66683 = (b - a);
return Math.abs(G__66683);
} else {
return clojure.core.matrix.protocols.distance(b,a);
}
});})(G__66678_70375,G__66679_70376))
;
goog.object.set(G__66678_70375,G__66679_70376,G__66680_70377);

goog.object.set(clojure.core.matrix.protocols.PVectorDistance,"object",true);

var G__66684_70383 = clojure.core.matrix.protocols.distance;
var G__66685_70384 = "object";
var G__66686_70385 = ((function (G__66684_70383,G__66685_70384){
return (function (a,b){
return clojure.core.matrix.protocols.length(clojure.core.matrix.protocols.matrix_sub(a,b));
});})(G__66684_70383,G__66685_70384))
;
goog.object.set(G__66684_70383,G__66685_70384,G__66686_70385);
goog.object.set(clojure.core.matrix.protocols.PVectorCross,"object",true);

var G__66691_70387 = clojure.core.matrix.protocols.cross_product;
var G__66692_70388 = "object";
var G__66693_70389 = ((function (G__66691_70387,G__66692_70388){
return (function (a,b){
var x1 = clojure.core.matrix.protocols.get_1d(a,(0));
var y1 = clojure.core.matrix.protocols.get_1d(a,(1));
var z1 = clojure.core.matrix.protocols.get_1d(a,(2));
var x2 = clojure.core.matrix.protocols.get_1d(b,(0));
var y2 = clojure.core.matrix.protocols.get_1d(b,(1));
var z2 = clojure.core.matrix.protocols.get_1d(b,(2));
return clojure.core.matrix.protocols.construct_matrix(a,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((y1 * z2) - (z1 * y2)),((z1 * x2) - (x1 * z2)),((x1 * y2) - (y1 * x2))], null));
});})(G__66691_70387,G__66692_70388))
;
goog.object.set(G__66691_70387,G__66692_70388,G__66693_70389);

var G__66700_70390 = clojure.core.matrix.protocols.cross_product_BANG_;
var G__66701_70391 = "object";
var G__66702_70392 = ((function (G__66700_70390,G__66701_70391){
return (function (a,b){
var x1 = clojure.core.matrix.protocols.get_1d(a,(0));
var y1 = clojure.core.matrix.protocols.get_1d(a,(1));
var z1 = clojure.core.matrix.protocols.get_1d(a,(2));
var x2 = clojure.core.matrix.protocols.get_1d(b,(0));
var y2 = clojure.core.matrix.protocols.get_1d(b,(1));
var z2 = clojure.core.matrix.protocols.get_1d(b,(2));
clojure.core.matrix.protocols.set_1d_BANG_(a,(0),((y1 * z2) - (z1 * y2)));

clojure.core.matrix.protocols.set_1d_BANG_(a,(1),((z1 * x2) - (x1 * z2)));

clojure.core.matrix.protocols.set_1d_BANG_(a,(2),((x1 * y2) - (y1 * x2)));

return a;
});})(G__66700_70390,G__66701_70391))
;
goog.object.set(G__66700_70390,G__66701_70391,G__66702_70392);
goog.object.set(clojure.core.matrix.protocols.PMutableVectorOps,"object",true);

var G__66705_70401 = clojure.core.matrix.protocols.normalise_BANG_;
var G__66706_70402 = "object";
var G__66707_70403 = ((function (G__66705_70401,G__66706_70402){
return (function (a){
return clojure.core.matrix.protocols.scale_BANG_(a,(1.0 / (function (){var G__66708 = clojure.core.matrix.protocols.length_squared(a);
return Math.sqrt(G__66708);
})()));
});})(G__66705_70401,G__66706_70402))
;
goog.object.set(G__66705_70401,G__66706_70402,G__66707_70403);
goog.object.set(clojure.core.matrix.protocols.PAssignment,"object",true);

var G__66713_70405 = clojure.core.matrix.protocols.assign_BANG_;
var G__66714_70406 = "object";
var G__66715_70407 = ((function (G__66713_70405,G__66714_70406){
return (function (m,x){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
if(((0) === dims)){
return clojure.core.matrix.protocols.set_0d_BANG_(m,clojure.core.matrix.protocols.get_0d(x));
} else {
if(((1) === dims)){
if((x instanceof cljs.core.ISeq)){
var x__$1 = cljs.core.seq(x);
var msize = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
var i = (0);
var s = cljs.core.seq(x__$1);
while(true){
if((i >= msize)){
if(s){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Mismatches size of sequence in assign!",cljs.core.PersistentArrayMap.EMPTY);
} else {
return null;
}
} else {
clojure.core.matrix.protocols.set_1d_BANG_(m,i,cljs.core.first(s));

var G__70414 = (i + (1));
var G__70416 = cljs.core.next(s);
i = G__70414;
s = G__70416;
continue;
}
break;
}
} else {
var xdims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(x));
var msize = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
if(((0) === xdims)){
var value = clojure.core.matrix.protocols.get_0d(x);
var n__4607__auto__ = msize;
var i = (0);
while(true){
if((i < n__4607__auto__)){
clojure.core.matrix.protocols.set_1d_BANG_(m,i,value);

var G__70425 = (i + (1));
i = G__70425;
continue;
} else {
return null;
}
break;
}
} else {
if(((1) === xdims)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(msize,cljs.core.long$(clojure.core.matrix.protocols.dimension_count(x,(0))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Mismatched shapes in assign to array of shape: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.get_shape(m))," with argument of shape: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.get_shape(x))].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

var n__4607__auto__ = msize;
var i = (0);
while(true){
if((i < n__4607__auto__)){
clojure.core.matrix.protocols.set_1d_BANG_(m,i,clojure.core.matrix.protocols.get_1d(x,i));

var G__70434 = (i + (1));
i = G__70434;
continue;
} else {
return null;
}
break;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't assign! with an argument of higher dimensionality",cljs.core.PersistentArrayMap.EMPTY);

}
}
}
} else {
if(cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(m))){
var xdims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(x));
if((dims === xdims)){
var xss = clojure.core.matrix.protocols.get_major_slice_seq(x);
var _ = (function (){var or__4131__auto__ = clojure.core.matrix.protocols.same_shapes_QMARK_(xss);
if(or__4131__auto__){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Inconsistent slice shapes for assign!",cljs.core.PersistentArrayMap.EMPTY);
}
})();
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (xss,_,xdims,dims,G__66713_70405,G__66714_70406){
return (function (a,b){
return clojure.core.matrix.protocols.assign_BANG_(a,b);
});})(xss,_,xdims,dims,G__66713_70405,G__66714_70406))
,clojure.core.matrix.protocols.get_major_slice_view_seq(m),xss));
} else {
var seq__66732 = cljs.core.seq(clojure.core.matrix.protocols.get_major_slice_view_seq(m));
var chunk__66733 = null;
var count__66734 = (0);
var i__66735 = (0);
while(true){
if((i__66735 < count__66734)){
var ms = chunk__66733.cljs$core$IIndexed$_nth$arity$2(null,i__66735);
clojure.core.matrix.protocols.assign_BANG_(ms,x);


var G__70449 = seq__66732;
var G__70450 = chunk__66733;
var G__70451 = count__66734;
var G__70452 = (i__66735 + (1));
seq__66732 = G__70449;
chunk__66733 = G__70450;
count__66734 = G__70451;
i__66735 = G__70452;
continue;
} else {
var temp__5818__auto__ = cljs.core.seq(seq__66732);
if(temp__5818__auto__){
var seq__66732__$1 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__66732__$1)){
var c__4550__auto__ = cljs.core.chunk_first(seq__66732__$1);
var G__70456 = cljs.core.chunk_rest(seq__66732__$1);
var G__70457 = c__4550__auto__;
var G__70458 = cljs.core.count(c__4550__auto__);
var G__70459 = (0);
seq__66732 = G__70456;
chunk__66733 = G__70457;
count__66734 = G__70458;
i__66735 = G__70459;
continue;
} else {
var ms = cljs.core.first(seq__66732__$1);
clojure.core.matrix.protocols.assign_BANG_(ms,x);


var G__70463 = cljs.core.next(seq__66732__$1);
var G__70464 = null;
var G__70465 = (0);
var G__70466 = (0);
seq__66732 = G__70463;
chunk__66733 = G__70464;
count__66734 = G__70465;
i__66735 = G__70466;
continue;
}
} else {
return null;
}
}
break;
}
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't assign to a non-array object: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(m))].join(''),cljs.core.PersistentArrayMap.EMPTY);

}
}
}
});})(G__66713_70405,G__66714_70406))
;
goog.object.set(G__66713_70405,G__66714_70406,G__66715_70407);

var G__66744_70472 = clojure.core.matrix.protocols.assign_array_BANG_;
var G__66745_70473 = "object";
var G__66746_70474 = ((function (G__66744_70472,G__66745_70473){
return (function() {
var G__70476 = null;
var G__70476__2 = (function (m,arr){
var alen = cljs.core.long$(cljs.core.count(arr));
if(cljs.core.truth_(clojure.core.matrix.protocols.is_vector_QMARK_(m))){
var n__4607__auto__ = alen;
var i = (0);
while(true){
if((i < n__4607__auto__)){
clojure.core.matrix.protocols.set_1d_BANG_(m,i,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arr,i));

var G__70479 = (i + (1));
i = G__70479;
continue;
} else {
return null;
}
break;
}
} else {
return clojure.core.matrix.protocols.assign_array_BANG_.cljs$core$IFn$_invoke$arity$4(m,arr,(0),alen);
}
});
var G__70476__4 = (function (m,arr,start,length){
var length__$1 = cljs.core.long$(length);
var start__$1 = cljs.core.long$(start);
if(cljs.core.truth_(clojure.core.matrix.protocols.is_vector_QMARK_(m))){
var n__4607__auto__ = length__$1;
var i = (0);
while(true){
if((i < n__4607__auto__)){
clojure.core.matrix.protocols.set_1d_BANG_(m,i,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arr,(start__$1 + i)));

var G__70487 = (i + (1));
i = G__70487;
continue;
} else {
return null;
}
break;
}
} else {
var ss = cljs.core.seq(clojure.core.matrix.protocols.get_major_slice_seq(m));
var skip = cljs.core.long$(((ss)?clojure.core.matrix.impl.defaults.calc_element_count(cljs.core.first(clojure.core.matrix.protocols.get_major_slice_seq(m))):(0)));
var vals__53374__auto__ = cljs.core.seq(ss);
var i = cljs.core.long$((0));
while(true){
if(vals__53374__auto__){
var s = cljs.core.first(vals__53374__auto__);
clojure.core.matrix.protocols.assign_array_BANG_.cljs$core$IFn$_invoke$arity$4(s,arr,(start__$1 + (skip * i)),skip);

var G__70493 = cljs.core.next(vals__53374__auto__);
var G__70494 = (i + (1));
vals__53374__auto__ = G__70493;
i = G__70494;
continue;
} else {
return null;
}
break;
}
}
});
G__70476 = function(m,arr,start,length){
switch(arguments.length){
case 2:
return G__70476__2.call(this,m,arr);
case 4:
return G__70476__4.call(this,m,arr,start,length);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__70476.cljs$core$IFn$_invoke$arity$2 = G__70476__2;
G__70476.cljs$core$IFn$_invoke$arity$4 = G__70476__4;
return G__70476;
})()
;})(G__66744_70472,G__66745_70473))
;
goog.object.set(G__66744_70472,G__66745_70473,G__66746_70474);
goog.object.set(clojure.core.matrix.protocols.PImmutableAssignment,"null",true);

var G__66761_70498 = clojure.core.matrix.protocols.assign;
var G__66762_70499 = "null";
var G__66763_70500 = ((function (G__66761_70498,G__66762_70499){
return (function (m,source){
var r = clojure.core.matrix.protocols.broadcast_coerce(m,source);
if((r === source)){
return clojure.core.matrix.protocols.clone(r);
} else {
return r;
}
});})(G__66761_70498,G__66762_70499))
;
goog.object.set(G__66761_70498,G__66762_70499,G__66763_70500);

goog.object.set(clojure.core.matrix.protocols.PImmutableAssignment,"number",true);

var G__66767_70504 = clojure.core.matrix.protocols.assign;
var G__66768_70505 = "number";
var G__66769_70506 = ((function (G__66767_70504,G__66768_70505){
return (function (m,source){
return source;
});})(G__66767_70504,G__66768_70505))
;
goog.object.set(G__66767_70504,G__66768_70505,G__66769_70506);

goog.object.set(clojure.core.matrix.protocols.PImmutableAssignment,"object",true);

var G__66772_70508 = clojure.core.matrix.protocols.assign;
var G__66773_70509 = "object";
var G__66774_70510 = ((function (G__66772_70508,G__66773_70509){
return (function (m,source){
var r = clojure.core.matrix.protocols.broadcast_coerce(m,source);
if((r === source)){
return clojure.core.matrix.protocols.clone(r);
} else {
return r;
}
});})(G__66772_70508,G__66773_70509))
;
goog.object.set(G__66772_70508,G__66773_70509,G__66774_70510);
goog.object.set(clojure.core.matrix.protocols.PMutableFill,"object",true);

var G__66776_70516 = clojure.core.matrix.protocols.fill_BANG_;
var G__66777_70517 = "object";
var G__66778_70518 = ((function (G__66776_70516,G__66777_70517){
return (function (m,value){
return clojure.core.matrix.protocols.assign_BANG_(m,value);
});})(G__66776_70516,G__66777_70517))
;
goog.object.set(G__66776_70516,G__66777_70517,G__66778_70518);
goog.object.set(clojure.core.matrix.protocols.PMatrixCloning,"null",true);

var G__66780_70520 = clojure.core.matrix.protocols.clone;
var G__66781_70521 = "null";
var G__66782_70522 = ((function (G__66780_70520,G__66781_70521){
return (function (m){
return m;
});})(G__66780_70520,G__66781_70521))
;
goog.object.set(G__66780_70520,G__66781_70521,G__66782_70522);

goog.object.set(clojure.core.matrix.protocols.PMatrixCloning,"number",true);

var G__66784_70527 = clojure.core.matrix.protocols.clone;
var G__66785_70528 = "number";
var G__66786_70529 = ((function (G__66784_70527,G__66785_70528){
return (function (m){
return m;
});})(G__66784_70527,G__66785_70528))
;
goog.object.set(G__66784_70527,G__66785_70528,G__66786_70529);

goog.object.set(clojure.core.matrix.protocols.PMatrixCloning,"object",true);

var G__66789_70531 = clojure.core.matrix.protocols.clone;
var G__66790_70532 = "object";
var G__66791_70533 = ((function (G__66789_70531,G__66790_70532){
return (function (m){
return clojure.core.matrix.protocols.construct_matrix(m,m);
});})(G__66789_70531,G__66790_70532))
;
goog.object.set(G__66789_70531,G__66790_70532,G__66791_70533);
goog.object.set(clojure.core.matrix.protocols.PSparseArray,"object",true);

var G__66793_70534 = clojure.core.matrix.protocols.is_sparse_QMARK_;
var G__66794_70535 = "object";
var G__66795_70536 = ((function (G__66793_70534,G__66794_70535){
return (function (m){
return false;
});})(G__66793_70534,G__66794_70535))
;
goog.object.set(G__66793_70534,G__66794_70535,G__66795_70536);
goog.object.set(clojure.core.matrix.protocols.PImmutableMatrixConstruction,"null",true);

var G__66797_70540 = clojure.core.matrix.protocols.immutable_matrix;
var G__66798_70541 = "null";
var G__66799_70542 = ((function (G__66797_70540,G__66798_70541){
return (function (m){
return null;
});})(G__66797_70540,G__66798_70541))
;
goog.object.set(G__66797_70540,G__66798_70541,G__66799_70542);

goog.object.set(clojure.core.matrix.protocols.PImmutableMatrixConstruction,"object",true);

var G__66800_70545 = clojure.core.matrix.protocols.immutable_matrix;
var G__66801_70546 = "object";
var G__66802_70547 = ((function (G__66800_70545,G__66801_70546){
return (function (m){
if(cljs.core.truth_(clojure.core.matrix.protocols.is_mutable_QMARK_(m))){
return clojure.core.matrix.protocols.convert_to_nested_vectors(m);
} else {
return m;
}
});})(G__66800_70545,G__66801_70546))
;
goog.object.set(G__66800_70545,G__66801_70546,G__66802_70547);
goog.object.set(clojure.core.matrix.protocols.PZeroCount,"null",true);

var G__66808_70550 = clojure.core.matrix.protocols.zero_count;
var G__66809_70551 = "null";
var G__66810_70552 = ((function (G__66808_70550,G__66809_70551){
return (function (m){
return (0);
});})(G__66808_70550,G__66809_70551))
;
goog.object.set(G__66808_70550,G__66809_70551,G__66810_70552);

goog.object.set(clojure.core.matrix.protocols.PZeroCount,"number",true);

var G__66811_70553 = clojure.core.matrix.protocols.zero_count;
var G__66812_70554 = "number";
var G__66813_70555 = ((function (G__66811_70553,G__66812_70554){
return (function (m){
if((m === (0))){
return (1);
} else {
return (0);
}
});})(G__66811_70553,G__66812_70554))
;
goog.object.set(G__66811_70553,G__66812_70554,G__66813_70555);

goog.object.set(clojure.core.matrix.protocols.PZeroCount,"object",true);

var G__66815_70556 = clojure.core.matrix.protocols.zero_count;
var G__66816_70557 = "object";
var G__66817_70558 = ((function (G__66815_70556,G__66816_70557){
return (function (m){
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$3(m,((function (G__66815_70556,G__66816_70557){
return (function (acc,e){
if((e === (0))){
return (acc + (1));
} else {
return acc;
}
});})(G__66815_70556,G__66816_70557))
,(0));
});})(G__66815_70556,G__66816_70557))
;
goog.object.set(G__66815_70556,G__66816_70557,G__66817_70558);
goog.object.set(clojure.core.matrix.protocols.PMutableMatrixConstruction,"null",true);

var G__66825_70565 = clojure.core.matrix.protocols.mutable_matrix;
var G__66826_70566 = "null";
var G__66827_70567 = ((function (G__66825_70565,G__66826_70566){
return (function (m){
return clojure.core.matrix.impl.wrappers.wrap_scalar(m);
});})(G__66825_70565,G__66826_70566))
;
goog.object.set(G__66825_70565,G__66826_70566,G__66827_70567);

goog.object.set(clojure.core.matrix.protocols.PMutableMatrixConstruction,"number",true);

var G__66829_70569 = clojure.core.matrix.protocols.mutable_matrix;
var G__66830_70570 = "number";
var G__66831_70571 = ((function (G__66829_70569,G__66830_70570){
return (function (m){
return clojure.core.matrix.impl.wrappers.wrap_scalar(m);
});})(G__66829_70569,G__66830_70570))
;
goog.object.set(G__66829_70569,G__66830_70570,G__66831_70571);

goog.object.set(clojure.core.matrix.protocols.PMutableMatrixConstruction,"object",true);

var G__66832_70572 = clojure.core.matrix.protocols.mutable_matrix;
var G__66833_70573 = "object";
var G__66834_70574 = ((function (G__66832_70572,G__66833_70573){
return (function (m){
return clojure.core.matrix.impl.defaults.construct_mutable_matrix(m);
});})(G__66832_70572,G__66833_70573))
;
goog.object.set(G__66832_70572,G__66833_70573,G__66834_70574);
goog.object.set(clojure.core.matrix.protocols.PMutableCoercion,"null",true);

var G__66837_70575 = clojure.core.matrix.protocols.ensure_mutable;
var G__66838_70576 = "null";
var G__66839_70577 = ((function (G__66837_70575,G__66838_70576){
return (function (m){
return clojure.core.matrix.impl.wrappers.wrap_scalar(m);
});})(G__66837_70575,G__66838_70576))
;
goog.object.set(G__66837_70575,G__66838_70576,G__66839_70577);

goog.object.set(clojure.core.matrix.protocols.PMutableCoercion,"number",true);

var G__66840_70580 = clojure.core.matrix.protocols.ensure_mutable;
var G__66841_70581 = "number";
var G__66842_70582 = ((function (G__66840_70580,G__66841_70581){
return (function (m){
return clojure.core.matrix.impl.wrappers.wrap_scalar(m);
});})(G__66840_70580,G__66841_70581))
;
goog.object.set(G__66840_70580,G__66841_70581,G__66842_70582);

goog.object.set(clojure.core.matrix.protocols.PMutableCoercion,"object",true);

var G__66845_70583 = clojure.core.matrix.protocols.ensure_mutable;
var G__66846_70584 = "object";
var G__66847_70585 = ((function (G__66845_70583,G__66846_70584){
return (function (m){
if(cljs.core.truth_(clojure.core.matrix.protocols.is_mutable_QMARK_(m))){
return m;
} else {
return clojure.core.matrix.impl.defaults.construct_mutable_matrix(m);
}
});})(G__66845_70583,G__66846_70584))
;
goog.object.set(G__66845_70583,G__66846_70584,G__66847_70585);
goog.object.set(clojure.core.matrix.protocols.PComputeMatrix,"object",true);

var G__66852_70586 = clojure.core.matrix.protocols.compute_matrix;
var G__66853_70587 = "object";
var G__66854_70588 = ((function (G__66852_70586,G__66853_70587){
return (function (m,shape,f){
var m__$1 = clojure.core.matrix.protocols.new_matrix_nd(m,shape);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (m__$1,G__66852_70586,G__66853_70587){
return (function (m__$2,ix){
return clojure.core.matrix.protocols.set_nd(m__$2,ix,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,ix));
});})(m__$1,G__66852_70586,G__66853_70587))
,m__$1,clojure.core.matrix.utils.base_index_seq_for_shape(shape));
});})(G__66852_70586,G__66853_70587))
;
goog.object.set(G__66852_70586,G__66853_70587,G__66854_70588);
goog.object.set(clojure.core.matrix.protocols.PDimensionInfo,"null",true);

var G__66867_70598 = clojure.core.matrix.protocols.dimensionality;
var G__66868_70599 = "null";
var G__66869_70600 = ((function (G__66867_70598,G__66868_70599){
return (function (m){
return (0);
});})(G__66867_70598,G__66868_70599))
;
goog.object.set(G__66867_70598,G__66868_70599,G__66869_70600);

var G__66872_70601 = clojure.core.matrix.protocols.is_scalar_QMARK_;
var G__66873_70602 = "null";
var G__66874_70603 = ((function (G__66872_70601,G__66873_70602){
return (function (m){
return true;
});})(G__66872_70601,G__66873_70602))
;
goog.object.set(G__66872_70601,G__66873_70602,G__66874_70603);

var G__66875_70604 = clojure.core.matrix.protocols.is_vector_QMARK_;
var G__66876_70605 = "null";
var G__66877_70606 = ((function (G__66875_70604,G__66876_70605){
return (function (m){
return false;
});})(G__66875_70604,G__66876_70605))
;
goog.object.set(G__66875_70604,G__66876_70605,G__66877_70606);

var G__66880_70607 = clojure.core.matrix.protocols.get_shape;
var G__66881_70608 = "null";
var G__66882_70609 = ((function (G__66880_70607,G__66881_70608){
return (function (m){
return null;
});})(G__66880_70607,G__66881_70608))
;
goog.object.set(G__66880_70607,G__66881_70608,G__66882_70609);

var G__66884_70610 = clojure.core.matrix.protocols.dimension_count;
var G__66885_70611 = "null";
var G__66886_70612 = ((function (G__66884_70610,G__66885_70611){
return (function (m,i){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["nil has zero dimensionality, cannot get count for dimension: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)].join(''),cljs.core.PersistentArrayMap.EMPTY);
});})(G__66884_70610,G__66885_70611))
;
goog.object.set(G__66884_70610,G__66885_70611,G__66886_70612);

cljs.core.Cons.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Cons.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (m){
var m__$1 = this;
return (clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)) + (1));
});

cljs.core.Cons.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return ((0) === clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)));
});

cljs.core.Cons.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return false;
});

cljs.core.Cons.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (m){
var m__$1 = this;
return cljs.core.cons(cljs.core.count(m__$1),clojure.core.matrix.protocols.get_shape(cljs.core.first(m__$1)));
});

cljs.core.Cons.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (m,x){
var m__$1 = this;
if((x === (0))){
return cljs.core.count(m__$1);
} else {
return clojure.core.matrix.protocols.dimension_count(cljs.core.first(m__$1),(x - (1)));
}
});

goog.object.set(clojure.core.matrix.protocols.PDimensionInfo,"object",true);

var G__66893_70617 = clojure.core.matrix.protocols.dimensionality;
var G__66894_70618 = "object";
var G__66895_70619 = ((function (G__66893_70617,G__66894_70618){
return (function (m){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Array,cljs.core.type(m))){
var n = cljs.core.long$(cljs.core.count(m));
if((n > (0))){
return (cljs.core.long$(clojure.core.matrix.protocols.dimensionality(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,(0)))) + (1));
} else {
return (1);
}
} else {
return (0);

}
});})(G__66893_70617,G__66894_70618))
;
goog.object.set(G__66893_70617,G__66894_70618,G__66895_70619);

var G__66901_70625 = clojure.core.matrix.protocols.is_vector_QMARK_;
var G__66902_70626 = "object";
var G__66903_70627 = ((function (G__66901_70625,G__66902_70626){
return (function (m){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Array,cljs.core.type(m))){
var n = cljs.core.long$(cljs.core.count(m));
return (((n === (0))) || (((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,(0)))))));
} else {
return false;

}
});})(G__66901_70625,G__66902_70626))
;
goog.object.set(G__66901_70625,G__66902_70626,G__66903_70627);

var G__66905_70628 = clojure.core.matrix.protocols.is_scalar_QMARK_;
var G__66906_70629 = "object";
var G__66907_70630 = ((function (G__66905_70628,G__66906_70629){
return (function (m){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Array,cljs.core.type(m))){
return false;
} else {
return true;

}
});})(G__66905_70628,G__66906_70629))
;
goog.object.set(G__66905_70628,G__66906_70629,G__66907_70630);

var G__66910_70634 = clojure.core.matrix.protocols.get_shape;
var G__66911_70635 = "object";
var G__66912_70636 = ((function (G__66910_70634,G__66911_70635){
return (function (m){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Array,cljs.core.type(m))){
var n = cljs.core.count(m);
if((n === (0))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
} else {
return cljs.core.cons(n,clojure.core.matrix.protocols.get_shape(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,(0))));
}
} else {
return null;

}
});})(G__66910_70634,G__66911_70635))
;
goog.object.set(G__66910_70634,G__66911_70635,G__66912_70636);

var G__66915_70647 = clojure.core.matrix.protocols.dimension_count;
var G__66916_70648 = "object";
var G__66917_70649 = ((function (G__66915_70647,G__66916_70648){
return (function (m,i){
var i__$1 = cljs.core.long$(i);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Array,cljs.core.type(m))){
if((i__$1 === (0))){
return cljs.core.count(m);
} else {
return clojure.core.matrix.protocols.dimension_count(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,(0)),(i__$1 - (1)));
}
} else {
if(((0) === i__$1)){
return cljs.core.count(m);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't determine count of dimension ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i__$1)," on Object: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(m))].join(''),cljs.core.PersistentArrayMap.EMPTY);

}
}
});})(G__66915_70647,G__66916_70648))
;
goog.object.set(G__66915_70647,G__66916_70648,G__66917_70649);

cljs.core.IndexedSeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.IndexedSeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (m){
var m__$1 = this;
return (clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)) + (1));
});

cljs.core.IndexedSeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return ((0) === clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)));
});

cljs.core.IndexedSeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return false;
});

cljs.core.IndexedSeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (m){
var m__$1 = this;
return cljs.core.cons(cljs.core.count(m__$1),clojure.core.matrix.protocols.get_shape(cljs.core.first(m__$1)));
});

cljs.core.IndexedSeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (m,x){
var m__$1 = this;
if((x === (0))){
return cljs.core.count(m__$1);
} else {
return clojure.core.matrix.protocols.dimension_count(cljs.core.first(m__$1),(x - (1)));
}
});

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (m){
var m__$1 = this;
return (clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)) + (1));
});

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return ((0) === clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)));
});

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return false;
});

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (m){
var m__$1 = this;
return cljs.core.cons(cljs.core.count(m__$1),clojure.core.matrix.protocols.get_shape(cljs.core.first(m__$1)));
});

cljs.core.LazySeq.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (m,x){
var m__$1 = this;
if((x === (0))){
return cljs.core.count(m__$1);
} else {
return clojure.core.matrix.protocols.dimension_count(cljs.core.first(m__$1),(x - (1)));
}
});

goog.object.set(clojure.core.matrix.protocols.PDimensionInfo,"number",true);

var G__66940_70669 = clojure.core.matrix.protocols.dimensionality;
var G__66941_70670 = "number";
var G__66942_70671 = ((function (G__66940_70669,G__66941_70670){
return (function (m){
return (0);
});})(G__66940_70669,G__66941_70670))
;
goog.object.set(G__66940_70669,G__66941_70670,G__66942_70671);

var G__66944_70672 = clojure.core.matrix.protocols.is_scalar_QMARK_;
var G__66945_70673 = "number";
var G__66946_70674 = ((function (G__66944_70672,G__66945_70673){
return (function (m){
return true;
});})(G__66944_70672,G__66945_70673))
;
goog.object.set(G__66944_70672,G__66945_70673,G__66946_70674);

var G__66949_70675 = clojure.core.matrix.protocols.is_vector_QMARK_;
var G__66950_70676 = "number";
var G__66951_70677 = ((function (G__66949_70675,G__66950_70676){
return (function (m){
return false;
});})(G__66949_70675,G__66950_70676))
;
goog.object.set(G__66949_70675,G__66950_70676,G__66951_70677);

var G__66953_70679 = clojure.core.matrix.protocols.get_shape;
var G__66954_70680 = "number";
var G__66955_70681 = ((function (G__66953_70679,G__66954_70680){
return (function (m){
return null;
});})(G__66953_70679,G__66954_70680))
;
goog.object.set(G__66953_70679,G__66954_70680,G__66955_70681);

var G__66956_70683 = clojure.core.matrix.protocols.dimension_count;
var G__66957_70684 = "number";
var G__66958_70685 = ((function (G__66956_70683,G__66957_70684){
return (function (m,i){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Number has zero dimensionality, cannot get count for dimension: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)].join(''),cljs.core.PersistentArrayMap.EMPTY);
});})(G__66956_70683,G__66957_70684))
;
goog.object.set(G__66956_70683,G__66957_70684,G__66958_70685);

cljs.core.List.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.List.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (m){
var m__$1 = this;
return (clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)) + (1));
});

cljs.core.List.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return ((0) === clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)));
});

cljs.core.List.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return false;
});

cljs.core.List.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (m){
var m__$1 = this;
return cljs.core.cons(cljs.core.count(m__$1),clojure.core.matrix.protocols.get_shape(cljs.core.first(m__$1)));
});

cljs.core.List.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (m,x){
var m__$1 = this;
if((x === (0))){
return cljs.core.count(m__$1);
} else {
return clojure.core.matrix.protocols.dimension_count(cljs.core.first(m__$1),(x - (1)));
}
});

goog.object.set(clojure.core.matrix.protocols.PDimensionInfo,"string",true);

var G__66975_70688 = clojure.core.matrix.protocols.dimensionality;
var G__66976_70689 = "string";
var G__66977_70690 = ((function (G__66975_70688,G__66976_70689){
return (function (m){
return (0);
});})(G__66975_70688,G__66976_70689))
;
goog.object.set(G__66975_70688,G__66976_70689,G__66977_70690);

var G__66982_70692 = clojure.core.matrix.protocols.is_scalar_QMARK_;
var G__66983_70693 = "string";
var G__66984_70694 = ((function (G__66982_70692,G__66983_70693){
return (function (m){
return true;
});})(G__66982_70692,G__66983_70693))
;
goog.object.set(G__66982_70692,G__66983_70693,G__66984_70694);

var G__66986_70697 = clojure.core.matrix.protocols.is_vector_QMARK_;
var G__66987_70698 = "string";
var G__66988_70699 = ((function (G__66986_70697,G__66987_70698){
return (function (m){
return false;
});})(G__66986_70697,G__66987_70698))
;
goog.object.set(G__66986_70697,G__66987_70698,G__66988_70699);

var G__66989_70703 = clojure.core.matrix.protocols.get_shape;
var G__66990_70704 = "string";
var G__66991_70705 = ((function (G__66989_70703,G__66990_70704){
return (function (m){
return null;
});})(G__66989_70703,G__66990_70704))
;
goog.object.set(G__66989_70703,G__66990_70704,G__66991_70705);

var G__66992_70708 = clojure.core.matrix.protocols.dimension_count;
var G__66993_70709 = "string";
var G__66994_70710 = ((function (G__66992_70708,G__66993_70709){
return (function (m,i){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["String has zero dimensionality, cannot get count for dimension: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)].join(''),cljs.core.PersistentArrayMap.EMPTY);
});})(G__66992_70708,G__66993_70709))
;
goog.object.set(G__66992_70708,G__66993_70709,G__66994_70710);

cljs.core.Range.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Range.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (m){
var m__$1 = this;
return (clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)) + (1));
});

cljs.core.Range.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return ((0) === clojure.core.matrix.protocols.dimensionality(cljs.core.first(m__$1)));
});

cljs.core.Range.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return false;
});

cljs.core.Range.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (m){
var m__$1 = this;
return cljs.core.cons(cljs.core.count(m__$1),clojure.core.matrix.protocols.get_shape(cljs.core.first(m__$1)));
});

cljs.core.Range.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (m,x){
var m__$1 = this;
if((x === (0))){
return cljs.core.count(m__$1);
} else {
return clojure.core.matrix.protocols.dimension_count(cljs.core.first(m__$1),(x - (1)));
}
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PDimensionInfo$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimensionality$arity$1 = (function (m){
var m__$1 = this;
return (0);
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_scalar_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return true;
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PDimensionInfo$is_vector_QMARK_$arity$1 = (function (m){
var m__$1 = this;
return false;
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PDimensionInfo$get_shape$arity$1 = (function (m){
var m__$1 = this;
return null;
});

cljs.core.Keyword.prototype.clojure$core$matrix$protocols$PDimensionInfo$dimension_count$arity$2 = (function (m,i){
var m__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Keyword has zero dimensionality, cannot get count for dimension: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)].join(''),cljs.core.PersistentArrayMap.EMPTY);
});
goog.object.set(clojure.core.matrix.protocols.PSameShape,"null",true);

var G__67021_70736 = clojure.core.matrix.protocols.same_shape_QMARK_;
var G__67022_70737 = "null";
var G__67023_70738 = ((function (G__67021_70736,G__67022_70737){
return (function (a,b){
return ((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b)));
});})(G__67021_70736,G__67022_70737))
;
goog.object.set(G__67021_70736,G__67022_70737,G__67023_70738);

goog.object.set(clojure.core.matrix.protocols.PSameShape,"string",true);

var G__67025_70745 = clojure.core.matrix.protocols.same_shape_QMARK_;
var G__67026_70746 = "string";
var G__67027_70747 = ((function (G__67025_70745,G__67026_70746){
return (function (a,b){
return ((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b)));
});})(G__67025_70745,G__67026_70746))
;
goog.object.set(G__67025_70745,G__67026_70746,G__67027_70747);

goog.object.set(clojure.core.matrix.protocols.PSameShape,"number",true);

var G__67030_70753 = clojure.core.matrix.protocols.same_shape_QMARK_;
var G__67031_70754 = "number";
var G__67032_70755 = ((function (G__67030_70753,G__67031_70754){
return (function (a,b){
return ((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b)));
});})(G__67030_70753,G__67031_70754))
;
goog.object.set(G__67030_70753,G__67031_70754,G__67032_70755);

goog.object.set(clojure.core.matrix.protocols.PSameShape,"object",true);

var G__67033_70758 = clojure.core.matrix.protocols.same_shape_QMARK_;
var G__67034_70759 = "object";
var G__67035_70760 = ((function (G__67033_70758,G__67034_70759){
return (function (a,b){
return clojure.core.matrix.utils.same_shape_object_QMARK_(clojure.core.matrix.protocols.get_shape(a),clojure.core.matrix.protocols.get_shape(b));
});})(G__67033_70758,G__67034_70759))
;
goog.object.set(G__67033_70758,G__67034_70759,G__67035_70760);
goog.object.set(clojure.core.matrix.protocols.PMatrixOps,"null",true);

var G__67039_70763 = clojure.core.matrix.protocols.trace;
var G__67040_70764 = "null";
var G__67041_70765 = ((function (G__67039_70763,G__67040_70764){
return (function (m){
return m;
});})(G__67039_70763,G__67040_70764))
;
goog.object.set(G__67039_70763,G__67040_70764,G__67041_70765);

goog.object.set(clojure.core.matrix.protocols.PMatrixOps,"number",true);

var G__67043_70766 = clojure.core.matrix.protocols.trace;
var G__67044_70767 = "number";
var G__67045_70768 = ((function (G__67043_70766,G__67044_70767){
return (function (m){
return m;
});})(G__67043_70766,G__67044_70767))
;
goog.object.set(G__67043_70766,G__67044_70767,G__67045_70768);

var G__67055_70771 = clojure.core.matrix.protocols.inverse;
var G__67057_70772 = "number";
var G__67058_70773 = ((function (G__67055_70771,G__67057_70772){
return (function (m){
return ((1) / m);
});})(G__67055_70771,G__67057_70772))
;
goog.object.set(G__67055_70771,G__67057_70772,G__67058_70773);

goog.object.set(clojure.core.matrix.protocols.PMatrixOps,"object",true);

var G__67060_70776 = clojure.core.matrix.protocols.trace;
var G__67061_70777 = "object";
var G__67062_70778 = ((function (G__67060_70776,G__67061_70777){
return (function (m){
if(((2) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Trace requires a 2D matrix",cljs.core.PersistentArrayMap.EMPTY);
}

var rc = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
var cc = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(1)));
var dims = Math.min(rc,cc);
var i = (0);
var res = 0.0;
while(true){
if((i >= dims)){
return res;
} else {
var G__70782 = (i + (1));
var G__70783 = (res + clojure.core.matrix.protocols.get_2d(m,i,i));
i = G__70782;
res = G__70783;
continue;
}
break;
}
});})(G__67060_70776,G__67061_70777))
;
goog.object.set(G__67060_70776,G__67061_70777,G__67062_70778);

var G__67068_70790 = clojure.core.matrix.protocols.determinant;
var G__67069_70791 = "object";
var G__67070_70792 = ((function (G__67068_70790,G__67069_70791){
return (function (m){
var imp = (function (){var or__4131__auto__ = clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"vectorz","vectorz",1550942815));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("(let Need to load an implementation which supports determinant, e.g. vectorz-clj",cljs.core.PersistentArrayMap.EMPTY);
}
})();
var m__$1 = clojure.core.matrix.protocols.coerce_param(imp,m);
return clojure.core.matrix.protocols.determinant(m__$1);
});})(G__67068_70790,G__67069_70791))
;
goog.object.set(G__67068_70790,G__67069_70791,G__67070_70792);

var G__67072_70795 = clojure.core.matrix.protocols.inverse;
var G__67073_70796 = "object";
var G__67074_70797 = ((function (G__67072_70795,G__67073_70796){
return (function (m){
var imp = (function (){var or__4131__auto__ = clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"vectorz","vectorz",1550942815));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Need to load an implementation which supports inverse, e.g. vectorz-clj",cljs.core.PersistentArrayMap.EMPTY);
}
})();
var mm = clojure.core.matrix.protocols.coerce_param(imp,m);
return clojure.core.matrix.protocols.coerce_param(m,clojure.core.matrix.protocols.inverse(mm));
});})(G__67072_70795,G__67073_70796))
;
goog.object.set(G__67072_70795,G__67073_70796,G__67074_70797);
goog.object.set(clojure.core.matrix.protocols.PTranspose,"null",true);

var G__67077_70802 = clojure.core.matrix.protocols.transpose;
var G__67078_70803 = "null";
var G__67079_70804 = ((function (G__67077_70802,G__67078_70803){
return (function (m){
return m;
});})(G__67077_70802,G__67078_70803))
;
goog.object.set(G__67077_70802,G__67078_70803,G__67079_70804);

goog.object.set(clojure.core.matrix.protocols.PTranspose,"number",true);

var G__67080_70807 = clojure.core.matrix.protocols.transpose;
var G__67081_70808 = "number";
var G__67082_70809 = ((function (G__67080_70807,G__67081_70808){
return (function (m){
return m;
});})(G__67080_70807,G__67081_70808))
;
goog.object.set(G__67080_70807,G__67081_70808,G__67082_70809);

goog.object.set(clojure.core.matrix.protocols.PTranspose,"object",true);

var G__67086_70812 = clojure.core.matrix.protocols.transpose;
var G__67087_70813 = "object";
var G__67088_70814 = ((function (G__67086_70812,G__67087_70813){
return (function (m){
return clojure.core.matrix.protocols.coerce_param(m,(function (){var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
var G__67089 = dims;
switch (G__67089) {
case (0):
return m;

break;
case (1):
return m;

break;
case (2):
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.mapv,cljs.core.vector,clojure.core.matrix.protocols.convert_to_nested_vectors(m));

break;
default:
return clojure.core.matrix.protocols.transpose_dims(m,cljs.core.reverse(cljs.core.range.cljs$core$IFn$_invoke$arity$1(dims)));

}
})());
});})(G__67086_70812,G__67087_70813))
;
goog.object.set(G__67086_70812,G__67087_70813,G__67088_70814);
goog.object.set(clojure.core.matrix.protocols.PTransposeDims,"null",true);

var G__67092_70819 = clojure.core.matrix.protocols.transpose_dims;
var G__67093_70820 = "null";
var G__67094_70821 = ((function (G__67092_70819,G__67093_70820){
return (function (m,ordering){
return m;
});})(G__67092_70819,G__67093_70820))
;
goog.object.set(G__67092_70819,G__67093_70820,G__67094_70821);

goog.object.set(clojure.core.matrix.protocols.PTransposeDims,"number",true);

var G__67097_70824 = clojure.core.matrix.protocols.transpose_dims;
var G__67098_70825 = "number";
var G__67099_70826 = ((function (G__67097_70824,G__67098_70825){
return (function (m,ordering){
return m;
});})(G__67097_70824,G__67098_70825))
;
goog.object.set(G__67097_70824,G__67098_70825,G__67099_70826);

goog.object.set(clojure.core.matrix.protocols.PTransposeDims,"object",true);

var G__67100_70829 = clojure.core.matrix.protocols.transpose_dims;
var G__67101_70830 = "object";
var G__67102_70831 = ((function (G__67100_70829,G__67101_70830){
return (function (m,ordering){
return clojure.core.matrix.protocols.transpose_dims(clojure.core.matrix.protocols.convert_to_nested_vectors(m),ordering);
});})(G__67100_70829,G__67101_70830))
;
goog.object.set(G__67100_70829,G__67101_70830,G__67102_70831);
goog.object.set(clojure.core.matrix.protocols.PTransposeInPlace,"object",true);

var G__67105_70842 = clojure.core.matrix.protocols.transpose_BANG_;
var G__67106_70843 = "object";
var G__67107_70844 = ((function (G__67105_70842,G__67106_70843){
return (function (m){
var n_70846 = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(n_70846,cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(1))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("transpose! requires a quare matrix",cljs.core.PersistentArrayMap.EMPTY);
} else {
}

var n__4607__auto___70849 = n_70846;
var i_70850 = (0);
while(true){
if((i_70850 < n__4607__auto___70849)){
var n__4607__auto___70852__$1 = i_70850;
var j_70853 = (0);
while(true){
if((j_70853 < n__4607__auto___70852__$1)){
var t_70854 = clojure.core.matrix.protocols.get_2d(m,i_70850,j_70853);
clojure.core.matrix.protocols.set_2d_BANG_(m,i_70850,j_70853,clojure.core.matrix.protocols.get_2d(m,j_70853,i_70850));

clojure.core.matrix.protocols.set_2d_BANG_(m,j_70853,i_70850,t_70854);

var G__70856 = (j_70853 + (1));
j_70853 = G__70856;
continue;
} else {
}
break;
}

var G__70858 = (i_70850 + (1));
i_70850 = G__70858;
continue;
} else {
}
break;
}

return m;
});})(G__67105_70842,G__67106_70843))
;
goog.object.set(G__67105_70842,G__67106_70843,G__67107_70844);
goog.object.set(clojure.core.matrix.protocols.PRotate,"null",true);

var G__67120_70859 = clojure.core.matrix.protocols.rotate;
var G__67121_70860 = "null";
var G__67122_70861 = ((function (G__67120_70859,G__67121_70860){
return (function (m,dim,places){
return null;
});})(G__67120_70859,G__67121_70860))
;
goog.object.set(G__67120_70859,G__67121_70860,G__67122_70861);

goog.object.set(clojure.core.matrix.protocols.PRotate,"number",true);

var G__67126_70865 = clojure.core.matrix.protocols.rotate;
var G__67127_70866 = "number";
var G__67128_70867 = ((function (G__67126_70865,G__67127_70866){
return (function (m,dim,places){
return m;
});})(G__67126_70865,G__67127_70866))
;
goog.object.set(G__67126_70865,G__67127_70866,G__67128_70867);

goog.object.set(clojure.core.matrix.protocols.PRotate,"object",true);

var G__67131_70870 = clojure.core.matrix.protocols.rotate;
var G__67132_70871 = "object";
var G__67133_70872 = ((function (G__67131_70870,G__67132_70871){
return (function (m,dim,places){
var dim__$1 = cljs.core.long$(dim);
var places__$1 = cljs.core.long$(places);
if((cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)) <= (0))){
return m;
} else {
if(((0) === dim__$1)){
var ss = clojure.core.matrix.protocols.get_major_slice_seq(m);
var c = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
var sh = cljs.core.long$((((c > (0)))?cljs.core.long$(cljs.core.mod(places__$1,c)):(0)));
if((sh === (0))){
return m;
} else {
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.take_last((c - sh),ss),cljs.core.take.cljs$core$IFn$_invoke$arity$2(sh,ss)));
}
} else {
return clojure.core.matrix.protocols.rotate(clojure.core.matrix.protocols.convert_to_nested_vectors(m),dim__$1,places__$1);

}
}
});})(G__67131_70870,G__67132_70871))
;
goog.object.set(G__67131_70870,G__67132_70871,G__67133_70872);
goog.object.set(clojure.core.matrix.protocols.PRotateAll,"null",true);

var G__67147_70886 = clojure.core.matrix.protocols.rotate_all;
var G__67148_70887 = "null";
var G__67149_70888 = ((function (G__67147_70886,G__67148_70887){
return (function (m,shifts){
return null;
});})(G__67147_70886,G__67148_70887))
;
goog.object.set(G__67147_70886,G__67148_70887,G__67149_70888);

goog.object.set(clojure.core.matrix.protocols.PRotateAll,"number",true);

var G__67152_70892 = clojure.core.matrix.protocols.rotate_all;
var G__67153_70893 = "number";
var G__67154_70894 = ((function (G__67152_70892,G__67153_70893){
return (function (m,shifts){
return m;
});})(G__67152_70892,G__67153_70893))
;
goog.object.set(G__67152_70892,G__67153_70893,G__67154_70894);

goog.object.set(clojure.core.matrix.protocols.PRotateAll,"object",true);

var G__67159_70896 = clojure.core.matrix.protocols.rotate_all;
var G__67160_70897 = "object";
var G__67161_70898 = ((function (G__67159_70896,G__67160_70897){
return (function (m,shifts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__67159_70896,G__67160_70897){
return (function (m__$1,p__67166){
var vec__67167 = p__67166;
var dim = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67167,(0),null);
var shift = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67167,(1),null);
if((shift === (0))){
return m__$1;
} else {
return clojure.core.matrix.protocols.rotate(m__$1,dim,shift);
}
});})(G__67159_70896,G__67160_70897))
,m,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (G__67159_70896,G__67160_70897){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(G__67159_70896,G__67160_70897))
,shifts));
});})(G__67159_70896,G__67160_70897))
;
goog.object.set(G__67159_70896,G__67160_70897,G__67161_70898);
goog.object.set(clojure.core.matrix.protocols.PShift,"object",true);

var G__67173_70908 = clojure.core.matrix.protocols.shift;
var G__67174_70909 = "object";
var G__67175_70910 = ((function (G__67173_70908,G__67174_70909){
return (function (m,dim,shift){
var shift__$1 = cljs.core.long$(shift);
var z = clojure.core.matrix.protocols.generic_zero(m);
var c = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,dim));
var sh = cljs.core.vec(clojure.core.matrix.protocols.get_shape(m));
if((shift__$1 === (0))){
return m;
} else {
if((shift__$1 >= c)){
return clojure.core.matrix.protocols.broadcast_coerce(m,z);
} else {
if((shift__$1 <= (- c))){
return clojure.core.matrix.protocols.broadcast_coerce(m,z);
} else {
if((shift__$1 < (0))){
return clojure.core.matrix.protocols.join_along(clojure.core.matrix.protocols.broadcast(clojure.core.matrix.protocols.construct_matrix(m,z),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sh,dim,(- shift__$1))),clojure.core.matrix.protocols.submatrix(m,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(sh),(0))),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sh,dim,(c + shift__$1)))),dim);
} else {
if((shift__$1 > (0))){
return clojure.core.matrix.protocols.join_along(clojure.core.matrix.protocols.submatrix(m,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(sh),(0))),dim,shift__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sh,dim,(c - shift__$1)))),clojure.core.matrix.protocols.broadcast(clojure.core.matrix.protocols.construct_matrix(m,z),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sh,dim,shift__$1)),dim);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Shouldn't be possible!!",cljs.core.PersistentArrayMap.EMPTY);

}
}
}
}
}
});})(G__67173_70908,G__67174_70909))
;
goog.object.set(G__67173_70908,G__67174_70909,G__67175_70910);

var G__67182_70925 = clojure.core.matrix.protocols.shift_all;
var G__67183_70926 = "object";
var G__67184_70927 = ((function (G__67182_70925,G__67183_70926){
return (function (m,shifts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__67182_70925,G__67183_70926){
return (function (m__$1,p__67185){
var vec__67186 = p__67185;
var dim = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67186,(0),null);
var shift = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67186,(1),null);
if((shift === (0))){
return m__$1;
} else {
return clojure.core.matrix.protocols.shift(m__$1,dim,shift);
}
});})(G__67182_70925,G__67183_70926))
,m,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (G__67182_70925,G__67183_70926){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(G__67182_70925,G__67183_70926))
,shifts));
});})(G__67182_70925,G__67183_70926))
;
goog.object.set(G__67182_70925,G__67183_70926,G__67184_70927);
goog.object.set(clojure.core.matrix.protocols.POrder,"null",true);

var G__67204_70938 = clojure.core.matrix.protocols.order;
var G__67205_70939 = "null";
var G__67206_70940 = ((function (G__67204_70938,G__67205_70939){
return (function() {
var G__70942 = null;
var G__70942__2 = (function (m,indices){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't reorder a scalar nil",cljs.core.PersistentArrayMap.EMPTY);
});
var G__70942__3 = (function (m,dim,indices){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't reorder a scalar nil",cljs.core.PersistentArrayMap.EMPTY);
});
G__70942 = function(m,dim,indices){
switch(arguments.length){
case 2:
return G__70942__2.call(this,m,dim);
case 3:
return G__70942__3.call(this,m,dim,indices);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__70942.cljs$core$IFn$_invoke$arity$2 = G__70942__2;
G__70942.cljs$core$IFn$_invoke$arity$3 = G__70942__3;
return G__70942;
})()
;})(G__67204_70938,G__67205_70939))
;
goog.object.set(G__67204_70938,G__67205_70939,G__67206_70940);

goog.object.set(clojure.core.matrix.protocols.POrder,"number",true);

var G__67208_70948 = clojure.core.matrix.protocols.order;
var G__67209_70949 = "number";
var G__67210_70950 = ((function (G__67208_70948,G__67209_70949){
return (function() {
var G__70951 = null;
var G__70951__2 = (function (m,indices){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't reorder a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});
var G__70951__3 = (function (m,dim,indices){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't reorder a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});
G__70951 = function(m,dim,indices){
switch(arguments.length){
case 2:
return G__70951__2.call(this,m,dim);
case 3:
return G__70951__3.call(this,m,dim,indices);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__70951.cljs$core$IFn$_invoke$arity$2 = G__70951__2;
G__70951.cljs$core$IFn$_invoke$arity$3 = G__70951__3;
return G__70951;
})()
;})(G__67208_70948,G__67209_70949))
;
goog.object.set(G__67208_70948,G__67209_70949,G__67210_70950);

goog.object.set(clojure.core.matrix.protocols.POrder,"object",true);

var G__67213_70962 = clojure.core.matrix.protocols.order;
var G__67214_70963 = "object";
var G__67215_70964 = ((function (G__67213_70962,G__67214_70963){
return (function() {
var G__70965 = null;
var G__70965__2 = (function (m,indices){
var mshape = cljs.core.vec(clojure.core.matrix.protocols.get_shape(m));
var subshape = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,(0),(1));
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (mshape,subshape,G__67213_70962,G__67214_70963){
return (function (p1__67197_SHARP_){
return clojure.core.matrix.protocols.broadcast(clojure.core.matrix.protocols.get_major_slice(m,p1__67197_SHARP_),subshape);
});})(mshape,subshape,G__67213_70962,G__67214_70963))
,indices);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (mshape,subshape,ss,G__67213_70962,G__67214_70963){
return (function (p1__67199_SHARP_,p2__67202_SHARP_){
return clojure.core.matrix.protocols.join(p1__67199_SHARP_,p2__67202_SHARP_);
});})(mshape,subshape,ss,G__67213_70962,G__67214_70963))
,ss);
});
var G__70965__3 = (function (m,dim,indices){
return clojure.core.matrix.protocols.order.cljs$core$IFn$_invoke$arity$3(clojure.core.matrix.protocols.convert_to_nested_vectors(m),dim,indices);
});
G__70965 = function(m,dim,indices){
switch(arguments.length){
case 2:
return G__70965__2.call(this,m,dim);
case 3:
return G__70965__3.call(this,m,dim,indices);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__70965.cljs$core$IFn$_invoke$arity$2 = G__70965__2;
G__70965.cljs$core$IFn$_invoke$arity$3 = G__70965__3;
return G__70965;
})()
;})(G__67213_70962,G__67214_70963))
;
goog.object.set(G__67213_70962,G__67214_70963,G__67215_70964);
/**
 * Outputs a vector containing the rank of array elements, given a sorted sequence of [index value] pairs and a length
 */
clojure.core.matrix.impl.defaults.output_rank = (function clojure$core$matrix$impl$defaults$output_rank(pairs,n){
var dest = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(n);
var i_70975 = cljs.core.long$((0));
var pairs_70976__$1 = cljs.core.seq(pairs);
while(true){
if((i_70975 < n)){
(dest[cljs.core.first(cljs.core.first(pairs_70976__$1))] = Long.valueOf(i_70975));

var G__70977 = (i_70975 + (1));
var G__70978 = cljs.core.next(pairs_70976__$1);
i_70975 = G__70977;
pairs_70976__$1 = G__70978;
continue;
} else {
}
break;
}

return cljs.core.vec(dest);
});
goog.object.set(clojure.core.matrix.protocols.PIndexRank,"object",true);

var G__67227_70981 = clojure.core.matrix.protocols.index_rank;
var G__67228_70982 = "object";
var G__67229_70983 = ((function (G__67227_70981,G__67228_70982){
return (function() {
var G__70984 = null;
var G__70984__1 = (function (m){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
var G__67232 = dims;
switch (G__67232) {
case (0):
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't get indexed rank of a scalar value",cljs.core.PersistentArrayMap.EMPTY);

break;
case (1):
var n = cljs.core.long$(clojure.core.matrix.protocols.element_count(m));
return clojure.core.matrix.impl.defaults.output_rank(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.second,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.element_count(m)),clojure.core.matrix.protocols.element_seq(m))),n);

break;
default:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.index_rank,clojure.core.matrix.protocols.get_major_slice_seq(m));

}
});
var G__70984__2 = (function (m,comp){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
var G__67238 = dims;
switch (G__67238) {
case (0):
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't get indexed rank of a scalar value",cljs.core.PersistentArrayMap.EMPTY);

break;
case (1):
var n = cljs.core.long$(clojure.core.matrix.protocols.element_count(m));
return clojure.core.matrix.impl.defaults.output_rank(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.second,comp,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.element_count(m)),clojure.core.matrix.protocols.element_seq(m))),n);

break;
default:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__67238,dims,G__67227_70981,G__67228_70982){
return (function (p1__67225_SHARP_){
return clojure.core.matrix.protocols.index_rank.cljs$core$IFn$_invoke$arity$2(p1__67225_SHARP_,comp);
});})(G__67238,dims,G__67227_70981,G__67228_70982))
,clojure.core.matrix.protocols.get_major_slice_seq(m));

}
});
G__70984 = function(m,comp){
switch(arguments.length){
case 1:
return G__70984__1.call(this,m);
case 2:
return G__70984__2.call(this,m,comp);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__70984.cljs$core$IFn$_invoke$arity$1 = G__70984__1;
G__70984.cljs$core$IFn$_invoke$arity$2 = G__70984__2;
return G__70984;
})()
;})(G__67227_70981,G__67228_70982))
;
goog.object.set(G__67227_70981,G__67228_70982,G__67229_70983);
goog.object.set(clojure.core.matrix.protocols.PMatrixProducts,"number",true);

var G__67248_71032 = clojure.core.matrix.protocols.inner_product;
var G__67249_71033 = "number";
var G__67250_71034 = ((function (G__67248_71032,G__67249_71033){
return (function (m,a){
if(typeof a === 'number'){
return (m * a);
} else {
return clojure.core.matrix.protocols.pre_scale(a,m);
}
});})(G__67248_71032,G__67249_71033))
;
goog.object.set(G__67248_71032,G__67249_71033,G__67250_71034);

var G__67256_71040 = clojure.core.matrix.protocols.outer_product;
var G__67257_71041 = "number";
var G__67258_71042 = ((function (G__67256_71040,G__67257_71041){
return (function (m,a){
if(typeof a === 'number'){
return (m * a);
} else {
return clojure.core.matrix.protocols.pre_scale(a,m);
}
});})(G__67256_71040,G__67257_71041))
;
goog.object.set(G__67256_71040,G__67257_71041,G__67258_71042);

goog.object.set(clojure.core.matrix.protocols.PMatrixProducts,"object",true);

var G__67260_71045 = clojure.core.matrix.protocols.inner_product;
var G__67261_71046 = "object";
var G__67262_71047 = ((function (G__67260_71045,G__67261_71046){
return (function (m,a){
if(cljs.core.truth_(clojure.core.matrix.protocols.is_scalar_QMARK_(m))){
return clojure.core.matrix.protocols.pre_scale(a,m);
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.is_scalar_QMARK_(a))){
return clojure.core.matrix.protocols.scale(m,a);
} else {
if(((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))){
if(((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a)))){
return clojure.core.matrix.protocols.element_sum(clojure.core.matrix.protocols.element_multiply(m,a));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.matrix_add,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (G__67260_71045,G__67261_71046){
return (function (sl,x){
return clojure.core.matrix.protocols.scale(sl,x);
});})(G__67260_71045,G__67261_71046))
,clojure.core.matrix.protocols.get_major_slice_seq(a),clojure.core.matrix.protocols.get_major_slice_seq(m)));
}
} else {
return clojure.core.matrix.protocols.construct_matrix(clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$0(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__67260_71045,G__67261_71046){
return (function (p1__67240_SHARP_){
return clojure.core.matrix.protocols.inner_product(p1__67240_SHARP_,a);
});})(G__67260_71045,G__67261_71046))
,clojure.core.matrix.protocols.get_major_slice_seq(m)));

}
}
}
});})(G__67260_71045,G__67261_71046))
;
goog.object.set(G__67260_71045,G__67261_71046,G__67262_71047);

var G__67267_71064 = clojure.core.matrix.protocols.outer_product;
var G__67268_71065 = "object";
var G__67269_71066 = ((function (G__67267_71064,G__67268_71065){
return (function (m,a){
if(cljs.core.truth_(clojure.core.matrix.protocols.is_scalar_QMARK_(m))){
return clojure.core.matrix.protocols.pre_scale(a,m);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.convert_to_nested_vectors(m),((function (G__67267_71064,G__67268_71065){
return (function (x){
return clojure.core.matrix.protocols.pre_scale(a,x);
});})(G__67267_71064,G__67268_71065))
);

}
});})(G__67267_71064,G__67268_71065))
;
goog.object.set(G__67267_71064,G__67268_71065,G__67269_71066);
goog.object.set(clojure.core.matrix.protocols.PMatrixMultiply,"number",true);

var G__67280_71074 = clojure.core.matrix.protocols.element_multiply;
var G__67281_71075 = "number";
var G__67282_71076 = ((function (G__67280_71074,G__67281_71075){
return (function (m,a){
if(typeof a === 'number'){
return (m * a);
} else {
return clojure.core.matrix.protocols.pre_scale(a,m);
}
});})(G__67280_71074,G__67281_71075))
;
goog.object.set(G__67280_71074,G__67281_71075,G__67282_71076);

var G__67290_71079 = clojure.core.matrix.protocols.matrix_multiply;
var G__67291_71080 = "number";
var G__67292_71081 = ((function (G__67290_71079,G__67291_71080){
return (function (m,a){
if(typeof a === 'number'){
return (m * a);
} else {
if(cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(a))){
return clojure.core.matrix.protocols.pre_scale(a,m);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Don't know how to multiply number with: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(a))].join(''),cljs.core.PersistentArrayMap.EMPTY);

}
}
});})(G__67290_71079,G__67291_71080))
;
goog.object.set(G__67290_71079,G__67291_71080,G__67292_71081);

goog.object.set(clojure.core.matrix.protocols.PMatrixMultiply,"object",true);

var G__67300_71087 = clojure.core.matrix.protocols.matrix_multiply;
var G__67301_71088 = "object";
var G__67302_71089 = ((function (G__67300_71087,G__67301_71088){
return (function (m,a){
var mdims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
var adims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a));
if((adims === (0))){
return clojure.core.matrix.protocols.scale(m,a);
} else {
if((((mdims === (1))) && ((adims === (1))))){
return clojure.core.matrix.protocols.vector_dot(m,a);
} else {
if((((mdims === (1))) && ((adims === (2))))){
var vec__67309 = clojure.core.matrix.protocols.get_shape(a);
var arows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67309,(0),null);
var acols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67309,(1),null);
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.matrix_multiply(clojure.core.matrix.protocols.reshape(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),arows], null)),a),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acols], null));
} else {
if((((mdims === (2))) && ((adims === (1))))){
var mshape = clojure.core.matrix.protocols.get_shape(m);
var vec__67313 = mshape;
var mrows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67313,(0),null);
var mcols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67313,(1),null);
var acount = clojure.core.matrix.protocols.element_count(a);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(mcols,acount)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't multiply matrix of shape: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(mshape)," with a vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(acount)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.matrix_multiply(m,clojure.core.matrix.protocols.reshape(a,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mcols,(1)], null))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [mrows], null));
} else {
if((((mdims === (2))) && ((adims === (2))))){
var mutable = clojure.core.matrix.protocols.is_mutable_QMARK_(m);
var vec__67316 = clojure.core.matrix.protocols.get_shape(m);
var mrows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67316,(0),null);
var mcols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67316,(1),null);
var vec__67319 = clojure.core.matrix.protocols.get_shape(a);
var arows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67319,(0),null);
var acols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67319,(1),null);
var new_m_type = (cljs.core.truth_(mutable)?m:clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"ndarray","ndarray",1659822393)));
var new_m = clojure.core.matrix.protocols.new_matrix(new_m_type,mrows,acols);
var i_71106 = cljs.core.long$((0));
while(true){
if((i_71106 < mrows)){
var j_71108 = cljs.core.long$((0));
while(true){
if((j_71108 < acols)){
clojure.core.matrix.protocols.set_2d_BANG_(new_m,i_71106,j_71108,(0));

var G__71109 = (j_71108 + (1));
j_71108 = G__71109;
continue;
} else {
}
break;
}

var G__71110 = (i_71106 + (1));
i_71106 = G__71110;
continue;
} else {
}
break;
}


var i_71111 = cljs.core.long$((0));
while(true){
if((i_71111 < mrows)){
var j_71112 = cljs.core.long$((0));
while(true){
if((j_71112 < acols)){
var k_71114 = cljs.core.long$((0));
while(true){
if((k_71114 < mcols)){
clojure.core.matrix.protocols.set_2d_BANG_(new_m,i_71111,j_71112,(clojure.core.matrix.protocols.get_2d(new_m,i_71111,j_71112) + (clojure.core.matrix.protocols.get_2d(m,i_71111,k_71114) * clojure.core.matrix.protocols.get_2d(a,k_71114,j_71112))));

var G__71115 = (k_71114 + (1));
k_71114 = G__71115;
continue;
} else {
}
break;
}

var G__71116 = (j_71112 + (1));
j_71112 = G__71116;
continue;
} else {
}
break;
}

var G__71118 = (i_71111 + (1));
i_71111 = G__71118;
continue;
} else {
}
break;
}


return new_m;
} else {
return null;
}
}
}
}
}
});})(G__67300_71087,G__67301_71088))
;
goog.object.set(G__67300_71087,G__67301_71088,G__67302_71089);

var G__67328_71119 = clojure.core.matrix.protocols.element_multiply;
var G__67329_71120 = "object";
var G__67330_71121 = ((function (G__67328_71119,G__67329_71120){
return (function (m,a){
if(typeof a === 'number'){
return clojure.core.matrix.protocols.scale(m,a);
} else {
var vec__67331 = clojure.core.matrix.protocols.broadcast_compatible(m,a);
var m__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67331,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67331,(1),null);
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core._STAR_,a__$1);
}
});})(G__67328_71119,G__67329_71120))
;
goog.object.set(G__67328_71119,G__67329_71120,G__67330_71121);
goog.object.set(clojure.core.matrix.protocols.PMatrixMultiplyMutable,"number",true);

var G__67345_71123 = clojure.core.matrix.protocols.element_multiply_BANG_;
var G__67346_71124 = "number";
var G__67347_71125 = ((function (G__67345_71123,G__67346_71124){
return (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do mutable multiply on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67345_71123,G__67346_71124))
;
goog.object.set(G__67345_71123,G__67346_71124,G__67347_71125);

var G__67348_71128 = clojure.core.matrix.protocols.matrix_multiply_BANG_;
var G__67349_71129 = "number";
var G__67350_71130 = ((function (G__67348_71128,G__67349_71129){
return (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do mutable multiply on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67348_71128,G__67349_71129))
;
goog.object.set(G__67348_71128,G__67349_71129,G__67350_71130);

goog.object.set(clojure.core.matrix.protocols.PMatrixMultiplyMutable,"object",true);

var G__67352_71132 = clojure.core.matrix.protocols.element_multiply_BANG_;
var G__67353_71133 = "object";
var G__67354_71134 = ((function (G__67352_71132,G__67353_71133){
return (function (m,a){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_multiply(m,a));
});})(G__67352_71132,G__67353_71133))
;
goog.object.set(G__67352_71132,G__67353_71133,G__67354_71134);

var G__67357_71135 = clojure.core.matrix.protocols.matrix_multiply_BANG_;
var G__67358_71136 = "object";
var G__67359_71137 = ((function (G__67357_71135,G__67358_71136){
return (function (m,a){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.matrix_multiply(m,a));
});})(G__67357_71135,G__67358_71136))
;
goog.object.set(G__67357_71135,G__67358_71136,G__67359_71137);
goog.object.set(clojure.core.matrix.protocols.PMatrixDivide,"number",true);

var G__67362_71143 = clojure.core.matrix.protocols.element_divide;
var G__67363_71144 = "number";
var G__67364_71145 = ((function (G__67362_71143,G__67363_71144){
return (function() {
var G__71146 = null;
var G__71146__1 = (function (m){
return ((1) / m);
});
var G__71146__2 = (function (m,a){
return clojure.core.matrix.protocols.pre_scale(clojure.core.matrix.protocols.element_divide.cljs$core$IFn$_invoke$arity$1(a),m);
});
G__71146 = function(m,a){
switch(arguments.length){
case 1:
return G__71146__1.call(this,m);
case 2:
return G__71146__2.call(this,m,a);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71146.cljs$core$IFn$_invoke$arity$1 = G__71146__1;
G__71146.cljs$core$IFn$_invoke$arity$2 = G__71146__2;
return G__71146;
})()
;})(G__67362_71143,G__67363_71144))
;
goog.object.set(G__67362_71143,G__67363_71144,G__67364_71145);

goog.object.set(clojure.core.matrix.protocols.PMatrixDivide,"object",true);

var G__67370_71156 = clojure.core.matrix.protocols.element_divide;
var G__67371_71157 = "object";
var G__67372_71158 = ((function (G__67370_71156,G__67371_71157){
return (function() {
var G__71159 = null;
var G__71159__1 = (function (m){
if(cljs.core.truth_(clojure.core.matrix.protocols.get_shape(m))){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.protocols.element_divide);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Don't know how to take reciprocal of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(m))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});
var G__71159__2 = (function (m,a){
return clojure.core.matrix.protocols.element_multiply(m,clojure.core.matrix.protocols.element_divide.cljs$core$IFn$_invoke$arity$1(a));
});
G__71159 = function(m,a){
switch(arguments.length){
case 1:
return G__71159__1.call(this,m);
case 2:
return G__71159__2.call(this,m,a);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71159.cljs$core$IFn$_invoke$arity$1 = G__71159__1;
G__71159.cljs$core$IFn$_invoke$arity$2 = G__71159__2;
return G__71159;
})()
;})(G__67370_71156,G__67371_71157))
;
goog.object.set(G__67370_71156,G__67371_71157,G__67372_71158);
goog.object.set(clojure.core.matrix.protocols.PMatrixDivideMutable,"number",true);

var G__67375_71163 = clojure.core.matrix.protocols.element_divide_BANG_;
var G__67376_71164 = "number";
var G__67377_71165 = ((function (G__67375_71163,G__67376_71164){
return (function() {
var G__71166 = null;
var G__71166__1 = (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do mutable divide on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71166__2 = (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do mutable divide on a scalar numer",cljs.core.PersistentArrayMap.EMPTY);
});
G__71166 = function(m,a){
switch(arguments.length){
case 1:
return G__71166__1.call(this,m);
case 2:
return G__71166__2.call(this,m,a);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71166.cljs$core$IFn$_invoke$arity$1 = G__71166__1;
G__71166.cljs$core$IFn$_invoke$arity$2 = G__71166__2;
return G__71166;
})()
;})(G__67375_71163,G__67376_71164))
;
goog.object.set(G__67375_71163,G__67376_71164,G__67377_71165);

goog.object.set(clojure.core.matrix.protocols.PMatrixDivideMutable,"object",true);

var G__67378_71168 = clojure.core.matrix.protocols.element_divide_BANG_;
var G__67379_71169 = "object";
var G__67380_71170 = ((function (G__67378_71168,G__67379_71169){
return (function() {
var G__71171 = null;
var G__71171__1 = (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,cljs.core._SLASH_);
});
var G__71171__2 = (function (m,a){
var vec__67381 = clojure.core.matrix.protocols.broadcast_compatible(m,a);
var m__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67381,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67381,(1),null);
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core._SLASH_,a__$1);
});
G__71171 = function(m,a){
switch(arguments.length){
case 1:
return G__71171__1.call(this,m);
case 2:
return G__71171__2.call(this,m,a);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71171.cljs$core$IFn$_invoke$arity$1 = G__71171__1;
G__71171.cljs$core$IFn$_invoke$arity$2 = G__71171__2;
return G__71171;
})()
;})(G__67378_71168,G__67379_71169))
;
goog.object.set(G__67378_71168,G__67379_71169,G__67380_71170);
goog.object.set(clojure.core.matrix.protocols.PSummable,"number",true);

var G__67388_71174 = clojure.core.matrix.protocols.element_sum;
var G__67389_71175 = "number";
var G__67390_71176 = ((function (G__67388_71174,G__67389_71175){
return (function (a){
return a;
});})(G__67388_71174,G__67389_71175))
;
goog.object.set(G__67388_71174,G__67389_71175,G__67390_71176);

goog.object.set(clojure.core.matrix.protocols.PSummable,"object",true);

var G__67391_71182 = clojure.core.matrix.protocols.element_sum;
var G__67392_71183 = "object";
var G__67393_71184 = ((function (G__67391_71182,G__67392_71183){
return (function (a){
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$2(a,(cljs.core.truth_(clojure.core.matrix.protocols.numerical_QMARK_(a))?cljs.core._PLUS_:clojure.core.matrix.protocols.matrix_add));
});})(G__67391_71182,G__67392_71183))
;
goog.object.set(G__67391_71182,G__67392_71183,G__67393_71184);
goog.object.set(clojure.core.matrix.protocols.PElementMinMax,"number",true);

var G__67406_71186 = clojure.core.matrix.protocols.element_min;
var G__67407_71187 = "number";
var G__67408_71188 = ((function (G__67406_71186,G__67407_71187){
return (function (m){
return m;
});})(G__67406_71186,G__67407_71187))
;
goog.object.set(G__67406_71186,G__67407_71187,G__67408_71188);

var G__67409_71189 = clojure.core.matrix.protocols.element_max;
var G__67410_71190 = "number";
var G__67411_71191 = ((function (G__67409_71189,G__67410_71190){
return (function (m){
return m;
});})(G__67409_71189,G__67410_71190))
;
goog.object.set(G__67409_71189,G__67410_71190,G__67411_71191);

var G__67413_71193 = clojure.core.matrix.protocols.element_clamp;
var G__67414_71194 = "number";
var G__67415_71195 = ((function (G__67413_71193,G__67414_71194){
return (function (m,a,b){
if((!((a <= b)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["min argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(a)," should be <= max argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(b)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
if((m < a)){
return a;
} else {
if((m > b)){
return b;
} else {
return m;
}
}
}
});})(G__67413_71193,G__67414_71194))
;
goog.object.set(G__67413_71193,G__67414_71194,G__67415_71195);

goog.object.set(clojure.core.matrix.protocols.PElementMinMax,"object",true);

var G__67420_71196 = clojure.core.matrix.protocols.element_min;
var G__67421_71197 = "object";
var G__67422_71198 = ((function (G__67420_71196,G__67421_71197){
return (function (m){
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$3(m,((function (G__67420_71196,G__67421_71197){
return (function (best,v){
if(((cljs.core.not(best)) || ((v < best)))){
return v;
} else {
return best;
}
});})(G__67420_71196,G__67421_71197))
,null);
});})(G__67420_71196,G__67421_71197))
;
goog.object.set(G__67420_71196,G__67421_71197,G__67422_71198);

var G__67427_71204 = clojure.core.matrix.protocols.element_max;
var G__67428_71205 = "object";
var G__67429_71206 = ((function (G__67427_71204,G__67428_71205){
return (function (m){
return clojure.core.matrix.protocols.element_reduce.cljs$core$IFn$_invoke$arity$3(m,((function (G__67427_71204,G__67428_71205){
return (function (best,v){
if(((cljs.core.not(best)) || ((v > best)))){
return v;
} else {
return best;
}
});})(G__67427_71204,G__67428_71205))
,null);
});})(G__67427_71204,G__67428_71205))
;
goog.object.set(G__67427_71204,G__67428_71205,G__67429_71206);

var G__67431_71210 = clojure.core.matrix.protocols.element_clamp;
var G__67432_71211 = "object";
var G__67433_71212 = ((function (G__67431_71210,G__67432_71211){
return (function (m,a,b){
if((!((a <= b)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["min argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(a)," should be <= max argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(b)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67431_71210,G__67432_71211){
return (function (p1__67405_SHARP_){
if((p1__67405_SHARP_ < a)){
return a;
} else {
if((p1__67405_SHARP_ > b)){
return b;
} else {
return p1__67405_SHARP_;
}
}
});})(G__67431_71210,G__67432_71211))
);
}
});})(G__67431_71210,G__67432_71211))
;
goog.object.set(G__67431_71210,G__67432_71211,G__67433_71212);
goog.object.set(clojure.core.matrix.protocols.PCompare,"number",true);

var G__67467_71214 = clojure.core.matrix.protocols.element_compare;
var G__67468_71215 = "number";
var G__67469_71216 = ((function (G__67467_71214,G__67468_71215){
return (function (a,b){
if(typeof b === 'number'){
return cljs.core.long$(clojure.core.matrix.impl.mathsops.signum((a - b)));
} else {
return clojure.core.matrix.protocols.signum(clojure.core.matrix.protocols.matrix_sub(a,b));
}
});})(G__67467_71214,G__67468_71215))
;
goog.object.set(G__67467_71214,G__67468_71215,G__67469_71216);

var G__67476_71218 = clojure.core.matrix.protocols.element_if;
var G__67477_71219 = "number";
var G__67478_71220 = ((function (G__67476_71218,G__67477_71219){
return (function (m,a,b){
var vec__67484 = clojure.core.matrix.protocols.broadcast_same_shape(a,b);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67484,(0),null);
var b__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67484,(1),null);
if((m > (0))){
return a__$1;
} else {
return b__$1;
}
});})(G__67476_71218,G__67477_71219))
;
goog.object.set(G__67476_71218,G__67477_71219,G__67478_71220);

var G__67487_71222 = clojure.core.matrix.protocols.element_lt;
var G__67488_71223 = "number";
var G__67489_71224 = ((function (G__67487_71222,G__67488_71223){
return (function (m,a){
if(typeof a === 'number'){
if((m < a)){
return (1);
} else {
return (0);
}
} else {
return clojure.core.matrix.protocols.element_gt(a,m);
}
});})(G__67487_71222,G__67488_71223))
;
goog.object.set(G__67487_71222,G__67488_71223,G__67489_71224);

var G__67491_71232 = clojure.core.matrix.protocols.element_le;
var G__67492_71233 = "number";
var G__67493_71234 = ((function (G__67491_71232,G__67492_71233){
return (function (m,a){
if(typeof a === 'number'){
if((m <= a)){
return (1);
} else {
return (0);
}
} else {
return clojure.core.matrix.protocols.element_ge(a,m);
}
});})(G__67491_71232,G__67492_71233))
;
goog.object.set(G__67491_71232,G__67492_71233,G__67493_71234);

var G__67495_71235 = clojure.core.matrix.protocols.element_gt;
var G__67496_71236 = "number";
var G__67497_71237 = ((function (G__67495_71235,G__67496_71236){
return (function (m,a){
if(typeof a === 'number'){
if((m > a)){
return (1);
} else {
return (0);
}
} else {
return clojure.core.matrix.protocols.element_lt(a,m);
}
});})(G__67495_71235,G__67496_71236))
;
goog.object.set(G__67495_71235,G__67496_71236,G__67497_71237);

var G__67500_71239 = clojure.core.matrix.protocols.element_ge;
var G__67501_71240 = "number";
var G__67502_71241 = ((function (G__67500_71239,G__67501_71240){
return (function (m,a){
if(typeof a === 'number'){
if((m >= a)){
return (1);
} else {
return (0);
}
} else {
return clojure.core.matrix.protocols.element_le(a,m);
}
});})(G__67500_71239,G__67501_71240))
;
goog.object.set(G__67500_71239,G__67501_71240,G__67502_71241);

var G__67504_71244 = clojure.core.matrix.protocols.element_ne;
var G__67508_71245 = "number";
var G__67509_71246 = ((function (G__67504_71244,G__67508_71245){
return (function (m,a){
if(typeof a === 'number'){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(m,a)){
return (1);
} else {
return (0);
}
} else {
return clojure.core.matrix.protocols.element_ne(a,m);
}
});})(G__67504_71244,G__67508_71245))
;
goog.object.set(G__67504_71244,G__67508_71245,G__67509_71246);

var G__67512_71249 = clojure.core.matrix.protocols.element_eq;
var G__67513_71250 = "number";
var G__67514_71251 = ((function (G__67512_71249,G__67513_71250){
return (function (m,a){
if(typeof a === 'number'){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(m,a)){
return (1);
} else {
return (0);
}
} else {
return clojure.core.matrix.protocols.element_eq(a,m);
}
});})(G__67512_71249,G__67513_71250))
;
goog.object.set(G__67512_71249,G__67513_71250,G__67514_71251);

goog.object.set(clojure.core.matrix.protocols.PCompare,"object",true);

var G__67515_71252 = clojure.core.matrix.protocols.element_compare;
var G__67516_71253 = "object";
var G__67517_71254 = ((function (G__67515_71252,G__67516_71253){
return (function (a,b){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.matrix_sub(a,b),((function (G__67515_71252,G__67516_71253){
return (function (p1__67436_SHARP_){
return cljs.core.long$(clojure.core.matrix.impl.mathsops.signum(p1__67436_SHARP_));
});})(G__67515_71252,G__67516_71253))
);
});})(G__67515_71252,G__67516_71253))
;
goog.object.set(G__67515_71252,G__67516_71253,G__67517_71254);

var G__67520_71257 = clojure.core.matrix.protocols.element_if;
var G__67521_71258 = "object";
var G__67522_71259 = ((function (G__67520_71257,G__67521_71258){
return (function (m,a,b){
if(((typeof a === 'number') && (typeof b === 'number'))){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67520_71257,G__67521_71258){
return (function (p1__67437_SHARP_){
if((p1__67437_SHARP_ > (0))){
return a;
} else {
return b;
}
});})(G__67520_71257,G__67521_71258))
);
} else {
if(typeof a === 'number'){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__67520_71257,G__67521_71258){
return (function (p1__67438_SHARP_,p2__67439_SHARP_){
if((p1__67438_SHARP_ > (0))){
return a;
} else {
return p2__67439_SHARP_;
}
});})(G__67520_71257,G__67521_71258))
,b);
} else {
if(typeof b === 'number'){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__67520_71257,G__67521_71258){
return (function (p1__67441_SHARP_,p2__67442_SHARP_){
if((p1__67441_SHARP_ > (0))){
return p2__67442_SHARP_;
} else {
return b;
}
});})(G__67520_71257,G__67521_71258))
,a);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$4(m,((function (G__67520_71257,G__67521_71258){
return (function (p1__67443_SHARP_,p2__67444_SHARP_,p3__67445_SHARP_){
if((p1__67443_SHARP_ > (0))){
return p2__67444_SHARP_;
} else {
return p3__67445_SHARP_;
}
});})(G__67520_71257,G__67521_71258))
,a,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [b], null));

}
}
}
});})(G__67520_71257,G__67521_71258))
;
goog.object.set(G__67520_71257,G__67521_71258,G__67522_71259);

var G__67527_71267 = clojure.core.matrix.protocols.element_lt;
var G__67528_71268 = "object";
var G__67529_71269 = ((function (G__67527_71267,G__67528_71268){
return (function (m,a){
if(typeof a === 'number'){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67527_71267,G__67528_71268){
return (function (p1__67446_SHARP_){
if((p1__67446_SHARP_ < a)){
return (1);
} else {
return (0);
}
});})(G__67527_71267,G__67528_71268))
);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__67527_71267,G__67528_71268){
return (function (p1__67448_SHARP_,p2__67449_SHARP_){
if((p1__67448_SHARP_ < p2__67449_SHARP_)){
return (1);
} else {
return (0);
}
});})(G__67527_71267,G__67528_71268))
,a);
}
});})(G__67527_71267,G__67528_71268))
;
goog.object.set(G__67527_71267,G__67528_71268,G__67529_71269);

var G__67531_71279 = clojure.core.matrix.protocols.element_le;
var G__67532_71280 = "object";
var G__67533_71281 = ((function (G__67531_71279,G__67532_71280){
return (function (m,a){
if(typeof a === 'number'){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67531_71279,G__67532_71280){
return (function (p1__67450_SHARP_){
if((p1__67450_SHARP_ <= a)){
return (1);
} else {
return (0);
}
});})(G__67531_71279,G__67532_71280))
);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__67531_71279,G__67532_71280){
return (function (p1__67451_SHARP_,p2__67452_SHARP_){
if((p1__67451_SHARP_ <= p2__67452_SHARP_)){
return (1);
} else {
return (0);
}
});})(G__67531_71279,G__67532_71280))
,a);
}
});})(G__67531_71279,G__67532_71280))
;
goog.object.set(G__67531_71279,G__67532_71280,G__67533_71281);

var G__67544_71284 = clojure.core.matrix.protocols.element_gt;
var G__67545_71285 = "object";
var G__67546_71286 = ((function (G__67544_71284,G__67545_71285){
return (function (m,a){
if(typeof a === 'number'){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67544_71284,G__67545_71285){
return (function (p1__67453_SHARP_){
if((p1__67453_SHARP_ > a)){
return (1);
} else {
return (0);
}
});})(G__67544_71284,G__67545_71285))
);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__67544_71284,G__67545_71285){
return (function (p1__67455_SHARP_,p2__67456_SHARP_){
if((p1__67455_SHARP_ > p2__67456_SHARP_)){
return (1);
} else {
return (0);
}
});})(G__67544_71284,G__67545_71285))
,a);
}
});})(G__67544_71284,G__67545_71285))
;
goog.object.set(G__67544_71284,G__67545_71285,G__67546_71286);

var G__67548_71289 = clojure.core.matrix.protocols.element_ge;
var G__67549_71290 = "object";
var G__67550_71291 = ((function (G__67548_71289,G__67549_71290){
return (function (m,a){
if(typeof a === 'number'){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67548_71289,G__67549_71290){
return (function (p1__67457_SHARP_){
if((p1__67457_SHARP_ >= a)){
return (1);
} else {
return (0);
}
});})(G__67548_71289,G__67549_71290))
);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__67548_71289,G__67549_71290){
return (function (p1__67458_SHARP_,p2__67459_SHARP_){
if((p1__67458_SHARP_ >= p2__67459_SHARP_)){
return (1);
} else {
return (0);
}
});})(G__67548_71289,G__67549_71290))
,a);
}
});})(G__67548_71289,G__67549_71290))
;
goog.object.set(G__67548_71289,G__67549_71290,G__67550_71291);

var G__67554_71294 = clojure.core.matrix.protocols.element_ne;
var G__67555_71295 = "object";
var G__67556_71296 = ((function (G__67554_71294,G__67555_71295){
return (function (m,a){
if(typeof a === 'number'){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67554_71294,G__67555_71295){
return (function (p1__67460_SHARP_){
if((!((p1__67460_SHARP_ === a)))){
return (1);
} else {
return (0);
}
});})(G__67554_71294,G__67555_71295))
);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__67554_71294,G__67555_71295){
return (function (p1__67461_SHARP_,p2__67462_SHARP_){
if((!((p1__67461_SHARP_ === p2__67462_SHARP_)))){
return (1);
} else {
return (0);
}
});})(G__67554_71294,G__67555_71295))
,a);
}
});})(G__67554_71294,G__67555_71295))
;
goog.object.set(G__67554_71294,G__67555_71295,G__67556_71296);

var G__67558_71305 = clojure.core.matrix.protocols.element_eq;
var G__67559_71306 = "object";
var G__67560_71307 = ((function (G__67558_71305,G__67559_71306){
return (function (m,a){
if(typeof a === 'number'){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67558_71305,G__67559_71306){
return (function (p1__67464_SHARP_){
if((p1__67464_SHARP_ === a)){
return (1);
} else {
return (0);
}
});})(G__67558_71305,G__67559_71306))
);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__67558_71305,G__67559_71306){
return (function (p1__67465_SHARP_,p2__67466_SHARP_){
if((p1__67465_SHARP_ === p2__67466_SHARP_)){
return (1);
} else {
return (0);
}
});})(G__67558_71305,G__67559_71306))
,a);
}
});})(G__67558_71305,G__67559_71306))
;
goog.object.set(G__67558_71305,G__67559_71306,G__67560_71307);
goog.object.set(clojure.core.matrix.protocols.PAddProduct,"number",true);

var G__67563_71311 = clojure.core.matrix.protocols.add_product;
var G__67564_71312 = "number";
var G__67565_71313 = ((function (G__67563_71311,G__67564_71312){
return (function (m,a,b){
return clojure.core.matrix.protocols.matrix_add(clojure.core.matrix.protocols.element_multiply(a,b),m);
});})(G__67563_71311,G__67564_71312))
;
goog.object.set(G__67563_71311,G__67564_71312,G__67565_71313);

goog.object.set(clojure.core.matrix.protocols.PAddProduct,"object",true);

var G__67567_71315 = clojure.core.matrix.protocols.add_product;
var G__67568_71316 = "object";
var G__67569_71317 = ((function (G__67567_71315,G__67568_71316){
return (function (m,a,b){
return clojure.core.matrix.protocols.matrix_add(m,clojure.core.matrix.protocols.element_multiply(a,b));
});})(G__67567_71315,G__67568_71316))
;
goog.object.set(G__67567_71315,G__67568_71316,G__67569_71317);
goog.object.set(clojure.core.matrix.protocols.PAddProductMutable,"number",true);

var G__67576_71319 = clojure.core.matrix.protocols.add_product_BANG_;
var G__67577_71320 = "number";
var G__67578_71321 = ((function (G__67576_71319,G__67577_71320){
return (function (m,a,b){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Numbers are not mutable",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67576_71319,G__67577_71320))
;
goog.object.set(G__67576_71319,G__67577_71320,G__67578_71321);

goog.object.set(clojure.core.matrix.protocols.PAddProductMutable,"object",true);

var G__67579_71324 = clojure.core.matrix.protocols.add_product_BANG_;
var G__67580_71325 = "object";
var G__67581_71326 = ((function (G__67579_71324,G__67580_71325){
return (function (m,a,b){
return clojure.core.matrix.protocols.matrix_add_BANG_(m,clojure.core.matrix.protocols.element_multiply(a,b));
});})(G__67579_71324,G__67580_71325))
;
goog.object.set(G__67579_71324,G__67580_71325,G__67581_71326);
goog.object.set(clojure.core.matrix.protocols.PAddScaled,"number",true);

var G__67588_71328 = clojure.core.matrix.protocols.add_scaled;
var G__67589_71329 = "number";
var G__67590_71330 = ((function (G__67588_71328,G__67589_71329){
return (function (m,a,factor){
return clojure.core.matrix.protocols.matrix_add(clojure.core.matrix.protocols.scale(a,factor),m);
});})(G__67588_71328,G__67589_71329))
;
goog.object.set(G__67588_71328,G__67589_71329,G__67590_71330);

goog.object.set(clojure.core.matrix.protocols.PAddScaled,"object",true);

var G__67591_71333 = clojure.core.matrix.protocols.add_scaled;
var G__67592_71334 = "object";
var G__67593_71335 = ((function (G__67591_71333,G__67592_71334){
return (function (m,a,factor){
return clojure.core.matrix.protocols.matrix_add(m,clojure.core.matrix.protocols.scale(a,factor));
});})(G__67591_71333,G__67592_71334))
;
goog.object.set(G__67591_71333,G__67592_71334,G__67593_71335);
goog.object.set(clojure.core.matrix.protocols.PAddScaledMutable,"number",true);

var G__67597_71337 = clojure.core.matrix.protocols.add_scaled_BANG_;
var G__67598_71338 = "number";
var G__67599_71339 = ((function (G__67597_71337,G__67598_71338){
return (function (m,a,factor){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Numbers are not mutable",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67597_71337,G__67598_71338))
;
goog.object.set(G__67597_71337,G__67598_71338,G__67599_71339);

goog.object.set(clojure.core.matrix.protocols.PAddScaledMutable,"object",true);

var G__67606_71341 = clojure.core.matrix.protocols.add_scaled_BANG_;
var G__67607_71342 = "object";
var G__67608_71343 = ((function (G__67606_71341,G__67607_71342){
return (function (m,a,factor){
return clojure.core.matrix.protocols.matrix_add_BANG_(m,clojure.core.matrix.protocols.scale(a,factor));
});})(G__67606_71341,G__67607_71342))
;
goog.object.set(G__67606_71341,G__67607_71342,G__67608_71343);
goog.object.set(clojure.core.matrix.protocols.PAddScaledProduct,"number",true);

var G__67610_71346 = clojure.core.matrix.protocols.add_scaled_product;
var G__67611_71347 = "number";
var G__67612_71348 = ((function (G__67610_71346,G__67611_71347){
return (function (m,a,b,factor){
return clojure.core.matrix.protocols.matrix_add(clojure.core.matrix.protocols.scale(clojure.core.matrix.protocols.element_multiply(a,b),factor),m);
});})(G__67610_71346,G__67611_71347))
;
goog.object.set(G__67610_71346,G__67611_71347,G__67612_71348);

goog.object.set(clojure.core.matrix.protocols.PAddScaledProduct,"object",true);

var G__67616_71353 = clojure.core.matrix.protocols.add_scaled_product;
var G__67617_71354 = "object";
var G__67618_71355 = ((function (G__67616_71353,G__67617_71354){
return (function (m,a,b,factor){
return clojure.core.matrix.protocols.matrix_add(m,clojure.core.matrix.protocols.scale(clojure.core.matrix.protocols.element_multiply(a,b),factor));
});})(G__67616_71353,G__67617_71354))
;
goog.object.set(G__67616_71353,G__67617_71354,G__67618_71355);
goog.object.set(clojure.core.matrix.protocols.PAddScaledProductMutable,"number",true);

var G__67621_71359 = clojure.core.matrix.protocols.add_scaled_product_BANG_;
var G__67622_71360 = "number";
var G__67623_71361 = ((function (G__67621_71359,G__67622_71360){
return (function (m,a,b,factor){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Numbers are not mutable",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67621_71359,G__67622_71360))
;
goog.object.set(G__67621_71359,G__67622_71360,G__67623_71361);

goog.object.set(clojure.core.matrix.protocols.PAddScaledProductMutable,"object",true);

var G__67627_71363 = clojure.core.matrix.protocols.add_scaled_product_BANG_;
var G__67628_71364 = "object";
var G__67629_71365 = ((function (G__67627_71363,G__67628_71364){
return (function (m,a,b,factor){
return clojure.core.matrix.protocols.matrix_add_BANG_(m,clojure.core.matrix.protocols.scale(clojure.core.matrix.protocols.element_multiply(a,b),factor));
});})(G__67627_71363,G__67628_71364))
;
goog.object.set(G__67627_71363,G__67628_71364,G__67629_71365);
goog.object.set(clojure.core.matrix.protocols.PScaleAdd,"object",true);

var G__67632_71367 = clojure.core.matrix.protocols.scale_add_BANG_;
var G__67633_71368 = "object";
var G__67634_71369 = ((function (G__67632_71367,G__67633_71368){
return (function (m1,a,m2,b,constant){
clojure.core.matrix.protocols.element_multiply_BANG_(m1,a);

if(((typeof b === 'number') && ((b === (0))))){
} else {
clojure.core.matrix.protocols.add_product_BANG_(m1,m2,b);
}

if(((typeof constant === 'number') && ((constant === (0))))){
} else {
clojure.core.matrix.protocols.matrix_add_BANG_(m1,constant);
}

return m1;
});})(G__67632_71367,G__67633_71368))
;
goog.object.set(G__67632_71367,G__67633_71368,G__67634_71369);
goog.object.set(clojure.core.matrix.protocols.PScaleAdd2,"object",true);

var G__67642_71373 = clojure.core.matrix.protocols.scale_add;
var G__67643_71374 = "object";
var G__67644_71375 = ((function (G__67642_71373,G__67643_71374){
return (function (m1,a,m2,b,constant){
var r = clojure.core.matrix.protocols.matrix_add(clojure.core.matrix.protocols.scale(m1,a),clojure.core.matrix.protocols.scale(m2,b));
if((0.0 === constant)){
return r;
} else {
return clojure.core.matrix.protocols.matrix_add(r,constant);
}
});})(G__67642_71373,G__67643_71374))
;
goog.object.set(G__67642_71373,G__67643_71374,G__67644_71375);
goog.object.set(clojure.core.matrix.protocols.PLerp,"object",true);

var G__67650_71377 = clojure.core.matrix.protocols.lerp;
var G__67651_71378 = "object";
var G__67652_71379 = ((function (G__67650_71377,G__67651_71378){
return (function (a,b,factor){
return clojure.core.matrix.protocols.scale_add(a,(1.0 - factor),b,factor,0.0);
});})(G__67650_71377,G__67651_71378))
;
goog.object.set(G__67650_71377,G__67651_71378,G__67652_71379);

var G__67653_71382 = clojure.core.matrix.protocols.lerp_BANG_;
var G__67654_71383 = "object";
var G__67655_71384 = ((function (G__67653_71382,G__67654_71383){
return (function (a,b,factor){
return clojure.core.matrix.protocols.scale_add_BANG_(a,(1.0 - factor),b,factor,0.0);
});})(G__67653_71382,G__67654_71383))
;
goog.object.set(G__67653_71382,G__67654_71383,G__67655_71384);
goog.object.set(clojure.core.matrix.protocols.PAddInnerProductMutable,"object",true);

var G__67658_71386 = clojure.core.matrix.protocols.add_inner_product_BANG_;
var G__67659_71387 = "object";
var G__67660_71388 = ((function (G__67658_71386,G__67659_71387){
return (function() {
var G__71389 = null;
var G__71389__3 = (function (m,a,b){
return clojure.core.matrix.protocols.matrix_add_BANG_(m,clojure.core.matrix.protocols.inner_product(a,b));
});
var G__71389__4 = (function (m,a,b,factor){
return clojure.core.matrix.protocols.add_scaled_BANG_(m,clojure.core.matrix.protocols.inner_product(a,b),factor);
});
G__71389 = function(m,a,b,factor){
switch(arguments.length){
case 3:
return G__71389__3.call(this,m,a,b);
case 4:
return G__71389__4.call(this,m,a,b,factor);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71389.cljs$core$IFn$_invoke$arity$3 = G__71389__3;
G__71389.cljs$core$IFn$_invoke$arity$4 = G__71389__4;
return G__71389;
})()
;})(G__67658_71386,G__67659_71387))
;
goog.object.set(G__67658_71386,G__67659_71387,G__67660_71388);
goog.object.set(clojure.core.matrix.protocols.PAddOuterProductMutable,"object",true);

var G__67665_71394 = clojure.core.matrix.protocols.add_outer_product_BANG_;
var G__67666_71395 = "object";
var G__67667_71396 = ((function (G__67665_71394,G__67666_71395){
return (function() {
var G__71397 = null;
var G__71397__3 = (function (m,a,b){
return clojure.core.matrix.protocols.matrix_add_BANG_(m,clojure.core.matrix.protocols.outer_product(a,b));
});
var G__71397__4 = (function (m,a,b,factor){
return clojure.core.matrix.protocols.add_scaled_BANG_(m,clojure.core.matrix.protocols.outer_product(a,b),factor);
});
G__71397 = function(m,a,b,factor){
switch(arguments.length){
case 3:
return G__71397__3.call(this,m,a,b);
case 4:
return G__71397__4.call(this,m,a,b,factor);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71397.cljs$core$IFn$_invoke$arity$3 = G__71397__3;
G__71397.cljs$core$IFn$_invoke$arity$4 = G__71397__4;
return G__71397;
})()
;})(G__67665_71394,G__67666_71395))
;
goog.object.set(G__67665_71394,G__67666_71395,G__67667_71396);
goog.object.set(clojure.core.matrix.protocols.PSetInnerProductMutable,"object",true);

var G__67674_71401 = clojure.core.matrix.protocols.set_inner_product_BANG_;
var G__67675_71402 = "object";
var G__67676_71403 = ((function (G__67674_71401,G__67675_71402){
return (function() {
var G__71404 = null;
var G__71404__3 = (function (m,a,b){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.inner_product(a,b));
});
var G__71404__4 = (function (m,a,b,factor){
clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.inner_product(a,b));

return clojure.core.matrix.protocols.scale_BANG_(m,factor);
});
G__71404 = function(m,a,b,factor){
switch(arguments.length){
case 3:
return G__71404__3.call(this,m,a,b);
case 4:
return G__71404__4.call(this,m,a,b,factor);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71404.cljs$core$IFn$_invoke$arity$3 = G__71404__3;
G__71404.cljs$core$IFn$_invoke$arity$4 = G__71404__4;
return G__71404;
})()
;})(G__67674_71401,G__67675_71402))
;
goog.object.set(G__67674_71401,G__67675_71402,G__67676_71403);
goog.object.set(clojure.core.matrix.protocols.PTypeInfo,"null",true);

var G__67678_71412 = clojure.core.matrix.protocols.element_type;
var G__67679_71413 = "null";
var G__67680_71414 = ((function (G__67678_71412,G__67679_71413){
return (function (a){
return Object;
});})(G__67678_71412,G__67679_71413))
;
goog.object.set(G__67678_71412,G__67679_71413,G__67680_71414);

goog.object.set(clojure.core.matrix.protocols.PTypeInfo,"object",true);

var G__67683_71415 = clojure.core.matrix.protocols.element_type;
var G__67684_71416 = "object";
var G__67685_71417 = ((function (G__67683_71415,G__67684_71416){
return (function (a){
if((Array === a.constructor)){
return cljs.core.type(a).getComponentType();
} else {
return Object;
}
});})(G__67683_71415,G__67684_71416))
;
goog.object.set(G__67683_71415,G__67684_71416,G__67685_71417);
goog.object.set(clojure.core.matrix.protocols.PGenericValues,"object",true);

var G__67687_71420 = clojure.core.matrix.protocols.generic_zero;
var G__67688_71421 = "object";
var G__67689_71422 = ((function (G__67687_71420,G__67688_71421){
return (function (m){
return (0);
});})(G__67687_71420,G__67688_71421))
;
goog.object.set(G__67687_71420,G__67688_71421,G__67689_71422);

var G__67692_71423 = clojure.core.matrix.protocols.generic_one;
var G__67693_71424 = "object";
var G__67694_71425 = ((function (G__67692_71423,G__67693_71424){
return (function (m){
return (1);
});})(G__67692_71423,G__67693_71424))
;
goog.object.set(G__67692_71423,G__67693_71424,G__67694_71425);

var G__67697_71429 = clojure.core.matrix.protocols.generic_value;
var G__67698_71430 = "object";
var G__67699_71431 = ((function (G__67697_71429,G__67698_71430){
return (function (m){
return (0);
});})(G__67697_71429,G__67698_71430))
;
goog.object.set(G__67697_71429,G__67698_71430,G__67699_71431);
cljs.core.IFn.prototype.clojure$core$matrix$protocols$PVectorTransform$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.IFn.prototype.clojure$core$matrix$protocols$PVectorTransform$vector_transform$arity$2 = (function (m,a){
var m__$1 = this;
if(cljs.core.vector_QMARK_(m__$1)){
return clojure.core.matrix.protocols.matrix_multiply(m__$1,a);
} else {
return (m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(a) : m__$1.call(null,a));
}
});

cljs.core.IFn.prototype.clojure$core$matrix$protocols$PVectorTransform$vector_transform_BANG_$arity$2 = (function (m,a){
var m__$1 = this;
if(cljs.core.vector_QMARK_(m__$1)){
return clojure.core.matrix.protocols.assign_BANG_(a,clojure.core.matrix.protocols.matrix_multiply(m__$1,a));
} else {
return clojure.core.matrix.protocols.assign_BANG_(a,(m__$1.cljs$core$IFn$_invoke$arity$1 ? m__$1.cljs$core$IFn$_invoke$arity$1(a) : m__$1.call(null,a)));
}
});

goog.object.set(clojure.core.matrix.protocols.PVectorTransform,"object",true);

var G__67713_71436 = clojure.core.matrix.protocols.vector_transform;
var G__67714_71437 = "object";
var G__67715_71438 = ((function (G__67713_71436,G__67714_71437){
return (function (m,a){
if(((2) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))){
return clojure.core.matrix.protocols.matrix_multiply(m,a);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Don't know how to transform using: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(m))].join(''),cljs.core.PersistentArrayMap.EMPTY);

}
});})(G__67713_71436,G__67714_71437))
;
goog.object.set(G__67713_71436,G__67714_71437,G__67715_71438);

var G__67718_71440 = clojure.core.matrix.protocols.vector_transform_BANG_;
var G__67719_71441 = "object";
var G__67720_71442 = ((function (G__67718_71440,G__67719_71441){
return (function (m,a){
return clojure.core.matrix.protocols.assign_BANG_(a,clojure.core.matrix.protocols.vector_transform(m,a));
});})(G__67718_71440,G__67719_71441))
;
goog.object.set(G__67718_71440,G__67719_71441,G__67720_71442);
goog.object.set(clojure.core.matrix.protocols.PMatrixScaling,"number",true);

var G__67725_71450 = clojure.core.matrix.protocols.scale;
var G__67726_71451 = "number";
var G__67727_71452 = ((function (G__67725_71450,G__67726_71451){
return (function (m,a){
if(typeof a === 'number'){
return (m * a);
} else {
return clojure.core.matrix.protocols.pre_scale(a,m);
}
});})(G__67725_71450,G__67726_71451))
;
goog.object.set(G__67725_71450,G__67726_71451,G__67727_71452);

var G__67731_71453 = clojure.core.matrix.protocols.pre_scale;
var G__67732_71454 = "number";
var G__67733_71455 = ((function (G__67731_71453,G__67732_71454){
return (function (m,a){
if(typeof a === 'number'){
return (a * m);
} else {
return clojure.core.matrix.protocols.scale(a,m);
}
});})(G__67731_71453,G__67732_71454))
;
goog.object.set(G__67731_71453,G__67732_71454,G__67733_71455);

goog.object.set(clojure.core.matrix.protocols.PMatrixScaling,"object",true);

var G__67736_71457 = clojure.core.matrix.protocols.scale;
var G__67737_71458 = "object";
var G__67738_71459 = ((function (G__67736_71457,G__67737_71458){
return (function (m,a){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__67736_71457,G__67737_71458){
return (function (p1__67723_SHARP_){
return (p1__67723_SHARP_ * a);
});})(G__67736_71457,G__67737_71458))
);
});})(G__67736_71457,G__67737_71458))
;
goog.object.set(G__67736_71457,G__67737_71458,G__67738_71459);

var G__67739_71461 = clojure.core.matrix.protocols.pre_scale;
var G__67740_71462 = "object";
var G__67741_71463 = ((function (G__67739_71461,G__67740_71462){
return (function (m,a){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,a));
});})(G__67739_71461,G__67740_71462))
;
goog.object.set(G__67739_71461,G__67740_71462,G__67741_71463);
goog.object.set(clojure.core.matrix.protocols.PMatrixMutableScaling,"number",true);

var G__67745_71465 = clojure.core.matrix.protocols.scale_BANG_;
var G__67746_71466 = "number";
var G__67747_71467 = ((function (G__67745_71465,G__67746_71466){
return (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't scale! a numeric value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m)].join(''),cljs.core.PersistentArrayMap.EMPTY);
});})(G__67745_71465,G__67746_71466))
;
goog.object.set(G__67745_71465,G__67746_71466,G__67747_71467);

var G__67749_71469 = clojure.core.matrix.protocols.pre_scale_BANG_;
var G__67750_71470 = "number";
var G__67751_71471 = ((function (G__67749_71469,G__67750_71470){
return (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't pre-scale! a numeric value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m)].join(''),cljs.core.PersistentArrayMap.EMPTY);
});})(G__67749_71469,G__67750_71470))
;
goog.object.set(G__67749_71469,G__67750_71470,G__67751_71471);

goog.object.set(clojure.core.matrix.protocols.PMatrixMutableScaling,"object",true);

var G__67755_71473 = clojure.core.matrix.protocols.scale_BANG_;
var G__67756_71474 = "object";
var G__67757_71475 = ((function (G__67755_71473,G__67756_71474){
return (function (m,a){
clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__67755_71473,G__67756_71474){
return (function (p1__67744_SHARP_){
return (p1__67744_SHARP_ * a);
});})(G__67755_71473,G__67756_71474))
);

return m;
});})(G__67755_71473,G__67756_71474))
;
goog.object.set(G__67755_71473,G__67756_71474,G__67757_71475);

var G__67760_71477 = clojure.core.matrix.protocols.pre_scale_BANG_;
var G__67761_71478 = "object";
var G__67762_71479 = ((function (G__67760_71477,G__67761_71478){
return (function (m,a){
clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,a));

return m;
});})(G__67760_71477,G__67761_71478))
;
goog.object.set(G__67760_71477,G__67761_71478,G__67762_71479);
goog.object.set(clojure.core.matrix.protocols.PMatrixAdd,"number",true);

var G__67771_71482 = clojure.core.matrix.protocols.matrix_add;
var G__67772_71483 = "number";
var G__67773_71484 = ((function (G__67771_71482,G__67772_71483){
return (function (m,a){
if(typeof a === 'number'){
return (m + a);
} else {
return clojure.core.matrix.protocols.matrix_add(a,m);
}
});})(G__67771_71482,G__67772_71483))
;
goog.object.set(G__67771_71482,G__67772_71483,G__67773_71484);

var G__67778_71485 = clojure.core.matrix.protocols.matrix_sub;
var G__67779_71486 = "number";
var G__67780_71487 = ((function (G__67778_71485,G__67779_71486){
return (function (m,a){
if(typeof a === 'number'){
return (m - a);
} else {
return clojure.core.matrix.protocols.negate(clojure.core.matrix.protocols.matrix_sub(a,m));
}
});})(G__67778_71485,G__67779_71486))
;
goog.object.set(G__67778_71485,G__67779_71486,G__67780_71487);

goog.object.set(clojure.core.matrix.protocols.PMatrixAdd,"object",true);

var G__67782_71492 = clojure.core.matrix.protocols.matrix_add;
var G__67783_71493 = "object";
var G__67784_71494 = ((function (G__67782_71492,G__67783_71493){
return (function (m,a){
var vec__67786 = clojure.core.matrix.protocols.broadcast_compatible(m,a);
var m__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67786,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67786,(1),null);
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core._PLUS_,a__$1);
});})(G__67782_71492,G__67783_71493))
;
goog.object.set(G__67782_71492,G__67783_71493,G__67784_71494);

var G__67790_71497 = clojure.core.matrix.protocols.matrix_sub;
var G__67791_71498 = "object";
var G__67792_71499 = ((function (G__67790_71497,G__67791_71498){
return (function (m,a){
var vec__67794 = clojure.core.matrix.protocols.broadcast_compatible(m,a);
var m__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67794,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67794,(1),null);
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core._,a__$1);
});})(G__67790_71497,G__67791_71498))
;
goog.object.set(G__67790_71497,G__67791_71498,G__67792_71499);
goog.object.set(clojure.core.matrix.protocols.PMatrixAddMutable,"number",true);

var G__67801_71501 = clojure.core.matrix.protocols.matrix_add_BANG_;
var G__67802_71502 = "number";
var G__67803_71503 = ((function (G__67801_71501,G__67802_71502){
return (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do mutable add! on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67801_71501,G__67802_71502))
;
goog.object.set(G__67801_71501,G__67802_71502,G__67803_71503);

var G__67806_71505 = clojure.core.matrix.protocols.matrix_sub_BANG_;
var G__67807_71506 = "number";
var G__67808_71507 = ((function (G__67806_71505,G__67807_71506){
return (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do mutable sub! on a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67806_71505,G__67807_71506))
;
goog.object.set(G__67806_71505,G__67807_71506,G__67808_71507);

goog.object.set(clojure.core.matrix.protocols.PMatrixAddMutable,"object",true);

var G__67809_71509 = clojure.core.matrix.protocols.matrix_add_BANG_;
var G__67810_71510 = "object";
var G__67811_71511 = ((function (G__67809_71509,G__67810_71510){
return (function (m,a){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$3(m,cljs.core._PLUS_,a);
});})(G__67809_71509,G__67810_71510))
;
goog.object.set(G__67809_71509,G__67810_71510,G__67811_71511);

var G__67814_71513 = clojure.core.matrix.protocols.matrix_sub_BANG_;
var G__67815_71514 = "object";
var G__67816_71515 = ((function (G__67814_71513,G__67815_71514){
return (function (m,a){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$3(m,cljs.core._,a);
});})(G__67814_71513,G__67815_71514))
;
goog.object.set(G__67814_71513,G__67815_71514,G__67816_71515);
goog.object.set(clojure.core.matrix.protocols.PNegation,"null",true);

var G__67817_71516 = clojure.core.matrix.protocols.negate;
var G__67818_71517 = "null";
var G__67819_71518 = ((function (G__67817_71516,G__67818_71517){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't negate nil!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67817_71516,G__67818_71517))
;
goog.object.set(G__67817_71516,G__67818_71517,G__67819_71518);

goog.object.set(clojure.core.matrix.protocols.PNegation,"number",true);

var G__67821_71519 = clojure.core.matrix.protocols.negate;
var G__67822_71520 = "number";
var G__67823_71521 = ((function (G__67821_71519,G__67822_71520){
return (function (m){
return (- m);
});})(G__67821_71519,G__67822_71520))
;
goog.object.set(G__67821_71519,G__67822_71520,G__67823_71521);

goog.object.set(clojure.core.matrix.protocols.PNegation,"object",true);

var G__67826_71524 = clojure.core.matrix.protocols.negate;
var G__67827_71525 = "object";
var G__67828_71526 = ((function (G__67826_71524,G__67827_71525){
return (function (m){
return clojure.core.matrix.protocols.scale(m,-1.0);
});})(G__67826_71524,G__67827_71525))
;
goog.object.set(G__67826_71524,G__67827_71525,G__67828_71526);
goog.object.set(clojure.core.matrix.protocols.PMatrixEquality,"null",true);

var G__67834_71528 = clojure.core.matrix.protocols.matrix_equals;
var G__67835_71529 = "null";
var G__67836_71530 = ((function (G__67834_71528,G__67835_71529){
return (function (a,b){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("nil is not a valid numerical value in equality testing",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67834_71528,G__67835_71529))
;
goog.object.set(G__67834_71528,G__67835_71529,G__67836_71530);

goog.object.set(clojure.core.matrix.protocols.PMatrixEquality,"number",true);

var G__67837_71531 = clojure.core.matrix.protocols.matrix_equals;
var G__67838_71532 = "number";
var G__67839_71533 = ((function (G__67837_71531,G__67838_71532){
return (function (a,b){
if(typeof b === 'number'){
return (a === b);
} else {
if(((0) === clojure.core.matrix.protocols.dimensionality(b))){
return clojure.core.matrix.protocols.matrix_equals(b,a);
} else {
return false;

}
}
});})(G__67837_71531,G__67838_71532))
;
goog.object.set(G__67837_71531,G__67838_71532,G__67839_71533);

goog.object.set(clojure.core.matrix.protocols.PMatrixEquality,"object",true);

var G__67848_71536 = clojure.core.matrix.protocols.matrix_equals;
var G__67849_71537 = "object";
var G__67850_71538 = ((function (G__67848_71536,G__67849_71537){
return (function (a,b){
if((a === b)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_(a,b))){
if(((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a)))){
return (clojure.core.matrix.protocols.get_0d(a) === (function (){var x__53433__auto__ = b;
if(typeof x__53433__auto__ === 'number'){
return x__53433__auto__;
} else {
return clojure.core.matrix.protocols.get_0d(x__53433__auto__);

}
})());
} else {
return cljs.core.not_any_QMARK_(cljs.core.false_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._EQ__EQ_,clojure.core.matrix.protocols.element_seq(a),clojure.core.matrix.protocols.element_seq(b)));
}
} else {
return false;

}
}
});})(G__67848_71536,G__67849_71537))
;
goog.object.set(G__67848_71536,G__67849_71537,G__67850_71538);
goog.object.set(clojure.core.matrix.protocols.PValueEquality,"null",true);

var G__67857_71540 = clojure.core.matrix.protocols.value_equals;
var G__67858_71541 = "null";
var G__67859_71542 = ((function (G__67857_71540,G__67858_71541){
return (function (a,b){
return (((b == null)) || (((((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b)))) && ((clojure.core.matrix.protocols.get_0d(b) == null)))));
});})(G__67857_71540,G__67858_71541))
;
goog.object.set(G__67857_71540,G__67858_71541,G__67859_71542);

goog.object.set(clojure.core.matrix.protocols.PValueEquality,"number",true);

var G__67864_71550 = clojure.core.matrix.protocols.value_equals;
var G__67865_71551 = "number";
var G__67866_71552 = ((function (G__67864_71550,G__67865_71551){
return (function (a,b){
return ((((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b)))) && ((a === clojure.core.matrix.protocols.get_0d(b))));
});})(G__67864_71550,G__67865_71551))
;
goog.object.set(G__67864_71550,G__67865_71551,G__67866_71552);

goog.object.set(clojure.core.matrix.protocols.PValueEquality,"object",true);

var G__67872_71554 = clojure.core.matrix.protocols.value_equals;
var G__67873_71555 = "object";
var G__67874_71556 = ((function (G__67872_71554,G__67873_71555){
return (function (a,b){
var and__4120__auto__ = clojure.core.matrix.protocols.same_shape_QMARK_(a,b);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._EQ_,clojure.core.matrix.protocols.element_seq(a),clojure.core.matrix.protocols.element_seq(b)));
} else {
return and__4120__auto__;
}
});})(G__67872_71554,G__67873_71555))
;
goog.object.set(G__67872_71554,G__67873_71555,G__67874_71556);
goog.object.set(clojure.core.matrix.protocols.PMatrixEqualityEpsilon,"null",true);

var G__67878_71558 = clojure.core.matrix.protocols.matrix_equals_epsilon;
var G__67879_71559 = "null";
var G__67880_71560 = ((function (G__67878_71558,G__67879_71559){
return (function (a,b,eps){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("nil is not a valid numerical value in equality testing",cljs.core.PersistentArrayMap.EMPTY);
});})(G__67878_71558,G__67879_71559))
;
goog.object.set(G__67878_71558,G__67879_71559,G__67880_71560);

goog.object.set(clojure.core.matrix.protocols.PMatrixEqualityEpsilon,"number",true);

var G__67881_71562 = clojure.core.matrix.protocols.matrix_equals_epsilon;
var G__67882_71563 = "number";
var G__67883_71564 = ((function (G__67881_71562,G__67882_71563){
return (function (a,b,eps){
if(typeof b === 'number'){
return (Math.abs((a - b)) <= eps);
} else {
if(((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(b)))){
return (Math.abs((a - clojure.core.matrix.protocols.get_0d(b))) <= eps);
} else {
return false;

}
}
});})(G__67881_71562,G__67882_71563))
;
goog.object.set(G__67881_71562,G__67882_71563,G__67883_71564);

goog.object.set(clojure.core.matrix.protocols.PMatrixEqualityEpsilon,"object",true);

var G__67890_71568 = clojure.core.matrix.protocols.matrix_equals_epsilon;
var G__67891_71569 = "object";
var G__67892_71570 = ((function (G__67890_71568,G__67891_71569){
return (function (a,b,eps){
if((a === b)){
return true;
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.same_shape_QMARK_(a,b))){
var eps__$1 = eps;
return cljs.core.every_QMARK_(((function (eps__$1,G__67890_71568,G__67891_71569){
return (function (p1__67877_SHARP_){
return ((function (){var G__67895 = p1__67877_SHARP_;
return Math.abs(G__67895);
})() <= eps__$1);
});})(eps__$1,G__67890_71568,G__67891_71569))
,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,clojure.core.matrix.protocols.element_seq(a),clojure.core.matrix.protocols.element_seq(b)));
} else {
return false;

}
}
});})(G__67890_71568,G__67891_71569))
;
goog.object.set(G__67890_71568,G__67891_71569,G__67892_71570);
goog.object.set(clojure.core.matrix.protocols.PDoubleArrayOutput,"number",true);

var G__67897_71576 = clojure.core.matrix.protocols.to_double_array;
var G__67898_71577 = "number";
var G__67899_71578 = ((function (G__67897_71576,G__67898_71577){
return (function (m){
var arr = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((1));
(arr[(0)] = m);

return arr;
});})(G__67897_71576,G__67898_71577))
;
goog.object.set(G__67897_71576,G__67898_71577,G__67899_71578);

var G__67912_71580 = clojure.core.matrix.protocols.as_double_array;
var G__67913_71581 = "number";
var G__67914_71582 = ((function (G__67912_71580,G__67913_71581){
return (function (m){
return null;
});})(G__67912_71580,G__67913_71581))
;
goog.object.set(G__67912_71580,G__67913_71581,G__67914_71582);

goog.object.set(clojure.core.matrix.protocols.PDoubleArrayOutput,"object",true);

var G__67915_71583 = clojure.core.matrix.protocols.to_double_array;
var G__67916_71584 = "object";
var G__67917_71585 = ((function (G__67915_71583,G__67916_71584){
return (function (m){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.element_seq(m));
});})(G__67915_71583,G__67916_71584))
;
goog.object.set(G__67915_71583,G__67916_71584,G__67917_71585);

var G__67918_71586 = clojure.core.matrix.protocols.as_double_array;
var G__67919_71587 = "object";
var G__67920_71588 = ((function (G__67918_71586,G__67919_71587){
return (function (m){
return null;
});})(G__67918_71586,G__67919_71587))
;
goog.object.set(G__67918_71586,G__67919_71587,G__67920_71588);
goog.object.set(clojure.core.matrix.protocols.PObjectArrayOutput,"null",true);

var G__67924_71590 = clojure.core.matrix.protocols.to_object_array;
var G__67925_71591 = "null";
var G__67926_71592 = ((function (G__67924_71590,G__67925_71591){
return (function (m){
var arr = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((1));
return arr;
});})(G__67924_71590,G__67925_71591))
;
goog.object.set(G__67924_71590,G__67925_71591,G__67926_71592);

var G__67929_71593 = clojure.core.matrix.protocols.as_object_array;
var G__67930_71594 = "null";
var G__67931_71595 = ((function (G__67929_71593,G__67930_71594){
return (function (m){
return null;
});})(G__67929_71593,G__67930_71594))
;
goog.object.set(G__67929_71593,G__67930_71594,G__67931_71595);

goog.object.set(clojure.core.matrix.protocols.PObjectArrayOutput,"number",true);

var G__67932_71596 = clojure.core.matrix.protocols.to_object_array;
var G__67933_71597 = "number";
var G__67934_71598 = ((function (G__67932_71596,G__67933_71597){
return (function (m){
var arr = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((1));
(arr[(0)] = m);

return arr;
});})(G__67932_71596,G__67933_71597))
;
goog.object.set(G__67932_71596,G__67933_71597,G__67934_71598);

var G__67940_71601 = clojure.core.matrix.protocols.as_object_array;
var G__67941_71602 = "number";
var G__67942_71603 = ((function (G__67940_71601,G__67941_71602){
return (function (m){
return null;
});})(G__67940_71601,G__67941_71602))
;
goog.object.set(G__67940_71601,G__67941_71602,G__67942_71603);

goog.object.set(clojure.core.matrix.protocols.PObjectArrayOutput,"object",true);

var G__67943_71604 = clojure.core.matrix.protocols.to_object_array;
var G__67944_71605 = "object";
var G__67945_71606 = ((function (G__67943_71604,G__67944_71605){
return (function (m){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.element_seq(m));
});})(G__67943_71604,G__67944_71605))
;
goog.object.set(G__67943_71604,G__67944_71605,G__67945_71606);

var G__67946_71607 = clojure.core.matrix.protocols.as_object_array;
var G__67947_71608 = "object";
var G__67948_71609 = ((function (G__67946_71607,G__67947_71608){
return (function (m){
return null;
});})(G__67946_71607,G__67947_71608))
;
goog.object.set(G__67946_71607,G__67947_71608,G__67948_71609);
goog.object.set(clojure.core.matrix.protocols.PRowOperations,"object",true);

var G__67951_71611 = clojure.core.matrix.protocols.swap_rows;
var G__67952_71612 = "object";
var G__67953_71613 = ((function (G__67951_71611,G__67952_71612){
return (function (m,i,j){
return clojure.core.matrix.protocols.swap_rows(clojure.core.matrix.protocols.convert_to_nested_vectors(m),i,j);
});})(G__67951_71611,G__67952_71612))
;
goog.object.set(G__67951_71611,G__67952_71612,G__67953_71613);

var G__67954_71615 = clojure.core.matrix.protocols.multiply_row;
var G__67955_71616 = "object";
var G__67956_71617 = ((function (G__67954_71615,G__67955_71616){
return (function (m,i,k){
return clojure.core.matrix.protocols.multiply_row(clojure.core.matrix.protocols.convert_to_nested_vectors(m),i,k);
});})(G__67954_71615,G__67955_71616))
;
goog.object.set(G__67954_71615,G__67955_71616,G__67956_71617);

var G__67958_71618 = clojure.core.matrix.protocols.add_row;
var G__67959_71619 = "object";
var G__67960_71620 = ((function (G__67958_71618,G__67959_71619){
return (function (m,i,j,k){
return clojure.core.matrix.protocols.add_row(clojure.core.matrix.protocols.convert_to_nested_vectors(m),i,j,k);
});})(G__67958_71618,G__67959_71619))
;
goog.object.set(G__67958_71618,G__67959_71619,G__67960_71620);
goog.object.set(clojure.core.matrix.protocols.PRowSetting,"object",true);

var G__67965_71626 = clojure.core.matrix.protocols.set_row;
var G__67966_71627 = "object";
var G__67967_71628 = ((function (G__67965_71626,G__67966_71627){
return (function (m,i,row){
var svec = cljs.core.vec(clojure.core.matrix.protocols.get_major_slice_seq(m));
var row__$1 = clojure.core.matrix.protocols.broadcast_like((svec.cljs$core$IFn$_invoke$arity$1 ? svec.cljs$core$IFn$_invoke$arity$1((0)) : svec.call(null,(0))),row);
return clojure.core.matrix.protocols.coerce_param(m,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(svec,i,row__$1));
});})(G__67965_71626,G__67966_71627))
;
goog.object.set(G__67965_71626,G__67966_71627,G__67967_71628);

var G__67971_71634 = clojure.core.matrix.protocols.set_row_BANG_;
var G__67972_71635 = "object";
var G__67973_71636 = ((function (G__67971_71634,G__67972_71635){
return (function (m,i,row){
var sl = clojure.core.matrix.protocols.get_major_slice_view(m,i);
var row__$1 = clojure.core.matrix.protocols.broadcast_like(sl,row);
clojure.core.matrix.protocols.assign_BANG_(sl,row__$1);

return m;
});})(G__67971_71634,G__67972_71635))
;
goog.object.set(G__67971_71634,G__67972_71635,G__67973_71636);
goog.object.set(clojure.core.matrix.protocols.PColumnSetting,"object",true);

var G__67986_71638 = clojure.core.matrix.protocols.set_column;
var G__67987_71639 = "object";
var G__67988_71640 = ((function (G__67986_71638,G__67987_71639){
return (function (m,i,column){
var scol = clojure.core.matrix.protocols.get_column(m,(0));
var column__$1 = clojure.core.matrix.protocols.broadcast_like(scol,column);
var indices = cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(column__$1,(0)));
var new_m = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (scol,column__$1,indices,G__67986_71638,G__67987_71639){
return (function (acc,idx){
return clojure.core.matrix.protocols.set_2d(acc,idx,i,clojure.core.matrix.protocols.get_1d(column__$1,idx));
});})(scol,column__$1,indices,G__67986_71638,G__67987_71639))
,m,indices);
return clojure.core.matrix.protocols.coerce_param(m,new_m);
});})(G__67986_71638,G__67987_71639))
;
goog.object.set(G__67986_71638,G__67987_71639,G__67988_71640);

var G__67990_71642 = clojure.core.matrix.protocols.set_column_BANG_;
var G__67991_71643 = "object";
var G__67992_71644 = ((function (G__67990_71642,G__67991_71643){
return (function (m,i,column){
var scol = clojure.core.matrix.protocols.get_column(m,(0));
var column__$1 = clojure.core.matrix.protocols.broadcast_like(scol,column);
var n__4607__auto__ = clojure.core.matrix.protocols.dimension_count(column__$1,(0));
var j = (0);
while(true){
if((j < n__4607__auto__)){
clojure.core.matrix.protocols.set_2d_BANG_(m,j,i,clojure.core.matrix.protocols.get_1d(column__$1,j));

var G__71648 = (j + (1));
j = G__71648;
continue;
} else {
return null;
}
break;
}
});})(G__67990_71642,G__67991_71643))
;
goog.object.set(G__67990_71642,G__67991_71643,G__67992_71644);
goog.object.set(clojure.core.matrix.protocols.PSliceMap,"object",true);

var G__67998_71649 = clojure.core.matrix.protocols.slice_map;
var G__67999_71650 = "object";
var G__68000_71651 = ((function (G__67998_71649,G__67999_71650){
return (function() {
var G__71652 = null;
var G__71652__2 = (function (m,f){
return clojure.core.matrix.impl.common.construct_matrix(m,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(f,clojure.core.matrix.protocols.get_major_slice_seq(m)));
});
var G__71652__3 = (function (m,f,a){
return clojure.core.matrix.impl.common.construct_matrix(m,cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(f,clojure.core.matrix.protocols.get_major_slice_seq(m),clojure.core.matrix.protocols.get_major_slice_seq(a)));
});
var G__71652__4 = (function (m,f,a,more){
return clojure.core.matrix.impl.common.construct_matrix(m,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.mapv,f,clojure.core.matrix.protocols.get_major_slice_seq(m),clojure.core.matrix.protocols.get_major_slice_seq(a),cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_major_slice_seq,more)));
});
G__71652 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71652__2.call(this,m,f);
case 3:
return G__71652__3.call(this,m,f,a);
case 4:
return G__71652__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71652.cljs$core$IFn$_invoke$arity$2 = G__71652__2;
G__71652.cljs$core$IFn$_invoke$arity$3 = G__71652__3;
G__71652.cljs$core$IFn$_invoke$arity$4 = G__71652__4;
return G__71652;
})()
;})(G__67998_71649,G__67999_71650))
;
goog.object.set(G__67998_71649,G__67999_71650,G__68000_71651);
goog.object.set(clojure.core.matrix.protocols.PFilterSlices,"object",true);

var G__68006_71656 = clojure.core.matrix.protocols.filter_slices;
var G__68007_71657 = "object";
var G__68008_71658 = ((function (G__68006_71656,G__68007_71657){
return (function (m,f){
var slcs = cljs.core.filterv(f,clojure.core.matrix.protocols.get_major_slice_seq(m));
if(cljs.core.seq(slcs)){
return slcs;
} else {
return null;
}
});})(G__68006_71656,G__68007_71657))
;
goog.object.set(G__68006_71656,G__68007_71657,G__68008_71658);
goog.object.set(clojure.core.matrix.protocols.PAddEmap,"object",true);

var G__68011_71667 = clojure.core.matrix.protocols.add_emap_BANG_;
var G__68012_71668 = "object";
var G__68013_71669 = ((function (G__68011_71667,G__68012_71668){
return (function() {
var G__71670 = null;
var G__71670__3 = (function (dest,f,a){
return clojure.core.matrix.protocols.matrix_add_BANG_(dest,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(a,f));
});
var G__71670__4 = (function (dest,f,a,b){
return clojure.core.matrix.protocols.matrix_add_BANG_(dest,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(a,f,b));
});
var G__71670__5 = (function (dest,f,a,b,more){
return clojure.core.matrix.protocols.matrix_add_BANG_(dest,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$4(a,f,b,more));
});
G__71670 = function(dest,f,a,b,more){
switch(arguments.length){
case 3:
return G__71670__3.call(this,dest,f,a);
case 4:
return G__71670__4.call(this,dest,f,a,b);
case 5:
return G__71670__5.call(this,dest,f,a,b,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71670.cljs$core$IFn$_invoke$arity$3 = G__71670__3;
G__71670.cljs$core$IFn$_invoke$arity$4 = G__71670__4;
G__71670.cljs$core$IFn$_invoke$arity$5 = G__71670__5;
return G__71670;
})()
;})(G__68011_71667,G__68012_71668))
;
goog.object.set(G__68011_71667,G__68012_71668,G__68013_71669);
goog.object.set(clojure.core.matrix.protocols.PSetEmap,"object",true);

var G__68014_71673 = clojure.core.matrix.protocols.set_emap_BANG_;
var G__68015_71674 = "object";
var G__68016_71675 = ((function (G__68014_71673,G__68015_71674){
return (function() {
var G__71677 = null;
var G__71677__3 = (function (dest,f,a){
return clojure.core.matrix.protocols.assign_BANG_(dest,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(a,f));
});
var G__71677__4 = (function (dest,f,a,b){
return clojure.core.matrix.protocols.assign_BANG_(dest,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(a,f,b));
});
var G__71677__5 = (function (dest,f,a,b,more){
return clojure.core.matrix.protocols.assign_BANG_(dest,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$4(a,f,b,more));
});
G__71677 = function(dest,f,a,b,more){
switch(arguments.length){
case 3:
return G__71677__3.call(this,dest,f,a);
case 4:
return G__71677__4.call(this,dest,f,a,b);
case 5:
return G__71677__5.call(this,dest,f,a,b,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71677.cljs$core$IFn$_invoke$arity$3 = G__71677__3;
G__71677.cljs$core$IFn$_invoke$arity$4 = G__71677__4;
G__71677.cljs$core$IFn$_invoke$arity$5 = G__71677__5;
return G__71677;
})()
;})(G__68014_71673,G__68015_71674))
;
goog.object.set(G__68014_71673,G__68015_71674,G__68016_71675);
goog.object.set(clojure.core.matrix.protocols.PFunctionalOperations,"number",true);

var G__68032_71683 = clojure.core.matrix.protocols.element_seq;
var G__68033_71684 = "number";
var G__68034_71685 = ((function (G__68032_71683,G__68033_71684){
return (function (m){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[m],null));
});})(G__68032_71683,G__68033_71684))
;
goog.object.set(G__68032_71683,G__68033_71684,G__68034_71685);

var G__68035_71690 = clojure.core.matrix.protocols.element_map;
var G__68036_71691 = "number";
var G__68037_71692 = ((function (G__68035_71690,G__68036_71691){
return (function() {
var G__71693 = null;
var G__71693__2 = (function (m,f){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(m) : f.call(null,m));
});
var G__71693__3 = (function (m,f,a){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(a,((function (G__68035_71690,G__68036_71691){
return (function (p1__68019_SHARP_){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(m,p1__68019_SHARP_) : f.call(null,m,p1__68019_SHARP_));
});})(G__68035_71690,G__68036_71691))
);
});
var G__71693__4 = (function (m,f,a,more){
var temp__5816__auto__ = cljs.core.next(more);
if(temp__5816__auto__){
var moremore = temp__5816__auto__;
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$4(a,((function (moremore,temp__5816__auto__,G__68035_71690,G__68036_71691){
return (function() { 
var G__71695__delegate = function (p1__68020_SHARP_,p2__68022_SHARP_,rest__68023_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,m,p1__68020_SHARP_,p2__68022_SHARP_,rest__68023_SHARP_);
};
var G__71695 = function (p1__68020_SHARP_,p2__68022_SHARP_,var_args){
var rest__68023_SHARP_ = null;
if (arguments.length > 2) {
var G__71696__i = 0, G__71696__a = new Array(arguments.length -  2);
while (G__71696__i < G__71696__a.length) {G__71696__a[G__71696__i] = arguments[G__71696__i + 2]; ++G__71696__i;}
  rest__68023_SHARP_ = new cljs.core.IndexedSeq(G__71696__a,0,null);
} 
return G__71695__delegate.call(this,p1__68020_SHARP_,p2__68022_SHARP_,rest__68023_SHARP_);};
G__71695.cljs$lang$maxFixedArity = 2;
G__71695.cljs$lang$applyTo = (function (arglist__71698){
var p1__68020_SHARP_ = cljs.core.first(arglist__71698);
arglist__71698 = cljs.core.next(arglist__71698);
var p2__68022_SHARP_ = cljs.core.first(arglist__71698);
var rest__68023_SHARP_ = cljs.core.rest(arglist__71698);
return G__71695__delegate(p1__68020_SHARP_,p2__68022_SHARP_,rest__68023_SHARP_);
});
G__71695.cljs$core$IFn$_invoke$arity$variadic = G__71695__delegate;
return G__71695;
})()
;})(moremore,temp__5816__auto__,G__68035_71690,G__68036_71691))
,cljs.core.first(more),moremore);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(a,((function (temp__5816__auto__,G__68035_71690,G__68036_71691){
return (function (p1__68024_SHARP_,p2__68025_SHARP_){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(m,p1__68024_SHARP_,p2__68025_SHARP_) : f.call(null,m,p1__68024_SHARP_,p2__68025_SHARP_));
});})(temp__5816__auto__,G__68035_71690,G__68036_71691))
,cljs.core.first(more));
}
});
G__71693 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71693__2.call(this,m,f);
case 3:
return G__71693__3.call(this,m,f,a);
case 4:
return G__71693__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71693.cljs$core$IFn$_invoke$arity$2 = G__71693__2;
G__71693.cljs$core$IFn$_invoke$arity$3 = G__71693__3;
G__71693.cljs$core$IFn$_invoke$arity$4 = G__71693__4;
return G__71693;
})()
;})(G__68035_71690,G__68036_71691))
;
goog.object.set(G__68035_71690,G__68036_71691,G__68037_71692);

var G__68046_71700 = clojure.core.matrix.protocols.element_map_BANG_;
var G__68047_71701 = "number";
var G__68048_71702 = ((function (G__68046_71700,G__68047_71701){
return (function() {
var G__71704 = null;
var G__71704__2 = (function (m,f){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("java.lang.Number instance is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71704__3 = (function (m,f,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("java.lang.Number instance is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71704__4 = (function (m,f,a,more){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("java.lang.Number instance is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});
G__71704 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71704__2.call(this,m,f);
case 3:
return G__71704__3.call(this,m,f,a);
case 4:
return G__71704__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71704.cljs$core$IFn$_invoke$arity$2 = G__71704__2;
G__71704.cljs$core$IFn$_invoke$arity$3 = G__71704__3;
G__71704.cljs$core$IFn$_invoke$arity$4 = G__71704__4;
return G__71704;
})()
;})(G__68046_71700,G__68047_71701))
;
goog.object.set(G__68046_71700,G__68047_71701,G__68048_71702);

var G__68054_71706 = clojure.core.matrix.protocols.element_reduce;
var G__68055_71707 = "number";
var G__68056_71708 = ((function (G__68054_71706,G__68055_71707){
return (function() {
var G__71709 = null;
var G__71709__2 = (function (m,f){
return m;
});
var G__71709__3 = (function (m,f,init){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(init,m) : f.call(null,init,m));
});
G__71709 = function(m,f,init){
switch(arguments.length){
case 2:
return G__71709__2.call(this,m,f);
case 3:
return G__71709__3.call(this,m,f,init);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71709.cljs$core$IFn$_invoke$arity$2 = G__71709__2;
G__71709.cljs$core$IFn$_invoke$arity$3 = G__71709__3;
return G__71709;
})()
;})(G__68054_71706,G__68055_71707))
;
goog.object.set(G__68054_71706,G__68055_71707,G__68056_71708);

goog.object.set(clojure.core.matrix.protocols.PFunctionalOperations,"object",true);

var G__68057_71711 = clojure.core.matrix.protocols.element_seq;
var G__68058_71712 = "object";
var G__68059_71713 = ((function (G__68057_71711,G__68058_71712){
return (function (m){
var c = cljs.core.type(m);
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
if((dims > (1))){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(clojure.core.matrix.protocols.element_seq,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([clojure.core.matrix.protocols.get_major_slice_seq(m)], 0));
} else {
if(cljs.core.seq_QMARK_(m)){
return m;
} else {
if(((0) === dims)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[clojure.core.matrix.protocols.get_0d(m)],null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Array,c)){
return m;
} else {
if(((1) === dims)){
return clojure.core.matrix.protocols.convert_to_nested_vectors(m);
} else {
if(cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(m))){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(clojure.core.matrix.protocols.element_seq,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([clojure.core.matrix.protocols.get_major_slice_seq(m)], 0));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Don't know how to create element-seq from: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m)].join(''),cljs.core.PersistentArrayMap.EMPTY);

}
}
}
}
}
}
});})(G__68057_71711,G__68058_71712))
;
goog.object.set(G__68057_71711,G__68058_71712,G__68059_71713);

var G__68064_71729 = clojure.core.matrix.protocols.element_map;
var G__68065_71730 = "object";
var G__68066_71731 = ((function (G__68064_71729,G__68065_71730){
return (function() {
var G__71732 = null;
var G__71732__2 = (function (m,f){
return clojure.core.matrix.impl.common.construct_matrix(m,clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$2(f,m));
});
var G__71732__3 = (function (m,f,a){
var vec__68068 = clojure.core.matrix.protocols.broadcast_same_shape(m,a);
var m__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68068,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68068,(1),null);
return clojure.core.matrix.impl.common.construct_matrix(m__$1,clojure.core.matrix.impl.common.mapmatrix.cljs$core$IFn$_invoke$arity$3(f,m__$1,a__$1));
});
var G__71732__4 = (function (m,f,a,more){
var arrays = cljs.core.cons(m,cljs.core.cons(a,more));
var shapes = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_shape,arrays);
var sh = (function (){var or__4131__auto__ = clojure.core.matrix.protocols.common_shape(shapes);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Attempt to do element map with incompatible shapes: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_shape,arrays))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
})();
var arrays__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (arrays,shapes,sh,G__68064_71729,G__68065_71730){
return (function (p1__68028_SHARP_){
return clojure.core.matrix.protocols.broadcast(p1__68028_SHARP_,sh);
});})(arrays,shapes,sh,G__68064_71729,G__68065_71730))
,arrays);
return clojure.core.matrix.impl.common.construct_matrix(m,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.core.matrix.impl.common.mapmatrix,f,arrays__$1));
});
G__71732 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71732__2.call(this,m,f);
case 3:
return G__71732__3.call(this,m,f,a);
case 4:
return G__71732__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71732.cljs$core$IFn$_invoke$arity$2 = G__71732__2;
G__71732.cljs$core$IFn$_invoke$arity$3 = G__71732__3;
G__71732.cljs$core$IFn$_invoke$arity$4 = G__71732__4;
return G__71732;
})()
;})(G__68064_71729,G__68065_71730))
;
goog.object.set(G__68064_71729,G__68065_71730,G__68066_71731);

var G__68076_71739 = clojure.core.matrix.protocols.element_map_BANG_;
var G__68077_71740 = "object";
var G__68078_71741 = ((function (G__68076_71739,G__68077_71740){
return (function() {
var G__71742 = null;
var G__71742__2 = (function (m,f){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,f));
});
var G__71742__3 = (function (m,f,a){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,f,a));
});
var G__71742__4 = (function (m,f,a,more){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$4(m,f,a,more));
});
G__71742 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71742__2.call(this,m,f);
case 3:
return G__71742__3.call(this,m,f,a);
case 4:
return G__71742__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71742.cljs$core$IFn$_invoke$arity$2 = G__71742__2;
G__71742.cljs$core$IFn$_invoke$arity$3 = G__71742__3;
G__71742.cljs$core$IFn$_invoke$arity$4 = G__71742__4;
return G__71742;
})()
;})(G__68076_71739,G__68077_71740))
;
goog.object.set(G__68076_71739,G__68077_71740,G__68078_71741);

var G__68081_71747 = clojure.core.matrix.protocols.element_reduce;
var G__68082_71748 = "object";
var G__68083_71749 = ((function (G__68081_71747,G__68082_71748){
return (function() {
var G__71750 = null;
var G__71750__2 = (function (m,f){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(f,clojure.core.matrix.protocols.element_seq(m));
});
var G__71750__3 = (function (m,f,init){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,init,clojure.core.matrix.protocols.element_seq(m));
});
G__71750 = function(m,f,init){
switch(arguments.length){
case 2:
return G__71750__2.call(this,m,f);
case 3:
return G__71750__3.call(this,m,f,init);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71750.cljs$core$IFn$_invoke$arity$2 = G__71750__2;
G__71750.cljs$core$IFn$_invoke$arity$3 = G__71750__3;
return G__71750;
})()
;})(G__68081_71747,G__68082_71748))
;
goog.object.set(G__68081_71747,G__68082_71748,G__68083_71749);

goog.object.set(clojure.core.matrix.protocols.PFunctionalOperations,"null",true);

var G__68084_71753 = clojure.core.matrix.protocols.element_seq;
var G__68085_71754 = "null";
var G__68086_71755 = ((function (G__68084_71753,G__68085_71754){
return (function (m){
return cljs.core.list(null);
});})(G__68084_71753,G__68085_71754))
;
goog.object.set(G__68084_71753,G__68085_71754,G__68086_71755);

var G__68089_71757 = clojure.core.matrix.protocols.element_map;
var G__68090_71758 = "null";
var G__68091_71759 = ((function (G__68089_71757,G__68090_71758){
return (function() {
var G__71760 = null;
var G__71760__2 = (function (m,f){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(null) : f.call(null,null));
});
var G__71760__3 = (function (m,f,a){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(null,a) : f.call(null,null,a));
});
var G__71760__4 = (function (m,f,a,more){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,null,a,more);
});
G__71760 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71760__2.call(this,m,f);
case 3:
return G__71760__3.call(this,m,f,a);
case 4:
return G__71760__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71760.cljs$core$IFn$_invoke$arity$2 = G__71760__2;
G__71760.cljs$core$IFn$_invoke$arity$3 = G__71760__3;
G__71760.cljs$core$IFn$_invoke$arity$4 = G__71760__4;
return G__71760;
})()
;})(G__68089_71757,G__68090_71758))
;
goog.object.set(G__68089_71757,G__68090_71758,G__68091_71759);

var G__68094_71773 = clojure.core.matrix.protocols.element_map_BANG_;
var G__68095_71774 = "null";
var G__68096_71775 = ((function (G__68094_71773,G__68095_71774){
return (function() {
var G__71776 = null;
var G__71776__2 = (function (m,f){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do element-map! on nil",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71776__3 = (function (m,f,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do element-map! on nil",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71776__4 = (function (m,f,a,more){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do element-map! on nil",cljs.core.PersistentArrayMap.EMPTY);
});
G__71776 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71776__2.call(this,m,f);
case 3:
return G__71776__3.call(this,m,f,a);
case 4:
return G__71776__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71776.cljs$core$IFn$_invoke$arity$2 = G__71776__2;
G__71776.cljs$core$IFn$_invoke$arity$3 = G__71776__3;
G__71776.cljs$core$IFn$_invoke$arity$4 = G__71776__4;
return G__71776;
})()
;})(G__68094_71773,G__68095_71774))
;
goog.object.set(G__68094_71773,G__68095_71774,G__68096_71775);

var G__68105_71782 = clojure.core.matrix.protocols.element_reduce;
var G__68106_71783 = "null";
var G__68107_71784 = ((function (G__68105_71782,G__68106_71783){
return (function() {
var G__71786 = null;
var G__71786__2 = (function (m,f){
return null;
});
var G__71786__3 = (function (m,f,init){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(init,null) : f.call(null,init,null));
});
G__71786 = function(m,f,init){
switch(arguments.length){
case 2:
return G__71786__2.call(this,m,f);
case 3:
return G__71786__3.call(this,m,f,init);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71786.cljs$core$IFn$_invoke$arity$2 = G__71786__2;
G__71786.cljs$core$IFn$_invoke$arity$3 = G__71786__3;
return G__71786;
})()
;})(G__68105_71782,G__68106_71783))
;
goog.object.set(G__68105_71782,G__68106_71783,G__68107_71784);

cljs.core.List.prototype.clojure$core$matrix$protocols$PFunctionalOperations$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.List.prototype.clojure$core$matrix$protocols$PFunctionalOperations$element_seq$arity$1 = (function (m){
var m__$1 = this;
if(((0) === cljs.core.count(m__$1))){
return null;
} else {
if((cljs.core.long$(clojure.core.matrix.protocols.dimensionality(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m__$1,(0)))) >= (1))){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(clojure.core.matrix.protocols.element_seq,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m__$1], 0));
} else {
return m__$1;

}
}
});
clojure.core.matrix.impl.defaults.cart = (function clojure$core$matrix$impl$defaults$cart(colls){
if(cljs.core.empty_QMARK_(colls)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null);
} else {
var iter__4523__auto__ = (function clojure$core$matrix$impl$defaults$cart_$_iter__68114(s__68115){
return (new cljs.core.LazySeq(null,(function (){
var s__68115__$1 = s__68115;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__68115__$1);
if(temp__5818__auto__){
var xs__6376__auto__ = temp__5818__auto__;
var x = cljs.core.first(xs__6376__auto__);
var iterys__4519__auto__ = ((function (s__68115__$1,x,xs__6376__auto__,temp__5818__auto__){
return (function clojure$core$matrix$impl$defaults$cart_$_iter__68114_$_iter__68116(s__68117){
return (new cljs.core.LazySeq(null,((function (s__68115__$1,x,xs__6376__auto__,temp__5818__auto__){
return (function (){
var s__68117__$1 = s__68117;
while(true){
var temp__5818__auto____$1 = cljs.core.seq(s__68117__$1);
if(temp__5818__auto____$1){
var s__68117__$2 = temp__5818__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__68117__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__68117__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__68119 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__68118 = (0);
while(true){
if((i__68118 < size__4522__auto__)){
var more = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__68118);
cljs.core.chunk_append(b__68119,cljs.core.cons(x,more));

var G__71797 = (i__68118 + (1));
i__68118 = G__71797;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__68119),clojure$core$matrix$impl$defaults$cart_$_iter__68114_$_iter__68116(cljs.core.chunk_rest(s__68117__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__68119),null);
}
} else {
var more = cljs.core.first(s__68117__$2);
return cljs.core.cons(cljs.core.cons(x,more),clojure$core$matrix$impl$defaults$cart_$_iter__68114_$_iter__68116(cljs.core.rest(s__68117__$2)));
}
} else {
return null;
}
break;
}
});})(s__68115__$1,x,xs__6376__auto__,temp__5818__auto__))
,null,null));
});})(s__68115__$1,x,xs__6376__auto__,temp__5818__auto__))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__((function (){var G__68127 = cljs.core.rest(colls);
return (clojure.core.matrix.impl.defaults.cart.cljs$core$IFn$_invoke$arity$1 ? clojure.core.matrix.impl.defaults.cart.cljs$core$IFn$_invoke$arity$1(G__68127) : clojure.core.matrix.impl.defaults.cart.call(null,G__68127));
})()));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,clojure$core$matrix$impl$defaults$cart_$_iter__68114(cljs.core.rest(s__68115__$1)));
} else {
var G__71800 = cljs.core.rest(s__68115__$1);
s__68115__$1 = G__71800;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(cljs.core.first(colls));
}
});
clojure.core.matrix.impl.defaults.indices_seq = (function clojure$core$matrix$impl$defaults$indices_seq(m){
return clojure.core.matrix.impl.defaults.cart(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.range,clojure.core.matrix.protocols.get_shape(m)));
});
goog.object.set(clojure.core.matrix.protocols.PMapIndexed,"number",true);

var G__68148_71802 = clojure.core.matrix.protocols.element_map_indexed;
var G__68149_71803 = "number";
var G__68150_71804 = ((function (G__68148_71802,G__68149_71803){
return (function() {
var G__71806 = null;
var G__71806__2 = (function (m,f){
var G__68151 = cljs.core.PersistentVector.EMPTY;
var G__68152 = m;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__68151,G__68152) : f.call(null,G__68151,G__68152));
});
var G__71806__3 = (function (m,f,a){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(a,((function (G__68148_71802,G__68149_71803){
return (function (p1__68134_SHARP_){
var G__68153 = cljs.core.PersistentVector.EMPTY;
var G__68154 = m;
var G__68155 = p1__68134_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__68153,G__68154,G__68155) : f.call(null,G__68153,G__68154,G__68155));
});})(G__68148_71802,G__68149_71803))
);
});
var G__71806__4 = (function (m,f,a,more){
var temp__5816__auto__ = cljs.core.next(more);
if(temp__5816__auto__){
var moremore = temp__5816__auto__;
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$4(a,((function (moremore,temp__5816__auto__,G__68148_71802,G__68149_71803){
return (function() { 
var G__71809__delegate = function (p1__68135_SHARP_,p2__68136_SHARP_,rest__68137_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.PersistentVector.EMPTY,m,p1__68135_SHARP_,p2__68136_SHARP_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([rest__68137_SHARP_], 0));
};
var G__71809 = function (p1__68135_SHARP_,p2__68136_SHARP_,var_args){
var rest__68137_SHARP_ = null;
if (arguments.length > 2) {
var G__71810__i = 0, G__71810__a = new Array(arguments.length -  2);
while (G__71810__i < G__71810__a.length) {G__71810__a[G__71810__i] = arguments[G__71810__i + 2]; ++G__71810__i;}
  rest__68137_SHARP_ = new cljs.core.IndexedSeq(G__71810__a,0,null);
} 
return G__71809__delegate.call(this,p1__68135_SHARP_,p2__68136_SHARP_,rest__68137_SHARP_);};
G__71809.cljs$lang$maxFixedArity = 2;
G__71809.cljs$lang$applyTo = (function (arglist__71811){
var p1__68135_SHARP_ = cljs.core.first(arglist__71811);
arglist__71811 = cljs.core.next(arglist__71811);
var p2__68136_SHARP_ = cljs.core.first(arglist__71811);
var rest__68137_SHARP_ = cljs.core.rest(arglist__71811);
return G__71809__delegate(p1__68135_SHARP_,p2__68136_SHARP_,rest__68137_SHARP_);
});
G__71809.cljs$core$IFn$_invoke$arity$variadic = G__71809__delegate;
return G__71809;
})()
;})(moremore,temp__5816__auto__,G__68148_71802,G__68149_71803))
,cljs.core.first(more),moremore);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(a,((function (temp__5816__auto__,G__68148_71802,G__68149_71803){
return (function (p1__68141_SHARP_,p2__68142_SHARP_){
var G__68161 = cljs.core.PersistentVector.EMPTY;
var G__68162 = m;
var G__68163 = p1__68141_SHARP_;
var G__68164 = p2__68142_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__68161,G__68162,G__68163,G__68164) : f.call(null,G__68161,G__68162,G__68163,G__68164));
});})(temp__5816__auto__,G__68148_71802,G__68149_71803))
,cljs.core.first(more));
}
});
G__71806 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71806__2.call(this,m,f);
case 3:
return G__71806__3.call(this,m,f,a);
case 4:
return G__71806__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71806.cljs$core$IFn$_invoke$arity$2 = G__71806__2;
G__71806.cljs$core$IFn$_invoke$arity$3 = G__71806__3;
G__71806.cljs$core$IFn$_invoke$arity$4 = G__71806__4;
return G__71806;
})()
;})(G__68148_71802,G__68149_71803))
;
goog.object.set(G__68148_71802,G__68149_71803,G__68150_71804);

var G__68165_71819 = clojure.core.matrix.protocols.element_map_indexed_BANG_;
var G__68166_71820 = "number";
var G__68167_71821 = ((function (G__68165_71819,G__68166_71820){
return (function() {
var G__71824 = null;
var G__71824__2 = (function (m,f){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("java.lang.Number instance is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71824__3 = (function (m,f,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("java.lang.Number instance is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71824__4 = (function (m,f,a,more){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("java.lang.Number instance is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});
G__71824 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71824__2.call(this,m,f);
case 3:
return G__71824__3.call(this,m,f,a);
case 4:
return G__71824__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71824.cljs$core$IFn$_invoke$arity$2 = G__71824__2;
G__71824.cljs$core$IFn$_invoke$arity$3 = G__71824__3;
G__71824.cljs$core$IFn$_invoke$arity$4 = G__71824__4;
return G__71824;
})()
;})(G__68165_71819,G__68166_71820))
;
goog.object.set(G__68165_71819,G__68166_71820,G__68167_71821);

goog.object.set(clojure.core.matrix.protocols.PMapIndexed,"object",true);

var G__68177_71828 = clojure.core.matrix.protocols.element_map_indexed;
var G__68178_71829 = "object";
var G__68179_71830 = ((function (G__68177_71828,G__68178_71829){
return (function() {
var G__71831 = null;
var G__71831__2 = (function (m,f){
if(((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))){
var G__68180 = cljs.core.PersistentVector.EMPTY;
var G__68181 = clojure.core.matrix.protocols.get_0d(m);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__68180,G__68181) : f.call(null,G__68180,G__68181));
} else {
var s = cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,clojure.core.matrix.impl.defaults.indices_seq(m),clojure.core.matrix.protocols.element_seq(m));
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.coerce_param(m,s),clojure.core.matrix.protocols.get_shape(m));
}
});
var G__71831__3 = (function (m,f,a){
if(((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))){
var v = clojure.core.matrix.protocols.get_0d(m);
return clojure.core.matrix.protocols.element_map_indexed.cljs$core$IFn$_invoke$arity$2(a,((function (v,G__68177_71828,G__68178_71829){
return (function (p1__68143_SHARP_,p2__68144_SHARP_){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(p1__68143_SHARP_,v,p2__68144_SHARP_) : f.call(null,p1__68143_SHARP_,v,p2__68144_SHARP_));
});})(v,G__68177_71828,G__68178_71829))
);
} else {
var vec__68189 = clojure.core.matrix.protocols.broadcast_compatible(m,a);
var m__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68189,(0),null);
var a__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68189,(1),null);
var s = cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,clojure.core.matrix.impl.defaults.indices_seq(m__$1),clojure.core.matrix.protocols.element_seq(m__$1),clojure.core.matrix.protocols.element_seq(a__$1));
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.coerce_param(m__$1,s),clojure.core.matrix.protocols.get_shape(m__$1));
}
});
var G__71831__4 = (function (m,f,a,more){
var s = cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,clojure.core.matrix.protocols.element_seq(m),clojure.core.matrix.protocols.element_seq(a));
var s__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(clojure.core.matrix.impl.defaults.indices_seq(m),clojure.core.matrix.protocols.element_seq(m),clojure.core.matrix.protocols.element_seq(a),cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.element_seq,more)));
return clojure.core.matrix.protocols.reshape(clojure.core.matrix.protocols.coerce_param(m,s__$1),clojure.core.matrix.protocols.get_shape(m));
});
G__71831 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71831__2.call(this,m,f);
case 3:
return G__71831__3.call(this,m,f,a);
case 4:
return G__71831__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71831.cljs$core$IFn$_invoke$arity$2 = G__71831__2;
G__71831.cljs$core$IFn$_invoke$arity$3 = G__71831__3;
G__71831.cljs$core$IFn$_invoke$arity$4 = G__71831__4;
return G__71831;
})()
;})(G__68177_71828,G__68178_71829))
;
goog.object.set(G__68177_71828,G__68178_71829,G__68179_71830);

var G__68193_71842 = clojure.core.matrix.protocols.element_map_indexed_BANG_;
var G__68194_71843 = "object";
var G__68195_71844 = ((function (G__68193_71842,G__68194_71843){
return (function() {
var G__71846 = null;
var G__71846__2 = (function (m,f){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map_indexed.cljs$core$IFn$_invoke$arity$2(m,f));
});
var G__71846__3 = (function (m,f,a){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map_indexed.cljs$core$IFn$_invoke$arity$3(m,f,a));
});
var G__71846__4 = (function (m,f,a,more){
return clojure.core.matrix.protocols.assign_BANG_(m,clojure.core.matrix.protocols.element_map_indexed.cljs$core$IFn$_invoke$arity$4(m,f,a,more));
});
G__71846 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71846__2.call(this,m,f);
case 3:
return G__71846__3.call(this,m,f,a);
case 4:
return G__71846__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71846.cljs$core$IFn$_invoke$arity$2 = G__71846__2;
G__71846.cljs$core$IFn$_invoke$arity$3 = G__71846__3;
G__71846.cljs$core$IFn$_invoke$arity$4 = G__71846__4;
return G__71846;
})()
;})(G__68193_71842,G__68194_71843))
;
goog.object.set(G__68193_71842,G__68194_71843,G__68195_71844);

goog.object.set(clojure.core.matrix.protocols.PMapIndexed,"null",true);

var G__68198_71853 = clojure.core.matrix.protocols.element_map_indexed;
var G__68199_71854 = "null";
var G__68200_71855 = ((function (G__68198_71853,G__68199_71854){
return (function() {
var G__71861 = null;
var G__71861__2 = (function (m,f){
var G__68201 = cljs.core.PersistentVector.EMPTY;
var G__68202 = null;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__68201,G__68202) : f.call(null,G__68201,G__68202));
});
var G__71861__3 = (function (m,f,a){
var G__68204 = cljs.core.PersistentVector.EMPTY;
var G__68205 = null;
var G__68206 = a;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__68204,G__68205,G__68206) : f.call(null,G__68204,G__68205,G__68206));
});
var G__71861__4 = (function (m,f,a,more){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,cljs.core.PersistentVector.EMPTY,null,a,more);
});
G__71861 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71861__2.call(this,m,f);
case 3:
return G__71861__3.call(this,m,f,a);
case 4:
return G__71861__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71861.cljs$core$IFn$_invoke$arity$2 = G__71861__2;
G__71861.cljs$core$IFn$_invoke$arity$3 = G__71861__3;
G__71861.cljs$core$IFn$_invoke$arity$4 = G__71861__4;
return G__71861;
})()
;})(G__68198_71853,G__68199_71854))
;
goog.object.set(G__68198_71853,G__68199_71854,G__68200_71855);

var G__68207_71864 = clojure.core.matrix.protocols.element_map_indexed_BANG_;
var G__68208_71865 = "null";
var G__68209_71866 = ((function (G__68207_71864,G__68208_71865){
return (function() {
var G__71867 = null;
var G__71867__2 = (function (m,f){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do element-map-indexed! on nil",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71867__3 = (function (m,f,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do element-map-indexed! on nil",cljs.core.PersistentArrayMap.EMPTY);
});
var G__71867__4 = (function (m,f,a,more){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't do element-map-indexed! on nil",cljs.core.PersistentArrayMap.EMPTY);
});
G__71867 = function(m,f,a,more){
switch(arguments.length){
case 2:
return G__71867__2.call(this,m,f);
case 3:
return G__71867__3.call(this,m,f,a);
case 4:
return G__71867__4.call(this,m,f,a,more);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71867.cljs$core$IFn$_invoke$arity$2 = G__71867__2;
G__71867.cljs$core$IFn$_invoke$arity$3 = G__71867__3;
G__71867.cljs$core$IFn$_invoke$arity$4 = G__71867__4;
return G__71867;
})()
;})(G__68207_71864,G__68208_71865))
;
goog.object.set(G__68207_71864,G__68208_71865,G__68209_71866);
goog.object.set(clojure.core.matrix.protocols.PElementCount,"null",true);

var G__68211_71871 = clojure.core.matrix.protocols.element_count;
var G__68212_71872 = "null";
var G__68213_71873 = ((function (G__68211_71871,G__68212_71872){
return (function (m){
return (1);
});})(G__68211_71871,G__68212_71872))
;
goog.object.set(G__68211_71871,G__68212_71872,G__68213_71873);

goog.object.set(clojure.core.matrix.protocols.PElementCount,"number",true);

var G__68215_71875 = clojure.core.matrix.protocols.element_count;
var G__68216_71876 = "number";
var G__68217_71877 = ((function (G__68215_71875,G__68216_71876){
return (function (m){
return (1);
});})(G__68215_71875,G__68216_71876))
;
goog.object.set(G__68215_71875,G__68216_71876,G__68217_71877);

goog.object.set(clojure.core.matrix.protocols.PElementCount,"object",true);

var G__68218_71882 = clojure.core.matrix.protocols.element_count;
var G__68219_71883 = "object";
var G__68220_71884 = ((function (G__68218_71882,G__68219_71883){
return (function (m){
return clojure.core.matrix.impl.defaults.calc_element_count(m);
});})(G__68218_71882,G__68219_71883))
;
goog.object.set(G__68218_71882,G__68219_71883,G__68220_71884);
goog.object.set(clojure.core.matrix.protocols.PValidateShape,"null",true);

var G__68231_71885 = clojure.core.matrix.protocols.validate_shape;
var G__68232_71886 = "null";
var G__68233_71887 = ((function (G__68231_71885,G__68232_71886){
return (function() {
var G__71889 = null;
var G__71889__1 = (function (m){
return null;
});
var G__71889__2 = (function (m,shape){
if((shape == null)){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Shape validation failed, was scalar but expected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shape)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});
G__71889 = function(m,shape){
switch(arguments.length){
case 1:
return G__71889__1.call(this,m);
case 2:
return G__71889__2.call(this,m,shape);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71889.cljs$core$IFn$_invoke$arity$1 = G__71889__1;
G__71889.cljs$core$IFn$_invoke$arity$2 = G__71889__2;
return G__71889;
})()
;})(G__68231_71885,G__68232_71886))
;
goog.object.set(G__68231_71885,G__68232_71886,G__68233_71887);

goog.object.set(clojure.core.matrix.protocols.PValidateShape,"object",true);

var G__68234_71890 = clojure.core.matrix.protocols.validate_shape;
var G__68235_71891 = "object";
var G__68236_71892 = ((function (G__68234_71890,G__68235_71891){
return (function() {
var G__71897 = null;
var G__71897__1 = (function (m){
return clojure.core.matrix.protocols.validate_shape.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.protocols.get_shape(m));
});
var G__71897__2 = (function (m,expected_shape){
if(((0) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))){
var sh = clojure.core.matrix.protocols.get_shape(m);
if((sh == null)){
if((expected_shape == null)){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Shape validation failed, was scalar but expected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expected_shape)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(sh),cljs.core.vec(expected_shape))){
return sh;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Shape validation failed, was ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sh)," but expected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expected_shape)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
}
} else {
var sh = clojure.core.matrix.protocols.get_shape(m);
var ss = clojure.core.matrix.protocols.get_major_slice_seq(m);
var efirst = (function (){var or__4131__auto__ = cljs.core.first(expected_shape);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Shape validation failed, was ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sh)," but expected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expected_shape)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
})();
var enext = cljs.core.next(expected_shape);
var shapes = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (sh,ss,efirst,enext,G__68234_71890,G__68235_71891){
return (function (p1__68227_SHARP_){
return clojure.core.matrix.protocols.validate_shape.cljs$core$IFn$_invoke$arity$2(p1__68227_SHARP_,enext);
});})(sh,ss,efirst,enext,G__68234_71890,G__68235_71891))
,ss);
if(cljs.core.truth_(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core._EQ_,enext,shapes))){
return cljs.core.vec(cljs.core.cons(clojure.core.matrix.protocols.dimension_count(m,(0)),cljs.core.first(shapes)));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Inconsistent shapes for sub arrays in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(m))].join(''),cljs.core.PersistentArrayMap.EMPTY);
}

}
});
G__71897 = function(m,expected_shape){
switch(arguments.length){
case 1:
return G__71897__1.call(this,m);
case 2:
return G__71897__2.call(this,m,expected_shape);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__71897.cljs$core$IFn$_invoke$arity$1 = G__71897__1;
G__71897.cljs$core$IFn$_invoke$arity$2 = G__71897__2;
return G__71897;
})()
;})(G__68234_71890,G__68235_71891))
;
goog.object.set(G__68234_71890,G__68235_71891,G__68236_71892);
goog.object.set(clojure.core.matrix.protocols.PMatrixSlices,"object",true);

var G__68252_71909 = clojure.core.matrix.protocols.get_row;
var G__68253_71910 = "object";
var G__68254_71911 = ((function (G__68252_71909,G__68253_71910){
return (function (m,i){
if((Array === m.constructor)){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,i);
} else {
return clojure.core.matrix.protocols.get_major_slice(m,i);
}
});})(G__68252_71909,G__68253_71910))
;
goog.object.set(G__68252_71909,G__68253_71910,G__68254_71911);

var G__68258_71912 = clojure.core.matrix.protocols.get_column;
var G__68259_71913 = "object";
var G__68260_71914 = ((function (G__68258_71912,G__68259_71913){
return (function (m,i){
return clojure.core.matrix.protocols.get_slice(m,(1),i);
});})(G__68258_71912,G__68259_71913))
;
goog.object.set(G__68258_71912,G__68259_71913,G__68260_71914);

var G__68261_71919 = clojure.core.matrix.protocols.get_major_slice;
var G__68262_71920 = "object";
var G__68263_71921 = ((function (G__68261_71919,G__68262_71920){
return (function (m,i){
if((Array === m.constructor)){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,i);
} else {
if(((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)))){
return clojure.core.matrix.protocols.get_1d(m,i);
} else {
return clojure.core.matrix.impl.wrappers.wrap_slice(m,i);

}
}
});})(G__68261_71919,G__68262_71920))
;
goog.object.set(G__68261_71919,G__68262_71920,G__68263_71921);

var G__68266_71925 = clojure.core.matrix.protocols.get_slice;
var G__68267_71926 = "object";
var G__68268_71927 = ((function (G__68266_71925,G__68267_71926){
return (function (m,dimension,i){
var ldimension = cljs.core.long$(dimension);
if(((0) === ldimension)){
return clojure.core.matrix.protocols.get_major_slice(m,i);
} else {
return clojure.core.matrix.protocols.get_slice(clojure.core.matrix.protocols.convert_to_nested_vectors(m),dimension,i);

}
});})(G__68266_71925,G__68267_71926))
;
goog.object.set(G__68266_71925,G__68267_71926,G__68268_71927);
goog.object.set(clojure.core.matrix.protocols.PBLASBase,"object",true);

var G__68276_71936 = clojure.core.matrix.protocols.gemm_BANG_;
var G__68277_71937 = "object";
var G__68278_71938 = ((function (G__68276_71936,G__68277_71937){
return (function (c,trans_a_QMARK_,trans_b_QMARK_,alpha,a,b,beta){
var a__$1 = (cljs.core.truth_(trans_a_QMARK_)?clojure.core.matrix.protocols.transpose(a):a);
var b__$1 = (cljs.core.truth_(trans_b_QMARK_)?clojure.core.matrix.protocols.transpose(b):b);
if((!((1.0 === beta)))){
clojure.core.matrix.protocols.scale_BANG_(c,beta);
} else {
}

return clojure.core.matrix.protocols.add_inner_product_BANG_.cljs$core$IFn$_invoke$arity$4(c,a__$1,b__$1,alpha);
});})(G__68276_71936,G__68277_71937))
;
goog.object.set(G__68276_71936,G__68277_71937,G__68278_71938);

var G__68281_71943 = clojure.core.matrix.protocols.gemv_BANG_;
var G__68282_71944 = "object";
var G__68283_71945 = ((function (G__68281_71943,G__68282_71944){
return (function (c,trans_a_QMARK_,alpha,a,b,beta){
var a__$1 = (cljs.core.truth_(trans_a_QMARK_)?clojure.core.matrix.protocols.transpose(a):a);
if((!((1.0 === beta)))){
clojure.core.matrix.protocols.scale_BANG_(c,beta);
} else {
}

return clojure.core.matrix.protocols.add_inner_product_BANG_.cljs$core$IFn$_invoke$arity$4(c,a__$1,b,alpha);
});})(G__68281_71943,G__68282_71944))
;
goog.object.set(G__68281_71943,G__68282_71944,G__68283_71945);
goog.object.set(clojure.core.matrix.protocols.PMatrixColumns,"object",true);

var G__68293_71950 = clojure.core.matrix.protocols.get_columns;
var G__68294_71951 = "object";
var G__68295_71952 = ((function (G__68293_71950,G__68294_71951){
return (function (m){
var G__68297 = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
switch (G__68297) {
case (0):
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't get columns of a 0-dimensional object",cljs.core.PersistentArrayMap.EMPTY);

break;
case (1):
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't get columns of a 1-dimensional object",cljs.core.PersistentArrayMap.EMPTY);

break;
case (2):
return cljs.core.vec(clojure.core.matrix.protocols.get_slice_seq(m,(1)));

break;
default:
return cljs.core.vec(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(clojure.core.matrix.protocols.get_columns,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([clojure.core.matrix.protocols.get_major_slice_seq(m)], 0)));

}
});})(G__68293_71950,G__68294_71951))
;
goog.object.set(G__68293_71950,G__68294_71951,G__68295_71952);
goog.object.set(clojure.core.matrix.protocols.PMatrixRows,"object",true);

var G__68298_71957 = clojure.core.matrix.protocols.get_rows;
var G__68300_71958 = "object";
var G__68301_71959 = ((function (G__68298_71957,G__68300_71958){
return (function (m){
var G__68310 = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
switch (G__68310) {
case (0):
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't get rows of a 0-dimensional object",cljs.core.PersistentArrayMap.EMPTY);

break;
case (1):
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't get rows of a 1-dimensional object",cljs.core.PersistentArrayMap.EMPTY);

break;
case (2):
return cljs.core.vec(clojure.core.matrix.protocols.get_major_slice_seq(m));

break;
default:
return cljs.core.vec(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(clojure.core.matrix.protocols.get_rows,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([clojure.core.matrix.protocols.get_major_slice_seq(m)], 0)));

}
});})(G__68298_71957,G__68300_71958))
;
goog.object.set(G__68298_71957,G__68300_71958,G__68301_71959);
goog.object.set(clojure.core.matrix.protocols.PSliceView,"object",true);

var G__68312_71967 = clojure.core.matrix.protocols.get_major_slice_view;
var G__68313_71968 = "object";
var G__68314_71969 = ((function (G__68312_71967,G__68313_71968){
return (function (m,i){
if((Array === m.constructor)){
var ss = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(m,i);
if(cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(ss))){
return ss;
} else {
return clojure.core.matrix.impl.wrappers.wrap_slice(m,i);
}
} else {
return clojure.core.matrix.impl.wrappers.wrap_slice(m,i);

}
});})(G__68312_71967,G__68313_71968))
;
goog.object.set(G__68312_71967,G__68313_71968,G__68314_71969);
goog.object.set(clojure.core.matrix.protocols.PSliceView2,"object",true);

var G__68322_71971 = clojure.core.matrix.protocols.get_slice_view;
var G__68323_71972 = "object";
var G__68324_71973 = ((function (G__68322_71971,G__68323_71972){
return (function (m,dim,i){
if((dim === (0))){
return clojure.core.matrix.protocols.get_major_slice_view(m,i);
} else {
return clojure.core.matrix.impl.wrappers.wrap_nd(m).clojure$core$matrix$protocols$PSliceView2$get_slice_view$arity$3(null,dim,i);
}
});})(G__68322_71971,G__68323_71972))
;
goog.object.set(G__68322_71971,G__68323_71972,G__68324_71973);
goog.object.set(clojure.core.matrix.protocols.PSliceSeq,"object",true);

var G__68326_71976 = clojure.core.matrix.protocols.get_major_slice_seq;
var G__68328_71977 = "object";
var G__68330_71978 = ((function (G__68326_71976,G__68328_71977){
return (function (m){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
if((dims <= (0))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't get slices on [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dims),"]-dimensional object"].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(Array,cljs.core.type(m))){
return cljs.core.seq(m);
} else {
if((dims === (1))){
var iter__4523__auto__ = ((function (dims,G__68326_71976,G__68328_71977){
return (function clojure$core$matrix$impl$defaults$iter__68331(s__68332){
return (new cljs.core.LazySeq(null,((function (dims,G__68326_71976,G__68328_71977){
return (function (){
var s__68332__$1 = s__68332;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__68332__$1);
if(temp__5818__auto__){
var s__68332__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__68332__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__68332__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__68334 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__68333 = (0);
while(true){
if((i__68333 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__68333);
cljs.core.chunk_append(b__68334,clojure.core.matrix.protocols.get_1d(m,i));

var G__71989 = (i__68333 + (1));
i__68333 = G__71989;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__68334),clojure$core$matrix$impl$defaults$iter__68331(cljs.core.chunk_rest(s__68332__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__68334),null);
}
} else {
var i = cljs.core.first(s__68332__$2);
return cljs.core.cons(clojure.core.matrix.protocols.get_1d(m,i),clojure$core$matrix$impl$defaults$iter__68331(cljs.core.rest(s__68332__$2)));
}
} else {
return null;
}
break;
}
});})(dims,G__68326_71976,G__68328_71977))
,null,null));
});})(dims,G__68326_71976,G__68328_71977))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(m,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (dims,G__68326_71976,G__68328_71977){
return (function (p1__68325_SHARP_){
return clojure.core.matrix.protocols.get_major_slice(m,p1__68325_SHARP_);
});})(dims,G__68326_71976,G__68328_71977))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(m,(0))));

}
}
}
});})(G__68326_71976,G__68328_71977))
;
goog.object.set(G__68326_71976,G__68328_71977,G__68330_71978);
goog.object.set(clojure.core.matrix.protocols.PSliceSeq2,"object",true);

var G__68350_71994 = clojure.core.matrix.protocols.get_slice_seq;
var G__68351_71995 = "object";
var G__68352_71996 = ((function (G__68350_71994,G__68351_71995){
return (function (m,dimension){
var ldimension = cljs.core.long$(dimension);
if((ldimension === (0))){
return clojure.core.matrix.protocols.get_major_slice_seq(m);
} else {
if((ldimension < (0))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't get slices of a negative dimension: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dimension)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ldimension,G__68350_71994,G__68351_71995){
return (function (p1__68342_SHARP_){
return clojure.core.matrix.protocols.get_slice(m,dimension,p1__68342_SHARP_);
});})(ldimension,G__68350_71994,G__68351_71995))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(m,dimension)));

}
}
});})(G__68350_71994,G__68351_71995))
;
goog.object.set(G__68350_71994,G__68351_71995,G__68352_71996);
goog.object.set(clojure.core.matrix.protocols.PSliceViewSeq,"object",true);

var G__68358_72002 = clojure.core.matrix.protocols.get_major_slice_view_seq;
var G__68359_72003 = "object";
var G__68360_72004 = ((function (G__68358_72002,G__68359_72003){
return (function (m){
var n = clojure.core.matrix.protocols.dimension_count(m,(0));
var iter__4523__auto__ = ((function (n,G__68358_72002,G__68359_72003){
return (function clojure$core$matrix$impl$defaults$iter__68362(s__68363){
return (new cljs.core.LazySeq(null,((function (n,G__68358_72002,G__68359_72003){
return (function (){
var s__68363__$1 = s__68363;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__68363__$1);
if(temp__5818__auto__){
var s__68363__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__68363__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__68363__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__68365 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__68364 = (0);
while(true){
if((i__68364 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__68364);
cljs.core.chunk_append(b__68365,clojure.core.matrix.protocols.get_major_slice_view(m,i));

var G__72006 = (i__68364 + (1));
i__68364 = G__72006;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__68365),clojure$core$matrix$impl$defaults$iter__68362(cljs.core.chunk_rest(s__68363__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__68365),null);
}
} else {
var i = cljs.core.first(s__68363__$2);
return cljs.core.cons(clojure.core.matrix.protocols.get_major_slice_view(m,i),clojure$core$matrix$impl$defaults$iter__68362(cljs.core.rest(s__68363__$2)));
}
} else {
return null;
}
break;
}
});})(n,G__68358_72002,G__68359_72003))
,null,null));
});})(n,G__68358_72002,G__68359_72003))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(n));
});})(G__68358_72002,G__68359_72003))
;
goog.object.set(G__68358_72002,G__68359_72003,G__68360_72004);
goog.object.set(clojure.core.matrix.protocols.PSliceJoin,"null",true);

var G__68374_72008 = clojure.core.matrix.protocols.join;
var G__68375_72009 = "null";
var G__68376_72010 = ((function (G__68374_72008,G__68375_72009){
return (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't join an array to a nil value!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__68374_72008,G__68375_72009))
;
goog.object.set(G__68374_72008,G__68375_72009,G__68376_72010);

goog.object.set(clojure.core.matrix.protocols.PSliceJoin,"number",true);

var G__68379_72012 = clojure.core.matrix.protocols.join;
var G__68380_72013 = "number";
var G__68381_72014 = ((function (G__68379_72012,G__68380_72013){
return (function (m,a){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't join an array to a scalar number!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__68379_72012,G__68380_72013))
;
goog.object.set(G__68379_72012,G__68380_72013,G__68381_72014);

goog.object.set(clojure.core.matrix.protocols.PSliceJoin,"object",true);

var G__68382_72016 = clojure.core.matrix.protocols.join;
var G__68383_72017 = "object";
var G__68384_72018 = ((function (G__68382_72016,G__68383_72017){
return (function (m,a){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
var adims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(a));
if((dims === (0))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't join to a 0-dimensional array!",cljs.core.PersistentArrayMap.EMPTY);
} else {
if((dims === adims)){
return clojure.core.matrix.protocols.coerce_param(m,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_major_slice_seq(m),clojure.core.matrix.protocols.get_major_slice_seq(a)));
} else {
if((dims === (adims + (1)))){
return clojure.core.matrix.protocols.coerce_param(m,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_major_slice_seq(m),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [a], null)));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Joining with array of incompatible size",cljs.core.PersistentArrayMap.EMPTY);

}
}
}
});})(G__68382_72016,G__68383_72017))
;
goog.object.set(G__68382_72016,G__68383_72017,G__68384_72018);
goog.object.set(clojure.core.matrix.protocols.PSliceJoinAlong,"null",true);

var G__68393_72020 = clojure.core.matrix.protocols.join_along;
var G__68394_72021 = "null";
var G__68395_72022 = ((function (G__68393_72020,G__68394_72021){
return (function (m,a,dim){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't join an array to a nil value!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__68393_72020,G__68394_72021))
;
goog.object.set(G__68393_72020,G__68394_72021,G__68395_72022);

goog.object.set(clojure.core.matrix.protocols.PSliceJoinAlong,"number",true);

var G__68396_72027 = clojure.core.matrix.protocols.join_along;
var G__68397_72028 = "number";
var G__68398_72029 = ((function (G__68396_72027,G__68397_72028){
return (function (m,a,dim){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't join an array to a scalar number!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__68396_72027,G__68397_72028))
;
goog.object.set(G__68396_72027,G__68397_72028,G__68398_72029);

goog.object.set(clojure.core.matrix.protocols.PSliceJoinAlong,"object",true);

var G__68410_72034 = clojure.core.matrix.protocols.join_along;
var G__68411_72035 = "object";
var G__68412_72036 = ((function (G__68410_72034,G__68411_72035){
return (function (m,a,dim){
return clojure.core.matrix.protocols.coerce_param(m,(function (){var dim__$1 = cljs.core.long$(dim);
if((dim__$1 === (0))){
return clojure.core.matrix.protocols.join(m,a);
} else {
var ddim = (dim__$1 - (1));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(((function (ddim,dim__$1,G__68410_72034,G__68411_72035){
return (function (p1__68391_SHARP_,p2__68392_SHARP_){
return clojure.core.matrix.protocols.join_along(p1__68391_SHARP_,p2__68392_SHARP_,ddim);
});})(ddim,dim__$1,G__68410_72034,G__68411_72035))
,clojure.core.matrix.protocols.get_major_slice_seq(m),clojure.core.matrix.protocols.get_major_slice_seq(a));

}
})());
});})(G__68410_72034,G__68411_72035))
;
goog.object.set(G__68410_72034,G__68411_72035,G__68412_72036);
goog.object.set(clojure.core.matrix.protocols.PSubVector,"null",true);

var G__68416_72046 = clojure.core.matrix.protocols.subvector;
var G__68417_72047 = "null";
var G__68418_72048 = ((function (G__68416_72046,G__68417_72047){
return (function (m,start,length){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't take subvector of nil",cljs.core.PersistentArrayMap.EMPTY);
});})(G__68416_72046,G__68417_72047))
;
goog.object.set(G__68416_72046,G__68417_72047,G__68418_72048);

goog.object.set(clojure.core.matrix.protocols.PSubVector,"number",true);

var G__68421_72049 = clojure.core.matrix.protocols.subvector;
var G__68422_72050 = "number";
var G__68423_72051 = ((function (G__68421_72049,G__68422_72050){
return (function (m,start,length){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't take subvector of a scalar number",cljs.core.PersistentArrayMap.EMPTY);
});})(G__68421_72049,G__68422_72050))
;
goog.object.set(G__68421_72049,G__68422_72050,G__68423_72051);

goog.object.set(clojure.core.matrix.protocols.PSubVector,"object",true);

var G__68425_72052 = clojure.core.matrix.protocols.subvector;
var G__68426_72053 = "object";
var G__68427_72054 = ((function (G__68425_72052,G__68426_72053){
return (function (m,start,length){
return clojure.core.matrix.impl.wrappers.wrap_nd(m).clojure$core$matrix$protocols$PSubVector$subvector$arity$3(null,start,length);
});})(G__68425_72052,G__68426_72053))
;
goog.object.set(G__68425_72052,G__68426_72053,G__68427_72054);
goog.object.set(clojure.core.matrix.protocols.PSubMatrix,"null",true);

var G__68433_72056 = clojure.core.matrix.protocols.submatrix;
var G__68434_72057 = "null";
var G__68435_72058 = ((function (G__68433_72056,G__68434_72057){
return (function (m,index_ranges){
if(cljs.core.seq(index_ranges)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't take partial submatrix of nil",cljs.core.PersistentArrayMap.EMPTY);
} else {
return m;
}
});})(G__68433_72056,G__68434_72057))
;
goog.object.set(G__68433_72056,G__68434_72057,G__68435_72058);

goog.object.set(clojure.core.matrix.protocols.PSubMatrix,"number",true);

var G__68438_72060 = clojure.core.matrix.protocols.submatrix;
var G__68439_72061 = "number";
var G__68440_72062 = ((function (G__68438_72060,G__68439_72061){
return (function (m,index_ranges){
if(cljs.core.seq(index_ranges)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't take partial submatrix of a scalar number",cljs.core.PersistentArrayMap.EMPTY);
} else {
return m;
}
});})(G__68438_72060,G__68439_72061))
;
goog.object.set(G__68438_72060,G__68439_72061,G__68440_72062);

goog.object.set(clojure.core.matrix.protocols.PSubMatrix,"object",true);

var G__68447_72067 = clojure.core.matrix.protocols.submatrix;
var G__68448_72068 = "object";
var G__68449_72069 = ((function (G__68447_72067,G__68448_72068){
return (function (m,index_ranges){
return clojure.core.matrix.impl.wrappers.wrap_submatrix(m,index_ranges);
});})(G__68447_72067,G__68448_72068))
;
goog.object.set(G__68447_72067,G__68448_72068,G__68449_72069);
goog.object.set(clojure.core.matrix.protocols.PBroadcast,"null",true);

var G__68453_72072 = clojure.core.matrix.protocols.broadcast;
var G__68454_72073 = "null";
var G__68455_72074 = ((function (G__68453_72072,G__68454_72073){
return (function (m,new_shape){
return clojure.core.matrix.impl.wrappers.wrap_broadcast(m,new_shape);
});})(G__68453_72072,G__68454_72073))
;
goog.object.set(G__68453_72072,G__68454_72073,G__68455_72074);

goog.object.set(clojure.core.matrix.protocols.PBroadcast,"number",true);

var G__68456_72077 = clojure.core.matrix.protocols.broadcast;
var G__68457_72078 = "number";
var G__68458_72079 = ((function (G__68456_72077,G__68457_72078){
return (function (m,new_shape){
return clojure.core.matrix.impl.wrappers.wrap_broadcast(m,new_shape);
});})(G__68456_72077,G__68457_72078))
;
goog.object.set(G__68456_72077,G__68457_72078,G__68458_72079);

goog.object.set(clojure.core.matrix.protocols.PBroadcast,"object",true);

var G__68463_72080 = clojure.core.matrix.protocols.broadcast;
var G__68464_72081 = "object";
var G__68465_72082 = ((function (G__68463_72080,G__68464_72081){
return (function (m,new_shape){
var nshape = new_shape;
var mshape = clojure.core.matrix.protocols.get_shape(m);
var mdims = cljs.core.count(mshape);
var ndims = cljs.core.count(nshape);
if((((mdims === ndims)) && (clojure.core.matrix.utils.same_shape_object_QMARK_(nshape,mshape)))){
return m;
} else {
return clojure.core.matrix.impl.wrappers.wrap_broadcast(m,new_shape);

}
});})(G__68463_72080,G__68464_72081))
;
goog.object.set(G__68463_72080,G__68464_72081,G__68465_72082);
goog.object.set(clojure.core.matrix.protocols.PBroadcastLike,"null",true);

var G__68469_72085 = clojure.core.matrix.protocols.broadcast_like;
var G__68470_72086 = "null";
var G__68471_72087 = ((function (G__68469_72085,G__68470_72086){
return (function (m,a){
return clojure.core.matrix.impl.wrappers.wrap_broadcast(a,clojure.core.matrix.protocols.get_shape(m));
});})(G__68469_72085,G__68470_72086))
;
goog.object.set(G__68469_72085,G__68470_72086,G__68471_72087);

goog.object.set(clojure.core.matrix.protocols.PBroadcastLike,"object",true);

var G__68472_72097 = clojure.core.matrix.protocols.broadcast_like;
var G__68473_72098 = "object";
var G__68474_72099 = ((function (G__68472_72097,G__68473_72098){
return (function (m,a){
var sm = clojure.core.matrix.protocols.get_shape(m);
var sa = clojure.core.matrix.protocols.get_shape(a);
if(clojure.core.matrix.utils.same_shape_object_QMARK_(sm,sa)){
return a;
} else {
return clojure.core.matrix.protocols.broadcast(a,sm);
}
});})(G__68472_72097,G__68473_72098))
;
goog.object.set(G__68472_72097,G__68473_72098,G__68474_72099);
goog.object.set(clojure.core.matrix.protocols.PBroadcastCoerce,"null",true);

var G__68482_72102 = clojure.core.matrix.protocols.broadcast_coerce;
var G__68483_72103 = "null";
var G__68484_72104 = ((function (G__68482_72102,G__68483_72103){
return (function (m,a){
return clojure.core.matrix.protocols.coerce_param(m,clojure.core.matrix.protocols.broadcast_like(m,a));
});})(G__68482_72102,G__68483_72103))
;
goog.object.set(G__68482_72102,G__68483_72103,G__68484_72104);

goog.object.set(clojure.core.matrix.protocols.PBroadcastCoerce,"object",true);

var G__68491_72105 = clojure.core.matrix.protocols.broadcast_coerce;
var G__68492_72106 = "object";
var G__68493_72107 = ((function (G__68491_72105,G__68492_72106){
return (function (m,a){
return clojure.core.matrix.protocols.coerce_param(m,clojure.core.matrix.protocols.broadcast_like(m,a));
});})(G__68491_72105,G__68492_72106))
;
goog.object.set(G__68491_72105,G__68492_72106,G__68493_72107);
goog.object.set(clojure.core.matrix.protocols.PPack,"null",true);

var G__68495_72109 = clojure.core.matrix.protocols.pack;
var G__68496_72110 = "null";
var G__68497_72111 = ((function (G__68495_72109,G__68496_72110){
return (function (m){
return null;
});})(G__68495_72109,G__68496_72110))
;
goog.object.set(G__68495_72109,G__68496_72110,G__68497_72111);

goog.object.set(clojure.core.matrix.protocols.PPack,"object",true);

var G__68503_72113 = clojure.core.matrix.protocols.pack;
var G__68504_72114 = "object";
var G__68505_72115 = ((function (G__68503_72113,G__68504_72114){
return (function (m){
return m;
});})(G__68503_72113,G__68504_72114))
;
goog.object.set(G__68503_72113,G__68504_72114,G__68505_72115);
goog.object.set(clojure.core.matrix.protocols.PConversion,"null",true);

var G__68512_72119 = clojure.core.matrix.protocols.convert_to_nested_vectors;
var G__68513_72120 = "null";
var G__68514_72121 = ((function (G__68512_72119,G__68513_72120){
return (function (m){
return null;
});})(G__68512_72119,G__68513_72120))
;
goog.object.set(G__68512_72119,G__68513_72120,G__68514_72121);

goog.object.set(clojure.core.matrix.protocols.PConversion,"number",true);

var G__68520_72123 = clojure.core.matrix.protocols.convert_to_nested_vectors;
var G__68521_72124 = "number";
var G__68522_72125 = ((function (G__68520_72123,G__68521_72124){
return (function (m){
return m;
});})(G__68520_72123,G__68521_72124))
;
goog.object.set(G__68520_72123,G__68521_72124,G__68522_72125);

goog.object.set(clojure.core.matrix.protocols.PConversion,"object",true);

var G__68524_72131 = clojure.core.matrix.protocols.convert_to_nested_vectors;
var G__68525_72132 = "object";
var G__68526_72133 = ((function (G__68524_72131,G__68525_72132){
return (function (m){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
if((dims === (0))){
return clojure.core.matrix.protocols.get_0d(m);
} else {
if(((1) === dims)){
if(((cljs.core.seq_QMARK_(m)) || (cljs.core.sequential_QMARK_(m)))){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_0d,m);
} else {
var n = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
var i = (0);
var res = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < n)){
var G__72136 = (i + (1));
var G__72137 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res,clojure.core.matrix.protocols.get_1d(m,i));
i = G__72136;
res = G__72137;
continue;
} else {
return res;
}
break;
}
}
} else {
if(cljs.core.sequential_QMARK_(m)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.convert_to_nested_vectors,m);
} else {
if(cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(m))){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.convert_to_nested_vectors,clojure.core.matrix.protocols.get_major_slice_seq(m));
} else {
if(cljs.core.seq_QMARK_(m)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.convert_to_nested_vectors,m);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Can't work out how to convert to nested vectors: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(m))," = ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(m)].join(''),cljs.core.PersistentArrayMap.EMPTY);

}
}
}
}
}
});})(G__68524_72131,G__68525_72132))
;
goog.object.set(G__68524_72131,G__68525_72132,G__68526_72133);
goog.object.set(clojure.core.matrix.protocols.PRowColMatrix,"null",true);

var G__68531_72141 = clojure.core.matrix.protocols.column_matrix;
var G__68532_72142 = "null";
var G__68533_72143 = ((function (G__68531_72141,G__68532_72142){
return (function (m,data){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't create a column matrix from nil",cljs.core.PersistentArrayMap.EMPTY);
});})(G__68531_72141,G__68532_72142))
;
goog.object.set(G__68531_72141,G__68532_72142,G__68533_72143);

var G__68536_72145 = clojure.core.matrix.protocols.row_matrix;
var G__68537_72146 = "null";
var G__68538_72147 = ((function (G__68536_72145,G__68537_72146){
return (function (m,data){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't create a column matrix from nil",cljs.core.PersistentArrayMap.EMPTY);
});})(G__68536_72145,G__68537_72146))
;
goog.object.set(G__68536_72145,G__68537_72146,G__68538_72147);

goog.object.set(clojure.core.matrix.protocols.PRowColMatrix,"object",true);

var G__68544_72148 = clojure.core.matrix.protocols.column_matrix;
var G__68545_72149 = "object";
var G__68546_72150 = ((function (G__68544_72148,G__68545_72149){
return (function (m,data){
if(((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(data)))){
return clojure.core.matrix.protocols.coerce_param(m,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,clojure.core.matrix.protocols.element_seq(data)));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't create a column matrix: input must be 1D vector",cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__68544_72148,G__68545_72149))
;
goog.object.set(G__68544_72148,G__68545_72149,G__68546_72150);

var G__68548_72155 = clojure.core.matrix.protocols.row_matrix;
var G__68549_72156 = "object";
var G__68550_72157 = ((function (G__68548_72155,G__68549_72156){
return (function (m,data){
if(((1) === cljs.core.long$(clojure.core.matrix.protocols.dimensionality(data)))){
return clojure.core.matrix.protocols.coerce_param(m,(new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[data],null)));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Can't create a row matrix: input must be 1D vector",cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__68548_72155,G__68549_72156))
;
goog.object.set(G__68548_72155,G__68549_72156,G__68550_72157);
goog.object.set(clojure.core.matrix.protocols.PVectorView,"null",true);

var G__68559_72159 = clojure.core.matrix.protocols.as_vector;
var G__68560_72160 = "null";
var G__68561_72161 = ((function (G__68559_72159,G__68560_72160){
return (function (m){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null);
});})(G__68559_72159,G__68560_72160))
;
goog.object.set(G__68559_72159,G__68560_72160,G__68561_72161);

goog.object.set(clojure.core.matrix.protocols.PVectorView,"number",true);

var G__68568_72164 = clojure.core.matrix.protocols.as_vector;
var G__68569_72165 = "number";
var G__68570_72166 = ((function (G__68568_72164,G__68569_72165){
return (function (m){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [m], null);
});})(G__68568_72164,G__68569_72165))
;
goog.object.set(G__68568_72164,G__68569_72165,G__68570_72166);

goog.object.set(clojure.core.matrix.protocols.PVectorView,"object",true);

var G__68571_72170 = clojure.core.matrix.protocols.as_vector;
var G__68572_72171 = "object";
var G__68573_72172 = ((function (G__68571_72170,G__68572_72171){
return (function (m){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
if((dims === (0))){
return clojure.core.matrix.protocols.broadcast(clojure.core.matrix.impl.wrappers.wrap_nd(m),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1)], null));
} else {
if((dims === (1))){
return m;
} else {
if(cljs.core.not(clojure.core.matrix.protocols.is_mutable_QMARK_(m))){
return clojure.core.matrix.protocols.to_vector(m);
} else {
return null;

}
}
}
});})(G__68571_72170,G__68572_72171))
;
goog.object.set(G__68571_72170,G__68572_72171,G__68573_72172);
goog.object.set(clojure.core.matrix.protocols.PVectorisable,"null",true);

var G__68578_72187 = clojure.core.matrix.protocols.to_vector;
var G__68579_72188 = "null";
var G__68580_72189 = ((function (G__68578_72187,G__68579_72188){
return (function (m){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null);
});})(G__68578_72187,G__68579_72188))
;
goog.object.set(G__68578_72187,G__68579_72188,G__68580_72189);

goog.object.set(clojure.core.matrix.protocols.PVectorisable,"number",true);

var G__68582_72198 = clojure.core.matrix.protocols.to_vector;
var G__68583_72199 = "number";
var G__68584_72200 = ((function (G__68582_72198,G__68583_72199){
return (function (m){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [m], null);
});})(G__68582_72198,G__68583_72199))
;
goog.object.set(G__68582_72198,G__68583_72199,G__68584_72200);

goog.object.set(clojure.core.matrix.protocols.PVectorisable,"object",true);

var G__68585_72209 = clojure.core.matrix.protocols.to_vector;
var G__68586_72210 = "object";
var G__68587_72211 = ((function (G__68585_72209,G__68586_72210){
return (function (m){
var dims = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
if(((0) === dims)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clojure.core.matrix.protocols.get_0d(m)], null);
} else {
if(cljs.core.truth_(clojure.core.matrix.protocols.is_vector_QMARK_(m))){
return clojure.core.matrix.protocols.clone(m);
} else {
return cljs.core.vec(clojure.core.matrix.protocols.element_seq(m));

}
}
});})(G__68585_72209,G__68586_72210))
;
goog.object.set(G__68585_72209,G__68586_72210,G__68587_72211);
goog.object.set(clojure.core.matrix.protocols.PReshaping,"null",true);

var G__68597_72216 = clojure.core.matrix.protocols.reshape;
var G__68598_72217 = "null";
var G__68599_72218 = ((function (G__68597_72216,G__68598_72217){
return (function (m,shape){
return clojure.core.matrix.protocols.reshape(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null),shape);
});})(G__68597_72216,G__68598_72217))
;
goog.object.set(G__68597_72216,G__68598_72217,G__68599_72218);

goog.object.set(clojure.core.matrix.protocols.PReshaping,"number",true);

var G__68604_72220 = clojure.core.matrix.protocols.reshape;
var G__68605_72221 = "number";
var G__68606_72222 = ((function (G__68604_72220,G__68605_72221){
return (function (m,shape){
return clojure.core.matrix.protocols.reshape(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [m], null),shape);
});})(G__68604_72220,G__68605_72221))
;
goog.object.set(G__68604_72220,G__68605_72221,G__68606_72222);

goog.object.set(clojure.core.matrix.protocols.PReshaping,"object",true);

var G__68611_72224 = clojure.core.matrix.protocols.reshape;
var G__68612_72225 = "object";
var G__68613_72226 = ((function (G__68611_72224,G__68612_72225){
return (function (m,shape){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.get_shape(m),shape)){
return m;
} else {
var gv = clojure.core.matrix.protocols.generic_value(m);
var es = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.element_seq(m),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(gv));
var partition_shape = ((function (gv,es,G__68611_72224,G__68612_72225){
return (function clojure$core$matrix$impl$defaults$partition_shape(es__$1,shape__$1){
var temp__5816__auto__ = cljs.core.seq(shape__$1);
if(temp__5816__auto__){
var s = temp__5816__auto__;
var ns = cljs.core.next(s);
var plen = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(1),ns);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (ns,plen,s,temp__5816__auto__,gv,es,G__68611_72224,G__68612_72225){
return (function (p1__68596_SHARP_){
return clojure$core$matrix$impl$defaults$partition_shape(p1__68596_SHARP_,ns);
});})(ns,plen,s,temp__5816__auto__,gv,es,G__68611_72224,G__68612_72225))
,cljs.core.partition.cljs$core$IFn$_invoke$arity$2(plen,es__$1));
} else {
return cljs.core.first(es__$1);
}
});})(gv,es,G__68611_72224,G__68612_72225))
;
var temp__5816__auto__ = cljs.core.seq(shape);
if(temp__5816__auto__){
var shape__$1 = temp__5816__auto__;
var fs = cljs.core.long$(cljs.core.first(shape__$1));
var parts = partition_shape(es,shape__$1);
var or__4131__auto__ = clojure.core.matrix.protocols.construct_matrix(m,cljs.core.take.cljs$core$IFn$_invoke$arity$2(fs,parts));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return clojure.core.matrix.protocols.construct_matrix(cljs.core.PersistentVector.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(fs,parts));
}
} else {
return cljs.core.first(es);
}
}
});})(G__68611_72224,G__68612_72225))
;
goog.object.set(G__68611_72224,G__68612_72225,G__68613_72226);
goog.object.set(clojure.core.matrix.protocols.PReshapeView,"null",true);

var G__68624_72237 = clojure.core.matrix.protocols.reshape_view;
var G__68625_72238 = "null";
var G__68626_72239 = ((function (G__68624_72237,G__68625_72238){
return (function (m,shape){
return clojure.core.matrix.protocols.broadcast(null,shape);
});})(G__68624_72237,G__68625_72238))
;
goog.object.set(G__68624_72237,G__68625_72238,G__68626_72239);

goog.object.set(clojure.core.matrix.protocols.PReshapeView,"number",true);

var G__68627_72241 = clojure.core.matrix.protocols.reshape_view;
var G__68628_72242 = "number";
var G__68629_72243 = ((function (G__68627_72241,G__68628_72242){
return (function (m,shape){
return clojure.core.matrix.protocols.broadcast(m,shape);
});})(G__68627_72241,G__68628_72242))
;
goog.object.set(G__68627_72241,G__68628_72242,G__68629_72243);

goog.object.set(clojure.core.matrix.protocols.PReshapeView,"object",true);

var G__68634_72246 = clojure.core.matrix.protocols.reshape_view;
var G__68635_72247 = "object";
var G__68636_72248 = ((function (G__68634_72246,G__68635_72247){
return (function (m,shape){
if(cljs.core.truth_(clojure.core.matrix.protocols.is_mutable_QMARK_(m))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["TODO: ","reshape-view not supported on mutable array of type: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((clojure.core.matrix.impl.defaults.class$.cljs$core$IFn$_invoke$arity$1 ? clojure.core.matrix.impl.defaults.class$.cljs$core$IFn$_invoke$arity$1(m) : clojure.core.matrix.impl.defaults.class$.call(null,m)))].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
return clojure.core.matrix.protocols.reshape(m,shape);
}
});})(G__68634_72246,G__68635_72247))
;
goog.object.set(G__68634_72246,G__68635_72247,G__68636_72248);
goog.object.set(clojure.core.matrix.protocols.PCoercion,"null",true);

var G__68638_72258 = clojure.core.matrix.protocols.coerce_param;
var G__68639_72259 = "null";
var G__68640_72260 = ((function (G__68638_72258,G__68639_72259){
return (function (m,param){
return param;
});})(G__68638_72258,G__68639_72259))
;
goog.object.set(G__68638_72258,G__68639_72259,G__68640_72260);

goog.object.set(clojure.core.matrix.protocols.PCoercion,"number",true);

var G__68641_72263 = clojure.core.matrix.protocols.coerce_param;
var G__68642_72264 = "number";
var G__68643_72265 = ((function (G__68641_72263,G__68642_72264){
return (function (m,param){
return param;
});})(G__68641_72263,G__68642_72264))
;
goog.object.set(G__68641_72263,G__68642_72264,G__68643_72265);

goog.object.set(clojure.core.matrix.protocols.PCoercion,"object",true);

var G__68644_72267 = clojure.core.matrix.protocols.coerce_param;
var G__68645_72268 = "object";
var G__68646_72269 = ((function (G__68644_72267,G__68645_72268){
return (function (m,param){
var param__$1 = (((param instanceof cljs.core.ISeq))?clojure.core.matrix.protocols.convert_to_nested_vectors(param):param);
var or__4131__auto__ = clojure.core.matrix.protocols.construct_matrix(m,param__$1);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return param__$1;
}
});})(G__68644_72267,G__68645_72268))
;
goog.object.set(G__68644_72267,G__68645_72268,G__68646_72269);
goog.object.set(clojure.core.matrix.protocols.PExponent,"number",true);

var G__68661_72272 = clojure.core.matrix.protocols.element_pow;
var G__68662_72273 = "number";
var G__68663_72274 = ((function (G__68661_72272,G__68662_72273){
return (function (m,exponent){
if(cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(exponent))){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(exponent,((function (G__68661_72272,G__68662_72273){
return (function (p1__68653_SHARP_){
return Math.pow(m,p1__68653_SHARP_);
});})(G__68661_72272,G__68662_72273))
);
} else {
return Math.pow(m,exponent);
}
});})(G__68661_72272,G__68662_72273))
;
goog.object.set(G__68661_72272,G__68662_72273,G__68663_72274);

goog.object.set(clojure.core.matrix.protocols.PExponent,"object",true);

var G__68671_72277 = clojure.core.matrix.protocols.element_pow;
var G__68672_72278 = "object";
var G__68673_72279 = ((function (G__68671_72277,G__68672_72278){
return (function (m,exponent){
if(cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(exponent))){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$3(m,((function (G__68671_72277,G__68672_72278){
return (function (p1__68657_SHARP_,p2__68658_SHARP_){
return Math.pow(p1__68657_SHARP_,p2__68658_SHARP_);
});})(G__68671_72277,G__68672_72278))
,exponent);
} else {
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68671_72277,G__68672_72278){
return (function (p1__68659_SHARP_){
return Math.pow(p1__68659_SHARP_,exponent);
});})(G__68671_72277,G__68672_72278))
);
}
});})(G__68671_72277,G__68672_72278))
;
goog.object.set(G__68671_72277,G__68672_72278,G__68673_72279);
goog.object.set(clojure.core.matrix.protocols.PSquare,"number",true);

var G__68683_72287 = clojure.core.matrix.protocols.square;
var G__68684_72288 = "number";
var G__68685_72289 = ((function (G__68683_72287,G__68684_72288){
return (function (m){
return (m * m);
});})(G__68683_72287,G__68684_72288))
;
goog.object.set(G__68683_72287,G__68684_72288,G__68685_72289);

goog.object.set(clojure.core.matrix.protocols.PSquare,"object",true);

var G__68688_72291 = clojure.core.matrix.protocols.square;
var G__68689_72292 = "object";
var G__68690_72293 = ((function (G__68688_72291,G__68689_72292){
return (function (m){
return clojure.core.matrix.protocols.element_multiply(m,m);
});})(G__68688_72291,G__68689_72292))
;
goog.object.set(G__68688_72291,G__68689_72292,G__68690_72293);
goog.object.set(clojure.core.matrix.protocols.PLogistic,"number",true);

var G__68693_72295 = clojure.core.matrix.protocols.logistic;
var G__68694_72296 = "number";
var G__68695_72297 = ((function (G__68693_72295,G__68694_72296){
return (function (m){
var e_t = (function (){var G__68696 = (- m);
return Math.exp(G__68696);
})();
return (1.0 / (1.0 + e_t));
});})(G__68693_72295,G__68694_72296))
;
goog.object.set(G__68693_72295,G__68694_72296,G__68695_72297);

goog.object.set(clojure.core.matrix.protocols.PLogistic,"object",true);

var G__68698_72299 = clojure.core.matrix.protocols.logistic;
var G__68699_72300 = "object";
var G__68700_72301 = ((function (G__68698_72299,G__68699_72300){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.logistic_fn);
});})(G__68698_72299,G__68699_72300))
;
goog.object.set(G__68698_72299,G__68699_72300,G__68700_72301);
goog.object.set(clojure.core.matrix.protocols.PLogisticMutable,"object",true);

var G__68702_72303 = clojure.core.matrix.protocols.logistic_BANG_;
var G__68703_72304 = "object";
var G__68704_72305 = ((function (G__68702_72303,G__68703_72304){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.logistic_fn);
});})(G__68702_72303,G__68703_72304))
;
goog.object.set(G__68702_72303,G__68703_72304,G__68704_72305);
goog.object.set(clojure.core.matrix.protocols.PSoftplus,"number",true);

var G__68709_72307 = clojure.core.matrix.protocols.softplus;
var G__68710_72308 = "number";
var G__68711_72309 = ((function (G__68709_72307,G__68710_72308){
return (function (m){
var et = (function (){var G__68713 = m;
return Math.exp(G__68713);
})();
var G__68714 = (1.0 + et);
return Math.log(G__68714);
});})(G__68709_72307,G__68710_72308))
;
goog.object.set(G__68709_72307,G__68710_72308,G__68711_72309);

goog.object.set(clojure.core.matrix.protocols.PSoftplus,"object",true);

var G__68715_72311 = clojure.core.matrix.protocols.softplus;
var G__68716_72312 = "object";
var G__68717_72313 = ((function (G__68715_72311,G__68716_72312){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.softplus_fn);
});})(G__68715_72311,G__68716_72312))
;
goog.object.set(G__68715_72311,G__68716_72312,G__68717_72313);
goog.object.set(clojure.core.matrix.protocols.PSoftmax,"object",true);

var G__68722_72316 = clojure.core.matrix.protocols.softmax;
var G__68723_72317 = "object";
var G__68724_72318 = ((function (G__68722_72316,G__68723_72317){
return (function (m){
var em = clojure.core.matrix.protocols.exp(m);
return clojure.core.matrix.protocols.element_divide.cljs$core$IFn$_invoke$arity$2(em,clojure.core.matrix.protocols.element_sum(em));
});})(G__68722_72316,G__68723_72317))
;
goog.object.set(G__68722_72316,G__68723_72317,G__68724_72318);
goog.object.set(clojure.core.matrix.protocols.PSoftmaxMutable,"object",true);

var G__68730_72320 = clojure.core.matrix.protocols.softmax_BANG_;
var G__68731_72321 = "object";
var G__68732_72322 = ((function (G__68730_72320,G__68731_72321){
return (function (m){
clojure.core.matrix.protocols.exp_BANG_(m);

clojure.core.matrix.protocols.element_divide_BANG_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.protocols.element_sum(m));

return m;
});})(G__68730_72320,G__68731_72321))
;
goog.object.set(G__68730_72320,G__68731_72321,G__68732_72322);
goog.object.set(clojure.core.matrix.protocols.PSoftplusMutable,"object",true);

var G__68735_72324 = clojure.core.matrix.protocols.softplus_BANG_;
var G__68736_72325 = "object";
var G__68737_72326 = ((function (G__68735_72324,G__68736_72325){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.softplus_fn);
});})(G__68735_72324,G__68736_72325))
;
goog.object.set(G__68735_72324,G__68736_72325,G__68737_72326);
goog.object.set(clojure.core.matrix.protocols.PReLU,"number",true);

var G__68743_72328 = clojure.core.matrix.protocols.relu;
var G__68744_72329 = "number";
var G__68745_72330 = ((function (G__68743_72328,G__68744_72329){
return (function (m){
var G__68747 = 0.0;
var G__68748 = m;
return Math.max(G__68747,G__68748);
});})(G__68743_72328,G__68744_72329))
;
goog.object.set(G__68743_72328,G__68744_72329,G__68745_72330);

goog.object.set(clojure.core.matrix.protocols.PReLU,"object",true);

var G__68751_72334 = clojure.core.matrix.protocols.relu;
var G__68752_72335 = "object";
var G__68753_72336 = ((function (G__68751_72334,G__68752_72335){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.relu_fn);
});})(G__68751_72334,G__68752_72335))
;
goog.object.set(G__68751_72334,G__68752_72335,G__68753_72336);
goog.object.set(clojure.core.matrix.protocols.PReLUMutable,"object",true);

var G__68759_72340 = clojure.core.matrix.protocols.relu_BANG_;
var G__68760_72341 = "object";
var G__68761_72342 = ((function (G__68759_72340,G__68760_72341){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.common.relu_fn);
});})(G__68759_72340,G__68760_72341))
;
goog.object.set(G__68759_72340,G__68760_72341,G__68761_72342);
goog.object.set(clojure.core.matrix.protocols.PMathsFunctions,"number",true);

var G__68796_72344 = clojure.core.matrix.protocols.abs;
var G__68797_72345 = "number";
var G__68798_72346 = ((function (G__68796_72344,G__68797_72345){
return (function (m){
var G__68803 = m;
return Math.abs(G__68803);
});})(G__68796_72344,G__68797_72345))
;
goog.object.set(G__68796_72344,G__68797_72345,G__68798_72346);

var G__68805_72347 = clojure.core.matrix.protocols.acos;
var G__68806_72348 = "number";
var G__68807_72349 = ((function (G__68805_72347,G__68806_72348){
return (function (m){
var G__68811 = m;
return Math.acos(G__68811);
});})(G__68805_72347,G__68806_72348))
;
goog.object.set(G__68805_72347,G__68806_72348,G__68807_72349);

var G__68812_72351 = clojure.core.matrix.protocols.asin;
var G__68813_72352 = "number";
var G__68814_72353 = ((function (G__68812_72351,G__68813_72352){
return (function (m){
var G__68816 = m;
return Math.asin(G__68816);
});})(G__68812_72351,G__68813_72352))
;
goog.object.set(G__68812_72351,G__68813_72352,G__68814_72353);

var G__68823_72354 = clojure.core.matrix.protocols.atan;
var G__68824_72355 = "number";
var G__68825_72356 = ((function (G__68823_72354,G__68824_72355){
return (function (m){
var G__68826 = m;
return Math.atan(G__68826);
});})(G__68823_72354,G__68824_72355))
;
goog.object.set(G__68823_72354,G__68824_72355,G__68825_72356);

var G__68830_72358 = clojure.core.matrix.protocols.cbrt;
var G__68831_72359 = "number";
var G__68832_72360 = ((function (G__68830_72358,G__68831_72359){
return (function (m){
var G__68834 = m;
return Math.cbrt(G__68834);
});})(G__68830_72358,G__68831_72359))
;
goog.object.set(G__68830_72358,G__68831_72359,G__68832_72360);

var G__68835_72362 = clojure.core.matrix.protocols.ceil;
var G__68836_72363 = "number";
var G__68837_72364 = ((function (G__68835_72362,G__68836_72363){
return (function (m){
var G__68841 = m;
return Math.ceil(G__68841);
});})(G__68835_72362,G__68836_72363))
;
goog.object.set(G__68835_72362,G__68836_72363,G__68837_72364);

var G__68842_72366 = clojure.core.matrix.protocols.cos;
var G__68843_72367 = "number";
var G__68844_72368 = ((function (G__68842_72366,G__68843_72367){
return (function (m){
var G__68845 = m;
return Math.cos(G__68845);
});})(G__68842_72366,G__68843_72367))
;
goog.object.set(G__68842_72366,G__68843_72367,G__68844_72368);

var G__68846_72369 = clojure.core.matrix.protocols.cosh;
var G__68847_72370 = "number";
var G__68848_72371 = ((function (G__68846_72369,G__68847_72370){
return (function (m){
var G__68850 = m;
return Math.cosh(G__68850);
});})(G__68846_72369,G__68847_72370))
;
goog.object.set(G__68846_72369,G__68847_72370,G__68848_72371);

var G__68851_72373 = clojure.core.matrix.protocols.exp;
var G__68852_72374 = "number";
var G__68853_72375 = ((function (G__68851_72373,G__68852_72374){
return (function (m){
var G__68855 = m;
return Math.exp(G__68855);
});})(G__68851_72373,G__68852_72374))
;
goog.object.set(G__68851_72373,G__68852_72374,G__68853_72375);

var G__68856_72377 = clojure.core.matrix.protocols.floor;
var G__68857_72378 = "number";
var G__68858_72379 = ((function (G__68856_72377,G__68857_72378){
return (function (m){
var G__68859 = m;
return Math.floor(G__68859);
});})(G__68856_72377,G__68857_72378))
;
goog.object.set(G__68856_72377,G__68857_72378,G__68858_72379);

var G__68860_72381 = clojure.core.matrix.protocols.log;
var G__68861_72382 = "number";
var G__68862_72383 = ((function (G__68860_72381,G__68861_72382){
return (function (m){
var G__68863 = m;
return Math.log(G__68863);
});})(G__68860_72381,G__68861_72382))
;
goog.object.set(G__68860_72381,G__68861_72382,G__68862_72383);

var G__68868_72385 = clojure.core.matrix.protocols.log10;
var G__68869_72386 = "number";
var G__68870_72387 = ((function (G__68868_72385,G__68869_72386){
return (function (m){
var G__68871 = m;
return Math.log10(G__68871);
});})(G__68868_72385,G__68869_72386))
;
goog.object.set(G__68868_72385,G__68869_72386,G__68870_72387);

var G__68872_72390 = clojure.core.matrix.protocols.round;
var G__68873_72391 = "number";
var G__68874_72392 = ((function (G__68872_72390,G__68873_72391){
return (function (m){
var G__68876 = m;
return Math.rint(G__68876);
});})(G__68872_72390,G__68873_72391))
;
goog.object.set(G__68872_72390,G__68873_72391,G__68874_72392);

var G__68880_72394 = clojure.core.matrix.protocols.signum;
var G__68881_72395 = "number";
var G__68882_72396 = ((function (G__68880_72394,G__68881_72395){
return (function (m){
var G__68883 = m;
return Math.sign(G__68883);
});})(G__68880_72394,G__68881_72395))
;
goog.object.set(G__68880_72394,G__68881_72395,G__68882_72396);

var G__68884_72398 = clojure.core.matrix.protocols.sin;
var G__68885_72399 = "number";
var G__68886_72400 = ((function (G__68884_72398,G__68885_72399){
return (function (m){
var G__68887 = m;
return Math.sin(G__68887);
});})(G__68884_72398,G__68885_72399))
;
goog.object.set(G__68884_72398,G__68885_72399,G__68886_72400);

var G__68888_72401 = clojure.core.matrix.protocols.sinh;
var G__68889_72402 = "number";
var G__68890_72403 = ((function (G__68888_72401,G__68889_72402){
return (function (m){
var G__68891 = m;
return Math.sinh(G__68891);
});})(G__68888_72401,G__68889_72402))
;
goog.object.set(G__68888_72401,G__68889_72402,G__68890_72403);

var G__68892_72405 = clojure.core.matrix.protocols.sqrt;
var G__68893_72406 = "number";
var G__68894_72407 = ((function (G__68892_72405,G__68893_72406){
return (function (m){
var G__68895 = m;
return Math.sqrt(G__68895);
});})(G__68892_72405,G__68893_72406))
;
goog.object.set(G__68892_72405,G__68893_72406,G__68894_72407);

var G__68897_72409 = clojure.core.matrix.protocols.tan;
var G__68898_72410 = "number";
var G__68899_72411 = ((function (G__68897_72409,G__68898_72410){
return (function (m){
var G__68900 = m;
return Math.tan(G__68900);
});})(G__68897_72409,G__68898_72410))
;
goog.object.set(G__68897_72409,G__68898_72410,G__68899_72411);

var G__68901_72413 = clojure.core.matrix.protocols.tanh;
var G__68902_72414 = "number";
var G__68903_72415 = ((function (G__68901_72413,G__68902_72414){
return (function (m){
var G__68904 = m;
return Math.tanh(G__68904);
});})(G__68901_72413,G__68902_72414))
;
goog.object.set(G__68901_72413,G__68902_72414,G__68903_72415);

var G__68905_72417 = clojure.core.matrix.protocols.to_degrees;
var G__68906_72418 = "number";
var G__68907_72419 = ((function (G__68905_72417,G__68906_72418){
return (function (m){
return clojure.core.matrix.impl.mathsops.to_degrees_STAR_(m);
});})(G__68905_72417,G__68906_72418))
;
goog.object.set(G__68905_72417,G__68906_72418,G__68907_72419);

var G__68915_72424 = clojure.core.matrix.protocols.to_radians;
var G__68916_72425 = "number";
var G__68917_72426 = ((function (G__68915_72424,G__68916_72425){
return (function (m){
return clojure.core.matrix.impl.mathsops.to_radians_STAR_(m);
});})(G__68915_72424,G__68916_72425))
;
goog.object.set(G__68915_72424,G__68916_72425,G__68917_72426);

goog.object.set(clojure.core.matrix.protocols.PMathsFunctions,"object",true);

var G__68919_72428 = clojure.core.matrix.protocols.abs;
var G__68920_72429 = "object";
var G__68921_72430 = ((function (G__68919_72428,G__68920_72429){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68919_72428,G__68920_72429){
return (function (p1__65541__65542__auto__){
var G__68923 = p1__65541__65542__auto__;
return Math.abs(G__68923);
});})(G__68919_72428,G__68920_72429))
);
});})(G__68919_72428,G__68920_72429))
;
goog.object.set(G__68919_72428,G__68920_72429,G__68921_72430);

var G__68924_72432 = clojure.core.matrix.protocols.acos;
var G__68925_72433 = "object";
var G__68926_72434 = ((function (G__68924_72432,G__68925_72433){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68924_72432,G__68925_72433){
return (function (p1__65541__65542__auto__){
var G__68934 = p1__65541__65542__auto__;
return Math.acos(G__68934);
});})(G__68924_72432,G__68925_72433))
);
});})(G__68924_72432,G__68925_72433))
;
goog.object.set(G__68924_72432,G__68925_72433,G__68926_72434);

var G__68935_72436 = clojure.core.matrix.protocols.asin;
var G__68936_72437 = "object";
var G__68937_72438 = ((function (G__68935_72436,G__68936_72437){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68935_72436,G__68936_72437){
return (function (p1__65541__65542__auto__){
var G__68939 = p1__65541__65542__auto__;
return Math.asin(G__68939);
});})(G__68935_72436,G__68936_72437))
);
});})(G__68935_72436,G__68936_72437))
;
goog.object.set(G__68935_72436,G__68936_72437,G__68937_72438);

var G__68940_72443 = clojure.core.matrix.protocols.atan;
var G__68941_72444 = "object";
var G__68942_72445 = ((function (G__68940_72443,G__68941_72444){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68940_72443,G__68941_72444){
return (function (p1__65541__65542__auto__){
var G__68943 = p1__65541__65542__auto__;
return Math.atan(G__68943);
});})(G__68940_72443,G__68941_72444))
);
});})(G__68940_72443,G__68941_72444))
;
goog.object.set(G__68940_72443,G__68941_72444,G__68942_72445);

var G__68944_72447 = clojure.core.matrix.protocols.cbrt;
var G__68945_72448 = "object";
var G__68946_72449 = ((function (G__68944_72447,G__68945_72448){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68944_72447,G__68945_72448){
return (function (p1__65541__65542__auto__){
var G__68947 = p1__65541__65542__auto__;
return Math.cbrt(G__68947);
});})(G__68944_72447,G__68945_72448))
);
});})(G__68944_72447,G__68945_72448))
;
goog.object.set(G__68944_72447,G__68945_72448,G__68946_72449);

var G__68948_72451 = clojure.core.matrix.protocols.ceil;
var G__68949_72452 = "object";
var G__68950_72453 = ((function (G__68948_72451,G__68949_72452){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68948_72451,G__68949_72452){
return (function (p1__65541__65542__auto__){
var G__68951 = p1__65541__65542__auto__;
return Math.ceil(G__68951);
});})(G__68948_72451,G__68949_72452))
);
});})(G__68948_72451,G__68949_72452))
;
goog.object.set(G__68948_72451,G__68949_72452,G__68950_72453);

var G__68954_72458 = clojure.core.matrix.protocols.cos;
var G__68955_72459 = "object";
var G__68956_72460 = ((function (G__68954_72458,G__68955_72459){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68954_72458,G__68955_72459){
return (function (p1__65541__65542__auto__){
var G__68957 = p1__65541__65542__auto__;
return Math.cos(G__68957);
});})(G__68954_72458,G__68955_72459))
);
});})(G__68954_72458,G__68955_72459))
;
goog.object.set(G__68954_72458,G__68955_72459,G__68956_72460);

var G__68958_72462 = clojure.core.matrix.protocols.cosh;
var G__68959_72463 = "object";
var G__68960_72464 = ((function (G__68958_72462,G__68959_72463){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68958_72462,G__68959_72463){
return (function (p1__65541__65542__auto__){
var G__68961 = p1__65541__65542__auto__;
return Math.cosh(G__68961);
});})(G__68958_72462,G__68959_72463))
);
});})(G__68958_72462,G__68959_72463))
;
goog.object.set(G__68958_72462,G__68959_72463,G__68960_72464);

var G__68966_72469 = clojure.core.matrix.protocols.exp;
var G__68967_72470 = "object";
var G__68968_72471 = ((function (G__68966_72469,G__68967_72470){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68966_72469,G__68967_72470){
return (function (p1__65541__65542__auto__){
var G__68969 = p1__65541__65542__auto__;
return Math.exp(G__68969);
});})(G__68966_72469,G__68967_72470))
);
});})(G__68966_72469,G__68967_72470))
;
goog.object.set(G__68966_72469,G__68967_72470,G__68968_72471);

var G__68970_72476 = clojure.core.matrix.protocols.floor;
var G__68971_72477 = "object";
var G__68972_72478 = ((function (G__68970_72476,G__68971_72477){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68970_72476,G__68971_72477){
return (function (p1__65541__65542__auto__){
var G__68973 = p1__65541__65542__auto__;
return Math.floor(G__68973);
});})(G__68970_72476,G__68971_72477))
);
});})(G__68970_72476,G__68971_72477))
;
goog.object.set(G__68970_72476,G__68971_72477,G__68972_72478);

var G__68974_72480 = clojure.core.matrix.protocols.log;
var G__68975_72481 = "object";
var G__68976_72482 = ((function (G__68974_72480,G__68975_72481){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68974_72480,G__68975_72481){
return (function (p1__65541__65542__auto__){
var G__68977 = p1__65541__65542__auto__;
return Math.log(G__68977);
});})(G__68974_72480,G__68975_72481))
);
});})(G__68974_72480,G__68975_72481))
;
goog.object.set(G__68974_72480,G__68975_72481,G__68976_72482);

var G__68978_72487 = clojure.core.matrix.protocols.log10;
var G__68979_72488 = "object";
var G__68980_72489 = ((function (G__68978_72487,G__68979_72488){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68978_72487,G__68979_72488){
return (function (p1__65541__65542__auto__){
var G__68981 = p1__65541__65542__auto__;
return Math.log10(G__68981);
});})(G__68978_72487,G__68979_72488))
);
});})(G__68978_72487,G__68979_72488))
;
goog.object.set(G__68978_72487,G__68979_72488,G__68980_72489);

var G__68983_72494 = clojure.core.matrix.protocols.round;
var G__68984_72495 = "object";
var G__68985_72496 = ((function (G__68983_72494,G__68984_72495){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68983_72494,G__68984_72495){
return (function (p1__65541__65542__auto__){
var G__68992 = p1__65541__65542__auto__;
return Math.rint(G__68992);
});})(G__68983_72494,G__68984_72495))
);
});})(G__68983_72494,G__68984_72495))
;
goog.object.set(G__68983_72494,G__68984_72495,G__68985_72496);

var G__68993_72498 = clojure.core.matrix.protocols.signum;
var G__68994_72499 = "object";
var G__68995_72500 = ((function (G__68993_72498,G__68994_72499){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68993_72498,G__68994_72499){
return (function (p1__65541__65542__auto__){
var G__68996 = p1__65541__65542__auto__;
return Math.sign(G__68996);
});})(G__68993_72498,G__68994_72499))
);
});})(G__68993_72498,G__68994_72499))
;
goog.object.set(G__68993_72498,G__68994_72499,G__68995_72500);

var G__68997_72501 = clojure.core.matrix.protocols.sin;
var G__68998_72502 = "object";
var G__68999_72503 = ((function (G__68997_72501,G__68998_72502){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__68997_72501,G__68998_72502){
return (function (p1__65541__65542__auto__){
var G__69000 = p1__65541__65542__auto__;
return Math.sin(G__69000);
});})(G__68997_72501,G__68998_72502))
);
});})(G__68997_72501,G__68998_72502))
;
goog.object.set(G__68997_72501,G__68998_72502,G__68999_72503);

var G__69001_72505 = clojure.core.matrix.protocols.sinh;
var G__69002_72506 = "object";
var G__69003_72507 = ((function (G__69001_72505,G__69002_72506){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69001_72505,G__69002_72506){
return (function (p1__65541__65542__auto__){
var G__69005 = p1__65541__65542__auto__;
return Math.sinh(G__69005);
});})(G__69001_72505,G__69002_72506))
);
});})(G__69001_72505,G__69002_72506))
;
goog.object.set(G__69001_72505,G__69002_72506,G__69003_72507);

var G__69007_72511 = clojure.core.matrix.protocols.sqrt;
var G__69008_72512 = "object";
var G__69009_72513 = ((function (G__69007_72511,G__69008_72512){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69007_72511,G__69008_72512){
return (function (p1__65541__65542__auto__){
var G__69010 = p1__65541__65542__auto__;
return Math.sqrt(G__69010);
});})(G__69007_72511,G__69008_72512))
);
});})(G__69007_72511,G__69008_72512))
;
goog.object.set(G__69007_72511,G__69008_72512,G__69009_72513);

var G__69011_72515 = clojure.core.matrix.protocols.tan;
var G__69012_72516 = "object";
var G__69013_72517 = ((function (G__69011_72515,G__69012_72516){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69011_72515,G__69012_72516){
return (function (p1__65541__65542__auto__){
var G__69014 = p1__65541__65542__auto__;
return Math.tan(G__69014);
});})(G__69011_72515,G__69012_72516))
);
});})(G__69011_72515,G__69012_72516))
;
goog.object.set(G__69011_72515,G__69012_72516,G__69013_72517);

var G__69015_72519 = clojure.core.matrix.protocols.tanh;
var G__69016_72520 = "object";
var G__69017_72521 = ((function (G__69015_72519,G__69016_72520){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69015_72519,G__69016_72520){
return (function (p1__65541__65542__auto__){
var G__69018 = p1__65541__65542__auto__;
return Math.tanh(G__69018);
});})(G__69015_72519,G__69016_72520))
);
});})(G__69015_72519,G__69016_72520))
;
goog.object.set(G__69015_72519,G__69016_72520,G__69017_72521);

var G__69019_72523 = clojure.core.matrix.protocols.to_degrees;
var G__69020_72524 = "object";
var G__69021_72525 = ((function (G__69019_72523,G__69020_72524){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69019_72523,G__69020_72524){
return (function (p1__65541__65542__auto__){
return clojure.core.matrix.impl.mathsops.to_degrees_STAR_(p1__65541__65542__auto__);
});})(G__69019_72523,G__69020_72524))
);
});})(G__69019_72523,G__69020_72524))
;
goog.object.set(G__69019_72523,G__69020_72524,G__69021_72525);

var G__69023_72527 = clojure.core.matrix.protocols.to_radians;
var G__69024_72528 = "object";
var G__69025_72529 = ((function (G__69023_72527,G__69024_72528){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69023_72527,G__69024_72528){
return (function (p1__65541__65542__auto__){
return clojure.core.matrix.impl.mathsops.to_radians_STAR_(p1__65541__65542__auto__);
});})(G__69023_72527,G__69024_72528))
);
});})(G__69023_72527,G__69024_72528))
;
goog.object.set(G__69023_72527,G__69024_72528,G__69025_72529);

goog.object.set(clojure.core.matrix.protocols.PMathsFunctions,"array",true);

var G__69035_72532 = clojure.core.matrix.protocols.abs;
var G__69036_72533 = "array";
var G__69037_72534 = ((function (G__69035_72532,G__69036_72533){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69035_72532,G__69036_72533){
return (function (p1__65543__65544__auto__){
var G__69038 = p1__65543__65544__auto__;
return Math.abs(G__69038);
});})(G__69035_72532,G__69036_72533))
);
});})(G__69035_72532,G__69036_72533))
;
goog.object.set(G__69035_72532,G__69036_72533,G__69037_72534);

var G__69040_72536 = clojure.core.matrix.protocols.acos;
var G__69041_72537 = "array";
var G__69042_72538 = ((function (G__69040_72536,G__69041_72537){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69040_72536,G__69041_72537){
return (function (p1__65543__65544__auto__){
var G__69043 = p1__65543__65544__auto__;
return Math.acos(G__69043);
});})(G__69040_72536,G__69041_72537))
);
});})(G__69040_72536,G__69041_72537))
;
goog.object.set(G__69040_72536,G__69041_72537,G__69042_72538);

var G__69044_72540 = clojure.core.matrix.protocols.asin;
var G__69045_72541 = "array";
var G__69046_72542 = ((function (G__69044_72540,G__69045_72541){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69044_72540,G__69045_72541){
return (function (p1__65543__65544__auto__){
var G__69047 = p1__65543__65544__auto__;
return Math.asin(G__69047);
});})(G__69044_72540,G__69045_72541))
);
});})(G__69044_72540,G__69045_72541))
;
goog.object.set(G__69044_72540,G__69045_72541,G__69046_72542);

var G__69048_72544 = clojure.core.matrix.protocols.atan;
var G__69049_72545 = "array";
var G__69050_72546 = ((function (G__69048_72544,G__69049_72545){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69048_72544,G__69049_72545){
return (function (p1__65543__65544__auto__){
var G__69051 = p1__65543__65544__auto__;
return Math.atan(G__69051);
});})(G__69048_72544,G__69049_72545))
);
});})(G__69048_72544,G__69049_72545))
;
goog.object.set(G__69048_72544,G__69049_72545,G__69050_72546);

var G__69052_72547 = clojure.core.matrix.protocols.cbrt;
var G__69053_72548 = "array";
var G__69054_72549 = ((function (G__69052_72547,G__69053_72548){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69052_72547,G__69053_72548){
return (function (p1__65543__65544__auto__){
var G__69056 = p1__65543__65544__auto__;
return Math.cbrt(G__69056);
});})(G__69052_72547,G__69053_72548))
);
});})(G__69052_72547,G__69053_72548))
;
goog.object.set(G__69052_72547,G__69053_72548,G__69054_72549);

var G__69057_72557 = clojure.core.matrix.protocols.ceil;
var G__69058_72558 = "array";
var G__69059_72559 = ((function (G__69057_72557,G__69058_72558){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69057_72557,G__69058_72558){
return (function (p1__65543__65544__auto__){
var G__69060 = p1__65543__65544__auto__;
return Math.ceil(G__69060);
});})(G__69057_72557,G__69058_72558))
);
});})(G__69057_72557,G__69058_72558))
;
goog.object.set(G__69057_72557,G__69058_72558,G__69059_72559);

var G__69061_72560 = clojure.core.matrix.protocols.cos;
var G__69062_72561 = "array";
var G__69063_72562 = ((function (G__69061_72560,G__69062_72561){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69061_72560,G__69062_72561){
return (function (p1__65543__65544__auto__){
var G__69065 = p1__65543__65544__auto__;
return Math.cos(G__69065);
});})(G__69061_72560,G__69062_72561))
);
});})(G__69061_72560,G__69062_72561))
;
goog.object.set(G__69061_72560,G__69062_72561,G__69063_72562);

var G__69069_72563 = clojure.core.matrix.protocols.cosh;
var G__69070_72564 = "array";
var G__69071_72565 = ((function (G__69069_72563,G__69070_72564){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69069_72563,G__69070_72564){
return (function (p1__65543__65544__auto__){
var G__69072 = p1__65543__65544__auto__;
return Math.cosh(G__69072);
});})(G__69069_72563,G__69070_72564))
);
});})(G__69069_72563,G__69070_72564))
;
goog.object.set(G__69069_72563,G__69070_72564,G__69071_72565);

var G__69073_72567 = clojure.core.matrix.protocols.exp;
var G__69074_72568 = "array";
var G__69075_72569 = ((function (G__69073_72567,G__69074_72568){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69073_72567,G__69074_72568){
return (function (p1__65543__65544__auto__){
var G__69076 = p1__65543__65544__auto__;
return Math.exp(G__69076);
});})(G__69073_72567,G__69074_72568))
);
});})(G__69073_72567,G__69074_72568))
;
goog.object.set(G__69073_72567,G__69074_72568,G__69075_72569);

var G__69077_72577 = clojure.core.matrix.protocols.floor;
var G__69078_72578 = "array";
var G__69079_72579 = ((function (G__69077_72577,G__69078_72578){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69077_72577,G__69078_72578){
return (function (p1__65543__65544__auto__){
var G__69080 = p1__65543__65544__auto__;
return Math.floor(G__69080);
});})(G__69077_72577,G__69078_72578))
);
});})(G__69077_72577,G__69078_72578))
;
goog.object.set(G__69077_72577,G__69078_72578,G__69079_72579);

var G__69081_72581 = clojure.core.matrix.protocols.log;
var G__69082_72582 = "array";
var G__69083_72583 = ((function (G__69081_72581,G__69082_72582){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69081_72581,G__69082_72582){
return (function (p1__65543__65544__auto__){
var G__69084 = p1__65543__65544__auto__;
return Math.log(G__69084);
});})(G__69081_72581,G__69082_72582))
);
});})(G__69081_72581,G__69082_72582))
;
goog.object.set(G__69081_72581,G__69082_72582,G__69083_72583);

var G__69086_72585 = clojure.core.matrix.protocols.log10;
var G__69087_72586 = "array";
var G__69088_72587 = ((function (G__69086_72585,G__69087_72586){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69086_72585,G__69087_72586){
return (function (p1__65543__65544__auto__){
var G__69089 = p1__65543__65544__auto__;
return Math.log10(G__69089);
});})(G__69086_72585,G__69087_72586))
);
});})(G__69086_72585,G__69087_72586))
;
goog.object.set(G__69086_72585,G__69087_72586,G__69088_72587);

var G__69090_72589 = clojure.core.matrix.protocols.round;
var G__69091_72590 = "array";
var G__69092_72591 = ((function (G__69090_72589,G__69091_72590){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69090_72589,G__69091_72590){
return (function (p1__65543__65544__auto__){
var G__69100 = p1__65543__65544__auto__;
return Math.rint(G__69100);
});})(G__69090_72589,G__69091_72590))
);
});})(G__69090_72589,G__69091_72590))
;
goog.object.set(G__69090_72589,G__69091_72590,G__69092_72591);

var G__69101_72596 = clojure.core.matrix.protocols.signum;
var G__69102_72597 = "array";
var G__69103_72598 = ((function (G__69101_72596,G__69102_72597){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69101_72596,G__69102_72597){
return (function (p1__65543__65544__auto__){
var G__69105 = p1__65543__65544__auto__;
return Math.sign(G__69105);
});})(G__69101_72596,G__69102_72597))
);
});})(G__69101_72596,G__69102_72597))
;
goog.object.set(G__69101_72596,G__69102_72597,G__69103_72598);

var G__69106_72600 = clojure.core.matrix.protocols.sin;
var G__69107_72601 = "array";
var G__69108_72602 = ((function (G__69106_72600,G__69107_72601){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69106_72600,G__69107_72601){
return (function (p1__65543__65544__auto__){
var G__69109 = p1__65543__65544__auto__;
return Math.sin(G__69109);
});})(G__69106_72600,G__69107_72601))
);
});})(G__69106_72600,G__69107_72601))
;
goog.object.set(G__69106_72600,G__69107_72601,G__69108_72602);

var G__69111_72611 = clojure.core.matrix.protocols.sinh;
var G__69112_72612 = "array";
var G__69113_72613 = ((function (G__69111_72611,G__69112_72612){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69111_72611,G__69112_72612){
return (function (p1__65543__65544__auto__){
var G__69114 = p1__65543__65544__auto__;
return Math.sinh(G__69114);
});})(G__69111_72611,G__69112_72612))
);
});})(G__69111_72611,G__69112_72612))
;
goog.object.set(G__69111_72611,G__69112_72612,G__69113_72613);

var G__69115_72615 = clojure.core.matrix.protocols.sqrt;
var G__69116_72616 = "array";
var G__69117_72617 = ((function (G__69115_72615,G__69116_72616){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69115_72615,G__69116_72616){
return (function (p1__65543__65544__auto__){
var G__69118 = p1__65543__65544__auto__;
return Math.sqrt(G__69118);
});})(G__69115_72615,G__69116_72616))
);
});})(G__69115_72615,G__69116_72616))
;
goog.object.set(G__69115_72615,G__69116_72616,G__69117_72617);

var G__69119_72619 = clojure.core.matrix.protocols.tan;
var G__69120_72620 = "array";
var G__69121_72621 = ((function (G__69119_72619,G__69120_72620){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69119_72619,G__69120_72620){
return (function (p1__65543__65544__auto__){
var G__69122 = p1__65543__65544__auto__;
return Math.tan(G__69122);
});})(G__69119_72619,G__69120_72620))
);
});})(G__69119_72619,G__69120_72620))
;
goog.object.set(G__69119_72619,G__69120_72620,G__69121_72621);

var G__69124_72622 = clojure.core.matrix.protocols.tanh;
var G__69125_72623 = "array";
var G__69126_72624 = ((function (G__69124_72622,G__69125_72623){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69124_72622,G__69125_72623){
return (function (p1__65543__65544__auto__){
var G__69127 = p1__65543__65544__auto__;
return Math.tanh(G__69127);
});})(G__69124_72622,G__69125_72623))
);
});})(G__69124_72622,G__69125_72623))
;
goog.object.set(G__69124_72622,G__69125_72623,G__69126_72624);

var G__69128_72625 = clojure.core.matrix.protocols.to_degrees;
var G__69129_72626 = "array";
var G__69130_72627 = ((function (G__69128_72625,G__69129_72626){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69128_72625,G__69129_72626){
return (function (p1__65543__65544__auto__){
return clojure.core.matrix.impl.mathsops.to_degrees_STAR_(p1__65543__65544__auto__);
});})(G__69128_72625,G__69129_72626))
);
});})(G__69128_72625,G__69129_72626))
;
goog.object.set(G__69128_72625,G__69129_72626,G__69130_72627);

var G__69132_72628 = clojure.core.matrix.protocols.to_radians;
var G__69133_72629 = "array";
var G__69134_72630 = ((function (G__69132_72628,G__69133_72629){
return (function (m){
return clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,((function (G__69132_72628,G__69133_72629){
return (function (p1__65543__65544__auto__){
return clojure.core.matrix.impl.mathsops.to_radians_STAR_(p1__65543__65544__auto__);
});})(G__69132_72628,G__69133_72629))
);
});})(G__69132_72628,G__69133_72629))
;
goog.object.set(G__69132_72628,G__69133_72629,G__69134_72630);
goog.object.set(clojure.core.matrix.protocols.PMathsFunctionsMutable,"number",true);

var G__69142_72634 = clojure.core.matrix.protocols.abs_BANG_;
var G__69143_72635 = "number";
var G__69144_72636 = ((function (G__69142_72634,G__69143_72635){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69142_72634,G__69143_72635))
;
goog.object.set(G__69142_72634,G__69143_72635,G__69144_72636);

var G__69149_72637 = clojure.core.matrix.protocols.acos_BANG_;
var G__69150_72638 = "number";
var G__69151_72639 = ((function (G__69149_72637,G__69150_72638){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69149_72637,G__69150_72638))
;
goog.object.set(G__69149_72637,G__69150_72638,G__69151_72639);

var G__69152_72640 = clojure.core.matrix.protocols.asin_BANG_;
var G__69153_72641 = "number";
var G__69154_72642 = ((function (G__69152_72640,G__69153_72641){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69152_72640,G__69153_72641))
;
goog.object.set(G__69152_72640,G__69153_72641,G__69154_72642);

var G__69155_72649 = clojure.core.matrix.protocols.atan_BANG_;
var G__69156_72650 = "number";
var G__69157_72651 = ((function (G__69155_72649,G__69156_72650){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69155_72649,G__69156_72650))
;
goog.object.set(G__69155_72649,G__69156_72650,G__69157_72651);

var G__69159_72652 = clojure.core.matrix.protocols.cbrt_BANG_;
var G__69160_72653 = "number";
var G__69161_72654 = ((function (G__69159_72652,G__69160_72653){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69159_72652,G__69160_72653))
;
goog.object.set(G__69159_72652,G__69160_72653,G__69161_72654);

var G__69162_72657 = clojure.core.matrix.protocols.ceil_BANG_;
var G__69163_72658 = "number";
var G__69164_72659 = ((function (G__69162_72657,G__69163_72658){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69162_72657,G__69163_72658))
;
goog.object.set(G__69162_72657,G__69163_72658,G__69164_72659);

var G__69165_72661 = clojure.core.matrix.protocols.cos_BANG_;
var G__69166_72662 = "number";
var G__69167_72663 = ((function (G__69165_72661,G__69166_72662){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69165_72661,G__69166_72662))
;
goog.object.set(G__69165_72661,G__69166_72662,G__69167_72663);

var G__69172_72664 = clojure.core.matrix.protocols.cosh_BANG_;
var G__69173_72665 = "number";
var G__69174_72666 = ((function (G__69172_72664,G__69173_72665){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69172_72664,G__69173_72665))
;
goog.object.set(G__69172_72664,G__69173_72665,G__69174_72666);

var G__69180_72672 = clojure.core.matrix.protocols.exp_BANG_;
var G__69181_72673 = "number";
var G__69182_72674 = ((function (G__69180_72672,G__69181_72673){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69180_72672,G__69181_72673))
;
goog.object.set(G__69180_72672,G__69181_72673,G__69182_72674);

var G__69183_72678 = clojure.core.matrix.protocols.floor_BANG_;
var G__69184_72679 = "number";
var G__69185_72680 = ((function (G__69183_72678,G__69184_72679){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69183_72678,G__69184_72679))
;
goog.object.set(G__69183_72678,G__69184_72679,G__69185_72680);

var G__69186_72687 = clojure.core.matrix.protocols.log_BANG_;
var G__69187_72688 = "number";
var G__69188_72689 = ((function (G__69186_72687,G__69187_72688){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69186_72687,G__69187_72688))
;
goog.object.set(G__69186_72687,G__69187_72688,G__69188_72689);

var G__69194_72690 = clojure.core.matrix.protocols.log10_BANG_;
var G__69195_72691 = "number";
var G__69196_72692 = ((function (G__69194_72690,G__69195_72691){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69194_72690,G__69195_72691))
;
goog.object.set(G__69194_72690,G__69195_72691,G__69196_72692);

var G__69197_72693 = clojure.core.matrix.protocols.round_BANG_;
var G__69198_72694 = "number";
var G__69199_72695 = ((function (G__69197_72693,G__69198_72694){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69197_72693,G__69198_72694))
;
goog.object.set(G__69197_72693,G__69198_72694,G__69199_72695);

var G__69204_72697 = clojure.core.matrix.protocols.signum_BANG_;
var G__69205_72698 = "number";
var G__69206_72699 = ((function (G__69204_72697,G__69205_72698){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69204_72697,G__69205_72698))
;
goog.object.set(G__69204_72697,G__69205_72698,G__69206_72699);

var G__69208_72700 = clojure.core.matrix.protocols.sin_BANG_;
var G__69209_72701 = "number";
var G__69210_72702 = ((function (G__69208_72700,G__69209_72701){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69208_72700,G__69209_72701))
;
goog.object.set(G__69208_72700,G__69209_72701,G__69210_72702);

var G__69220_72703 = clojure.core.matrix.protocols.sinh_BANG_;
var G__69221_72704 = "number";
var G__69222_72705 = ((function (G__69220_72703,G__69221_72704){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69220_72703,G__69221_72704))
;
goog.object.set(G__69220_72703,G__69221_72704,G__69222_72705);

var G__69227_72709 = clojure.core.matrix.protocols.sqrt_BANG_;
var G__69228_72710 = "number";
var G__69229_72711 = ((function (G__69227_72709,G__69228_72710){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69227_72709,G__69228_72710))
;
goog.object.set(G__69227_72709,G__69228_72710,G__69229_72711);

var G__69230_72712 = clojure.core.matrix.protocols.tan_BANG_;
var G__69231_72713 = "number";
var G__69232_72714 = ((function (G__69230_72712,G__69231_72713){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69230_72712,G__69231_72713))
;
goog.object.set(G__69230_72712,G__69231_72713,G__69232_72714);

var G__69233_72715 = clojure.core.matrix.protocols.tanh_BANG_;
var G__69234_72716 = "number";
var G__69235_72717 = ((function (G__69233_72715,G__69234_72716){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69233_72715,G__69234_72716))
;
goog.object.set(G__69233_72715,G__69234_72716,G__69235_72717);

var G__69240_72718 = clojure.core.matrix.protocols.to_degrees_BANG_;
var G__69241_72719 = "number";
var G__69242_72720 = ((function (G__69240_72718,G__69241_72719){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69240_72718,G__69241_72719))
;
goog.object.set(G__69240_72718,G__69241_72719,G__69242_72720);

var G__69244_72722 = clojure.core.matrix.protocols.to_radians_BANG_;
var G__69245_72723 = "number";
var G__69246_72724 = ((function (G__69244_72722,G__69245_72723){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Number is not mutable!",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69244_72722,G__69245_72723))
;
goog.object.set(G__69244_72722,G__69245_72723,G__69246_72724);

goog.object.set(clojure.core.matrix.protocols.PMathsFunctionsMutable,"object",true);

var G__69247_72726 = clojure.core.matrix.protocols.abs_BANG_;
var G__69248_72727 = "object";
var G__69249_72728 = ((function (G__69247_72726,G__69248_72727){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69247_72726,G__69248_72727){
return (function (p1__65545__65546__auto__){
var G__69254 = p1__65545__65546__auto__;
return Math.abs(G__69254);
});})(G__69247_72726,G__69248_72727))
);
});})(G__69247_72726,G__69248_72727))
;
goog.object.set(G__69247_72726,G__69248_72727,G__69249_72728);

var G__69255_72729 = clojure.core.matrix.protocols.acos_BANG_;
var G__69256_72730 = "object";
var G__69257_72731 = ((function (G__69255_72729,G__69256_72730){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69255_72729,G__69256_72730){
return (function (p1__65545__65546__auto__){
var G__69258 = p1__65545__65546__auto__;
return Math.acos(G__69258);
});})(G__69255_72729,G__69256_72730))
);
});})(G__69255_72729,G__69256_72730))
;
goog.object.set(G__69255_72729,G__69256_72730,G__69257_72731);

var G__69259_72740 = clojure.core.matrix.protocols.asin_BANG_;
var G__69260_72741 = "object";
var G__69261_72742 = ((function (G__69259_72740,G__69260_72741){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69259_72740,G__69260_72741){
return (function (p1__65545__65546__auto__){
var G__69262 = p1__65545__65546__auto__;
return Math.asin(G__69262);
});})(G__69259_72740,G__69260_72741))
);
});})(G__69259_72740,G__69260_72741))
;
goog.object.set(G__69259_72740,G__69260_72741,G__69261_72742);

var G__69263_72745 = clojure.core.matrix.protocols.atan_BANG_;
var G__69264_72746 = "object";
var G__69265_72747 = ((function (G__69263_72745,G__69264_72746){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69263_72745,G__69264_72746){
return (function (p1__65545__65546__auto__){
var G__69266 = p1__65545__65546__auto__;
return Math.atan(G__69266);
});})(G__69263_72745,G__69264_72746))
);
});})(G__69263_72745,G__69264_72746))
;
goog.object.set(G__69263_72745,G__69264_72746,G__69265_72747);

var G__69267_72748 = clojure.core.matrix.protocols.cbrt_BANG_;
var G__69268_72749 = "object";
var G__69269_72750 = ((function (G__69267_72748,G__69268_72749){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69267_72748,G__69268_72749){
return (function (p1__65545__65546__auto__){
var G__69270 = p1__65545__65546__auto__;
return Math.cbrt(G__69270);
});})(G__69267_72748,G__69268_72749))
);
});})(G__69267_72748,G__69268_72749))
;
goog.object.set(G__69267_72748,G__69268_72749,G__69269_72750);

var G__69271_72752 = clojure.core.matrix.protocols.ceil_BANG_;
var G__69272_72753 = "object";
var G__69273_72754 = ((function (G__69271_72752,G__69272_72753){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69271_72752,G__69272_72753){
return (function (p1__65545__65546__auto__){
var G__69274 = p1__65545__65546__auto__;
return Math.ceil(G__69274);
});})(G__69271_72752,G__69272_72753))
);
});})(G__69271_72752,G__69272_72753))
;
goog.object.set(G__69271_72752,G__69272_72753,G__69273_72754);

var G__69275_72756 = clojure.core.matrix.protocols.cos_BANG_;
var G__69276_72757 = "object";
var G__69277_72758 = ((function (G__69275_72756,G__69276_72757){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69275_72756,G__69276_72757){
return (function (p1__65545__65546__auto__){
var G__69279 = p1__65545__65546__auto__;
return Math.cos(G__69279);
});})(G__69275_72756,G__69276_72757))
);
});})(G__69275_72756,G__69276_72757))
;
goog.object.set(G__69275_72756,G__69276_72757,G__69277_72758);

var G__69280_72764 = clojure.core.matrix.protocols.cosh_BANG_;
var G__69281_72765 = "object";
var G__69282_72766 = ((function (G__69280_72764,G__69281_72765){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69280_72764,G__69281_72765){
return (function (p1__65545__65546__auto__){
var G__69286 = p1__65545__65546__auto__;
return Math.cosh(G__69286);
});})(G__69280_72764,G__69281_72765))
);
});})(G__69280_72764,G__69281_72765))
;
goog.object.set(G__69280_72764,G__69281_72765,G__69282_72766);

var G__69291_72769 = clojure.core.matrix.protocols.exp_BANG_;
var G__69292_72770 = "object";
var G__69293_72771 = ((function (G__69291_72769,G__69292_72770){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69291_72769,G__69292_72770){
return (function (p1__65545__65546__auto__){
var G__69294 = p1__65545__65546__auto__;
return Math.exp(G__69294);
});})(G__69291_72769,G__69292_72770))
);
});})(G__69291_72769,G__69292_72770))
;
goog.object.set(G__69291_72769,G__69292_72770,G__69293_72771);

var G__69297_72773 = clojure.core.matrix.protocols.floor_BANG_;
var G__69298_72774 = "object";
var G__69299_72775 = ((function (G__69297_72773,G__69298_72774){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69297_72773,G__69298_72774){
return (function (p1__65545__65546__auto__){
var G__69300 = p1__65545__65546__auto__;
return Math.floor(G__69300);
});})(G__69297_72773,G__69298_72774))
);
});})(G__69297_72773,G__69298_72774))
;
goog.object.set(G__69297_72773,G__69298_72774,G__69299_72775);

var G__69301_72783 = clojure.core.matrix.protocols.log_BANG_;
var G__69302_72784 = "object";
var G__69303_72785 = ((function (G__69301_72783,G__69302_72784){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69301_72783,G__69302_72784){
return (function (p1__65545__65546__auto__){
var G__69304 = p1__65545__65546__auto__;
return Math.log(G__69304);
});})(G__69301_72783,G__69302_72784))
);
});})(G__69301_72783,G__69302_72784))
;
goog.object.set(G__69301_72783,G__69302_72784,G__69303_72785);

var G__69305_72787 = clojure.core.matrix.protocols.log10_BANG_;
var G__69306_72788 = "object";
var G__69307_72789 = ((function (G__69305_72787,G__69306_72788){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69305_72787,G__69306_72788){
return (function (p1__65545__65546__auto__){
var G__69308 = p1__65545__65546__auto__;
return Math.log10(G__69308);
});})(G__69305_72787,G__69306_72788))
);
});})(G__69305_72787,G__69306_72788))
;
goog.object.set(G__69305_72787,G__69306_72788,G__69307_72789);

var G__69309_72790 = clojure.core.matrix.protocols.round_BANG_;
var G__69310_72791 = "object";
var G__69311_72792 = ((function (G__69309_72790,G__69310_72791){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69309_72790,G__69310_72791){
return (function (p1__65545__65546__auto__){
var G__69312 = p1__65545__65546__auto__;
return Math.rint(G__69312);
});})(G__69309_72790,G__69310_72791))
);
});})(G__69309_72790,G__69310_72791))
;
goog.object.set(G__69309_72790,G__69310_72791,G__69311_72792);

var G__69315_72794 = clojure.core.matrix.protocols.signum_BANG_;
var G__69316_72795 = "object";
var G__69317_72796 = ((function (G__69315_72794,G__69316_72795){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69315_72794,G__69316_72795){
return (function (p1__65545__65546__auto__){
var G__69318 = p1__65545__65546__auto__;
return Math.sign(G__69318);
});})(G__69315_72794,G__69316_72795))
);
});})(G__69315_72794,G__69316_72795))
;
goog.object.set(G__69315_72794,G__69316_72795,G__69317_72796);

var G__69319_72801 = clojure.core.matrix.protocols.sin_BANG_;
var G__69320_72802 = "object";
var G__69321_72803 = ((function (G__69319_72801,G__69320_72802){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69319_72801,G__69320_72802){
return (function (p1__65545__65546__auto__){
var G__69322 = p1__65545__65546__auto__;
return Math.sin(G__69322);
});})(G__69319_72801,G__69320_72802))
);
});})(G__69319_72801,G__69320_72802))
;
goog.object.set(G__69319_72801,G__69320_72802,G__69321_72803);

var G__69327_72804 = clojure.core.matrix.protocols.sinh_BANG_;
var G__69328_72805 = "object";
var G__69329_72806 = ((function (G__69327_72804,G__69328_72805){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69327_72804,G__69328_72805){
return (function (p1__65545__65546__auto__){
var G__69330 = p1__65545__65546__auto__;
return Math.sinh(G__69330);
});})(G__69327_72804,G__69328_72805))
);
});})(G__69327_72804,G__69328_72805))
;
goog.object.set(G__69327_72804,G__69328_72805,G__69329_72806);

var G__69336_72807 = clojure.core.matrix.protocols.sqrt_BANG_;
var G__69337_72808 = "object";
var G__69338_72809 = ((function (G__69336_72807,G__69337_72808){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69336_72807,G__69337_72808){
return (function (p1__65545__65546__auto__){
var G__69341 = p1__65545__65546__auto__;
return Math.sqrt(G__69341);
});})(G__69336_72807,G__69337_72808))
);
});})(G__69336_72807,G__69337_72808))
;
goog.object.set(G__69336_72807,G__69337_72808,G__69338_72809);

var G__69342_72813 = clojure.core.matrix.protocols.tan_BANG_;
var G__69343_72814 = "object";
var G__69344_72815 = ((function (G__69342_72813,G__69343_72814){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69342_72813,G__69343_72814){
return (function (p1__65545__65546__auto__){
var G__69345 = p1__65545__65546__auto__;
return Math.tan(G__69345);
});})(G__69342_72813,G__69343_72814))
);
});})(G__69342_72813,G__69343_72814))
;
goog.object.set(G__69342_72813,G__69343_72814,G__69344_72815);

var G__69346_72820 = clojure.core.matrix.protocols.tanh_BANG_;
var G__69347_72821 = "object";
var G__69348_72822 = ((function (G__69346_72820,G__69347_72821){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69346_72820,G__69347_72821){
return (function (p1__65545__65546__auto__){
var G__69349 = p1__65545__65546__auto__;
return Math.tanh(G__69349);
});})(G__69346_72820,G__69347_72821))
);
});})(G__69346_72820,G__69347_72821))
;
goog.object.set(G__69346_72820,G__69347_72821,G__69348_72822);

var G__69350_72826 = clojure.core.matrix.protocols.to_degrees_BANG_;
var G__69351_72827 = "object";
var G__69352_72828 = ((function (G__69350_72826,G__69351_72827){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69350_72826,G__69351_72827){
return (function (p1__65545__65546__auto__){
return clojure.core.matrix.impl.mathsops.to_degrees_STAR_(p1__65545__65546__auto__);
});})(G__69350_72826,G__69351_72827))
);
});})(G__69350_72826,G__69351_72827))
;
goog.object.set(G__69350_72826,G__69351_72827,G__69352_72828);

var G__69354_72829 = clojure.core.matrix.protocols.to_radians_BANG_;
var G__69355_72830 = "object";
var G__69356_72831 = ((function (G__69354_72829,G__69355_72830){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69354_72829,G__69355_72830){
return (function (p1__65545__65546__auto__){
return clojure.core.matrix.impl.mathsops.to_radians_STAR_(p1__65545__65546__auto__);
});})(G__69354_72829,G__69355_72830))
);
});})(G__69354_72829,G__69355_72830))
;
goog.object.set(G__69354_72829,G__69355_72830,G__69356_72831);

goog.object.set(clojure.core.matrix.protocols.PMathsFunctionsMutable,"array",true);

var G__69357_72840 = clojure.core.matrix.protocols.abs_BANG_;
var G__69358_72841 = "array";
var G__69359_72842 = ((function (G__69357_72840,G__69358_72841){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69357_72840,G__69358_72841){
return (function (p1__65547__65548__auto__){
var G__69360 = p1__65547__65548__auto__;
return Math.abs(G__69360);
});})(G__69357_72840,G__69358_72841))
);
});})(G__69357_72840,G__69358_72841))
;
goog.object.set(G__69357_72840,G__69358_72841,G__69359_72842);

var G__69361_72845 = clojure.core.matrix.protocols.acos_BANG_;
var G__69362_72846 = "array";
var G__69363_72847 = ((function (G__69361_72845,G__69362_72846){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69361_72845,G__69362_72846){
return (function (p1__65547__65548__auto__){
var G__69365 = p1__65547__65548__auto__;
return Math.acos(G__69365);
});})(G__69361_72845,G__69362_72846))
);
});})(G__69361_72845,G__69362_72846))
;
goog.object.set(G__69361_72845,G__69362_72846,G__69363_72847);

var G__69366_72849 = clojure.core.matrix.protocols.asin_BANG_;
var G__69367_72850 = "array";
var G__69368_72851 = ((function (G__69366_72849,G__69367_72850){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69366_72849,G__69367_72850){
return (function (p1__65547__65548__auto__){
var G__69369 = p1__65547__65548__auto__;
return Math.asin(G__69369);
});})(G__69366_72849,G__69367_72850))
);
});})(G__69366_72849,G__69367_72850))
;
goog.object.set(G__69366_72849,G__69367_72850,G__69368_72851);

var G__69370_72852 = clojure.core.matrix.protocols.atan_BANG_;
var G__69371_72853 = "array";
var G__69372_72854 = ((function (G__69370_72852,G__69371_72853){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69370_72852,G__69371_72853){
return (function (p1__65547__65548__auto__){
var G__69374 = p1__65547__65548__auto__;
return Math.atan(G__69374);
});})(G__69370_72852,G__69371_72853))
);
});})(G__69370_72852,G__69371_72853))
;
goog.object.set(G__69370_72852,G__69371_72853,G__69372_72854);

var G__69375_72857 = clojure.core.matrix.protocols.cbrt_BANG_;
var G__69376_72858 = "array";
var G__69377_72859 = ((function (G__69375_72857,G__69376_72858){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69375_72857,G__69376_72858){
return (function (p1__65547__65548__auto__){
var G__69378 = p1__65547__65548__auto__;
return Math.cbrt(G__69378);
});})(G__69375_72857,G__69376_72858))
);
});})(G__69375_72857,G__69376_72858))
;
goog.object.set(G__69375_72857,G__69376_72858,G__69377_72859);

var G__69383_72862 = clojure.core.matrix.protocols.ceil_BANG_;
var G__69384_72863 = "array";
var G__69385_72864 = ((function (G__69383_72862,G__69384_72863){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69383_72862,G__69384_72863){
return (function (p1__65547__65548__auto__){
var G__69386 = p1__65547__65548__auto__;
return Math.ceil(G__69386);
});})(G__69383_72862,G__69384_72863))
);
});})(G__69383_72862,G__69384_72863))
;
goog.object.set(G__69383_72862,G__69384_72863,G__69385_72864);

var G__69388_72867 = clojure.core.matrix.protocols.cos_BANG_;
var G__69389_72868 = "array";
var G__69390_72869 = ((function (G__69388_72867,G__69389_72868){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69388_72867,G__69389_72868){
return (function (p1__65547__65548__auto__){
var G__69394 = p1__65547__65548__auto__;
return Math.cos(G__69394);
});})(G__69388_72867,G__69389_72868))
);
});})(G__69388_72867,G__69389_72868))
;
goog.object.set(G__69388_72867,G__69389_72868,G__69390_72869);

var G__69395_72877 = clojure.core.matrix.protocols.cosh_BANG_;
var G__69396_72878 = "array";
var G__69397_72879 = ((function (G__69395_72877,G__69396_72878){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69395_72877,G__69396_72878){
return (function (p1__65547__65548__auto__){
var G__69398 = p1__65547__65548__auto__;
return Math.cosh(G__69398);
});})(G__69395_72877,G__69396_72878))
);
});})(G__69395_72877,G__69396_72878))
;
goog.object.set(G__69395_72877,G__69396_72878,G__69397_72879);

var G__69399_72886 = clojure.core.matrix.protocols.exp_BANG_;
var G__69400_72887 = "array";
var G__69401_72888 = ((function (G__69399_72886,G__69400_72887){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69399_72886,G__69400_72887){
return (function (p1__65547__65548__auto__){
var G__69402 = p1__65547__65548__auto__;
return Math.exp(G__69402);
});})(G__69399_72886,G__69400_72887))
);
});})(G__69399_72886,G__69400_72887))
;
goog.object.set(G__69399_72886,G__69400_72887,G__69401_72888);

var G__69403_72893 = clojure.core.matrix.protocols.floor_BANG_;
var G__69404_72894 = "array";
var G__69405_72895 = ((function (G__69403_72893,G__69404_72894){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69403_72893,G__69404_72894){
return (function (p1__65547__65548__auto__){
var G__69408 = p1__65547__65548__auto__;
return Math.floor(G__69408);
});})(G__69403_72893,G__69404_72894))
);
});})(G__69403_72893,G__69404_72894))
;
goog.object.set(G__69403_72893,G__69404_72894,G__69405_72895);

var G__69410_72897 = clojure.core.matrix.protocols.log_BANG_;
var G__69411_72898 = "array";
var G__69412_72899 = ((function (G__69410_72897,G__69411_72898){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69410_72897,G__69411_72898){
return (function (p1__65547__65548__auto__){
var G__69413 = p1__65547__65548__auto__;
return Math.log(G__69413);
});})(G__69410_72897,G__69411_72898))
);
});})(G__69410_72897,G__69411_72898))
;
goog.object.set(G__69410_72897,G__69411_72898,G__69412_72899);

var G__69414_72906 = clojure.core.matrix.protocols.log10_BANG_;
var G__69415_72907 = "array";
var G__69416_72908 = ((function (G__69414_72906,G__69415_72907){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69414_72906,G__69415_72907){
return (function (p1__65547__65548__auto__){
var G__69418 = p1__65547__65548__auto__;
return Math.log10(G__69418);
});})(G__69414_72906,G__69415_72907))
);
});})(G__69414_72906,G__69415_72907))
;
goog.object.set(G__69414_72906,G__69415_72907,G__69416_72908);

var G__69422_72910 = clojure.core.matrix.protocols.round_BANG_;
var G__69423_72911 = "array";
var G__69424_72912 = ((function (G__69422_72910,G__69423_72911){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69422_72910,G__69423_72911){
return (function (p1__65547__65548__auto__){
var G__69425 = p1__65547__65548__auto__;
return Math.rint(G__69425);
});})(G__69422_72910,G__69423_72911))
);
});})(G__69422_72910,G__69423_72911))
;
goog.object.set(G__69422_72910,G__69423_72911,G__69424_72912);

var G__69426_72916 = clojure.core.matrix.protocols.signum_BANG_;
var G__69427_72917 = "array";
var G__69428_72918 = ((function (G__69426_72916,G__69427_72917){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69426_72916,G__69427_72917){
return (function (p1__65547__65548__auto__){
var G__69429 = p1__65547__65548__auto__;
return Math.sign(G__69429);
});})(G__69426_72916,G__69427_72917))
);
});})(G__69426_72916,G__69427_72917))
;
goog.object.set(G__69426_72916,G__69427_72917,G__69428_72918);

var G__69430_72920 = clojure.core.matrix.protocols.sin_BANG_;
var G__69431_72921 = "array";
var G__69432_72922 = ((function (G__69430_72920,G__69431_72921){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69430_72920,G__69431_72921){
return (function (p1__65547__65548__auto__){
var G__69433 = p1__65547__65548__auto__;
return Math.sin(G__69433);
});})(G__69430_72920,G__69431_72921))
);
});})(G__69430_72920,G__69431_72921))
;
goog.object.set(G__69430_72920,G__69431_72921,G__69432_72922);

var G__69434_72928 = clojure.core.matrix.protocols.sinh_BANG_;
var G__69435_72929 = "array";
var G__69436_72930 = ((function (G__69434_72928,G__69435_72929){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69434_72928,G__69435_72929){
return (function (p1__65547__65548__auto__){
var G__69437 = p1__65547__65548__auto__;
return Math.sinh(G__69437);
});})(G__69434_72928,G__69435_72929))
);
});})(G__69434_72928,G__69435_72929))
;
goog.object.set(G__69434_72928,G__69435_72929,G__69436_72930);

var G__69438_72931 = clojure.core.matrix.protocols.sqrt_BANG_;
var G__69439_72932 = "array";
var G__69440_72933 = ((function (G__69438_72931,G__69439_72932){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69438_72931,G__69439_72932){
return (function (p1__65547__65548__auto__){
var G__69441 = p1__65547__65548__auto__;
return Math.sqrt(G__69441);
});})(G__69438_72931,G__69439_72932))
);
});})(G__69438_72931,G__69439_72932))
;
goog.object.set(G__69438_72931,G__69439_72932,G__69440_72933);

var G__69443_72934 = clojure.core.matrix.protocols.tan_BANG_;
var G__69444_72935 = "array";
var G__69445_72936 = ((function (G__69443_72934,G__69444_72935){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69443_72934,G__69444_72935){
return (function (p1__65547__65548__auto__){
var G__69446 = p1__65547__65548__auto__;
return Math.tan(G__69446);
});})(G__69443_72934,G__69444_72935))
);
});})(G__69443_72934,G__69444_72935))
;
goog.object.set(G__69443_72934,G__69444_72935,G__69445_72936);

var G__69450_72937 = clojure.core.matrix.protocols.tanh_BANG_;
var G__69451_72938 = "array";
var G__69452_72939 = ((function (G__69450_72937,G__69451_72938){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69450_72937,G__69451_72938){
return (function (p1__65547__65548__auto__){
var G__69457 = p1__65547__65548__auto__;
return Math.tanh(G__69457);
});})(G__69450_72937,G__69451_72938))
);
});})(G__69450_72937,G__69451_72938))
;
goog.object.set(G__69450_72937,G__69451_72938,G__69452_72939);

var G__69458_72940 = clojure.core.matrix.protocols.to_degrees_BANG_;
var G__69459_72941 = "array";
var G__69460_72942 = ((function (G__69458_72940,G__69459_72941){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69458_72940,G__69459_72941){
return (function (p1__65547__65548__auto__){
return clojure.core.matrix.impl.mathsops.to_degrees_STAR_(p1__65547__65548__auto__);
});})(G__69458_72940,G__69459_72941))
);
});})(G__69458_72940,G__69459_72941))
;
goog.object.set(G__69458_72940,G__69459_72941,G__69460_72942);

var G__69463_72944 = clojure.core.matrix.protocols.to_radians_BANG_;
var G__69464_72945 = "array";
var G__69465_72946 = ((function (G__69463_72944,G__69464_72945){
return (function (m){
return clojure.core.matrix.protocols.element_map_BANG_.cljs$core$IFn$_invoke$arity$2(m,((function (G__69463_72944,G__69464_72945){
return (function (p1__65547__65548__auto__){
return clojure.core.matrix.impl.mathsops.to_radians_STAR_(p1__65547__65548__auto__);
});})(G__69463_72944,G__69464_72945))
);
});})(G__69463_72944,G__69464_72945))
;
goog.object.set(G__69463_72944,G__69464_72945,G__69465_72946);
goog.object.set(clojure.core.matrix.protocols.PMatrixSubComponents,"object",true);

var G__69466_72948 = clojure.core.matrix.protocols.main_diagonal;
var G__69467_72949 = "object";
var G__69468_72950 = ((function (G__69466_72948,G__69467_72949){
return (function (m){
var sh = clojure.core.matrix.protocols.get_shape(m);
var rank = cljs.core.count(sh);
var dims = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,sh);
var diag_vals = (function (){var iter__4523__auto__ = ((function (sh,rank,dims,G__69466_72948,G__69467_72949){
return (function clojure$core$matrix$impl$defaults$iter__69469(s__69470){
return (new cljs.core.LazySeq(null,((function (sh,rank,dims,G__69466_72948,G__69467_72949){
return (function (){
var s__69470__$1 = s__69470;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__69470__$1);
if(temp__5818__auto__){
var s__69470__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__69470__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__69470__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__69472 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__69471 = (0);
while(true){
if((i__69471 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__69471);
cljs.core.chunk_append(b__69472,clojure.core.matrix.protocols.get_nd(m,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(rank,i)));

var G__72954 = (i__69471 + (1));
i__69471 = G__72954;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__69472),clojure$core$matrix$impl$defaults$iter__69469(cljs.core.chunk_rest(s__69470__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__69472),null);
}
} else {
var i = cljs.core.first(s__69470__$2);
return cljs.core.cons(clojure.core.matrix.protocols.get_nd(m,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(rank,i)),clojure$core$matrix$impl$defaults$iter__69469(cljs.core.rest(s__69470__$2)));
}
} else {
return null;
}
break;
}
});})(sh,rank,dims,G__69466_72948,G__69467_72949))
,null,null));
});})(sh,rank,dims,G__69466_72948,G__69467_72949))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(dims));
})();
return clojure.core.matrix.implementations.construct(m,diag_vals);
});})(G__69466_72948,G__69467_72949))
;
goog.object.set(G__69466_72948,G__69467_72949,G__69468_72950);
goog.object.set(clojure.core.matrix.protocols.PSpecialisedConstructors,"object",true);

var G__69478_72961 = clojure.core.matrix.protocols.identity_matrix;
var G__69479_72962 = "object";
var G__69480_72963 = ((function (G__69478_72961,G__69479_72962){
return (function (m,dims){
return clojure.core.matrix.protocols.diagonal_matrix(m,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(dims,1.0));
});})(G__69478_72961,G__69479_72962))
;
goog.object.set(G__69478_72961,G__69479_72962,G__69480_72963);

var G__69484_72967 = clojure.core.matrix.protocols.diagonal_matrix;
var G__69485_72968 = "object";
var G__69486_72969 = ((function (G__69484_72967,G__69485_72968){
return (function (m,diagonal_values){
var dims = cljs.core.count(diagonal_values);
var diagonal_values__$1 = clojure.core.matrix.protocols.convert_to_nested_vectors(diagonal_values);
var zs = cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(dims,0.0));
var dm = cljs.core.vec((function (){var iter__4523__auto__ = ((function (dims,diagonal_values__$1,zs,G__69484_72967,G__69485_72968){
return (function clojure$core$matrix$impl$defaults$iter__69491(s__69492){
return (new cljs.core.LazySeq(null,((function (dims,diagonal_values__$1,zs,G__69484_72967,G__69485_72968){
return (function (){
var s__69492__$1 = s__69492;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__69492__$1);
if(temp__5818__auto__){
var s__69492__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__69492__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__69492__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__69494 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__69493 = (0);
while(true){
if((i__69493 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__69493);
cljs.core.chunk_append(b__69494,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(zs,i,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(diagonal_values__$1,i)));

var G__72979 = (i__69493 + (1));
i__69493 = G__72979;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__69494),clojure$core$matrix$impl$defaults$iter__69491(cljs.core.chunk_rest(s__69492__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__69494),null);
}
} else {
var i = cljs.core.first(s__69492__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(zs,i,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(diagonal_values__$1,i)),clojure$core$matrix$impl$defaults$iter__69491(cljs.core.rest(s__69492__$2)));
}
} else {
return null;
}
break;
}
});})(dims,diagonal_values__$1,zs,G__69484_72967,G__69485_72968))
,null,null));
});})(dims,diagonal_values__$1,zs,G__69484_72967,G__69485_72968))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(dims));
})());
return clojure.core.matrix.protocols.coerce_param(m,dm);
});})(G__69484_72967,G__69485_72968))
;
goog.object.set(G__69484_72967,G__69485_72968,G__69486_72969);
goog.object.set(clojure.core.matrix.protocols.PPermutationMatrix,"object",true);

var G__69496_72982 = clojure.core.matrix.protocols.permutation_matrix;
var G__69497_72983 = "object";
var G__69498_72984 = ((function (G__69496_72982,G__69497_72983){
return (function (m,permutation){
var v = clojure.core.matrix.protocols.convert_to_nested_vectors(permutation);
var n = cljs.core.count(v);
var r = clojure.core.matrix.protocols.new_matrix(m,n,n);
var r__$1 = (cljs.core.truth_(clojure.core.matrix.protocols.is_mutable_QMARK_(r))?r:clojure.core.matrix.impl.defaults.construct_mutable_matrix(r));
var n__4607__auto___72986 = n;
var i_72987 = (0);
while(true){
if((i_72987 < n__4607__auto___72986)){
clojure.core.matrix.protocols.set_2d_BANG_(r__$1,i_72987,(v.cljs$core$IFn$_invoke$arity$1 ? v.cljs$core$IFn$_invoke$arity$1(i_72987) : v.call(null,i_72987)),1.0);

var G__72989 = (i_72987 + (1));
i_72987 = G__72989;
continue;
} else {
}
break;
}

return r__$1;
});})(G__69496_72982,G__69497_72983))
;
goog.object.set(G__69496_72982,G__69497_72983,G__69498_72984);
goog.object.set(clojure.core.matrix.protocols.PBlockDiagonalMatrix,"object",true);

var G__69499_72993 = clojure.core.matrix.protocols.block_diagonal_matrix;
var G__69500_72994 = "object";
var G__69501_72995 = ((function (G__69499_72993,G__69500_72994){
return (function (m,blocks){
var aux = ((function (G__69499_72993,G__69500_72994){
return (function clojure$core$matrix$impl$defaults$aux(acc,blocks__$1){
if(cljs.core.empty_QMARK_(blocks__$1)){
return acc;
} else {
var acc_dim = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(acc,(0)));
var new_block = (blocks__$1.cljs$core$IFn$_invoke$arity$1 ? blocks__$1.cljs$core$IFn$_invoke$arity$1((0)) : blocks__$1.call(null,(0)));
var new_block_dim = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(new_block,(0)));
var new_dim = (acc_dim + new_block_dim);
var dm = cljs.core.vec((function (){var iter__4523__auto__ = ((function (acc_dim,new_block,new_block_dim,new_dim,G__69499_72993,G__69500_72994){
return (function clojure$core$matrix$impl$defaults$aux_$_iter__69503(s__69504){
return (new cljs.core.LazySeq(null,((function (acc_dim,new_block,new_block_dim,new_dim,G__69499_72993,G__69500_72994){
return (function (){
var s__69504__$1 = s__69504;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__69504__$1);
if(temp__5818__auto__){
var s__69504__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__69504__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__69504__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__69506 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__69505 = (0);
while(true){
if((i__69505 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__69505);
cljs.core.chunk_append(b__69506,(((i < acc_dim))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2((acc.cljs$core$IFn$_invoke$arity$1 ? acc.cljs$core$IFn$_invoke$arity$1(i) : acc.call(null,i)),clojure.core.matrix.protocols.new_vector(cljs.core.PersistentVector.EMPTY,new_block_dim))):cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.new_vector(cljs.core.PersistentVector.EMPTY,acc_dim),(function (){var G__69515 = (i - acc_dim);
return (new_block.cljs$core$IFn$_invoke$arity$1 ? new_block.cljs$core$IFn$_invoke$arity$1(G__69515) : new_block.call(null,G__69515));
})()))));

var G__73003 = (i__69505 + (1));
i__69505 = G__73003;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__69506),clojure$core$matrix$impl$defaults$aux_$_iter__69503(cljs.core.chunk_rest(s__69504__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__69506),null);
}
} else {
var i = cljs.core.first(s__69504__$2);
return cljs.core.cons((((i < acc_dim))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2((acc.cljs$core$IFn$_invoke$arity$1 ? acc.cljs$core$IFn$_invoke$arity$1(i) : acc.call(null,i)),clojure.core.matrix.protocols.new_vector(cljs.core.PersistentVector.EMPTY,new_block_dim))):cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.new_vector(cljs.core.PersistentVector.EMPTY,acc_dim),(function (){var G__69516 = (i - acc_dim);
return (new_block.cljs$core$IFn$_invoke$arity$1 ? new_block.cljs$core$IFn$_invoke$arity$1(G__69516) : new_block.call(null,G__69516));
})()))),clojure$core$matrix$impl$defaults$aux_$_iter__69503(cljs.core.rest(s__69504__$2)));
}
} else {
return null;
}
break;
}
});})(acc_dim,new_block,new_block_dim,new_dim,G__69499_72993,G__69500_72994))
,null,null));
});})(acc_dim,new_block,new_block_dim,new_dim,G__69499_72993,G__69500_72994))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(new_dim));
})());
return clojure$core$matrix$impl$defaults$aux(dm,cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(blocks__$1,(1)));
}
});})(G__69499_72993,G__69500_72994))
;
return aux(cljs.core.PersistentVector.EMPTY,blocks);
});})(G__69499_72993,G__69500_72994))
;
goog.object.set(G__69499_72993,G__69500_72994,G__69501_72995);
goog.object.set(clojure.core.matrix.protocols.PMatrixPredicates,"object",true);

var G__69519_73008 = clojure.core.matrix.protocols.identity_matrix_QMARK_;
var G__69520_73009 = "object";
var G__69521_73010 = ((function (G__69519_73008,G__69520_73009){
return (function (m){
var rc = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(0)));
var cc = cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,(1)));
if((((cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)) === (2))) && ((rc === cc)))){
var i = cljs.core.long$((0));
while(true){
if((i < rc)){
if((function (){var j = cljs.core.long$((0));
while(true){
if((j < cc)){
var elem = clojure.core.matrix.protocols.get_2d(m,i,j);
if(typeof elem === 'number'){
if((i === j)){
if((elem === 1.0)){
var G__73018 = (j + (1));
j = G__73018;
continue;
} else {
return false;
}
} else {
if((elem === (0))){
var G__73020 = (j + (1));
j = G__73020;
continue;
} else {
return false;
}
}
} else {
return false;
}
} else {
return true;
}
break;
}
})()){
var G__73021 = (i + (1));
i = G__73021;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});})(G__69519_73008,G__69520_73009))
;
goog.object.set(G__69519_73008,G__69520_73009,G__69521_73010);

var G__69526_73023 = clojure.core.matrix.protocols.zero_matrix_QMARK_;
var G__69527_73024 = "object";
var G__69528_73025 = ((function (G__69526_73023,G__69527_73024){
return (function (m){
return cljs.core.every_QMARK_(((function (G__69526_73023,G__69527_73024){
return (function (p1__69518_SHARP_){
return ((typeof p1__69518_SHARP_ === 'number') && ((p1__69518_SHARP_ === (0))));
});})(G__69526_73023,G__69527_73024))
,clojure.core.matrix.protocols.element_seq(m));
});})(G__69526_73023,G__69527_73024))
;
goog.object.set(G__69526_73023,G__69527_73024,G__69528_73025);

var G__69529_73027 = clojure.core.matrix.protocols.symmetric_QMARK_;
var G__69530_73028 = "object";
var G__69531_73029 = ((function (G__69529_73027,G__69530_73028){
return (function (m){
var G__69532 = cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m));
switch (G__69532) {
case (0):
return true;

break;
case (1):
return true;

break;
case (2):
var and__4120__auto__ = clojure.core.matrix.impl.common.square_QMARK_(m);
if(and__4120__auto__){
return clojure.core.matrix.impl.common.symmetric_matrix_entries_QMARK_(m);
} else {
return and__4120__auto__;
}

break;
default:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.protocols.transpose(m));

}
});})(G__69529_73027,G__69530_73028))
;
goog.object.set(G__69529_73027,G__69530_73028,G__69531_73029);

goog.object.set(clojure.core.matrix.protocols.PMatrixPredicates,"null",true);

var G__69534_73033 = clojure.core.matrix.protocols.identity_matrix_QMARK_;
var G__69535_73034 = "null";
var G__69536_73035 = ((function (G__69534_73033,G__69535_73034){
return (function (m){
return false;
});})(G__69534_73033,G__69535_73034))
;
goog.object.set(G__69534_73033,G__69535_73034,G__69536_73035);

var G__69540_73038 = clojure.core.matrix.protocols.zero_matrix_QMARK_;
var G__69541_73039 = "null";
var G__69542_73040 = ((function (G__69540_73038,G__69541_73039){
return (function (m){
return false;
});})(G__69540_73038,G__69541_73039))
;
goog.object.set(G__69540_73038,G__69541_73039,G__69542_73040);

var G__69547_73045 = clojure.core.matrix.protocols.symmetric_QMARK_;
var G__69548_73046 = "null";
var G__69549_73047 = ((function (G__69547_73045,G__69548_73046){
return (function (m){
return true;
});})(G__69547_73045,G__69548_73046))
;
goog.object.set(G__69547_73045,G__69548_73046,G__69549_73047);
goog.object.set(clojure.core.matrix.protocols.PIndicesAccess,"object",true);

var G__69553_73049 = clojure.core.matrix.protocols.get_indices;
var G__69554_73050 = "object";
var G__69555_73051 = ((function (G__69553_73049,G__69554_73050){
return (function (a,indices){
var vals = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__69553_73049,G__69554_73050){
return (function (p1__69551_SHARP_){
return clojure.core.matrix.protocols.get_nd(a,p1__69551_SHARP_);
});})(G__69553_73049,G__69554_73050))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.element_seq,indices));
var or__4131__auto__ = ((cljs.core.not(clojure.core.matrix.protocols.is_scalar_QMARK_(a)))?clojure.core.matrix.protocols.construct_matrix(a,vals):null);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return clojure.core.matrix.protocols.construct_matrix(cljs.core.PersistentVector.EMPTY,vals);
}
});})(G__69553_73049,G__69554_73050))
;
goog.object.set(G__69553_73049,G__69554_73050,G__69555_73051);
goog.object.set(clojure.core.matrix.protocols.PIndicesSetting,"object",true);

var G__69556_73062 = clojure.core.matrix.protocols.set_indices;
var G__69557_73063 = "object";
var G__69558_73064 = ((function (G__69556_73062,G__69557_73063){
return (function (a,indices,values){
var indices__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.element_seq,indices);
var values__$1 = clojure.core.matrix.protocols.element_seq(clojure.core.matrix.protocols.broadcast(values,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.count(indices__$1)], null)));
var a__$1 = a;
var G__69565 = indices__$1;
var vec__69567 = G__69565;
var seq__69568 = cljs.core.seq(vec__69567);
var first__69569 = cljs.core.first(seq__69568);
var seq__69568__$1 = cljs.core.next(seq__69568);
var id = first__69569;
var idx = seq__69568__$1;
var G__69566 = values__$1;
var vec__69570 = G__69566;
var seq__69571 = cljs.core.seq(vec__69570);
var first__69572 = cljs.core.first(seq__69571);
var seq__69571__$1 = cljs.core.next(seq__69571);
var v = first__69572;
var vs = seq__69571__$1;
var a__$2 = a__$1;
var G__69565__$1 = G__69565;
var G__69566__$1 = G__69566;
while(true){
var a__$3 = a__$2;
var vec__69583 = G__69565__$1;
var seq__69584 = cljs.core.seq(vec__69583);
var first__69585 = cljs.core.first(seq__69584);
var seq__69584__$1 = cljs.core.next(seq__69584);
var id__$1 = first__69585;
var idx__$1 = seq__69584__$1;
var vec__69586 = G__69566__$1;
var seq__69587 = cljs.core.seq(vec__69586);
var first__69588 = cljs.core.first(seq__69587);
var seq__69587__$1 = cljs.core.next(seq__69587);
var v__$1 = first__69588;
var vs__$1 = seq__69587__$1;
if(cljs.core.truth_(id__$1)){
var G__73075 = clojure.core.matrix.protocols.set_nd(a__$3,id__$1,v__$1);
var G__73076 = idx__$1;
var G__73077 = vs__$1;
a__$2 = G__73075;
G__69565__$1 = G__73076;
G__69566__$1 = G__73077;
continue;
} else {
return a__$3;
}
break;
}
});})(G__69556_73062,G__69557_73063))
;
goog.object.set(G__69556_73062,G__69557_73063,G__69558_73064);

var G__69593_73082 = clojure.core.matrix.protocols.set_indices_BANG_;
var G__69594_73083 = "object";
var G__69595_73084 = ((function (G__69593_73082,G__69594_73083){
return (function (a,indices,values){
var indices__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.core.matrix.protocols.element_seq,indices);
var values__$1 = clojure.core.matrix.protocols.element_seq(clojure.core.matrix.protocols.broadcast(values,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.count(indices__$1)], null)));
var G__69602 = indices__$1;
var vec__69604 = G__69602;
var seq__69605 = cljs.core.seq(vec__69604);
var first__69606 = cljs.core.first(seq__69605);
var seq__69605__$1 = cljs.core.next(seq__69605);
var id = first__69606;
var idx = seq__69605__$1;
var G__69603 = values__$1;
var vec__69607 = G__69603;
var seq__69608 = cljs.core.seq(vec__69607);
var first__69609 = cljs.core.first(seq__69608);
var seq__69608__$1 = cljs.core.next(seq__69608);
var v = first__69609;
var vs = seq__69608__$1;
var G__69602__$1 = G__69602;
var G__69603__$1 = G__69603;
while(true){
var vec__69616 = G__69602__$1;
var seq__69617 = cljs.core.seq(vec__69616);
var first__69618 = cljs.core.first(seq__69617);
var seq__69617__$1 = cljs.core.next(seq__69617);
var id__$1 = first__69618;
var idx__$1 = seq__69617__$1;
var vec__69619 = G__69603__$1;
var seq__69620 = cljs.core.seq(vec__69619);
var first__69621 = cljs.core.first(seq__69620);
var seq__69620__$1 = cljs.core.next(seq__69620);
var v__$1 = first__69621;
var vs__$1 = seq__69620__$1;
if(cljs.core.truth_(id__$1)){
clojure.core.matrix.protocols.set_nd_BANG_(a,id__$1,v__$1);

var G__73090 = idx__$1;
var G__73091 = vs__$1;
G__69602__$1 = G__73090;
G__69603__$1 = G__73091;
continue;
} else {
return null;
}
break;
}
});})(G__69593_73082,G__69594_73083))
;
goog.object.set(G__69593_73082,G__69594_73083,G__69595_73084);
goog.object.set(clojure.core.matrix.protocols.PNonZeroIndices,"object",true);

var G__69623_73092 = clojure.core.matrix.protocols.non_zero_indices;
var G__69624_73093 = "object";
var G__69625_73094 = ((function (G__69623_73092,G__69624_73093){
return (function (m){
if(cljs.core.truth_(clojure.core.matrix.protocols.is_vector_QMARK_(m))){
return cljs.core.vec((function (){var iter__4523__auto__ = ((function (G__69623_73092,G__69624_73093){
return (function clojure$core$matrix$impl$defaults$iter__69631(s__69632){
return (new cljs.core.LazySeq(null,((function (G__69623_73092,G__69624_73093){
return (function (){
var s__69632__$1 = s__69632;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__69632__$1);
if(temp__5818__auto__){
var s__69632__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__69632__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__69632__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__69634 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__69633 = (0);
while(true){
if((i__69633 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__69633);
if((!((clojure.core.matrix.protocols.get_1d(m,i) === (0))))){
cljs.core.chunk_append(b__69634,i);

var G__73099 = (i__69633 + (1));
i__69633 = G__73099;
continue;
} else {
var G__73100 = (i__69633 + (1));
i__69633 = G__73100;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__69634),clojure$core$matrix$impl$defaults$iter__69631(cljs.core.chunk_rest(s__69632__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__69634),null);
}
} else {
var i = cljs.core.first(s__69632__$2);
if((!((clojure.core.matrix.protocols.get_1d(m,i) === (0))))){
return cljs.core.cons(i,clojure$core$matrix$impl$defaults$iter__69631(cljs.core.rest(s__69632__$2)));
} else {
var G__73101 = cljs.core.rest(s__69632__$2);
s__69632__$1 = G__73101;
continue;
}
}
} else {
return null;
}
break;
}
});})(G__69623_73092,G__69624_73093))
,null,null));
});})(G__69623_73092,G__69624_73093))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(m,(0))));
})());
} else {
return cljs.core.vec((function (){var iter__4523__auto__ = ((function (G__69623_73092,G__69624_73093){
return (function clojure$core$matrix$impl$defaults$iter__69641(s__69642){
return (new cljs.core.LazySeq(null,((function (G__69623_73092,G__69624_73093){
return (function (){
var s__69642__$1 = s__69642;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__69642__$1);
if(temp__5818__auto__){
var s__69642__$2 = temp__5818__auto__;
if(cljs.core.chunked_seq_QMARK_(s__69642__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__69642__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__69644 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__69643 = (0);
while(true){
if((i__69643 < size__4522__auto__)){
var i = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__69643);
cljs.core.chunk_append(b__69644,clojure.core.matrix.protocols.non_zero_indices(clojure.core.matrix.protocols.get_major_slice(m,i)));

var G__73113 = (i__69643 + (1));
i__69643 = G__73113;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__69644),clojure$core$matrix$impl$defaults$iter__69641(cljs.core.chunk_rest(s__69642__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__69644),null);
}
} else {
var i = cljs.core.first(s__69642__$2);
return cljs.core.cons(clojure.core.matrix.protocols.non_zero_indices(clojure.core.matrix.protocols.get_major_slice(m,i)),clojure$core$matrix$impl$defaults$iter__69641(cljs.core.rest(s__69642__$2)));
}
} else {
return null;
}
break;
}
});})(G__69623_73092,G__69624_73093))
,null,null));
});})(G__69623_73092,G__69624_73093))
;
return iter__4523__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.dimension_count(m,(0))));
})());
}
});})(G__69623_73092,G__69624_73093))
;
goog.object.set(G__69623_73092,G__69624_73093,G__69625_73094);
goog.object.set(clojure.core.matrix.protocols.PMatrixTypes,"object",true);

var G__69650_73119 = clojure.core.matrix.protocols.diagonal_QMARK_;
var G__69651_73120 = "object";
var G__69652_73121 = ((function (G__69650_73119,G__69651_73120){
return (function (m){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)),(2))){
var vec__69653 = clojure.core.matrix.protocols.get_shape(m);
var mrows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69653,(0),null);
var mcols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69653,(1),null);
return cljs.core.every_QMARK_(((function (vec__69653,mrows,mcols,G__69650_73119,G__69651_73120){
return (function (p__69656){
var vec__69657 = p__69656;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69657,(0),null);
var j = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69657,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69657,(2),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,j)){
return true;
} else {
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(i,j)) && ((v === (0))))){
return true;
} else {
return false;

}
}
});})(vec__69653,mrows,mcols,G__69650_73119,G__69651_73120))
,cljs.core.map.cljs$core$IFn$_invoke$arity$3(((function (vec__69653,mrows,mcols,G__69650_73119,G__69651_73120){
return (function (i,elem){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.quot(i,mcols),cljs.core.rem(i,mcols),elem],null));
});})(vec__69653,mrows,mcols,G__69650_73119,G__69651_73120))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1((mrows * mcols)),clojure.core.matrix.protocols.element_seq(m)));
} else {
return false;
}
});})(G__69650_73119,G__69651_73120))
;
goog.object.set(G__69650_73119,G__69651_73120,G__69652_73121);

var G__69661_73132 = clojure.core.matrix.protocols.upper_triangular_QMARK_;
var G__69662_73133 = "object";
var G__69663_73134 = ((function (G__69661_73132,G__69662_73133){
return (function (m){
if(clojure.core.matrix.impl.common.square_QMARK_(m)){
return cljs.core.every_QMARK_(cljs.core.zero_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(((function (G__69661_73132,G__69662_73133){
return (function (p__69671){
var vec__69673 = p__69671;
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69673,(0),null);
var xs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69673,(1),null);
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(idx,xs);
});})(G__69661_73132,G__69662_73133))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$0(),clojure.core.matrix.protocols.get_slice_seq(m,(0)))], 0)));
} else {
return false;
}
});})(G__69661_73132,G__69662_73133))
;
goog.object.set(G__69661_73132,G__69662_73133,G__69663_73134);

var G__69676_73136 = clojure.core.matrix.protocols.lower_triangular_QMARK_;
var G__69677_73137 = "object";
var G__69678_73138 = ((function (G__69676_73136,G__69677_73137){
return (function (m){
if(clojure.core.matrix.impl.common.square_QMARK_(m)){
return cljs.core.every_QMARK_(cljs.core.zero_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(((function (G__69676_73136,G__69677_73137){
return (function (p__69680){
var vec__69681 = p__69680;
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69681,(0),null);
var xs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69681,(1),null);
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((idx + (1)),xs);
});})(G__69676_73136,G__69677_73137))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$0(),clojure.core.matrix.protocols.get_slice_seq(m,(0)))], 0)));
} else {
return false;
}
});})(G__69676_73136,G__69677_73137))
;
goog.object.set(G__69676_73136,G__69677_73137,G__69678_73138);

var G__69684_73140 = clojure.core.matrix.protocols.positive_definite_QMARK_;
var G__69686_73141 = "object";
var G__69687_73142 = ((function (G__69684_73140,G__69686_73141){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("TODO: Not yet implemented",cljs.core.PersistentArrayMap.EMPTY);

return clojure.core.matrix.protocols.positive_definite_QMARK_(clojure.core.matrix.protocols.convert_to_nested_vectors(m));
});})(G__69684_73140,G__69686_73141))
;
goog.object.set(G__69684_73140,G__69686_73141,G__69687_73142);

var G__69688_73144 = clojure.core.matrix.protocols.positive_semidefinite_QMARK_;
var G__69689_73145 = "object";
var G__69690_73146 = ((function (G__69688_73144,G__69689_73145){
return (function (m){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("TODO: Not yet implemented",cljs.core.PersistentArrayMap.EMPTY);
});})(G__69688_73144,G__69689_73145))
;
goog.object.set(G__69688_73144,G__69689_73145,G__69690_73146);

var G__69692_73148 = clojure.core.matrix.protocols.orthogonal_QMARK_;
var G__69693_73149 = "object";
var G__69694_73150 = ((function (G__69692_73148,G__69693_73149){
return (function (m,eps){
var and__4120__auto__ = clojure.core.matrix.impl.common.square_QMARK_(m);
if(and__4120__auto__){
return clojure.core.matrix.protocols.matrix_equals_epsilon(clojure.core.matrix.protocols.matrix_multiply(m,clojure.core.matrix.protocols.transpose(m)),clojure.core.matrix.protocols.identity_matrix(m,clojure.core.matrix.protocols.dimension_count(m,(0))),eps);
} else {
return and__4120__auto__;
}
});})(G__69692_73148,G__69693_73149))
;
goog.object.set(G__69692_73148,G__69693_73149,G__69694_73150);
goog.object.set(clojure.core.matrix.protocols.PSelect,"null",true);

var G__69698_73155 = clojure.core.matrix.protocols.select;
var G__69699_73156 = "null";
var G__69700_73157 = ((function (G__69698_73155,G__69699_73156){
return (function (a,area){
if(cljs.core.seq(area)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Trying to select on nil with selection: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(area)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return null;
});})(G__69698_73155,G__69699_73156))
;
goog.object.set(G__69698_73155,G__69699_73156,G__69700_73157);

goog.object.set(clojure.core.matrix.protocols.PSelect,"number",true);

var G__69706_73158 = clojure.core.matrix.protocols.select;
var G__69707_73159 = "number";
var G__69708_73160 = ((function (G__69706_73158,G__69707_73159){
return (function (a,area){
if(cljs.core.seq(area)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Trying to select on numerical scalar with selection: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(area)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return a;
});})(G__69706_73158,G__69707_73159))
;
goog.object.set(G__69706_73158,G__69707_73159,G__69708_73160);

goog.object.set(clojure.core.matrix.protocols.PSelect,"object",true);

var G__69709_73161 = clojure.core.matrix.protocols.select;
var G__69710_73162 = "object";
var G__69711_73163 = ((function (G__69709_73161,G__69710_73162){
return (function (a,area){
var or__4131__auto__ = clojure.core.matrix.protocols.select_view(a,area);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return clojure.core.matrix.impl.wrappers.wrap_selection(a,area);
}
});})(G__69709_73161,G__69710_73162))
;
goog.object.set(G__69709_73161,G__69710_73162,G__69711_73163);
goog.object.set(clojure.core.matrix.protocols.PSelectView,"null",true);

var G__69713_73164 = clojure.core.matrix.protocols.select_view;
var G__69714_73165 = "null";
var G__69715_73166 = ((function (G__69713_73164,G__69714_73165){
return (function (a,area){
if(cljs.core.seq(area)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Trying to select on nil with selection: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(area)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return null;
});})(G__69713_73164,G__69714_73165))
;
goog.object.set(G__69713_73164,G__69714_73165,G__69715_73166);

goog.object.set(clojure.core.matrix.protocols.PSelectView,"object",true);

var G__69716_73167 = clojure.core.matrix.protocols.select_view;
var G__69717_73168 = "object";
var G__69718_73169 = ((function (G__69716_73167,G__69717_73168){
return (function (a,area){
return clojure.core.matrix.impl.wrappers.wrap_selection(a,area);
});})(G__69716_73167,G__69717_73168))
;
goog.object.set(G__69716_73167,G__69717_73168,G__69718_73169);

goog.object.set(clojure.core.matrix.protocols.PSelectView,"number",true);

var G__69719_73170 = clojure.core.matrix.protocols.select_view;
var G__69720_73171 = "number";
var G__69721_73172 = ((function (G__69719_73170,G__69720_73171){
return (function (a,area){
if(cljs.core.seq(area)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Trying to select on numerical scalar with selection: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(area)].join(''),cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return a;
});})(G__69719_73170,G__69720_73171))
;
goog.object.set(G__69719_73170,G__69720_73171,G__69721_73172);
goog.object.set(clojure.core.matrix.protocols.PSelect,"number",true);

var G__69727_73173 = clojure.core.matrix.protocols.select;
var G__69728_73174 = "number";
var G__69729_73175 = ((function (G__69727_73173,G__69728_73174){
return (function (a,area){
if(cljs.core.empty_QMARK_(area)){
return a;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Non empty area argument in select, called on Number ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(a)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__69727_73173,G__69728_73174))
;
goog.object.set(G__69727_73173,G__69728_73174,G__69729_73175);
clojure.core.matrix.impl.defaults.area_indices = (function clojure$core$matrix$impl$defaults$area_indices(area){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (io,in$){
var iter__4523__auto__ = (function clojure$core$matrix$impl$defaults$area_indices_$_iter__69731(s__69732){
return (new cljs.core.LazySeq(null,(function (){
var s__69732__$1 = s__69732;
while(true){
var temp__5818__auto__ = cljs.core.seq(s__69732__$1);
if(temp__5818__auto__){
var xs__6376__auto__ = temp__5818__auto__;
var a = cljs.core.first(xs__6376__auto__);
var iterys__4519__auto__ = ((function (s__69732__$1,a,xs__6376__auto__,temp__5818__auto__){
return (function clojure$core$matrix$impl$defaults$area_indices_$_iter__69731_$_iter__69733(s__69734){
return (new cljs.core.LazySeq(null,((function (s__69732__$1,a,xs__6376__auto__,temp__5818__auto__){
return (function (){
var s__69734__$1 = s__69734;
while(true){
var temp__5818__auto____$1 = cljs.core.seq(s__69734__$1);
if(temp__5818__auto____$1){
var s__69734__$2 = temp__5818__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__69734__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__69734__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__69736 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__69735 = (0);
while(true){
if((i__69735 < size__4522__auto__)){
var b = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__69735);
cljs.core.chunk_append(b__69736,cljs.core.cons(a,b));

var G__73188 = (i__69735 + (1));
i__69735 = G__73188;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__69736),clojure$core$matrix$impl$defaults$area_indices_$_iter__69731_$_iter__69733(cljs.core.chunk_rest(s__69734__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__69736),null);
}
} else {
var b = cljs.core.first(s__69734__$2);
return cljs.core.cons(cljs.core.cons(a,b),clojure$core$matrix$impl$defaults$area_indices_$_iter__69731_$_iter__69733(cljs.core.rest(s__69734__$2)));
}
} else {
return null;
}
break;
}
});})(s__69732__$1,a,xs__6376__auto__,temp__5818__auto__))
,null,null));
});})(s__69732__$1,a,xs__6376__auto__,temp__5818__auto__))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(io));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,clojure$core$matrix$impl$defaults$area_indices_$_iter__69731(cljs.core.rest(s__69732__$1)));
} else {
var G__73191 = cljs.core.rest(s__69732__$1);
s__69732__$1 = G__73191;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4523__auto__(in$);
}),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.last(area)),cljs.core.rest(cljs.core.reverse(area)));
});
clojure.core.matrix.impl.defaults.indices = (function clojure$core$matrix$impl$defaults$indices(vals){
return clojure.core.matrix.impl.defaults.area_indices(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.range,clojure.core.matrix.protocols.get_shape(vals)));
});
goog.object.set(clojure.core.matrix.protocols.PSetSelection,"object",true);

var G__69744_73192 = clojure.core.matrix.protocols.set_selection;
var G__69745_73193 = "object";
var G__69746_73194 = ((function (G__69744_73192,G__69745_73193){
return (function (m,area,vals){
var mm = (function (){var or__4131__auto__ = clojure.core.matrix.protocols.mutable_matrix(m);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return clojure.core.matrix.impl.defaults.construct_mutable_matrix(m);
}
})();
var v = clojure.core.matrix.protocols.select_view(m,area);
clojure.core.matrix.protocols.assign_BANG_(v,vals);

return mm;
});})(G__69744_73192,G__69745_73193))
;
goog.object.set(G__69744_73192,G__69745_73193,G__69746_73194);
goog.object.set(clojure.core.matrix.protocols.PIndexImplementation,"object",true);

var G__69751_73196 = clojure.core.matrix.protocols.index_QMARK_;
var G__69752_73197 = "object";
var G__69753_73198 = ((function (G__69751_73196,G__69752_73197){
return (function (m){
return false;
});})(G__69751_73196,G__69752_73197))
;
goog.object.set(G__69751_73196,G__69752_73197,G__69753_73198);

var G__69754_73199 = clojure.core.matrix.protocols.index_to_longs;
var G__69755_73200 = "object";
var G__69756_73201 = ((function (G__69754_73199,G__69755_73200){
return (function (m){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.element_seq(m));
});})(G__69754_73199,G__69755_73200))
;
goog.object.set(G__69754_73199,G__69755_73200,G__69756_73201);

var G__69757_73205 = clojure.core.matrix.protocols.index_to_ints;
var G__69758_73206 = "object";
var G__69759_73207 = ((function (G__69757_73205,G__69758_73206){
return (function (m){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(clojure.core.matrix.protocols.element_seq(m));
});})(G__69757_73205,G__69758_73206))
;
goog.object.set(G__69757_73205,G__69758_73206,G__69759_73207);

var G__69760_73210 = clojure.core.matrix.protocols.index_from_longs;
var G__69761_73211 = "object";
var G__69762_73212 = ((function (G__69760_73210,G__69761_73211){
return (function (m,xs){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(xs);
});})(G__69760_73210,G__69761_73211))
;
goog.object.set(G__69760_73210,G__69761_73211,G__69762_73212);

var G__69763_73215 = clojure.core.matrix.protocols.index_from_ints;
var G__69764_73216 = "object";
var G__69765_73217 = ((function (G__69763_73215,G__69764_73216){
return (function (m,xs){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(xs);
});})(G__69763_73215,G__69764_73216))
;
goog.object.set(G__69763_73215,G__69764_73216,G__69765_73217);

var G__69766_73220 = clojure.core.matrix.protocols.index_coerce;
var G__69767_73221 = "object";
var G__69768_73222 = ((function (G__69766_73220,G__69767_73221){
return (function (m,a){
return clojure.core.matrix.protocols.index_to_longs(m);
});})(G__69766_73220,G__69767_73221))
;
goog.object.set(G__69766_73220,G__69767_73221,G__69768_73222);
goog.object.set(clojure.core.matrix.protocols.PDimensionLabels,"object",true);

var G__69769_73225 = clojure.core.matrix.protocols.label;
var G__69770_73226 = "object";
var G__69771_73227 = ((function (G__69769_73225,G__69770_73226){
return (function (m,dim,i){
if(((((0) <= cljs.core.long$(i))) && ((cljs.core.long$(i) <= (cljs.core.long$(clojure.core.matrix.protocols.dimension_count(m,dim)) - (1)))))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Dimension index out of range: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__69769_73225,G__69770_73226))
;
goog.object.set(G__69769_73225,G__69770_73226,G__69771_73227);

var G__69776_73229 = clojure.core.matrix.protocols.labels;
var G__69777_73230 = "object";
var G__69778_73231 = ((function (G__69776_73229,G__69777_73230){
return (function (m,dim){
if(((((0) <= cljs.core.long$(dim))) && ((cljs.core.long$(dim) <= (cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)) - (1)))))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Dimension out of range: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dim)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}
});})(G__69776_73229,G__69777_73230))
;
goog.object.set(G__69776_73229,G__69777_73230,G__69778_73231);
goog.object.set(clojure.core.matrix.protocols.PColumnNames,"object",true);

var G__69784_73233 = clojure.core.matrix.protocols.column_name;
var G__69785_73234 = "object";
var G__69786_73235 = ((function (G__69784_73233,G__69785_73234){
return (function (m,i){
var dim = (cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)) - (1));
return clojure.core.matrix.protocols.label(m,dim,i);
});})(G__69784_73233,G__69785_73234))
;
goog.object.set(G__69784_73233,G__69785_73234,G__69786_73235);

var G__69787_73236 = clojure.core.matrix.protocols.column_names;
var G__69788_73237 = "object";
var G__69789_73238 = ((function (G__69787_73236,G__69788_73237){
return (function (m){
var dim = (cljs.core.long$(clojure.core.matrix.protocols.dimensionality(m)) - (1));
return clojure.core.matrix.protocols.labels(m,dim);
});})(G__69787_73236,G__69788_73237))
;
goog.object.set(G__69787_73236,G__69788_73237,G__69789_73238);
goog.object.set(clojure.core.matrix.protocols.PNorm,"object",true);

var G__69791_73239 = clojure.core.matrix.protocols.norm;
var G__69792_73240 = "object";
var G__69793_73241 = ((function (G__69791_73239,G__69792_73240){
return (function (m,p){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p,Number.POSITIVE_INFINITY)){
return clojure.core.matrix.protocols.element_max(clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.mathsops.abs));
} else {
if(typeof p === 'number'){
var sum_of_element_powers = clojure.core.matrix.protocols.element_sum(clojure.core.matrix.protocols.element_pow(clojure.core.matrix.protocols.element_map.cljs$core$IFn$_invoke$arity$2(m,clojure.core.matrix.impl.mathsops.abs),p));
var pred__69798 = cljs.core._EQ__EQ_;
var expr__69799 = p;
if(cljs.core.truth_((pred__69798.cljs$core$IFn$_invoke$arity$2 ? pred__69798.cljs$core$IFn$_invoke$arity$2((1),expr__69799) : pred__69798.call(null,(1),expr__69799)))){
return sum_of_element_powers;
} else {
if(cljs.core.truth_((pred__69798.cljs$core$IFn$_invoke$arity$2 ? pred__69798.cljs$core$IFn$_invoke$arity$2((2),expr__69799) : pred__69798.call(null,(2),expr__69799)))){
return Math.sqrt(sum_of_element_powers);
} else {
if(cljs.core.truth_((pred__69798.cljs$core$IFn$_invoke$arity$2 ? pred__69798.cljs$core$IFn$_invoke$arity$2((3),expr__69799) : pred__69798.call(null,(3),expr__69799)))){
return Math.cbrt(sum_of_element_powers);
} else {
var G__69804 = sum_of_element_powers;
var G__69805 = (1.0 / p);
return Math.pow(G__69804,G__69805);
}
}
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("p must be a number",cljs.core.PersistentArrayMap.EMPTY);

}
}
});})(G__69791_73239,G__69792_73240))
;
goog.object.set(G__69791_73239,G__69792_73240,G__69793_73241);
clojure.core.matrix.impl.defaults.compute_q = (function clojure$core$matrix$impl$defaults$compute_q(m,qr_data,mcols,mrows,min_len,us,vs,gammas){
var q = clojure.core.matrix.protocols.to_double_array(clojure.core.matrix.protocols.identity_matrix(cljs.core.PersistentVector.EMPTY,mrows));
var mcols__$1 = cljs.core.long$(mcols);
var mrows__$1 = cljs.core.long$(mrows);
var min_len__$1 = cljs.core.long$(min_len);
var i_73246 = (min_len__$1 - (1));
while(true){
if((i_73246 > (-1))){
var gamma_73247 = (gammas[i_73246]);
(us[i_73246] = 1.0);

var j_73248 = (i_73246 + (1));
while(true){
if((j_73248 < mrows__$1)){
(us[j_73248] = (qr_data[((j_73248 * mcols__$1) + i_73246)]));

var G__73251 = (j_73248 + (1));
j_73248 = G__73251;
continue;
} else {
}
break;
}


var j_73252 = i_73246;
while(true){
if((j_73252 < mrows__$1)){
(vs[j_73252] = ((us[i_73246]) * (q[((i_73246 * mrows__$1) + j_73252)])));

var G__73257 = (j_73252 + (1));
j_73252 = G__73257;
continue;
} else {
}
break;
}


var j_73259 = (i_73246 + (1));
while(true){
if((j_73259 < mrows__$1)){
var u_73261 = (us[j_73259]);
var k_73262 = i_73246;
while(true){
if((k_73262 < mrows__$1)){
var q_idx_73264 = (((j_73259 * mrows__$1) + i_73246) + (k_73262 - i_73246));
(vs[k_73262] = ((vs[k_73262]) + (u_73261 * (q[q_idx_73264]))));

var G__73269 = (k_73262 + (1));
k_73262 = G__73269;
continue;
} else {
}
break;
}


var G__73271 = (j_73259 + (1));
j_73259 = G__73271;
continue;
} else {
}
break;
}


var j_73273 = i_73246;
while(true){
if((j_73273 < mrows__$1)){
(vs[j_73273] = ((vs[j_73273]) * gamma_73247));

var G__73278 = (j_73273 + (1));
j_73273 = G__73278;
continue;
} else {
}
break;
}


var j_73279 = i_73246;
while(true){
if((j_73279 < mrows__$1)){
var u_73280 = (us[j_73279]);
var k_73281 = i_73246;
while(true){
if((k_73281 < mrows__$1)){
var qr_idx_73282 = (((j_73279 * mrows__$1) + i_73246) + (k_73281 - i_73246));
(q[qr_idx_73282] = ((q[qr_idx_73282]) - (u_73280 * (vs[k_73281]))));

var G__73283 = (k_73281 + (1));
k_73281 = G__73283;
continue;
} else {
}
break;
}


var G__73284 = (j_73279 + (1));
j_73279 = G__73284;
continue;
} else {
}
break;
}


var G__73285 = (i_73246 - (1));
i_73246 = G__73285;
continue;
} else {
}
break;
}


return clojure.core.matrix.protocols.compute_matrix(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mrows__$1,mrows__$1], null),((function (q,mcols__$1,mrows__$1,min_len__$1){
return (function (i,j){
return (q[((i * mrows__$1) + j)]);
});})(q,mcols__$1,mrows__$1,min_len__$1))
);
});
clojure.core.matrix.impl.defaults.compute_r = (function clojure$core$matrix$impl$defaults$compute_r(m,data,mcols,mrows,min_len,compact_QMARK_){
var mrows__$1 = cljs.core.long$(mrows);
var mcols__$1 = cljs.core.long$(mcols);
var min_len__$1 = cljs.core.long$(min_len);
var cm = clojure.core.matrix.protocols.compute_matrix(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mrows__$1,mcols__$1], null),((function (mrows__$1,mcols__$1,min_len__$1){
return (function (i,j){
if((((i < min_len__$1)) && ((j >= i)) && ((j < mcols__$1)))){
return (data[((i * mcols__$1) + j)]);
} else {
return (0);
}
});})(mrows__$1,mcols__$1,min_len__$1))
);
if(cljs.core.truth_(compact_QMARK_)){
var slcs = clojure.core.matrix.protocols.get_major_slice_seq(cm);
var non_zero_rows = cljs.core.long$(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (slcs,mrows__$1,mcols__$1,min_len__$1,cm){
return (function (cnt,slice){
if(cljs.core.every_QMARK_(cljs.core.zero_QMARK_,slice)){
return (cnt + (1));
} else {
return cnt;
}
});})(slcs,mrows__$1,mcols__$1,min_len__$1,cm))
,(0),slcs));
return clojure.core.matrix.protocols.reshape(cm,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [mcols__$1,(mrows__$1 - non_zero_rows)], null));
} else {
return cm;
}
});
clojure.core.matrix.impl.defaults.householder_qr = (function clojure$core$matrix$impl$defaults$householder_qr(qr_data,idx,mcols,mrows,us,gammas){
var idx__$1 = cljs.core.long$(idx);
var mcols__$1 = cljs.core.long$(mcols);
var mrows__$1 = cljs.core.long$(mrows);
var qr_idx_73287 = cljs.core.long$((idx__$1 + (idx__$1 * mcols__$1)));
var i_73288 = cljs.core.long$(idx__$1);
while(true){
if((i_73288 < mrows__$1)){
(us[i_73288] = (qr_data[qr_idx_73287]));

var G__73289 = (qr_idx_73287 + mcols__$1);
var G__73290 = (i_73288 + (1));
qr_idx_73287 = G__73289;
i_73288 = G__73290;
continue;
} else {
}
break;
}

var max_ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (idx__$1,mcols__$1,mrows__$1){
return (function (p1__69824_SHARP_){
var G__69828 = p1__69824_SHARP_;
return Math.abs(G__69828);
});})(idx__$1,mcols__$1,mrows__$1))
,clojure.core.matrix.protocols.subvector(us,idx__$1,(mrows__$1 - idx__$1))));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(max_,0.0)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),true], null);
} else {
var _ = (function (){
var i_73292 = idx__$1;
while(true){
if((i_73292 < mrows__$1)){
(us[i_73292] = ((us[i_73292]) / max_));

var G__73293 = (i_73292 + (1));
i_73292 = G__73293;
continue;
} else {
}
break;
}

return null;
})()
;
var tau = (function (){var G__69833 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (_,max_,idx__$1,mcols__$1,mrows__$1){
return (function (acc,x){
return (acc + (x * x));
});})(_,max_,idx__$1,mcols__$1,mrows__$1))
,0.0,clojure.core.matrix.protocols.subvector(us,idx__$1,(mrows__$1 - idx__$1)));
return Math.sqrt(G__69833);
})();
var u_idx = (us[idx__$1]);
var tau__$1 = (((u_idx < (0)))?(- tau):tau);
var u_0 = (u_idx + tau__$1);
var gamma = (u_0 / tau__$1);
var tau__$2 = (tau__$1 * max_);
(gammas[idx__$1] = gamma);

var i_73298 = (idx__$1 + (1));
while(true){
if((i_73298 < mrows__$1)){
(us[i_73298] = ((us[i_73298]) / u_0));

var G__73301 = (i_73298 + (1));
i_73298 = G__73301;
continue;
} else {
}
break;
}


(us[idx__$1] = 1.0);

return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gamma","gamma",1883969687),gamma,new cljs.core.Keyword(null,"gammas","gammas",-195052461),gammas,new cljs.core.Keyword(null,"us","us",746429226),us,new cljs.core.Keyword(null,"tau","tau",89782904),tau__$2,new cljs.core.Keyword(null,"error","error",-978969032),false], null);
}
});
clojure.core.matrix.impl.defaults.update_qr = (function clojure$core$matrix$impl$defaults$update_qr(qr_data,idx,mcols,mrows,vs,us,gamma,tau){
var idx__$1 = cljs.core.long$(idx);
var mrows__$1 = cljs.core.long$(mrows);
var mcols__$1 = cljs.core.long$(mcols);
var u = (us[idx__$1]);
var idx_PLUS_1 = (idx__$1 + (1));
var gamma__$1 = gamma;
var tau__$1 = tau;
var i_73306 = idx_PLUS_1;
while(true){
if((i_73306 < mcols__$1)){
(vs[i_73306] = (qr_data[(i_73306 + (idx__$1 * mcols__$1))]));

var G__73307 = (i_73306 + (1));
i_73306 = G__73307;
continue;
} else {
}
break;
}


var i_73308 = idx_PLUS_1;
while(true){
if((i_73308 < mrows__$1)){
var qr_idx_73309 = (idx_PLUS_1 + (i_73308 * mcols__$1));
var j_73310 = idx_PLUS_1;
while(true){
if((j_73310 < mcols__$1)){
(vs[j_73310] = ((vs[j_73310]) + ((us[i_73308]) * (qr_data[(qr_idx_73309 + (j_73310 - idx_PLUS_1))]))));

var G__73311 = (j_73310 + (1));
j_73310 = G__73311;
continue;
} else {
}
break;
}


var G__73312 = (i_73308 + (1));
i_73308 = G__73312;
continue;
} else {
}
break;
}


var i_73313 = idx_PLUS_1;
while(true){
if((i_73313 < mcols__$1)){
(vs[i_73313] = ((vs[i_73313]) * gamma__$1));

var G__73314 = (i_73313 + (1));
i_73313 = G__73314;
continue;
} else {
}
break;
}


var i_73315 = idx__$1;
while(true){
if((i_73315 < mrows__$1)){
var u_73316__$1 = (us[i_73315]);
var j_73317 = idx_PLUS_1;
while(true){
if((j_73317 < mcols__$1)){
var qr_idx_73318 = (((i_73315 * mcols__$1) + idx_PLUS_1) + (j_73317 - idx_PLUS_1));
(qr_data[qr_idx_73318] = ((qr_data[qr_idx_73318]) - (u_73316__$1 * (vs[j_73317]))));

var G__73319 = (j_73317 + (1));
j_73317 = G__73319;
continue;
} else {
}
break;
}


var G__73320 = (i_73315 + (1));
i_73315 = G__73320;
continue;
} else {
}
break;
}


if((idx__$1 < mcols__$1)){
(qr_data[(idx__$1 + (idx__$1 * mcols__$1))] = (- tau__$1));
} else {
}

var i_73321 = idx_PLUS_1;
while(true){
if((i_73321 < mrows__$1)){
(qr_data[(idx__$1 + (i_73321 * mcols__$1))] = (us[i_73321]));

var G__73322 = (i_73321 + (1));
i_73321 = G__73322;
continue;
} else {
}
break;
}


return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"qr-data","qr-data",-504970292),qr_data,new cljs.core.Keyword(null,"vs","vs",-2022097090),vs], null);
});
goog.object.set(clojure.core.matrix.protocols.PQRDecomposition,"object",true);

var G__69848_73325 = clojure.core.matrix.protocols.qr;
var G__69849_73326 = "object";
var G__69850_73327 = ((function (G__69848_73325,G__69849_73326){
return (function (m,options){
var vec__69855 = clojure.core.matrix.protocols.get_shape(m);
var mrows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69855,(0),null);
var mcols = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69855,(1),null);
var mrows__$1 = cljs.core.long$(mrows);
var mcols__$1 = cljs.core.long$(mcols);
var min_len = (function (){var x__4222__auto__ = mcols__$1;
var y__4223__auto__ = mrows__$1;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})();
var max_len = (function (){var x__4219__auto__ = mcols__$1;
var y__4220__auto__ = mrows__$1;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var qr_data = clojure.core.matrix.protocols.to_double_array(m);
var vs = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(max_len);
var us = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(max_len);
var gammas = cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(min_len);
var gamma = 0.0;
var tau = 0.0;
var i = (0);
while(true){
if((i < min_len)){
var map__69874 = clojure.core.matrix.impl.defaults.householder_qr(qr_data,i,mcols__$1,mrows__$1,us,gammas);
var map__69874__$1 = (((((!((map__69874 == null))))?(((((map__69874.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69874.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__69874):map__69874);
var us__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69874__$1,new cljs.core.Keyword(null,"us","us",746429226));
var gamma__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69874__$1,new cljs.core.Keyword(null,"gamma","gamma",1883969687));
var gammas__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69874__$1,new cljs.core.Keyword(null,"gammas","gammas",-195052461));
var tau__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69874__$1,new cljs.core.Keyword(null,"tau","tau",89782904));
var error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69874__$1,new cljs.core.Keyword(null,"error","error",-978969032));
if(cljs.core.truth_(error)){
return null;
} else {
var map__69876 = clojure.core.matrix.impl.defaults.update_qr(qr_data,i,mcols__$1,mrows__$1,vs,us__$1,gamma__$1,tau__$1);
var map__69876__$1 = (((((!((map__69876 == null))))?(((((map__69876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69876.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__69876):map__69876);
var qr_data__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69876__$1,new cljs.core.Keyword(null,"qr-data","qr-data",-504970292));
var vs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69876__$1,new cljs.core.Keyword(null,"vs","vs",-2022097090));
var G__73349 = qr_data__$1;
var G__73350 = vs__$1;
var G__73351 = us__$1;
var G__73352 = gammas__$1;
var G__73353 = gamma__$1;
var G__73354 = tau__$1;
var G__73355 = (i + (1));
qr_data = G__73349;
vs = G__73350;
us = G__73351;
gammas = G__73352;
gamma = G__73353;
tau = G__73354;
i = G__73355;
continue;
}
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (qr_data,vs,us,gammas,gamma,tau,i,vec__69855,mrows,mcols,mrows__$1,mcols__$1,min_len,max_len,G__69848_73325,G__69849_73326){
return (function (p__69881){
var vec__69882 = p__69881;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69882,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69882,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(v.cljs$core$IFn$_invoke$arity$0 ? v.cljs$core$IFn$_invoke$arity$0() : v.call(null))], null);
});})(qr_data,vs,us,gammas,gamma,tau,i,vec__69855,mrows,mcols,mrows__$1,mcols__$1,min_len,max_len,G__69848_73325,G__69849_73326))
,cljs.core.select_keys(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"Q","Q",663320520),((function (qr_data,vs,us,gammas,gamma,tau,i,vec__69855,mrows,mcols,mrows__$1,mcols__$1,min_len,max_len,G__69848_73325,G__69849_73326){
return (function (){
return clojure.core.matrix.impl.defaults.compute_q(m,qr_data,mcols__$1,mrows__$1,min_len,us,vs,gammas);
});})(qr_data,vs,us,gammas,gamma,tau,i,vec__69855,mrows,mcols,mrows__$1,mcols__$1,min_len,max_len,G__69848_73325,G__69849_73326))
,new cljs.core.Keyword(null,"R","R",-936662523),((function (qr_data,vs,us,gammas,gamma,tau,i,vec__69855,mrows,mcols,mrows__$1,mcols__$1,min_len,max_len,G__69848_73325,G__69849_73326){
return (function (){
return clojure.core.matrix.impl.defaults.compute_r(m,qr_data,mcols__$1,mrows__$1,min_len,new cljs.core.Keyword(null,"compact","compact",-348732150).cljs$core$IFn$_invoke$arity$1(options));
});})(qr_data,vs,us,gammas,gamma,tau,i,vec__69855,mrows,mcols,mrows__$1,mcols__$1,min_len,max_len,G__69848_73325,G__69849_73326))
], null),new cljs.core.Keyword(null,"return","return",-1891502105).cljs$core$IFn$_invoke$arity$1(options))));
}
break;
}
});})(G__69848_73325,G__69849_73326))
;
goog.object.set(G__69848_73325,G__69849_73326,G__69850_73327);
goog.object.set(clojure.core.matrix.protocols.PCholeskyDecomposition,"object",true);

var G__69886_73379 = clojure.core.matrix.protocols.cholesky;
var G__69887_73380 = "object";
var G__69888_73381 = ((function (G__69886_73379,G__69887_73380){
return (function (m,options){
if(cljs.core.truth_(clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_)){
var _STAR_trying_current_implementation_STAR__orig_val__69889 = clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_;
var _STAR_trying_current_implementation_STAR__temp_val__69890 = true;
clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__temp_val__69890;

try{var imp__53981__auto__ = clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$0();
var m__$1 = clojure.core.matrix.protocols.coerce_param(imp__53981__auto__,m);
return clojure.core.matrix.protocols.cholesky(m__$1,options);
}finally {clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__orig_val__69889;
}} else {
return null;
}
});})(G__69886_73379,G__69887_73380))
;
goog.object.set(G__69886_73379,G__69887_73380,G__69888_73381);
goog.object.set(clojure.core.matrix.protocols.PLUDecomposition,"object",true);

var G__69895_73390 = clojure.core.matrix.protocols.lu;
var G__69896_73391 = "object";
var G__69897_73392 = ((function (G__69895_73390,G__69896_73391){
return (function (m,options){
if(cljs.core.truth_(clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_)){
var _STAR_trying_current_implementation_STAR__orig_val__69898 = clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_;
var _STAR_trying_current_implementation_STAR__temp_val__69899 = true;
clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__temp_val__69899;

try{var imp__53981__auto__ = clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$0();
var m__$1 = clojure.core.matrix.protocols.coerce_param(imp__53981__auto__,m);
return clojure.core.matrix.protocols.lu(m__$1,options);
}finally {clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__orig_val__69898;
}} else {
return null;
}
});})(G__69895_73390,G__69896_73391))
;
goog.object.set(G__69895_73390,G__69896_73391,G__69897_73392);
goog.object.set(clojure.core.matrix.protocols.PSVDDecomposition,"object",true);

var G__69902_73407 = clojure.core.matrix.protocols.svd;
var G__69903_73408 = "object";
var G__69904_73409 = ((function (G__69902_73407,G__69903_73408){
return (function (m,options){
if(cljs.core.truth_(clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_)){
var _STAR_trying_current_implementation_STAR__orig_val__69912 = clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_;
var _STAR_trying_current_implementation_STAR__temp_val__69913 = true;
clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__temp_val__69913;

try{var imp__53981__auto__ = clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$0();
var m__$1 = clojure.core.matrix.protocols.coerce_param(imp__53981__auto__,m);
return clojure.core.matrix.protocols.svd(m__$1,options);
}finally {clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__orig_val__69912;
}} else {
return null;
}
});})(G__69902_73407,G__69903_73408))
;
goog.object.set(G__69902_73407,G__69903_73408,G__69904_73409);
goog.object.set(clojure.core.matrix.protocols.PEigenDecomposition,"object",true);

var G__69915_73415 = clojure.core.matrix.protocols.eigen;
var G__69916_73416 = "object";
var G__69917_73417 = ((function (G__69915_73415,G__69916_73416){
return (function (m,options){
if(cljs.core.truth_(clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_)){
var _STAR_trying_current_implementation_STAR__orig_val__69919 = clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_;
var _STAR_trying_current_implementation_STAR__temp_val__69920 = true;
clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__temp_val__69920;

try{var imp__53981__auto__ = clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$0();
var m__$1 = clojure.core.matrix.protocols.coerce_param(imp__53981__auto__,m);
return clojure.core.matrix.protocols.eigen(m__$1,options);
}finally {clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__orig_val__69919;
}} else {
return null;
}
});})(G__69915_73415,G__69916_73416))
;
goog.object.set(G__69915_73415,G__69916_73416,G__69917_73417);
goog.object.set(clojure.core.matrix.protocols.PSolveLinear,"object",true);

var G__69926_73418 = clojure.core.matrix.protocols.solve;
var G__69927_73419 = "object";
var G__69928_73420 = ((function (G__69926_73418,G__69927_73419){
return (function (a,b){
if(cljs.core.truth_(clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_)){
var _STAR_trying_current_implementation_STAR__orig_val__69929 = clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_;
var _STAR_trying_current_implementation_STAR__temp_val__69930 = true;
clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__temp_val__69930;

try{var imp__53981__auto__ = clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$0();
var a__$1 = clojure.core.matrix.protocols.coerce_param(imp__53981__auto__,a);
return clojure.core.matrix.protocols.solve(a__$1,b);
}finally {clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__orig_val__69929;
}} else {
return null;
}
});})(G__69926_73418,G__69927_73419))
;
goog.object.set(G__69926_73418,G__69927_73419,G__69928_73420);
goog.object.set(clojure.core.matrix.protocols.PLeastSquares,"object",true);

var G__69935_73426 = clojure.core.matrix.protocols.least_squares;
var G__69936_73427 = "object";
var G__69937_73428 = ((function (G__69935_73426,G__69936_73427){
return (function (a,b){
if(cljs.core.truth_(clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_)){
var _STAR_trying_current_implementation_STAR__orig_val__69938 = clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_;
var _STAR_trying_current_implementation_STAR__temp_val__69939 = true;
clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__temp_val__69939;

try{var imp__53981__auto__ = clojure.core.matrix.implementations.get_canonical_object.cljs$core$IFn$_invoke$arity$0();
var a__$1 = clojure.core.matrix.protocols.coerce_param(imp__53981__auto__,a);
return clojure.core.matrix.protocols.least_squares(a__$1,b);
}finally {clojure.core.matrix.impl.defaults._STAR_trying_current_implementation_STAR_ = _STAR_trying_current_implementation_STAR__orig_val__69938;
}} else {
return null;
}
});})(G__69935_73426,G__69936_73427))
;
goog.object.set(G__69935_73426,G__69936_73427,G__69937_73428);

//# sourceMappingURL=clojure.core.matrix.impl.defaults.js.map
