goog.provide('clograms.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('clojure.zip');
clograms.utils.replace_in_str = (function clograms$utils$replace_in_str(f,s,from,len){
var before = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),from);
var after = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(from + len));
var being_replaced = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,from,(from + len));
var replaced = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(being_replaced) : f.call(null,being_replaced));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(before),cljs.core.str.cljs$core$IFn$_invoke$arity$1(replaced),cljs.core.str.cljs$core$IFn$_invoke$arity$1(after)].join('');
});
clograms.utils.replace_in_str_line = (function clograms$utils$replace_in_str_line(f,s,l,from,len){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,line){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,l)){
return clograms.utils.replace_in_str(f,line,from,len);
} else {
return line;
}
}),clojure.string.split_lines(s)));
});
/**
 * Returns a zipper for nested sequences, given a root sequence
 */
clograms.utils.code_zipper = (function clograms$utils$code_zipper(root){
return clojure.zip.zipper(cljs.core.coll_QMARK_,cljs.core.seq,(function (node,children){
return cljs.core.with_meta(children,cljs.core.meta(node));
}),root);
});
clograms.utils.move_zipper_to_next = (function clograms$utils$move_zipper_to_next(zloc,pred){
var z = clojure.zip.next(zloc);
while(true){
if(cljs.core.truth_((function (){var or__4131__auto__ = clojure.zip.end_QMARK_(z);
if(or__4131__auto__){
return or__4131__auto__;
} else {
var G__80847 = clojure.zip.node(z);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__80847) : pred.call(null,G__80847));
}
})())){
return z;
} else {
var G__80848 = clojure.zip.next(z);
z = G__80848;
continue;
}
break;
}
});

//# sourceMappingURL=clograms.utils.js.map
