goog.provide('clograms.events');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('clograms.db');
goog.require('clograms.db.components');
goog.require('reagent.dom');
goog.require('day8.re_frame.http_fx');
goog.require('datascript.core');
goog.require('clograms.re_grams.re_grams');
goog.require('zprint.core');
goog.require('clojure.string');
goog.require('cljs.spec.alpha');
goog.require('clograms.spec');
goog.require('expound.alpha');
goog.require('clograms.models');
goog.require('clograms.external');
goog.require('clograms.diagram.selection');
goog.require('clograms.diagram.entities');
goog.require('clograms.diagram.tools');
goog.require('clograms.browser');
goog.require('clograms.menues');
/**
 * Throws an exception if `db` doesn't match the Spec `a-spec`.
 */
clograms.events.check_and_throw = (function clograms$events$check_and_throw(a_spec,db){
if(cljs.spec.alpha.valid_QMARK_.cljs$core$IFn$_invoke$arity$2(a_spec,db)){
return null;
} else {
throw (new Error(["spec check failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expound.alpha.expound_str(a_spec,db))].join('')));
}
});
clograms.events.inter_check = (function (){var G__80634 = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(clograms.events.check_and_throw,new cljs.core.Keyword("clograms.spec","db","clograms.spec/db",920296694));
return (re_frame.core.after.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.after.cljs$core$IFn$_invoke$arity$1(G__80634) : re_frame.core.after.call(null,G__80634));
})();
clograms.events.initialize_db_and_load = (function clograms$events$initialize_db_and_load(){
var port = window.location.port;
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),clograms.db.default_db,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","reload-config","clograms.events/reload-config",447613879),port], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","reload-db","clograms.events/reload-db",2051007942),port], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","load-diagram","clograms.events/load-diagram",-312441236),port], null)], null)], null);
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","initialize-db","clograms.events/initialize-db",-1748376113),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (_,___$1){
return clograms.events.initialize_db_and_load();
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","reload-config","clograms.events/reload-config",447613879),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (cofxs,p__80637){
var vec__80638 = p__80637;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80638,(0),null);
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80638,(1),null);
return clograms.external.reload_config(port);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","reload-db","clograms.events/reload-db",2051007942),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (cofxs,p__80642){
var vec__80643 = p__80642;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80643,(0),null);
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80643,(1),null);
return clograms.external.reload_datascript_db(port);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","new-datoms","clograms.events/new-datoms",1961812881),cljs.core.PersistentVector.EMPTY,(function (db,p__80646){
var vec__80647 = p__80646;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80647,(0),null);
var new_datoms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80647,(1),null);
return clograms.external.new_datascript_db_datoms(db,new_datoms);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","db-loaded","clograms.events/db-loaded",1556484560),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80652){
var vec__80653 = p__80652;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80653,(0),null);
var new_db = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80653,(1),null);
return clograms.external.db_loaded(db,new_db);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","config-loaded","clograms.events/config-loaded",454416280),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (cofxs,p__80658){
var vec__80660 = p__80658;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80660,(0),null);
var config = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80660,(1),null);
return clograms.external.config_loaded(cofxs,config);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","add-entity-to-diagram","clograms.events/add-entity-to-diagram",-666058240),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (p__80664,p__80665){
var map__80667 = p__80664;
var map__80667__$1 = (((((!((map__80667 == null))))?(((((map__80667.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80667.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__80667):map__80667);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80667__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__80668 = p__80665;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80668,(0),null);
var et = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80668,(1),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80668,(2),null);
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80668,(3),null);
return clograms.diagram.entities.add_entity_to_diagram(db,et,id,opts);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","remove-entity-from-diagram","clograms.events/remove-entity-from-diagram",-2000289610),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (p__80675,p__80676){
var map__80677 = p__80675;
var map__80677__$1 = (((((!((map__80677 == null))))?(((((map__80677.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80677.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__80677):map__80677);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80677__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__80678 = p__80676;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80678,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80678,(1),null);
return clograms.diagram.entities.remove_entity_from_diagram(db,id);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.re-grams.re-grams","node-selection-updated","clograms.re-grams.re-grams/node-selection-updated",-72372537),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (p__80682,p__80683){
var map__80684 = p__80682;
var map__80684__$1 = (((((!((map__80684 == null))))?(((((map__80684.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80684.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__80684):map__80684);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80684__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__80685 = p__80683;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80685,(0),null);
var nodes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80685,(1),null);
return clograms.diagram.selection.node_selection_updated(db,nodes);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","set-node-comment","clograms.events/set-node-comment",-1958510706),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80691){
var vec__80693 = p__80691;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80693,(0),null);
var node_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80693,(1),null);
var comment = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80693,(2),null);
return clograms.re_grams.re_grams.set_node_extra_data(db,node_id,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clograms.re_grams.re_grams.node_extra_data(db,node_id),new cljs.core.Keyword(null,"comment","comment",532206069),comment));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","set-node-label","clograms.events/set-node-label",-947779900),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80701){
var vec__80702 = p__80701;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80702,(0),null);
var node_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80702,(1),null);
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80702,(2),null);
return clograms.re_grams.re_grams.set_node_extra_data(db,node_id,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clograms.re_grams.re_grams.node_extra_data(db,node_id),new cljs.core.Keyword(null,"label","label",1718410804),label));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","remove-node-comment","clograms.events/remove-node-comment",-1790593591),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80705){
var vec__80706 = p__80705;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80706,(0),null);
var node_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80706,(1),null);
var comment = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80706,(2),null);
return clograms.re_grams.re_grams.set_node_extra_data(db,node_id,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(clograms.re_grams.re_grams.node_extra_data(db,node_id),new cljs.core.Keyword(null,"comment","comment",532206069)));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","toggle-collapse-node","clograms.events/toggle-collapse-node",867418593),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80709){
var vec__80710 = p__80709;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80710,(0),null);
var node_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80710,(1),null);
return clograms.re_grams.re_grams.set_node_extra_data(db,node_id,cljs.core.update.cljs$core$IFn$_invoke$arity$3(clograms.re_grams.re_grams.node_extra_data(db,node_id),new cljs.core.Keyword(null,"collapsed?","collapsed?",-1661420674),cljs.core.not));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","show-context-menu","clograms.events/show-context-menu",31631706),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80718){
var vec__80720 = p__80718;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80720,(0),null);
var ctx_menu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80720,(1),null);
return clograms.menues.show_context_menu(db,ctx_menu);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","hide-context-menu","clograms.events/hide-context-menu",-423900565),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80723){
var vec__80724 = p__80723;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80724,(0),null);
return clograms.menues.hide_context_menu(db);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","select-color","clograms.events/select-color",1632283148),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80727){
var vec__80728 = p__80727;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80728,(0),null);
var color = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80728,(1),null);
return clograms.diagram.tools.select_color(db,color);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","set-namespace-color","clograms.events/set-namespace-color",682298923),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80731){
var vec__80732 = p__80731;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80732,(0),null);
var ns_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80732,(1),null);
return clograms.diagram.tools.set_namespace_color(db,ns_name);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","set-project-color","clograms.events/set-project-color",-1028847842),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80735){
var vec__80736 = p__80735;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80736,(0),null);
var project_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80736,(1),null);
return clograms.diagram.tools.set_project_color(db,project_name);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","find-var-references","clograms.events/find-var-references",633295038),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80739){
var vec__80740 = p__80739;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80740,(0),null);
var var_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80740,(1),null);
var node_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80740,(2),null);
return clograms.diagram.tools.find_var_references(db,var_id,node_id);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","find-project-protocols","clograms.events/find-project-protocols",1405010634),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80746){
var vec__80747 = p__80746;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80747,(0),null);
var project_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80747,(1),null);
return clograms.diagram.tools.find_project_protocols(db,project_id);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","find-project-multimethods","clograms.events/find-project-multimethods",41287683),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80751){
var vec__80752 = p__80751;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80752,(0),null);
var project_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80752,(1),null);
return clograms.diagram.tools.find_project_multimethods(db,project_id);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","find-unreferenced-functions","clograms.events/find-unreferenced-functions",833285453),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80764){
var vec__80765 = p__80764;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80765,(0),null);
var project_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80765,(1),null);
return clograms.diagram.tools.find_unreferenced_functions(db,project_id);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","side-bar-browser-back","clograms.events/side-bar-browser-back",-1200415724),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,_){
return clograms.browser.side_bar_browser_back(db);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","side-bar-browser-select-project","clograms.events/side-bar-browser-select-project",-356493262),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80768){
var vec__80769 = p__80768;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80769,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80769,(1),null);
return clograms.db.set_side_bar_search(clograms.browser.side_bar_browser_select_project(db,p),"");
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","side-bar-browser-select-namespace","clograms.events/side-bar-browser-select-namespace",-1818306664),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80772){
var vec__80773 = p__80772;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80773,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80773,(1),null);
return clograms.db.set_side_bar_search(clograms.browser.side_bar_browser_select_namespace(db,ns),"");
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","side-bar-set-search","clograms.events/side-bar-set-search",1891847974),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80776){
var vec__80777 = p__80776;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80777,(0),null);
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80777,(1),null);
return clograms.db.set_side_bar_search(db,query);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","toggle-bottom-bar-collapse","clograms.events/toggle-bottom-bar-collapse",-41142293),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,_){
return clograms.db.toggle_bottom_bar_collapse(db);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","load-diagram","clograms.events/load-diagram",-312441236),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (_,p__80782){
var vec__80783 = p__80782;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80783,(0),null);
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80783,(1),null);
return clograms.external.load_diagram(port);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","diagram-loaded","clograms.events/diagram-loaded",1672036047),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80786){
var vec__80787 = p__80786;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80787,(0),null);
var diagram = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80787,(1),null);
return clograms.external.diagram_loaded(db,diagram);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("clograms.events","save-diagram","clograms.events/save-diagram",1897075158),cljs.core.PersistentVector.EMPTY,(function (cofxs,_){
return clograms.external.save_diagram(cljs.core.select_keys(new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(cofxs),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.re-grams.re-grams","diagram","clograms.re-grams.re-grams/diagram",-337817884),new cljs.core.Keyword("project","colors","project/colors",-160871691),new cljs.core.Keyword("namespace","colors","namespace/colors",-1722531529),new cljs.core.Keyword("node","comments","node/comments",-290384497)], null)),new cljs.core.Keyword(null,"port","port",1534937262).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(cofxs))));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("accordion","activate-item","accordion/activate-item",1128536796),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80791){
var vec__80792 = p__80791;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80792,(0),null);
var accordion_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80792,(1),null);
var item_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80792,(2),null);
return clograms.db.components.accordion_activate_item(db,accordion_id,item_id);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("text-edit-modal","create","text-edit-modal/create",914427838),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (db,p__80795){
var vec__80796 = p__80795;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80796,(0),null);
var event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80796,(1),null);
return clograms.db.components.text_edit_modal_create(db,event);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword("text-edit-modal","set","text-edit-modal/set",1841071128),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.events.inter_check], null),(function (p__80799,p__80800){
var map__80801 = p__80799;
var map__80801__$1 = (((((!((map__80801 == null))))?(((((map__80801.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__80801.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__80801):map__80801);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__80801__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__80802 = p__80800;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80802,(0),null);
var event = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__80802,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),clograms.db.components.text_edit_modal_kill(db),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),event], null);
}));

//# sourceMappingURL=clograms.events.js.map
