goog.provide('clograms.core');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('clograms.events');
goog.require('clograms.fxs');
goog.require('clograms.ui.screens.main');
goog.require('clograms.ui.components.nodes');
goog.require('clograms.ui.components.links');
goog.require('clograms.config');
goog.require('clograms.re_grams.re_grams');
goog.require('cljs.core.async');
goog.require('taoensso.sente');
clograms.core.dev_setup = (function clograms$core$dev_setup(){
if(clograms.config.debug_QMARK_){
cljs.core.enable_console_print_BANG_();

return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["dev mode"], 0));
} else {
return null;
}
});
goog.object.set(cljs.core.IComparable,"string",true);

var G__89223_89227 = cljs.core._compare;
var G__89224_89228 = "string";
var G__89225_89229 = ((function (G__89223_89227,G__89224_89228){
return (function (x,y){
if(typeof y === 'string'){
return x.localeCompare(y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
});})(G__89223_89227,G__89224_89228))
;
goog.object.set(G__89223_89227,G__89224_89228,G__89225_89229);

cljs.core.List.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.List.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if(cljs.core.list_QMARK_(y)){
return cljs.core.compare(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(y));
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
});
clograms.core.mount_root = (function clograms$core$mount_root(){
clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","project-node","clograms/project-node",1660647717),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.project_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","namespace-node","clograms/namespace-node",1210773424),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.namespace_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","function-node","clograms/function-node",-1302488663),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.function_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","var-node","clograms/var-node",-619163284),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.var_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","multimethod-node","clograms/multimethod-node",-930602493),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.multimethod_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","re-frame-subs-node","clograms/re-frame-subs-node",1866541211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.re_frame_subs_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","re-frame-event-node","clograms/re-frame-event-node",-1646191523),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.re_frame_event_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","re-frame-fx-node","clograms/re-frame-fx-node",1612378212),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.re_frame_fx_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","re-frame-cofx-node","clograms/re-frame-cofx-node",1874562903),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.re_frame_cofx_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","spec-node","clograms/spec-node",1994812906),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.spec_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","rectangle-node","clograms/rectangle-node",644490726),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.Keyword(null,"prop-resize?","prop-resize?",-841102461),false,new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.rectangle_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","circle-node","clograms/circle-node",367043488),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.Keyword(null,"svg-url","svg-url",-1025297912),"/svg/circle.svg",new cljs.core.Keyword(null,"prop-resize?","prop-resize?",-841102461),true,new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.svg_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","group-node","clograms/group-node",-848431885),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.Keyword(null,"prop-resize?","prop-resize?",-841102461),false,new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.group_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","user-node","clograms/user-node",-870947588),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.Keyword(null,"svg-url","svg-url",-1025297912),"/svg/man-user.svg",new cljs.core.Keyword(null,"prop-resize?","prop-resize?",-841102461),true,new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.svg_node_component], null));

clograms.re_grams.re_grams.register_node_component_BANG_(new cljs.core.Keyword("clograms","database-node","clograms/database-node",-1497404912),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"svg","svg",856789142),new cljs.core.Keyword(null,"svg-url","svg-url",-1025297912),"/svg/database.svg",new cljs.core.Keyword(null,"prop-resize?","prop-resize?",-841102461),true,new cljs.core.Keyword(null,"comp","comp",1191953630),clograms.ui.components.nodes.svg_node_component], null));

clograms.re_grams.re_grams.register_link_component_BANG_(new cljs.core.Keyword("clograms","straight-line","clograms/straight-line",-1564831106),clograms.ui.components.links.line_link_component);

(re_frame.core.clear_subscription_cache_BANG_.cljs$core$IFn$_invoke$arity$0 ? re_frame.core.clear_subscription_cache_BANG_.cljs$core$IFn$_invoke$arity$0() : re_frame.core.clear_subscription_cache_BANG_.call(null));

return reagent.core.render.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clograms.ui.screens.main.main_panel], null),document.getElementById("app"));
});
clograms.core.init = (function clograms$core$init(){
var G__89226_89230 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clograms.events","initialize-db","clograms.events/initialize-db",-1748376113)], null);
(re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch_sync.cljs$core$IFn$_invoke$arity$1(G__89226_89230) : re_frame.core.dispatch_sync.call(null,G__89226_89230));

clograms.core.dev_setup();

return clograms.core.mount_root();
});
goog.exportSymbol('clograms.core.init', clograms.core.init);

//# sourceMappingURL=clograms.core.js.map
