goog.provide('ajax.xml_http_request');
goog.require('cljs.core');
goog.require('ajax.protocols');
goog.require('goog.string');
ajax.xml_http_request.ready_state = (function ajax$xml_http_request$ready_state(e){
var G__75526 = e.target.readyState;
var fexpr__75525 = new cljs.core.PersistentArrayMap(null, 6, [(0),new cljs.core.Keyword(null,"not-initialized","not-initialized",-1937378906),(1),new cljs.core.Keyword(null,"connection-established","connection-established",-1403749733),(2),new cljs.core.Keyword(null,"request-received","request-received",2110590540),(3),new cljs.core.Keyword(null,"processing-request","processing-request",-264947221),(4),new cljs.core.Keyword(null,"response-ready","response-ready",245208276),new cljs.core.Keyword("cljs.analyzer","analyzed","cljs.analyzer/analyzed",-735094162),true], null);
return (fexpr__75525.cljs$core$IFn$_invoke$arity$1 ? fexpr__75525.cljs$core$IFn$_invoke$arity$1(G__75526) : fexpr__75525.call(null,G__75526));
});
ajax.xml_http_request.append = (function ajax$xml_http_request$append(current,next){
if(cljs.core.truth_(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current),", ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(next)].join('');
} else {
return next;
}
});
ajax.xml_http_request.process_headers = (function ajax$xml_http_request$process_headers(header_str){
if(cljs.core.truth_(header_str)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (headers,header_line){
if(cljs.core.truth_(goog.string.isEmptyOrWhitespace(header_line))){
return headers;
} else {
var key_value = goog.string.splitLimit(header_line,": ",(2));
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(headers,(key_value[(0)]),ajax.xml_http_request.append,(key_value[(1)]));
}
}),cljs.core.PersistentArrayMap.EMPTY,header_str.split("\r\n"));
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
ajax.xml_http_request.xmlhttprequest = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_target_STAR_,"nodejs"))?(function (){var xmlhttprequest = require("xmlhttprequest").XMLHttpRequest;
goog.object.set(global,"XMLHttpRequest",xmlhttprequest);

return xmlhttprequest;
})():window.XMLHttpRequest);
ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxImpl$_js_ajax_request$arity$3 = (function (this$,p__75544,handler){
var map__75545 = p__75544;
var map__75545__$1 = (((((!((map__75545 == null))))?(((((map__75545.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75545.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__75545):map__75545);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75545__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75545__$1,new cljs.core.Keyword(null,"method","method",55703592));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75545__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75545__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75545__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(0));
var with_credentials = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75545__$1,new cljs.core.Keyword(null,"with-credentials","with-credentials",-1163127235),false);
var response_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75545__$1,new cljs.core.Keyword(null,"response-format","response-format",1664465322));
var this$__$1 = this;
this$__$1.withCredentials = with_credentials;

this$__$1.onreadystatechange = ((function (this$__$1,map__75545,map__75545__$1,uri,method,body,headers,timeout,with_credentials,response_format){
return (function (p1__75543_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"response-ready","response-ready",245208276),ajax.xml_http_request.ready_state(p1__75543_SHARP_))){
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(this$__$1) : handler.call(null,this$__$1));
} else {
return null;
}
});})(this$__$1,map__75545,map__75545__$1,uri,method,body,headers,timeout,with_credentials,response_format))
;

this$__$1.open(method,uri,true);

this$__$1.timeout = timeout;

var temp__5818__auto___75591 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(response_format);
if(cljs.core.truth_(temp__5818__auto___75591)){
var response_type_75592 = temp__5818__auto___75591;
this$__$1.responseType = cljs.core.name(response_type_75592);
} else {
}

var seq__75551_75594 = cljs.core.seq(headers);
var chunk__75552_75595 = null;
var count__75553_75596 = (0);
var i__75554_75597 = (0);
while(true){
if((i__75554_75597 < count__75553_75596)){
var vec__75567_75598 = chunk__75552_75595.cljs$core$IIndexed$_nth$arity$2(null,i__75554_75597);
var k_75599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75567_75598,(0),null);
var v_75600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75567_75598,(1),null);
this$__$1.setRequestHeader(k_75599,v_75600);


var G__75601 = seq__75551_75594;
var G__75602 = chunk__75552_75595;
var G__75603 = count__75553_75596;
var G__75604 = (i__75554_75597 + (1));
seq__75551_75594 = G__75601;
chunk__75552_75595 = G__75602;
count__75553_75596 = G__75603;
i__75554_75597 = G__75604;
continue;
} else {
var temp__5818__auto___75605 = cljs.core.seq(seq__75551_75594);
if(temp__5818__auto___75605){
var seq__75551_75606__$1 = temp__5818__auto___75605;
if(cljs.core.chunked_seq_QMARK_(seq__75551_75606__$1)){
var c__4550__auto___75607 = cljs.core.chunk_first(seq__75551_75606__$1);
var G__75608 = cljs.core.chunk_rest(seq__75551_75606__$1);
var G__75609 = c__4550__auto___75607;
var G__75610 = cljs.core.count(c__4550__auto___75607);
var G__75611 = (0);
seq__75551_75594 = G__75608;
chunk__75552_75595 = G__75609;
count__75553_75596 = G__75610;
i__75554_75597 = G__75611;
continue;
} else {
var vec__75574_75612 = cljs.core.first(seq__75551_75606__$1);
var k_75613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75574_75612,(0),null);
var v_75614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75574_75612,(1),null);
this$__$1.setRequestHeader(k_75613,v_75614);


var G__75615 = cljs.core.next(seq__75551_75606__$1);
var G__75616 = null;
var G__75617 = (0);
var G__75618 = (0);
seq__75551_75594 = G__75615;
chunk__75552_75595 = G__75616;
count__75553_75596 = G__75617;
i__75554_75597 = G__75618;
continue;
}
} else {
}
}
break;
}

this$__$1.send((function (){var or__4131__auto__ = body;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})());

return this$__$1;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxRequest$_abort$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.abort();
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$ = cljs.core.PROTOCOL_SENTINEL;

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_body$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.response;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.status;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_status_text$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.statusText;
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_all_headers$arity$1 = (function (this$){
var this$__$1 = this;
return ajax.xml_http_request.process_headers(this$__$1.getAllResponseHeaders());
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_get_response_header$arity$2 = (function (this$,header){
var this$__$1 = this;
return this$__$1.getResponseHeader(header);
});

ajax.xml_http_request.xmlhttprequest.prototype.ajax$protocols$AjaxResponse$_was_aborted$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),this$__$1.readyState);
});

//# sourceMappingURL=ajax.xml_http_request.js.map
