(ns leiningen.new.discord-http-bot
  (:require [leiningen.new.templates :as tmpl]
            [leiningen.core.main :as main]))

(def render (tmpl/renderer "discord_http_bot"))

(def clj-kondo-base-url "https://raw.githubusercontent.com/JohnnyJayJay/slash/main/.clj-kondo/")

(defn discord-http-bot
  "FIXME: write documentation"
  [name]
  (let [data {:name name
              :year (tmpl/year)
              :simple-name (tmpl/project-name name)
              :ns-name (tmpl/sanitize-ns name)
              :sanitized (tmpl/name-to-path name)}
        _ (main/info "Fetching latest clj-kondo config...")
        config (slurp (str clj-kondo-base-url "config.edn"))
        hook (slurp (str clj-kondo-base-url "hooks/slash.clj"))]
    (main/info "Generating fresh 'lein new' discord-http-bot project.")
    (tmpl/->files data
                  ["project.clj" (render "project.clj" data)]
                  ["src/{{sanitized}}/handler.clj" (render "handler.clj" data)]
                  ["src/{{sanitized}}/command.clj" (render "command.clj" data)]
                  [".gitignore" (render "gitignore" data)]
                  ["LICENSE" (render "LICENSE" data)]
                  ["Dockerfile" (render "Dockerfile" data)]
                  ["docker-compose.yml" (render "docker-compose.yml" data)]
                  ["config/config.edn" (render "config.edn" data)]
                  [".clj-kondo/config.edn" config]
                  [".clj-kondo/hooks/slash.clj" hook])))
