/*
 * Decompiled with CFR 0.152.
 */
package jnr.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.SpawnFileAction;
import jnr.process.Process;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBuilder {
    private List<String> command;
    private static final POSIX posix = POSIXFactory.getPOSIX();

    public ProcessBuilder(List<String> command) {
        this.command = new ArrayList<String>(command);
    }

    public ProcessBuilder(String ... command) {
        this.command = Arrays.asList(command);
    }

    public List<String> command() {
        return new ArrayList<String>(this.command);
    }

    public ProcessBuilder command(List<String> command) {
        this.command = new ArrayList<String>(command);
        return this;
    }

    public ProcessBuilder command(String ... command) {
        this.command = Arrays.asList(command);
        return this;
    }

    public Process start() {
        int[] stdin = new int[2];
        int[] stdout = new int[2];
        int[] stderr = new int[2];
        posix.pipe(stdin);
        posix.pipe(stdout);
        posix.pipe(stderr);
        ArrayList<String> envp = new ArrayList<String>();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            envp.add(entry.getKey() + "=" + entry.getValue());
        }
        long pid = posix.posix_spawnp(this.command.get(0), Arrays.asList(SpawnFileAction.dup((int)stdin[0], (int)0), SpawnFileAction.dup((int)stdout[1], (int)1), SpawnFileAction.dup((int)stderr[1], (int)2), SpawnFileAction.close((int)stdin[1]), SpawnFileAction.close((int)stdout[0]), SpawnFileAction.close((int)stderr[0])), this.command, envp);
        posix.close(stdin[0]);
        posix.close(stdout[1]);
        posix.close(stderr[1]);
        return new Process(posix, pid, stdin[1], stdout[0], stderr[0]);
    }
}

